/*
 * Decompiled with CFR 0.152.
 */
package jp.open.cloud.studio.rcp.image;

import com.xerox.amazonws.ec2.GroupDescription;
import com.xerox.amazonws.ec2.ImageDescription;
import com.xerox.amazonws.ec2.KeyPairInfo;
import java.util.List;
import jp.open.cloud.studio.common.ConnectionConfig;
import jp.open.cloud.studio.common.ConnectionException;
import jp.open.cloud.studio.common.TypicaWrapper;
import jp.open.cloud.studio.rcp.cloud.model.CloudCanvas;
import jp.open.cloud.studio.rcp.connector.CloudConnector;
import jp.open.cloud.studio.rcp.image.LaunchWizard;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class OpenLaunchDialogJob
extends Job {
    private final ConnectionConfig config;
    private final ImageDescription img;
    private final CloudCanvas canvas;

    public OpenLaunchDialogJob(ImageDescription img, ConnectionConfig config, CloudCanvas canvas) {
        super("\u8d77\u52d5\u30c0\u30a4\u30a2\u30ed\u30b0\u306e\u6e96\u5099...");
        this.img = img;
        this.config = config;
        this.canvas = canvas;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            TypicaWrapper wrapper = new TypicaWrapper();
            List<KeyPairInfo> keyPairs = wrapper.describeKeyPair(this.config);
            List<GroupDescription> groups = wrapper.describeGroup(this.config);
            final LaunchWizard wizard = new LaunchWizard(this.config);
            wizard.setImageDescription(this.img);
            wizard.setKeypairs(keyPairs);
            wizard.setGroups(groups);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                    if (dialog.open() == 0) {
                        CloudConnector connector = new CloudConnector(OpenLaunchDialogJob.this.canvas, OpenLaunchDialogJob.this.config);
                        connector.schedule();
                    }
                }
            });
        }
        catch (ConnectionException e) {
            e.printStackTrace();
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }
}

