/*
 * Decompiled with CFR 0.152.
 */
package jp.open.cloud.studio.rcp.image;

import com.xerox.amazonws.ec2.ImageDescription;
import java.util.ArrayList;
import java.util.List;
import jp.open.cloud.studio.common.ConnectionException;
import jp.open.cloud.studio.common.TypicaWrapper;
import jp.open.cloud.studio.rcp.Activator;
import jp.open.cloud.studio.rcp.profile.ProfileModel;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class UpdateImageJob
extends Job {
    private final ProfileModel model;
    private final IPropertyChangeListener listener;

    public UpdateImageJob(ProfileModel model, IPropertyChangeListener listener) {
        super(String.valueOf(model.getEc2Url()) + "\u304b\u3089\u30a4\u30e1\u30fc\u30b8\u60c5\u5831\u306e\u53d6\u5f97...");
        this.model = model;
        this.listener = listener;
    }

    protected IStatus run(IProgressMonitor monitor) {
        TypicaWrapper wrapper = new TypicaWrapper();
        try {
            List<ImageDescription> images = wrapper.describeImages(this.model.toEc2Config());
            this.listener.propertyChange(new PropertyChangeEvent((Object)this, "images", null, images));
        }
        catch (ConnectionException e) {
            Activator.warn("\u30a4\u30e1\u30fc\u30b8\u60c5\u5831\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            this.listener.propertyChange(new PropertyChangeEvent((Object)this, "images", null, new ArrayList()));
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }
}

