/*
 * Decompiled with CFR 0.152.
 */
package jp.open.cloud.studio.rcp.instance;

import com.xerox.amazonws.ec2.ImageDescription;
import com.xerox.amazonws.ec2.ReservationDescription;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import jp.open.cloud.studio.common.ConnectionException;
import jp.open.cloud.studio.common.TypicaWrapper;
import jp.open.cloud.studio.rcp.Activator;
import jp.open.cloud.studio.rcp.action.RebootInstanceAction;
import jp.open.cloud.studio.rcp.action.StartInstanceAction;
import jp.open.cloud.studio.rcp.action.StopInstanceAction;
import jp.open.cloud.studio.rcp.action.TerminateInstanceAction;
import jp.open.cloud.studio.rcp.cloud.model.InstanceElement;
import jp.open.cloud.studio.rcp.elasticip.ElasticIpEditorInput;
import jp.open.cloud.studio.rcp.image.editor.ImageEditorInput;
import jp.open.cloud.studio.rcp.profile.ProfileModel;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class InstancePage
extends FormPage
implements PropertyChangeListener {
    private ReservationDescription description;
    private InstanceElement element;
    private ReservationDescription.Instance inst;
    private TerminateInstanceAction terminateAction;
    private StartInstanceAction startAction;
    private StopInstanceAction pauseAction;
    private RebootInstanceAction rebootAction;
    private Label status;
    private Text publicDns;
    private Text publicIp;
    private Text privateDns;
    private Text privateIp;

    public void setDescription(ReservationDescription description) {
        this.description = description;
    }

    public void setElement(InstanceElement element) {
        this.element = element;
    }

    public InstancePage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText("Instance");
        form.setImage(Activator.getImage("computer"));
        form.setBackgroundImage(Activator.getImage("background"));
        form.getBody().setLayout((Layout)new GridLayout());
        IToolBarManager manager = form.getToolBarManager();
        this.fillToolbar(manager);
        manager.update(true);
        List instances = this.description.getInstances();
        for (ReservationDescription.Instance instance : instances) {
            if (!instance.getInstanceId().equals(this.element.getId())) continue;
            this.inst = instance;
        }
        if (this.inst == null) {
            toolkit.createLabel(form.getBody(), "\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9ID\u304c\u4e0d\u6b63\u306a\u305f\u3081\u3001\u60c5\u5831\u3092\u8868\u793a\u3067\u304d\u307e\u305b\u3093");
            return;
        }
        Section stateSection = toolkit.createSection(form.getBody(), 450);
        stateSection.setText("\u30b9\u30c6\u30fc\u30bf\u30b9\u60c5\u5831");
        stateSection.setDescription("\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u306e\u8d77\u52d5\u505c\u6b62\u306e\u72b6\u614b\u3084\u5909\u66f4\u30a2\u30af\u30b7\u30e7\u30f3\u3067\u3059\u3002");
        stateSection.setLayoutData((Object)new GridData(768));
        Composite stateComposite = toolkit.createComposite((Composite)stateSection);
        stateComposite.setLayout((Layout)new GridLayout(2, false));
        toolkit.createLabel(stateComposite, "\u30b9\u30c6\u30fc\u30bf\u30b9 :");
        this.status = toolkit.createLabel(stateComposite, this.inst.getState());
        this.status.setLayoutData((Object)new GridData(768));
        Group composite = new Group(stateComposite, 0);
        toolkit.adapt((Composite)composite);
        composite.setText("\u30b9\u30c6\u30fc\u30bf\u30b9\u5909\u66f4");
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        composite.setLayoutData((Object)data);
        composite.setLayout((Layout)new RowLayout());
        this.createButtons(toolkit, composite);
        stateSection.setClient((Control)stateComposite);
        Section basicSection = toolkit.createSection(form.getBody(), 450);
        basicSection.setText("\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u60c5\u5831");
        basicSection.setDescription("\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9ID\u3084\u30a4\u30e1\u30fc\u30b8ID\u306a\u3069\u306e\u57fa\u672c\u60c5\u5831\u3067\u3059\u3002");
        basicSection.setLayoutData((Object)new GridData(768));
        Composite basicComposite = toolkit.createComposite((Composite)basicSection);
        basicComposite.setLayout((Layout)new GridLayout(2, false));
        toolkit.createLabel(basicComposite, "Reservation ID :");
        Label label = toolkit.createLabel(basicComposite, this.description.getReservationId());
        label.setLayoutData((Object)new GridData(768));
        toolkit.createLabel(basicComposite, "\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9ID :");
        label = toolkit.createLabel(basicComposite, this.inst.getInstanceId());
        label.setLayoutData((Object)new GridData(768));
        toolkit.createLabel(basicComposite, "\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u30bf\u30a4\u30d7 :");
        label = toolkit.createLabel(basicComposite, this.inst.getInstanceType().name());
        label.setLayoutData((Object)new GridData(768));
        toolkit.createLabel(basicComposite, "\u30a4\u30e1\u30fc\u30b8ID :");
        Hyperlink imageLink = toolkit.createHyperlink(basicComposite, this.inst.getImageId(), 0);
        imageLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                ProfileModel model = (ProfileModel)page.getActiveEditor().getAdapter(ProfileModel.class);
                try {
                    TypicaWrapper wrapper = new TypicaWrapper();
                    ImageDescription image = wrapper.getImage(model.toEc2Config(), InstancePage.this.inst.getImageId());
                    ImageEditorInput input = new ImageEditorInput(model, image);
                    page.openEditor((IEditorInput)input, "jp.open.cloud.studio.rcp.image.editor");
                }
                catch (ConnectionException e1) {
                    e1.printStackTrace();
                }
                catch (PartInitException e2) {
                    e2.printStackTrace();
                }
            }
        });
        toolkit.createLabel(basicComposite, "\u8d77\u52d5\u6642\u9593:");
        if (this.inst.getLaunchTime() != null) {
            DateFormat format = SimpleDateFormat.getDateTimeInstance();
            label = toolkit.createLabel(basicComposite, format.format(this.inst.getLaunchTime().getTime()));
        } else {
            label = toolkit.createLabel(basicComposite, "");
        }
        label.setLayoutData((Object)new GridData(768));
        basicSection.setClient((Control)basicComposite);
        Section adddressSection = toolkit.createSection(form.getBody(), 450);
        adddressSection.setText("\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u60c5\u5831");
        adddressSection.setDescription("\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u306b\u30a2\u30af\u30bb\u30b9\u3059\u308b\u305f\u3081\u306e\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u60c5\u5831\u3067\u3059\u3002");
        adddressSection.setLayoutData((Object)new GridData(768));
        Composite addressComposite = toolkit.createComposite((Composite)adddressSection);
        addressComposite.setLayout((Layout)new GridLayout(2, false));
        toolkit.createLabel(addressComposite, "\u30d1\u30d6\u30ea\u30c3\u30afDNS :");
        this.publicDns = toolkit.createText(addressComposite, this.inst.getDnsName(), 8);
        this.publicDns.setLayoutData((Object)new GridData(768));
        toolkit.createLabel(addressComposite, "\u30d1\u30d6\u30ea\u30c3\u30afIP :");
        this.publicIp = toolkit.createText(addressComposite, this.inst.getIpAddress(), 8);
        this.publicIp.setLayoutData((Object)new GridData(768));
        toolkit.createLabel(addressComposite, "\u30d7\u30e9\u30a4\u30d9\u30fc\u30c8DNS :");
        this.privateDns = toolkit.createText(addressComposite, this.inst.getPrivateDnsName(), 8);
        this.privateDns.setLayoutData((Object)new GridData(768));
        toolkit.createLabel(addressComposite, "\u30d7\u30e9\u30a4\u30d9\u30fc\u30c8IP :");
        this.privateIp = toolkit.createText(addressComposite, this.inst.getPrivateIpAddress(), 8);
        this.privateIp.setLayoutData((Object)new GridData(768));
        Hyperlink addressLink = toolkit.createHyperlink(addressComposite, "\u30d1\u30d6\u30ea\u30c3\u30af\u30a2\u30c9\u30ec\u30b9\u3092\u7de8\u96c6\u3059\u308b...", 0);
        adddressSection.setClient((Control)addressComposite);
        addressLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                ProfileModel model = (ProfileModel)page.getActiveEditor().getAdapter(ProfileModel.class);
                try {
                    ElasticIpEditorInput input = new ElasticIpEditorInput(model);
                    page.openEditor((IEditorInput)input, "jp.open.cloud.studio.rcp.elasticip.editor");
                }
                catch (PartInitException e2) {
                    e2.printStackTrace();
                }
            }
        });
        this.element.addListener(this);
        this.changeButtonStatus();
        form.pack();
    }

    public void dispose() {
        super.dispose();
        this.element.removeListener(this);
    }

    private void createButtons(FormToolkit toolkit, Group composite) {
        Button startButton = toolkit.createButton((Composite)composite, "\u958b\u59cb", 0);
        startButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstancePage.this.startAction.run();
            }
        });
        Button pauseButton = toolkit.createButton((Composite)composite, "\u4e00\u6642\u505c\u6b62", 0);
        pauseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstancePage.this.pauseAction.run();
            }
        });
        Button stopButton = toolkit.createButton((Composite)composite, "\u505c\u6b62", 0);
        stopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstancePage.this.terminateAction.run();
            }
        });
        Button rebootButton = toolkit.createButton((Composite)composite, "\u518d\u8d77\u52d5", 0);
        rebootButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstancePage.this.rebootAction.run();
            }
        });
    }

    private void fillToolbar(IToolBarManager manager) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ProfileModel model = (ProfileModel)page.getActiveEditor().getAdapter(ProfileModel.class);
        this.terminateAction = new TerminateInstanceAction(model.toEc2Config(), this.element.getId());
        this.startAction = new StartInstanceAction(model.toEc2Config(), this.element.getId());
        this.pauseAction = new StopInstanceAction(model.toEc2Config(), this.element.getId());
        this.rebootAction = new RebootInstanceAction(model.toEc2Config(), this.element.getId());
        manager.add((IAction)this.startAction);
        manager.add((IAction)this.pauseAction);
        manager.add((IAction)this.terminateAction);
        manager.add((IAction)this.rebootAction);
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        this.status.setText(this.element.getState());
        this.privateDns.setText(this.element.getPrivateDns());
        this.publicDns.setText(this.element.getPublicDns());
        this.privateIp.setText(this.element.getPrivateIp());
        this.publicIp.setText(this.element.getPublicIp());
        this.changeButtonStatus();
    }

    private void changeButtonStatus() {
        if ("terminated".equals(this.element.getState())) {
            this.startAction.setEnabled(false);
            this.pauseAction.setEnabled(false);
            this.terminateAction.setEnabled(false);
            this.rebootAction.setEnabled(false);
        } else if ("shutting-down".equals(this.element.getState())) {
            this.startAction.setEnabled(false);
            this.pauseAction.setEnabled(false);
            this.terminateAction.setEnabled(false);
            this.rebootAction.setEnabled(false);
        } else {
            this.startAction.setEnabled(true);
            this.pauseAction.setEnabled(true);
            this.terminateAction.setEnabled(true);
            this.rebootAction.setEnabled(true);
        }
    }
}

