/*
 * Decompiled with CFR 0.152.
 */
package jp.open.cloud.studio.rcp.profile;

import java.net.MalformedURLException;
import java.net.URL;
import jp.open.cloud.studio.common.ConnectionConfig;
import jp.open.cloud.studio.rcp.Activator;
import jp.open.cloud.studio.rcp.model.AbstractModel;
import jp.open.cloud.studio.rcp.model.IDisplay;
import jp.open.cloud.studio.rcp.profile.ProfileModelRoot;
import net.arnx.jsonic.JSONHint;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class ProfileModel
extends AbstractModel
implements IDisplay {
    private String name;
    private String userNumber;
    private String accessKey;
    private String secretKey;
    private String x509cert;
    private String x509pk;
    private String cloudCert;
    private String ec2Url;
    private String s3Url;
    @JSONHint(ignore=true)
    private ProfileModelRoot root;

    @JSONHint(ignore=true)
    public ProfileModelRoot getRoot() {
        return this.root;
    }

    @JSONHint(ignore=true)
    public void setRoot(ProfileModelRoot root) {
        this.root = root;
    }

    public String getEc2Url() {
        return this.ec2Url;
    }

    public void setEc2Url(String ec2Url) {
        this.ec2Url = ec2Url;
    }

    public String getS3Url() {
        return this.s3Url;
    }

    public void setS3Url(String s3Url) {
        this.s3Url = s3Url;
    }

    public String getX509cert() {
        return this.x509cert;
    }

    public void setX509cert(String x509cert) {
        this.x509cert = x509cert;
    }

    public String getX509pk() {
        return this.x509pk;
    }

    public void setX509pk(String x509pk) {
        this.x509pk = x509pk;
    }

    public String getCloudCert() {
        return this.cloudCert;
    }

    public void setCloudCert(String cloudSert) {
        this.cloudCert = cloudSert;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getUserNumber() {
        return this.userNumber;
    }

    public void setUserNumber(String userNumber) {
        this.userNumber = userNumber;
    }

    @Override
    public String getText() {
        return this.name;
    }

    @Override
    public Image getImage() {
        return Activator.getImage("profile");
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return Activator.getImageDescriptor("profile");
    }

    @Override
    public void refresh() {
        super.refresh();
        this.root.refresh();
    }

    public ConnectionConfig toEc2Config() {
        ConnectionConfig config = new ConnectionConfig();
        config.setAccessKey(this.accessKey);
        config.setSecretKey(this.secretKey);
        config.setSignatureVersion(1);
        try {
            URL url = new URL(this.ec2Url);
            config.setHost(url.getHost());
            config.setPort(url.getPort());
            config.setResourcePrefix(url.getPath());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return config;
    }
}

