/*
 * Decompiled with CFR 0.152.
 */
package jp.open.cloud.studio.rcp.profile;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import jp.open.cloud.studio.rcp.Activator;
import jp.open.cloud.studio.rcp.RootModel;
import jp.open.cloud.studio.rcp.action.OpenEditorAction;
import jp.open.cloud.studio.rcp.model.StandardLabelProvider;
import jp.open.cloud.studio.rcp.model.StandardTreeContentProvider;
import jp.open.cloud.studio.rcp.profile.AddProfileAction;
import jp.open.cloud.studio.rcp.profile.DeleteProfileAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class ProfileView
extends ViewPart
implements PropertyChangeListener,
ISelectionChangedListener {
    private TreeViewer viewer;
    private AddProfileAction addAction;
    private DrillDownAdapter drillDownAdapter;
    private DeleteProfileAction deleteAction;
    private OpenEditorAction openProfileEditor;
    private OpenEditorAction openCloudEditor;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent);
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        this.viewer.setContentProvider((IContentProvider)new StandardTreeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new StandardLabelProvider());
        RootModel model = Activator.getDefault().getRootModel();
        this.viewer.setInput((Object)model.getProfileRoot());
        model.getProfileRoot().addListener(this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.makeAction();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.addAction);
        manager.add((IAction)this.deleteAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.addAction);
        manager.add((IAction)this.deleteAction);
        manager.add((IContributionItem)new Separator());
    }

    private void makeAction() {
        this.addAction = new AddProfileAction(Activator.getDefault().getRootModel().getProfileRoot());
        this.deleteAction = new DeleteProfileAction();
        this.deleteAction.init(this.getSite().getWorkbenchWindow());
        this.openProfileEditor = new OpenEditorAction("\u30d7\u30ed\u30d5\u30a1\u30a4\u30eb", "jp.open.cloud.studio.rcp.profile.editor");
        this.openCloudEditor = new OpenEditorAction("\u30af\u30e9\u30a6\u30c9", "jp.open.cloud.studio.rcp.editor.cloudeditor");
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.getViewSite().getActionBars().setGlobalActionHandler("profile.delete", (IAction)this.deleteAction);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ProfileView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        MenuManager openMenu = new MenuManager("\u958b\u304f");
        openMenu.add((IAction)this.openCloudEditor);
        openMenu.add((IAction)this.openProfileEditor);
        manager.add((IContributionItem)openMenu);
        manager.add((IAction)this.addAction);
        manager.add((IAction)this.deleteAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (ProfileView.this.openCloudEditor.isEnabled()) {
                    ProfileView.this.openCloudEditor.run();
                }
            }
        });
    }

    public void setFocus() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ProfileView.this.viewer.refresh();
            }
        });
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.deleteAction.selectionChanged(event);
        this.openCloudEditor.selectionChanged(event);
        this.openProfileEditor.selectionChanged(event);
        this.getViewSite().getActionBars().getToolBarManager().update(true);
    }
}

