/*
 * Decompiled with CFR 0.152.
 */
package jp.open.cloud.studio.common;

import com.xerox.amazonws.ec2.AddressInfo;
import com.xerox.amazonws.ec2.DescribeImageAttributeResult;
import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.GroupDescription;
import com.xerox.amazonws.ec2.ImageAttribute;
import com.xerox.amazonws.ec2.ImageDescription;
import com.xerox.amazonws.ec2.Jec2;
import com.xerox.amazonws.ec2.KeyPairInfo;
import com.xerox.amazonws.ec2.LaunchConfiguration;
import com.xerox.amazonws.ec2.ReservationDescription;
import com.xerox.amazonws.ec2.VolumeInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.open.cloud.studio.common.ConnectionConfig;
import jp.open.cloud.studio.common.ConnectionException;

public class TypicaWrapper {
    public List<GroupDescription> describeGroup(ConnectionConfig config) throws ConnectionException {
        Jec2 jec2 = this.createJec2(config);
        try {
            List groups = jec2.describeSecurityGroups(new ArrayList());
            return groups;
        }
        catch (EC2Exception e) {
            throw new ConnectionException(e);
        }
    }

    private Jec2 createJec2(ConnectionConfig config) throws ConnectionException {
        if ("".equals(config.getAccessKey()) || "".equals(config.getSecretKey())) {
            throw new ConnectionException("AccessKey, SecretKey are not specified.");
        }
        Jec2 jec2 = new Jec2(config.getAccessKey(), config.getSecretKey(), false, config.getHost(), config.getPort());
        jec2.setResourcePrefix(config.getResourcePrefix());
        jec2.setSignatureVersion(config.getSignatureVersion());
        return jec2;
    }

    public List<ReservationDescription> describeInstance(ConnectionConfig config) throws ConnectionException {
        Jec2 jec2 = this.createJec2(config);
        try {
            List reserves = jec2.describeInstances(new ArrayList());
            return reserves;
        }
        catch (EC2Exception e) {
            throw new ConnectionException(e);
        }
    }

    public ReservationDescription getInstance(ConnectionConfig config, String instanceId) throws ConnectionException {
        Jec2 jec2 = this.createJec2(config);
        try {
            ArrayList<String> request = new ArrayList<String>();
            request.add(instanceId);
            List reserves = jec2.describeInstances(request);
            Iterator iterator = reserves.iterator();
            if (iterator.hasNext()) {
                ReservationDescription reserv = (ReservationDescription)iterator.next();
                return reserv;
            }
            throw new ConnectionException("Unable to find specified instance");
        }
        catch (EC2Exception e) {
            throw new ConnectionException(e);
        }
    }

    public List<AddressInfo> describeAddress(ConnectionConfig config) throws ConnectionException {
        Jec2 jec2 = this.createJec2(config);
        try {
            List addresses = jec2.describeAddresses(new ArrayList());
            return addresses;
        }
        catch (EC2Exception e) {
            throw new ConnectionException(e);
        }
    }

    public String allocateAddress(ConnectionConfig config) throws ConnectionException {
        Jec2 jec2 = this.createJec2(config);
        try {
            String addresses = jec2.allocateAddress();
            return addresses;
        }
        catch (EC2Exception e) {
            throw new ConnectionException(e);
        }
    }

    public void releaseAddress(ConnectionConfig config, String publicIp) throws ConnectionException {
        Jec2 jec2 = this.createJec2(config);
        try {
            jec2.releaseAddress(publicIp);
        }
        catch (EC2Exception e) {
            throw new ConnectionException(e);
        }
    }

    public List<VolumeInfo> describeVolume(ConnectionConfig config) throws ConnectionException {
        Jec2 jec2 = this.createJec2(config);
        try {
            List volumes = jec2.describeVolumes(new ArrayList());
            return volumes;
        }
        catch (EC2Exception e) {
            throw new ConnectionException(e);
        }
    }

    public List<ImageDescription> describeImages(ConnectionConfig config) throws ConnectionException {
        Jec2 jec2 = this.createJec2(config);
        try {
            List images = jec2.describeImages(new ArrayList());
            return images;
        }
        catch (EC2Exception e) {
            throw new ConnectionException(e);
        }
    }

    public ImageDescription getImage(ConnectionConfig config, String imageId) throws ConnectionException {
        Jec2 jec2 = this.createJec2(config);
        try {
            ArrayList<String> request = new ArrayList<String>();
            request.add(imageId);
            List images = jec2.describeImages(request);
            Iterator iterator = images.iterator();
            if (iterator.hasNext()) {
                ImageDescription img = (ImageDescription)iterator.next();
                return img;
            }
            throw new ConnectionException("Unable to find specifed image");
        }
        catch (EC2Exception e) {
            throw new ConnectionException(e);
        }
    }

    public DescribeImageAttributeResult describeLaunchPermition(ConnectionConfig config, String imageId) throws ConnectionException {
        Jec2 jec2 = this.createJec2(config);
        try {
            DescribeImageAttributeResult attr = jec2.describeImageAttribute(imageId, ImageAttribute.ImageAttributeType.launchPermission);
            return attr;
        }
        catch (EC2Exception e) {
            throw new ConnectionException(e);
        }
    }

    public List<KeyPairInfo> describeKeyPair(ConnectionConfig config) throws ConnectionException {
        Jec2 jec2 = this.createJec2(config);
        try {
            List keypairs = jec2.describeKeyPairs(new ArrayList());
            return keypairs;
        }
        catch (EC2Exception e) {
            throw new ConnectionException(e);
        }
    }

    public void runInstance(ConnectionConfig config, LaunchConfiguration lc) throws ConnectionException {
        Jec2 jec2 = this.createJec2(config);
        try {
            jec2.runInstances(lc);
        }
        catch (EC2Exception e) {
            throw new ConnectionException(e);
        }
    }

    public void terminateInstance(ConnectionConfig config, String instanceId) throws ConnectionException {
        Jec2 jec2 = this.createJec2(config);
        try {
            ArrayList<String> request = new ArrayList<String>();
            request.add(instanceId);
            jec2.terminateInstances(request);
        }
        catch (EC2Exception e) {
            throw new ConnectionException(e);
        }
    }

    public void stopInstance(ConnectionConfig config, String instanceId) throws ConnectionException {
        Jec2 jec2 = this.createJec2(config);
        try {
            ArrayList<String> request = new ArrayList<String>();
            request.add(instanceId);
            jec2.stopInstances(request, true);
        }
        catch (EC2Exception e) {
            throw new ConnectionException(e);
        }
    }

    public void startInstance(ConnectionConfig config, String instanceId) throws ConnectionException {
        Jec2 jec2 = this.createJec2(config);
        try {
            ArrayList<String> request = new ArrayList<String>();
            request.add(instanceId);
            jec2.startInstances(request);
        }
        catch (EC2Exception e) {
            throw new ConnectionException(e);
        }
    }

    public void rebootInstance(ConnectionConfig config, String instanceId) throws ConnectionException {
        Jec2 jec2 = this.createJec2(config);
        try {
            ArrayList<String> request = new ArrayList<String>();
            request.add(instanceId);
            jec2.rebootInstances(request);
        }
        catch (EC2Exception e) {
            throw new ConnectionException(e);
        }
    }
}

