
//
//  APE^O擾
//
//  Written by Otachan
//  http://otachan.com/
//

#include "stdafx.h"

#include "wa_ipc.h"

#include "CommonFunc.h"

#include "in_mpg123.h"

#include "TagInfo.h"

bool
Tag::GetTitleFromAPE(_TagInfo* TagInfo, _ReplayGainInfo* ReplayGainInfo, const WCHAR* FileName)
{
	::SetLastError(NO_ERROR);

	HANDLE	hF = ::CreateFile(
							TagInfo ? TagInfo->FileName : FileName,
							GENERIC_READ,
							FILE_SHARE_READ,
							NULL,
							OPEN_EXISTING,
							FILE_FLAG_RANDOM_ACCESS,
							NULL);

	if(::GetLastError() != NO_ERROR) return false;

	bool	RetCode;
	bool	FindReplayGainInfo;
	DWORD	FileSize = ::GetFileSize(hF, NULL);

	if(FileSize >= sizeof(APE_TAG_FOOTER)) {
		APE_TAG_FOOTER	APETagFooter;
		DWORD	ReadByte;

		memset(APETagFooter.m_cID, '\0', 8);
		::SetFilePointer(hF, FileSize - sizeof APETagFooter, NULL, FILE_BEGIN);
		::ReadFile(hF, &APETagFooter, sizeof APETagFooter, &ReadByte, NULL);

		bool	FindTag;

		if(memcmp(APETagFooter.m_cID, "APETAGEX", 8) == 0) {
			FindTag = true;
		} else if(FileSize >= (sizeof(APE_TAG_FOOTER) + 128)) {
			FileSize -= 128;

			memset(APETagFooter.m_cID, '\0', 8);
			::SetFilePointer(hF, FileSize - sizeof APETagFooter, NULL, FILE_BEGIN);
			::ReadFile(hF, &APETagFooter, sizeof APETagFooter, &ReadByte, NULL);

			if(memcmp(APETagFooter.m_cID, "APETAGEX", 8) == 0) {
				FindTag = true;
			} else if(FileSize >= (sizeof(APE_TAG_FOOTER) + 15)) {
				FileSize -= 15;

				char	Lyrics200Tag[15];

				memset(Lyrics200Tag, '\0', 15);
				::SetFilePointer(hF, FileSize, NULL, FILE_BEGIN);
				::ReadFile(hF, Lyrics200Tag, sizeof Lyrics200Tag, &ReadByte, NULL);

				if(memcmp(Lyrics200Tag + 6, "LYRICS200", 9) == 0) {
					*(Lyrics200Tag + 6) = '\0';

					const UINT	Lyrics200Size = atoi(Lyrics200Tag);

					if(FileSize >= (sizeof(APE_TAG_FOOTER) + Lyrics200Size)) {
						FileSize -= Lyrics200Size;

						memset(APETagFooter.m_cID, '\0', 8);
						::SetFilePointer(hF, FileSize - sizeof APETagFooter, NULL, FILE_BEGIN);
						::ReadFile(hF, &APETagFooter, sizeof APETagFooter, &ReadByte, NULL);

						FindTag = memcmp(APETagFooter.m_cID, "APETAGEX", 8) == 0;
					} else {
						FindTag = false;
					}
				} else {
					FindTag = false;
				}
			} else {
				FindTag = false;
			}
		} else {
			FindTag = false;
		}

		UINT	TagSize;

		if(FindTag && (FileSize >= (TagSize = APETagFooter.m_nSize - sizeof APETagFooter))) {
			const UINT	TagVersion = APETagFooter.m_nVersion;
			unsigned char*	TagData = new unsigned char[TagSize];

			::SetFilePointer(hF, FileSize - sizeof APETagFooter - TagSize, NULL, FILE_BEGIN);
			::ReadFile(hF, TagData, TagSize, &ReadByte, NULL);

			::CloseHandle(hF);

			bool	TitleSc = false;
			bool	ArtistSc = false;
			bool	CommentSc = false;
			bool	AlbumSc = false;
			bool	YearSc = false;
			bool	GenreSc = false;
			bool	TrackSc = false;
			bool	ComposerSc = false;
			bool	OrgArtistSc = false;
			bool	CopyrightSc = false;
			bool	EncoderSc = false;
			bool	ReplayGainTrackGainSc = false;
			bool	ReplayGainTrackPeakSc = false;
			bool	ReplayGainAlbumGainSc = false;
			bool	ReplayGainAlbumPeakSc = false;

			unsigned char*	TagDataPnt = TagData;
			UINT	MaxField = APETagFooter.m_nFields;

			for(UINT Idx = 0; Idx < MaxField; Idx++) {
				const UINT	FieldDataSize = *reinterpret_cast<DWORD*>(TagDataPnt);
				const bool	TagUTF8 = (TagVersion >= 2000) &&
										((*(TagDataPnt + 4) & TAG_FIELD_FLAG_DATA_TYPE_BINARY) == 0);

				TagDataPnt += 8;

				char*	FieldName = reinterpret_cast<char*>(TagDataPnt);

				TagDataPnt += strlen(FieldName) + 1;

				int		ReplayGainFieldName;
				WCHAR	ReplayGainBuff[MAX_MUSICTEXT];
				WCHAR*	Buff;

				if(TagInfo) {
					if((TitleSc == false) && _stricmp(FieldName, APE_TAG_FIELD_TITLE) == 0) {
						Buff = TagInfo->Title;
						TitleSc = true;
					} else if((ArtistSc == false) && _stricmp(FieldName, APE_TAG_FIELD_ARTIST) == 0) {
						Buff = TagInfo->Artist;
						ArtistSc = true;
					} else if((CommentSc == false) && _stricmp(FieldName, APE_TAG_FIELD_COMMENT) == 0) {
						Buff = TagInfo->Comment;
						CommentSc = true;
					} else if((AlbumSc == false) && _stricmp(FieldName, APE_TAG_FIELD_ALBUM) == 0) {
						Buff = TagInfo->Album;
						AlbumSc = true;
					} else if((YearSc == false) && _stricmp(FieldName, APE_TAG_FIELD_YEAR_) == 0) {
						Buff = TagInfo->Year;
						YearSc = true;
					} else if((GenreSc == false) && _stricmp(FieldName, APE_TAG_FIELD_GENRE) == 0) {
						Buff = TagInfo->Genre;
						GenreSc = true;
					} else if((TrackSc == false) && _stricmp(FieldName, APE_TAG_FIELD_TRACK_) == 0) {
						Buff = TagInfo->Track;
						TrackSc = true;
					} else if((ComposerSc == false) &&
							_stricmp(FieldName, APE_TAG_FIELD_COMPOSER) == 0) {
						Buff = TagInfo->Composer;
						ComposerSc = true;
					} else if((OrgArtistSc == false) &&
							_stricmp(FieldName, APE_TAG_FIELD_ORIGINAL_ARTIST) == 0) {
						Buff = TagInfo->OrgArtist;
						OrgArtistSc = true;
					} else if((CopyrightSc == false) &&
							_stricmp(FieldName, APE_TAG_FIELD_COPYRIGHT) == 0) {
						Buff = TagInfo->Copyright;
						CopyrightSc = true;
					} else if((EncoderSc == false) &&
							_stricmp(FieldName, APE_TAG_FIELD_ENCODED_BY) == 0) {
						Buff = TagInfo->Encoder;
						EncoderSc = true;
					} else {
						Buff = NULL;
					}
				} else if(ReplayGainInfo) {
					if((ReplayGainTrackGainSc == false) &&
							_stricmp(FieldName, APE_TAG_FIELD_REPLAYGAIN_TRACK_GAIN) == 0) {
						ReplayGainFieldName = REPLAYGAIN_TRACK_GAIN;
						Buff = ReplayGainBuff;
						ReplayGainTrackGainSc = true;
					} else if((ReplayGainTrackPeakSc == false) &&
							_stricmp(FieldName, APE_TAG_FIELD_REPLAYGAIN_TRACK_PEAK) == 0) {
						ReplayGainFieldName = REPLAYGAIN_TRACK_PEAK;
						Buff = ReplayGainBuff;
						ReplayGainTrackPeakSc = true;
					} else if((ReplayGainAlbumGainSc == false) &&
							_stricmp(FieldName, APE_TAG_FIELD_REPLAYGAIN_ALBUM_GAIN) == 0) {
						ReplayGainFieldName = REPLAYGAIN_ALBUM_GAIN;
						Buff = ReplayGainBuff;
						ReplayGainAlbumGainSc = true;
					} else if((ReplayGainAlbumPeakSc == false) &&
							_stricmp(FieldName, APE_TAG_FIELD_REPLAYGAIN_ALBUM_PEAK) == 0) {
						ReplayGainFieldName = REPLAYGAIN_ALBUM_PEAK;
						Buff = ReplayGainBuff;
						ReplayGainAlbumPeakSc = true;
					} else {
						Buff = NULL;
					}
				}

				if(Buff) {
					if(TagUTF8) {
						UTF8Strcpy(
							Buff,
							MAX_MUSICTEXT,
							reinterpret_cast<char*>(TagDataPnt),
							FieldDataSize);
					} else {
						Strcpy(
							Buff,
							MAX_MUSICTEXT,
							reinterpret_cast<char*>(TagDataPnt),
							FieldDataSize);
					}

					if(ReplayGainInfo) StoreReplayGainInfo(ReplayGainInfo, ReplayGainFieldName, Buff);
				}

				TagDataPnt += FieldDataSize;
			}

			delete[] TagData;

			RetCode = true;

			if(TagInfo) {
				if(TitleSc == false) *TagInfo->Title = L'\0';
				if(ArtistSc == false) *TagInfo->Artist = L'\0';
				if(CommentSc == false) *TagInfo->Comment = L'\0';
				if(AlbumSc == false) *TagInfo->Album = L'\0';
				if(YearSc == false) *TagInfo->Year = L'\0';
				if(GenreSc == false) *TagInfo->Genre = L'\0';
				if(TrackSc == false) *TagInfo->Track = L'\0';
				if(ComposerSc == false) *TagInfo->Composer = L'\0';
				if(OrgArtistSc == false) *TagInfo->OrgArtist = L'\0';
				if(CopyrightSc == false) *TagInfo->Copyright = L'\0';
				if(EncoderSc == false) *TagInfo->Encoder = L'\0';
			} else if(ReplayGainInfo) {
				FindReplayGainInfo = ReplayGainInfo->ValidTrackGain || ReplayGainInfo->ValidAlbumGain;
			}
		} else {
			RetCode = false;
		}
	} else {
		RetCode = false;
	}

	if(RetCode == false) {
		::CloseHandle(hF);

		FindReplayGainInfo = false;
	}

	return (TagInfo || (ReplayGainInfo == NULL)) ? RetCode : FindReplayGainInfo;
}

