
#define	STRICT

#include <windows.h>

#include "mpglib/mpg123.h"

// added by Otachan
#include "FileSys.h"
//

#include "AdrTime.h"

#define	ADRTIME_FILESYS_NO	1

#define	MAX_SEARCH_HEADER	65536

static inline void SwapByte(BYTE& b1, BYTE& b2)
{
	BYTE temp = b1;
	b1 = b2;
	b2 = temp;
}

CAdrTime::CAdrTime(void)
{
	m_input_file = NULL;
	m_pData = NULL;
}

CAdrTime::~CAdrTime(void)
{
	Release();
}

bool CAdrTime::Init(FileSys* input_file, int pos, int frames)
{
	Release();

	m_input_file = input_file;
	m_dwFileSize = m_input_file->GetSize();

	frame fr;

	m_input_file->SetPointer(ADRTIME_FILESYS_NO, pos);
	if(GetFrame(fr) == false) return false;
	m_input_file->SetPointer(ADRTIME_FILESYS_NO, -fr.framesize - 4, NULL, FILE_CURRENT);

	m_nFrames = (frames == -1) ? m_dwFileSize / (fr.framesize + 4) : frames;
	m_nMaxData = m_nFrames + m_nFrames / 32;	// 3.125%]Ɋm
	m_pData = (AdrTimeData*)::malloc(m_nMaxData * sizeof(AdrTimeData));
	m_nNumData = 0;
	AddData(GetFilePtr(), 0.);

	return true;
}

void CAdrTime::Release(void)
{
	if(m_pData) {
		::free(m_pData);
		m_pData = NULL;
	}

	m_input_file = NULL;
}

DWORD CAdrTime::ToAddress(double nTime)
{
	if(m_input_file == NULL || nTime < 0) return (DWORD)-1;

	while ((m_pData + m_nNumData - 1)->nTime < nTime)
	{
		if (ProcessOneFrame() == false)
			break;
	}

	if ((m_pData + m_nNumData - 1)->nTime <= nTime)
		return (m_pData + m_nNumData - 1)->dwAdr;

	AdrTimeData dummy[2];
	dummy[0].nTime = dummy[1].nTime = nTime;
	AdrTimeData* pData = (AdrTimeData*)::bsearch(
		dummy, m_pData, m_nNumData - 1, sizeof(AdrTimeData),
		(int (__cdecl *)(const void*, const void*))AdrTimeData::CompTime);

	return pData->dwAdr;
}

double CAdrTime::ToTime(DWORD dwAdr)
{
	if(m_input_file == NULL || dwAdr < m_pData->dwAdr) return -1.;

	while ((m_pData + m_nNumData - 1)->dwAdr < dwAdr)
	{
		if (ProcessOneFrame() == false)
			return -1.;
	}

	AdrTimeData* pData = (AdrTimeData*)::bsearch(
		&AdrTimeData(dwAdr, 0), m_pData, m_nNumData, sizeof(AdrTimeData),
		(int (__cdecl *)(const void*, const void*))AdrTimeData::CompAdr);
	if (pData == NULL)
		return -1.;

	return pData->nTime;
}

double CAdrTime::GetFrameTime(const frame& fr)
{
	static const double table[4][3] ={
		{384000.0, 1152000.0, 1152000.0},/*mpeg1  */
		{384000.0, 1152000.0,  576000.0},/*mpeg2  */
		{384000.0, 1152000.0,  576000.0} /*mpeg2.5*/
		/* layer1,    layer2,    layer3*/
	};

	const int	mpeg25 = fr.mpeg25 ? 1 : 0;

	return table[mpeg25 * 2 + (fr.lsf >> mpeg25)][fr.lay - 1] / (double)freqs[fr.frequency];
}

bool CAdrTime::GetFrame(frame& fr)
{
	int i;
	for (i = 0; i < MAX_SEARCH_HEADER; i++)
	{
		DWORD dw = GetFilePtr();
		int r = ReadFrame(fr);
		if (i == 0 && r == 0)
			break;
		else if (r == 0)
		{
			DWORD dwCur = GetFilePtr();
			int j;
			for (j = 0; j < 4; j++)
			{
				frame f;
				if (ReadFrame(f) == -2)
					break;
			}
			if (j == 4)
			{
				m_input_file->SetPointer(ADRTIME_FILESYS_NO, dwCur);
				return AddData(dw, m_dTime);
			}
			else
				m_input_file->SetPointer(ADRTIME_FILESYS_NO, dw + 1);
		}
		else if (r == -1)
			return false;
	}
	if (i == MAX_SEARCH_HEADER)
		return false;

	return true;
}

// 0 
//-1 EOF
//-2 s
int CAdrTime::ReadFrame(frame& fr)
{
	union
	{
		DWORD header;
		BYTE byte[4];
	};
	DWORD nbr;
	m_input_file->Read(ADRTIME_FILESYS_NO, &header, 4, &nbr);
	if (nbr != 4)
	{
		m_input_file->SetPointer(ADRTIME_FILESYS_NO, -(long)nbr, NULL, FILE_CURRENT);
		return -1;
	}
	SwapByte(byte[0], byte[3]);
	SwapByte(byte[1], byte[2]);
	if (CheckHeader(header) == false || ::decode_header(&fr, header) == false)
	{
		int i;
		for (i = 2; i >= 0 && byte[i] != 0xFF; i--);
		m_input_file->SetPointer(ADRTIME_FILESYS_NO, -i - 1, NULL, FILE_CURRENT);
		return -2;
	}
	if((GetFilePtr() + fr.framesize) >= m_dwFileSize) {
		m_input_file->SetPointer(ADRTIME_FILESYS_NO, -4, NULL, FILE_CURRENT);
		return -1;
	}
	m_input_file->SetPointer(ADRTIME_FILESYS_NO, fr.framesize, NULL, FILE_CURRENT);

	return 0;
}

bool CAdrTime::CheckHeader(DWORD header)
{
	if((header & 0xffe00000) != 0xffe00000) return false;
	if(((header >> 17) & 3) == 0) return false;
//	if((4 - ((header >> 17) & 3)) != 3) return false;
	if(((header >> 10) & 0x3) == 0x3) return false;

	const int	bitrate = (header >> 12) & 0xf;

	if((bitrate == 0x0) || (bitrate == 0xf)) return false;

	return true;
}

inline DWORD CAdrTime::GetFilePtr(void)
{
	return m_input_file->GetPointer(ADRTIME_FILESYS_NO);
}

bool CAdrTime::AddData(DWORD dw, double nTime)
{
	if (m_nNumData == m_nMaxData)
	{
		m_nMaxData += m_nFrames / 4;	// 25%ǉ
		void* p = ::realloc(m_pData, m_nMaxData * sizeof(AdrTimeData));
		if (p == NULL)
			return false;
		m_pData = (AdrTimeData*)p;
	}
	(m_pData + m_nNumData)->dwAdr = dw;
	(m_pData + m_nNumData)->nTime = nTime;
	m_nNumData++;
	m_dTime = nTime;

	return true;
}

bool CAdrTime::ProcessOneFrame(void)
{
	frame fr;
	if (GetFrame(fr) == false)
		return false;

	return AddData(GetFilePtr(), m_dTime + GetFrameTime(fr));
}

int __cdecl CAdrTime::AdrTimeData::CompAdr(const AdrTimeData* p1, const AdrTimeData* p2)
{
	return p1->dwAdr - p2->dwAdr;
}

int __cdecl CAdrTime::AdrTimeData::CompTime(const AdrTimeData* p1, const AdrTimeData* p2)
{
	if (p2->nTime == (p2 + 1)->nTime)
	{
		if (p1->nTime <= p2->nTime && p2->nTime < (p1 + 1)->nTime)
			return 0;
	}
	else if (p2->nTime <= p1->nTime && p1->nTime < (p2 + 1)->nTime)
		return 0;

	return (int)(p1->nTime - p2->nTime);
}

