
//
//  t@Cǂݍݗpbp[NX
//  tobt@Oł悤ɂ
//
//  Written by Otachan
//  http://otachan.com/
//

#define	STRICT

#include <windows.h>

#include "CommonFunc.h"

#include "FileSys.h"

FileSys::FileSys(int _MaxClient)
{
	MaxClient = _MaxClient;

	hF = NULL;
	FileBuff = NULL;
	FilePointer = NULL;
}

FileSys::~FileSys(void)
{
	Close();
}

void
FileSys::Init(void)
{
	switch(OpenMode) {
	case FILESYS_OPENMODE_NORMAL:
		MaxHandle = MaxClient;
		FilePointer = NULL;
		break;
	case FILESYS_OPENMODE_FULLBUFFERING:
		MaxHandle = 1;
		FilePointer = new DWORD[MaxClient];
		memset(FilePointer, 0, sizeof DWORD * MaxClient);
		break;
	}

	hF = new HANDLE[MaxHandle];

	for(int Idx = 0; Idx < MaxHandle; Idx++) {
		hF[Idx] = INVALID_HANDLE_VALUE;
	}
}

bool
FileSys::Open(
			int _OpenMode,
			const WCHAR* FileName,
			DWORD Acces,
			DWORD ShareMode,
			LPSECURITY_ATTRIBUTES sa,
			DWORD Create,
			DWORD AttrsAndFlags,
			HANDLE TemplateFile,
			bool NoClose)
{
	Close();

	OpenMode = _OpenMode;

	Init();

	bool	RetCode = true;

	for(int Idx = 0; Idx < MaxHandle; Idx++) {
		if((hF[Idx] = ::CreateFile(
								FileName,
								Acces,
								ShareMode,
								sa,
								Create,
								AttrsAndFlags,
								TemplateFile)) == INVALID_HANDLE_VALUE) {
			RetCode = false;
			break;
		}
	}

	if(RetCode && (OpenMode == FILESYS_OPENMODE_FULLBUFFERING)) {
		FileSize = ::GetFileSize(hF[0], NULL);

		if(FileSize != 0xffffffff) {
			FileBuff = new unsigned char[FileSize];

			if(FileBuff) {
				DWORD	ReadByte;

				::ReadFile(hF[0], FileBuff, FileSize, &ReadByte, NULL);

				RetCode = ReadByte == FileSize;
			} else {
				RetCode = false;
			}
		}

		if(NoClose == false) CloseHandleOnly();
	}

	return RetCode;
}

void
FileSys::Close(void)
{
	if(FileBuff) {
		delete[] FileBuff;
		FileBuff = NULL;
	}

	CloseHandleOnly();

	if(FilePointer) {
		delete[] FilePointer;
		FilePointer = NULL;
	}
}

void
FileSys::CloseHandleOnly(void)
{
	if(hF) {
		for(int Idx = 0; Idx < MaxHandle; Idx++) {
			if(hF[Idx] != INVALID_HANDLE_VALUE) ::CloseHandle(hF[Idx]);
		}

		delete[] hF;
		hF = NULL;
	}
}

bool
FileSys::Read(
			int ClientIdx,
			LPVOID lpBuffer,
			DWORD nNumberOfBytesRead,
			LPDWORD lpNumberOfBytesRead,
			LPOVERLAPPED lpOverlapped)
{
	bool	RetCode;

	switch(OpenMode) {
	case FILESYS_OPENMODE_NORMAL:
		{
			DWORD	ReadByte;
			LPDWORD	pReadByte;

			if(lpNumberOfBytesRead) {
				pReadByte = lpNumberOfBytesRead;
			} else {
				pReadByte = &ReadByte;
			}

			RetCode = ::ReadFile(
							hF[ClientIdx],
							lpBuffer,
							nNumberOfBytesRead,
							pReadByte,
							lpOverlapped) != 0;
		}
		break;
	case FILESYS_OPENMODE_FULLBUFFERING:
		{
			const DWORD	CopySize = Min(nNumberOfBytesRead,
										(FileSize > FilePointer[ClientIdx]) ?
											FileSize - FilePointer[ClientIdx] : 0);

			memcpy(lpBuffer, FileBuff + FilePointer[ClientIdx], CopySize);
			FilePointer[ClientIdx] += CopySize;
			if(lpNumberOfBytesRead) *lpNumberOfBytesRead = CopySize;
		}

		RetCode = true;
		break;
	}

	return RetCode;
}

DWORD
FileSys::SetPointer(
				int ClientIdx,
				LONG lDistanceToMove,
				PLONG lpDistanceToMoveHigh,
				DWORD dwMoveMethod)
{
	DWORD	RetCode;

	switch(OpenMode) {
	case FILESYS_OPENMODE_NORMAL:
		RetCode = ::SetFilePointer(hF[ClientIdx], lDistanceToMove, lpDistanceToMoveHigh, dwMoveMethod);
		break;
	case FILESYS_OPENMODE_FULLBUFFERING:
		switch(dwMoveMethod) {
		case FILE_BEGIN:
			FilePointer[ClientIdx] = lDistanceToMove;
			break;
		case FILE_CURRENT:
			FilePointer[ClientIdx] += lDistanceToMove;
			break;
		case FILE_END:
			FilePointer[ClientIdx] = FileSize - 1 + lDistanceToMove;
			break;
		}

		RetCode = FilePointer[ClientIdx];
		break;
	}

	return RetCode;
}

HANDLE
FileSys::GetHandle(void)
{
	return hF[0];
}

DWORD
FileSys::GetSize(LPDWORD lpdwFileSizeHigh)
{
	DWORD	RetCode;

	switch(OpenMode) {
	case FILESYS_OPENMODE_NORMAL:
		RetCode = ::GetFileSize(hF[0], lpdwFileSizeHigh);
		break;
	case FILESYS_OPENMODE_FULLBUFFERING:
		if(lpdwFileSizeHigh) *lpdwFileSizeHigh = 0;

		RetCode = FileSize;
		break;
	}

	return RetCode;
}

DWORD
FileSys::GetPointer(int ClientIdx)
{
	DWORD	RetCode;

	switch(OpenMode) {
	case FILESYS_OPENMODE_NORMAL:
		RetCode = ::SetFilePointer(hF[ClientIdx], 0, NULL, FILE_CURRENT);
		break;
	case FILESYS_OPENMODE_FULLBUFFERING:
		RetCode = FilePointer[ClientIdx];
		break;
	}

	return RetCode;
}

