// In_mpg123dHttpFile.cpp : Cve[V t@C
//

#include "stdafx.h"
#include <process.h>

#include "CommonFunc.h"

#include "in_mpg123.h"

#include "HttpFile.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

ThreadParamInetRead*	CIn_mpg123dHttpFile::pParam;

//////////////////////////////////////////////////////////////
// InternetReadFile API@̎̂ăXbh
//
// 낢뎎Ă݂łǁAT[oStreamĂ
// SYNC/ASYNC/NO_WAITɊ֌WȂubLO݂Ȃ
// ŁAǂ悤ȂTerminateThreadŊOEĂ
// ܂(TerminateThreadŃ^[~l[gł悤CreateThread
// Ă܂)
// AȂłˁH(^^;

unsigned int __stdcall
InternetReadFileThread(LPVOID pParam)
{
	ThreadParamInetRead*	p = reinterpret_cast<ThreadParamInetRead*>(pParam);
	HANDLE	HandleEvent[2];

	*(HandleEvent + 0) = p->EventDestroyThread;
	*(HandleEvent + 1) = p->EventReadEx;

	::SetEvent(p->EventReadyThread);

	while(::WaitForMultipleObjects(2, HandleEvent, false, INFINITE) == (WAIT_OBJECT_0 + 1)) {
		p->success = ::InternetReadFile(
									p->hFile,
									p->lpBuffer,
									p->dwNumberOfBytesToRead,
									const_cast<DWORD*>(&p->dwNumberOfBytesRead)) != 0;
		::SetEvent(p->EventRetReadEx);
	}

	_endthreadex(0);

	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// CIn_mpg123dHttpFile

// hNX̂ŏ̂ɃRXgN^/fXgN^͌Ă΂Ȃ
// (邢)Ȃ悤ł:-)

CIn_mpg123dHttpFile::CIn_mpg123dHttpFile(HINTERNET hFile, HINTERNET hSession, LPCTSTR pstrObject,
	LPCTSTR pstrServer, LPCTSTR pstrVerb, DWORD dwContext)
 : CHttpFile(hFile, hSession, pstrObject, pstrServer, pstrVerb, dwContext)
{
}

CIn_mpg123dHttpFile::CIn_mpg123dHttpFile(HINTERNET hFile, LPCTSTR pstrVerb, LPCTSTR pstrObject,
	CHttpConnection* pConnection)
 : CHttpFile(hFile, pstrVerb, pstrObject, pConnection)
{
}

CIn_mpg123dHttpFile::~CIn_mpg123dHttpFile()
{
}

// ClassWizard KvƂȉ̍sҏWȂłB
#if 0
BEGIN_MESSAGE_MAP(CIn_mpg123dHttpFile, CHttpFile)
	//{{AFX_MSG_MAP(CIn_mpg123dHttpFile)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
#endif	// 0

// begin pl3 by YunaSoft
void CIn_mpg123dHttpFile::Init(int nPriority)
{
	pParam = new ThreadParamInetRead;
	pParam->EventReadyThread = ::CreateEvent(NULL, false, false, NULL);
	pParam->EventDestroyThread = ::CreateEvent(NULL, false, false, NULL);
	pParam->EventReadEx = ::CreateEvent(NULL, false, false, NULL);
	pParam->EventRetReadEx = ::CreateEvent(NULL, false, false, NULL);
	pParam->nPriority = nPriority;
	// begin pl4 by YunaSoft
	pParam->success = false;
	// end pl4

	// InternetReadFileXbhグ
	// (TerminateThreadŎEƂl̂ăXbh)

	unsigned int	dwThread;

	pParam->hThread = reinterpret_cast<HANDLE>(_beginthreadex(
															NULL,
															0,
															InternetReadFileThread,
															reinterpret_cast<void*>(pParam),
															// begin pl4 by YunaSoft
															CREATE_SUSPENDED,
															// end pl4
															&dwThread));

	::SetThreadPriority(pParam->hThread, pParam->nPriority);
	::ResumeThread(pParam->hThread);

	::WaitForSingleObject(pParam->EventReadyThread, INFINITE);

	::CloseHandle(pParam->EventReadyThread);

	*(pParam->HandleEvent + 0) = pParam->hThread;
	*(pParam->HandleEvent + 1) = pParam->EventRetReadEx;
}
// end pl3

// ނRXgN^/fXgN^ǂ

void CIn_mpg123dHttpFile::Quit(void)
{
	// InetReadThreadINVALID_HANDLE_VALUEȂ
	// XbhTerinateꂽƔf
	if(pParam->hThread != INVALID_HANDLE_VALUE) {
		::SetEvent(pParam->EventDestroyThread);

		if(::WaitForSingleObject(pParam->hThread, 5000) != WAIT_OBJECT_0) {
			if(::TerminateThread(pParam->hThread, 0)) {
				::WaitForSingleObject(pParam->hThread, 3000);
			}
		}

		::CloseHandle(pParam->hThread);
	}

	::CloseHandle(pParam->EventDestroyThread);
	::CloseHandle(pParam->EventReadEx);
	::CloseHandle(pParam->EventRetReadEx);

	delete pParam;
}

bool CIn_mpg123dHttpFile::_InternetReadFile(
										HINTERNET hFile,
										LPVOID lpBuffer,
										DWORD dwNumberOfBytesToRead,
										LPDWORD lpdwNumberOfBytesRead)
{
	bool	RetCode;

	pParam->hFile = hFile;
	pParam->lpBuffer = lpBuffer;
	pParam->dwNumberOfBytesToRead = dwNumberOfBytesToRead;

	if(pParam->hThread != INVALID_HANDLE_VALUE) {
		::SetEvent(pParam->EventReadEx);

		if(::WaitForMultipleObjects(2, pParam->HandleEvent, false, INFINITE) == (WAIT_OBJECT_0 + 1)) {
			if(pParam->success) {
				*lpdwNumberOfBytesRead = pParam->dwNumberOfBytesRead;
				RetCode = true;
			} else {
//				AfxThrowInternetException(m_dwContext);
				*lpdwNumberOfBytesRead = 0;
				RetCode = false;
			}
		} else {
			*lpdwNumberOfBytesRead = 0;
			RetCode = false;
		}
	} else {
		*lpdwNumberOfBytesRead = 0;
		RetCode = false;
	}

	return RetCode;
}

// ReadOverride肾ǕʕɂȂ:-)

UINT CIn_mpg123dHttpFile::ReadEx(LPVOID lpBuf, UINT nCount)
{
	ASSERT_VALID(this);
	ASSERT(AfxIsValidAddress(lpBuf, nCount));
	ASSERT(m_hFile != NULL);
	ASSERT(m_bReadMode);

	DWORD dwBytes;

	if(!m_bReadMode || m_hFile == NULL) AfxThrowInternetException(m_dwContext, ERROR_INVALID_HANDLE);

	if(m_pbReadBuffer == NULL) {
		_InternetReadFile(m_hFile, (LPVOID)lpBuf, nCount, &dwBytes);
		return dwBytes;
	}

	LPBYTE lpbBuf = (LPBYTE)lpBuf;

	// if the requested size is bigger than our buffer,
	// then handle it directly

	if(nCount >= m_nReadBufferSize) {
		DWORD dwMoved = Max(0l, (long)m_nReadBufferBytes - (long)m_nReadBufferPos);

		if(dwMoved <= nCount) {
			memcpy(lpBuf, m_pbReadBuffer + m_nReadBufferPos, dwMoved);
		} else {
			return 0; // output buffer not big enough.
		}

		m_nReadBufferPos = m_nReadBufferSize;

		_InternetReadFile(m_hFile, lpbBuf + dwMoved, nCount - dwMoved, &dwBytes);

		dwBytes += dwMoved;
	} else {
		if(m_nReadBufferPos + nCount >= m_nReadBufferBytes) {
			DWORD dwMoved = Max(0l, (long)m_nReadBufferBytes - (long)m_nReadBufferPos);

			if(dwMoved <= nCount) {
				memcpy(lpbBuf, m_pbReadBuffer + m_nReadBufferPos, dwMoved);
			} else {
				return 0;
			}

			DWORD dwRead;

			_InternetReadFile(m_hFile, m_pbReadBuffer, m_nReadBufferSize, &dwRead);

			m_nReadBufferBytes = dwRead;

			dwRead = Min(nCount - dwMoved, (DWORD)m_nReadBufferBytes);
			memcpy(lpbBuf + dwMoved, m_pbReadBuffer, dwRead);
			m_nReadBufferPos = dwRead;
			dwBytes = dwMoved + dwRead;
		} else {
			memcpy(lpbBuf, m_pbReadBuffer + m_nReadBufferPos, nCount);
			m_nReadBufferPos += nCount;
			dwBytes = nCount;
		}
	}

	return dwBytes;
}

