// ReplaygainDialog.cpp : t@C
//

#include "stdafx.h"

#include "wa_ipc.h"

#include "in_mpg123.h"

#include "HttpFile.h"
#include "ICYInfo.h"

#include "Param.h"
#include "ReplayGainDialog.h"
#include "PropertySheet.h"

// CReplaygainDialog _CAO

IMPLEMENT_DYNAMIC(CReplayGainDialog, CPropertyPage)

CReplayGainDialog::CReplayGainDialog() : CPropertyPage(CReplayGainDialog::IDD)
{
	m_bReplayGainEnable = false;
	m_bReplayGainTagID3v2 = false;
	m_bReplayGainTagAPE = false;
	m_bReplayGainTagLAME = false;
	m_bReplayGainHardLimit = false;
}

CReplayGainDialog::~CReplayGainDialog()
{
}

void CReplayGainDialog::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CH_REPLAYGAIN_ENABLE, m_bReplayGainEnable);
	DDX_Control(pDX, IDC_COMBO_REPLAYGAIN_MODE, m_comboReplayGainMode);
	DDX_Check(pDX, IDC_CH_REPLAYGAIN_TAG_ID3V2, m_bReplayGainTagID3v2);
	DDX_Check(pDX, IDC_CH_REPLAYGAIN_TAG_APE, m_bReplayGainTagAPE);
	DDX_Check(pDX, IDC_CH_REPLAYGAIN_TAG_LAME, m_bReplayGainTagLAME);
	DDX_Control(pDX, IDC_TRACK_REPLAYGAIN_PREAMP_WITH_RG, m_trackReplayGainPreAmpWithRG);
	DDX_Control(pDX, IDC_ST_REPLAYGAIN_PREAMP_WITH_RG_DB, m_ReplayGainPreAmpWithRG_DB);
	DDX_Control(pDX, IDC_TRACK_REPLAYGAIN_PREAMP_WITHOUT_RG, m_trackReplayGainPreAmpWithoutRG);
	DDX_Control(pDX, IDC_ST_REPLAYGAIN_PREAMP_WITHOUT_RG_DB, m_ReplayGainPreAmpWithoutRG_DB);
	DDX_Check(pDX, IDC_CH_REPLAYGAIN_HARDLIMIT, m_bReplayGainHardLimit);
}

BEGIN_MESSAGE_MAP(CReplayGainDialog, CPropertyPage)
	ON_BN_CLICKED(IDC_CH_REPLAYGAIN_ENABLE, OnBnClickedChReplayGainEnable)
	ON_BN_CLICKED(IDC_CH_REPLAYGAIN_TAG_ID3V2, OnBnClickedChReplayGainTagID3v2)
	ON_BN_CLICKED(IDC_CH_REPLAYGAIN_TAG_APE, OnBnClickedChReplayGainTagAPE)
	ON_BN_CLICKED(IDC_CH_REPLAYGAIN_TAG_LAME, OnBnClickedChReplayGainTagLAME)
	ON_CBN_SELCHANGE(IDC_COMBO_REPLAYGAIN_MODE, OnCbnSelchangeComboReplayGainMode)
	ON_BN_CLICKED(IDC_CH_REPLAYGAIN_HARDLIMIT, OnBnClickedChReplayGainHardlimit)
	ON_WM_HSCROLL()
END_MESSAGE_MAP()

void CReplayGainDialog::OnOK() 
{
	bool	bFlag = false;

	UpdateData();

	pr->m_bReplayGainEnable = m_bReplayGainEnable != 0;

	if(pr->m_nReplayGainMode != m_comboReplayGainMode.GetCurSel()) {
		pr->m_nReplayGainMode = m_comboReplayGainMode.GetCurSel();
		bFlag = true;
	}

	pr->m_nReplayGainTag = (m_bReplayGainTagID3v2 ? REPLAYGAIN_TAG_ID3V2 : REPLAYGAIN_TAG_NONE) |
								(m_bReplayGainTagAPE ? REPLAYGAIN_TAG_APE : REPLAYGAIN_TAG_NONE) |
								(m_bReplayGainTagLAME ? REPLAYGAIN_TAG_LAME : REPLAYGAIN_TAG_NONE);

	pr->m_nReplayGainPreAmpWithRG = m_trackReplayGainPreAmpWithRG.GetPos();
	pr->m_nReplayGainPreAmpWithoutRG = m_trackReplayGainPreAmpWithoutRG.GetPos();

	pr->m_bReplayGainHardLimit = m_bReplayGainHardLimit != 0;

	/* activeIndex 擾 */
	CIn_mpg123dPropertySheet* pSheet = (CIn_mpg123dPropertySheet*)GetParent();
	pr->m_nStartPage = pSheet->GetActiveIndex();
	pSheet->ReflectSetting(bFlag);

	CPropertyPage::OnOK();
}

void CReplayGainDialog::OnCancel() 
{
	// TODO: ̈ʒuɓʂȌ㏈ǉĂB
	
	CPropertyPage::OnCancel();
}

void CReplayGainDialog::SetParam()
{
	m_bReplayGainEnable = pr->m_bReplayGainEnable;
	m_bReplayGainTagID3v2 = !!(pr->m_nReplayGainTag & REPLAYGAIN_TAG_ID3V2);
	m_bReplayGainTagAPE = !!(pr->m_nReplayGainTag & REPLAYGAIN_TAG_APE);
	m_bReplayGainTagLAME = !!(pr->m_nReplayGainTag & REPLAYGAIN_TAG_LAME);
	m_bReplayGainHardLimit = pr->m_bReplayGainHardLimit;
}

BOOL CReplayGainDialog::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();

	// TODO: ̈ʒuɏ̕⑫ǉĂ

	m_comboReplayGainMode.SetCurSel(pr->m_nReplayGainMode);

	m_trackReplayGainPreAmpWithRG.SetRange(-120, 120, true);
	m_trackReplayGainPreAmpWithRG.SetTic(25);
	m_trackReplayGainPreAmpWithRG.SetTicFreq(10);
	m_trackReplayGainPreAmpWithRG.SetPos(pr->m_nReplayGainPreAmpWithRG);

	m_trackReplayGainPreAmpWithoutRG.SetRange(-120, 120, true);
	m_trackReplayGainPreAmpWithoutRG.SetTic(25);
	m_trackReplayGainPreAmpWithoutRG.SetTicFreq(10);
	m_trackReplayGainPreAmpWithoutRG.SetPos(pr->m_nReplayGainPreAmpWithoutRG);

	ShowDB(m_trackReplayGainPreAmpWithRG.GetPos(), &m_ReplayGainPreAmpWithRG_DB);
	ShowDB(m_trackReplayGainPreAmpWithoutRG.GetPos(), &m_ReplayGainPreAmpWithoutRG_DB);

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CReplayGainDialog::OnBnClickedChReplayGainEnable()
{
	// TODO : ɃRg[ʒmnh R[hǉ܂B
	SetModified();
}

void CReplayGainDialog::OnCbnSelchangeComboReplayGainMode()
{
	// TODO : ɃRg[ʒmnh R[hǉ܂B
	SetModified();
}

void CReplayGainDialog::OnBnClickedChReplayGainTagID3v2()
{
	// TODO : ɃRg[ʒmnh R[hǉ܂B
	SetModified();
}

void CReplayGainDialog::OnBnClickedChReplayGainTagAPE()
{
	// TODO : ɃRg[ʒmnh R[hǉ܂B
	SetModified();
}

void CReplayGainDialog::OnBnClickedChReplayGainTagLAME()
{
	// TODO : ɃRg[ʒmnh R[hǉ܂B
	SetModified();
}

void CReplayGainDialog::OnBnClickedChReplayGainHardlimit()
{
	// TODO : ɃRg[ʒmnh R[hǉ܂B
	SetModified();
}

void CReplayGainDialog::OnHScroll(UINT, UINT, CScrollBar* pScrollBar)
{
	if(pScrollBar == reinterpret_cast<CScrollBar*>(&m_trackReplayGainPreAmpWithRG)) {
		ShowDB(m_trackReplayGainPreAmpWithRG.GetPos(), &m_ReplayGainPreAmpWithRG_DB);
		SetModified();
	} else if(pScrollBar == reinterpret_cast<CScrollBar*>(&m_trackReplayGainPreAmpWithoutRG)) {
		ShowDB(m_trackReplayGainPreAmpWithoutRG.GetPos(), &m_ReplayGainPreAmpWithoutRG_DB);
		SetModified();
	}
}

void CReplayGainDialog::ShowDB(int Pos, CStatic* StaticDB)
{
	WCHAR	StrBuff[16];
	WCHAR*	Str = StrBuff;

	if(Pos > 0) {
		*Str++ = L'+';
	} else if(Pos < 0) {
		*Str++ = L'-';
	} else {
		*Str++ = L'+';
		*Str++ = L'/';
		*Str++ = L'-';
	}

	Pos = abs(Pos);

	_itow_s(Pos / 10, Str, StrBuff + 16 - Str, 10);
	Str += wcslen(Str);
	*Str++ = L'.';
	_itow_s(Pos - Pos / 10 * 10, Str, StrBuff + 16 - Str, 10);
	Str += wcslen(Str);
	*Str++ = L' ';
	*Str++ = L'd';
	*Str++ = L'B';
	*Str = L'\0';

	StaticDB->SetWindowText(StrBuff);
}

