
#define	MAX_FORMATTEXT	2048
#define	MAX_MUSICTEXT	1024

#define	MAX_GENRE		148

class
Tag
{
public:
	struct
	_TagInfo
	{
		int		Length;
		WCHAR	FileName[MAX_PATHLEN];
		WCHAR	Title[MAX_MUSICTEXT];
		WCHAR	Artist[MAX_MUSICTEXT];
		WCHAR	Album[MAX_MUSICTEXT];
		WCHAR	Year[MAX_MUSICTEXT];
		WCHAR	Comment[MAX_MUSICTEXT];
		WCHAR	Genre[MAX_MUSICTEXT];
		WCHAR	Track[MAX_MUSICTEXT];
		WCHAR	Composer[MAX_MUSICTEXT];
		WCHAR	OrgArtist[MAX_MUSICTEXT];
		WCHAR	Copyright[MAX_MUSICTEXT];
		WCHAR	Encoder[MAX_MUSICTEXT];
	};
	struct
	_ReplayGainInfo
	{
		WCHAR	FileName[MAX_PATHLEN];
		bool	ValidTrackGain;
		bool	ValidTrackPeak;
		bool	ValidAlbumGain;
		bool	ValidAlbumPeak;
		double	TrackGain;
		double	TrackPeak;
		double	AlbumGain;
		double	AlbumPeak;
	};
	struct
	_Cache
	{
		DWORD	GetTagTime;
		_TagInfo	TagInfo;
	};
	struct
	_CacheReplayGainInfo
	{
		DWORD	GetTagTime;
		_ReplayGainInfo	ReplayGainInfo;
	};
	enum
	{
		REPLAYGAIN_NONE,
		REPLAYGAIN_TRACK_GAIN,
		REPLAYGAIN_TRACK_PEAK,
		REPLAYGAIN_ALBUM_GAIN,
		REPLAYGAIN_ALBUM_PEAK,
	};

	Tag(void);
	~Tag(void);

	void	FlushCache(void);
	bool	Get(WCHAR* Title, const WCHAR* Format, const int TagPriority, const WCHAR* FileName);
	bool	GetReplayGainInfo(
							_ReplayGainInfo* Info,
							mp3info* mp3Info,
							const int TagPriority,
							const UINT ReplayGainTag,
							const WCHAR* FileName = NULL);
	int		GetExtendedFileInfo(
							extendedFileInfoStructW* ExtendedFileInfo,
							const int TagPriority,
							const UINT ReplayGainTag);

private:
	CRITICAL_SECTION	CriticalSection;
	_Cache	Cache;
	_CacheReplayGainInfo	CacheReplayGainInfo;

	int		GetCache(extendedFileInfoStructW* ExtendedFileInfo, const int TagPriority);
	int		GetCacheReplayGainInfo(
								extendedFileInfoStructW* ExtendedFileInfo,
								const int TagPriority,
								const UINT ReplayGainTag);
	bool	GetTitle(const int TagPriority, _TagInfo* TagInfo);
	bool	GetTitleFromID3v2(
							_TagInfo* TagInfo,
							_ReplayGainInfo* ReplayGainInfo = NULL,
							const WCHAR* FileName = NULL);
	bool	GetTitleFromAPE(
						_TagInfo* TagInfo,
						_ReplayGainInfo* ReplayGainInfo = NULL,
						const WCHAR* FileName = NULL);
	bool	GetTitleFromID3v1(_TagInfo* TagInfo);
	void	StoreReplayGainInfo( _ReplayGainInfo* Info, const int ReplayGainFieldName, WCHAR* Buff);
	void	DoFormat(WCHAR* Title, const size_t TitleSize, const WCHAR* Format, const _TagInfo* Info);
};

#include "APEInfo.h"
#include "ID3v1Info.h"

