/**************************************************************************
 * Copyright (C) 2008 Cocha                                               *
 * http://sourceforge.jp/projects/ecodecotool/                            *
 *                                                                        *
 *  This Program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2, or (at your option)   *
 *  any later version.                                                    *
 *                                                                        *
 *  This Program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with GNU Make; see the file COPYING.  If not, write to          *
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. *
 *                                                                        *
 **************************************************************************/

#include "EcoDecoTooL.h"

#define ID_MYTIMER 1

#define DW 196 
#define DH 328 


struct COMBODATA
{
   struct WAV
   {
      int nSamplingRate[14];
      int nBitsPerSample[7];
      int nFormatTag[7];
      int nChannels[3];
   } wav;

   struct AAC
   {
      int nAbr[18];
      int nCbr[18];
      float fVbr[11];
   } aac;

   struct FRAUNHOFER
   {
      int nCbr[19];
   } fraunhofer;

   struct LAME
   {
      int nAbr[14];
      int nCbr[14];
      int nVbr[10];
   } lame;

   struct OGG
   {
      int nAbr[14];
      int nCbr[14];
      float fVbr[12];
   } ogg;

   struct WMA
   {
      int nCbr[14];
   } wma;
};

static COMBODATA g_comboData =
{
   8000,11025,12000,16000,22050,24000,32000,44100,48000,88200,96000,176400,192000,0,
   8,16,24,32,32,64, 0,
   1, 1, 1, 1, 3, 3, 0, 
   1, 2, 0,

   16000, 20000, 24000, 28000, 32000, 40000, 48000, 56000, 64000, 80000, 96000,112000,128000,160000,192000,224000,256000,320000,
   16000, 20000, 24000, 28000, 32000, 40000, 48000, 56000, 64000, 80000, 96000,112000,128000,160000,192000,224000,256000,320000,
   0.0f, 0.1f, 0.2f, 0.3f, 0.4f, 0.5f, 0.6f, 0.7f, 0.8f, 0.9f, 1.0f,

   8000, 16000, 18000, 20000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000,112000,128000,160000,192000,224000,256000,320000,

   32000, 40000, 48000, 56000, 64000, 80000, 96000,112000,128000,160000,192000,224000,256000,320000,
   32000, 40000, 48000, 56000, 64000, 80000, 96000,112000,128000,160000,192000,224000,256000,320000,
   9, 8, 7, 6, 5, 4, 3, 2, 1, 0,

   32000, 40000, 48000, 56000, 64000, 80000, 96000,112000,128000,160000,192000,224000,256000,320000,
   32000, 40000, 48000, 56000, 64000, 80000, 96000,112000,128000,160000,192000,224000,256000,320000,
   -0.1f, 0.0f, 0.1f, 0.2f, 0.3f, 0.4f, 0.5f, 0.6f, 0.7f, 0.8f, 0.9f, 1.0f,

   32000, 40000, 48000, 56000, 64000, 80000, 96000,112000,128000,160000,192000,224000,256000,320000
};

struct LOCALEDATA
{
   char *pszLocale;
   WCHAR *pwLocale;
   int nDialogID[2]; 
   WCHAR *pwFolderDialogCaption;

   struct ERROR_MESSAGE
   {
      WCHAR *pwReplaygain;
      WCHAR *pwCombobox;
      WCHAR *pwAac;
      WCHAR *pwFraunhofer;
      WCHAR *pwLame;
      WCHAR *pwFolder1;
      WCHAR *pwFolder2;
      WCHAR *pwFolder3;
   } error;

   WCHAR *pwContainer;
   WCHAR *pwGain;

   struct WAV
   {
      WCHAR *pwSamplingRate;
      WCHAR *pwBitsPerSample;
      WCHAR *pwChannels;
   } wav;

   struct AAC
   {
      WCHAR *pwMode;
      WCHAR *pwEncode;
      WCHAR *pwAbr;
      WCHAR *pwCbr;
      WCHAR *pwVbr;
   } aac;

   struct FRAUNHOFER
   {
      WCHAR *pwMode;
      WCHAR *pwCbr;
   } fraunhofer;

   struct LAME
   {
      WCHAR *pwMode;
      WCHAR *pwAbr;
      WCHAR *pwCbr;
      WCHAR *pwVbr;
   } lame;

   struct OGG
   {
      WCHAR *pwMode;
      WCHAR *pwAbr;
      WCHAR *pwCbr;
      WCHAR *pwVbr;
   } ogg;

   struct WMA
   {
      WCHAR *pwMode;
      WCHAR *pwCbr;
   } wma;
};

static LOCALEDATA g_localeData[sizeof_LANGUAGE] =
{
   {
      "japanese", L"japanese",
      IDD_DIALOG_MAIN_JAPANESE, IDD_DIALOG_WAVEFORMAT_JAPANESE,
      L"o͐tH_̑I",

      L"vCQC̏lsł",
      L"R{{bNX̒lsłB",
      L"neroAacEnc.exe݂܂B",
      L"l3codecp.acm݂܂B",
      L"lame_enc.dll݂܂B",
      L"o͐tH_݂܂B",
      L"o͐tH_쐬ł܂łB",
      L"w肵o͐Ƀt@C쐬ł܂łB",

      L"óFwav;óFaac;óFmp3(Fraunhofer);óFmp3(Lame);óFogg(aoTuv);f特̂ݒo",

      L"͂Ɠ;Trackm[}CY;Albumm[}CY;TrackQC;AlbumQC",

      L"8,000Hz;11,025Hz;12,000Hz;16,000Hz;22,050Hz;24,000Hz;32,000Hz;44,100Hz;48,000Hz;88,200Hz;96,000Hz;176,400Hz;192,000Hz;͂Ɠ",
      L" 8bit;16bit;24bit;32bit();32bit();64bit;͂Ɠ",
      L"m(1ch);XeI(2ch);͂Ɠ",

      L"ABR;CBR;VBR",
      L";LC-AAC;HE-AAC;HE-AACv2",
      L" 16kbps; 20kbps; 24kbps; 28kbps; 32kbps; 40kbps; 48kbps; 56kbps; 64kbps; 80kbps; 96kbps;112kbps;128kbps;160kbps;192kbps;224kbps;256kbps;320kbps",
      L"Œ 16kbps;Œ 20kbps;Œ 24kbps;Œ 28kbps;Œ 32kbps;Œ 40kbps;Œ 48kbps;Œ 56kbps;Œ 64kbps;Œ 80kbps;Œ 96kbps;Œ112kbps;Œ128kbps;Œ160kbps;Œ192kbps;Œ224kbps;Œ256kbps;Œ320kbps",
      L" 0.0 (rbg[g); 0.1; 0.2; 0.3;; 0.5; 0.6; 0.7; 0.8; 0.9; 1.0 (rbg[g)",

      L"CBR",
      L"Œ@8kbps;Œ 16kbps;Œ 18kbps;Œ 20kbps;Œ 24kbps;Œ 32kbps;Œ 40kbps;Œ 48kbps;Œ 56kbps;Œ 64kbps;Œ 80kbps;Œ 96kbps;Œ112kbps;Œ128kbps;Œ160kbps;Œ192kbps;Œ224kbps;Œ256kbps;Œ320kbps",

      L"ABR;CBR;VBR",
      L" 32kbps; 40kbps; 48kbps; 56kbps; 64kbps; 80kbps; 96kbps;112kbps;128kbps;160kbps;192kbps;224kbps;256kbps;320kbps",
      L"Œ 32kbps;Œ 40kbps;Œ 48kbps;Œ 56kbps;Œ 64kbps;Œ 80kbps;Œ 96kbps;Œ112kbps;Œ128kbps;Œ160kbps;Œ192kbps;Œ224kbps;Œ256kbps;Œ320kbps",
      L" Q9 (rbg[g); Q8; Q7; Q6; Q5; Q4; Q3; Q2; Q1; Q0 (rbg[g)",

      L"ABR;CBR;VBR",
      L" 32kbps; 40kbps; 48kbps; 56kbps; 64kbps; 80kbps; 96kbps;112kbps;128kbps;160kbps;192kbps;224kbps;256kbps;320kbps",
      L"Œ 32kbps;Œ 40kbps;Œ 48kbps;Œ 56kbps;Œ 64kbps;Œ 80kbps;Œ 96kbps;Œ112kbps;Œ128kbps;Œ160kbps;Œ192kbps;Œ224kbps;Œ256kbps;Œ320kbps",
      L" -0.1 (rbg[g);ρ@0.0;ρ@0.1;ρ@0.2;ρ@0.3;ρ@0.4;ρ@0.5;ρ@0.6;ρ@0.7;ρ@0.8;ρ@0.9;ρ@1.0 (rbg[g)",

      L"CBR",
      L"Œ 32kbps;Œ 40kbps;Œ 48kbps;Œ 56kbps;Œ 64kbps;Œ 80kbps;Œ 96kbps;Œ112kbps;Œ128kbps;Œ160kbps;Œ192kbps;Œ224kbps;Œ256kbps;Œ320kbps",
   }
};


static const POINT g_apRgn[] =
{
               {   1,   7},{   1,   5},{   2,   4},{   2,   3},{   3,   2},{   4,   2},{   5,   1},{   7,   1},{   8,   0},
   {DW-8,   0},{DW-7,   1},{DW-5,   1},{DW-4,   2},{DW-3,   2},{DW-2,   3},{DW-2,   4},{DW-1,   5},{DW-1,   7},{  DW,   8},
   {  DW,DH-9},{DW-1,DH-8},{DW-1,DH-6},{DW-2,DH-5},{DW-2,DH-4},{DW-4,DH-2},{DW-5,DH-2},{DW-6,DH-1},{DW-8,DH-1},{DW-9,  DH},
   {   9,DH  },{   8,DH-1},{   6,DH-1},{   5,DH-2},{   4,DH-2},{   2,DH-4},{   2,DH-5},{   1,DH-6},{   1,DH-8},{   0,DH-9},
   {   0,   8}
};

static const POINT g_apFrame1[] =
{
               {   1,   7},{   1,   5},{   2,   4},{   2,   3},{   3,   2},{   4,   2},{   5,   1},{   7,   1},{   8,   0},
   {DW-9,   0},{DW-8,   1},{DW-6,   1},{DW-5,   2},{DW-4,   2},{DW-3,   3},{DW-3,   4},{DW-2,   5},{DW-2,   7},{DW-1,   8},
   {DW-1,DH-9},{DW-2,DH-8},{DW-2,DH-6},{DW-3,DH-5},{DW-3,DH-4},{DW-4,DH-3},{DW-5,DH-3},{DW-6,DH-2},{DW-8,DH-2},{DW-9,DH-1},
   {   8,DH-1},{   7,DH-2},{   5,DH-2},{   4,DH-3},{   3,DH-3},{   2,DH-4},{   2,DH-5},{   1,DH-6},{   1,DH-8},{   0,DH-9},
   {   0,   7}
};

static const POINT g_apFrame2[] =
{
               {   2,   7},{   2,   5},{   3,   4},{   3,   3},{   4,   3},{   5,   2},{   7,   2},{   8,   1},
   {DW-9,   1},{DW-8,   2},{DW-6,   2},{DW-5,   3},{DW-4,   3},{DW-4,   4},{DW-3,   5},{DW-3,   7},{DW-2,   8},
   {DW-2,DH-9},{DW-3,DH-8},{DW-3,DH-6},{DW-4,DH-5},{DW-4,DH-4},{DW-5,DH-4},{DW-6,DH-3},{DW-8,DH-3},{DW-9,DH-2},
   {   8,DH-2},{   7,DH-3},{   5,DH-3},{   4,DH-4},{   3,DH-4},{   3,DH-5},{   2,DH-6},{   2,DH-8},{   1,DH-9},
   {   1,   7}
};

static const POINT g_apFrame3[] =
{
               {   3,   7},{   3,   5},{   5,   3},{   7,   3},{   8,   2},
   {DW-9,   2},{DW-8,   3},{DW-6,   3},{DW-4,   5},{DW-4,   7},{DW-3,   8},
   {DW-3,DH-9},{DW-4,DH-8},{DW-4,DH-6},{DW-6,DH-4},{DW-8,DH-4},{DW-9,DH-3},
   {   8,DH-3},{   7,DH-4},{   5,DH-4},{   3,DH-6},{   3,DH-8},{   2,DH-9},
   {   2,   7}
};

static const int g_nWavResourceID[] =
{ IDC_WAV_STATIC, IDC_WAV_RADIO1, IDC_WAV_RADIO2, IDC_WAV_RADIO3, IDC_WAV_BUTTON, IDC_WAV_STATIC_FORMAT1, IDC_WAV_STATIC_FORMAT2, IDC_WAV_STATIC_GAIN, IDC_WAV_COMBO_GAIN, IDC_WAV_EDIT_GAIN, IDC_WAV_STATIC_DB};

static int g_nAacResourceID[] =
{ IDC_AAC_STATIC, IDC_AAC_COMBO_MODE, IDC_AAC_COMBO_ENCODE, IDC_AAC_COMBO_ABR, IDC_AAC_COMBO_CBR, IDC_AAC_COMBO_VBR, IDC_AAC_STATIC_GAIN, IDC_AAC_COMBO_GAIN, IDC_AAC_EDIT_GAIN, IDC_AAC_STATIC_DB, IDC_AAC_STATIC_CODEC};

static int g_nFraunhoferResourceID[] =
{ IDC_FRAUNHOFER_STATIC, IDC_FRAUNHOFER_COMBO_MODE, IDC_FRAUNHOFER_COMBO_CBR, IDC_FRAUNHOFER_STATIC_GAIN, IDC_FRAUNHOFER_COMBO_GAIN, IDC_FRAUNHOFER_EDIT_GAIN, IDC_FRAUNHOFER_STATIC_DB, IDC_FRAUNHOFER_STATIC_CODEC};

static int g_nLameResourceID[] =
{ IDC_LAME_STATIC, IDC_LAME_COMBO_MODE, IDC_LAME_COMBO_ABR, IDC_LAME_COMBO_CBR, IDC_LAME_COMBO_VBR, IDC_LAME_STATIC_VBR, IDC_LAME_STATIC_GAIN, IDC_LAME_COMBO_GAIN, IDC_LAME_EDIT_GAIN, IDC_LAME_STATIC_DB, IDC_LAME_STATIC_CODEC};

static int g_nOggResourceID[] =
{ IDC_OGG_STATIC, IDC_OGG_COMBO_MODE, IDC_OGG_COMBO_ABR, IDC_OGG_COMBO_CBR, IDC_OGG_COMBO_VBR, IDC_OGG_STATIC_VBR, IDC_OGG_STATIC_GAIN, IDC_OGG_COMBO_GAIN, IDC_OGG_EDIT_GAIN, IDC_OGG_STATIC_DB};

static int g_nWmaResourceID[] =
{ IDC_WMA_STATIC, IDC_WMA_COMBO_MODE, IDC_WMA_COMBO_CBR};

static int g_nSonomamaResourceID[] =
{ IDC_SONOMAMA_STATIC1, IDC_SONOMAMA_STATIC2, IDC_SONOMAMA_STATIC3, IDC_SONOMAMA_STATIC4, IDC_SONOMAMA_STATIC5};


static const int g_nComboResourceID[] =
{
   IDC_COMBO_CONTAINER, IDC_WAV_COMBO_GAIN,
   IDC_AAC_COMBO_MODE, IDC_AAC_COMBO_ENCODE, IDC_AAC_COMBO_ABR, IDC_AAC_COMBO_CBR, IDC_AAC_COMBO_VBR, IDC_AAC_COMBO_GAIN,
   IDC_FRAUNHOFER_COMBO_MODE, IDC_FRAUNHOFER_COMBO_CBR, IDC_FRAUNHOFER_COMBO_GAIN,
   IDC_LAME_COMBO_MODE, IDC_LAME_COMBO_ABR, IDC_LAME_COMBO_CBR, IDC_LAME_COMBO_VBR, IDC_LAME_COMBO_GAIN,
   IDC_OGG_COMBO_MODE, IDC_OGG_COMBO_ABR, IDC_OGG_COMBO_CBR, IDC_OGG_COMBO_VBR, IDC_OGG_COMBO_GAIN,
   IDC_WMA_COMBO_MODE, IDC_WMA_COMBO_CBR
};

static const int g_nComboArraySize = sizeof(g_nComboResourceID) / sizeof(g_nComboResourceID[0]);


static CMainDialog *g_pMyClass = NULL; 
void CMainDialog::PrepareComboBox(HWND hWnd, int nResourceID, WCHAR *pwText, int nTextLength)
{  

   WCHAR awItem[64];
   int i, nStartPos = 0;

   for(i=0;i<nTextLength;i++)
   {
      if(pwText[i] != ';')
      {
         awItem[i-nStartPos] = pwText[i];
      }
      else
      {
         awItem[i-nStartPos] = '\0';
         ::SendMessage(::GetDlgItem(hWnd, nResourceID), CB_ADDSTRING, 0, (LPARAM)awItem);

         nStartPos = i+1;
      }
   }

   awItem[i-nStartPos] = '\0';
   ::SendMessage(::GetDlgItem(hWnd, nResourceID), CB_ADDSTRING, 0, (LPARAM)awItem);
}
CMainDialog::CMainDialog()
{  

   g_pMyClass = this;

   m_nAlpha = 0;
   m_hRgn = NULL;
   m_nMinResourceID = IDB_BITMAP_MAIN_MIN1;
   m_nCloseResourceID = IDB_BITMAP_MAIN_CLOSE1;

   m_bExistsNeroAAC = false;
   m_bExistsFraunhoferPro = false;
   m_bExistsLameEnc = false;

   ::ZeroMemory(&m_waveFormat, sizeof(m_waveFormat));

   for(int i=0;i<sizeof_MYPROC;i++)
      m_myProc[i].proc = NULL;

   m_nLanguage = 0;

   m_myProc[ 0].nItemType = DIALOG_BUTTON;    m_myProc[ 0].nResourceID = IDC_BUTTON_MAIN_MIN;
   m_myProc[ 1].nItemType = DIALOG_BUTTON;    m_myProc[ 1].nResourceID = IDC_BUTTON_MAIN_CLOSE;
   m_myProc[ 2].nItemType = DIALOG_LINKLABEL; m_myProc[ 2].nResourceID = IDC_CONTAINER_HELP;
   m_myProc[ 3].nItemType = DIALOG_LINKLABEL; m_myProc[ 3].nResourceID = IDC_DROPFILE_BUTTON_HELP;
   m_myProc[ 4].nItemType = DIALOG_BUTTON;    m_myProc[ 4].nResourceID = IDC_WAV_BUTTON;
   m_myProc[ 5].nItemType = DIALOG_BUTTON;    m_myProc[ 5].nResourceID = IDC_OUTFOLDER_BUTTON;
   m_myProc[ 6].nItemType = DIALOG_LINKLABEL; m_myProc[ 6].nResourceID = IDC_AAC_STATIC_CODEC;
   m_myProc[ 7].nItemType = DIALOG_LINKLABEL; m_myProc[ 7].nResourceID = IDC_FRAUNHOFER_STATIC_CODEC;
   m_myProc[ 8].nItemType = DIALOG_LINKLABEL; m_myProc[ 8].nResourceID = IDC_LAME_STATIC_CODEC;
   m_myProc[ 9].nItemType = DIALOG_EDITBOX;   m_myProc[ 9].nResourceID = IDC_WAV_EDIT_GAIN;
   m_myProc[10].nItemType = DIALOG_EDITBOX;   m_myProc[10].nResourceID = IDC_AAC_EDIT_GAIN;
   m_myProc[11].nItemType = DIALOG_EDITBOX;   m_myProc[11].nResourceID = IDC_FRAUNHOFER_EDIT_GAIN;
   m_myProc[12].nItemType = DIALOG_EDITBOX;   m_myProc[12].nResourceID = IDC_LAME_EDIT_GAIN;
   m_myProc[13].nItemType = DIALOG_EDITBOX;   m_myProc[13].nResourceID = IDC_OGG_EDIT_GAIN;
}
CMainDialog::~CMainDialog()
{  

}
int CMainDialog::GetPrivateProfileInt(WCHAR *pwSection, WCHAR *pwKey, int nMin, int nMax, int nDefault, WCHAR *pwFile)
{  
   int n;
   n = (int)::GetPrivateProfileInt(pwSection, pwKey, nDefault, pwFile);

   if(n < nMin)
      n = nDefault;
   else if(nMax < n)
      n = nDefault;

   return n;
}
bool CMainDialog::LoadSetting(CONVERTDATA *pConvertData)
{  

   WCHAR awKey[16], awText[MAX_PATH], awIniFileName[MAX_PATH];
   WCHAR *pwEndPtr;
   int n, nArraySize;

   ::GetModuleFileName(NULL, awIniFileName, MAX_PATH);
   ::PathRemoveFileSpec(awIniFileName);
   ::lstrcat(awIniFileName, TEXT("\\EcoDecoTooL.ini"));

   pConvertData->nOutputFolder = GetPrivateProfileInt(L"Radio", L"outfolder", 0, 1, 0, awIniFileName);

   if(pConvertData->nOutputFolder == 1)
   {  
      pConvertData->awOutputFolder[0] = '\0';
      ::GetPrivateProfileString(L"Edit", L"outfolder", L"d:\\", pConvertData->awOutputFolder, MAX_PATH, awIniFileName);

      if(::PathIsDirectory(pConvertData->awOutputFolder) == FALSE)
      {  
         if(::SHCreateDirectory(NULL, pConvertData->awOutputFolder) != ERROR_SUCCESS)
         {
            ::MessageBeep(MB_ICONEXCLAMATION);
            ::MessageBox(NULL, g_localeData[m_nLanguage].error.pwFolder2, L"EcoDecoTooL", MB_OK);
            return false;
         }
      }
   }

   ::wsprintf(awKey, L"%d", IDC_COMBO_CONTAINER);
   pConvertData->nContainerType = GetPrivateProfileInt(L"ComboBox", awKey, 0, 4, 0, awIniFileName);

   if(pConvertData->nContainerType == 0)
   {  
      n = GetPrivateProfileInt(L"Radio", L"wav", 0, 2, 0, awIniFileName);

      if(n == 0)
      {  
         pConvertData->wf.nSamplesPerSec = 0;
         pConvertData->wf.wFormatTag = 0;
         pConvertData->wf.wBitsPerSample = 0;
         pConvertData->wf.nChannels = 0;
      }
      else if(n == 1)
      {  
         pConvertData->wf.nSamplesPerSec = 44100;
         pConvertData->wf.wFormatTag = 1;
         pConvertData->wf.wBitsPerSample = 16;
         pConvertData->wf.nChannels = 2;
      }
      else 
      {  
         n = GetPrivateProfileInt(L"combo_wav", L"combo1", 0, 13, 8, awIniFileName);
         pConvertData->wf.nSamplesPerSec = g_comboData.wav.nSamplingRate[n];

         n = GetPrivateProfileInt(L"combo_wav", L"combo2", 0, 6, 1, awIniFileName);
         pConvertData->wf.wBitsPerSample = g_comboData.wav.nBitsPerSample[n];
         pConvertData->wf.wFormatTag = g_comboData.wav.nFormatTag[n];

         n = GetPrivateProfileInt(L"combo_wav", L"combo3", 0, 2, 1, awIniFileName);
         pConvertData->wf.nChannels = g_comboData.wav.nChannels[n];
      }

      ::wsprintf(awKey, L"%d", IDC_WAV_COMBO_GAIN);
      pConvertData->nGainMode = GetPrivateProfileInt(L"ComboBox", awKey, 0, 3, 0, awIniFileName);

      awText[0] = '\0';
      ::GetPrivateProfileString(L"Edit", L"wav", L"89.0", awText, MAX_PATH, awIniFileName);
      pConvertData->dGain = ::wcstod(awText, &pwEndPtr);
   }
   else if(pConvertData->nContainerType == 1)
   {  
      ::wsprintf(awKey, L"%d", IDC_AAC_COMBO_MODE);
      pConvertData->nEncodeMode = GetPrivateProfileInt(L"ComboBox", awKey, 0, 3, 0, awIniFileName);

      ::wsprintf(awKey, L"%d", IDC_AAC_COMBO_ENCODE);
      pConvertData->nAdvancedMode = GetPrivateProfileInt(L"ComboBox", awKey, 0, 3, 0, awIniFileName);

      if(pConvertData->nEncodeMode == 0)
      {  
         nArraySize = sizeof(g_comboData.aac.nAbr) / sizeof(g_comboData.aac.nAbr[0]);
         ::wsprintf(awKey, L"%d", IDC_AAC_COMBO_ABR);
         n = GetPrivateProfileInt(L"ComboBox", awKey, 0, nArraySize-1, 0, awIniFileName);
         pConvertData->nABRCBR = g_comboData.aac.nAbr[n];
      }
      else if(pConvertData->nEncodeMode == 1)
      {  
         nArraySize = sizeof(g_comboData.aac.nCbr) / sizeof(g_comboData.aac.nCbr[0]);
         ::wsprintf(awKey, L"%d", IDC_AAC_COMBO_CBR);
         n = GetPrivateProfileInt(L"ComboBox", awKey, 0, nArraySize-1, 0, awIniFileName);
         pConvertData->nABRCBR = g_comboData.aac.nCbr[n];
      }
      else
      {  
         nArraySize = sizeof(g_comboData.aac.fVbr) / sizeof(g_comboData.aac.fVbr[0]);
         ::wsprintf(awKey, L"%d", IDC_AAC_COMBO_VBR);
         n = GetPrivateProfileInt(L"ComboBox", awKey, 0, nArraySize-1, 0, awIniFileName);
         pConvertData->fVBR = g_comboData.aac.fVbr[n];
      }

      ::wsprintf(awKey, L"%d", IDC_AAC_COMBO_GAIN);
      pConvertData->nGainMode = GetPrivateProfileInt(L"ComboBox", awKey, 0, 3, 0, awIniFileName);

      awText[0] = '\0';
      ::GetPrivateProfileString(L"Edit", L"aac", L"89.0", awText, MAX_PATH, awIniFileName);
      pConvertData->dGain = ::wcstod(awText, &pwEndPtr);
   }
   else if(pConvertData->nContainerType == 2)
   {  
      ::wsprintf(awKey, L"%d", IDC_FRAUNHOFER_COMBO_MODE);
      pConvertData->nEncodeMode = 1;

      nArraySize = sizeof(g_comboData.fraunhofer.nCbr) / sizeof(g_comboData.fraunhofer.nCbr);
      ::wsprintf(awKey, L"%d", IDC_FRAUNHOFER_COMBO_CBR);
      n = GetPrivateProfileInt(L"ComboBox", awKey, 0, nArraySize-1, 0, awIniFileName);
      pConvertData->nABRCBR = g_comboData.fraunhofer.nCbr[n];

      ::wsprintf(awKey, L"%d", IDC_FRAUNHOFER_COMBO_GAIN);
      pConvertData->nGainMode = GetPrivateProfileInt(L"ComboBox", awKey, 0, 3, 0, awIniFileName);

      awText[0] = '\0';
      ::GetPrivateProfileString(L"Edit", L"fraunhofer", L"89.0", awText, MAX_PATH, awIniFileName);
      pConvertData->dGain = ::wcstod(awText, &pwEndPtr);
   }
   else if(pConvertData->nContainerType == 3)
   {  
      ::wsprintf(awKey, L"%d", IDC_LAME_COMBO_MODE);
      pConvertData->nEncodeMode = GetPrivateProfileInt(L"ComboBox", awKey, 0, 3, 0, awIniFileName);

      if(pConvertData->nEncodeMode == 0)
      {  
         nArraySize = sizeof(g_comboData.lame.nAbr) / sizeof(g_comboData.lame.nAbr[0]);
         ::wsprintf(awKey, L"%d", IDC_LAME_COMBO_ABR);
         n = GetPrivateProfileInt(L"ComboBox", awKey, 0, nArraySize-1, 0, awIniFileName);
         pConvertData->nABRCBR = g_comboData.lame.nAbr[n];
      }
      else if(pConvertData->nEncodeMode == 1)
      {  
         nArraySize = sizeof(g_comboData.lame.nCbr) / sizeof(g_comboData.lame.nCbr[0]);
         ::wsprintf(awKey, L"%d", IDC_LAME_COMBO_CBR);
         n = GetPrivateProfileInt(L"ComboBox", awKey, 0, nArraySize-1, 0, awIniFileName);
         pConvertData->nABRCBR = g_comboData.lame.nCbr[n];
      }
      else
      {  
         nArraySize = sizeof(g_comboData.lame.nVbr) / sizeof(g_comboData.lame.nVbr[0]);
         ::wsprintf(awKey, L"%d", IDC_LAME_COMBO_VBR);
         n = GetPrivateProfileInt(L"ComboBox", awKey, 0, nArraySize-1, 0, awIniFileName);
         pConvertData->nVBR = g_comboData.lame.nVbr[n];
      }

      ::wsprintf(awKey, L"%d", IDC_LAME_COMBO_GAIN);
      pConvertData->nGainMode = GetPrivateProfileInt(L"ComboBox", awKey, 0, 3, 0, awIniFileName);

      awText[0] = '\0';
      ::GetPrivateProfileString(L"Edit", L"lame", L"89.0", awText, MAX_PATH, awIniFileName);
      pConvertData->dGain = ::wcstod(awText, &pwEndPtr);
   }
   else if(pConvertData->nContainerType == 4)
   {  
      ::wsprintf(awKey, L"%d", IDC_OGG_COMBO_MODE);
      pConvertData->nEncodeMode = GetPrivateProfileInt(L"ComboBox", awKey, 0, 3, 0, awIniFileName);

      if(pConvertData->nEncodeMode == 0)
      {  
         nArraySize = sizeof(g_comboData.ogg.nAbr) / sizeof(g_comboData.ogg.nAbr[0]);
         ::wsprintf(awKey, L"%d", IDC_OGG_COMBO_ABR);
         n = GetPrivateProfileInt(L"ComboBox", awKey, 0, nArraySize-1, 0, awIniFileName);
         pConvertData->nABRCBR = g_comboData.ogg.nAbr[n];
      }
      else if(pConvertData->nEncodeMode == 1)
      {  
         nArraySize = sizeof(g_comboData.ogg.nCbr) / sizeof(g_comboData.ogg.nCbr[0]);
         ::wsprintf(awKey, L"%d", IDC_OGG_COMBO_CBR);
         n = GetPrivateProfileInt(L"ComboBox", awKey, 0, nArraySize-1, 0, awIniFileName);
         pConvertData->nABRCBR = g_comboData.ogg.nCbr[n];
      }
      else
      {  
         nArraySize = sizeof(g_comboData.ogg.fVbr) / sizeof(g_comboData.ogg.fVbr[0]);
         ::wsprintf(awKey, L"%d", IDC_OGG_COMBO_VBR);
         n = GetPrivateProfileInt(L"ComboBox", awKey, 0, nArraySize-1, 0, awIniFileName);
         pConvertData->fVBR = g_comboData.ogg.fVbr[n];
      }

      ::wsprintf(awKey, L"%d", IDC_OGG_COMBO_GAIN);
      pConvertData->nGainMode = GetPrivateProfileInt(L"ComboBox", awKey, 0, 3, 0, awIniFileName);

      awText[0] = '\0';
      ::GetPrivateProfileString(L"Edit", L"ogg", L"89.0", awText, MAX_PATH, awIniFileName);
      pConvertData->dGain = ::wcstod(awText, &pwEndPtr);
   }

   return true;
}
bool CMainDialog::ExistsNeroAAC(void)
{  

   WCHAR awFileName[MAX_PATH];
   ::GetModuleFileName(NULL, awFileName, MAX_PATH);
   ::PathRemoveFileSpec(awFileName);
   ::lstrcat(awFileName, L"\\NeroAACEnc.exe");

   if(::PathFileExists(awFileName) != FALSE)
      return true;

   ::GetSystemDirectory(awFileName, MAX_PATH);
   ::lstrcat(awFileName, L"\\NeroAACEnc.exe");

   if(::PathFileExists(awFileName) != FALSE)
      return true;

   return false;
}
bool CMainDialog::ExistsFraunhoferPro(void)
{  

   HMODULE hDLL = NULL;
   WCHAR awFileName[MAX_PATH];

   ::GetSystemDirectory(awFileName, MAX_PATH);
   ::lstrcat(awFileName, TEXT("\\l3codecp.acm"));

   if(::PathFileExists(awFileName) != FALSE)
      hDLL = ::LoadLibrary(awFileName);

   if(hDLL == NULL)
      return false;

   SAFE_FREELIBRARY(hDLL);
   return true;
}
bool CMainDialog::ExistsLameEnc(void)
{  

   HMODULE hDLL = NULL;

   hDLL = ::LoadLibrary(TEXT("lame_enc.dll"));
   if(hDLL == NULL)
      return false;

   SAFE_FREELIBRARY(hDLL);

   return true;
}
bool CMainDialog::GetReplaygain(HWND hWnd, int nResourceID, double *pdGain)
{  

   WCHAR awText[32];
   ::GetDlgItemText(hWnd, nResourceID, awText, 32);

   WCHAR *pwEndPtr;

   *pdGain = ::wcstod(awText, &pwEndPtr);

   if(::lstrlen(pwEndPtr) > 0)
   {
      ::MessageBox(hWnd, g_localeData[m_nLanguage].error.pwReplaygain, L"EcoDecoTooL", MB_OK);
      return false;
   }

   return true;
}
void CMainDialog::SetComboBoxCursel(WCHAR *pwIniFileName, HWND hWnd, int nResourceID)
{  

   int n, nCount;
   WCHAR awKey[16];

   ::wsprintf(awKey, L"%d", nResourceID);
   n = (int)::GetPrivateProfileInt(L"ComboBox", awKey, 0, pwIniFileName);

   nCount = ::SendMessage(::GetDlgItem(hWnd, nResourceID), CB_GETCOUNT, (WPARAM)0, (LPARAM)0);

   if(n < 0 || nCount <= n)
      n = 0;

   ::SendMessage(::GetDlgItem(hWnd, nResourceID), CB_SETCURSEL, (WPARAM)n, (LPARAM)0);
}
void CMainDialog::WriteIniFile(WCHAR *pwIniFileName, HWND hWnd, int nResourceID, WCHAR *pwSection)
{  
   int n;
   WCHAR awKey[16], awText[16];

   n = ::SendMessage(::GetDlgItem(hWnd, nResourceID), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
   ::wsprintf(awText, L"%d", n);
   ::wsprintf(awKey, L"%d", nResourceID);
   ::WritePrivateProfileString(pwSection, awKey, awText, pwIniFileName);
}
bool CMainDialog::GetSettingData(HWND hWnd)
{  

   bool flag;
   int n, nArraySize;

   m_convertData.nContainerType = ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_CONTAINER), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);

   if(::IsDlgButtonChecked(hWnd, IDC_OUTFOLDER_RADIO1) == BST_CHECKED)
      m_convertData.nOutputFolder = 0;
   else
   {
      m_convertData.nOutputFolder = 1;
      ::GetDlgItemText(hWnd, IDC_OUTFOLDER_EDIT, (LPTSTR)m_convertData.awOutputFolder, MAX_PATH);
   }

   if(m_convertData.nContainerType == 0)
   {  
      if(::IsDlgButtonChecked(hWnd, IDC_WAV_RADIO1) == BST_CHECKED)
      {
         m_convertData.wf.nSamplesPerSec = 0;
         m_convertData.wf.wBitsPerSample = 0;
         m_convertData.wf.nChannels = 0;
         m_convertData.wf.wFormatTag = 0;
      }
      else if(::IsDlgButtonChecked(hWnd, IDC_WAV_RADIO2) == BST_CHECKED)
      {
         m_convertData.wf.nSamplesPerSec = 44100;
         m_convertData.wf.wBitsPerSample = 16;
         m_convertData.wf.nChannels = 2;
         m_convertData.wf.wFormatTag = 1;
      }
      else
      {
         m_convertData.wf.nSamplesPerSec = m_waveFormat.nSamplesPerSec;
         m_convertData.wf.wBitsPerSample = m_waveFormat.wBitsPerSample;
         m_convertData.wf.nChannels = m_waveFormat.nChannels;
         m_convertData.wf.wFormatTag = m_waveFormat.wFormatTag;
      }
 
      m_convertData.nGainMode = ::SendMessage(::GetDlgItem(hWnd, IDC_WAV_COMBO_GAIN), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
      if(m_convertData.nGainMode != 0)
      {
         flag = GetReplaygain(hWnd, IDC_WAV_EDIT_GAIN, &m_convertData.dGain);
         if(flag == false) return false;
      }

      return true;
  }
   else if(m_convertData.nContainerType == 1)
   {  
      m_convertData.nEncodeMode = ::SendMessage(::GetDlgItem(hWnd, IDC_AAC_COMBO_MODE), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
      m_convertData.nAdvancedMode = ::SendMessage(::GetDlgItem(hWnd, IDC_AAC_COMBO_ENCODE), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);

      if(m_convertData.nEncodeMode == 0)
      {  
         n = ::SendMessage(::GetDlgItem(hWnd, IDC_AAC_COMBO_ABR), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
         nArraySize = sizeof(g_comboData.aac.nAbr) / sizeof(g_comboData.aac.nAbr[0]);
         if(n < 0 || nArraySize <= n)
         {
            ::MessageBox(hWnd, g_localeData[m_nLanguage].error.pwCombobox, L"EcoDecoTooL", MB_OK);
            return false;
         }

         m_convertData.nABRCBR = g_comboData.aac.nAbr[n];
      }
      else if(m_convertData.nEncodeMode == 1)
      {  
         n = ::SendMessage(::GetDlgItem(hWnd, IDC_AAC_COMBO_CBR), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
         nArraySize = sizeof(g_comboData.aac.nCbr) / sizeof(g_comboData.aac.nCbr[0]);
         if(n < 0 || nArraySize <= n)
         {
            ::MessageBox(hWnd, g_localeData[m_nLanguage].error.pwCombobox, L"EcoDecoTooL", MB_OK);
            return false;
         }

         m_convertData.nABRCBR = g_comboData.aac.nCbr[n];
      }
      else
      {  
         n = ::SendMessage(::GetDlgItem(hWnd, IDC_AAC_COMBO_VBR), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
         nArraySize = sizeof(g_comboData.aac.fVbr) / sizeof(g_comboData.aac.fVbr[0]);
         if(n < 0 || nArraySize <= n)
         {
            ::MessageBox(hWnd, g_localeData[m_nLanguage].error.pwCombobox, L"EcoDecoTooL", MB_OK);
            return false;
         }

         m_convertData.fVBR = g_comboData.aac.fVbr[n];
      }

      m_convertData.nGainMode = ::SendMessage(::GetDlgItem(hWnd, IDC_AAC_COMBO_GAIN), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
      if(m_convertData.nGainMode != 0)
      {
         flag = GetReplaygain(hWnd, IDC_AAC_EDIT_GAIN, &m_convertData.dGain);
         if(flag == false) return false;
      }

      return true;
   }
   else if(m_convertData.nContainerType == 2)
   {  

      m_convertData.nEncodeMode = 1;

      n = ::SendMessage(::GetDlgItem(hWnd, IDC_FRAUNHOFER_COMBO_CBR), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
      nArraySize = sizeof(g_comboData.fraunhofer.nCbr) / sizeof(g_comboData.fraunhofer.nCbr[0]);
      if(n < 0 || nArraySize <= n)
      {
         ::MessageBox(hWnd, g_localeData[m_nLanguage].error.pwCombobox, L"EcoDecoTooL", MB_OK);
         return false;
      }

      m_convertData.nABRCBR = g_comboData.fraunhofer.nCbr[n];

      m_convertData.nGainMode = ::SendMessage(::GetDlgItem(hWnd, IDC_FRAUNHOFER_COMBO_GAIN), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
      if(m_convertData.nGainMode != 0)
      {
         flag = GetReplaygain(hWnd, IDC_FRAUNHOFER_EDIT_GAIN, &m_convertData.dGain);
         if(flag == false) return false;
      }

      return true;
   }
   else if(m_convertData.nContainerType == 3)
   {  
      m_convertData.nEncodeMode = ::SendMessage(::GetDlgItem(hWnd, IDC_LAME_COMBO_MODE), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);

      if(m_convertData.nEncodeMode == 0)
      {  
         n = ::SendMessage(::GetDlgItem(hWnd, IDC_LAME_COMBO_ABR), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
         nArraySize = sizeof(g_comboData.lame.nAbr) / sizeof(g_comboData.lame.nAbr[0]);
         if(n < 0 || nArraySize <= n)
         {
            ::MessageBox(hWnd, g_localeData[m_nLanguage].error.pwCombobox, L"EcoDecoTooL", MB_OK);
            return false;
         }

         m_convertData.nABRCBR = g_comboData.lame.nAbr[n];
      }
      else if(m_convertData.nEncodeMode == 1)
      {  
         n = ::SendMessage(::GetDlgItem(hWnd, IDC_LAME_COMBO_CBR), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
         nArraySize = sizeof(g_comboData.lame.nCbr) / sizeof(g_comboData.lame.nCbr[0]);
         if(n < 0 || nArraySize <= n)
         {
            ::MessageBox(hWnd, g_localeData[m_nLanguage].error.pwCombobox, L"EcoDecoTooL", MB_OK);
            return false;
         }

         m_convertData.nABRCBR = g_comboData.lame.nCbr[n];
      }
      else
      {  
         n = ::SendMessage(::GetDlgItem(hWnd, IDC_LAME_COMBO_VBR), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
         nArraySize = sizeof(g_comboData.lame.nVbr) / sizeof(g_comboData.lame.nVbr[0]);
         if(n < 0 || nArraySize <= n)
         {
            ::MessageBox(hWnd, g_localeData[m_nLanguage].error.pwCombobox, L"EcoDecoTooL", MB_OK);
            return false;
         }

         m_convertData.nVBR = g_comboData.lame.nVbr[n];
      }

      m_convertData.nGainMode = ::SendMessage(::GetDlgItem(hWnd, IDC_LAME_COMBO_GAIN), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
      if(m_convertData.nGainMode != 0)
      {
         flag = GetReplaygain(hWnd, IDC_LAME_EDIT_GAIN, &m_convertData.dGain);
         if(flag == false) return false;
      }

      return true;
   }
   else if(m_convertData.nContainerType == 4)
   {  
      m_convertData.nEncodeMode = ::SendMessage(::GetDlgItem(hWnd, IDC_OGG_COMBO_MODE), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);

      if(m_convertData.nEncodeMode == 0)
      {  
         n = ::SendMessage(::GetDlgItem(hWnd, IDC_OGG_COMBO_ABR), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
         nArraySize = sizeof(g_comboData.ogg.nAbr) / sizeof(g_comboData.ogg.nAbr[0]);
         if(n < 0 || nArraySize <= n)
         {
            ::MessageBox(hWnd, g_localeData[m_nLanguage].error.pwCombobox, L"EcoDecoTooL", MB_OK);
            return false;
         }

         m_convertData.nABRCBR = g_comboData.ogg.nAbr[n];
      }
      else if(m_convertData.nEncodeMode == 1)
      {  
         n = ::SendMessage(::GetDlgItem(hWnd, IDC_OGG_COMBO_CBR), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
         nArraySize = sizeof(g_comboData.ogg.nCbr) / sizeof(g_comboData.ogg.nCbr[0]);
         if(n < 0 || nArraySize <= n)
         {
            ::MessageBox(hWnd, g_localeData[m_nLanguage].error.pwCombobox, L"EcoDecoTooL", MB_OK);
            return false;
         }

         m_convertData.nABRCBR = g_comboData.ogg.nCbr[n];
      }
      else
      {  
         n = ::SendMessage(::GetDlgItem(hWnd, IDC_OGG_COMBO_VBR), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
         nArraySize = sizeof(g_comboData.ogg.fVbr) / sizeof(g_comboData.ogg.fVbr[0]);
         if(n < 0 || nArraySize <= n)
         {
            ::MessageBox(hWnd, g_localeData[m_nLanguage].error.pwCombobox, L"EcoDecoTooL", MB_OK);
            return false;
         }

         m_convertData.fVBR = g_comboData.ogg.fVbr[n];
      }

      m_convertData.nGainMode = ::SendMessage(::GetDlgItem(hWnd, IDC_OGG_COMBO_GAIN), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
      if(m_convertData.nGainMode != 0)
      {
         flag = GetReplaygain(hWnd, IDC_OGG_EDIT_GAIN, &m_convertData.dGain);
         if(flag == false) return false;
      }

      return true;
   }




   else if(m_convertData.nContainerType == 5)
   {  
      return true;
   }

   ::MessageBox(hWnd, g_localeData[m_nLanguage].error.pwCombobox, L"EcoDecoTooL", MB_OK);
   return false;
}
bool CMainDialog::DropFiles(HWND hWnd, HDROP hDrop)
{  

   int n, nLength;
   WCHAR awFileName[MAX_PATH];
   WCHAR awOutputFolder[MAX_PATH];

   int nDropFiles = (int)::DragQueryFile(hDrop, 0xFFFFFFFF, NULL, 0);
   if(nDropFiles <= 0)
      return false;

   m_convertData.dropList.clear();

   n = ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_CONTAINER), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);

   if(n == 1 && m_bExistsNeroAAC == false)
   {
      ::MessageBeep(MB_ICONEXCLAMATION);
   ::MessageBox(hWnd, g_localeData[m_nLanguage].error.pwAac, L"EcoDecoTooL", MB_OK);
      return false;
   }

   if(n == 2 && m_bExistsFraunhoferPro == false)
   {
      ::MessageBeep(MB_ICONEXCLAMATION);
      ::MessageBox(hWnd, g_localeData[m_nLanguage].error.pwCombobox, L"EcoDecoTooL", MB_OK);
      return false;
   }

   if(n == 3 && m_bExistsLameEnc == false)
   {
      ::MessageBeep(MB_ICONEXCLAMATION);
      ::MessageBox(hWnd, g_localeData[m_nLanguage].error.pwLame, L"EcoDecoTooL", MB_OK);
      return false;
   }

   if(::SendMessage(::GetDlgItem(hWnd, IDC_OUTFOLDER_RADIO2), BM_GETCHECK , 0 , 0) == BST_CHECKED)
   {
      nLength = ::GetDlgItemText(hWnd, IDC_OUTFOLDER_EDIT, (LPTSTR)awOutputFolder, MAX_PATH);

      if(nLength == 0)
      {
         ::MessageBox(hWnd, g_localeData[m_nLanguage].error.pwFolder1, L"EcoDecoTooL", MB_OK);
         return false;
      }

      ::lstrcat(awOutputFolder, TEXT("\\"));

      if(::PathIsDirectory(awOutputFolder) == FALSE)
      {
         if(::SHCreateDirectory(NULL, awOutputFolder) != ERROR_SUCCESS)
         {
            ::MessageBeep(MB_ICONEXCLAMATION);
            ::MessageBox(hWnd, g_localeData[m_nLanguage].error.pwFolder2, L"EcoDecoTooL", MB_OK);
            return false;
         }
      }
   }

   ::DragQueryFile(hDrop, 0, awFileName, MAX_PATH);

   if(::SendMessage(::GetDlgItem(hWnd, IDC_OUTFOLDER_RADIO1), BM_GETCHECK , 0 , 0) == BST_CHECKED)
      ::lstrcpy(awOutputFolder, awFileName);
   else
      ::GetDlgItemText(hWnd, IDC_OUTFOLDER_EDIT, (LPTSTR)awOutputFolder, MAX_PATH);

   awOutputFolder[3] = NULL;

   if(::GetDriveType(awOutputFolder) == DRIVE_CDROM)
   {
      ::MessageBeep(MB_ICONEXCLAMATION);
      ::MessageBox(hWnd, g_localeData[m_nLanguage].error.pwFolder3, L"EcoDecoTooL", MB_OK);
      return false;
   }

   for(int i=0;i<nDropFiles;i++)
   {
      ::DragQueryFile(hDrop, i, awFileName, MAX_PATH);
      m_convertData.dropList.push_back(awFileName);
   }

   return true;
}
int CALLBACK CMainDialog::SHBrowseProc(HWND hWnd, UINT msg, LPARAM lParam,  LPARAM lpData)
{
   if(msg == BFFM_INITIALIZED)
   {
      POINT p;
      RECT r1, r2;
      WINDOWPLACEMENT wndpl;

      ::SystemParametersInfo(SPI_GETWORKAREA, 0, &r1, 0);
      ::GetWindowRect(hWnd, &r2);
      ::GetWindowPlacement(::GetParent(hWnd), &wndpl);

      p.x = wndpl.rcNormalPosition.left + 120;
      p.y = wndpl.rcNormalPosition.top + 196;

      if( (p.x + (r2.right - r2.left)) > r1.right)
         p.x = r1.right - (r2.right - r2.left);

      if( (p.y + (r2.bottom - r2.top)) > r1.bottom)
         p.y = r1.bottom - (r2.bottom - r2.top);

      if(p.x < 0)
         p.x =0;

      if(p.y < 0)
         p.y =0;

      ::SetWindowPos(hWnd, NULL, p.x, p.y, 0, 0, SWP_NOSIZE|SWP_NOZORDER);

      ::SendMessage(hWnd, BFFM_SETSELECTION, TRUE, lpData);
   }

   return 0;
}
void CMainDialog::SelectFolder(HWND hWnd)
{  

   BROWSEINFO bInfo;
   LPITEMIDLIST pIDList = NULL;
   WCHAR awDisplayName[MAX_PATH];

   bInfo.hwndOwner      = hWnd;
   bInfo.lpfn           = this->SHBrowseProc;
   bInfo.pidlRoot       = NULL;
   bInfo.pszDisplayName = awDisplayName;
   bInfo.lpszTitle      = g_localeData[m_nLanguage].pwFolderDialogCaption;
   bInfo.ulFlags        = BIF_DONTGOBELOWDOMAIN | BIF_STATUSTEXT | BIF_RETURNONLYFSDIRS | BIF_VALIDATE | BIF_NEWDIALOGSTYLE;
   bInfo.lParam         = (LPARAM)0; 

   WCHAR awFolder[MAX_PATH];
   int length = ::GetDlgItemText(hWnd, IDC_OUTFOLDER_EDIT, (LPTSTR)awFolder, MAX_PATH);
   if(length > 0)
      bInfo.lParam = (LPARAM)awFolder; 
   else
      bInfo.lParam = (LPARAM)TEXT("c:\\"); 
    
   pIDList = ::SHBrowseForFolder(&bInfo);
   if(pIDList == NULL)
      return;

   if(!::SHGetPathFromIDList(pIDList, awDisplayName))
   {
      if(pIDList != NULL)
         ::CoTaskMemFree(pIDList);

      return;
   }

   ::SetDlgItemText(hWnd, IDC_OUTFOLDER_EDIT, (LPCTSTR)awDisplayName);

   ::CoTaskMemFree(pIDList);
}
void CMainDialog::SelectMode(HWND hWnd, int nModeResourceID, int nModeIndex)
{  

   int nCmdShow[3] = {SW_HIDE, SW_HIDE, SW_HIDE};
   nCmdShow[nModeIndex] = SW_SHOW;

   if(nModeResourceID == IDC_AAC_COMBO_MODE)
   {  
      ::ShowWindow(::GetDlgItem(hWnd, IDC_AAC_COMBO_ABR), nCmdShow[0]);
      ::ShowWindow(::GetDlgItem(hWnd, IDC_AAC_COMBO_CBR), nCmdShow[1]);
      ::ShowWindow(::GetDlgItem(hWnd, IDC_AAC_COMBO_VBR), nCmdShow[2]);

      if(nModeIndex != 2)
         ::ShowWindow(::GetDlgItem(hWnd, IDC_AAC_STATIC_VBR), SW_HIDE);
      else
         ::ShowWindow(::GetDlgItem(hWnd, IDC_AAC_STATIC_VBR), SW_SHOW);
   }
   else if(nModeResourceID == IDC_FRAUNHOFER_COMBO_MODE)
   {  
      ::ShowWindow(::GetDlgItem(hWnd, IDC_FRAUNHOFER_COMBO_CBR), SW_SHOW);
   }
   else if(nModeResourceID == IDC_LAME_COMBO_MODE)
   {  
      ::ShowWindow(::GetDlgItem(hWnd, IDC_LAME_COMBO_ABR), nCmdShow[0]);
      ::ShowWindow(::GetDlgItem(hWnd, IDC_LAME_COMBO_CBR), nCmdShow[1]);
      ::ShowWindow(::GetDlgItem(hWnd, IDC_LAME_COMBO_VBR), nCmdShow[2]);

      if(nModeIndex != 2)
         ::ShowWindow(::GetDlgItem(hWnd, IDC_LAME_STATIC_VBR), SW_HIDE);
      else
         ::ShowWindow(::GetDlgItem(hWnd, IDC_LAME_STATIC_VBR), SW_SHOW);
   }
   else if(nModeResourceID == IDC_OGG_COMBO_MODE)
   {  
      ::ShowWindow(::GetDlgItem(hWnd, IDC_OGG_COMBO_ABR), nCmdShow[0]);
      ::ShowWindow(::GetDlgItem(hWnd, IDC_OGG_COMBO_CBR), nCmdShow[1]);
      ::ShowWindow(::GetDlgItem(hWnd, IDC_OGG_COMBO_VBR), nCmdShow[2]);

      if(nModeIndex != 2)
         ::ShowWindow(::GetDlgItem(hWnd, IDC_OGG_STATIC_VBR), SW_HIDE);
      else
         ::ShowWindow(::GetDlgItem(hWnd, IDC_OGG_STATIC_VBR), SW_SHOW);
   }
   else  
   {  
      ::ShowWindow(::GetDlgItem(hWnd, IDC_WMA_COMBO_CBR), SW_SHOW);
   }
}
void CMainDialog::SelectContainer(HWND hWnd, int nContainerIndex)
{  

   int i, nArraySize, nCmdShow;

   if(nContainerIndex == 0) nCmdShow = SW_SHOW;
   else                     nCmdShow = SW_HIDE;

   nArraySize = sizeof(g_nWavResourceID) / sizeof(g_nWavResourceID[0]);
   for(i=0;i<nArraySize;i++)
      ::ShowWindow(::GetDlgItem(hWnd, g_nWavResourceID[i]), nCmdShow);

   if(nContainerIndex == 0)
   {
      if(::SendMessage(::GetDlgItem(hWnd, IDC_WAV_COMBO_GAIN), CB_GETCURSEL, (WPARAM)0, (LPARAM)0) == 0)
      {
         ::ShowWindow(::GetDlgItem(hWnd, IDC_WAV_EDIT_GAIN), SW_HIDE);
         ::ShowWindow(::GetDlgItem(hWnd, IDC_WAV_STATIC_DB), SW_HIDE);
      }
   }

   if(nContainerIndex == 1 && m_bExistsNeroAAC == true) nCmdShow = SW_SHOW;
   else                                                 nCmdShow = SW_HIDE;

   nArraySize = sizeof(g_nAacResourceID) / sizeof(g_nAacResourceID[0]);
   for(i=0;i<nArraySize;i++)
      ::ShowWindow(::GetDlgItem(hWnd, g_nAacResourceID[i]), nCmdShow);

   if(nContainerIndex == 1)
   {
      if(m_bExistsNeroAAC == true)
      {
         ::ShowWindow(::GetDlgItem(hWnd, IDC_AAC_STATIC_CODEC), SW_HIDE);
         SelectMode(hWnd, IDC_AAC_COMBO_MODE, ::SendMessage(::GetDlgItem(hWnd, IDC_AAC_COMBO_MODE), CB_GETCURSEL, 0, 0));
      }
      else
      {
         ::ShowWindow(::GetDlgItem(hWnd, IDC_AAC_STATIC), SW_SHOW);
         ::ShowWindow(::GetDlgItem(hWnd, IDC_AAC_STATIC_CODEC), SW_SHOW);
      }

      if(::SendMessage(::GetDlgItem(hWnd, IDC_AAC_COMBO_GAIN), CB_GETCURSEL, (WPARAM)0, (LPARAM)0) == 0)
      {
         ::ShowWindow(::GetDlgItem(hWnd, IDC_AAC_EDIT_GAIN), SW_HIDE);
         ::ShowWindow(::GetDlgItem(hWnd, IDC_AAC_STATIC_DB), SW_HIDE);
      }

      ::ShowWindow(::GetDlgItem(hWnd, IDC_AAC_STATIC_GAIN), SW_HIDE);
      ::ShowWindow(::GetDlgItem(hWnd, IDC_AAC_COMBO_GAIN), SW_HIDE);
      ::ShowWindow(::GetDlgItem(hWnd, IDC_AAC_EDIT_GAIN), SW_HIDE);
      ::ShowWindow(::GetDlgItem(hWnd, IDC_AAC_STATIC_DB), SW_HIDE);
   }

   if(nContainerIndex == 2 && m_bExistsFraunhoferPro == true) nCmdShow = SW_SHOW;
   else                                                       nCmdShow = SW_HIDE;

   nArraySize = sizeof(g_nFraunhoferResourceID) / sizeof(g_nFraunhoferResourceID[0]);
   for(i=0;i<nArraySize;i++)
      ::ShowWindow(::GetDlgItem(hWnd, g_nFraunhoferResourceID[i]), nCmdShow);

   if(nContainerIndex == 2)
   {
      if(m_bExistsFraunhoferPro == true)
      {
         ::ShowWindow(::GetDlgItem(hWnd, IDC_FRAUNHOFER_STATIC_CODEC), SW_HIDE);
         SelectMode(hWnd, IDC_FRAUNHOFER_COMBO_MODE, ::SendMessage(::GetDlgItem(hWnd, IDC_FRAUNHOFER_COMBO_MODE), CB_GETCURSEL, 0, 0));
      }
      else
      {
         ::ShowWindow(::GetDlgItem(hWnd, IDC_FRAUNHOFER_STATIC), SW_SHOW);
         ::ShowWindow(::GetDlgItem(hWnd, IDC_FRAUNHOFER_STATIC_CODEC), SW_SHOW);
      }

      if(::SendMessage(::GetDlgItem(hWnd, IDC_FRAUNHOFER_COMBO_GAIN), CB_GETCURSEL, (WPARAM)0, (LPARAM)0) == 0)
      {
         ::ShowWindow(::GetDlgItem(hWnd, IDC_FRAUNHOFER_EDIT_GAIN), SW_HIDE);
         ::ShowWindow(::GetDlgItem(hWnd, IDC_FRAUNHOFER_STATIC_DB), SW_HIDE);
      }
   }

   if(nContainerIndex == 3 && m_bExistsLameEnc == true) nCmdShow = SW_SHOW;
   else                                                 nCmdShow = SW_HIDE;

   nArraySize = sizeof(g_nLameResourceID) / sizeof(g_nLameResourceID[0]);
   for(i=0;i<nArraySize;i++)
      ::ShowWindow(::GetDlgItem(hWnd, g_nLameResourceID[i]), nCmdShow);

   if(nContainerIndex == 3)
   {
      if(m_bExistsLameEnc == true)
      {
         ::ShowWindow(::GetDlgItem(hWnd, IDC_LAME_STATIC_CODEC), SW_HIDE);
         SelectMode(hWnd, IDC_LAME_COMBO_MODE, ::SendMessage(::GetDlgItem(hWnd, IDC_LAME_COMBO_MODE), CB_GETCURSEL, 0, 0));
      }
      else
      {
         ::ShowWindow(::GetDlgItem(hWnd, IDC_LAME_STATIC), SW_SHOW);
         ::ShowWindow(::GetDlgItem(hWnd, IDC_LAME_STATIC_CODEC), SW_SHOW);
      }

      if(::SendMessage(::GetDlgItem(hWnd, IDC_LAME_COMBO_GAIN), CB_GETCURSEL, (WPARAM)0, (LPARAM)0) == 0)
      {
         ::ShowWindow(::GetDlgItem(hWnd, IDC_LAME_EDIT_GAIN), SW_HIDE);
         ::ShowWindow(::GetDlgItem(hWnd, IDC_LAME_STATIC_DB), SW_HIDE);
      }
   }

   if(nContainerIndex == 4) nCmdShow = SW_SHOW;
   else                     nCmdShow = SW_HIDE;

   nArraySize = sizeof(g_nOggResourceID) / sizeof(g_nOggResourceID[0]);
   for(i=0;i<nArraySize;i++)
      ::ShowWindow(::GetDlgItem(hWnd, g_nOggResourceID[i]), nCmdShow);

   if(nContainerIndex == 4)
   {
      SelectMode(hWnd, IDC_OGG_COMBO_MODE, ::SendMessage(::GetDlgItem(hWnd, IDC_OGG_COMBO_MODE), CB_GETCURSEL, 0, 0));

      if(::SendMessage(::GetDlgItem(hWnd, IDC_OGG_COMBO_GAIN), CB_GETCURSEL, (WPARAM)0, (LPARAM)0) == 0)
      {
         ::ShowWindow(::GetDlgItem(hWnd, IDC_OGG_EDIT_GAIN), SW_HIDE);
         ::ShowWindow(::GetDlgItem(hWnd, IDC_OGG_STATIC_DB), SW_HIDE);
      }
   }


nCmdShow = SW_HIDE;

   nArraySize = sizeof(g_nWmaResourceID) / sizeof(g_nWmaResourceID[0]);
   for(i=0;i<nArraySize;i++)
      ::ShowWindow(::GetDlgItem(hWnd, g_nWmaResourceID[i]), nCmdShow);


   if(nContainerIndex == 5) nCmdShow = SW_SHOW;
   else                     nCmdShow = SW_HIDE;

   nArraySize = sizeof(g_nSonomamaResourceID) / sizeof(g_nSonomamaResourceID[0]);
   for(i=0;i<nArraySize;i++)
      ::ShowWindow(::GetDlgItem(hWnd, g_nSonomamaResourceID[i]), nCmdShow);
}
void CMainDialog::OnCreate(HWND hWnd)
{  

   int n;

   m_bExistsNeroAAC = ExistsNeroAAC();

   m_bExistsFraunhoferPro = ExistsFraunhoferPro();

   m_bExistsLameEnc = ExistsLameEnc();

   ::SetWindowPos(::GetDlgItem(hWnd, IDC_BUTTON_MAIN_MIN),           NULL, 165,   7,  11, 11, SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_BUTTON_MAIN_CLOSE),         NULL, 179,   7,  11, 11, SWP_NOZORDER);

   ::SetWindowPos(::GetDlgItem(hWnd, IDC_WAV_STATIC_GAIN),      NULL,  27, 120,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_WAV_COMBO_GAIN),       NULL,  30, 136, 115, 10, SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_WAV_EDIT_GAIN),        NULL, 146, 136,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_WAV_STATIC_DB),        NULL, 175, 140,   0,  0, SWP_NOSIZE|SWP_NOZORDER);

   ::SetWindowPos(::GetDlgItem(hWnd, IDC_AAC_STATIC),           NULL,  27,  57,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_AAC_COMBO_MODE),       NULL,  30,  73,  60, 10, SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_AAC_COMBO_ENCODE),     NULL,  95,  73,  80, 10, SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_AAC_COMBO_ABR),        NULL,  30,  94, 145, 10, SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_AAC_COMBO_CBR),        NULL,  30,  94, 145, 10, SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_AAC_COMBO_VBR),        NULL,  30,  94, 145, 10, SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_AAC_STATIC_GAIN),      NULL,  27, 120,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_AAC_COMBO_GAIN),       NULL,  30, 136, 115, 10, SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_AAC_EDIT_GAIN),        NULL, 146, 136,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_AAC_STATIC_DB),        NULL, 175, 140,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_AAC_STATIC_CODEC),     NULL,  30,  80,   0,  0, SWP_NOSIZE|SWP_NOZORDER);

   ::SetWindowPos(::GetDlgItem(hWnd, IDC_FRAUNHOFER_STATIC),           NULL,  27,  57,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_FRAUNHOFER_COMBO_MODE),       NULL,  30,  73,  60, 10, SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_FRAUNHOFER_COMBO_CBR),        NULL,  30,  94,  145, 10, SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_FRAUNHOFER_STATIC_GAIN),      NULL,  27, 120,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_FRAUNHOFER_COMBO_GAIN),       NULL,  30, 136, 115, 10, SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_FRAUNHOFER_EDIT_GAIN),        NULL, 146, 136,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_FRAUNHOFER_STATIC_DB),        NULL, 175, 140,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_FRAUNHOFER_STATIC_CODEC),     NULL,  30,  80,   0,  0, SWP_NOSIZE|SWP_NOZORDER);

   ::SetWindowPos(::GetDlgItem(hWnd, IDC_LAME_STATIC),           NULL,  27,  57,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_LAME_COMBO_MODE),       NULL,  30,  73,  60, 10, SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_LAME_COMBO_ABR),        NULL,  30,  94,  145, 10, SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_LAME_COMBO_CBR),        NULL,  30,  94,  145, 10, SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_LAME_COMBO_VBR),        NULL,  30,  94,  145, 10, SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_LAME_STATIC_GAIN),      NULL,  27, 120,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_LAME_COMBO_GAIN),       NULL,  30, 136, 115, 10, SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_LAME_EDIT_GAIN),        NULL, 146, 136,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_LAME_STATIC_DB),        NULL, 175, 140,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_LAME_STATIC_CODEC),     NULL,  30,  80,   0,  0, SWP_NOSIZE|SWP_NOZORDER);

   ::SetWindowPos(::GetDlgItem(hWnd, IDC_OGG_STATIC),           NULL,  27,  57,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_OGG_COMBO_MODE),       NULL,  30,  73,  60, 10, SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_OGG_COMBO_ABR),        NULL,  30,  94,  145, 10, SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_OGG_COMBO_CBR),        NULL,  30,  94,  145, 10, SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_OGG_COMBO_VBR),        NULL,  30,  94,  145, 10, SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_OGG_STATIC_GAIN),      NULL,  27, 120,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_OGG_COMBO_GAIN),       NULL,  30, 136, 115, 10, SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_OGG_EDIT_GAIN),        NULL, 146, 136,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_OGG_STATIC_DB),        NULL, 175, 140,   0,  0, SWP_NOSIZE|SWP_NOZORDER);

   ::SetWindowPos(::GetDlgItem(hWnd, IDC_WMA_STATIC),           NULL,  27,  57,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_WMA_COMBO_MODE),       NULL,  30,  73,  60, 10, SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_WMA_COMBO_CBR),        NULL,  30,  94,  145, 10, SWP_NOZORDER);

   ::SetWindowPos(::GetDlgItem(hWnd, IDC_SONOMAMA_STATIC1),     NULL,  27,  57,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_SONOMAMA_STATIC2),     NULL,  30,  75,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_SONOMAMA_STATIC3),     NULL,  90,  87,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_SONOMAMA_STATIC4),     NULL,  30, 107,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_SONOMAMA_STATIC5),     NULL,  90, 119,   0,  0, SWP_NOSIZE|SWP_NOZORDER);

   ::SetWindowPos(::GetDlgItem(hWnd, IDC_CONTAINER_HELP),       NULL, 170,  55,  16, 16, SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_DROPFILE_BUTTON_HELP), NULL, 170, 245,  16, 16, SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_WAV_BUTTON),           NULL, 112, 110,  16, 14, SWP_NOMOVE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_OUTFOLDER_BUTTON),     NULL,   0,   0, 16, 14, SWP_NOMOVE|SWP_NOZORDER);


   for(int i=0;i<g_nComboArraySize;i++)
      ::SendMessage(::GetDlgItem(hWnd, g_nComboResourceID[i]), CB_SETITEMHEIGHT, (WPARAM)-1, (LPARAM)13);

   ::SetWindowText(hWnd, TEXT("EcoDecoTooL"));

   DWORD result;
   WCHAR awText[MAX_PATH], awIniFileName[MAX_PATH];
   ::GetModuleFileName(NULL, awIniFileName, MAX_PATH);
   ::PathRemoveFileSpec(awIniFileName);
   ::lstrcat(awIniFileName, TEXT("\\EcoDecoTooL.ini"));

   PrepareComboBox(hWnd, IDC_COMBO_CONTAINER, g_localeData[m_nLanguage].pwContainer, ::lstrlen(g_localeData[m_nLanguage].pwContainer));
   PrepareComboBox(hWnd, IDC_WAV_COMBO_GAIN, g_localeData[m_nLanguage].pwGain, ::lstrlen(g_localeData[m_nLanguage].pwGain));
   PrepareComboBox(hWnd, IDC_AAC_COMBO_MODE, g_localeData[m_nLanguage].aac.pwMode, ::lstrlen(g_localeData[m_nLanguage].aac.pwMode));
   PrepareComboBox(hWnd, IDC_AAC_COMBO_ENCODE, g_localeData[m_nLanguage].aac.pwEncode, ::lstrlen(g_localeData[m_nLanguage].aac.pwEncode));
   PrepareComboBox(hWnd, IDC_AAC_COMBO_ABR, g_localeData[m_nLanguage].aac.pwAbr, ::lstrlen(g_localeData[m_nLanguage].aac.pwAbr));
   PrepareComboBox(hWnd, IDC_AAC_COMBO_CBR, g_localeData[m_nLanguage].aac.pwCbr, ::lstrlen(g_localeData[m_nLanguage].aac.pwCbr));
   PrepareComboBox(hWnd, IDC_AAC_COMBO_VBR, g_localeData[m_nLanguage].aac.pwVbr, ::lstrlen(g_localeData[m_nLanguage].aac.pwVbr));
   PrepareComboBox(hWnd, IDC_AAC_COMBO_GAIN, g_localeData[m_nLanguage].pwGain, ::lstrlen(g_localeData[m_nLanguage].pwGain));
   PrepareComboBox(hWnd, IDC_FRAUNHOFER_COMBO_MODE, g_localeData[m_nLanguage].fraunhofer.pwMode, ::lstrlen(g_localeData[m_nLanguage].fraunhofer.pwMode));
   PrepareComboBox(hWnd, IDC_FRAUNHOFER_COMBO_CBR, g_localeData[m_nLanguage].fraunhofer.pwCbr, ::lstrlen(g_localeData[m_nLanguage].fraunhofer.pwCbr));
   PrepareComboBox(hWnd, IDC_FRAUNHOFER_COMBO_GAIN, g_localeData[m_nLanguage].pwGain, ::lstrlen(g_localeData[m_nLanguage].pwGain));
   PrepareComboBox(hWnd, IDC_LAME_COMBO_MODE, g_localeData[m_nLanguage].lame.pwMode, ::lstrlen(g_localeData[m_nLanguage].lame.pwMode));
   PrepareComboBox(hWnd, IDC_LAME_COMBO_ABR, g_localeData[m_nLanguage].lame.pwAbr, ::lstrlen(g_localeData[m_nLanguage].lame.pwAbr));
   PrepareComboBox(hWnd, IDC_LAME_COMBO_CBR, g_localeData[m_nLanguage].lame.pwCbr, ::lstrlen(g_localeData[m_nLanguage].lame.pwCbr));
   PrepareComboBox(hWnd, IDC_LAME_COMBO_VBR, g_localeData[m_nLanguage].lame.pwVbr, ::lstrlen(g_localeData[m_nLanguage].lame.pwVbr));
   PrepareComboBox(hWnd, IDC_LAME_COMBO_GAIN, g_localeData[m_nLanguage].pwGain, ::lstrlen(g_localeData[m_nLanguage].pwGain));
   PrepareComboBox(hWnd, IDC_OGG_COMBO_MODE, g_localeData[m_nLanguage].ogg.pwMode, ::lstrlen(g_localeData[m_nLanguage].ogg.pwMode));
   PrepareComboBox(hWnd, IDC_OGG_COMBO_ABR, g_localeData[m_nLanguage].ogg.pwAbr, ::lstrlen(g_localeData[m_nLanguage].ogg.pwAbr));
   PrepareComboBox(hWnd, IDC_OGG_COMBO_CBR, g_localeData[m_nLanguage].ogg.pwCbr, ::lstrlen(g_localeData[m_nLanguage].ogg.pwCbr));
   PrepareComboBox(hWnd, IDC_OGG_COMBO_VBR, g_localeData[m_nLanguage].ogg.pwVbr, ::lstrlen(g_localeData[m_nLanguage].ogg.pwVbr));
   PrepareComboBox(hWnd, IDC_OGG_COMBO_GAIN, g_localeData[m_nLanguage].pwGain, ::lstrlen(g_localeData[m_nLanguage].pwGain));
   PrepareComboBox(hWnd, IDC_WMA_COMBO_MODE, g_localeData[m_nLanguage].wma.pwMode, ::lstrlen(g_localeData[m_nLanguage].wma.pwMode));
   PrepareComboBox(hWnd, IDC_WMA_COMBO_CBR, g_localeData[m_nLanguage].wma.pwCbr, ::lstrlen(g_localeData[m_nLanguage].wma.pwCbr));

   for(int i=0;i<g_nComboArraySize;i++)
      SetComboBoxCursel(awIniFileName, hWnd, g_nComboResourceID[i]);

   n = (int)::GetPrivateProfileInt(L"Radio", L"wav", 0, awIniFileName);
   if(n == 0)      ::CheckRadioButton(hWnd, IDC_WAV_RADIO1, IDC_WAV_RADIO3, IDC_WAV_RADIO1);
   else if(n == 1) ::CheckRadioButton(hWnd, IDC_WAV_RADIO1, IDC_WAV_RADIO3, IDC_WAV_RADIO2);
   else            ::CheckRadioButton(hWnd, IDC_WAV_RADIO1, IDC_WAV_RADIO3, IDC_WAV_RADIO3);

   n = (int)::GetPrivateProfileInt(L"Radio", L"outfolder", 0, awIniFileName);
   if(n == 0) ::CheckRadioButton(hWnd, IDC_OUTFOLDER_RADIO1, IDC_OUTFOLDER_RADIO2, IDC_OUTFOLDER_RADIO1);
   else       ::CheckRadioButton(hWnd, IDC_OUTFOLDER_RADIO1, IDC_OUTFOLDER_RADIO2, IDC_OUTFOLDER_RADIO2);

   awText[0] = '\0';
   ::GetPrivateProfileString(L"Edit", L"outfolder", L"d:\\", awText, MAX_PATH, awIniFileName);
   if(::lstrlen(awText) > 0) ::SetDlgItemText(hWnd, IDC_OUTFOLDER_EDIT, awText);

   awText[0] = '\0';
   result = ::GetPrivateProfileString(L"Edit", L"wav", L"89.0", awText, MAX_PATH, awIniFileName);
   if(result > 0)
      ::SetDlgItemText(hWnd, IDC_WAV_EDIT_GAIN, awText);

   awText[0] = '\0';
   result = ::GetPrivateProfileString(L"Edit", L"aac", L"89.0", awText, MAX_PATH, awIniFileName);
   if(result > 0)
      ::SetDlgItemText(hWnd, IDC_AAC_EDIT_GAIN, awText);

   awText[0] = '\0';
   result = ::GetPrivateProfileString(L"Edit", L"fraunhofer", L"89.0", awText, MAX_PATH, awIniFileName);
   if(result > 0)
      ::SetDlgItemText(hWnd, IDC_FRAUNHOFER_EDIT_GAIN, awText);

   awText[0] = '\0';
   result = ::GetPrivateProfileString(L"Edit", L"lame", L"89.0", awText, MAX_PATH, awIniFileName);
   if(result > 0)
      ::SetDlgItemText(hWnd, IDC_LAME_EDIT_GAIN, awText);

   awText[0] = '\0';
   result = ::GetPrivateProfileString(L"Edit", L"ogg", L"89.0", awText, MAX_PATH, awIniFileName);
   if(result > 0)
      ::SetDlgItemText(hWnd, IDC_OGG_EDIT_GAIN, awText);

   SelectContainer(hWnd, ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_CONTAINER), CB_GETCURSEL, 0, 0));

   WCHAR awTmp[32];
   n = (int)::GetPrivateProfileInt(L"combo_wav", L"combo1", 8, awIniFileName);
   if(n < 0 || 13 < n) n = 8;
   m_waveFormat.nSamplesPerSec = g_comboData.wav.nSamplingRate[n];

   n = (int)::GetPrivateProfileInt(L"combo_wav", L"combo2", 1, awIniFileName);
   if(n < 0 || 6 < n) n = 1;
   g_pMyClass->m_waveFormat.wBitsPerSample = g_comboData.wav.nBitsPerSample[n];
   g_pMyClass->m_waveFormat.wFormatTag = g_comboData.wav.nFormatTag[n];


   n = (int)::GetPrivateProfileInt(L"combo_wav", L"combo3", 1, awIniFileName);
   if(n < 0 || 2 < n) n = 1;
   g_pMyClass->m_waveFormat.nChannels = n + 1;
   if(n == 2)
   g_pMyClass->m_waveFormat.nChannels = 0;

   awText[0] = '\0';
   if(g_pMyClass->m_waveFormat.nSamplesPerSec != 0)
   {
      ::wsprintf(awTmp, L"%3d,%03dHz", g_pMyClass->m_waveFormat.nSamplesPerSec/1000, g_pMyClass->m_waveFormat.nSamplesPerSec%1000);
      ::lstrcpy(awText, awTmp);

      ::SetDlgItemText(hWnd, IDC_WAV_STATIC_FORMAT1, awText);
   }

   awText[0] = '\0';
   if(g_pMyClass->m_waveFormat.wBitsPerSample != 0)
   {
       ::wsprintf(awTmp, L" %2dbit", g_pMyClass->m_waveFormat.wBitsPerSample);
       ::lstrcat(awText, awTmp);
   }

   if(g_pMyClass->m_waveFormat.nChannels == 1)
      ::lstrcat(awText, L" 1ch");
   else if(g_pMyClass->m_waveFormat.nChannels == 2)
      ::lstrcat(awText, L" 2ch");

   if(g_pMyClass->m_waveFormat.nSamplesPerSec == 0)
   {
      ::SetDlgItemText(hWnd, IDC_WAV_STATIC_FORMAT1, awText);
      ::SetDlgItemText(hWnd, IDC_WAV_STATIC_FORMAT2, L"");
   }
   else
      ::SetDlgItemText(hWnd, IDC_WAV_STATIC_FORMAT2, awText);


   m_hRgn = ::CreatePolygonRgn(g_apRgn, 40, WINDING);

   ::SetWindowRgn(hWnd, m_hRgn, TRUE);
   ::SetWindowPos(hWnd, HWND_TOPMOST, 0, 0, DW, DH, SWP_NOMOVE|SWP_NOZORDER);

   for(n=0;n<sizeof_MYPROC;n++)
   {
      m_myProc[n].proc = (WNDPROC)::GetWindowLong(::GetDlgItem(hWnd, m_myProc[n].nResourceID), GWL_WNDPROC);
      ::SetWindowLong(::GetDlgItem(hWnd, m_myProc[n].nResourceID), GWL_WNDPROC, (LONG)g_pMyClass->CustomProc);
   }

   RECT r1, r2;
   POINT p;

   p.x = (int)::GetPrivateProfileInt(L"MainWindow", L"Left", 100, awIniFileName);
   p.y = (int)::GetPrivateProfileInt(L"MainWindow", L"Top", 100, awIniFileName);

   ::SystemParametersInfo(SPI_GETWORKAREA, 0, &r1, 0);
   ::GetWindowRect(hWnd, &r2);

   if(p.x < 0)
      p.x = 0;
   else if( ((r1.right- r1.left) - (r2.right - r2.left)) < p.x)
      p.x = (r1.right- r1.left) - (r2.right - r2.left);

   if(p.y < 0)
      p.y = 0;
   else if( ((r1.bottom- r1.top) - (r2.bottom - r2.top)) < p.y)
      p.y = (r1.bottom- r1.top) - (r2.bottom - r2.top);

   ::SetWindowPos(hWnd, HWND_TOPMOST, p.x, p.y, 0, 0, SWP_NOSIZE);

   ::DragAcceptFiles(hWnd, TRUE);
}
void CMainDialog::OnClose(HWND hWnd)
{  

   int n;
   DWORD result;
   WCHAR awText[MAX_PATH], awIniFileName[MAX_PATH];

   ::GetModuleFileName(NULL, awIniFileName, MAX_PATH);
   ::PathRemoveFileSpec(awIniFileName);
   ::lstrcat(awIniFileName, TEXT("\\EcoDecoTooL.ini"));

   for(n=0;n<g_nComboArraySize;n++)
      WriteIniFile(awIniFileName, hWnd, g_nComboResourceID[n], L"ComboBox");

   if(::IsDlgButtonChecked(hWnd, IDC_WAV_RADIO1) == BST_CHECKED)
      ::WritePrivateProfileString(L"Radio", L"wav", L"0", awIniFileName);
   else if(::IsDlgButtonChecked(hWnd, IDC_WAV_RADIO2) == 1)
      ::WritePrivateProfileString(L"Radio", L"wav", L"1", awIniFileName);
   else
      ::WritePrivateProfileString(L"Radio", L"wav", L"2", awIniFileName);

   if(::IsDlgButtonChecked(hWnd, IDC_OUTFOLDER_RADIO1) == BST_CHECKED)
      ::WritePrivateProfileString(L"Radio", L"outfolder", L"0", awIniFileName);
   else
      ::WritePrivateProfileString(L"Radio", L"outfolder", L"1", awIniFileName);

   ::GetDlgItemText(hWnd, IDC_OUTFOLDER_EDIT, awText, MAX_PATH);
   ::WritePrivateProfileString(L"Edit", L"outfolder", awText, awIniFileName);

   result = ::GetDlgItemText(hWnd, IDC_WAV_EDIT_GAIN, awText, MAX_PATH);
   if(result > 0)
      ::WritePrivateProfileString(L"Edit", L"wav", awText, awIniFileName);

   result = ::GetDlgItemText(hWnd, IDC_AAC_EDIT_GAIN, awText, MAX_PATH);
   if(result > 0)
      ::WritePrivateProfileString(L"Edit", L"aac", awText, awIniFileName);

   result = ::GetDlgItemText(hWnd, IDC_FRAUNHOFER_EDIT_GAIN, awText, MAX_PATH);
   if(result > 0)
      ::WritePrivateProfileString(L"Edit", L"fraunhofer", awText, awIniFileName);

   result = ::GetDlgItemText(hWnd, IDC_LAME_EDIT_GAIN, awText, MAX_PATH);
   if(result > 0)
      ::WritePrivateProfileString(L"Edit", L"lame", awText, awIniFileName);

   result = ::GetDlgItemText(hWnd, IDC_OGG_EDIT_GAIN, awText, MAX_PATH);
   if(result > 0)
      ::WritePrivateProfileString(L"Edit", L"ogg", awText, awIniFileName);

   WINDOWPLACEMENT wndpl;
   ::GetWindowPlacement(hWnd, &wndpl);
   ::wsprintf(awText, TEXT("%d"), wndpl.rcNormalPosition.left);
   ::WritePrivateProfileString(L"MainWindow", L"Left", awText, awIniFileName);
   ::wsprintf(awText, TEXT("%d"), wndpl.rcNormalPosition.top);
   ::WritePrivateProfileString(L"MainWindow", L"Top", awText, awIniFileName);

   SAFE_DELETEOBJECT(m_hRgn);
}
void CMainDialog::OnPaint(HDC hDC)
{
   RECT r;
   int i, color;

   double dx = DW / 50.0;
   double dc = (240.0-210.0) / 50.0;

   HBRUSH hBrush;

   for(i=0;i<=50;i++)
   {
      color = 210 + (int)(i*dc);

      ::SetRect(&r, int(i*dx), 0, int((i+1)*dx), DH);
      hBrush = ::CreateSolidBrush(RGB(color,color,color));
      ::FillRect(hDC, &r, hBrush);
      ::DeleteObject(hBrush); 
   }


   ::SetRect(&r, 0, 0, DW, 20);
   hBrush = ::CreateSolidBrush(RGB(255,255,255));
   ::FillRect(hDC, &r, hBrush);
   ::DeleteObject(hBrush); 

   HPEN hPen;

   hPen = CreatePen(PS_SOLID, 1, RGB(206, 206, 206));
   ::SelectObject(hDC, hPen);
   ::Polyline(hDC, g_apFrame1, 40);
   ::Polyline(hDC, g_apFrame2, 40);
   ::DeleteObject(hPen); 

   hPen = CreatePen(PS_SOLID, 1, RGB(230, 230, 230));
   ::SelectObject(hDC, hPen);
   ::Polyline(hDC, g_apFrame3, 24);

   ::MoveToEx(hDC, 5, 4, NULL);
   ::LineTo(hDC, DW-5, 4);

   ::MoveToEx(hDC, 4, 19, NULL);
   ::LineTo(hDC, DW-4, 19);

   ::DeleteObject(hPen); 

   hPen = CreatePen(PS_SOLID, 1, RGB(239, 239, 239));
   ::SelectObject(hDC, hPen);
   ::MoveToEx(hDC, 8, 3, NULL);
   ::LineTo(hDC, DW-8, 3);

   ::MoveToEx(hDC, 3, 21, NULL);
   ::LineTo(hDC, 3, DH-9);

   ::DeleteObject(hPen); 

   hPen = CreatePen(PS_SOLID, 1, RGB(235, 235, 235));
   ::SelectObject(hDC, hPen);
   ::MoveToEx(hDC, 4, 5, NULL);
   ::LineTo(hDC, DW-4, 5);
   ::DeleteObject(hPen); 

   hPen = CreatePen(PS_SOLID, 1, RGB(255, 255, 255));
   ::SelectObject(hDC, hPen);
   ::MoveToEx(hDC, 3, 20, NULL);
   ::LineTo(hDC, DW-3, 20);
   ::DeleteObject(hPen); 



   ::SetRect(&r, 22, 52, 190, 159);
   DrawCustomRoundRect(hDC, &r);

   ::SetRect(&r, 8, 163, 190, 238);
   DrawCustomRoundRect(hDC, &r);

   ::SetRect(&r, 8, 242, 190, 322);
   DrawCustomRoundRect(hDC, &r);
}
void CMainDialog::DrawCustomRoundRect(HDC hDC, RECT *pRect)
{
   RECT r;
   HPEN hPen;

   ::SetRect(&r, pRect->left+1, pRect->top+5, pRect->right-1, pRect->bottom-4);
   ::FillRect(hDC, &r, (HBRUSH)::GetStockObject(WHITE_BRUSH));

   hPen = CreatePen(PS_SOLID, 1, RGB(255, 255, 255));
   ::SelectObject(hDC, hPen);
   ::MoveToEx(hDC, pRect->left+5, pRect->top+1, NULL); ::LineTo(hDC, pRect->right-5, pRect->top+1);
   ::MoveToEx(hDC, pRect->left+3, pRect->top+2, NULL); ::LineTo(hDC, pRect->right-3, pRect->top+2);
   ::MoveToEx(hDC, pRect->left+2, pRect->top+3, NULL); ::LineTo(hDC, pRect->right-2, pRect->top+3);
   ::MoveToEx(hDC, pRect->left+2, pRect->top+4, NULL); ::LineTo(hDC, pRect->right-2, pRect->top+4);
   ::MoveToEx(hDC, pRect->left+2, pRect->bottom-4, NULL); ::LineTo(hDC, pRect->right-2, pRect->bottom-4);
   ::MoveToEx(hDC, pRect->left+2, pRect->bottom-3, NULL); ::LineTo(hDC, pRect->right-2, pRect->bottom-3);
   ::MoveToEx(hDC, pRect->left+3, pRect->bottom-2, NULL); ::LineTo(hDC, pRect->right-3, pRect->bottom-2);
   ::MoveToEx(hDC, pRect->left+5, pRect->bottom-1, NULL); ::LineTo(hDC, pRect->right-5, pRect->bottom-1);
   ::DeleteObject(hPen);

   hPen = CreatePen(PS_SOLID, 1, RGB(235, 235, 235));
   ::SelectObject(hDC, hPen);
   ::MoveToEx(hDC, pRect->left+5, pRect->top, NULL);

   ::LineTo(hDC, pRect->right-5, pRect->top);
   ::LineTo(hDC, pRect->right-4, pRect->top+1);
   ::LineTo(hDC, pRect->right-3, pRect->top+1);
   ::LineTo(hDC, pRect->right-1, pRect->top+3);
   ::LineTo(hDC, pRect->right-1, pRect->top+4);
   ::LineTo(hDC, pRect->right,   pRect->top+5);
   ::LineTo(hDC, pRect->right,   pRect->bottom-5);
   ::LineTo(hDC, pRect->right-1, pRect->bottom-4);
   ::LineTo(hDC, pRect->right-1, pRect->bottom-3);
   ::LineTo(hDC, pRect->right-3, pRect->bottom-1);
   ::LineTo(hDC, pRect->right-4, pRect->bottom-1);
   ::LineTo(hDC, pRect->right-5, pRect->bottom);
   ::LineTo(hDC, pRect->left+5,  pRect->bottom);
   ::LineTo(hDC, pRect->left+4,  pRect->bottom-1);
   ::LineTo(hDC, pRect->left+3,  pRect->bottom-1);
   ::LineTo(hDC, pRect->left+1,  pRect->bottom-3);
   ::LineTo(hDC, pRect->left+1,  pRect->bottom-4);
   ::LineTo(hDC, pRect->left,    pRect->bottom-5);
   ::LineTo(hDC, pRect->left,    pRect->top+5);
   ::LineTo(hDC, pRect->left+1,  pRect->top+4);
   ::LineTo(hDC, pRect->left+1,  pRect->top+3);
   ::LineTo(hDC, pRect->left+3,  pRect->top+1);
   ::LineTo(hDC, pRect->left+4,  pRect->top+1);
   ::LineTo(hDC, pRect->left+5,  pRect->top);

   ::DeleteObject(hPen); 
}
void CMainDialog::DrawHoverButton(DRAWITEMSTRUCT *pDrawItem, int nResourceID)
{
   HDC hmDC;
   HBITMAP hBitmap = NULL;

   hBitmap = ::LoadBitmap(::GetModuleHandle(NULL), MAKEINTRESOURCE(nResourceID));

   if(hBitmap != NULL)
   {
      hmDC = ::CreateCompatibleDC(pDrawItem->hDC);
      ::SelectObject(hmDC, hBitmap);
      ::BitBlt(pDrawItem->hDC, 0, 0, 16, 14, hmDC, 0, 0, SRCCOPY);
      ::DeleteDC(hmDC);
      ::DeleteObject(hBitmap);
   }
}
void CMainDialog::DrawItem(DRAWITEMSTRUCT *pDrawItem)
{
   if(pDrawItem->CtlType == ODT_COMBOBOX)
   {
      if(pDrawItem->itemState & ODS_SELECTED)
      {
         RECT r;
         int i, color;
         HBRUSH hBrush = NULL;

         double dx = (pDrawItem->rcItem.right - pDrawItem->rcItem.left - 4) / 30.0;
         double dc = (255.0-220.0) / 30.0;

         for(i=0;i<=30;i++)
         {
            color = 220 + (int)(i*dc);

            ::SetRect(&r, 2+int(i*dx), pDrawItem->rcItem.top, 2+int((i+1)*dx), pDrawItem->rcItem.bottom);

            hBrush = ::CreateSolidBrush(RGB(color,color,color));
            ::FillRect(pDrawItem->hDC, &r, hBrush);
            SAFE_DELETEOBJECT(hBrush);
         }

         HPEN hPen = CreatePen(PS_SOLID, 1, RGB(255, 255, 255));
         ::SelectObject(pDrawItem->hDC, hPen);

         ::MoveToEx(pDrawItem->hDC, 2, pDrawItem->rcItem.top, NULL);
         ::LineTo(pDrawItem->hDC, 6, pDrawItem->rcItem.top);
         ::MoveToEx(pDrawItem->hDC, 2, pDrawItem->rcItem.top+1, NULL);
         ::LineTo(pDrawItem->hDC, 4, pDrawItem->rcItem.top+1);
         ::MoveToEx(pDrawItem->hDC, 2, pDrawItem->rcItem.top+2, NULL);
         ::LineTo(pDrawItem->hDC, 2, pDrawItem->rcItem.top+4);

         ::MoveToEx(pDrawItem->hDC, 2, pDrawItem->rcItem.bottom-4, NULL);
         ::LineTo(pDrawItem->hDC, 2, pDrawItem->rcItem.bottom-2);
         ::MoveToEx(pDrawItem->hDC, 2, pDrawItem->rcItem.bottom-2, NULL);
         ::LineTo(pDrawItem->hDC, 4, pDrawItem->rcItem.bottom-2);
         ::MoveToEx(pDrawItem->hDC, 2, pDrawItem->rcItem.bottom-1, NULL);
         ::LineTo(pDrawItem->hDC, 6, pDrawItem->rcItem.bottom-1);

         SAFE_DELETEOBJECT(hPen);
      }
      else
      {
         ::FillRect(pDrawItem->hDC, &pDrawItem->rcItem, (HBRUSH)GetStockObject(WHITE_BRUSH));
      }

      ::SetBkMode(pDrawItem->hDC, TRANSPARENT);
      ::SetTextColor(pDrawItem->hDC, RGB(0,0,0));

      RECT r;
      ::SetRect(&r, pDrawItem->rcItem.left+4, pDrawItem->rcItem.top, pDrawItem->rcItem.right-2, pDrawItem->rcItem.bottom);






      WCHAR awItem[256];
      ::SendMessage(pDrawItem->hwndItem, CB_GETLBTEXT, pDrawItem->itemID, (LPARAM)awItem);
      ::DrawText(pDrawItem->hDC, awItem, -1, &r, DT_LEFT | DT_VCENTER | DT_SINGLELINE);


   }






















   else if(pDrawItem->CtlType == ODT_BUTTON)
   {
      HDC hmDC;
      HBITMAP hBitmap = NULL;

      if(pDrawItem->CtlID == IDC_WAV_BUTTON || pDrawItem->CtlID == IDC_OUTFOLDER_BUTTON)
         hBitmap = ::LoadBitmap(::GetModuleHandle(NULL), MAKEINTRESOURCE(IDB_BITMAP_MAIN_SETTING));
      else if(pDrawItem->CtlID == IDC_CONTAINER_HELP)
         hBitmap = ::LoadBitmap(::GetModuleHandle(NULL), MAKEINTRESOURCE(IDB_BITMAP_MAIN_HELP));
      else if(pDrawItem->CtlID == IDC_DROPFILE_BUTTON_HELP)
         hBitmap = ::LoadBitmap(::GetModuleHandle(NULL), MAKEINTRESOURCE(IDB_BITMAP_MAIN_HELP));

      if(hBitmap != NULL)
      {
         hmDC = ::CreateCompatibleDC(pDrawItem->hDC);
         ::SelectObject(hmDC, hBitmap);

         if(pDrawItem->CtlID == IDC_WAV_BUTTON || pDrawItem->CtlID == IDC_OUTFOLDER_BUTTON)
            ::BitBlt(pDrawItem->hDC, 0, 0, 16, 14, hmDC, 0, 0, SRCCOPY);
         else if(pDrawItem->CtlID == IDC_CONTAINER_HELP)
            ::BitBlt(pDrawItem->hDC, 0, 0, 16, 16, hmDC, 0, 0, SRCCOPY);
         else 
            ::BitBlt(pDrawItem->hDC, 0, 0, 16, 16, hmDC, 0, 0, SRCCOPY);

         ::DeleteDC(hmDC);
         ::DeleteObject(hBitmap);
      }
   }
}
LRESULT CALLBACK CMainDialog::DialogWaveFormatProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{  

   switch (msg)
   {
   case WM_INITDIALOG:

      g_pMyClass->PrepareComboBox(hWnd, IDC_WAVDIALOG_COMBO1, g_localeData[g_pMyClass->m_nLanguage].wav.pwSamplingRate, ::lstrlen(g_localeData[g_pMyClass->m_nLanguage].wav.pwSamplingRate));
      g_pMyClass->PrepareComboBox(hWnd, IDC_WAVDIALOG_COMBO2, g_localeData[g_pMyClass->m_nLanguage].wav.pwBitsPerSample, ::lstrlen(g_localeData[g_pMyClass->m_nLanguage].wav.pwBitsPerSample));
      g_pMyClass->PrepareComboBox(hWnd, IDC_WAVDIALOG_COMBO3, g_localeData[g_pMyClass->m_nLanguage].wav.pwChannels, ::lstrlen(g_localeData[g_pMyClass->m_nLanguage].wav.pwChannels));

      ::SendMessage(::GetDlgItem(hWnd, IDC_WAVDIALOG_COMBO1), CB_SETITEMHEIGHT, (WPARAM)-1, (LPARAM)13);
      ::SendMessage(::GetDlgItem(hWnd, IDC_WAVDIALOG_COMBO2), CB_SETITEMHEIGHT, (WPARAM)-1, (LPARAM)13);
      ::SendMessage(::GetDlgItem(hWnd, IDC_WAVDIALOG_COMBO3), CB_SETITEMHEIGHT, (WPARAM)-1, (LPARAM)13);

      POINT p;
      RECT r1, r2;
      WINDOWPLACEMENT wndpl;

      ::SystemParametersInfo(SPI_GETWORKAREA, 0, &r1, 0);
      ::GetWindowRect(hWnd, &r2);
      ::GetWindowPlacement(::GetWindow(hWnd, GW_OWNER), &wndpl);


      p.x = wndpl.rcNormalPosition.left + 112;
      p.y = wndpl.rcNormalPosition.top + 126;

      if( (p.x + (r2.right - r2.left)) > r1.right)
         p.x = r1.right - (r2.right - r2.left);

      if( (p.y + (r2.bottom - r2.top)) > r1.bottom)
         p.y = r1.bottom - (r2.bottom - r2.top);

      if(p.x < 0)
         p.x =0;

      if(p.y < 0)
         p.y =0;

      ::SetWindowPos(hWnd, NULL, p.x, p.y, 0, 0, SWP_NOSIZE|SWP_NOZORDER);

      int n;
      WCHAR awIniFileName[MAX_PATH];

      ::GetModuleFileName(NULL, awIniFileName, MAX_PATH);
      ::PathRemoveFileSpec(awIniFileName);
      ::lstrcat(awIniFileName, L"\\EcoDecoTooL.ini");

      n = (int)::GetPrivateProfileInt(L"combo_wav", L"combo1", 8, awIniFileName);
      if(n < 0 || 13 < n) n = 8;
      ::SendMessage(::GetDlgItem(hWnd, IDC_WAVDIALOG_COMBO1), CB_SETCURSEL, (WPARAM)n, (LPARAM)0);

      n = (int)::GetPrivateProfileInt(L"combo_wav", L"combo2", 1, awIniFileName);
      if(n < 0 || 6 < n) n = 1;
      ::SendMessage(::GetDlgItem(hWnd, IDC_WAVDIALOG_COMBO2), CB_SETCURSEL, (WPARAM)n, (LPARAM)0);

      n = (int)::GetPrivateProfileInt(L"combo_wav", L"combo3", 1, awIniFileName);
      if(n < 0 || 2 < n) n = 1;
      ::SendMessage(::GetDlgItem(hWnd, IDC_WAVDIALOG_COMBO3), CB_SETCURSEL, (WPARAM)n, (LPARAM)0);

      return TRUE;

   case WM_CTLCOLORSTATIC:
      ::SetBkMode((HDC)wParam, TRANSPARENT);
      return (BOOL)(HBRUSH)GetStockObject(NULL_BRUSH);

   case WM_PAINT:
      HDC hDC;
      PAINTSTRUCT ps;
      hDC = ::BeginPaint(hWnd , &ps);

      RECT r;
      ::SetRect(&r, 4, 4, 174, 110);
      g_pMyClass->DrawCustomRoundRect(hDC, &r);

      ::EndPaint(hWnd , &ps);
		return TRUE;

   case WM_DRAWITEM:
      g_pMyClass->DrawItem((DRAWITEMSTRUCT *)lParam);
      return TRUE;

   case WM_CTLCOLORDLG:
      return (LRESULT)::CreateSolidBrush(RGB(0xc0,0xc0,0xc0));

   case WM_COMMAND:

      const int nComboSamplingrate[14] = 
         { 8000, 11025, 12000, 16000, 22050, 24000, 32000, 44100, 48000, 88200, 96000, 176400, 192000, 0};

      const int nComboBitsPerSample[7] = { 8, 16, 24, 32, 32, 64, 0};

      switch(LOWORD(wParam))
      {
      case ID_WAVDIALOG_OK:

         int nCursel;
         WCHAR awText[MAX_PATH], awFileName[MAX_PATH];

         ::GetModuleFileName(NULL, awFileName, MAX_PATH);
         ::PathRemoveFileSpec(awFileName);
         ::lstrcat(awFileName, L"\\EcoDecoTooL.ini");

         nCursel = ::SendMessage(::GetDlgItem(hWnd, IDC_WAVDIALOG_COMBO1), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
         if(nCursel < 0 || 13 < nCursel) nCursel = 8;
         ::wsprintf(awText, L"%d", nCursel);
         ::WritePrivateProfileString(L"combo_wav", L"combo1", awText, awFileName);
         g_pMyClass->m_waveFormat.nSamplesPerSec = nComboSamplingrate[nCursel];

         nCursel = ::SendMessage(::GetDlgItem(hWnd, IDC_WAVDIALOG_COMBO2), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
         if(nCursel < 0 || 6 < nCursel) nCursel = 1;
         ::wsprintf(awText, L"%d", nCursel);
         ::WritePrivateProfileString(L"combo_wav", L"combo2", awText, awFileName);
         g_pMyClass->m_waveFormat.wBitsPerSample = nComboBitsPerSample[nCursel];

         if(nCursel == 6)
            g_pMyClass->m_waveFormat.wFormatTag = 0;
         else if(nCursel == 4 || nCursel == 5)
            g_pMyClass->m_waveFormat.wFormatTag = WAVE_FORMAT_IEEE_FLOAT;
         else
            g_pMyClass->m_waveFormat.wFormatTag = WAVE_FORMAT_PCM;

         nCursel = ::SendMessage(::GetDlgItem(hWnd, IDC_WAVDIALOG_COMBO3), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
         if(nCursel < 0 || 2 < nCursel) nCursel = 1;
         ::wsprintf(awText, L"%d", nCursel);
         ::WritePrivateProfileString(L"combo_wav", L"combo3", awText, awFileName);

         if(nCursel == 0)
            g_pMyClass->m_waveFormat.nChannels = 1;
         else if(nCursel == 1)
            g_pMyClass->m_waveFormat.nChannels = 2;
         else 
            g_pMyClass->m_waveFormat.nChannels = 0;

         ::EndDialog(hWnd, IDOK);
         return TRUE;
      case ID_WAVDIALOG_CANCEL:
         ::EndDialog(hWnd, IDCANCEL);
         return TRUE;
      case IDCANCEL:
         ::EndDialog(hWnd, IDCANCEL);
         return TRUE;
      }
   }

	return FALSE;
}
LRESULT CALLBACK CMainDialog::CustomProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{  

   int nIndex;

   for(nIndex=0;nIndex<sizeof_MYPROC;nIndex++)
   {
      if(g_pMyClass->m_myProc[nIndex].nResourceID == ::GetDlgCtrlID(hWnd))
         break;
   }

   switch(msg)
   {
   case WM_SETCURSOR:

      if(g_pMyClass->m_myProc[nIndex].nItemType == DIALOG_BUTTON || g_pMyClass->m_myProc[nIndex].nItemType == DIALOG_LINKLABEL)
      {  
         ::SetCursor(::LoadCursor(NULL, MAKEINTRESOURCE(32649)));
	      return 0;
      }

      break;

   case WM_CHAR:

      if(g_pMyClass->m_myProc[nIndex].nItemType == DIALOG_EDITBOX)
      {
         WCHAR awText[32];
         ::GetWindowText(hWnd, awText, 32);

         if(::lstrlen(awText) >= 5)
            return 0;

         if(wParam == VK_BACK || wParam == VK_DELETE || wParam == '.' || ('0' <= wParam && wParam <= '9'))
            break;
         else
            return 0;
      }

      break;

   case WM_MOUSEMOVE:

      if(wParam != MK_LBUTTON)
      {
         if(g_pMyClass->m_myProc[nIndex].nResourceID == IDC_BUTTON_MAIN_MIN || g_pMyClass->m_myProc[nIndex].nResourceID == IDC_BUTTON_MAIN_CLOSE)
         {
            TRACKMOUSEEVENT tme;
            tme.cbSize = sizeof(tme);
            tme.dwFlags = TME_LEAVE;
            tme.hwndTrack = hWnd;
            ::TrackMouseEvent(&tme);

            if(g_pMyClass->m_myProc[nIndex].nResourceID == IDC_BUTTON_MAIN_MIN)
            {
               if(g_pMyClass->m_nMinResourceID != IDB_BITMAP_MAIN_MIN2)
               {
                  g_pMyClass->m_nMinResourceID = IDB_BITMAP_MAIN_MIN2;
                  ::InvalidateRect(hWnd, NULL, FALSE);
                  ::UpdateWindow(hWnd);
               }
            }
            else if(g_pMyClass->m_myProc[nIndex].nResourceID == IDC_BUTTON_MAIN_CLOSE)
            {
               if(g_pMyClass->m_nCloseResourceID != IDB_BITMAP_MAIN_CLOSE2)
               {
                  g_pMyClass->m_nCloseResourceID = IDB_BITMAP_MAIN_CLOSE2;
                  ::InvalidateRect(hWnd, NULL, FALSE);
                  ::UpdateWindow(hWnd);
               }
            }
         }
      }

      break;

   case WM_MOUSELEAVE:

      if(g_pMyClass->m_myProc[nIndex].nResourceID == IDC_BUTTON_MAIN_MIN)
      {
         if(g_pMyClass->m_nMinResourceID != IDB_BITMAP_MAIN_MIN1)
         {
            g_pMyClass->m_nMinResourceID = IDB_BITMAP_MAIN_MIN1;
            ::InvalidateRect(hWnd, NULL, FALSE);
            ::UpdateWindow(hWnd);
         }
      }
      else if(g_pMyClass->m_myProc[nIndex].nResourceID == IDC_BUTTON_MAIN_CLOSE)
      {
         if(g_pMyClass->m_nCloseResourceID != IDB_BITMAP_MAIN_CLOSE1)
         {
            g_pMyClass->m_nCloseResourceID = IDB_BITMAP_MAIN_CLOSE1;
            ::InvalidateRect(hWnd, NULL, FALSE);
            ::UpdateWindow(hWnd);
         }
      }

      break;

   case WM_LBUTTONDOWN:

      if(g_pMyClass->m_myProc[nIndex].nResourceID == IDC_BUTTON_MAIN_MIN)
      {
         if(g_pMyClass->m_nMinResourceID != IDB_BITMAP_MAIN_MIN3)
         {
            g_pMyClass->m_nMinResourceID = IDB_BITMAP_MAIN_MIN3;
            ::InvalidateRect(hWnd, NULL, FALSE);
            ::UpdateWindow(hWnd);
         }
      }
      else if(g_pMyClass->m_myProc[nIndex].nResourceID == IDC_BUTTON_MAIN_CLOSE)
      {
         if(g_pMyClass->m_nCloseResourceID != IDB_BITMAP_MAIN_CLOSE3)
         {
            g_pMyClass->m_nCloseResourceID = IDB_BITMAP_MAIN_CLOSE3;
            ::InvalidateRect(hWnd, NULL, FALSE);
            ::UpdateWindow(hWnd);
         }
      }
      else if(g_pMyClass->m_myProc[nIndex].nResourceID == IDC_WAV_BUTTON)
      {

      }
      else if(g_pMyClass->m_myProc[nIndex].nResourceID == IDC_OUTFOLDER_BUTTON)
      {

      }
      else if(g_pMyClass->m_myProc[nIndex].nItemType == DIALOG_LINKLABEL)
      {  
         HRESULT hr;
         DWORD dwOut = MAX_PATH + 10;
         WCHAR awExeFileName[MAX_PATH + 10], awHtmlFileName[MAX_PATH + 10], awParameters[MAX_PATH + 10];

         hr = ::AssocQueryString(ASSOCF_NOTRUNCATE, ASSOCSTR_EXECUTABLE, L".html", L"open", awExeFileName, &dwOut);

         if(SUCCEEDED(hr))
         {
            ::GetModuleFileName(NULL, awHtmlFileName, MAX_PATH);
            ::PathRemoveFileSpec(awHtmlFileName);
            ::lstrcat(awHtmlFileName, L"/html/help.html");

            if(g_pMyClass->m_myProc[nIndex].nResourceID == IDC_CONTAINER_HELP)
            {
               int n;
               n = ::SendMessage(::GetDlgItem(::GetParent(hWnd), IDC_COMBO_CONTAINER), CB_GETCURSEL, 0, 0);

               switch(n)
               {
               case 0:  ::lstrcat(awHtmlFileName, L"#container_wav"); break;
               case 1:  ::lstrcat(awHtmlFileName, L"#container_aac"); break;
               case 2:  ::lstrcat(awHtmlFileName, L"#container_fraunhofer"); break;
               case 3:  ::lstrcat(awHtmlFileName, L"#container_lame"); break;
               case 4:  ::lstrcat(awHtmlFileName, L"#container_ogg"); break;
               default: ::lstrcat(awHtmlFileName, L"#container_raw"); break;
               }
            }
            else if(g_pMyClass->m_myProc[nIndex].nResourceID == IDC_DROPFILE_BUTTON_HELP)
               ::lstrcat(awHtmlFileName, L"#dropfile");
            else if(g_pMyClass->m_myProc[nIndex].nResourceID == IDC_AAC_STATIC_CODEC)
               ::lstrcat(awHtmlFileName, L"#container_aac");
            else if(g_pMyClass->m_myProc[nIndex].nResourceID == IDC_FRAUNHOFER_STATIC_CODEC)
               ::lstrcat(awHtmlFileName, L"#container_fraunhofer");
            else
               ::lstrcat(awHtmlFileName, L"#container_lame");

            ::wsprintf(awParameters, L"file://%s", awHtmlFileName);

            ::ShellExecute(NULL, NULL, awExeFileName, awParameters, NULL, SW_SHOWNORMAL);
         }
      }

      break;

   case WM_LBUTTONUP:

      if(g_pMyClass->m_myProc[nIndex].nResourceID == IDC_BUTTON_MAIN_MIN)
      {
         if(0 <= LOWORD(lParam) && LOWORD(lParam) < 11 && 0 <= HIWORD(lParam) && HIWORD(lParam) < 11)
            ::ShowWindow(::GetParent(hWnd), SW_MINIMIZE);
      }
      else if(g_pMyClass->m_myProc[nIndex].nResourceID == IDC_BUTTON_MAIN_CLOSE)
      {
         if(0 <= LOWORD(lParam) && LOWORD(lParam) < 11 && 0 <= HIWORD(lParam) && HIWORD(lParam) < 11)
         {
            g_pMyClass->OnClose(::GetParent(hWnd));
            ::EndDialog(::GetParent(hWnd), IDCANCEL);
            return 0;
         }
      }

      break;
   }

   return ::CallWindowProc(g_pMyClass->m_myProc[nIndex].proc, hWnd , msg , wParam , lParam);
}
LRESULT CALLBACK CMainDialog::DialogProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
   switch (msg)
   {
   case WM_INITDIALOG:
      g_pMyClass->OnCreate(hWnd);

      ::SetLayeredWindowAttributes(hWnd, 0, 0, LWA_ALPHA);
      ::SetTimer(hWnd, ID_MYTIMER, 50, NULL);
      return TRUE;

   case WM_PAINT:

      HDC hDC;
      PAINTSTRUCT ps;
      hDC = ::BeginPaint(hWnd , &ps);
      g_pMyClass->OnPaint(hDC);

      ::EndPaint(hWnd , &ps);
      return TRUE;

   case WM_LBUTTONDOWN:

      if(LOWORD(lParam) < 165 && HIWORD(lParam) <= 20)
      {  

         ::PostMessage(hWnd, WM_NCLBUTTONDOWN, HTCAPTION, lParam);
      }

      return TRUE;

   case WM_TIMER:
      if(wParam == ID_MYTIMER)
      {  

         g_pMyClass->m_nAlpha += 32;
         if(g_pMyClass->m_nAlpha >= 255)
         {
            g_pMyClass->m_nAlpha = 255;
            ::KillTimer(hWnd, ID_MYTIMER);
         }

         ::SetLayeredWindowAttributes(hWnd, 0, (BYTE)g_pMyClass->m_nAlpha, LWA_ALPHA);
      }

		return TRUE;

   case WM_COMMAND:

      if(LOWORD(wParam) == IDC_OUTFOLDER_BUTTON)
      {
         g_pMyClass->SelectFolder(hWnd);
         ::InvalidateRect(hWnd, NULL, TRUE);
         return TRUE;
      }
      if(LOWORD(wParam) == IDC_WAV_BUTTON)
      {
         ::DialogBox(::GetModuleHandle(NULL), MAKEINTRESOURCE(g_localeData[g_pMyClass->m_nLanguage].nDialogID[1]), hWnd, (DLGPROC)DialogWaveFormatProc);

         WCHAR awTmp[32], awText[64];

         awText[0] = '\0';
         if(g_pMyClass->m_waveFormat.nSamplesPerSec != 0)
         {
            ::wsprintf(awTmp, L"%3d,%03dHz", g_pMyClass->m_waveFormat.nSamplesPerSec/1000, g_pMyClass->m_waveFormat.nSamplesPerSec%1000);
            ::lstrcpy(awText, awTmp);

            ::SetDlgItemText(hWnd, IDC_WAV_STATIC_FORMAT1, awText);
         }

         awText[0] = '\0';
         if(g_pMyClass->m_waveFormat.wBitsPerSample != 0)
         {
            ::wsprintf(awTmp, L" %2dbit", g_pMyClass->m_waveFormat.wBitsPerSample);
            ::lstrcat(awText, awTmp);
         }

         if(g_pMyClass->m_waveFormat.nChannels == 1)
            ::lstrcat(awText, L" 1ch");
         else if(g_pMyClass->m_waveFormat.nChannels == 2)
            ::lstrcat(awText, L" 2ch");

         if(g_pMyClass->m_waveFormat.nSamplesPerSec == 0)
         {
            ::SetDlgItemText(hWnd, IDC_WAV_STATIC_FORMAT1, awText);
            ::SetDlgItemText(hWnd, IDC_WAV_STATIC_FORMAT2, L"");
         }
         else
            ::SetDlgItemText(hWnd, IDC_WAV_STATIC_FORMAT2, awText);

         ::InvalidateRect(hWnd, NULL, TRUE);

         return TRUE;
      }
      else if(LOWORD(wParam) == IDC_COMBO_CONTAINER)
      {
         if(HIWORD(wParam) == CBN_SELCHANGE)
            g_pMyClass->SelectContainer(hWnd, ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_CONTAINER), CB_GETCURSEL, 0, 0));

         return TRUE;
      }
      else if(LOWORD(wParam) == IDC_AAC_COMBO_MODE || LOWORD(wParam) == IDC_FRAUNHOFER_COMBO_MODE || LOWORD(wParam) == IDC_LAME_COMBO_MODE ||
              LOWORD(wParam) == IDC_OGG_COMBO_MODE || LOWORD(wParam) == IDC_WMA_COMBO_MODE)
      {
         if(HIWORD(wParam) == CBN_SELCHANGE)
            g_pMyClass->SelectMode(hWnd, LOWORD(wParam), ::SendMessage(::GetDlgItem(hWnd, LOWORD(wParam)), CB_GETCURSEL, 0, 0));

         return TRUE;
      }
      else if(LOWORD(wParam) == IDC_WAV_COMBO_GAIN || LOWORD(wParam) == IDC_AAC_COMBO_GAIN || LOWORD(wParam) == IDC_FRAUNHOFER_COMBO_GAIN ||
              LOWORD(wParam) == IDC_LAME_COMBO_GAIN || LOWORD(wParam) == IDC_OGG_COMBO_GAIN)
      {
         if(HIWORD(wParam) == CBN_SELCHANGE)
         {
            int nCmdShow;

            if(::SendMessage(::GetDlgItem(hWnd, LOWORD(wParam)), CB_GETCURSEL, (WPARAM)0, (LPARAM)0) == 0)
               nCmdShow = SW_HIDE;
            else
               nCmdShow = SW_SHOW;

            if(LOWORD(wParam) == IDC_WAV_COMBO_GAIN)
            {
               ::ShowWindow(::GetDlgItem(hWnd, IDC_WAV_EDIT_GAIN), nCmdShow);
               ::ShowWindow(::GetDlgItem(hWnd, IDC_WAV_STATIC_DB), nCmdShow);
            }
            else if(LOWORD(wParam) == IDC_AAC_COMBO_GAIN)
            {
               ::ShowWindow(::GetDlgItem(hWnd, IDC_AAC_EDIT_GAIN), nCmdShow);
               ::ShowWindow(::GetDlgItem(hWnd, IDC_AAC_STATIC_DB), nCmdShow);
            }
            else if(LOWORD(wParam) == IDC_FRAUNHOFER_COMBO_GAIN)
            {
               ::ShowWindow(::GetDlgItem(hWnd, IDC_FRAUNHOFER_EDIT_GAIN), nCmdShow);
               ::ShowWindow(::GetDlgItem(hWnd, IDC_FRAUNHOFER_STATIC_DB), nCmdShow);
            }
            else if(LOWORD(wParam) == IDC_LAME_COMBO_GAIN)
            {
               ::ShowWindow(::GetDlgItem(hWnd, IDC_LAME_EDIT_GAIN), nCmdShow);
               ::ShowWindow(::GetDlgItem(hWnd, IDC_LAME_STATIC_DB), nCmdShow);
            }
            else if(LOWORD(wParam) == IDC_OGG_COMBO_GAIN)
            {
               ::ShowWindow(::GetDlgItem(hWnd, IDC_OGG_EDIT_GAIN), nCmdShow);
               ::ShowWindow(::GetDlgItem(hWnd, IDC_OGG_STATIC_DB), nCmdShow);
            }

            return TRUE;
         }
      }

   	return FALSE;

   case WM_DRAWITEM:


      if(wParam == IDC_BUTTON_MAIN_MIN)
         g_pMyClass->DrawHoverButton((DRAWITEMSTRUCT *)lParam, g_pMyClass->m_nMinResourceID);
      else if(wParam == IDC_BUTTON_MAIN_CLOSE)
         g_pMyClass->DrawHoverButton((DRAWITEMSTRUCT *)lParam, g_pMyClass->m_nCloseResourceID);
      else
         g_pMyClass->DrawItem((DRAWITEMSTRUCT *)lParam);

		return TRUE;

   case WM_CTLCOLORSTATIC:

      if((HWND)lParam == ::GetDlgItem(hWnd, IDC_AAC_STATIC_CODEC) ||
         (HWND)lParam == ::GetDlgItem(hWnd, IDC_FRAUNHOFER_STATIC_CODEC) ||
         (HWND)lParam == ::GetDlgItem(hWnd, IDC_LAME_STATIC_CODEC))
      {  
         HFONT hFont = ::CreateFont(11,0,0,0,FW_DONTCARE,FALSE,TRUE,FALSE,SHIFTJIS_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH | FF_DONTCARE,NULL);
         ::SelectObject((HDC)wParam, hFont);
         ::DeleteObject(hFont);
         ::SetTextColor((HDC)wParam, RGB(0x00, 0x00, 0xff));
         return (BOOL)(HBRUSH)GetStockObject(WHITE_BRUSH);
      }

      ::SetBkMode((HDC)wParam, TRANSPARENT);
      return (BOOL)(HBRUSH)GetStockObject(NULL_BRUSH);

   case WM_DROPFILES:

      bool flag;
      flag = g_pMyClass->DropFiles(hWnd, (HDROP)wParam);
      ::DragFinish((HDROP)wParam);

      if(flag == true)
      {
         flag = g_pMyClass->GetSettingData(hWnd);
         if(flag == true)
         {
            ::SendMessage(hWnd, WM_CLOSE, 0, 0);
         }
      }

      return TRUE;

   case WM_DESTROY:

      int i;
      for(i=0;i<sizeof_MYPROC;i++)
      {
         if(g_pMyClass->m_myProc[i].proc != NULL)
            ::SetWindowLong(::GetDlgItem(hWnd, g_pMyClass->m_myProc[i].nResourceID), GWL_WNDPROC, (LONG)g_pMyClass->m_myProc[i].proc);
      }

      return TRUE;

   case WM_CLOSE:
      g_pMyClass->OnClose(hWnd);
      ::EndDialog(hWnd ,IDOK);
      return TRUE;
   }

	return FALSE;
}
bool CMainDialog::ShowDialog(CONVERTDATA *pConvertData, int nLanguage)
{

   m_nLanguage = nLanguage;

   ::DialogBox(::GetModuleHandle(NULL), MAKEINTRESOURCE(g_localeData[m_nLanguage].nDialogID[0]), NULL,(DLGPROC)DialogProc);


   if((int)m_convertData.dropList.size() == 0)
      return false;

   pConvertData->nContainerType = m_convertData.nContainerType;
   pConvertData->nOutputFolder  = m_convertData.nOutputFolder;
   ::lstrcpy(pConvertData->awOutputFolder, m_convertData.awOutputFolder);

   ::CopyMemory(&pConvertData->wf, &m_convertData.wf, sizeof(m_convertData.wf));
   pConvertData->nEncodeMode = m_convertData.nEncodeMode;
   pConvertData->nAdvancedMode = m_convertData.nAdvancedMode;
   pConvertData->nABRCBR = m_convertData.nABRCBR;
   pConvertData->nVBR = m_convertData.nVBR;
   pConvertData->fVBR = m_convertData.fVBR;

   pConvertData->nPass = m_convertData.nPass;

   pConvertData->nGainMode = m_convertData.nGainMode;
   pConvertData->dGain = m_convertData.dGain;

   for(int i=0;i<(int)m_convertData.dropList.size();i++)
      pConvertData->dropList.push_back(m_convertData.dropList[i]);


   return true;
}
