/**************************************************************************
 * Copyright (C) 2008 Cocha                                               *
 * http://sourceforge.jp/projects/ecodecotool/                            *
 *                                                                        *
 *  This Program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2, or (at your option)   *
 *  any later version.                                                    *
 *                                                                        *
 *  This Program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with GNU Make; see the file COPYING.  If not, write to          *
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. *
 *                                                                        *
 **************************************************************************/

#include "EcoDecoTooL.h"

static const DWORD crc_lookup[256] =
{
   0x00000000,0x04c11db7,0x09823b6e,0x0d4326d9,
   0x130476dc,0x17c56b6b,0x1a864db2,0x1e475005,
   0x2608edb8,0x22c9f00f,0x2f8ad6d6,0x2b4bcb61,
   0x350c9b64,0x31cd86d3,0x3c8ea00a,0x384fbdbd,
   0x4c11db70,0x48d0c6c7,0x4593e01e,0x4152fda9,
   0x5f15adac,0x5bd4b01b,0x569796c2,0x52568b75,
   0x6a1936c8,0x6ed82b7f,0x639b0da6,0x675a1011,
   0x791d4014,0x7ddc5da3,0x709f7b7a,0x745e66cd,
   0x9823b6e0,0x9ce2ab57,0x91a18d8e,0x95609039,
   0x8b27c03c,0x8fe6dd8b,0x82a5fb52,0x8664e6e5,
   0xbe2b5b58,0xbaea46ef,0xb7a96036,0xb3687d81,
   0xad2f2d84,0xa9ee3033,0xa4ad16ea,0xa06c0b5d,
   0xd4326d90,0xd0f37027,0xddb056fe,0xd9714b49,
   0xc7361b4c,0xc3f706fb,0xceb42022,0xca753d95,
   0xf23a8028,0xf6fb9d9f,0xfbb8bb46,0xff79a6f1,
   0xe13ef6f4,0xe5ffeb43,0xe8bccd9a,0xec7dd02d,
   0x34867077,0x30476dc0,0x3d044b19,0x39c556ae,
   0x278206ab,0x23431b1c,0x2e003dc5,0x2ac12072,
   0x128e9dcf,0x164f8078,0x1b0ca6a1,0x1fcdbb16,
   0x018aeb13,0x054bf6a4,0x0808d07d,0x0cc9cdca,
   0x7897ab07,0x7c56b6b0,0x71159069,0x75d48dde,
   0x6b93dddb,0x6f52c06c,0x6211e6b5,0x66d0fb02,
   0x5e9f46bf,0x5a5e5b08,0x571d7dd1,0x53dc6066,
   0x4d9b3063,0x495a2dd4,0x44190b0d,0x40d816ba,
   0xaca5c697,0xa864db20,0xa527fdf9,0xa1e6e04e,
   0xbfa1b04b,0xbb60adfc,0xb6238b25,0xb2e29692,
   0x8aad2b2f,0x8e6c3698,0x832f1041,0x87ee0df6,
   0x99a95df3,0x9d684044,0x902b669d,0x94ea7b2a,
   0xe0b41de7,0xe4750050,0xe9362689,0xedf73b3e,
   0xf3b06b3b,0xf771768c,0xfa325055,0xfef34de2,
   0xc6bcf05f,0xc27dede8,0xcf3ecb31,0xcbffd686,
   0xd5b88683,0xd1799b34,0xdc3abded,0xd8fba05a,
   0x690ce0ee,0x6dcdfd59,0x608edb80,0x644fc637,
   0x7a089632,0x7ec98b85,0x738aad5c,0x774bb0eb,
   0x4f040d56,0x4bc510e1,0x46863638,0x42472b8f,
   0x5c007b8a,0x58c1663d,0x558240e4,0x51435d53,
   0x251d3b9e,0x21dc2629,0x2c9f00f0,0x285e1d47,
   0x36194d42,0x32d850f5,0x3f9b762c,0x3b5a6b9b,
   0x0315d626,0x07d4cb91,0x0a97ed48,0x0e56f0ff,
   0x1011a0fa,0x14d0bd4d,0x19939b94,0x1d528623,
   0xf12f560e,0xf5ee4bb9,0xf8ad6d60,0xfc6c70d7,
   0xe22b20d2,0xe6ea3d65,0xeba91bbc,0xef68060b,
   0xd727bbb6,0xd3e6a601,0xdea580d8,0xda649d6f,
   0xc423cd6a,0xc0e2d0dd,0xcda1f604,0xc960ebb3,
   0xbd3e8d7e,0xb9ff90c9,0xb4bcb610,0xb07daba7,
   0xae3afba2,0xaafbe615,0xa7b8c0cc,0xa379dd7b,
   0x9b3660c6,0x9ff77d71,0x92b45ba8,0x9675461f,
   0x8832161a,0x8cf30bad,0x81b02d74,0x857130c3,
   0x5d8a9099,0x594b8d2e,0x5408abf7,0x50c9b640,
   0x4e8ee645,0x4a4ffbf2,0x470cdd2b,0x43cdc09c,
   0x7b827d21,0x7f436096,0x7200464f,0x76c15bf8,
   0x68860bfd,0x6c47164a,0x61043093,0x65c52d24,
   0x119b4be9,0x155a565e,0x18197087,0x1cd86d30,
   0x029f3d35,0x065e2082,0x0b1d065b,0x0fdc1bec,
   0x3793a651,0x3352bbe6,0x3e119d3f,0x3ad08088,
   0x2497d08d,0x2056cd3a,0x2d15ebe3,0x29d4f654,
   0xc5a92679,0xc1683bce,0xcc2b1d17,0xc8ea00a0,
   0xd6ad50a5,0xd26c4d12,0xdf2f6bcb,0xdbee767c,
   0xe3a1cbc1,0xe760d676,0xea23f0af,0xeee2ed18,
   0xf0a5bd1d,0xf464a0aa,0xf9278673,0xfde69bc4,
   0x89b8fd09,0x8d79e0be,0x803ac667,0x84fbdbd0,
   0x9abc8bd5,0x9e7d9662,0x933eb0bb,0x97ffad0c,
   0xafb010b1,0xab710d06,0xa6322bdf,0xa2f33668,
   0xbcb4666d,0xb8757bda,0xb5365d03,0xb1f740b4
};
void CReplayGain::GetCRC32(DWORD *crc, BYTE *pData, int nArraySize)
{
   for(int i=0;i<nArraySize;i++)
      *crc = (*crc << 8)^crc_lookup[((*crc >> 24)&0xff)^pData[i]];
}
HRESULT CReplayGain::WriteID3v2Tag(HANDLE hFile, int nGainMode, double dAlbumPeak, double dAlbumGain, double dTrackPeak, double dTrackGain)
{  

   char szText[32];
   DWORD dwWritten, dwBufferSize;
   BYTE id3Header[10], gainHeader[11], peakHeader[11], buffer[2176];

   ::SetFilePointer(hFile, 0, NULL, FILE_BEGIN);

   id3Header[0]=0x49; id3Header[1]=0x44; id3Header[2]=0x33; 
   id3Header[3]=0x03; id3Header[4]=0x00;                    
   id3Header[5]=0x80;                                       

   id3Header[6]=0x00; id3Header[7]=0x00; id3Header[8]=0x11; id3Header[9]=0x28; 
   ::WriteFile(hFile, id3Header, 10, &dwWritten, NULL);

   gainHeader[0]=0x54; gainHeader[1]=0x58; gainHeader[2]=0x58; gainHeader[3]=0x58; 
   gainHeader[4]=0x00; gainHeader[5]=0x00; gainHeader[6]=0x00; gainHeader[7]=0x26; 
   gainHeader[8]=0x00; gainHeader[9]=0x00;                                         
   gainHeader[10]=0x03;                                                            

   peakHeader[0]=0x54; peakHeader[1]=0x58; peakHeader[2]=0x58; peakHeader[3]=0x58; 
   peakHeader[4]=0x00; peakHeader[5]=0x00; peakHeader[6]=0x00; peakHeader[7]=0x22; 
   peakHeader[8]=0x00; peakHeader[9]=0x00;                                         
   peakHeader[10]=0x03;                                                            

   if(nGainMode == GAIN_ALBUMGAIN)
   {
      ::WriteFile(hFile, gainHeader, 11, &dwWritten, NULL);
       
      ::lstrcpyA(szText, "replaygain_album_gain");
      ::WriteFile(hFile, szText, ::lstrlenA(szText), &dwWritten, NULL);

      ::WriteFile(hFile, "\0", 1, &dwWritten, NULL);

      sprintf_s(szText, 32, "%+.8f", dAlbumGain);
      szText[11] = ' '; szText[12] = 'd'; szText[13] = 'B'; szText[14] = '\0';
      ::WriteFile(hFile, szText, ::lstrlenA(szText), &dwWritten, NULL);

      ::WriteFile(hFile, "\0", 1, &dwWritten, NULL);
       
      ::WriteFile(hFile, peakHeader, 11, &dwWritten, NULL);
       
      ::lstrcpyA(szText, "replaygain_album_peak");
      ::WriteFile(hFile, szText, ::lstrlenA(szText), &dwWritten, NULL);
       
      ::WriteFile(hFile, "\0", 1, &dwWritten, NULL);

      sprintf_s(szText, 32, "%.8f", dAlbumPeak);
      szText[10] = '\0';
      ::WriteFile(hFile, szText, ::lstrlenA(szText), &dwWritten, NULL);
       
      ::WriteFile(hFile, "\0", 1, &dwWritten, NULL);
   }

   ::WriteFile(hFile, gainHeader, 11, &dwWritten, NULL);

   ::lstrcpyA(szText, "replaygain_track_gain");
   ::WriteFile(hFile, szText, ::lstrlenA(szText), &dwWritten, NULL);

   ::WriteFile(hFile, "\0", 1, &dwWritten, NULL);

   sprintf_s(szText, 32, "%+.8f", dTrackGain);
   szText[11] = ' '; szText[12] = 'd'; szText[13] = 'B'; szText[14] = '\0';
   ::WriteFile(hFile, szText, ::lstrlenA(szText), &dwWritten, NULL);

   ::WriteFile(hFile, "\0", 1, &dwWritten, NULL);

   ::WriteFile(hFile, peakHeader, 11, &dwWritten, NULL);

   ::lstrcpyA(szText, "replaygain_track_peak");
   ::WriteFile(hFile, szText, ::lstrlenA(szText), &dwWritten, NULL);

   ::WriteFile(hFile, "\0", 1, &dwWritten, NULL);

   sprintf_s(szText, 32, "%.8f", dTrackPeak);
   szText[10] = '\0';
   ::WriteFile(hFile, szText, ::lstrlenA(szText), &dwWritten, NULL);

   ::WriteFile(hFile, "\0", 1, &dwWritten, NULL);


   if(nGainMode == GAIN_ALBUMGAIN)
      dwBufferSize = 2032;
   else
      dwBufferSize = 2124;

   ::ZeroMemory(buffer, dwBufferSize);
   ::WriteFile(hFile, buffer, dwBufferSize, &dwWritten, NULL);

   return S_OK;
}
HRESULT CReplayGain::OverWriteMp3AlbumGain(WCHAR *pwFileName, double dAlbumPeak, double dAlbumGain)
{
   HANDLE hFile = NULL;
   char szText[32];
   DWORD dwWritten;

   hFile = ::CreateFile(pwFileName, GENERIC_READ|GENERIC_WRITE, 0, NULL, OPEN_EXISTING, (DWORD)0, NULL);
   if(hFile == NULL) return E_FAIL;
   if(hFile == (HANDLE)0xffffffff) return E_FAIL;

   ::SetFilePointer(hFile, 43, NULL, FILE_BEGIN);
   sprintf_s(szText, 32, "%+.8f", dAlbumGain);
   szText[11] = ' '; szText[12] = 'd'; szText[13] = 'B'; szText[14] = '\0';
   ::WriteFile(hFile, szText, ::lstrlenA(szText), &dwWritten, NULL);

   ::SetFilePointer(hFile, 91, NULL, FILE_BEGIN);
   sprintf_s(szText, 32, "%.8f", dAlbumPeak);
   szText[10] = '\0';
   ::WriteFile(hFile, szText, ::lstrlenA(szText), &dwWritten, NULL);
       
   ::CloseHandle(hFile);
   return S_OK;
}
HRESULT CReplayGain::WriteLame(WCHAR *pwFileName, int nGainMode, double dAlbumPeak, double dAlbumGain, double dTrackPeak, double dTrackGain)
{  

   HANDLE hFile = NULL;
   BYTE buffer[2226];
   int nReadSize, nRestSize;
   DWORD dwNumberOfBytesRead, dwNumberOfBytesWrite;

   hFile = ::CreateFile(pwFileName, GENERIC_READ|GENERIC_WRITE, 0, NULL, OPEN_EXISTING, (DWORD)0, NULL);
   if(hFile == NULL) return E_FAIL;
   if(hFile == (HANDLE)0xffffffff) return E_FAIL;

   nRestSize = (int)::GetFileSize(hFile, NULL);

   while(0 < nRestSize)
   {
      if(2226 < nRestSize)
         nReadSize = 2226;
      else
         nReadSize = nRestSize;

      ::SetFilePointer(hFile, nRestSize - nReadSize, NULL, FILE_BEGIN);
      ::ReadFile(hFile, buffer, nReadSize, &dwNumberOfBytesRead, NULL);
      if(dwNumberOfBytesRead != nReadSize)
         goto error;

      ::SetFilePointer(hFile, nRestSize - nReadSize + 2226, NULL, FILE_BEGIN);
      ::WriteFile(hFile, buffer, nReadSize, &dwNumberOfBytesWrite, NULL);
      if(dwNumberOfBytesWrite != nReadSize)
         goto error;

      nRestSize -= nReadSize;
   }

   WriteID3v2Tag(hFile, nGainMode, dAlbumPeak, dAlbumGain, dTrackPeak, dTrackGain);

   ::CloseHandle(hFile);
   return S_OK;

error:

   if(hFile != NULL)
      ::CloseHandle(hFile);

   return E_FAIL;
}
HRESULT CReplayGain::WriteFraunhofer(WCHAR *pwFileName, int nGainMode, double dAlbumPeak, double dAlbumGain, double dTrackPeak, double dTrackGain)
{  

   HANDLE hFile = NULL;

   hFile = ::CreateFile(pwFileName, GENERIC_READ|GENERIC_WRITE, 0, NULL, OPEN_EXISTING, (DWORD)0, NULL);
   if(hFile == NULL) return E_FAIL;
   if(hFile == (HANDLE)0xffffffff) return E_FAIL;

   WriteID3v2Tag(hFile, nGainMode, dAlbumPeak, dAlbumGain, dTrackPeak, dTrackGain);

   ::CloseHandle(hFile);
   return S_OK;
}
HRESULT CReplayGain::WriteWav(WCHAR *pwFileName, int nGainMode, double dPeak, double dGain)
{  


   HANDLE hFile = NULL;
   DWORD dwNumberOfBytesWrite;
   short sData;
   float fData;

   hFile = ::CreateFile(pwFileName, GENERIC_READ|GENERIC_WRITE, 0, NULL, OPEN_EXISTING, (DWORD)0, NULL);
   if(hFile == NULL) return E_FAIL;
   if(hFile == (HANDLE)0xffffffff) return E_FAIL;

   if(nGainMode == GAIN_TRACKGAIN)
   {  

      ::SetFilePointer(hFile, 44, NULL, FILE_BEGIN);

      fData = (float)dPeak;
      ::WriteFile(hFile, &fData, 4, &dwNumberOfBytesWrite, NULL);
      if(dwNumberOfBytesWrite != 4)
         goto error;

      sData = 0;
      ::WriteFile(hFile, &sData, 2, &dwNumberOfBytesWrite, NULL);
      if(dwNumberOfBytesWrite != 2)
         goto error;

      if(dGain < 0)
      {
         if(dGain < -51.0)
            dGain = -51.0;

         sData = 0x4a00 | (short)(-dGain * 10.0);
      }
      else
      {
         if(51.0 < dGain)
            dGain = 51.0;

         sData = 0x4800 | (short)(dGain * 10.0);
      }

      ::WriteFile(hFile, &sData, 2, &dwNumberOfBytesWrite, NULL);
      if(dwNumberOfBytesWrite != 2)
         goto error;
   }
   else 
   {
      ::SetFilePointer(hFile, 48, NULL, FILE_BEGIN);

      if(dGain < 0)
      {
         if(dGain < -51.0)
            dGain = -51.0;

         sData = 0x2a00 | (short)(-dGain * 10.0);
      }
      else
      {
         if(51.0 < dGain)
            dGain = 51.0;

         sData = 0x2800 | (short)(dGain * 10.0);
      }

      ::WriteFile(hFile, &sData, 2, &dwNumberOfBytesWrite, NULL);
      if(dwNumberOfBytesWrite != 2)
         goto error;
   }

   ::CloseHandle(hFile);
   return S_OK;

error:

   if(hFile != NULL)
      ::CloseHandle(hFile);

   return E_FAIL;
}
HRESULT CReplayGain::WriteOgg(WCHAR *pwFileName, int nGainMode, double dPeak, double dGain)
{  
   HANDLE hFile = NULL;
   DWORD dwRead, crc = 0;
   int i, j, nCrcPosition, nVorbisPacketSize;
   char szText[64];
   BYTE buffer[320];

   hFile = ::CreateFile(pwFileName, GENERIC_READ|GENERIC_WRITE, 0, NULL, OPEN_EXISTING, (DWORD)0, NULL);
   if(hFile == NULL) return E_FAIL;
   if(hFile == (HANDLE)0xffffffff) return E_FAIL;

   ::SetFilePointer(hFile, 0, NULL, FILE_BEGIN);

   ::ReadFile(hFile, &buffer[0], 27, &dwRead, NULL);
   ::ReadFile(hFile, &buffer[27], buffer[26], &dwRead, NULL);

   nVorbisPacketSize = 0;
   for(i=0;i<buffer[26];i++)
      nVorbisPacketSize += buffer[27 + i];

   ::SetFilePointer(hFile, nVorbisPacketSize, NULL, FILE_CURRENT);

   nCrcPosition = 27 + buffer[26] + nVorbisPacketSize + 22;

   ::ReadFile(hFile, &buffer[0], 27, &dwRead, NULL);

   buffer[22] = 0; buffer[23] = 0; buffer[24] = 0; buffer[25] = 0;

   GetCRC32(&crc, &buffer[0], 27);

   ::ReadFile(hFile, &buffer[27], buffer[26], &dwRead, NULL);
   GetCRC32(&crc, &buffer[27], buffer[26]);

   nVorbisPacketSize = 0;
   for(int i=0;i<buffer[26];i++)
      nVorbisPacketSize += buffer[27 + i];

   ::ReadFile(hFile, &buffer[0], 320, &dwRead, NULL);
   nVorbisPacketSize -= 320;

   for(i=0;i<280;i++)
   {
      if(buffer[i] == 'R')
      {
         for(j=0;j<36;j++)
            szText[j] = buffer[i+j];

         if(nGainMode == GAIN_TRACKGAIN)
         {
            szText[32] = '\0';
            if(::lstrcmpiA(szText, "REPLAYGAIN_TRACK_PEAK=1.00000000") == 0)
            {
               char szgain[16];
               sprintf_s(szgain, 16, "%1.8f", dPeak);

               for(j=0;j<10;j++)
                  buffer[i+22+j] = szgain[j];

               i+=31;
            }

            szText[32] = buffer[i+32];
            szText[36] = '\0';
            if(::lstrcmpiA(szText, "REPLAYGAIN_TRACK_GAIN=-1.00000000 dB") == 0)
            {
               char szgain[16];

               if(dGain < -10.0 || 10.0< dGain)
                  sprintf_s(szgain, 16, "%+2.7f dB", dGain);
               else
                  sprintf_s(szgain, 16, "%+1.8f dB", dGain);

               for(j=0;j<11;j++)
                  buffer[i+22+j] = szgain[j];

               i+=35;
            }
         }
         else if(nGainMode == GAIN_ALBUMGAIN)
         {
            szText[32] = '\0';
            if(::lstrcmpiA(szText, "REPLAYGAIN_ALBUM_PEAK=1.00000000") == 0)
            {
               char szgain[16];
               sprintf_s(szgain, 16, "%1.8f", dPeak);

               for(j=0;j<10;j++)
                  buffer[i+22+j] = szgain[j];

               i+=31;
            }

            szText[32] = buffer[i+32];
            szText[36] = '\0';
            if(::lstrcmpiA(szText, "REPLAYGAIN_ALBUM_GAIN=-1.00000000 dB") == 0)
            {
               char szgain[16];

               if(dGain < -10.0 || 10.0< dGain)
                  sprintf_s(szgain, 16, "%+2.7f dB", dGain);
               else
                  sprintf_s(szgain, 16, "%+1.8f dB", dGain);

               for(j=0;j<11;j++)
                  buffer[i+22+j] = szgain[j];

               i+=35;
            }
         }
      }
   }

   GetCRC32(&crc, &buffer[0], 320);
   ::SetFilePointer(hFile, -320, NULL, FILE_CURRENT);
   ::WriteFile(hFile, &buffer[0], 320, &dwRead, NULL);

   while(0 < nVorbisPacketSize)
   {
      if(320 < nVorbisPacketSize)
      {
         ::ReadFile(hFile, &buffer[0], 320, &dwRead, NULL);
         GetCRC32(&crc, &buffer[0], 320);
      }
      else
      {
         ::ReadFile(hFile, &buffer[0], nVorbisPacketSize, &dwRead, NULL);
         GetCRC32(&crc, &buffer[0], nVorbisPacketSize);
      }

      nVorbisPacketSize -= 320;
   }

   ::SetFilePointer(hFile, nCrcPosition, NULL, FILE_BEGIN);
   ::WriteFile(hFile, &crc, 4, &dwRead, NULL);

   ::CloseHandle(hFile);
   return S_OK;
}
