#pragma once

#include <streams.h>
#include "../CSimpleFilter/CSimpleFilter.h"

#include "neaacdec.h"
#define FILTERNAME L"DecodeMp3"

#pragma comment(lib, "winmm.lib")
#pragma comment(lib, "../lib/strmbase.lib")
#pragma comment(lib, "../lib/CSimpleFilter.lib")
#pragma comment(lib, "libfaad.lib")

#define WAVE_FORMAT_IEEE_FLOAT 3

static const GUID CLSID_DecodeAac = 
{ 0x723b8a44, 0x86b6, 0x4497, { 0x9c, 0x77, 0x38, 0x14, 0xd7, 0x6a, 0x2f, 0xa6 } };

static const GUID MEDIASUBTYPE_Aac = 
{ 0x000000FF, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
class CDecodeAac : public CSimpleTransform , public IDecodeInterface
{
public:
   DECLARE_IUNKNOWN

   CDecodeAac(LPUNKNOWN, HRESULT *);
   ~CDecodeAac();

   static CUnknown * WINAPI CreateInstance(LPUNKNOWN, HRESULT *);

   HRESULT OnConnectInPin(const CMediaType *);
   HRESULT OnConnectOutPin(const CMediaType *, int, CMediaType *, int *);

   HRESULT OnTransform(IMediaSample *, IMediaSample *);
   HRESULT OnStart();
   HRESULT OnSeek();
   STDMETHODIMP OnQueryInterface(REFIID, void **);

   HRESULT GetOutFormat(void *);
   HRESULT SetOutFormat(void *);

private:

   WAVEFORMATEX m_outFormat;
   faacDecHandle m_decHandle;

   unsigned char *m_pszExtData;
   int m_nExtDataLength;

   REFERENCE_TIME m_rtCurrent;
};
