#pragma once

#include <streams.h>
#include "../CSimpleFilter/CSimpleFilter.h"

#include "ttacodec.h"

#pragma comment(lib, "winmm.lib")
#pragma comment(lib, "../lib/strmbase.lib")
#pragma comment(lib, "../lib/CSimpleFilter.lib")

static const GUID CLSID_DecodeTta = 
{ 0xb1c3b86e, 0xd75e, 0x4e19, { 0xa3, 0x14, 0x7b, 0xb6, 0x7, 0x3e, 0xef, 0xea } };

#define WAVE_FORMAT_TTA1 0x77A1
static const GUID MEDIASUBTYPE_TTA1 =
{ WAVE_FORMAT_TTA1, 0x000, 0x0010,  { 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71 } };
class CDecodeTta : public CSimpleTransform
{
public:
   DECLARE_IUNKNOWN

   CDecodeTta(LPUNKNOWN, HRESULT *);
   ~CDecodeTta();

   static CUnknown * WINAPI CreateInstance(LPUNKNOWN, HRESULT *);

   HRESULT OnConnectInPin(const CMediaType *);
   HRESULT OnConnectOutPin(const CMediaType *, int, CMediaType *, int *);
   HRESULT OnTransform(IMediaSample *, IMediaSample *);

   HRESULT OnStart();
   HRESULT OnSeek();

private:

   WAVEFORMATEX m_outFormat;
   TTA_codec *m_pTTACodec;
   REFERENCE_TIME m_rtCurrent;
};
