/*
** FAAD2 - Freeware Advanced Audio (AAC) Decoder including SBR decoding
** Copyright (C) 2003-2005 M. Bakker, Ahead Software AG, http://www.nero.com
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
** Any non-GPL usage of this software or parts of this software is strictly
** forbidden.
**
** Software using this code must display the following message visibly in the
** software:
** "FAAD2 AAC/HE-AAC/HE-AACv2/DRM decoder (c) Ahead Software, www.nero.com"
** in, for example, the about-box or help/startup screen.
**
** Commercial non-GPL licensing of this software is possible.
** For more info contact Ahead Software through Mpeg4AAClicense@nero.com.
**
** $Id$
**/

#ifndef __MDCT_TAB_H__
#define __MDCT_TAB_H__

#ifdef __cplusplus
extern "C" {
#endif

#ifdef FIXED_POINT

/* 256 (N/4) complex twiddle factors */
ALIGN static const complex_t mdct_tab_2048[] =
{
    { FRAC_CONST(0.999999926465718), FRAC_CONST(0.000383495187571) },
    { FRAC_CONST(0.999994043728986), FRAC_CONST(0.003451449920136) },
    { FRAC_CONST(0.999978748667469), FRAC_CONST(0.006519372166339) },
    { FRAC_CONST(0.999954041425130), FRAC_CONST(0.009587233049729) },
    { FRAC_CONST(0.999919922234523), FRAC_CONST(0.012655003694430) },
    { FRAC_CONST(0.999876391416790), FRAC_CONST(0.015722655225417) },
    { FRAC_CONST(0.999823449381662), FRAC_CONST(0.018790158768785) },
    { FRAC_CONST(0.999761096627447), FRAC_CONST(0.021857485452022) },
    { FRAC_CONST(0.999689333741034), FRAC_CONST(0.024924606404281) },
    { FRAC_CONST(0.999608161397882), FRAC_CONST(0.027991492756653) },
    { FRAC_CONST(0.999517580362017), FRAC_CONST(0.031058115642435) },
    { FRAC_CONST(0.999417591486022), FRAC_CONST(0.034124446197403) },
    { FRAC_CONST(0.999308195711029), FRAC_CONST(0.037190455560088) },
    { FRAC_CONST(0.999189394066715), FRAC_CONST(0.040256114872041) },
    { FRAC_CONST(0.999061187671285), FRAC_CONST(0.043321395278110) },
    { FRAC_CONST(0.998923577731466), FRAC_CONST(0.046386267926707) },
    { FRAC_CONST(0.998776565542496), FRAC_CONST(0.049450703970085) },
    { FRAC_CONST(0.998620152488109), FRAC_CONST(0.052514674564603) },
    { FRAC_CONST(0.998454340040525), FRAC_CONST(0.055578150871005) },
    { FRAC_CONST(0.998279129760433), FRAC_CONST(0.058641104054683) },
    { FRAC_CONST(0.998094523296980), FRAC_CONST(0.061703505285957) },
    { FRAC_CONST(0.997900522387752), FRAC_CONST(0.064765325740340) },
    { FRAC_CONST(0.997697128858759), FRAC_CONST(0.067826536598811) },
    { FRAC_CONST(0.997484344624418), FRAC_CONST(0.070887109048088) },
    { FRAC_CONST(0.997262171687536), FRAC_CONST(0.073947014280897) },
    { FRAC_CONST(0.997030612139289), FRAC_CONST(0.077006223496246) },
    { FRAC_CONST(0.996789668159205), FRAC_CONST(0.080064707899691) },
    { FRAC_CONST(0.996539342015138), FRAC_CONST(0.083122438703613) },
    { FRAC_CONST(0.996279636063255), FRAC_CONST(0.086179387127485) },
    { FRAC_CONST(0.996010552748006), FRAC_CONST(0.089235524398144) },
    { FRAC_CONST(0.995732094602106), FRAC_CONST(0.092290821750062) },
    { FRAC_CONST(0.995444264246510), FRAC_CONST(0.095345250425618) },
    { FRAC_CONST(0.995147064390386), FRAC_CONST(0.098398781675364) },
    { FRAC_CONST(0.994840497831093), FRAC_CONST(0.101451386758302) },
    { FRAC_CONST(0.994524567454152), FRAC_CONST(0.104503036942151) },
    { FRAC_CONST(0.994199276233219), FRAC_CONST(0.107553703503616) },
    { FRAC_CONST(0.993864627230060), FRAC_CONST(0.110603357728662) },
    { FRAC_CONST(0.993520623594518), FRAC_CONST(0.113651970912782) },
    { FRAC_CONST(0.993167268564487), FRAC_CONST(0.116699514361268) },
    { FRAC_CONST(0.992804565465879), FRAC_CONST(0.119745959389480) },
    { FRAC_CONST(0.992432517712594), FRAC_CONST(0.122791277323117) },
    { FRAC_CONST(0.992051128806486), FRAC_CONST(0.125835439498487) },
    { FRAC_CONST(0.991660402337333), FRAC_CONST(0.128878417262777) },
    { FRAC_CONST(0.991260341982802), FRAC_CONST(0.131920181974320) },
    { FRAC_CONST(0.990850951508414), FRAC_CONST(0.134960705002869) },
    { FRAC_CONST(0.990432234767506), FRAC_CONST(0.137999957729863) },
    { FRAC_CONST(0.990004195701201), FRAC_CONST(0.141037911548698) },
    { FRAC_CONST(0.989566838338365), FRAC_CONST(0.144074537864995) },
    { FRAC_CONST(0.989120166795573), FRAC_CONST(0.147109808096872) },
    { FRAC_CONST(0.988664185277066), FRAC_CONST(0.150143693675208) },
    { FRAC_CONST(0.988198898074718), FRAC_CONST(0.153176166043918) },
    { FRAC_CONST(0.987724309567987), FRAC_CONST(0.156207196660216) },
    { FRAC_CONST(0.987240424223882), FRAC_CONST(0.159236756994888) },
    { FRAC_CONST(0.986747246596917), FRAC_CONST(0.162264818532558) },
    { FRAC_CONST(0.986244781329065), FRAC_CONST(0.165291352771958) },
    { FRAC_CONST(0.985733033149723), FRAC_CONST(0.168316331226195) },
    { FRAC_CONST(0.985212006875659), FRAC_CONST(0.171339725423019) },
    { FRAC_CONST(0.984681707410971), FRAC_CONST(0.174361506905094) },
    { FRAC_CONST(0.984142139747039), FRAC_CONST(0.177381647230260) },
    { FRAC_CONST(0.983593308962479), FRAC_CONST(0.180400117971807) },
    { FRAC_CONST(0.983035220223096), FRAC_CONST(0.183416890718739) },
    { FRAC_CONST(0.982467878781833), FRAC_CONST(0.186431937076042) },
    { FRAC_CONST(0.981891289978725), FRAC_CONST(0.189445228664950) },
    { FRAC_CONST(0.981305459240845), FRAC_CONST(0.192456737123217) },
    { FRAC_CONST(0.980710392082254), FRAC_CONST(0.195466434105377) },
    { FRAC_CONST(0.980106094103952), FRAC_CONST(0.198474291283016) },
    { FRAC_CONST(0.979492570993821), FRAC_CONST(0.201480280345038) },
    { FRAC_CONST(0.978869828526574), FRAC_CONST(0.204484372997927) },
    { FRAC_CONST(0.978237872563701), FRAC_CONST(0.207486540966021) },
    { FRAC_CONST(0.977596709053412), FRAC_CONST(0.210486755991770) },
    { FRAC_CONST(0.976946344030582), FRAC_CONST(0.213484989836008) },
    { FRAC_CONST(0.976286783616694), FRAC_CONST(0.216481214278217) },
    { FRAC_CONST(0.975618034019782), FRAC_CONST(0.219475401116790) },
    { FRAC_CONST(0.974940101534372), FRAC_CONST(0.222467522169302) },
    { FRAC_CONST(0.974252992541423), FRAC_CONST(0.225457549272769) },
    { FRAC_CONST(0.973556713508266), FRAC_CONST(0.228445454283916) },
    { FRAC_CONST(0.972851270988544), FRAC_CONST(0.231431209079446) },
    { FRAC_CONST(0.972136671622152), FRAC_CONST(0.234414785556295) },
    { FRAC_CONST(0.971412922135171), FRAC_CONST(0.237396155631907) },
    { FRAC_CONST(0.970680029339806), FRAC_CONST(0.240375291244489) },
    { FRAC_CONST(0.969938000134324), FRAC_CONST(0.243352164353285) },
    { FRAC_CONST(0.969186841502986), FRAC_CONST(0.246326746938829) },
    { FRAC_CONST(0.968426560515983), FRAC_CONST(0.249299011003218) },
    { FRAC_CONST(0.967657164329370), FRAC_CONST(0.252268928570371) },
    { FRAC_CONST(0.966878660184996), FRAC_CONST(0.255236471686292) },
    { FRAC_CONST(0.966091055410439), FRAC_CONST(0.258201612419335) },
    { FRAC_CONST(0.965294357418935), FRAC_CONST(0.261164322860466) },
    { FRAC_CONST(0.964488573709308), FRAC_CONST(0.264124575123528) },
    { FRAC_CONST(0.963673711865903), FRAC_CONST(0.267082341345496) },
    { FRAC_CONST(0.962849779558509), FRAC_CONST(0.270037593686751) },
    { FRAC_CONST(0.962016784542291), FRAC_CONST(0.272990304331330) },
    { FRAC_CONST(0.961174734657714), FRAC_CONST(0.275940445487197) },
    { FRAC_CONST(0.960323637830474), FRAC_CONST(0.278887989386500) },
    { FRAC_CONST(0.959463502071418), FRAC_CONST(0.281832908285833) },
    { FRAC_CONST(0.958594335476470), FRAC_CONST(0.284775174466498) },
    { FRAC_CONST(0.957716146226559), FRAC_CONST(0.287714760234765) },
    { FRAC_CONST(0.956828942587535), FRAC_CONST(0.290651637922133) },
    { FRAC_CONST(0.955932732910098), FRAC_CONST(0.293585779885591) },
    { FRAC_CONST(0.955027525629714), FRAC_CONST(0.296517158507877) },
    { FRAC_CONST(0.954113329266539), FRAC_CONST(0.299445746197740) },
    { FRAC_CONST(0.953190152425337), FRAC_CONST(0.302371515390196) },
    { FRAC_CONST(0.952258003795400), FRAC_CONST(0.305294438546792) },
    { FRAC_CONST(0.951316892150466), FRAC_CONST(0.308214488155861) },
    { FRAC_CONST(0.950366826348636), FRAC_CONST(0.311131636732785) },
    { FRAC_CONST(0.949407815332292), FRAC_CONST(0.314045856820251) },
    { FRAC_CONST(0.948439868128010), FRAC_CONST(0.316957120988508) },
    { FRAC_CONST(0.947462993846478), FRAC_CONST(0.319865401835631) },
    { FRAC_CONST(0.946477201682409), FRAC_CONST(0.322770671987771) },
    { FRAC_CONST(0.945482500914454), FRAC_CONST(0.325672904099420) },
    { FRAC_CONST(0.944478900905116), FRAC_CONST(0.328572070853664) },
    { FRAC_CONST(0.943466411100659), FRAC_CONST(0.331468144962441) },
    { FRAC_CONST(0.942445041031025), FRAC_CONST(0.334361099166799) },
    { FRAC_CONST(0.941414800309736), FRAC_CONST(0.337250906237151) },
    { FRAC_CONST(0.940375698633812), FRAC_CONST(0.340137538973532) },
    { FRAC_CONST(0.939327745783671), FRAC_CONST(0.343020970205856) },
    { FRAC_CONST(0.938270951623047), FRAC_CONST(0.345901172794169) },
    { FRAC_CONST(0.937205326098888), FRAC_CONST(0.348778119628908) },
    { FRAC_CONST(0.936130879241267), FRAC_CONST(0.351651783631155) },
    { FRAC_CONST(0.935047621163287), FRAC_CONST(0.354522137752887) },
    { FRAC_CONST(0.933955562060987), FRAC_CONST(0.357389154977241) },
    { FRAC_CONST(0.932854712213241), FRAC_CONST(0.360252808318757) },
    { FRAC_CONST(0.931745081981669), FRAC_CONST(0.363113070823639) },
    { FRAC_CONST(0.930626681810532), FRAC_CONST(0.365969915570009) },
    { FRAC_CONST(0.929499522226639), FRAC_CONST(0.368823315668154) },
    { FRAC_CONST(0.928363613839244), FRAC_CONST(0.371673244260787) },
    { FRAC_CONST(0.927218967339952), FRAC_CONST(0.374519674523293) },
    { FRAC_CONST(0.926065593502609), FRAC_CONST(0.377362579663988) },
    { FRAC_CONST(0.924903503183211), FRAC_CONST(0.380201932924366) },
    { FRAC_CONST(0.923732707319793), FRAC_CONST(0.383037707579352) },
    { FRAC_CONST(0.922553216932333), FRAC_CONST(0.385869876937555) },
    { FRAC_CONST(0.921365043122642), FRAC_CONST(0.388698414341519) },
    { FRAC_CONST(0.920168197074266), FRAC_CONST(0.391523293167972) },
    { FRAC_CONST(0.918962690052376), FRAC_CONST(0.394344486828080) },
    { FRAC_CONST(0.917748533403661), FRAC_CONST(0.397161968767692) },
    { FRAC_CONST(0.916525738556228), FRAC_CONST(0.399975712467595) },
    { FRAC_CONST(0.915294317019487), FRAC_CONST(0.402785691443764) },
    { FRAC_CONST(0.914054280384047), FRAC_CONST(0.405591879247604) },
    { FRAC_CONST(0.912805640321604), FRAC_CONST(0.408394249466208) },
    { FRAC_CONST(0.911548408584834), FRAC_CONST(0.411192775722600) },
    { FRAC_CONST(0.910282597007282), FRAC_CONST(0.413987431675985) },
    { FRAC_CONST(0.909008217503247), FRAC_CONST(0.416778191021998) },
    { FRAC_CONST(0.907725282067676), FRAC_CONST(0.419565027492947) },
    { FRAC_CONST(0.906433802776045), FRAC_CONST(0.422347914858067) },
    { FRAC_CONST(0.905133791784250), FRAC_CONST(0.425126826923762) },
    { FRAC_CONST(0.903825261328488), FRAC_CONST(0.427901737533854) },
    { FRAC_CONST(0.902508223725146), FRAC_CONST(0.430672620569827) },
    { FRAC_CONST(0.901182691370685), FRAC_CONST(0.433439449951074) },
    { FRAC_CONST(0.899848676741519), FRAC_CONST(0.436202199635144) },
    { FRAC_CONST(0.898506192393902), FRAC_CONST(0.438960843617984) },
    { FRAC_CONST(0.897155250963809), FRAC_CONST(0.441715355934187) },
    { FRAC_CONST(0.895795865166814), FRAC_CONST(0.444465710657234) },
    { FRAC_CONST(0.894428047797974), FRAC_CONST(0.447211881899738) },
    { FRAC_CONST(0.893051811731707), FRAC_CONST(0.449953843813691) },
    { FRAC_CONST(0.891667169921672), FRAC_CONST(0.452691570590701) },
    { FRAC_CONST(0.890274135400645), FRAC_CONST(0.455425036462242) },
    { FRAC_CONST(0.888872721280396), FRAC_CONST(0.458154215699893) },
    { FRAC_CONST(0.887462940751569), FRAC_CONST(0.460879082615579) },
    { FRAC_CONST(0.886044807083556), FRAC_CONST(0.463599611561814) },
    { FRAC_CONST(0.884618333624370), FRAC_CONST(0.466315776931944) },
    { FRAC_CONST(0.883183533800523), FRAC_CONST(0.469027553160387) },
    { FRAC_CONST(0.881740421116898), FRAC_CONST(0.471734914722871) },
    { FRAC_CONST(0.880289009156621), FRAC_CONST(0.474437836136679) },
    { FRAC_CONST(0.878829311580933), FRAC_CONST(0.477136291960885) },
    { FRAC_CONST(0.877361342129065), FRAC_CONST(0.479830256796594) },
    { FRAC_CONST(0.875885114618104), FRAC_CONST(0.482519705287184) },
    { FRAC_CONST(0.874400642942865), FRAC_CONST(0.485204612118542) },
    { FRAC_CONST(0.872907941075761), FRAC_CONST(0.487884952019301) },
    { FRAC_CONST(0.871407023066671), FRAC_CONST(0.490560699761082) },
    { FRAC_CONST(0.869897903042806), FRAC_CONST(0.493231830158728) },
    { FRAC_CONST(0.868380595208580), FRAC_CONST(0.495898318070542) },
    { FRAC_CONST(0.866855113845470), FRAC_CONST(0.498560138398525) },
    { FRAC_CONST(0.865321473311890), FRAC_CONST(0.501217266088610) },
    { FRAC_CONST(0.863779688043047), FRAC_CONST(0.503869676130899) },
    { FRAC_CONST(0.862229772550811), FRAC_CONST(0.506517343559899) },
    { FRAC_CONST(0.860671741423578), FRAC_CONST(0.509160243454755) },
    { FRAC_CONST(0.859105609326130), FRAC_CONST(0.511798350939487) },
    { FRAC_CONST(0.857531390999499), FRAC_CONST(0.514431641183223) },
    { FRAC_CONST(0.855949101260827), FRAC_CONST(0.517060089400432) },
    { FRAC_CONST(0.854358755003227), FRAC_CONST(0.519683670851158) },
    { FRAC_CONST(0.852760367195645), FRAC_CONST(0.522302360841255) },
    { FRAC_CONST(0.851153952882715), FRAC_CONST(0.524916134722613) },
    { FRAC_CONST(0.849539527184621), FRAC_CONST(0.527524967893398) },
    { FRAC_CONST(0.847917105296951), FRAC_CONST(0.530128835798279) },
    { FRAC_CONST(0.846286702490560), FRAC_CONST(0.532727713928659) },
    { FRAC_CONST(0.844648334111418), FRAC_CONST(0.535321577822907) },
    { FRAC_CONST(0.843002015580473), FRAC_CONST(0.537910403066589) },
    { FRAC_CONST(0.841347762393502), FRAC_CONST(0.540494165292695) },
    { FRAC_CONST(0.839685590120966), FRAC_CONST(0.543072840181872) },
    { FRAC_CONST(0.838015514407864), FRAC_CONST(0.545646403462649) },
    { FRAC_CONST(0.836337550973584), FRAC_CONST(0.548214830911668) },
    { FRAC_CONST(0.834651715611756), FRAC_CONST(0.550778098353912) },
    { FRAC_CONST(0.832958024190107), FRAC_CONST(0.553336181662932) },
    { FRAC_CONST(0.831256492650303), FRAC_CONST(0.555889056761074) },
    { FRAC_CONST(0.829547137007809), FRAC_CONST(0.558436699619704) },
    { FRAC_CONST(0.827829973351730), FRAC_CONST(0.560979086259438) },
    { FRAC_CONST(0.826105017844665), FRAC_CONST(0.563516192750365) },
    { FRAC_CONST(0.824372286722551), FRAC_CONST(0.566047995212271) },
    { FRAC_CONST(0.822631796294515), FRAC_CONST(0.568574469814869) },
    { FRAC_CONST(0.820883562942715), FRAC_CONST(0.571095592778017) },
    { FRAC_CONST(0.819127603122188), FRAC_CONST(0.573611340371945) },
    { FRAC_CONST(0.817363933360698), FRAC_CONST(0.576121688917478) },
    { FRAC_CONST(0.815592570258577), FRAC_CONST(0.578626614786261) },
    { FRAC_CONST(0.813813530488567), FRAC_CONST(0.581126094400978) },
    { FRAC_CONST(0.812026830795670), FRAC_CONST(0.583620104235573) },
    { FRAC_CONST(0.810232487996982), FRAC_CONST(0.586108620815476) },
    { FRAC_CONST(0.808430518981543), FRAC_CONST(0.588591620717823) },
    { FRAC_CONST(0.806620940710170), FRAC_CONST(0.591069080571671) },
    { FRAC_CONST(0.804803770215303), FRAC_CONST(0.593540977058226) },
    { FRAC_CONST(0.802979024600843), FRAC_CONST(0.596007286911057) },
    { FRAC_CONST(0.801146721041991), FRAC_CONST(0.598467986916314) },
    { FRAC_CONST(0.799306876785086), FRAC_CONST(0.600923053912954) },
    { FRAC_CONST(0.797459509147442), FRAC_CONST(0.603372464792950) },
    { FRAC_CONST(0.795604635517188), FRAC_CONST(0.605816196501515) },
    { FRAC_CONST(0.793742273353100), FRAC_CONST(0.608254226037314) },
    { FRAC_CONST(0.791872440184440), FRAC_CONST(0.610686530452686) },
    { FRAC_CONST(0.789995153610791), FRAC_CONST(0.613113086853855) },
    { FRAC_CONST(0.788110431301888), FRAC_CONST(0.615533872401147) },
    { FRAC_CONST(0.786218290997456), FRAC_CONST(0.617948864309208) },
    { FRAC_CONST(0.784318750507039), FRAC_CONST(0.620358039847214) },
    { FRAC_CONST(0.782411827709837), FRAC_CONST(0.622761376339086) },
    { FRAC_CONST(0.780497540554532), FRAC_CONST(0.625158851163708) },
    { FRAC_CONST(0.778575907059125), FRAC_CONST(0.627550441755132) },
    { FRAC_CONST(0.776646945310762), FRAC_CONST(0.629936125602796) },
    { FRAC_CONST(0.774710673465566), FRAC_CONST(0.632315880251738) },
    { FRAC_CONST(0.772767109748464), FRAC_CONST(0.634689683302798) },
    { FRAC_CONST(0.770816272453019), FRAC_CONST(0.637057512412839) },
    { FRAC_CONST(0.768858179941253), FRAC_CONST(0.639419345294951) },
    { FRAC_CONST(0.766892850643481), FRAC_CONST(0.641775159718664) },
    { FRAC_CONST(0.764920303058128), FRAC_CONST(0.644124933510155) },
    { FRAC_CONST(0.762940555751566), FRAC_CONST(0.646468644552458) },
    { FRAC_CONST(0.760953627357928), FRAC_CONST(0.648806270785673) },
    { FRAC_CONST(0.758959536578942), FRAC_CONST(0.651137790207170) },
    { FRAC_CONST(0.756958302183750), FRAC_CONST(0.653463180871802) },
    { FRAC_CONST(0.754949943008733), FRAC_CONST(0.655782420892106) },
    { FRAC_CONST(0.752934477957330), FRAC_CONST(0.658095488438511) },
    { FRAC_CONST(0.750911925999868), FRAC_CONST(0.660402361739545) },
    { FRAC_CONST(0.748882306173375), FRAC_CONST(0.662703019082037) },
    { FRAC_CONST(0.746845637581407), FRAC_CONST(0.664997438811325) },
    { FRAC_CONST(0.744801939393863), FRAC_CONST(0.667285599331456) },
    { FRAC_CONST(0.742751230846809), FRAC_CONST(0.669567479105392) },
    { FRAC_CONST(0.740693531242296), FRAC_CONST(0.671843056655212) },
    { FRAC_CONST(0.738628859948175), FRAC_CONST(0.674112310562312) },
    { FRAC_CONST(0.736557236397919), FRAC_CONST(0.676375219467612) },
    { FRAC_CONST(0.734478680090438), FRAC_CONST(0.678631762071749) },
    { FRAC_CONST(0.732393210589896), FRAC_CONST(0.680881917135287) },
    { FRAC_CONST(0.730300847525525), FRAC_CONST(0.683125663478909) },
    { FRAC_CONST(0.728201610591445), FRAC_CONST(0.685362979983619) },
    { FRAC_CONST(0.726095519546471), FRAC_CONST(0.687593845590942) },
    { FRAC_CONST(0.723982594213936), FRAC_CONST(0.689818239303122) },
    { FRAC_CONST(0.721862854481496), FRAC_CONST(0.692036140183319) },
    { FRAC_CONST(0.719736320300951), FRAC_CONST(0.694247527355803) },
    { FRAC_CONST(0.717603011688049), FRAC_CONST(0.696452380006158) },
    { FRAC_CONST(0.715462948722304), FRAC_CONST(0.698650677381469) },
    { FRAC_CONST(0.713316151546803), FRAC_CONST(0.700842398790526) },
    { FRAC_CONST(0.711162640368018), FRAC_CONST(0.703027523604011) },
    { FRAC_CONST(0.709002435455618), FRAC_CONST(0.705206031254698) },
    { FRAC_CONST(0.706835557142274), FRAC_CONST(0.707377901237642) },
    { FRAC_CONST(0.704662025823469), FRAC_CONST(0.709543113110377) },
    { FRAC_CONST(0.702481861957308), FRAC_CONST(0.711701646493103) },
    { FRAC_CONST(0.700295086064324), FRAC_CONST(0.713853481068882) },
    { FRAC_CONST(0.698101718727284), FRAC_CONST(0.715998596583829) },
    { FRAC_CONST(0.695901780590997), FRAC_CONST(0.718136972847297) },
    { FRAC_CONST(0.693695292362118), FRAC_CONST(0.720268589732077) },
    { FRAC_CONST(0.691482274808956), FRAC_CONST(0.722393427174578) },
    { FRAC_CONST(0.689262748761273), FRAC_CONST(0.724511465175020) },
    { FRAC_CONST(0.687036735110096), FRAC_CONST(0.726622683797623) },
    { FRAC_CONST(0.684804254807511), FRAC_CONST(0.728727063170794) },
    { FRAC_CONST(0.682565328866473), FRAC_CONST(0.730824583487312) },
    { FRAC_CONST(0.680319978360607), FRAC_CONST(0.732915225004518) },
    { FRAC_CONST(0.678068224424007), FRAC_CONST(0.734998968044497) },
    { FRAC_CONST(0.675810088251037), FRAC_CONST(0.737075792994266) },
    { FRAC_CONST(0.673545591096136), FRAC_CONST(0.739145680305957) },
    { FRAC_CONST(0.671274754273613), FRAC_CONST(0.741208610497004) },
    { FRAC_CONST(0.668997599157450), FRAC_CONST(0.743264564150321) },
    { FRAC_CONST(0.666714147181098), FRAC_CONST(0.745313521914490) },
    { FRAC_CONST(0.664424419837275), FRAC_CONST(0.747355464503940) },
    { FRAC_CONST(0.662128438677769), FRAC_CONST(0.749390372699130) },
    { FRAC_CONST(0.659826225313227), FRAC_CONST(0.751418227346727) },
    { FRAC_CONST(0.657517801412960), FRAC_CONST(0.753439009359794) },
    { FRAC_CONST(0.655203188704732), FRAC_CONST(0.755452699717958) },
    { FRAC_CONST(0.652882408974559), FRAC_CONST(0.757459279467601) },
    { FRAC_CONST(0.650555484066504), FRAC_CONST(0.759458729722028) },
    { FRAC_CONST(0.648222435882470), FRAC_CONST(0.761451031661654) },
    { FRAC_CONST(0.645883286381996), FRAC_CONST(0.763436166534172) },
    { FRAC_CONST(0.643538057582048), FRAC_CONST(0.765414115654738) },
    { FRAC_CONST(0.641186771556811), FRAC_CONST(0.767384860406142) },
    { FRAC_CONST(0.638829450437486), FRAC_CONST(0.769348382238982) },
    { FRAC_CONST(0.636466116412077), FRAC_CONST(0.771304662671845) },
    { FRAC_CONST(0.634096791725184), FRAC_CONST(0.773253683291473) },
    { FRAC_CONST(0.631721498677792), FRAC_CONST(0.775195425752941) },
    { FRAC_CONST(0.629340259627066), FRAC_CONST(0.777129871779832) },
    { FRAC_CONST(0.626953096986133), FRAC_CONST(0.779057003164401) },
    { FRAC_CONST(0.624560033223877), FRAC_CONST(0.780976801767754) },
    { FRAC_CONST(0.622161090864727), FRAC_CONST(0.782889249520015) },
    { FRAC_CONST(0.619756292488441), FRAC_CONST(0.784794328420499) },
    { FRAC_CONST(0.617345660729897), FRAC_CONST(0.786692020537877) },
    { FRAC_CONST(0.614929218278880), FRAC_CONST(0.788582308010347) },
    { FRAC_CONST(0.612506987879866), FRAC_CONST(0.790465173045805) },
    { FRAC_CONST(0.610078992331810), FRAC_CONST(0.792340597922007) },
    { FRAC_CONST(0.607645254487931), FRAC_CONST(0.794208564986741) },
    { FRAC_CONST(0.605205797255497), FRAC_CONST(0.796069056657988) },
    { FRAC_CONST(0.602760643595607), FRAC_CONST(0.797922055424093) },
    { FRAC_CONST(0.600309816522980), FRAC_CONST(0.799767543843926) },
    { FRAC_CONST(0.597853339105734), FRAC_CONST(0.801605504547046) },
    { FRAC_CONST(0.595391234465169), FRAC_CONST(0.803435920233868) },
    { FRAC_CONST(0.592923525775551), FRAC_CONST(0.805258773675822) },
    { FRAC_CONST(0.590450236263896), FRAC_CONST(0.807074047715518) },
    { FRAC_CONST(0.587971389209745), FRAC_CONST(0.808881725266904) },
    { FRAC_CONST(0.585487007944951), FRAC_CONST(0.810681789315431) },
    { FRAC_CONST(0.582997115853458), FRAC_CONST(0.812474222918210) },
    { FRAC_CONST(0.580501736371077), FRAC_CONST(0.814259009204175) },
    { FRAC_CONST(0.578000892985270), FRAC_CONST(0.816036131374237) },
    { FRAC_CONST(0.575494609234928), FRAC_CONST(0.817805572701444) },
    { FRAC_CONST(0.572982908710149), FRAC_CONST(0.819567316531142) },
    { FRAC_CONST(0.570465815052013), FRAC_CONST(0.821321346281127) },
    { FRAC_CONST(0.567943351952366), FRAC_CONST(0.823067645441802) },
    { FRAC_CONST(0.565415543153590), FRAC_CONST(0.824806197576334) },
    { FRAC_CONST(0.562882412448385), FRAC_CONST(0.826536986320810) },
    { FRAC_CONST(0.560343983679541), FRAC_CONST(0.828259995384386) },
    { FRAC_CONST(0.557800280739717), FRAC_CONST(0.829975208549444) },
    { FRAC_CONST(0.555251327571214), FRAC_CONST(0.831682609671745) },
    { FRAC_CONST(0.552697148165750), FRAC_CONST(0.833382182680580) },
    { FRAC_CONST(0.550137766564234), FRAC_CONST(0.835073911578919) },
    { FRAC_CONST(0.547573206856540), FRAC_CONST(0.836757780443567) },
    { FRAC_CONST(0.545003493181281), FRAC_CONST(0.838433773425308) },
    { FRAC_CONST(0.542428649725581), FRAC_CONST(0.840101874749058) },
    { FRAC_CONST(0.539848700724848), FRAC_CONST(0.841762068714012) },
    { FRAC_CONST(0.537263670462543), FRAC_CONST(0.843414339693793) },
    { FRAC_CONST(0.534673583269956), FRAC_CONST(0.845058672136595) },
    { FRAC_CONST(0.532078463525974), FRAC_CONST(0.846695050565337) },
    { FRAC_CONST(0.529478335656852), FRAC_CONST(0.848323459577802) },
    { FRAC_CONST(0.526873224135985), FRAC_CONST(0.849943883846782) },
    { FRAC_CONST(0.524263153483673), FRAC_CONST(0.851556308120229) },
    { FRAC_CONST(0.521648148266897), FRAC_CONST(0.853160717221390) },
    { FRAC_CONST(0.519028233099081), FRAC_CONST(0.854757096048957) },
    { FRAC_CONST(0.516403432639864), FRAC_CONST(0.856345429577204) },
    { FRAC_CONST(0.513773771594868), FRAC_CONST(0.857925702856130) },
    { FRAC_CONST(0.511139274715464), FRAC_CONST(0.859497901011602) },
    { FRAC_CONST(0.508499966798541), FRAC_CONST(0.861062009245491) },
    { FRAC_CONST(0.505855872686269), FRAC_CONST(0.862618012835817) },
    { FRAC_CONST(0.503207017265869), FRAC_CONST(0.864165897136879) },
    { FRAC_CONST(0.500553425469378), FRAC_CONST(0.865705647579402) },
    { FRAC_CONST(0.497895122273411), FRAC_CONST(0.867237249670668) },
    { FRAC_CONST(0.495232132698931), FRAC_CONST(0.868760688994655) },
    { FRAC_CONST(0.492564481811011), FRAC_CONST(0.870275951212172) },
    { FRAC_CONST(0.489892194718595), FRAC_CONST(0.871783022060993) },
    { FRAC_CONST(0.487215296574269), FRAC_CONST(0.873281887355994) },
    { FRAC_CONST(0.484533812574016), FRAC_CONST(0.874772532989284) },
    { FRAC_CONST(0.481847767956986), FRAC_CONST(0.876254944930338) },
    { FRAC_CONST(0.479157188005253), FRAC_CONST(0.877729109226132) },
    { FRAC_CONST(0.476462098043581), FRAC_CONST(0.879195012001267) },
    { FRAC_CONST(0.473762523439183), FRAC_CONST(0.880652639458111) },
    { FRAC_CONST(0.471058489601483), FRAC_CONST(0.882101977876918) },
    { FRAC_CONST(0.468350021981877), FRAC_CONST(0.883543013615962) },
    { FRAC_CONST(0.465637146073494), FRAC_CONST(0.884975733111667) },
    { FRAC_CONST(0.462919887410955), FRAC_CONST(0.886400122878730) },
    { FRAC_CONST(0.460198271570134), FRAC_CONST(0.887816169510255) },
    { FRAC_CONST(0.457472324167916), FRAC_CONST(0.889223859677868) },
    { FRAC_CONST(0.454742070861955), FRAC_CONST(0.890623180131856) },
    { FRAC_CONST(0.452007537350437), FRAC_CONST(0.892014117701280) },
    { FRAC_CONST(0.449268749371830), FRAC_CONST(0.893396659294108) },
    { FRAC_CONST(0.446525732704651), FRAC_CONST(0.894770791897330) },
    { FRAC_CONST(0.443778513167218), FRAC_CONST(0.896136502577087) },
    { FRAC_CONST(0.441027116617407), FRAC_CONST(0.897493778478790) },
    { FRAC_CONST(0.438271568952410), FRAC_CONST(0.898842606827242) },
    { FRAC_CONST(0.435511896108492), FRAC_CONST(0.900182974926757) },
    { FRAC_CONST(0.432748124060744), FRAC_CONST(0.901514870161279) },
    { FRAC_CONST(0.429980278822841), FRAC_CONST(0.902838279994503) },
    { FRAC_CONST(0.427208386446796), FRAC_CONST(0.904153191969992) },
    { FRAC_CONST(0.424432473022717), FRAC_CONST(0.905459593711293) },
    { FRAC_CONST(0.421652564678558), FRAC_CONST(0.906757472922057) },
    { FRAC_CONST(0.418868687579875), FRAC_CONST(0.908046817386148) },
    { FRAC_CONST(0.416080867929579), FRAC_CONST(0.909327614967767) },
    { FRAC_CONST(0.413289131967691), FRAC_CONST(0.910599853611559) },
    { FRAC_CONST(0.410493505971093), FRAC_CONST(0.911863521342729) },
    { FRAC_CONST(0.407694016253280), FRAC_CONST(0.913118606267154) },
    { FRAC_CONST(0.404890689164118), FRAC_CONST(0.914365096571498) },
    { FRAC_CONST(0.402083551089587), FRAC_CONST(0.915602980523320) },
    { FRAC_CONST(0.399272628451541), FRAC_CONST(0.916832246471184) },
    { FRAC_CONST(0.396457947707454), FRAC_CONST(0.918052882844770) },
    { FRAC_CONST(0.393639535350173), FRAC_CONST(0.919264878154985) },
    { FRAC_CONST(0.390817417907669), FRAC_CONST(0.920468220994067) },
    { FRAC_CONST(0.387991621942785), FRAC_CONST(0.921662900035695) },
    { FRAC_CONST(0.385162174052990), FRAC_CONST(0.922848904035094) },
    { FRAC_CONST(0.382329100870125), FRAC_CONST(0.924026221829144) },
    { FRAC_CONST(0.379492429060153), FRAC_CONST(0.925194842336480) },
    { FRAC_CONST(0.376652185322910), FRAC_CONST(0.926354754557603) },
    { FRAC_CONST(0.373808396391851), FRAC_CONST(0.927505947574975) },
    { FRAC_CONST(0.370961089033802), FRAC_CONST(0.928648410553131) },
    { FRAC_CONST(0.368110290048703), FRAC_CONST(0.929782132738772) },
    { FRAC_CONST(0.365256026269360), FRAC_CONST(0.930907103460875) },
    { FRAC_CONST(0.362398324561191), FRAC_CONST(0.932023312130786) },
    { FRAC_CONST(0.359537211821973), FRAC_CONST(0.933130748242325) },
    { FRAC_CONST(0.356672714981588), FRAC_CONST(0.934229401371881) },
    { FRAC_CONST(0.353804861001772), FRAC_CONST(0.935319261178512) },
    { FRAC_CONST(0.350933676875858), FRAC_CONST(0.936400317404042) },
    { FRAC_CONST(0.348059189628526), FRAC_CONST(0.937472559873159) },
    { FRAC_CONST(0.345181426315543), FRAC_CONST(0.938535978493509) },
    { FRAC_CONST(0.342300414023514), FRAC_CONST(0.939590563255789) },
    { FRAC_CONST(0.339416179869623), FRAC_CONST(0.940636304233848) },
    { FRAC_CONST(0.336528751001382), FRAC_CONST(0.941673191584771) },
    { FRAC_CONST(0.333638154596371), FRAC_CONST(0.942701215548982) },
    { FRAC_CONST(0.330744417861983), FRAC_CONST(0.943720366450326) },
    { FRAC_CONST(0.327847568035171), FRAC_CONST(0.944730634696168) },
    { FRAC_CONST(0.324947632382188), FRAC_CONST(0.945732010777477) },
    { FRAC_CONST(0.322044638198335), FRAC_CONST(0.946724485268921) },
    { FRAC_CONST(0.319138612807696), FRAC_CONST(0.947708048828952) },
    { FRAC_CONST(0.316229583562890), FRAC_CONST(0.948682692199895) },
    { FRAC_CONST(0.313317577844809), FRAC_CONST(0.949648406208035) },
    { FRAC_CONST(0.310402623062359), FRAC_CONST(0.950605181763705) },
    { FRAC_CONST(0.307484746652204), FRAC_CONST(0.951553009861369) },
    { FRAC_CONST(0.304563976078509), FRAC_CONST(0.952491881579706) },
    { FRAC_CONST(0.301640338832679), FRAC_CONST(0.953421788081700) },
    { FRAC_CONST(0.298713862433100), FRAC_CONST(0.954342720614716) },
    { FRAC_CONST(0.295784574424884), FRAC_CONST(0.955254670510587) },
    { FRAC_CONST(0.292852502379605), FRAC_CONST(0.956157629185692) },
    { FRAC_CONST(0.289917673895041), FRAC_CONST(0.957051588141041) },
    { FRAC_CONST(0.286980116594916), FRAC_CONST(0.957936538962351) },
    { FRAC_CONST(0.284039858128637), FRAC_CONST(0.958812473320129) },
    { FRAC_CONST(0.281096926171038), FRAC_CONST(0.959679382969747) },
    { FRAC_CONST(0.278151348422115), FRAC_CONST(0.960537259751520) },
    { FRAC_CONST(0.275203152606767), FRAC_CONST(0.961386095590786) },
    { FRAC_CONST(0.272252366474537), FRAC_CONST(0.962225882497979) },
    { FRAC_CONST(0.269299017799346), FRAC_CONST(0.963056612568704) },
    { FRAC_CONST(0.266343134379238), FRAC_CONST(0.963878277983814) },
    { FRAC_CONST(0.263384744036113), FRAC_CONST(0.964690871009481) },
    { FRAC_CONST(0.260423874615468), FRAC_CONST(0.965494383997270) },
    { FRAC_CONST(0.257460553986133), FRAC_CONST(0.966288809384210) },
    { FRAC_CONST(0.254494810040011), FRAC_CONST(0.967074139692867) },
    { FRAC_CONST(0.251526670691813), FRAC_CONST(0.967850367531414) },
    { FRAC_CONST(0.248556163878797), FRAC_CONST(0.968617485593698) },
    { FRAC_CONST(0.245583317560504), FRAC_CONST(0.969375486659311) },
    { FRAC_CONST(0.242608159718497), FRAC_CONST(0.970124363593660) },
    { FRAC_CONST(0.239630718356094), FRAC_CONST(0.970864109348029) },
    { FRAC_CONST(0.236651021498106), FRAC_CONST(0.971594716959650) },
    { FRAC_CONST(0.233669097190577), FRAC_CONST(0.972316179551765) },
    { FRAC_CONST(0.230684973500512), FRAC_CONST(0.973028490333694) },
    { FRAC_CONST(0.227698678515621), FRAC_CONST(0.973731642600896) },
    { FRAC_CONST(0.224710240344050), FRAC_CONST(0.974425629735035) },
    { FRAC_CONST(0.221719687114115), FRAC_CONST(0.975110445204039) },
    { FRAC_CONST(0.218727046974045), FRAC_CONST(0.975786082562164) },
    { FRAC_CONST(0.215732348091706), FRAC_CONST(0.976452535450054) },
    { FRAC_CONST(0.212735618654346), FRAC_CONST(0.977109797594801) },
    { FRAC_CONST(0.209736886868323), FRAC_CONST(0.977757862810003) },
    { FRAC_CONST(0.206736180958844), FRAC_CONST(0.978396724995823) },
    { FRAC_CONST(0.203733529169694), FRAC_CONST(0.979026378139048) },
    { FRAC_CONST(0.200728959762976), FRAC_CONST(0.979646816313141) },
    { FRAC_CONST(0.197722501018842), FRAC_CONST(0.980258033678304) },
    { FRAC_CONST(0.194714181235226), FRAC_CONST(0.980860024481524) },
    { FRAC_CONST(0.191704028727580), FRAC_CONST(0.981452783056636) },
    { FRAC_CONST(0.188692071828605), FRAC_CONST(0.982036303824369) },
    { FRAC_CONST(0.185678338887988), FRAC_CONST(0.982610581292405) },
    { FRAC_CONST(0.182662858272129), FRAC_CONST(0.983175610055424) },
    { FRAC_CONST(0.179645658363882), FRAC_CONST(0.983731384795162) },
    { FRAC_CONST(0.176626767562281), FRAC_CONST(0.984277900280454) },
    { FRAC_CONST(0.173606214282275), FRAC_CONST(0.984815151367289) },
    { FRAC_CONST(0.170584026954464), FRAC_CONST(0.985343132998855) },
    { FRAC_CONST(0.167560234024824), FRAC_CONST(0.985861840205587) },
    { FRAC_CONST(0.164534863954446), FRAC_CONST(0.986371268105216) },
    { FRAC_CONST(0.161507945219266), FRAC_CONST(0.986871411902812) },
    { FRAC_CONST(0.158479506309796), FRAC_CONST(0.987362266890832) },
    { FRAC_CONST(0.155449575730856), FRAC_CONST(0.987843828449162) },
    { FRAC_CONST(0.152418182001307), FRAC_CONST(0.988316092045160) },
    { FRAC_CONST(0.149385353653780), FRAC_CONST(0.988779053233702) },
    { FRAC_CONST(0.146351119234411), FRAC_CONST(0.989232707657220) },
    { FRAC_CONST(0.143315507302572), FRAC_CONST(0.989677051045747) },
    { FRAC_CONST(0.140278546430595), FRAC_CONST(0.990112079216954) },
    { FRAC_CONST(0.137240265203516), FRAC_CONST(0.990537788076189) },
    { FRAC_CONST(0.134200692218792), FRAC_CONST(0.990954173616519) },
    { FRAC_CONST(0.131159856086043), FRAC_CONST(0.991361231918763) },
    { FRAC_CONST(0.128117785426777), FRAC_CONST(0.991758959151536) },
    { FRAC_CONST(0.125074508874121), FRAC_CONST(0.992147351571276) },
    { FRAC_CONST(0.122030055072553), FRAC_CONST(0.992526405522286) },
    { FRAC_CONST(0.118984452677633), FRAC_CONST(0.992896117436766) },
    { FRAC_CONST(0.115937730355728), FRAC_CONST(0.993256483834846) },
    { FRAC_CONST(0.112889916783750), FRAC_CONST(0.993607501324622) },
    { FRAC_CONST(0.109841040648883), FRAC_CONST(0.993949166602181) },
    { FRAC_CONST(0.106791130648307), FRAC_CONST(0.994281476451642) },
    { FRAC_CONST(0.103740215488939), FRAC_CONST(0.994604427745176) },
    { FRAC_CONST(0.100688323887154), FRAC_CONST(0.994918017443043) },
    { FRAC_CONST(0.097635484568517), FRAC_CONST(0.995222242593618) },
    { FRAC_CONST(0.094581726267515), FRAC_CONST(0.995517100333418) },
    { FRAC_CONST(0.091527077727285), FRAC_CONST(0.995802587887129) },
    { FRAC_CONST(0.088471567699341), FRAC_CONST(0.996078702567634) },
    { FRAC_CONST(0.085415224943307), FRAC_CONST(0.996345441776036) },
    { FRAC_CONST(0.082358078226647), FRAC_CONST(0.996602803001684) },
    { FRAC_CONST(0.079300156324388), FRAC_CONST(0.996850783822197) },
    { FRAC_CONST(0.076241488018856), FRAC_CONST(0.997089381903483) },
    { FRAC_CONST(0.073182102099403), FRAC_CONST(0.997318594999769) },
    { FRAC_CONST(0.070122027362134), FRAC_CONST(0.997538420953611) },
    { FRAC_CONST(0.067061292609637), FRAC_CONST(0.997748857695926) },
    { FRAC_CONST(0.063999926650714), FRAC_CONST(0.997949903246001) },
    { FRAC_CONST(0.060937958300107), FRAC_CONST(0.998141555711521) },
    { FRAC_CONST(0.057875416378229), FRAC_CONST(0.998323813288578) },
    { FRAC_CONST(0.054812329710890), FRAC_CONST(0.998496674261695) },
    { FRAC_CONST(0.051748727129028), FRAC_CONST(0.998660137003838) },
    { FRAC_CONST(0.048684637468439), FRAC_CONST(0.998814199976435) },
    { FRAC_CONST(0.045620089569500), FRAC_CONST(0.998958861729386) },
    { FRAC_CONST(0.042555112276904), FRAC_CONST(0.999094120901079) },
    { FRAC_CONST(0.039489734439384), FRAC_CONST(0.999219976218404) },
    { FRAC_CONST(0.036423984909444), FRAC_CONST(0.999336426496761) },
    { FRAC_CONST(0.033357892543086), FRAC_CONST(0.999443470640078) },
    { FRAC_CONST(0.030291486199539), FRAC_CONST(0.999541107640813) },
    { FRAC_CONST(0.027224794740988), FRAC_CONST(0.999629336579970) },
    { FRAC_CONST(0.024157847032300), FRAC_CONST(0.999708156627105) },
    { FRAC_CONST(0.021090671940755), FRAC_CONST(0.999777567040333) },
    { FRAC_CONST(0.018023298335774), FRAC_CONST(0.999837567166337) },
    { FRAC_CONST(0.014955755088644), FRAC_CONST(0.999888156440373) },
    { FRAC_CONST(0.011888071072252), FRAC_CONST(0.999929334386276) },
    { FRAC_CONST(0.008820275160808), FRAC_CONST(0.999961100616463) },
    { FRAC_CONST(0.005752396229574), FRAC_CONST(0.999983454831938) },
    { FRAC_CONST(0.002684463154596), FRAC_CONST(0.999996396822294) }
};

/* 64 (N/4) complex twiddle factors */
ALIGN static const complex_t mdct_tab_256[] =
{
    { FRAC_CONST(0.999995293809576), FRAC_CONST(0.003067956762966) },
    { FRAC_CONST(0.999618822495179), FRAC_CONST(0.027608145778966) },
    { FRAC_CONST(0.998640218180265), FRAC_CONST(0.052131704680283) },
    { FRAC_CONST(0.997060070339483), FRAC_CONST(0.076623861392031) },
    { FRAC_CONST(0.994879330794806), FRAC_CONST(0.101069862754828) },
    { FRAC_CONST(0.992099313142192), FRAC_CONST(0.125454983411546) },
    { FRAC_CONST(0.988721691960324), FRAC_CONST(0.149764534677322) },
    { FRAC_CONST(0.984748501801904), FRAC_CONST(0.173983873387464) },
    { FRAC_CONST(0.980182135968117), FRAC_CONST(0.198098410717954) },
    { FRAC_CONST(0.975025345066994), FRAC_CONST(0.222093620973204) },
    { FRAC_CONST(0.969281235356549), FRAC_CONST(0.245955050335795) },
    { FRAC_CONST(0.962953266873684), FRAC_CONST(0.269668325572915) },
    { FRAC_CONST(0.956045251349996), FRAC_CONST(0.293219162694259) },
    { FRAC_CONST(0.948561349915730), FRAC_CONST(0.316593375556166) },
    { FRAC_CONST(0.940506070593268), FRAC_CONST(0.339776884406827) },
    { FRAC_CONST(0.931884265581668), FRAC_CONST(0.362755724367397) },
    { FRAC_CONST(0.922701128333879), FRAC_CONST(0.385516053843919) },
    { FRAC_CONST(0.912962190428398), FRAC_CONST(0.408044162864979) },
    { FRAC_CONST(0.902673318237259), FRAC_CONST(0.430326481340083) },
    { FRAC_CONST(0.891840709392343), FRAC_CONST(0.452349587233771) },
    { FRAC_CONST(0.880470889052161), FRAC_CONST(0.474100214650550) },
    { FRAC_CONST(0.868570705971341), FRAC_CONST(0.495565261825773) },
    { FRAC_CONST(0.856147328375194), FRAC_CONST(0.516731799017650) },
    { FRAC_CONST(0.843208239641845), FRAC_CONST(0.537587076295645) },
    { FRAC_CONST(0.829761233794523), FRAC_CONST(0.558118531220556) },
    { FRAC_CONST(0.815814410806734), FRAC_CONST(0.578313796411656) },
    { FRAC_CONST(0.801376171723140), FRAC_CONST(0.598160706996342) },
    { FRAC_CONST(0.786455213599086), FRAC_CONST(0.617647307937804) },
    { FRAC_CONST(0.771060524261814), FRAC_CONST(0.636761861236284) },
    { FRAC_CONST(0.755201376896537), FRAC_CONST(0.655492852999615) },
    { FRAC_CONST(0.738887324460615), FRAC_CONST(0.673829000378756) },
    { FRAC_CONST(0.722128193929215), FRAC_CONST(0.691759258364158) },
    { FRAC_CONST(0.704934080375905), FRAC_CONST(0.709272826438866) },
    { FRAC_CONST(0.687315340891759), FRAC_CONST(0.726359155084346) },
    { FRAC_CONST(0.669282588346636), FRAC_CONST(0.743007952135122) },
    { FRAC_CONST(0.650846684996381), FRAC_CONST(0.759209188978388) },
    { FRAC_CONST(0.632018735939809), FRAC_CONST(0.774953106594874) },
    { FRAC_CONST(0.612810082429410), FRAC_CONST(0.790230221437310) },
    { FRAC_CONST(0.593232295039800), FRAC_CONST(0.805031331142964) },
    { FRAC_CONST(0.573297166698042), FRAC_CONST(0.819347520076797) },
    { FRAC_CONST(0.553016705580028), FRAC_CONST(0.833170164701913) },
    { FRAC_CONST(0.532403127877198), FRAC_CONST(0.846490938774052) },
    { FRAC_CONST(0.511468850437971), FRAC_CONST(0.859301818357008) },
    { FRAC_CONST(0.490226483288291), FRAC_CONST(0.871595086655951) },
    { FRAC_CONST(0.468688822035828), FRAC_CONST(0.883363338665732) },
    { FRAC_CONST(0.446868840162374), FRAC_CONST(0.894599485631383) },
    { FRAC_CONST(0.424779681209109), FRAC_CONST(0.905296759318119) },
    { FRAC_CONST(0.402434650859419), FRAC_CONST(0.915448716088268) },
    { FRAC_CONST(0.379847208924051), FRAC_CONST(0.925049240782678) },
    { FRAC_CONST(0.357030961233430), FRAC_CONST(0.934092550404259) },
    { FRAC_CONST(0.333999651442009), FRAC_CONST(0.942573197601447) },
    { FRAC_CONST(0.310767152749611), FRAC_CONST(0.950486073949482) },
    { FRAC_CONST(0.287347459544730), FRAC_CONST(0.957826413027533) },
    { FRAC_CONST(0.263754678974832), FRAC_CONST(0.964589793289813) },
    { FRAC_CONST(0.240003022448742), FRAC_CONST(0.970772140728950) },
    { FRAC_CONST(0.216106797076220), FRAC_CONST(0.976369731330021) },
    { FRAC_CONST(0.192080397049892), FRAC_CONST(0.981379193313755) },
    { FRAC_CONST(0.167938294974731), FRAC_CONST(0.985797509167567) },
    { FRAC_CONST(0.143695033150295), FRAC_CONST(0.989622017463201) },
    { FRAC_CONST(0.119365214810991), FRAC_CONST(0.992850414459865) },
    { FRAC_CONST(0.094963495329639), FRAC_CONST(0.995480755491927) },
    { FRAC_CONST(0.070504573389614), FRAC_CONST(0.997511456140303) },
    { FRAC_CONST(0.046003182130915), FRAC_CONST(0.998941293186857) },
    { FRAC_CONST(0.021474080275470), FRAC_CONST(0.999769405351215) }
};

#ifdef LD_DEC
/* 256 (N/4) complex twiddle factors */
ALIGN static const complex_t mdct_tab_1024[] =
{
    { FRAC_CONST(0.999999705862882), FRAC_CONST(0.000766990318743) },
    { FRAC_CONST(0.999976174986898), FRAC_CONST(0.006902858724730) },
    { FRAC_CONST(0.999914995573113), FRAC_CONST(0.013038467241987) },
    { FRAC_CONST(0.999816169924900), FRAC_CONST(0.019173584868323) },
    { FRAC_CONST(0.999679701762988), FRAC_CONST(0.025307980620025) },
    { FRAC_CONST(0.999505596225325), FRAC_CONST(0.031441423540560) },
    { FRAC_CONST(0.999293859866888), FRAC_CONST(0.037573682709270) },
    { FRAC_CONST(0.999044500659429), FRAC_CONST(0.043704527250063) },
    { FRAC_CONST(0.998757527991183), FRAC_CONST(0.049833726340107) },
    { FRAC_CONST(0.998432952666508), FRAC_CONST(0.055961049218521) },
    { FRAC_CONST(0.998070786905482), FRAC_CONST(0.062086265195060) },
    { FRAC_CONST(0.997671044343441), FRAC_CONST(0.068209143658806) },
    { FRAC_CONST(0.997233740030466), FRAC_CONST(0.074329454086846) },
    { FRAC_CONST(0.996758890430818), FRAC_CONST(0.080446966052950) },
    { FRAC_CONST(0.996246513422316), FRAC_CONST(0.086561449236251) },
    { FRAC_CONST(0.995696628295664), FRAC_CONST(0.092672673429913) },
    { FRAC_CONST(0.995109255753726), FRAC_CONST(0.098780408549800) },
    { FRAC_CONST(0.994484417910748), FRAC_CONST(0.104884424643135) },
    { FRAC_CONST(0.993822138291520), FRAC_CONST(0.110984491897163) },
    { FRAC_CONST(0.993122441830496), FRAC_CONST(0.117080380647801) },
    { FRAC_CONST(0.992385354870852), FRAC_CONST(0.123171861388280) },
    { FRAC_CONST(0.991610905163495), FRAC_CONST(0.129258704777796) },
    { FRAC_CONST(0.990799121866020), FRAC_CONST(0.135340681650134) },
    { FRAC_CONST(0.989950035541609), FRAC_CONST(0.141417563022303) },
    { FRAC_CONST(0.989063678157882), FRAC_CONST(0.147489120103154) },
    { FRAC_CONST(0.988140083085693), FRAC_CONST(0.153555124301993) },
    { FRAC_CONST(0.987179285097874), FRAC_CONST(0.159615347237193) },
    { FRAC_CONST(0.986181320367928), FRAC_CONST(0.165669560744784) },
    { FRAC_CONST(0.985146226468662), FRAC_CONST(0.171717536887050) },
    { FRAC_CONST(0.984074042370776), FRAC_CONST(0.177759047961107) },
    { FRAC_CONST(0.982964808441396), FRAC_CONST(0.183793866507478) },
    { FRAC_CONST(0.981818566442553), FRAC_CONST(0.189821765318656) },
    { FRAC_CONST(0.980635359529608), FRAC_CONST(0.195842517447658) },
    { FRAC_CONST(0.979415232249635), FRAC_CONST(0.201855896216568) },
    { FRAC_CONST(0.978158230539735), FRAC_CONST(0.207861675225075) },
    { FRAC_CONST(0.976864401725313), FRAC_CONST(0.213859628358994) },
    { FRAC_CONST(0.975533794518291), FRAC_CONST(0.219849529798779) },
    { FRAC_CONST(0.974166459015280), FRAC_CONST(0.225831154028026) },
    { FRAC_CONST(0.972762446695689), FRAC_CONST(0.231804275841965) },
    { FRAC_CONST(0.971321810419786), FRAC_CONST(0.237768670355934) },
    { FRAC_CONST(0.969844604426715), FRAC_CONST(0.243724113013852) },
    { FRAC_CONST(0.968330884332445), FRAC_CONST(0.249670379596669) },
    { FRAC_CONST(0.966780707127683), FRAC_CONST(0.255607246230807) },
    { FRAC_CONST(0.965194131175725), FRAC_CONST(0.261534489396596) },
    { FRAC_CONST(0.963571216210257), FRAC_CONST(0.267451885936678) },
    { FRAC_CONST(0.961912023333112), FRAC_CONST(0.273359213064419) },
    { FRAC_CONST(0.960216615011963), FRAC_CONST(0.279256248372291) },
    { FRAC_CONST(0.958485055077976), FRAC_CONST(0.285142769840249) },
    { FRAC_CONST(0.956717408723403), FRAC_CONST(0.291018555844085) },
    { FRAC_CONST(0.954913742499131), FRAC_CONST(0.296883385163778) },
    { FRAC_CONST(0.953074124312172), FRAC_CONST(0.302737036991819) },
    { FRAC_CONST(0.951198623423113), FRAC_CONST(0.308579290941525) },
    { FRAC_CONST(0.949287310443502), FRAC_CONST(0.314409927055337) },
    { FRAC_CONST(0.947340257333192), FRAC_CONST(0.320228725813100) },
    { FRAC_CONST(0.945357537397632), FRAC_CONST(0.326035468140330) },
    { FRAC_CONST(0.943339225285108), FRAC_CONST(0.331829935416461) },
    { FRAC_CONST(0.941285396983929), FRAC_CONST(0.337611909483075) },
    { FRAC_CONST(0.939196129819570), FRAC_CONST(0.343381172652115) },
    { FRAC_CONST(0.937071502451759), FRAC_CONST(0.349137507714085) },
    { FRAC_CONST(0.934911594871516), FRAC_CONST(0.354880697946223) },
    { FRAC_CONST(0.932716488398140), FRAC_CONST(0.360610527120662) },
    { FRAC_CONST(0.930486265676150), FRAC_CONST(0.366326779512574) },
    { FRAC_CONST(0.928221010672169), FRAC_CONST(0.372029239908285) },
    { FRAC_CONST(0.925920808671770), FRAC_CONST(0.377717693613386) },
    { FRAC_CONST(0.923585746276257), FRAC_CONST(0.383391926460809) },
    { FRAC_CONST(0.921215911399409), FRAC_CONST(0.389051724818894) },
    { FRAC_CONST(0.918811393264170), FRAC_CONST(0.394696875599434) },
    { FRAC_CONST(0.916372282399289), FRAC_CONST(0.400327166265690) },
    { FRAC_CONST(0.913898670635912), FRAC_CONST(0.405942384840403) },
    { FRAC_CONST(0.911390651104122), FRAC_CONST(0.411542319913765) },
    { FRAC_CONST(0.908848318229439), FRAC_CONST(0.417126760651388) },
    { FRAC_CONST(0.906271767729258), FRAC_CONST(0.422695496802233) },
    { FRAC_CONST(0.903661096609248), FRAC_CONST(0.428248318706532) },
    { FRAC_CONST(0.901016403159702), FRAC_CONST(0.433785017303679) },
    { FRAC_CONST(0.898337786951834), FRAC_CONST(0.439305384140100) },
    { FRAC_CONST(0.895625348834030), FRAC_CONST(0.444809211377105) },
    { FRAC_CONST(0.892879190928052), FRAC_CONST(0.450296291798709) },
    { FRAC_CONST(0.890099416625192), FRAC_CONST(0.455766418819435) },
    { FRAC_CONST(0.887286130582383), FRAC_CONST(0.461219386492092) },
    { FRAC_CONST(0.884439438718254), FRAC_CONST(0.466654989515531) },
    { FRAC_CONST(0.881559448209144), FRAC_CONST(0.472073023242369) },
    { FRAC_CONST(0.878646267485068), FRAC_CONST(0.477473283686698) },
    { FRAC_CONST(0.875700006225635), FRAC_CONST(0.482855567531766) },
    { FRAC_CONST(0.872720775355914), FRAC_CONST(0.488219672137627) },
    { FRAC_CONST(0.869708687042266), FRAC_CONST(0.493565395548775) },
    { FRAC_CONST(0.866663854688111), FRAC_CONST(0.498892536501745) },
    { FRAC_CONST(0.863586392929668), FRAC_CONST(0.504200894432690) },
    { FRAC_CONST(0.860476417631632), FRAC_CONST(0.509490269484936) },
    { FRAC_CONST(0.857334045882816), FRAC_CONST(0.514760462516501) },
    { FRAC_CONST(0.854159395991739), FRAC_CONST(0.520011275107596) },
    { FRAC_CONST(0.850952587482176), FRAC_CONST(0.525242509568095) },
    { FRAC_CONST(0.847713741088654), FRAC_CONST(0.530453968944976) },
    { FRAC_CONST(0.844442978751911), FRAC_CONST(0.535645457029741) },
    { FRAC_CONST(0.841140423614298), FRAC_CONST(0.540816778365797) },
    { FRAC_CONST(0.837806200015151), FRAC_CONST(0.545967738255818) },
    { FRAC_CONST(0.834440433486103), FRAC_CONST(0.551098142769075) },
    { FRAC_CONST(0.831043250746362), FRAC_CONST(0.556207798748740) },
    { FRAC_CONST(0.827614779697938), FRAC_CONST(0.561296513819151) },
    { FRAC_CONST(0.824155149420829), FRAC_CONST(0.566364096393064) },
    { FRAC_CONST(0.820664490168157), FRAC_CONST(0.571410355678857) },
    { FRAC_CONST(0.817142933361273), FRAC_CONST(0.576435101687722) },
    { FRAC_CONST(0.813590611584799), FRAC_CONST(0.581438145240810) },
    { FRAC_CONST(0.810007658581641), FRAC_CONST(0.586419297976361) },
    { FRAC_CONST(0.806394209247956), FRAC_CONST(0.591378372356788) },
    { FRAC_CONST(0.802750399628069), FRAC_CONST(0.596315181675744) },
    { FRAC_CONST(0.799076366909352), FRAC_CONST(0.601229540065149) },
    { FRAC_CONST(0.795372249417061), FRAC_CONST(0.606121262502186) },
    { FRAC_CONST(0.791638186609126), FRAC_CONST(0.610990164816272) },
    { FRAC_CONST(0.787874319070900), FRAC_CONST(0.615836063695985) },
    { FRAC_CONST(0.784080788509870), FRAC_CONST(0.620658776695972) },
    { FRAC_CONST(0.780257737750317), FRAC_CONST(0.625458122243814) },
    { FRAC_CONST(0.776405310727940), FRAC_CONST(0.630233919646864) },
    { FRAC_CONST(0.772523652484441), FRAC_CONST(0.634985989099049) },
    { FRAC_CONST(0.768612909162058), FRAC_CONST(0.639714151687640) },
    { FRAC_CONST(0.764673227998067), FRAC_CONST(0.644418229399988) },
    { FRAC_CONST(0.760704757319237), FRAC_CONST(0.649098045130226) },
    { FRAC_CONST(0.756707646536246), FRAC_CONST(0.653753422685936) },
    { FRAC_CONST(0.752682046138055), FRAC_CONST(0.658384186794785) },
    { FRAC_CONST(0.748628107686245), FRAC_CONST(0.662990163111121) },
    { FRAC_CONST(0.744545983809307), FRAC_CONST(0.667571178222540) },
    { FRAC_CONST(0.740435828196898), FRAC_CONST(0.672127059656412) },
    { FRAC_CONST(0.736297795594053), FRAC_CONST(0.676657635886375) },
    { FRAC_CONST(0.732132041795361), FRAC_CONST(0.681162736338795) },
    { FRAC_CONST(0.727938723639099), FRAC_CONST(0.685642191399187) },
    { FRAC_CONST(0.723717999001324), FRAC_CONST(0.690095832418600) },
    { FRAC_CONST(0.719470026789933), FRAC_CONST(0.694523491719966) },
    { FRAC_CONST(0.715194966938680), FRAC_CONST(0.698925002604414) },
    { FRAC_CONST(0.710892980401152), FRAC_CONST(0.703300199357549) },
    { FRAC_CONST(0.706564229144710), FRAC_CONST(0.707648917255684) },
    { FRAC_CONST(0.702208876144392), FRAC_CONST(0.711970992572050) },
    { FRAC_CONST(0.697827085376777), FRAC_CONST(0.716266262582953) },
    { FRAC_CONST(0.693419021813812), FRAC_CONST(0.720534565573905) },
    { FRAC_CONST(0.688984851416597), FRAC_CONST(0.724775740845711) },
    { FRAC_CONST(0.684524741129142), FRAC_CONST(0.728989628720519) },
    { FRAC_CONST(0.680038858872079), FRAC_CONST(0.733176070547833) },
    { FRAC_CONST(0.675527373536339), FRAC_CONST(0.737334908710483) },
    { FRAC_CONST(0.670990454976794), FRAC_CONST(0.741465986630563) },
    { FRAC_CONST(0.666428274005865), FRAC_CONST(0.745569148775325) },
    { FRAC_CONST(0.661841002387087), FRAC_CONST(0.749644240663033) },
    { FRAC_CONST(0.657228812828643), FRAC_CONST(0.753691108868781) },
    { FRAC_CONST(0.652591878976863), FRAC_CONST(0.757709601030268) },
    { FRAC_CONST(0.647930375409685), FRAC_CONST(0.761699565853535) },
    { FRAC_CONST(0.643244477630086), FRAC_CONST(0.765660853118662) },
    { FRAC_CONST(0.638534362059467), FRAC_CONST(0.769593313685423) },
    { FRAC_CONST(0.633800206031017), FRAC_CONST(0.773496799498899) },
    { FRAC_CONST(0.629042187783036), FRAC_CONST(0.777371163595056) },
    { FRAC_CONST(0.624260486452221), FRAC_CONST(0.781216260106276) },
    { FRAC_CONST(0.619455282066924), FRAC_CONST(0.785031944266848) },
    { FRAC_CONST(0.614626755540375), FRAC_CONST(0.788818072418420) },
    { FRAC_CONST(0.609775088663868), FRAC_CONST(0.792574502015408) },
    { FRAC_CONST(0.604900464099920), FRAC_CONST(0.796301091630359) },
    { FRAC_CONST(0.600003065375389), FRAC_CONST(0.799997700959282) },
    { FRAC_CONST(0.595083076874570), FRAC_CONST(0.803664190826924) },
    { FRAC_CONST(0.590140683832249), FRAC_CONST(0.807300423192014) },
    { FRAC_CONST(0.585176072326730), FRAC_CONST(0.810906261152460) },
    { FRAC_CONST(0.580189429272832), FRAC_CONST(0.814481568950499) },
    { FRAC_CONST(0.575180942414845), FRAC_CONST(0.818026211977813) },
    { FRAC_CONST(0.570150800319470), FRAC_CONST(0.821540056780598) },
    { FRAC_CONST(0.565099192368714), FRAC_CONST(0.825022971064580) },
    { FRAC_CONST(0.560026308752760), FRAC_CONST(0.828474823700007) },
    { FRAC_CONST(0.554932340462810), FRAC_CONST(0.831895484726578) },
    { FRAC_CONST(0.549817479283891), FRAC_CONST(0.835284825358337) },
    { FRAC_CONST(0.544681917787635), FRAC_CONST(0.838642717988527) },
    { FRAC_CONST(0.539525849325029), FRAC_CONST(0.841969036194388) },
    { FRAC_CONST(0.534349468019138), FRAC_CONST(0.845263654741918) },
    { FRAC_CONST(0.529152968757791), FRAC_CONST(0.848526449590593) },
    { FRAC_CONST(0.523936547186249), FRAC_CONST(0.851757297898029) },
    { FRAC_CONST(0.518700399699835), FRAC_CONST(0.854956078024615) },
    { FRAC_CONST(0.513444723436544), FRAC_CONST(0.858122669538086) },
    { FRAC_CONST(0.508169716269615), FRAC_CONST(0.861256953218062) },
    { FRAC_CONST(0.502875576800087), FRAC_CONST(0.864358811060534) },
    { FRAC_CONST(0.497562504349319), FRAC_CONST(0.867428126282307) },
    { FRAC_CONST(0.492230698951486), FRAC_CONST(0.870464783325398) },
    { FRAC_CONST(0.486880361346047), FRAC_CONST(0.873468667861385) },
    { FRAC_CONST(0.481511692970190), FRAC_CONST(0.876439666795714) },
    { FRAC_CONST(0.476124895951244), FRAC_CONST(0.879377668271953) },
    { FRAC_CONST(0.470720173099072), FRAC_CONST(0.882282561676009) },
    { FRAC_CONST(0.465297727898435), FRAC_CONST(0.885154237640285) },
    { FRAC_CONST(0.459857764501330), FRAC_CONST(0.887992588047806) },
    { FRAC_CONST(0.454400487719304), FRAC_CONST(0.890797506036281) },
    { FRAC_CONST(0.448926103015743), FRAC_CONST(0.893568886002136) },
    { FRAC_CONST(0.443434816498138), FRAC_CONST(0.896306623604480) },
    { FRAC_CONST(0.437926834910323), FRAC_CONST(0.899010615769039) },
    { FRAC_CONST(0.432402365624690), FRAC_CONST(0.901680760692038) },
    { FRAC_CONST(0.426861616634386), FRAC_CONST(0.904316957844028) },
    { FRAC_CONST(0.421304796545480), FRAC_CONST(0.906919107973678) },
    { FRAC_CONST(0.415732114569105), FRAC_CONST(0.909487113111505) },
    { FRAC_CONST(0.410143780513590), FRAC_CONST(0.912020876573568) },
    { FRAC_CONST(0.404540004776553), FRAC_CONST(0.914520302965104) },
    { FRAC_CONST(0.398920998336983), FRAC_CONST(0.916985298184123) },
    { FRAC_CONST(0.393286972747297), FRAC_CONST(0.919415769424947) },
    { FRAC_CONST(0.387638140125373), FRAC_CONST(0.921811625181708) },
    { FRAC_CONST(0.381974713146567), FRAC_CONST(0.924172775251791) },
    { FRAC_CONST(0.376296905035705), FRAC_CONST(0.926499130739231) },
    { FRAC_CONST(0.370604929559052), FRAC_CONST(0.928790604058057) },
    { FRAC_CONST(0.364899001016267), FRAC_CONST(0.931047108935595) },
    { FRAC_CONST(0.359179334232337), FRAC_CONST(0.933268560415712) },
    { FRAC_CONST(0.353446144549481), FRAC_CONST(0.935454874862015) },
    { FRAC_CONST(0.347699647819051), FRAC_CONST(0.937605969961000) },
    { FRAC_CONST(0.341940060393402), FRAC_CONST(0.939721764725153) },
    { FRAC_CONST(0.336167599117745), FRAC_CONST(0.941802179495998) },
    { FRAC_CONST(0.330382481321983), FRAC_CONST(0.943847135947093) },
    { FRAC_CONST(0.324584924812532), FRAC_CONST(0.945856557086984) },
    { FRAC_CONST(0.318775147864118), FRAC_CONST(0.947830367262101) },
    { FRAC_CONST(0.312953369211560), FRAC_CONST(0.949768492159607) },
    { FRAC_CONST(0.307119808041533), FRAC_CONST(0.951670858810194) },
    { FRAC_CONST(0.301274683984318), FRAC_CONST(0.953537395590833) },
    { FRAC_CONST(0.295418217105532), FRAC_CONST(0.955368032227470) },
    { FRAC_CONST(0.289550627897843), FRAC_CONST(0.957162699797670) },
    { FRAC_CONST(0.283672137272669), FRAC_CONST(0.958921330733213) },
    { FRAC_CONST(0.277782966551858), FRAC_CONST(0.960643858822638) },
    { FRAC_CONST(0.271883337459360), FRAC_CONST(0.962330219213737) },
    { FRAC_CONST(0.265973472112876), FRAC_CONST(0.963980348415994) },
    { FRAC_CONST(0.260053593015495), FRAC_CONST(0.965594184302977) },
    { FRAC_CONST(0.254123923047321), FRAC_CONST(0.967171666114677) },
    { FRAC_CONST(0.248184685457075), FRAC_CONST(0.968712734459795) },
    { FRAC_CONST(0.242236103853696), FRAC_CONST(0.970217331317979) },
    { FRAC_CONST(0.236278402197920), FRAC_CONST(0.971685400042009) },
    { FRAC_CONST(0.230311804793846), FRAC_CONST(0.973116885359925) },
    { FRAC_CONST(0.224336536280494), FRAC_CONST(0.974511733377116) },
    { FRAC_CONST(0.218352821623346), FRAC_CONST(0.975869891578341) },
    { FRAC_CONST(0.212360886105879), FRAC_CONST(0.977191308829712) },
    { FRAC_CONST(0.206360955321076), FRAC_CONST(0.978475935380617) },
    { FRAC_CONST(0.200353255162940), FRAC_CONST(0.979723722865591) },
    { FRAC_CONST(0.194338011817989), FRAC_CONST(0.980934624306142) },
    { FRAC_CONST(0.188315451756732), FRAC_CONST(0.982108594112514) },
    { FRAC_CONST(0.182285801725153), FRAC_CONST(0.983245588085407) },
    { FRAC_CONST(0.176249288736168), FRAC_CONST(0.984345563417642) },
    { FRAC_CONST(0.170206140061078), FRAC_CONST(0.985408478695768) },
    { FRAC_CONST(0.164156583221016), FRAC_CONST(0.986434293901627) },
    { FRAC_CONST(0.158100845978377), FRAC_CONST(0.987422970413855) },
    { FRAC_CONST(0.152039156328246), FRAC_CONST(0.988374471009341) },
    { FRAC_CONST(0.145971742489812), FRAC_CONST(0.989288759864625) },
    { FRAC_CONST(0.139898832897777), FRAC_CONST(0.990165802557248) },
    { FRAC_CONST(0.133820656193755), FRAC_CONST(0.991005566067049) },
    { FRAC_CONST(0.127737441217662), FRAC_CONST(0.991808018777406) },
    { FRAC_CONST(0.121649416999106), FRAC_CONST(0.992573130476429) },
    { FRAC_CONST(0.115556812748755), FRAC_CONST(0.993300872358093) },
    { FRAC_CONST(0.109459857849718), FRAC_CONST(0.993991217023329) },
    { FRAC_CONST(0.103358781848900), FRAC_CONST(0.994644138481051) },
    { FRAC_CONST(0.097253814448363), FRAC_CONST(0.995259612149133) },
    { FRAC_CONST(0.091145185496681), FRAC_CONST(0.995837614855342) },
    { FRAC_CONST(0.085033124980280), FRAC_CONST(0.996378124838200) },
    { FRAC_CONST(0.078917863014785), FRAC_CONST(0.996881121747814) },
    { FRAC_CONST(0.072799629836352), FRAC_CONST(0.997346586646633) },
    { FRAC_CONST(0.066678655793002), FRAC_CONST(0.997774502010168) },
    { FRAC_CONST(0.060555171335948), FRAC_CONST(0.998164851727646) },
    { FRAC_CONST(0.054429407010919), FRAC_CONST(0.998517621102622) },
    { FRAC_CONST(0.048301593449480), FRAC_CONST(0.998832796853528) },
    { FRAC_CONST(0.042171961360348), FRAC_CONST(0.999110367114175) },
    { FRAC_CONST(0.036040741520706), FRAC_CONST(0.999350321434199) },
    { FRAC_CONST(0.029908164767517), FRAC_CONST(0.999552650779457) },
    { FRAC_CONST(0.023774461988828), FRAC_CONST(0.999717347532362) },
    { FRAC_CONST(0.017639864115082), FRAC_CONST(0.999844405492175) },
    { FRAC_CONST(0.011504602110423), FRAC_CONST(0.999933819875236) },
    { FRAC_CONST(0.005368906963996), FRAC_CONST(0.999985587315143) }
};
#endif // LD_DEC

#ifdef ALLOW_SMALL_FRAMELENGTH
/* 480 (N/4) complex twiddle factors */
ALIGN static const complex_t mdct_tab_1920[] =
{
    { FRAC_CONST(0.999999916334328), FRAC_CONST(0.000409061532028) },
    { FRAC_CONST(0.999993223088129), FRAC_CONST(0.003681545574400) },
    { FRAC_CONST(0.999975820717897), FRAC_CONST(0.006953990190376) },
    { FRAC_CONST(0.999947709409999), FRAC_CONST(0.010226360334704) },
    { FRAC_CONST(0.999908889465485), FRAC_CONST(0.013498620962929) },
    { FRAC_CONST(0.999859361300084), FRAC_CONST(0.016770737031768) },
    { FRAC_CONST(0.999799125444203), FRAC_CONST(0.020042673499487) },
    { FRAC_CONST(0.999728182542920), FRAC_CONST(0.023314395326274) },
    { FRAC_CONST(0.999646533355977), FRAC_CONST(0.026585867474619) },
    { FRAC_CONST(0.999554178757770), FRAC_CONST(0.029857054909681) },
    { FRAC_CONST(0.999451119737344), FRAC_CONST(0.033127922599673) },
    { FRAC_CONST(0.999337357398377), FRAC_CONST(0.036398435516228) },
    { FRAC_CONST(0.999212892959173), FRAC_CONST(0.039668558634781) },
    { FRAC_CONST(0.999077727752645), FRAC_CONST(0.042938256934941) },
    { FRAC_CONST(0.998931863226306), FRAC_CONST(0.046207495400865) },
    { FRAC_CONST(0.998775300942246), FRAC_CONST(0.049476239021636) },
    { FRAC_CONST(0.998608042577122), FRAC_CONST(0.052744452791636) },
    { FRAC_CONST(0.998430089922136), FRAC_CONST(0.056012101710921) },
    { FRAC_CONST(0.998241444883019), FRAC_CONST(0.059279150785597) },
    { FRAC_CONST(0.998042109480008), FRAC_CONST(0.062545565028192) },
    { FRAC_CONST(0.997832085847824), FRAC_CONST(0.065811309458034) },
    { FRAC_CONST(0.997611376235651), FRAC_CONST(0.069076349101624) },
    { FRAC_CONST(0.997379983007114), FRAC_CONST(0.072340648993011) },
    { FRAC_CONST(0.997137908640245), FRAC_CONST(0.075604174174166) },
    { FRAC_CONST(0.996885155727469), FRAC_CONST(0.078866889695354) },
    { FRAC_CONST(0.996621726975566), FRAC_CONST(0.082128760615515) },
    { FRAC_CONST(0.996347625205645), FRAC_CONST(0.085389752002632) },
    { FRAC_CONST(0.996062853353117), FRAC_CONST(0.088649828934106) },
    { FRAC_CONST(0.995767414467660), FRAC_CONST(0.091908956497133) },
    { FRAC_CONST(0.995461311713186), FRAC_CONST(0.095167099789075) },
    { FRAC_CONST(0.995144548367810), FRAC_CONST(0.098424223917834) },
    { FRAC_CONST(0.994817127823813), FRAC_CONST(0.101680294002229) },
    { FRAC_CONST(0.994479053587606), FRAC_CONST(0.104935275172364) },
    { FRAC_CONST(0.994130329279692), FRAC_CONST(0.108189132570007) },
    { FRAC_CONST(0.993770958634630), FRAC_CONST(0.111441831348957) },
    { FRAC_CONST(0.993400945500988), FRAC_CONST(0.114693336675426) },
    { FRAC_CONST(0.993020293841312), FRAC_CONST(0.117943613728403) },
    { FRAC_CONST(0.992629007732074), FRAC_CONST(0.121192627700032) },
    { FRAC_CONST(0.992227091363634), FRAC_CONST(0.124440343795983) },
    { FRAC_CONST(0.991814549040194), FRAC_CONST(0.127686727235827) },
    { FRAC_CONST(0.991391385179751), FRAC_CONST(0.130931743253405) },
    { FRAC_CONST(0.990957604314048), FRAC_CONST(0.134175357097202) },
    { FRAC_CONST(0.990513211088533), FRAC_CONST(0.137417534030720) },
    { FRAC_CONST(0.990058210262297), FRAC_CONST(0.140658239332849) },
    { FRAC_CONST(0.989592606708036), FRAC_CONST(0.143897438298239) },
    { FRAC_CONST(0.989116405411988), FRAC_CONST(0.147135096237670) },
    { FRAC_CONST(0.988629611473887), FRAC_CONST(0.150371178478428) },
    { FRAC_CONST(0.988132230106905), FRAC_CONST(0.153605650364672) },
    { FRAC_CONST(0.987624266637598), FRAC_CONST(0.156838477257806) },
    { FRAC_CONST(0.987105726505845), FRAC_CONST(0.160069624536852) },
    { FRAC_CONST(0.986576615264794), FRAC_CONST(0.163299057598817) },
    { FRAC_CONST(0.986036938580803), FRAC_CONST(0.166526741859069) },
    { FRAC_CONST(0.985486702233375), FRAC_CONST(0.169752642751702) },
    { FRAC_CONST(0.984925912115099), FRAC_CONST(0.172976725729910) },
    { FRAC_CONST(0.984354574231587), FRAC_CONST(0.176198956266353) },
    { FRAC_CONST(0.983772694701407), FRAC_CONST(0.179419299853531) },
    { FRAC_CONST(0.983180279756024), FRAC_CONST(0.182637722004152) },
    { FRAC_CONST(0.982577335739725), FRAC_CONST(0.185854188251500) },
    { FRAC_CONST(0.981963869109555), FRAC_CONST(0.189068664149806) },
    { FRAC_CONST(0.981339886435250), FRAC_CONST(0.192281115274616) },
    { FRAC_CONST(0.980705394399163), FRAC_CONST(0.195491507223158) },
    { FRAC_CONST(0.980060399796194), FRAC_CONST(0.198699805614714) },
    { FRAC_CONST(0.979404909533716), FRAC_CONST(0.201905976090986) },
    { FRAC_CONST(0.978738930631504), FRAC_CONST(0.205109984316464) },
    { FRAC_CONST(0.978062470221657), FRAC_CONST(0.208311795978794) },
    { FRAC_CONST(0.977375535548522), FRAC_CONST(0.211511376789145) },
    { FRAC_CONST(0.976678133968618), FRAC_CONST(0.214708692482577) },
    { FRAC_CONST(0.975970272950556), FRAC_CONST(0.217903708818409) },
    { FRAC_CONST(0.975251960074958), FRAC_CONST(0.221096391580581) },
    { FRAC_CONST(0.974523203034377), FRAC_CONST(0.224286706578026) },
    { FRAC_CONST(0.973784009633218), FRAC_CONST(0.227474619645035) },
    { FRAC_CONST(0.973034387787646), FRAC_CONST(0.230660096641619) },
    { FRAC_CONST(0.972274345525510), FRAC_CONST(0.233843103453878) },
    { FRAC_CONST(0.971503890986252), FRAC_CONST(0.237023605994367) },
    { FRAC_CONST(0.970723032420820), FRAC_CONST(0.240201570202459) },
    { FRAC_CONST(0.969931778191584), FRAC_CONST(0.243376962044711) },
    { FRAC_CONST(0.969130136772239), FRAC_CONST(0.246549747515226) },
    { FRAC_CONST(0.968318116747721), FRAC_CONST(0.249719892636022) },
    { FRAC_CONST(0.967495726814114), FRAC_CONST(0.252887363457390) },
    { FRAC_CONST(0.966662975778551), FRAC_CONST(0.256052126058264) },
    { FRAC_CONST(0.965819872559127), FRAC_CONST(0.259214146546579) },
    { FRAC_CONST(0.964966426184802), FRAC_CONST(0.262373391059634) },
    { FRAC_CONST(0.964102645795299), FRAC_CONST(0.265529825764461) },
    { FRAC_CONST(0.963228540641012), FRAC_CONST(0.268683416858178) },
    { FRAC_CONST(0.962344120082907), FRAC_CONST(0.271834130568359) },
    { FRAC_CONST(0.961449393592416), FRAC_CONST(0.274981933153391) },
    { FRAC_CONST(0.960544370751341), FRAC_CONST(0.278126790902837) },
    { FRAC_CONST(0.959629061251750), FRAC_CONST(0.281268670137799) },
    { FRAC_CONST(0.958703474895872), FRAC_CONST(0.284407537211272) },
    { FRAC_CONST(0.957767621595993), FRAC_CONST(0.287543358508512) },
    { FRAC_CONST(0.956821511374351), FRAC_CONST(0.290676100447394) },
    { FRAC_CONST(0.955865154363025), FRAC_CONST(0.293805729478766) },
    { FRAC_CONST(0.954898560803832), FRAC_CONST(0.296932212086818) },
    { FRAC_CONST(0.953921741048211), FRAC_CONST(0.300055514789431) },
    { FRAC_CONST(0.952934705557117), FRAC_CONST(0.303175604138543) },
    { FRAC_CONST(0.951937464900908), FRAC_CONST(0.306292446720504) },
    { FRAC_CONST(0.950930029759229), FRAC_CONST(0.309406009156434) },
    { FRAC_CONST(0.949912410920903), FRAC_CONST(0.312516258102580) },
    { FRAC_CONST(0.948884619283808), FRAC_CONST(0.315623160250676) },
    { FRAC_CONST(0.947846665854767), FRAC_CONST(0.318726682328294) },
    { FRAC_CONST(0.946798561749429), FRAC_CONST(0.321826791099207) },
    { FRAC_CONST(0.945740318192145), FRAC_CONST(0.324923453363742) },
    { FRAC_CONST(0.944671946515855), FRAC_CONST(0.328016635959131) },
    { FRAC_CONST(0.943593458161960), FRAC_CONST(0.331106305759876) },
    { FRAC_CONST(0.942504864680205), FRAC_CONST(0.334192429678095) },
    { FRAC_CONST(0.941406177728551), FRAC_CONST(0.337274974663880) },
    { FRAC_CONST(0.940297409073052), FRAC_CONST(0.340353907705650) },
    { FRAC_CONST(0.939178570587730), FRAC_CONST(0.343429195830507) },
    { FRAC_CONST(0.938049674254446), FRAC_CONST(0.346500806104585) },
    { FRAC_CONST(0.936910732162774), FRAC_CONST(0.349568705633406) },
    { FRAC_CONST(0.935761756509868), FRAC_CONST(0.352632861562230) },
    { FRAC_CONST(0.934602759600334), FRAC_CONST(0.355693241076410) },
    { FRAC_CONST(0.933433753846097), FRAC_CONST(0.358749811401739) },
    { FRAC_CONST(0.932254751766271), FRAC_CONST(0.361802539804806) },
    { FRAC_CONST(0.931065765987021), FRAC_CONST(0.364851393593340) },
    { FRAC_CONST(0.929866809241428), FRAC_CONST(0.367896340116568) },
    { FRAC_CONST(0.928657894369357), FRAC_CONST(0.370937346765559) },
    { FRAC_CONST(0.927439034317314), FRAC_CONST(0.373974380973575) },
    { FRAC_CONST(0.926210242138311), FRAC_CONST(0.377007410216418) },
    { FRAC_CONST(0.924971530991726), FRAC_CONST(0.380036402012783) },
    { FRAC_CONST(0.923722914143160), FRAC_CONST(0.383061323924602) },
    { FRAC_CONST(0.922464404964295), FRAC_CONST(0.386082143557389) },
    { FRAC_CONST(0.921196016932755), FRAC_CONST(0.389098828560595) },
    { FRAC_CONST(0.919917763631956), FRAC_CONST(0.392111346627946) },
    { FRAC_CONST(0.918629658750963), FRAC_CONST(0.395119665497795) },
    { FRAC_CONST(0.917331716084346), FRAC_CONST(0.398123752953462) },
    { FRAC_CONST(0.916023949532027), FRAC_CONST(0.401123576823585) },
    { FRAC_CONST(0.914706373099136), FRAC_CONST(0.404119104982459) },
    { FRAC_CONST(0.913379000895858), FRAC_CONST(0.407110305350386) },
    { FRAC_CONST(0.912041847137282), FRAC_CONST(0.410097145894012) },
    { FRAC_CONST(0.910694926143251), FRAC_CONST(0.413079594626675) },
    { FRAC_CONST(0.909338252338207), FRAC_CONST(0.416057619608744) },
    { FRAC_CONST(0.907971840251037), FRAC_CONST(0.419031188947965) },
    { FRAC_CONST(0.906595704514915), FRAC_CONST(0.422000270799800) },
    { FRAC_CONST(0.905209859867151), FRAC_CONST(0.424964833367766) },
    { FRAC_CONST(0.903814321149027), FRAC_CONST(0.427924844903780) },
    { FRAC_CONST(0.902409103305641), FRAC_CONST(0.430880273708497) },
    { FRAC_CONST(0.900994221385748), FRAC_CONST(0.433831088131649) },
    { FRAC_CONST(0.899569690541596), FRAC_CONST(0.436777256572384) },
    { FRAC_CONST(0.898135526028766), FRAC_CONST(0.439718747479604) },
    { FRAC_CONST(0.896691743206008), FRAC_CONST(0.442655529352306) },
    { FRAC_CONST(0.895238357535076), FRAC_CONST(0.445587570739915) },
    { FRAC_CONST(0.893775384580563), FRAC_CONST(0.448514840242624) },
    { FRAC_CONST(0.892302840009734), FRAC_CONST(0.451437306511726) },
    { FRAC_CONST(0.890820739592359), FRAC_CONST(0.454354938249958) },
    { FRAC_CONST(0.889329099200541), FRAC_CONST(0.457267704211826) },
    { FRAC_CONST(0.887827934808551), FRAC_CONST(0.460175573203949) },
    { FRAC_CONST(0.886317262492655), FRAC_CONST(0.463078514085383) },
    { FRAC_CONST(0.884797098430938), FRAC_CONST(0.465976495767966) },
    { FRAC_CONST(0.883267458903136), FRAC_CONST(0.468869487216642) },
    { FRAC_CONST(0.881728360290461), FRAC_CONST(0.471757457449795) },
    { FRAC_CONST(0.880179819075421), FRAC_CONST(0.474640375539586) },
    { FRAC_CONST(0.878621851841649), FRAC_CONST(0.477518210612278) },
    { FRAC_CONST(0.877054475273722), FRAC_CONST(0.480390931848569) },
    { FRAC_CONST(0.875477706156984), FRAC_CONST(0.483258508483922) },
    { FRAC_CONST(0.873891561377366), FRAC_CONST(0.486120909808896) },
    { FRAC_CONST(0.872296057921204), FRAC_CONST(0.488978105169472) },
    { FRAC_CONST(0.870691212875058), FRAC_CONST(0.491830063967383) },
    { FRAC_CONST(0.869077043425529), FRAC_CONST(0.494676755660442) },
    { FRAC_CONST(0.867453566859076), FRAC_CONST(0.497518149762867) },
    { FRAC_CONST(0.865820800561827), FRAC_CONST(0.500354215845611) },
    { FRAC_CONST(0.864178762019399), FRAC_CONST(0.503184923536685) },
    { FRAC_CONST(0.862527468816704), FRAC_CONST(0.506010242521482) },
    { FRAC_CONST(0.860866938637767), FRAC_CONST(0.508830142543107) },
    { FRAC_CONST(0.859197189265532), FRAC_CONST(0.511644593402696) },
    { FRAC_CONST(0.857518238581672), FRAC_CONST(0.514453564959741) },
    { FRAC_CONST(0.855830104566401), FRAC_CONST(0.517257027132414) },
    { FRAC_CONST(0.854132805298278), FRAC_CONST(0.520054949897887) },
    { FRAC_CONST(0.852426358954015), FRAC_CONST(0.522847303292655) },
    { FRAC_CONST(0.850710783808280), FRAC_CONST(0.525634057412856) },
    { FRAC_CONST(0.848986098233506), FRAC_CONST(0.528415182414593) },
    { FRAC_CONST(0.847252320699689), FRAC_CONST(0.531190648514252) },
    { FRAC_CONST(0.845509469774194), FRAC_CONST(0.533960425988819) },
    { FRAC_CONST(0.843757564121554), FRAC_CONST(0.536724485176205) },
    { FRAC_CONST(0.841996622503271), FRAC_CONST(0.539482796475555) },
    { FRAC_CONST(0.840226663777615), FRAC_CONST(0.542235330347571) },
    { FRAC_CONST(0.838447706899422), FRAC_CONST(0.544982057314827) },
    { FRAC_CONST(0.836659770919891), FRAC_CONST(0.547722947962084) },
    { FRAC_CONST(0.834862874986380), FRAC_CONST(0.550457972936605) },
    { FRAC_CONST(0.833057038342201), FRAC_CONST(0.553187102948470) },
    { FRAC_CONST(0.831242280326413), FRAC_CONST(0.555910308770889) },
    { FRAC_CONST(0.829418620373617), FRAC_CONST(0.558627561240515) },
    { FRAC_CONST(0.827586078013746), FRAC_CONST(0.561338831257758) },
    { FRAC_CONST(0.825744672871856), FRAC_CONST(0.564044089787093) },
    { FRAC_CONST(0.823894424667918), FRAC_CONST(0.566743307857377) },
    { FRAC_CONST(0.822035353216601), FRAC_CONST(0.569436456562150) },
    { FRAC_CONST(0.820167478427070), FRAC_CONST(0.572123507059955) },
    { FRAC_CONST(0.818290820302761), FRAC_CONST(0.574804430574639) },
    { FRAC_CONST(0.816405398941175), FRAC_CONST(0.577479198395666) },
    { FRAC_CONST(0.814511234533661), FRAC_CONST(0.580147781878420) },
    { FRAC_CONST(0.812608347365198), FRAC_CONST(0.582810152444517) },
    { FRAC_CONST(0.810696757814178), FRAC_CONST(0.585466281582107) },
    { FRAC_CONST(0.808776486352191), FRAC_CONST(0.588116140846181) },
    { FRAC_CONST(0.806847553543799), FRAC_CONST(0.590759701858874) },
    { FRAC_CONST(0.804909980046325), FRAC_CONST(0.593396936309773) },
    { FRAC_CONST(0.802963786609623), FRAC_CONST(0.596027815956215) },
    { FRAC_CONST(0.801008994075862), FRAC_CONST(0.598652312623592) },
    { FRAC_CONST(0.799045623379300), FRAC_CONST(0.601270398205654) },
    { FRAC_CONST(0.797073695546059), FRAC_CONST(0.603882044664808) },
    { FRAC_CONST(0.795093231693901), FRAC_CONST(0.606487224032418) },
    { FRAC_CONST(0.793104253032005), FRAC_CONST(0.609085908409106) },
    { FRAC_CONST(0.791106780860733), FRAC_CONST(0.611678069965050) },
    { FRAC_CONST(0.789100836571407), FRAC_CONST(0.614263680940283) },
    { FRAC_CONST(0.787086441646080), FRAC_CONST(0.616842713644988) },
    { FRAC_CONST(0.785063617657302), FRAC_CONST(0.619415140459796) },
    { FRAC_CONST(0.783032386267894), FRAC_CONST(0.621980933836084) },
    { FRAC_CONST(0.780992769230711), FRAC_CONST(0.624540066296266) },
    { FRAC_CONST(0.778944788388414), FRAC_CONST(0.627092510434089) },
    { FRAC_CONST(0.776888465673232), FRAC_CONST(0.629638238914927) },
    { FRAC_CONST(0.774823823106730), FRAC_CONST(0.632177224476073) },
    { FRAC_CONST(0.772750882799570), FRAC_CONST(0.634709439927031) },
    { FRAC_CONST(0.770669666951277), FRAC_CONST(0.637234858149809) },
    { FRAC_CONST(0.768580197850002), FRAC_CONST(0.639753452099206) },
    { FRAC_CONST(0.766482497872280), FRAC_CONST(0.642265194803105) },
    { FRAC_CONST(0.764376589482793), FRAC_CONST(0.644770059362758) },
    { FRAC_CONST(0.762262495234126), FRAC_CONST(0.647268018953079) },
    { FRAC_CONST(0.760140237766532), FRAC_CONST(0.649759046822928) },
    { FRAC_CONST(0.758009839807683), FRAC_CONST(0.652243116295397) },
    { FRAC_CONST(0.755871324172429), FRAC_CONST(0.654720200768098) },
    { FRAC_CONST(0.753724713762555), FRAC_CONST(0.657190273713446) },
    { FRAC_CONST(0.751570031566534), FRAC_CONST(0.659653308678945) },
    { FRAC_CONST(0.749407300659280), FRAC_CONST(0.662109279287469) },
    { FRAC_CONST(0.747236544201905), FRAC_CONST(0.664558159237545) },
    { FRAC_CONST(0.745057785441466), FRAC_CONST(0.666999922303638) },
    { FRAC_CONST(0.742871047710719), FRAC_CONST(0.669434542336425) },
    { FRAC_CONST(0.740676354427868), FRAC_CONST(0.671861993263083) },
    { FRAC_CONST(0.738473729096316), FRAC_CONST(0.674282249087562) },
    { FRAC_CONST(0.736263195304409), FRAC_CONST(0.676695283890867) },
    { FRAC_CONST(0.734044776725190), FRAC_CONST(0.679101071831334) },
    { FRAC_CONST(0.731818497116138), FRAC_CONST(0.681499587144906) },
    { FRAC_CONST(0.729584380318920), FRAC_CONST(0.683890804145412) },
    { FRAC_CONST(0.727342450259131), FRAC_CONST(0.686274697224838) },
    { FRAC_CONST(0.725092730946042), FRAC_CONST(0.688651240853606) },
    { FRAC_CONST(0.722835246472338), FRAC_CONST(0.691020409580841) },
    { FRAC_CONST(0.720570021013866), FRAC_CONST(0.693382178034651) },
    { FRAC_CONST(0.718297078829369), FRAC_CONST(0.695736520922392) },
    { FRAC_CONST(0.716016444260233), FRAC_CONST(0.698083413030944) },
    { FRAC_CONST(0.713728141730222), FRAC_CONST(0.700422829226978) },
    { FRAC_CONST(0.711432195745216), FRAC_CONST(0.702754744457225) },
    { FRAC_CONST(0.709128630892954), FRAC_CONST(0.705079133748748) },
    { FRAC_CONST(0.706817471842764), FRAC_CONST(0.707395972209203) },
    { FRAC_CONST(0.704498743345302), FRAC_CONST(0.709705235027113) },
    { FRAC_CONST(0.702172470232289), FRAC_CONST(0.712006897472128) },
    { FRAC_CONST(0.699838677416240), FRAC_CONST(0.714300934895292) },
    { FRAC_CONST(0.697497389890200), FRAC_CONST(0.716587322729308) },
    { FRAC_CONST(0.695148632727480), FRAC_CONST(0.718866036488799) },
    { FRAC_CONST(0.692792431081381), FRAC_CONST(0.721137051770570) },
    { FRAC_CONST(0.690428810184929), FRAC_CONST(0.723400344253874) },
    { FRAC_CONST(0.688057795350606), FRAC_CONST(0.725655889700665) },
    { FRAC_CONST(0.685679411970075), FRAC_CONST(0.727903663955865) },
    { FRAC_CONST(0.683293685513912), FRAC_CONST(0.730143642947616) },
    { FRAC_CONST(0.680900641531330), FRAC_CONST(0.732375802687543) },
    { FRAC_CONST(0.678500305649909), FRAC_CONST(0.734600119271009) },
    { FRAC_CONST(0.676092703575316), FRAC_CONST(0.736816568877370) },
    { FRAC_CONST(0.673677861091036), FRAC_CONST(0.739025127770231) },
    { FRAC_CONST(0.671255804058092), FRAC_CONST(0.741225772297702) },
    { FRAC_CONST(0.668826558414768), FRAC_CONST(0.743418478892647) },
    { FRAC_CONST(0.666390150176334), FRAC_CONST(0.745603224072940) },
    { FRAC_CONST(0.663946605434765), FRAC_CONST(0.747779984441716) },
    { FRAC_CONST(0.661495950358462), FRAC_CONST(0.749948736687619) },
    { FRAC_CONST(0.659038211191971), FRAC_CONST(0.752109457585056) },
    { FRAC_CONST(0.656573414255705), FRAC_CONST(0.754262123994441) },
    { FRAC_CONST(0.654101585945659), FRAC_CONST(0.756406712862448) },
    { FRAC_CONST(0.651622752733128), FRAC_CONST(0.758543201222251) },
    { FRAC_CONST(0.649136941164425), FRAC_CONST(0.760671566193777) },
    { FRAC_CONST(0.646644177860593), FRAC_CONST(0.762791784983948) },
    { FRAC_CONST(0.644144489517126), FRAC_CONST(0.764903834886923) },
    { FRAC_CONST(0.641637902903677), FRAC_CONST(0.767007693284345) },
    { FRAC_CONST(0.639124444863776), FRAC_CONST(0.769103337645580) },
    { FRAC_CONST(0.636604142314538), FRAC_CONST(0.771190745527961) },
    { FRAC_CONST(0.634077022246379), FRAC_CONST(0.773269894577026) },
    { FRAC_CONST(0.631543111722725), FRAC_CONST(0.775340762526760) },
    { FRAC_CONST(0.629002437879721), FRAC_CONST(0.777403327199831) },
    { FRAC_CONST(0.626455027925944), FRAC_CONST(0.779457566507828) },
    { FRAC_CONST(0.623900909142107), FRAC_CONST(0.781503458451498) },
    { FRAC_CONST(0.621340108880771), FRAC_CONST(0.783540981120982) },
    { FRAC_CONST(0.618772654566049), FRAC_CONST(0.785570112696050) },
    { FRAC_CONST(0.616198573693314), FRAC_CONST(0.787590831446332) },
    { FRAC_CONST(0.613617893828905), FRAC_CONST(0.789603115731555) },
    { FRAC_CONST(0.611030642609828), FRAC_CONST(0.791606944001769) },
    { FRAC_CONST(0.608436847743468), FRAC_CONST(0.793602294797585) },
    { FRAC_CONST(0.605836537007281), FRAC_CONST(0.795589146750397) },
    { FRAC_CONST(0.603229738248508), FRAC_CONST(0.797567478582619) },
    { FRAC_CONST(0.600616479383869), FRAC_CONST(0.799537269107905) },
    { FRAC_CONST(0.597996788399267), FRAC_CONST(0.801498497231381) },
    { FRAC_CONST(0.595370693349487), FRAC_CONST(0.803451141949871) },
    { FRAC_CONST(0.592738222357898), FRAC_CONST(0.805395182352117) },
    { FRAC_CONST(0.590099403616149), FRAC_CONST(0.807330597619008) },
    { FRAC_CONST(0.587454265383869), FRAC_CONST(0.809257367023803) },
    { FRAC_CONST(0.584802835988364), FRAC_CONST(0.811175469932349) },
    { FRAC_CONST(0.582145143824311), FRAC_CONST(0.813084885803304) },
    { FRAC_CONST(0.579481217353460), FRAC_CONST(0.814985594188359) },
    { FRAC_CONST(0.576811085104321), FRAC_CONST(0.816877574732454) },
    { FRAC_CONST(0.574134775671867), FRAC_CONST(0.818760807173997) },
    { FRAC_CONST(0.571452317717222), FRAC_CONST(0.820635271345081) },
    { FRAC_CONST(0.568763739967354), FRAC_CONST(0.822500947171703) },
    { FRAC_CONST(0.566069071214772), FRAC_CONST(0.824357814673971) },
    { FRAC_CONST(0.563368340317214), FRAC_CONST(0.826205853966327) },
    { FRAC_CONST(0.560661576197336), FRAC_CONST(0.828045045257756) },
    { FRAC_CONST(0.557948807842409), FRAC_CONST(0.829875368851995) },
    { FRAC_CONST(0.555230064304002), FRAC_CONST(0.831696805147750) },
    { FRAC_CONST(0.552505374697674), FRAC_CONST(0.833509334638900) },
    { FRAC_CONST(0.549774768202663), FRAC_CONST(0.835312937914713) },
    { FRAC_CONST(0.547038274061568), FRAC_CONST(0.837107595660044) },
    { FRAC_CONST(0.544295921580046), FRAC_CONST(0.838893288655553) },
    { FRAC_CONST(0.541547740126486), FRAC_CONST(0.840669997777901) },
    { FRAC_CONST(0.538793759131706), FRAC_CONST(0.842437703999961) },
    { FRAC_CONST(0.536034008088628), FRAC_CONST(0.844196388391019) },
    { FRAC_CONST(0.533268516551970), FRAC_CONST(0.845946032116980) },
    { FRAC_CONST(0.530497314137923), FRAC_CONST(0.847686616440563) },
    { FRAC_CONST(0.527720430523840), FRAC_CONST(0.849418122721510) },
    { FRAC_CONST(0.524937895447912), FRAC_CONST(0.851140532416778) },
    { FRAC_CONST(0.522149738708856), FRAC_CONST(0.852853827080745) },
    { FRAC_CONST(0.519355990165590), FRAC_CONST(0.854557988365401) },
    { FRAC_CONST(0.516556679736915), FRAC_CONST(0.856252998020546) },
    { FRAC_CONST(0.513751837401199), FRAC_CONST(0.857938837893991) },
    { FRAC_CONST(0.510941493196049), FRAC_CONST(0.859615489931744) },
    { FRAC_CONST(0.508125677217994), FRAC_CONST(0.861282936178208) },
    { FRAC_CONST(0.505304419622159), FRAC_CONST(0.862941158776375) },
    { FRAC_CONST(0.502477750621949), FRAC_CONST(0.864590139968012) },
    { FRAC_CONST(0.499645700488717), FRAC_CONST(0.866229862093855) },
    { FRAC_CONST(0.496808299551444), FRAC_CONST(0.867860307593799) },
    { FRAC_CONST(0.493965578196415), FRAC_CONST(0.869481459007080) },
    { FRAC_CONST(0.491117566866892), FRAC_CONST(0.871093298972471) },
    { FRAC_CONST(0.488264296062789), FRAC_CONST(0.872695810228461) },
    { FRAC_CONST(0.485405796340343), FRAC_CONST(0.874288975613440) },
    { FRAC_CONST(0.482542098311789), FRAC_CONST(0.875872778065888) },
    { FRAC_CONST(0.479673232645033), FRAC_CONST(0.877447200624553) },
    { FRAC_CONST(0.476799230063322), FRAC_CONST(0.879012226428633) },
    { FRAC_CONST(0.473920121344914), FRAC_CONST(0.880567838717962) },
    { FRAC_CONST(0.471035937322751), FRAC_CONST(0.882114020833179) },
    { FRAC_CONST(0.468146708884125), FRAC_CONST(0.883650756215917) },
    { FRAC_CONST(0.465252466970353), FRAC_CONST(0.885178028408975) },
    { FRAC_CONST(0.462353242576441), FRAC_CONST(0.886695821056495) },
    { FRAC_CONST(0.459449066750752), FRAC_CONST(0.888204117904136) },
    { FRAC_CONST(0.456539970594675), FRAC_CONST(0.889702902799251) },
    { FRAC_CONST(0.453625985262295), FRAC_CONST(0.891192159691058) },
    { FRAC_CONST(0.450707141960053), FRAC_CONST(0.892671872630812) },
    { FRAC_CONST(0.447783471946415), FRAC_CONST(0.894142025771977) },
    { FRAC_CONST(0.444855006531538), FRAC_CONST(0.895602603370393) },
    { FRAC_CONST(0.441921777076935), FRAC_CONST(0.897053589784447) },
    { FRAC_CONST(0.438983814995137), FRAC_CONST(0.898494969475242) },
    { FRAC_CONST(0.436041151749356), FRAC_CONST(0.899926727006758) },
    { FRAC_CONST(0.433093818853152), FRAC_CONST(0.901348847046022) },
    { FRAC_CONST(0.430141847870093), FRAC_CONST(0.902761314363272) },
    { FRAC_CONST(0.427185270413416), FRAC_CONST(0.904164113832116) },
    { FRAC_CONST(0.424224118145690), FRAC_CONST(0.905557230429701) },
    { FRAC_CONST(0.421258422778478), FRAC_CONST(0.906940649236866) },
    { FRAC_CONST(0.418288216071994), FRAC_CONST(0.908314355438308) },
    { FRAC_CONST(0.415313529834766), FRAC_CONST(0.909678334322736) },
    { FRAC_CONST(0.412334395923293), FRAC_CONST(0.911032571283032) },
    { FRAC_CONST(0.409350846241706), FRAC_CONST(0.912377051816407) },
    { FRAC_CONST(0.406362912741425), FRAC_CONST(0.913711761524555) },
    { FRAC_CONST(0.403370627420818), FRAC_CONST(0.915036686113806) },
    { FRAC_CONST(0.400374022324857), FRAC_CONST(0.916351811395282) },
    { FRAC_CONST(0.397373129544774), FRAC_CONST(0.917657123285050) },
    { FRAC_CONST(0.394367981217720), FRAC_CONST(0.918952607804266) },
    { FRAC_CONST(0.391358609526420), FRAC_CONST(0.920238251079332) },
    { FRAC_CONST(0.388345046698826), FRAC_CONST(0.921514039342042) },
    { FRAC_CONST(0.385327325007776), FRAC_CONST(0.922779958929729) },
    { FRAC_CONST(0.382305476770645), FRAC_CONST(0.924035996285410) },
    { FRAC_CONST(0.379279534348999), FRAC_CONST(0.925282137957935) },
    { FRAC_CONST(0.376249530148250), FRAC_CONST(0.926518370602127) },
    { FRAC_CONST(0.373215496617310), FRAC_CONST(0.927744680978929) },
    { FRAC_CONST(0.370177466248239), FRAC_CONST(0.928961055955541) },
    { FRAC_CONST(0.367135471575903), FRAC_CONST(0.930167482505564) },
    { FRAC_CONST(0.364089545177621), FRAC_CONST(0.931363947709140) },
    { FRAC_CONST(0.361039719672816), FRAC_CONST(0.932550438753087) },
    { FRAC_CONST(0.357986027722671), FRAC_CONST(0.933726942931039) },
    { FRAC_CONST(0.354928502029772), FRAC_CONST(0.934893447643582) },
    { FRAC_CONST(0.351867175337763), FRAC_CONST(0.936049940398387) },
    { FRAC_CONST(0.348802080430994), FRAC_CONST(0.937196408810347) },
    { FRAC_CONST(0.345733250134169), FRAC_CONST(0.938332840601705) },
    { FRAC_CONST(0.342660717311994), FRAC_CONST(0.939459223602190) },
    { FRAC_CONST(0.339584514868829), FRAC_CONST(0.940575545749145) },
    { FRAC_CONST(0.336504675748328), FRAC_CONST(0.941681795087657) },
    { FRAC_CONST(0.333421232933097), FRAC_CONST(0.942777959770684) },
    { FRAC_CONST(0.330334219444328), FRAC_CONST(0.943864028059183) },
    { FRAC_CONST(0.327243668341457), FRAC_CONST(0.944939988322235) },
    { FRAC_CONST(0.324149612721804), FRAC_CONST(0.946005829037171) },
    { FRAC_CONST(0.321052085720218), FRAC_CONST(0.947061538789691) },
    { FRAC_CONST(0.317951120508725), FRAC_CONST(0.948107106273994) },
    { FRAC_CONST(0.314846750296171), FRAC_CONST(0.949142520292891) },
    { FRAC_CONST(0.311739008327867), FRAC_CONST(0.950167769757930) },
    { FRAC_CONST(0.308627927885232), FRAC_CONST(0.951182843689513) },
    { FRAC_CONST(0.305513542285440), FRAC_CONST(0.952187731217013) },
    { FRAC_CONST(0.302395884881056), FRAC_CONST(0.953182421578893) },
    { FRAC_CONST(0.299274989059689), FRAC_CONST(0.954166904122818) },
    { FRAC_CONST(0.296150888243624), FRAC_CONST(0.955141168305771) },
    { FRAC_CONST(0.293023615889471), FRAC_CONST(0.956105203694164) },
    { FRAC_CONST(0.289893205487806), FRAC_CONST(0.957058999963955) },
    { FRAC_CONST(0.286759690562807), FRAC_CONST(0.958002546900750) },
    { FRAC_CONST(0.283623104671904), FRAC_CONST(0.958935834399920) },
    { FRAC_CONST(0.280483481405410), FRAC_CONST(0.959858852466706) },
    { FRAC_CONST(0.277340854386169), FRAC_CONST(0.960771591216325) },
    { FRAC_CONST(0.274195257269191), FRAC_CONST(0.961674040874080) },
    { FRAC_CONST(0.271046723741295), FRAC_CONST(0.962566191775459) },
    { FRAC_CONST(0.267895287520743), FRAC_CONST(0.963448034366243) },
    { FRAC_CONST(0.264740982356888), FRAC_CONST(0.964319559202607) },
    { FRAC_CONST(0.261583842029803), FRAC_CONST(0.965180756951218) },
    { FRAC_CONST(0.258423900349924), FRAC_CONST(0.966031618389343) },
    { FRAC_CONST(0.255261191157689), FRAC_CONST(0.966872134404937) },
    { FRAC_CONST(0.252095748323171), FRAC_CONST(0.967702295996750) },
    { FRAC_CONST(0.248927605745720), FRAC_CONST(0.968522094274417) },
    { FRAC_CONST(0.245756797353599), FRAC_CONST(0.969331520458559) },
    { FRAC_CONST(0.242583357103617), FRAC_CONST(0.970130565880871) },
    { FRAC_CONST(0.239407318980770), FRAC_CONST(0.970919221984218) },
    { FRAC_CONST(0.236228716997876), FRAC_CONST(0.971697480322728) },
    { FRAC_CONST(0.233047585195206), FRAC_CONST(0.972465332561878) },
    { FRAC_CONST(0.229863957640129), FRAC_CONST(0.973222770478587) },
    { FRAC_CONST(0.226677868426735), FRAC_CONST(0.973969785961306) },
    { FRAC_CONST(0.223489351675482), FRAC_CONST(0.974706371010097) },
    { FRAC_CONST(0.220298441532823), FRAC_CONST(0.975432517736727) },
    { FRAC_CONST(0.217105172170841), FRAC_CONST(0.976148218364747) },
    { FRAC_CONST(0.213909577786886), FRAC_CONST(0.976853465229579) },
    { FRAC_CONST(0.210711692603206), FRAC_CONST(0.977548250778596) },
    { FRAC_CONST(0.207511550866582), FRAC_CONST(0.978232567571202) },
    { FRAC_CONST(0.204309186847962), FRAC_CONST(0.978906408278914) },
    { FRAC_CONST(0.201104634842092), FRAC_CONST(0.979569765685441) },
    { FRAC_CONST(0.197897929167148), FRAC_CONST(0.980222632686756) },
    { FRAC_CONST(0.194689104164373), FRAC_CONST(0.980865002291179) },
    { FRAC_CONST(0.191478194197704), FRAC_CONST(0.981496867619447) },
    { FRAC_CONST(0.188265233653407), FRAC_CONST(0.982118221904791) },
    { FRAC_CONST(0.185050256939710), FRAC_CONST(0.982729058493005) },
    { FRAC_CONST(0.181833298486427), FRAC_CONST(0.983329370842520) },
    { FRAC_CONST(0.178614392744603), FRAC_CONST(0.983919152524473) },
    { FRAC_CONST(0.175393574186129), FRAC_CONST(0.984498397222776) },
    { FRAC_CONST(0.172170877303385), FRAC_CONST(0.985067098734184) },
    { FRAC_CONST(0.168946336608867), FRAC_CONST(0.985625250968360) },
    { FRAC_CONST(0.165719986634814), FRAC_CONST(0.986172847947943) },
    { FRAC_CONST(0.162491861932842), FRAC_CONST(0.986709883808609) },
    { FRAC_CONST(0.159261997073573), FRAC_CONST(0.987236352799134) },
    { FRAC_CONST(0.156030426646266), FRAC_CONST(0.987752249281460) },
    { FRAC_CONST(0.152797185258443), FRAC_CONST(0.988257567730749) },
    { FRAC_CONST(0.149562307535523), FRAC_CONST(0.988752302735447) },
    { FRAC_CONST(0.146325828120446), FRAC_CONST(0.989236448997339) },
    { FRAC_CONST(0.143087781673307), FRAC_CONST(0.989710001331608) },
    { FRAC_CONST(0.139848202870981), FRAC_CONST(0.990172954666889) },
    { FRAC_CONST(0.136607126406757), FRAC_CONST(0.990625304045323) },
    { FRAC_CONST(0.133364586989957), FRAC_CONST(0.991067044622612) },
    { FRAC_CONST(0.130120619345575), FRAC_CONST(0.991498171668069) },
    { FRAC_CONST(0.126875258213898), FRAC_CONST(0.991918680564670) },
    { FRAC_CONST(0.123628538350136), FRAC_CONST(0.992328566809103) },
    { FRAC_CONST(0.120380494524051), FRAC_CONST(0.992727826011815) },
    { FRAC_CONST(0.117131161519582), FRAC_CONST(0.993116453897061) },
    { FRAC_CONST(0.113880574134475), FRAC_CONST(0.993494446302948) },
    { FRAC_CONST(0.110628767179910), FRAC_CONST(0.993861799181482) },
    { FRAC_CONST(0.107375775480128), FRAC_CONST(0.994218508598608) },
    { FRAC_CONST(0.104121633872055), FRAC_CONST(0.994564570734255) },
    { FRAC_CONST(0.100866377204933), FRAC_CONST(0.994899981882376) },
    { FRAC_CONST(0.097610040339947), FRAC_CONST(0.995224738450986) },
    { FRAC_CONST(0.094352658149849), FRAC_CONST(0.995538836962204) },
    { FRAC_CONST(0.091094265518583), FRAC_CONST(0.995842274052287) },
    { FRAC_CONST(0.087834897340919), FRAC_CONST(0.996135046471667) },
    { FRAC_CONST(0.084574588522070), FRAC_CONST(0.996417151084987) },
    { FRAC_CONST(0.081313373977324), FRAC_CONST(0.996688584871134) },
    { FRAC_CONST(0.078051288631670), FRAC_CONST(0.996949344923269) },
    { FRAC_CONST(0.074788367419420), FRAC_CONST(0.997199428448862) },
    { FRAC_CONST(0.071524645283840), FRAC_CONST(0.997438832769720) },
    { FRAC_CONST(0.068260157176771), FRAC_CONST(0.997667555322013) },
    { FRAC_CONST(0.064994938058259), FRAC_CONST(0.997885593656308) },
    { FRAC_CONST(0.061729022896176), FRAC_CONST(0.998092945437590) },
    { FRAC_CONST(0.058462446665851), FRAC_CONST(0.998289608445286) },
    { FRAC_CONST(0.055195244349690), FRAC_CONST(0.998475580573295) },
    { FRAC_CONST(0.051927450936806), FRAC_CONST(0.998650859830004) },
    { FRAC_CONST(0.048659101422640), FRAC_CONST(0.998815444338313) },
    { FRAC_CONST(0.045390230808591), FRAC_CONST(0.998969332335654) },
    { FRAC_CONST(0.042120874101635), FRAC_CONST(0.999112522174011) },
    { FRAC_CONST(0.038851066313958), FRAC_CONST(0.999245012319936) },
    { FRAC_CONST(0.035580842462574), FRAC_CONST(0.999366801354564) },
    { FRAC_CONST(0.032310237568951), FRAC_CONST(0.999477887973635) },
    { FRAC_CONST(0.029039286658643), FRAC_CONST(0.999578270987499) },
    { FRAC_CONST(0.025768024760904), FRAC_CONST(0.999667949321134) },
    { FRAC_CONST(0.022496486908322), FRAC_CONST(0.999746922014158) },
    { FRAC_CONST(0.019224708136438), FRAC_CONST(0.999815188220837) },
    { FRAC_CONST(0.015952723483375), FRAC_CONST(0.999872747210095) },
    { FRAC_CONST(0.012680567989461), FRAC_CONST(0.999919598365521) },
    { FRAC_CONST(0.009408276696850), FRAC_CONST(0.999955741185376) },
    { FRAC_CONST(0.006135884649155), FRAC_CONST(0.999981175282601) },
    { FRAC_CONST(0.002863426891064), FRAC_CONST(0.999995900384816) }
};

#ifdef LD_DEC
/* 240 (N/4) complex twiddle factors */
ALIGN static const complex_t mdct_tab_960[] =
{
    { FRAC_CONST(0.999999665337326), FRAC_CONST(0.000818122995607) },
    { FRAC_CONST(0.999972892444367), FRAC_CONST(0.007363041249780) },
    { FRAC_CONST(0.999903284040864), FRAC_CONST(0.013907644095771) },
    { FRAC_CONST(0.999790843108610), FRAC_CONST(0.020451651184577) },
    { FRAC_CONST(0.999635574464198), FRAC_CONST(0.026994782192715) },
    { FRAC_CONST(0.999437484758823), FRAC_CONST(0.033536756834230) },
    { FRAC_CONST(0.999196582477986), FRAC_CONST(0.040077294872701) },
    { FRAC_CONST(0.998912877941140), FRAC_CONST(0.046616116133247) },
    { FRAC_CONST(0.998586383301244), FRAC_CONST(0.053152940514528) },
    { FRAC_CONST(0.998217112544241), FRAC_CONST(0.059687488000744) },
    { FRAC_CONST(0.997805081488460), FRAC_CONST(0.066219478673630) },
    { FRAC_CONST(0.997350307783942), FRAC_CONST(0.072748632724445) },
    { FRAC_CONST(0.996852810911678), FRAC_CONST(0.079274670465961) },
    { FRAC_CONST(0.996312612182778), FRAC_CONST(0.085797312344440) },
    { FRAC_CONST(0.995729734737558), FRAC_CONST(0.092316278951614) },
    { FRAC_CONST(0.995104203544548), FRAC_CONST(0.098831291036650) },
    { FRAC_CONST(0.994436045399422), FRAC_CONST(0.105342069518114) },
    { FRAC_CONST(0.993725288923851), FRAC_CONST(0.111848335495926) },
    { FRAC_CONST(0.992971964564277), FRAC_CONST(0.118349810263305) },
    { FRAC_CONST(0.992176104590608), FRAC_CONST(0.124846215318711) },
    { FRAC_CONST(0.991337743094838), FRAC_CONST(0.131337272377774) },
    { FRAC_CONST(0.990456915989581), FRAC_CONST(0.137822703385212) },
    { FRAC_CONST(0.989533661006540), FRAC_CONST(0.144302230526747) },
    { FRAC_CONST(0.988568017694885), FRAC_CONST(0.150775576241001) },
    { FRAC_CONST(0.987560027419562), FRAC_CONST(0.157242463231389) },
    { FRAC_CONST(0.986509733359519), FRAC_CONST(0.163702614477995) },
    { FRAC_CONST(0.985417180505858), FRAC_CONST(0.170155753249442) },
    { FRAC_CONST(0.984282415659907), FRAC_CONST(0.176601603114742) },
    { FRAC_CONST(0.983105487431216), FRAC_CONST(0.183039887955141) },
    { FRAC_CONST(0.981886446235473), FRAC_CONST(0.189470331975943) },
    { FRAC_CONST(0.980625344292344), FRAC_CONST(0.195892659718330) },
    { FRAC_CONST(0.979322235623241), FRAC_CONST(0.202306596071156) },
    { FRAC_CONST(0.977977176049000), FRAC_CONST(0.208711866282735) },
    { FRAC_CONST(0.976590223187499), FRAC_CONST(0.215108195972610) },
    { FRAC_CONST(0.975161436451181), FRAC_CONST(0.221495311143304) },
    { FRAC_CONST(0.973690877044515), FRAC_CONST(0.227872938192063) },
    { FRAC_CONST(0.972178607961371), FRAC_CONST(0.234240803922570) },
    { FRAC_CONST(0.970624693982323), FRAC_CONST(0.240598635556650) },
    { FRAC_CONST(0.969029201671875), FRAC_CONST(0.246946160745958) },
    { FRAC_CONST(0.967392199375607), FRAC_CONST(0.253283107583640) },
    { FRAC_CONST(0.965713757217249), FRAC_CONST(0.259609204615985) },
    { FRAC_CONST(0.963993947095677), FRAC_CONST(0.265924180854051) },
    { FRAC_CONST(0.962232842681832), FRAC_CONST(0.272227765785273) },
    { FRAC_CONST(0.960430519415566), FRAC_CONST(0.278519689385053) },
    { FRAC_CONST(0.958587054502409), FRAC_CONST(0.284799682128326) },
    { FRAC_CONST(0.956702526910263), FRAC_CONST(0.291067475001103) },
    { FRAC_CONST(0.954777017366017), FRAC_CONST(0.297322799511998) },
    { FRAC_CONST(0.952810608352092), FRAC_CONST(0.303565387703730) },
    { FRAC_CONST(0.950803384102905), FRAC_CONST(0.309794972164597) },
    { FRAC_CONST(0.948755430601263), FRAC_CONST(0.316011286039934) },
    { FRAC_CONST(0.946666835574676), FRAC_CONST(0.322214063043544) },
    { FRAC_CONST(0.944537688491606), FRAC_CONST(0.328403037469105) },
    { FRAC_CONST(0.942368080557626), FRAC_CONST(0.334577944201551) },
    { FRAC_CONST(0.940158104711519), FRAC_CONST(0.340738518728429) },
    { FRAC_CONST(0.937907855621296), FRAC_CONST(0.346884497151231) },
    { FRAC_CONST(0.935617429680138), FRAC_CONST(0.353015616196696) },
    { FRAC_CONST(0.933286925002268), FRAC_CONST(0.359131613228090) },
    { FRAC_CONST(0.930916441418752), FRAC_CONST(0.365232226256457) },
    { FRAC_CONST(0.928506080473216), FRAC_CONST(0.371317193951838) },
    { FRAC_CONST(0.926055945417500), FRAC_CONST(0.377386255654469) },
    { FRAC_CONST(0.923566141207236), FRAC_CONST(0.383439151385947) },
    { FRAC_CONST(0.921036774497350), FRAC_CONST(0.389475621860365) },
    { FRAC_CONST(0.918467953637492), FRAC_CONST(0.395495408495417) },
    { FRAC_CONST(0.915859788667400), FRAC_CONST(0.401498253423481) },
    { FRAC_CONST(0.913212391312179), FRAC_CONST(0.407483899502658) },
    { FRAC_CONST(0.910525874977521), FRAC_CONST(0.413452090327791) },
    { FRAC_CONST(0.907800354744844), FRAC_CONST(0.419402570241451) },
    { FRAC_CONST(0.905035947366364), FRAC_CONST(0.425335084344881) },
    { FRAC_CONST(0.902232771260093), FRAC_CONST(0.431249378508924) },
    { FRAC_CONST(0.899390946504764), FRAC_CONST(0.437145199384900) },
    { FRAC_CONST(0.896510594834693), FRAC_CONST(0.443022294415467) },
    { FRAC_CONST(0.893591839634558), FRAC_CONST(0.448880411845433) },
    { FRAC_CONST(0.890634805934118), FRAC_CONST(0.454719300732547) },
    { FRAC_CONST(0.887639620402854), FRAC_CONST(0.460538710958240) },
    { FRAC_CONST(0.884606411344546), FRAC_CONST(0.466338393238348) },
    { FRAC_CONST(0.881535308691775), FRAC_CONST(0.472118099133784) },
    { FRAC_CONST(0.878426444000357), FRAC_CONST(0.477877581061184) },
    { FRAC_CONST(0.875279950443708), FRAC_CONST(0.483616592303511) },
    { FRAC_CONST(0.872095962807140), FRAC_CONST(0.489334887020625) },
    { FRAC_CONST(0.868874617482085), FRAC_CONST(0.495032220259813) },
    { FRAC_CONST(0.865616052460258), FRAC_CONST(0.500708347966279) },
    { FRAC_CONST(0.862320407327736), FRAC_CONST(0.506363026993605) },
    { FRAC_CONST(0.858987823258990), FRAC_CONST(0.511996015114162) },
    { FRAC_CONST(0.855618443010829), FRAC_CONST(0.517607071029487) },
    { FRAC_CONST(0.852212410916289), FRAC_CONST(0.523195954380619) },
    { FRAC_CONST(0.848769872878448), FRAC_CONST(0.528762425758396) },
    { FRAC_CONST(0.845290976364179), FRAC_CONST(0.534306246713712) },
    { FRAC_CONST(0.841775870397828), FRAC_CONST(0.539827179767727) },
    { FRAC_CONST(0.838224705554838), FRAC_CONST(0.545324988422046) },
    { FRAC_CONST(0.834637633955290), FRAC_CONST(0.550799437168844) },
    { FRAC_CONST(0.831014809257393), FRAC_CONST(0.556250291500956) },
    { FRAC_CONST(0.827356386650900), FRAC_CONST(0.561677317921925) },
    { FRAC_CONST(0.823662522850458), FRAC_CONST(0.567080283956001) },
    { FRAC_CONST(0.819933376088899), FRAC_CONST(0.572458958158102) },
    { FRAC_CONST(0.816169106110459), FRAC_CONST(0.577813110123727) },
    { FRAC_CONST(0.812369874163934), FRAC_CONST(0.583142510498826) },
    { FRAC_CONST(0.808535842995778), FRAC_CONST(0.588446930989624) },
    { FRAC_CONST(0.804667176843123), FRAC_CONST(0.593726144372402) },
    { FRAC_CONST(0.800764041426753), FRAC_CONST(0.598979924503229) },
    { FRAC_CONST(0.796826603943998), FRAC_CONST(0.604208046327650) },
    { FRAC_CONST(0.792855033061574), FRAC_CONST(0.609410285890327) },
    { FRAC_CONST(0.788849498908361), FRAC_CONST(0.614586420344631) },
    { FRAC_CONST(0.784810173068109), FRAC_CONST(0.619736227962191) },
    { FRAC_CONST(0.780737228572094), FRAC_CONST(0.624859488142386) },
    { FRAC_CONST(0.776630839891703), FRAC_CONST(0.629955981421804) },
    { FRAC_CONST(0.772491182930959), FRAC_CONST(0.635025489483633) },
    { FRAC_CONST(0.768318435018988), FRAC_CONST(0.640067795167023) },
    { FRAC_CONST(0.764112774902423), FRAC_CONST(0.645082682476378) },
    { FRAC_CONST(0.759874382737746), FRAC_CONST(0.650069936590618) },
    { FRAC_CONST(0.755603440083571), FRAC_CONST(0.655029343872374) },
    { FRAC_CONST(0.751300129892866), FRAC_CONST(0.659960691877147) },
    { FRAC_CONST(0.746964636505118), FRAC_CONST(0.664863769362399) },
    { FRAC_CONST(0.742597145638433), FRAC_CONST(0.669738366296610) },
    { FRAC_CONST(0.738197844381584), FRAC_CONST(0.674584273868271) },
    { FRAC_CONST(0.733766921185995), FRAC_CONST(0.679401284494831) },
    { FRAC_CONST(0.729304565857668), FRAC_CONST(0.684189191831585) },
    { FRAC_CONST(0.724810969549055), FRAC_CONST(0.688947790780520) },
    { FRAC_CONST(0.720286324750863), FRAC_CONST(0.693676877499095) },
    { FRAC_CONST(0.715730825283819), FRAC_CONST(0.698376249408973) },
    { FRAC_CONST(0.711144666290356), FRAC_CONST(0.703045705204703) },
    { FRAC_CONST(0.706528044226263), FRAC_CONST(0.707685044862340) },
    { FRAC_CONST(0.701881156852263), FRAC_CONST(0.712294069648014) },
    { FRAC_CONST(0.697204203225545), FRAC_CONST(0.716872582126442) },
    { FRAC_CONST(0.692497383691237), FRAC_CONST(0.721420386169390) },
    { FRAC_CONST(0.687760899873822), FRAC_CONST(0.725937286964068) },
    { FRAC_CONST(0.682994954668502), FRAC_CONST(0.730423091021479) },
    { FRAC_CONST(0.678199752232508), FRAC_CONST(0.734877606184707) },
    { FRAC_CONST(0.673375497976352), FRAC_CONST(0.739300641637149) },
    { FRAC_CONST(0.668522398555031), FRAC_CONST(0.743692007910687) },
    { FRAC_CONST(0.663640661859171), FRAC_CONST(0.748051516893805) },
    { FRAC_CONST(0.658730497006124), FRAC_CONST(0.752378981839648) },
    { FRAC_CONST(0.653792114331011), FRAC_CONST(0.756674217374021) },
    { FRAC_CONST(0.648825725377709), FRAC_CONST(0.760937039503328) },
    { FRAC_CONST(0.643831542889792), FRAC_CONST(0.765167265622459) },
    { FRAC_CONST(0.638809780801414), FRAC_CONST(0.769364714522605) },
    { FRAC_CONST(0.633760654228152), FRAC_CONST(0.773529206399025) },
    { FRAC_CONST(0.628684379457781), FRAC_CONST(0.777660562858748) },
    { FRAC_CONST(0.623581173941019), FRAC_CONST(0.781758606928213) },
    { FRAC_CONST(0.618451256282204), FRAC_CONST(0.785823163060853) },
    { FRAC_CONST(0.613294846229936), FRAC_CONST(0.789854057144609) },
    { FRAC_CONST(0.608112164667659), FRAC_CONST(0.793851116509396) },
    { FRAC_CONST(0.602903433604202), FRAC_CONST(0.797814169934493) },
    { FRAC_CONST(0.597668876164268), FRAC_CONST(0.801743047655882) },
    { FRAC_CONST(0.592408716578875), FRAC_CONST(0.805637581373517) },
    { FRAC_CONST(0.587123180175754), FRAC_CONST(0.809497604258536) },
    { FRAC_CONST(0.581812493369691), FRAC_CONST(0.813322950960406) },
    { FRAC_CONST(0.576476883652835), FRAC_CONST(0.817113457614006) },
    { FRAC_CONST(0.571116579584947), FRAC_CONST(0.820868961846646) },
    { FRAC_CONST(0.565731810783613), FRAC_CONST(0.824589302785025) },
    { FRAC_CONST(0.560322807914407), FRAC_CONST(0.828274321062119) },
    { FRAC_CONST(0.554889802681009), FRAC_CONST(0.831923858824010) },
    { FRAC_CONST(0.549433027815281), FRAC_CONST(0.835537759736646) },
    { FRAC_CONST(0.543952717067296), FRAC_CONST(0.839115868992540) },
    { FRAC_CONST(0.538449105195327), FRAC_CONST(0.842658033317402) },
    { FRAC_CONST(0.532922427955790), FRAC_CONST(0.846164100976699) },
    { FRAC_CONST(0.527372922093142), FRAC_CONST(0.849633921782164) },
    { FRAC_CONST(0.521800825329746), FRAC_CONST(0.853067347098221) },
    { FRAC_CONST(0.516206376355680), FRAC_CONST(0.856464229848356) },
    { FRAC_CONST(0.510589814818519), FRAC_CONST(0.859824424521420) },
    { FRAC_CONST(0.504951381313066), FRAC_CONST(0.863147787177854) },
    { FRAC_CONST(0.499291317371047), FRAC_CONST(0.866434175455865) },
    { FRAC_CONST(0.493609865450762), FRAC_CONST(0.869683448577516) },
    { FRAC_CONST(0.487907268926702), FRAC_CONST(0.872895467354761) },
    { FRAC_CONST(0.482183772079123), FRAC_CONST(0.876070094195407) },
    { FRAC_CONST(0.476439620083580), FRAC_CONST(0.879207193109004) },
    { FRAC_CONST(0.470675059000427), FRAC_CONST(0.882306629712678) },
    { FRAC_CONST(0.464890335764274), FRAC_CONST(0.885368271236879) },
    { FRAC_CONST(0.459085698173413), FRAC_CONST(0.888391986531075) },
    { FRAC_CONST(0.453261394879198), FRAC_CONST(0.891377646069366) },
    { FRAC_CONST(0.447417675375397), FRAC_CONST(0.894325121956035) },
    { FRAC_CONST(0.441554789987504), FRAC_CONST(0.897234287931024) },
    { FRAC_CONST(0.435672989862017), FRAC_CONST(0.900105019375345) },
    { FRAC_CONST(0.429772526955677), FRAC_CONST(0.902937193316419) },
    { FRAC_CONST(0.423853654024676), FRAC_CONST(0.905730688433339) },
    { FRAC_CONST(0.417916624613831), FRAC_CONST(0.908485385062073) },
    { FRAC_CONST(0.411961693045722), FRAC_CONST(0.911201165200584) },
    { FRAC_CONST(0.405989114409798), FRAC_CONST(0.913877912513892) },
    { FRAC_CONST(0.399999144551449), FRAC_CONST(0.916515512339049) },
    { FRAC_CONST(0.393992040061048), FRAC_CONST(0.919113851690058) },
    { FRAC_CONST(0.387968058262959), FRAC_CONST(0.921672819262709) },
    { FRAC_CONST(0.381927457204511), FRAC_CONST(0.924192305439348) },
    { FRAC_CONST(0.375870495644949), FRAC_CONST(0.926672202293573) },
    { FRAC_CONST(0.369797433044349), FRAC_CONST(0.929112403594856) },
    { FRAC_CONST(0.363708529552499), FRAC_CONST(0.931512804813095) },
    { FRAC_CONST(0.357604045997758), FRAC_CONST(0.933873303123091) },
    { FRAC_CONST(0.351484243875885), FRAC_CONST(0.936193797408954) },
    { FRAC_CONST(0.345349385338836), FRAC_CONST(0.938474188268430) },
    { FRAC_CONST(0.339199733183530), FRAC_CONST(0.940714378017165) },
    { FRAC_CONST(0.333035550840599), FRAC_CONST(0.942914270692887) },
    { FRAC_CONST(0.326857102363098), FRAC_CONST(0.945073772059514) },
    { FRAC_CONST(0.320664652415198), FRAC_CONST(0.947192789611197) },
    { FRAC_CONST(0.314458466260842), FRAC_CONST(0.949271232576274) },
    { FRAC_CONST(0.308238809752391), FRAC_CONST(0.951309011921168) },
    { FRAC_CONST(0.302005949319228), FRAC_CONST(0.953306040354194) },
    { FRAC_CONST(0.295760151956351), FRAC_CONST(0.955262232329299) },
    { FRAC_CONST(0.289501685212929), FRAC_CONST(0.957177504049732) },
    { FRAC_CONST(0.283230817180850), FRAC_CONST(0.959051773471624) },
    { FRAC_CONST(0.276947816483228), FRAC_CONST(0.960884960307514) },
    { FRAC_CONST(0.270652952262902), FRAC_CONST(0.962676986029777) },
    { FRAC_CONST(0.264346494170904), FRAC_CONST(0.964427773873996) },
    { FRAC_CONST(0.258028712354909), FRAC_CONST(0.966137248842248) },
    { FRAC_CONST(0.251699877447663), FRAC_CONST(0.967805337706313) },
    { FRAC_CONST(0.245360260555389), FRAC_CONST(0.969431969010818) },
    { FRAC_CONST(0.239010133246176), FRAC_CONST(0.971017073076290) },
    { FRAC_CONST(0.232649767538342), FRAC_CONST(0.972560582002147) },
    { FRAC_CONST(0.226279435888785), FRAC_CONST(0.974062429669605) },
    { FRAC_CONST(0.219899411181310), FRAC_CONST(0.975522551744506) },
    { FRAC_CONST(0.213509966714943), FRAC_CONST(0.976940885680082) },
    { FRAC_CONST(0.207111376192219), FRAC_CONST(0.978317370719628) },
    { FRAC_CONST(0.200703913707458), FRAC_CONST(0.979651947899104) },
    { FRAC_CONST(0.194287853735029), FRAC_CONST(0.980944560049668) },
    { FRAC_CONST(0.187863471117585), FRAC_CONST(0.982195151800116) },
    { FRAC_CONST(0.181431041054297), FRAC_CONST(0.983403669579260) },
    { FRAC_CONST(0.174990839089060), FRAC_CONST(0.984570061618221) },
    { FRAC_CONST(0.168543141098691), FRAC_CONST(0.985694277952645) },
    { FRAC_CONST(0.162088223281113), FRAC_CONST(0.986776270424848) },
    { FRAC_CONST(0.155626362143520), FRAC_CONST(0.987815992685872) },
    { FRAC_CONST(0.149157834490539), FRAC_CONST(0.988813400197476) },
    { FRAC_CONST(0.142682917412363), FRAC_CONST(0.989768450234042) },
    { FRAC_CONST(0.136201888272891), FRAC_CONST(0.990681101884405) },
    { FRAC_CONST(0.129715024697841), FRAC_CONST(0.991551316053606) },
    { FRAC_CONST(0.123222604562857), FRAC_CONST(0.992379055464567) },
    { FRAC_CONST(0.116724905981611), FRAC_CONST(0.993164284659685) },
    { FRAC_CONST(0.110222207293883), FRAC_CONST(0.993906970002356) },
    { FRAC_CONST(0.103714787053643), FRAC_CONST(0.994607079678411) },
    { FRAC_CONST(0.097202924017115), FRAC_CONST(0.995264583697482) },
    { FRAC_CONST(0.090686897130838), FRAC_CONST(0.995879453894286) },
    { FRAC_CONST(0.084166985519718), FRAC_CONST(0.996451663929828) },
    { FRAC_CONST(0.077643468475068), FRAC_CONST(0.996981189292537) },
    { FRAC_CONST(0.071116625442645), FRAC_CONST(0.997468007299307) },
    { FRAC_CONST(0.064586736010684), FRAC_CONST(0.997912097096476) },
    { FRAC_CONST(0.058054079897912), FRAC_CONST(0.998313439660714) },
    { FRAC_CONST(0.051518936941578), FRAC_CONST(0.998672017799843) },
    { FRAC_CONST(0.044981587085452), FRAC_CONST(0.998987816153567) },
    { FRAC_CONST(0.038442310367847), FRAC_CONST(0.999260821194138) },
    { FRAC_CONST(0.031901386909611), FRAC_CONST(0.999491021226926) },
    { FRAC_CONST(0.025359096902136), FRAC_CONST(0.999678406390929) },
    { FRAC_CONST(0.018815720595351), FRAC_CONST(0.999822968659191) },
    { FRAC_CONST(0.012271538285720), FRAC_CONST(0.999924701839145) },
    { FRAC_CONST(0.005726830304231), FRAC_CONST(0.999983601572879) }
};
#endif // LD_DEC

/* 60 (N/4) complex twiddle factors */
ALIGN static const complex_t mdct_tab_240[] =
{
    { FRAC_CONST(0.999994645401696), FRAC_CONST(0.003272486506527) },
    { FRAC_CONST(0.999566308502021), FRAC_CONST(0.029448173247963) },
    { FRAC_CONST(0.998452918783950), FRAC_CONST(0.055603677682425) },
    { FRAC_CONST(0.996655239309180), FRAC_CONST(0.081721074133668) },
    { FRAC_CONST(0.994174502117428), FRAC_CONST(0.107782463042759) },
    { FRAC_CONST(0.991012407382049), FRAC_CONST(0.133769983235535) },
    { FRAC_CONST(0.987171122244825), FRAC_CONST(0.159665824163761) },
    { FRAC_CONST(0.982653279330712), FRAC_CONST(0.185452238111591) },
    { FRAC_CONST(0.977461974943572), FRAC_CONST(0.211111552358965) },
    { FRAC_CONST(0.971600766944121), FRAC_CONST(0.236626181293610) },
    { FRAC_CONST(0.965073672311547), FRAC_CONST(0.261978638463337) },
    { FRAC_CONST(0.957885164390477), FRAC_CONST(0.287151548560387) },
    { FRAC_CONST(0.950040169825165), FRAC_CONST(0.312127659329594) },
    { FRAC_CONST(0.941544065183021), FRAC_CONST(0.336889853392220) },
    { FRAC_CONST(0.932402673269775), FRAC_CONST(0.361421159977355) },
    { FRAC_CONST(0.922622259138823), FRAC_CONST(0.385704766552831) },
    { FRAC_CONST(0.912209525797468), FRAC_CONST(0.409724030347695) },
    { FRAC_CONST(0.901171609613013), FRAC_CONST(0.433462489758331) },
    { FRAC_CONST(0.889516075421856), FRAC_CONST(0.456903875630421) },
    { FRAC_CONST(0.877250911344924), FRAC_CONST(0.480032122409011) },
    { FRAC_CONST(0.864384523313017), FRAC_CONST(0.502831379149042) },
    { FRAC_CONST(0.850925729305802), FRAC_CONST(0.525286020378792) },
    { FRAC_CONST(0.836883753308409), FRAC_CONST(0.547380656808797) },
    { FRAC_CONST(0.822268218989775), FRAC_CONST(0.569100145878898) },
    { FRAC_CONST(0.807089143107059), FRAC_CONST(0.590429602136201) },
    { FRAC_CONST(0.791356928640660), FRAC_CONST(0.611354407436816) },
    { FRAC_CONST(0.775082357664531), FRAC_CONST(0.631860220964409) },
    { FRAC_CONST(0.758276583956687), FRAC_CONST(0.651932989058674) },
    { FRAC_CONST(0.740951125354959), FRAC_CONST(0.671558954847018) },
    { FRAC_CONST(0.723117855863248), FRAC_CONST(0.690724667672829) },
    { FRAC_CONST(0.704788997513670), FRAC_CONST(0.709416992313883) },
    { FRAC_CONST(0.685977111990193), FRAC_CONST(0.727623117984575) },
    { FRAC_CONST(0.666695092019479), FRAC_CONST(0.745330567115786) },
    { FRAC_CONST(0.646956152534857), FRAC_CONST(0.762527203906388) },
    { FRAC_CONST(0.626773821619469), FRAC_CONST(0.779201242640517) },
    { FRAC_CONST(0.606161931234795), FRAC_CONST(0.795341255764910) },
    { FRAC_CONST(0.585134607740916), FRAC_CONST(0.810936181720784) },
    { FRAC_CONST(0.563706262215017), FRAC_CONST(0.825975332524873) },
    { FRAC_CONST(0.541891580574752), FRAC_CONST(0.840448401094438) },
    { FRAC_CONST(0.519705513513249), FRAC_CONST(0.854345468311227) },
    { FRAC_CONST(0.497163266252654), FRAC_CONST(0.867657009819544) },
    { FRAC_CONST(0.474280288123229), FRAC_CONST(0.880373902553765) },
    { FRAC_CONST(0.451072261975153), FRAC_CONST(0.892487430990834) },
    { FRAC_CONST(0.427555093430282), FRAC_CONST(0.903989293123443) },
    { FRAC_CONST(0.403744899981227), FRAC_CONST(0.914871606149819) },
    { FRAC_CONST(0.379657999945233), FRAC_CONST(0.925126911876195) },
    { FRAC_CONST(0.355310901280416), FRAC_CONST(0.934748181828292) },
    { FRAC_CONST(0.330720290272038), FRAC_CONST(0.943728822068278) },
    { FRAC_CONST(0.305903020096554), FRAC_CONST(0.952062677713924) },
    { FRAC_CONST(0.280876099271292), FRAC_CONST(0.959744037156857) },
    { FRAC_CONST(0.255656679997665), FRAC_CONST(0.966767635977008) },
    { FRAC_CONST(0.230262046405902), FRAC_CONST(0.973128660550580) },
    { FRAC_CONST(0.204709602709380), FRAC_CONST(0.978822751349072) },
    { FRAC_CONST(0.179016861276633), FRAC_CONST(0.983846005927077) },
    { FRAC_CONST(0.153201430629259), FRAC_CONST(0.988194981596825) },
    { FRAC_CONST(0.127281003373913), FRAC_CONST(0.991866697787626) },
    { FRAC_CONST(0.101273344076683), FRAC_CONST(0.994858638088611) },
    { FRAC_CONST(0.075196277088140), FRAC_CONST(0.997168751973348) },
    { FRAC_CONST(0.049067674327418), FRAC_CONST(0.998795456205172) },
    { FRAC_CONST(0.022905443033697), FRAC_CONST(0.999737635922260) }
};
#endif // ALLOW_SMALL_FRAMELENGTH

#ifdef SSR_DEC
/* 128 (N/4) complex twiddle factors */
ALIGN static const complex_t mdct_tab_512[] =
{
    { FRAC_CONST(0.999998823451702), FRAC_CONST(0.001533980186285) },
    { FRAC_CONST(0.999904701082853), FRAC_CONST(0.013805388528060) },
    { FRAC_CONST(0.999659996743959), FRAC_CONST(0.026074717829104) },
    { FRAC_CONST(0.999264747286594), FRAC_CONST(0.038340120373553) },
    { FRAC_CONST(0.998719012233873), FRAC_CONST(0.050599749036899) },
    { FRAC_CONST(0.998022873771486), FRAC_CONST(0.062851757564161) },
    { FRAC_CONST(0.997176436735326), FRAC_CONST(0.075094300847921) },
    { FRAC_CONST(0.996179828595697), FRAC_CONST(0.087325535206192) },
    { FRAC_CONST(0.995033199438119), FRAC_CONST(0.099543618660069) },
    { FRAC_CONST(0.993736721940725), FRAC_CONST(0.111746711211127) },
    { FRAC_CONST(0.992290591348257), FRAC_CONST(0.123932975118512) },
    { FRAC_CONST(0.990695025442665), FRAC_CONST(0.136100575175706) },
    { FRAC_CONST(0.988950264510303), FRAC_CONST(0.148247678986896) },
    { FRAC_CONST(0.987056571305751), FRAC_CONST(0.160372457242928) },
    { FRAC_CONST(0.985014231012240), FRAC_CONST(0.172473083996796) },
    { FRAC_CONST(0.982823551198705), FRAC_CONST(0.184547736938620) },
    { FRAC_CONST(0.980484861773469), FRAC_CONST(0.196594597670080) },
    { FRAC_CONST(0.977998514934557), FRAC_CONST(0.208611851978263) },
    { FRAC_CONST(0.975364885116657), FRAC_CONST(0.220597690108874) },
    { FRAC_CONST(0.972584368934732), FRAC_CONST(0.232550307038775) },
    { FRAC_CONST(0.969657385124292), FRAC_CONST(0.244467902747824) },
    { FRAC_CONST(0.966584374478333), FRAC_CONST(0.256348682489943) },
    { FRAC_CONST(0.963365799780954), FRAC_CONST(0.268190857063403) },
    { FRAC_CONST(0.960002145737666), FRAC_CONST(0.279992643080273) },
    { FRAC_CONST(0.956493918902395), FRAC_CONST(0.291752263234989) },
    { FRAC_CONST(0.952841647601199), FRAC_CONST(0.303467946572011) },
    { FRAC_CONST(0.949045881852701), FRAC_CONST(0.315137928752522) },
    { FRAC_CONST(0.945107193285261), FRAC_CONST(0.326760452320132) },
    { FRAC_CONST(0.941026175050889), FRAC_CONST(0.338333766965541) },
    { FRAC_CONST(0.936803441735922), FRAC_CONST(0.349856129790135) },
    { FRAC_CONST(0.932439629268462), FRAC_CONST(0.361325805568454) },
    { FRAC_CONST(0.927935394822618), FRAC_CONST(0.372741067009516) },
    { FRAC_CONST(0.923291416719528), FRAC_CONST(0.384100195016935) },
    { FRAC_CONST(0.918508394325212), FRAC_CONST(0.395401478947816) },
    { FRAC_CONST(0.913587047945251), FRAC_CONST(0.406643216870369) },
    { FRAC_CONST(0.908528118716306), FRAC_CONST(0.417823715820212) },
    { FRAC_CONST(0.903332368494512), FRAC_CONST(0.428941292055329) },
    { FRAC_CONST(0.898000579740740), FRAC_CONST(0.439994271309633) },
    { FRAC_CONST(0.892533555402765), FRAC_CONST(0.450980989045104) },
    { FRAC_CONST(0.886932118794342), FRAC_CONST(0.461899790702463) },
    { FRAC_CONST(0.881197113471222), FRAC_CONST(0.472749031950343) },
    { FRAC_CONST(0.875329403104111), FRAC_CONST(0.483527078932919) },
    { FRAC_CONST(0.869329871348607), FRAC_CONST(0.494232308515960) },
    { FRAC_CONST(0.863199421712124), FRAC_CONST(0.504863108531268) },
    { FRAC_CONST(0.856938977417829), FRAC_CONST(0.515417878019463) },
    { FRAC_CONST(0.850549481265603), FRAC_CONST(0.525895027471085) },
    { FRAC_CONST(0.844031895490066), FRAC_CONST(0.536292979065963) },
    { FRAC_CONST(0.837387201615662), FRAC_CONST(0.546610166910835) },
    { FRAC_CONST(0.830616400308846), FRAC_CONST(0.556845037275160) },
    { FRAC_CONST(0.823720511227391), FRAC_CONST(0.566996048825109) },
    { FRAC_CONST(0.816700572866828), FRAC_CONST(0.577061672855679) },
    { FRAC_CONST(0.809557642404051), FRAC_CONST(0.587040393520918) },
    { FRAC_CONST(0.802292795538116), FRAC_CONST(0.596930708062197) },
    { FRAC_CONST(0.794907126328237), FRAC_CONST(0.606731127034524) },
    { FRAC_CONST(0.787401747029031), FRAC_CONST(0.616440174530854) },
    { FRAC_CONST(0.779777787923015), FRAC_CONST(0.626056388404344) },
    { FRAC_CONST(0.772036397150385), FRAC_CONST(0.635578320488556) },
    { FRAC_CONST(0.764178740536117), FRAC_CONST(0.645004536815544) },
    { FRAC_CONST(0.756206001414395), FRAC_CONST(0.654333617831800) },
    { FRAC_CONST(0.748119380450404), FRAC_CONST(0.663564158612040) },
    { FRAC_CONST(0.739920095459516), FRAC_CONST(0.672694769070773) },
    { FRAC_CONST(0.731609381223893), FRAC_CONST(0.681724074171650) },
    { FRAC_CONST(0.723188489306527), FRAC_CONST(0.690650714134535) },
    { FRAC_CONST(0.714658687862769), FRAC_CONST(0.699473344640284) },
    { FRAC_CONST(0.706021261449340), FRAC_CONST(0.708190637033195) },
    { FRAC_CONST(0.697277510830887), FRAC_CONST(0.716801278521100) },
    { FRAC_CONST(0.688428752784091), FRAC_CONST(0.725303972373061) },
    { FRAC_CONST(0.679476319899365), FRAC_CONST(0.733697438114660) },
    { FRAC_CONST(0.670421560380173), FRAC_CONST(0.741980411720831) },
    { FRAC_CONST(0.661265837839992), FRAC_CONST(0.750151645806215) },
    { FRAC_CONST(0.652010531096960), FRAC_CONST(0.758209909813015) },
    { FRAC_CONST(0.642657033966227), FRAC_CONST(0.766153990196313) },
    { FRAC_CONST(0.633206755050057), FRAC_CONST(0.773982690606823) },
    { FRAC_CONST(0.623661117525695), FRAC_CONST(0.781694832071059) },
    { FRAC_CONST(0.614021558931038), FRAC_CONST(0.789289253168886) },
    { FRAC_CONST(0.604289530948156), FRAC_CONST(0.796764810208419) },
    { FRAC_CONST(0.594466499184665), FRAC_CONST(0.804120377398266) },
    { FRAC_CONST(0.584553942953015), FRAC_CONST(0.811354847017064) },
    { FRAC_CONST(0.574553355047716), FRAC_CONST(0.818467129580299) },
    { FRAC_CONST(0.564466241520520), FRAC_CONST(0.825456154004377) },
    { FRAC_CONST(0.554294121453620), FRAC_CONST(0.832320867767930) },
    { FRAC_CONST(0.544038526730884), FRAC_CONST(0.839060237070313) },
    { FRAC_CONST(0.533701001807153), FRAC_CONST(0.845673246987299) },
    { FRAC_CONST(0.523283103475656), FRAC_CONST(0.852158901623920) },
    { FRAC_CONST(0.512786400633563), FRAC_CONST(0.858516224264443) },
    { FRAC_CONST(0.502212474045711), FRAC_CONST(0.864744257519462) },
    { FRAC_CONST(0.491562916106550), FRAC_CONST(0.870842063470079) },
    { FRAC_CONST(0.480839330600334), FRAC_CONST(0.876808723809146) },
    { FRAC_CONST(0.470043332459596), FRAC_CONST(0.882643339979563) },
    { FRAC_CONST(0.459176547521944), FRAC_CONST(0.888345033309596) },
    { FRAC_CONST(0.448240612285220), FRAC_CONST(0.893912945145203) },
    { FRAC_CONST(0.437237173661044), FRAC_CONST(0.899346236979341) },
    { FRAC_CONST(0.426167888726800), FRAC_CONST(0.904644090578246) },
    { FRAC_CONST(0.415034424476082), FRAC_CONST(0.909805708104652) },
    { FRAC_CONST(0.403838457567654), FRAC_CONST(0.914830312237946) },
    { FRAC_CONST(0.392581674072952), FRAC_CONST(0.919717146291227) },
    { FRAC_CONST(0.381265769222162), FRAC_CONST(0.924465474325263) },
    { FRAC_CONST(0.369892447148934), FRAC_CONST(0.929074581259316) },
    { FRAC_CONST(0.358463420633737), FRAC_CONST(0.933543772978836) },
    { FRAC_CONST(0.346980410845924), FRAC_CONST(0.937872376439990) },
    { FRAC_CONST(0.335445147084532), FRAC_CONST(0.942059739771017) },
    { FRAC_CONST(0.323859366517853), FRAC_CONST(0.946105232370403) },
    { FRAC_CONST(0.312224813921825), FRAC_CONST(0.950008245001843) },
    { FRAC_CONST(0.300543241417273), FRAC_CONST(0.953768189885990) },
    { FRAC_CONST(0.288816408206049), FRAC_CONST(0.957384500788976) },
    { FRAC_CONST(0.277046080306100), FRAC_CONST(0.960856633107680) },
    { FRAC_CONST(0.265234030285512), FRAC_CONST(0.964184063951746) },
    { FRAC_CONST(0.253382036995570), FRAC_CONST(0.967366292222329) },
    { FRAC_CONST(0.241491885302869), FRAC_CONST(0.970402838687556) },
    { FRAC_CONST(0.229565365820519), FRAC_CONST(0.973293246054698) },
    { FRAC_CONST(0.217604274638484), FRAC_CONST(0.976037079039039) },
    { FRAC_CONST(0.205610413053099), FRAC_CONST(0.978633924429423) },
    { FRAC_CONST(0.193585587295804), FRAC_CONST(0.981083391150487) },
    { FRAC_CONST(0.181531608261125), FRAC_CONST(0.983385110321551) },
    { FRAC_CONST(0.169450291233968), FRAC_CONST(0.985538735312176) },
    { FRAC_CONST(0.157343455616238), FRAC_CONST(0.987543941794359) },
    { FRAC_CONST(0.145212924652848), FRAC_CONST(0.989400427791380) },
    { FRAC_CONST(0.133060525157139), FRAC_CONST(0.991107913723277) },
    { FRAC_CONST(0.120888087235777), FRAC_CONST(0.992666142448948) },
    { FRAC_CONST(0.108697444013139), FRAC_CONST(0.994074879304879) },
    { FRAC_CONST(0.096490431355253), FRAC_CONST(0.995333912140482) },
    { FRAC_CONST(0.084268887593324), FRAC_CONST(0.996443051350043) },
    { FRAC_CONST(0.072034653246889), FRAC_CONST(0.997402129901275) },
    { FRAC_CONST(0.059789570746640), FRAC_CONST(0.998211003360478) },
    { FRAC_CONST(0.047535484156959), FRAC_CONST(0.998869549914284) },
    { FRAC_CONST(0.035274238898214), FRAC_CONST(0.999377670388003) },
    { FRAC_CONST(0.023007681468839), FRAC_CONST(0.999735288260562) },
    { FRAC_CONST(0.010737659167265), FRAC_CONST(0.999942349676024) }
};

/* 16 (N/4) complex twiddle factors */
ALIGN static const complex_t mdct_tab_64[] =
{
    { FRAC_CONST(0.999924701839145), FRAC_CONST(0.012271538285720) },
    { FRAC_CONST(0.993906970002356), FRAC_CONST(0.110222207293883) },
    { FRAC_CONST(0.978317370719628), FRAC_CONST(0.207111376192219) },
    { FRAC_CONST(0.953306040354194), FRAC_CONST(0.302005949319228) },
    { FRAC_CONST(0.919113851690058), FRAC_CONST(0.393992040061048) },
    { FRAC_CONST(0.876070094195407), FRAC_CONST(0.482183772079123) },
    { FRAC_CONST(0.824589302785025), FRAC_CONST(0.565731810783613) },
    { FRAC_CONST(0.765167265622459), FRAC_CONST(0.643831542889791) },
    { FRAC_CONST(0.698376249408973), FRAC_CONST(0.715730825283819) },
    { FRAC_CONST(0.624859488142386), FRAC_CONST(0.780737228572094) },
    { FRAC_CONST(0.545324988422046), FRAC_CONST(0.838224705554838) },
    { FRAC_CONST(0.460538710958240), FRAC_CONST(0.887639620402854) },
    { FRAC_CONST(0.371317193951838), FRAC_CONST(0.928506080473215) },
    { FRAC_CONST(0.278519689385053), FRAC_CONST(0.960430519415566) },
    { FRAC_CONST(0.183039887955141), FRAC_CONST(0.983105487431216) },
    { FRAC_CONST(0.085797312344440), FRAC_CONST(0.996312612182778) }
};
#endif // SSR_DEC

#else // FIXED_POINT

/* 256 (N/4) complex twiddle factors */
ALIGN static const complex_t mdct_tab_2048[] =
{
    { FRAC_CONST(0.031249997702054), FRAC_CONST(0.000011984224612) },
    { FRAC_CONST(0.031249813866531), FRAC_CONST(0.000107857810004) },
    { FRAC_CONST(0.031249335895858), FRAC_CONST(0.000203730380198) },
    { FRAC_CONST(0.031248563794535), FRAC_CONST(0.000299601032804) },
    { FRAC_CONST(0.031247497569829), FRAC_CONST(0.000395468865451) },
    { FRAC_CONST(0.031246137231775), FRAC_CONST(0.000491332975794) },
    { FRAC_CONST(0.031244482793177), FRAC_CONST(0.000587192461525) },
    { FRAC_CONST(0.031242534269608), FRAC_CONST(0.000683046420376) },
    { FRAC_CONST(0.031240291679407), FRAC_CONST(0.000778893950134) },
    { FRAC_CONST(0.031237755043684), FRAC_CONST(0.000874734148645) },
    { FRAC_CONST(0.031234924386313), FRAC_CONST(0.000970566113826) },
    { FRAC_CONST(0.031231799733938), FRAC_CONST(0.001066388943669) },
    { FRAC_CONST(0.031228381115970), FRAC_CONST(0.001162201736253) },
    { FRAC_CONST(0.031224668564585), FRAC_CONST(0.001258003589751) },
    { FRAC_CONST(0.031220662114728), FRAC_CONST(0.001353793602441) },
    { FRAC_CONST(0.031216361804108), FRAC_CONST(0.001449570872710) },
    { FRAC_CONST(0.031211767673203), FRAC_CONST(0.001545334499065) },
    { FRAC_CONST(0.031206879765253), FRAC_CONST(0.001641083580144) },
    { FRAC_CONST(0.031201698126266), FRAC_CONST(0.001736817214719) },
    { FRAC_CONST(0.031196222805014), FRAC_CONST(0.001832534501709) },
    { FRAC_CONST(0.031190453853031), FRAC_CONST(0.001928234540186) },
    { FRAC_CONST(0.031184391324617), FRAC_CONST(0.002023916429386) },
    { FRAC_CONST(0.031178035276836), FRAC_CONST(0.002119579268713) },
    { FRAC_CONST(0.031171385769513), FRAC_CONST(0.002215222157753) },
    { FRAC_CONST(0.031164442865236), FRAC_CONST(0.002310844196278) },
    { FRAC_CONST(0.031157206629353), FRAC_CONST(0.002406444484258) },
    { FRAC_CONST(0.031149677129975), FRAC_CONST(0.002502022121865) },
    { FRAC_CONST(0.031141854437973), FRAC_CONST(0.002597576209488) },
    { FRAC_CONST(0.031133738626977), FRAC_CONST(0.002693105847734) },
    { FRAC_CONST(0.031125329773375), FRAC_CONST(0.002788610137442) },
    { FRAC_CONST(0.031116627956316), FRAC_CONST(0.002884088179689) },
    { FRAC_CONST(0.031107633257703), FRAC_CONST(0.002979539075801) },
    { FRAC_CONST(0.031098345762200), FRAC_CONST(0.003074961927355) },
    { FRAC_CONST(0.031088765557222), FRAC_CONST(0.003170355836197) },
    { FRAC_CONST(0.031078892732942), FRAC_CONST(0.003265719904442) },
    { FRAC_CONST(0.031068727382288), FRAC_CONST(0.003361053234488) },
    { FRAC_CONST(0.031058269600939), FRAC_CONST(0.003456354929021) },
    { FRAC_CONST(0.031047519487329), FRAC_CONST(0.003551624091024) },
    { FRAC_CONST(0.031036477142640), FRAC_CONST(0.003646859823790) },
    { FRAC_CONST(0.031025142670809), FRAC_CONST(0.003742061230921) },
    { FRAC_CONST(0.031013516178519), FRAC_CONST(0.003837227416347) },
    { FRAC_CONST(0.031001597775203), FRAC_CONST(0.003932357484328) },
    { FRAC_CONST(0.030989387573042), FRAC_CONST(0.004027450539462) },
    { FRAC_CONST(0.030976885686963), FRAC_CONST(0.004122505686697) },
    { FRAC_CONST(0.030964092234638), FRAC_CONST(0.004217522031340) },
    { FRAC_CONST(0.030951007336485), FRAC_CONST(0.004312498679058) },
    { FRAC_CONST(0.030937631115663), FRAC_CONST(0.004407434735897) },
    { FRAC_CONST(0.030923963698074), FRAC_CONST(0.004502329308281) },
    { FRAC_CONST(0.030910005212362), FRAC_CONST(0.004597181503027) },
    { FRAC_CONST(0.030895755789908), FRAC_CONST(0.004691990427350) },
    { FRAC_CONST(0.030881215564835), FRAC_CONST(0.004786755188872) },
    { FRAC_CONST(0.030866384674000), FRAC_CONST(0.004881474895632) },
    { FRAC_CONST(0.030851263256996), FRAC_CONST(0.004976148656090) },
    { FRAC_CONST(0.030835851456154), FRAC_CONST(0.005070775579142) },
    { FRAC_CONST(0.030820149416533), FRAC_CONST(0.005165354774124) },
    { FRAC_CONST(0.030804157285929), FRAC_CONST(0.005259885350819) },
    { FRAC_CONST(0.030787875214864), FRAC_CONST(0.005354366419469) },
    { FRAC_CONST(0.030771303356593), FRAC_CONST(0.005448797090784) },
    { FRAC_CONST(0.030754441867095), FRAC_CONST(0.005543176475946) },
    { FRAC_CONST(0.030737290905077), FRAC_CONST(0.005637503686619) },
    { FRAC_CONST(0.030719850631972), FRAC_CONST(0.005731777834961) },
    { FRAC_CONST(0.030702121211932), FRAC_CONST(0.005825998033626) },
    { FRAC_CONST(0.030684102811835), FRAC_CONST(0.005920163395780) },
    { FRAC_CONST(0.030665795601276), FRAC_CONST(0.006014273035101) },
    { FRAC_CONST(0.030647199752570), FRAC_CONST(0.006108326065793) },
    { FRAC_CONST(0.030628315440748), FRAC_CONST(0.006202321602594) },
    { FRAC_CONST(0.030609142843557), FRAC_CONST(0.006296258760782) },
    { FRAC_CONST(0.030589682141455), FRAC_CONST(0.006390136656185) },
    { FRAC_CONST(0.030569933517616), FRAC_CONST(0.006483954405188) },
    { FRAC_CONST(0.030549897157919), FRAC_CONST(0.006577711124743) },
    { FRAC_CONST(0.030529573250956), FRAC_CONST(0.006671405932375) },
    { FRAC_CONST(0.030508961988022), FRAC_CONST(0.006765037946194) },
    { FRAC_CONST(0.030488063563118), FRAC_CONST(0.006858606284900) },
    { FRAC_CONST(0.030466878172949), FRAC_CONST(0.006952110067791) },
    { FRAC_CONST(0.030445406016919), FRAC_CONST(0.007045548414774) },
    { FRAC_CONST(0.030423647297133), FRAC_CONST(0.007138920446372) },
    { FRAC_CONST(0.030401602218392), FRAC_CONST(0.007232225283733) },
    { FRAC_CONST(0.030379270988192), FRAC_CONST(0.007325462048634) },
    { FRAC_CONST(0.030356653816724), FRAC_CONST(0.007418629863497) },
    { FRAC_CONST(0.030333750916869), FRAC_CONST(0.007511727851390) },
    { FRAC_CONST(0.030310562504198), FRAC_CONST(0.007604755136040) },
    { FRAC_CONST(0.030287088796968), FRAC_CONST(0.007697710841838) },
    { FRAC_CONST(0.030263330016124), FRAC_CONST(0.007790594093851) },
    { FRAC_CONST(0.030239286385293), FRAC_CONST(0.007883404017824) },
    { FRAC_CONST(0.030214958130781), FRAC_CONST(0.007976139740197) },
    { FRAC_CONST(0.030190345481576), FRAC_CONST(0.008068800388104) },
    { FRAC_CONST(0.030165448669342), FRAC_CONST(0.008161385089390) },
    { FRAC_CONST(0.030140267928416), FRAC_CONST(0.008253892972610) },
    { FRAC_CONST(0.030114803495809), FRAC_CONST(0.008346323167047) },
    { FRAC_CONST(0.030089055611203), FRAC_CONST(0.008438674802711) },
    { FRAC_CONST(0.030063024516947), FRAC_CONST(0.008530947010354) },
    { FRAC_CONST(0.030036710458054), FRAC_CONST(0.008623138921475) },
    { FRAC_CONST(0.030010113682202), FRAC_CONST(0.008715249668328) },
    { FRAC_CONST(0.029983234439732), FRAC_CONST(0.008807278383932) },
    { FRAC_CONST(0.029956072983640), FRAC_CONST(0.008899224202078) },
    { FRAC_CONST(0.029928629569580), FRAC_CONST(0.008991086257336) },
    { FRAC_CONST(0.029900904455860), FRAC_CONST(0.009082863685067) },
    { FRAC_CONST(0.029872897903441), FRAC_CONST(0.009174555621425) },
    { FRAC_CONST(0.029844610175929), FRAC_CONST(0.009266161203371) },
    { FRAC_CONST(0.029816041539579), FRAC_CONST(0.009357679568679) },
    { FRAC_CONST(0.029787192263292), FRAC_CONST(0.009449109855944) },
    { FRAC_CONST(0.029758062618606), FRAC_CONST(0.009540451204587) },
    { FRAC_CONST(0.029728652879702), FRAC_CONST(0.009631702754871) },
    { FRAC_CONST(0.029698963323395), FRAC_CONST(0.009722863647900) },
    { FRAC_CONST(0.029668994229134), FRAC_CONST(0.009813933025633) },
    { FRAC_CONST(0.029638745879000), FRAC_CONST(0.009904910030891) },
    { FRAC_CONST(0.029608218557702), FRAC_CONST(0.009995793807363) },
    { FRAC_CONST(0.029577412552575), FRAC_CONST(0.010086583499618) },
    { FRAC_CONST(0.029546328153577), FRAC_CONST(0.010177278253107) },
    { FRAC_CONST(0.029514965653285), FRAC_CONST(0.010267877214177) },
    { FRAC_CONST(0.029483325346896), FRAC_CONST(0.010358379530076) },
    { FRAC_CONST(0.029451407532220), FRAC_CONST(0.010448784348962) },
    { FRAC_CONST(0.029419212509679), FRAC_CONST(0.010539090819911) },
    { FRAC_CONST(0.029386740582307), FRAC_CONST(0.010629298092923) },
    { FRAC_CONST(0.029353992055740), FRAC_CONST(0.010719405318933) },
    { FRAC_CONST(0.029320967238220), FRAC_CONST(0.010809411649818) },
    { FRAC_CONST(0.029287666440590), FRAC_CONST(0.010899316238403) },
    { FRAC_CONST(0.029254089976290), FRAC_CONST(0.010989118238474) },
    { FRAC_CONST(0.029220238161353), FRAC_CONST(0.011078816804778) },
    { FRAC_CONST(0.029186111314406), FRAC_CONST(0.011168411093039) },
    { FRAC_CONST(0.029151709756664), FRAC_CONST(0.011257900259961) },
    { FRAC_CONST(0.029117033811927), FRAC_CONST(0.011347283463239) },
    { FRAC_CONST(0.029082083806579), FRAC_CONST(0.011436559861563) },
    { FRAC_CONST(0.029046860069582), FRAC_CONST(0.011525728614630) },
    { FRAC_CONST(0.029011362932476), FRAC_CONST(0.011614788883150) },
    { FRAC_CONST(0.028975592729373), FRAC_CONST(0.011703739828853) },
    { FRAC_CONST(0.028939549796957), FRAC_CONST(0.011792580614500) },
    { FRAC_CONST(0.028903234474475), FRAC_CONST(0.011881310403886) },
    { FRAC_CONST(0.028866647103744), FRAC_CONST(0.011969928361855) },
    { FRAC_CONST(0.028829788029135), FRAC_CONST(0.012058433654299) },
    { FRAC_CONST(0.028792657597583), FRAC_CONST(0.012146825448172) },
    { FRAC_CONST(0.028755256158571), FRAC_CONST(0.012235102911499) },
    { FRAC_CONST(0.028717584064137), FRAC_CONST(0.012323265213377) },
    { FRAC_CONST(0.028679641668864), FRAC_CONST(0.012411311523990) },
    { FRAC_CONST(0.028641429329882), FRAC_CONST(0.012499241014612) },
    { FRAC_CONST(0.028602947406859), FRAC_CONST(0.012587052857618) },
    { FRAC_CONST(0.028564196262001), FRAC_CONST(0.012674746226488) },
    { FRAC_CONST(0.028525176260050), FRAC_CONST(0.012762320295819) },
    { FRAC_CONST(0.028485887768276), FRAC_CONST(0.012849774241331) },
    { FRAC_CONST(0.028446331156478), FRAC_CONST(0.012937107239875) },
    { FRAC_CONST(0.028406506796976), FRAC_CONST(0.013024318469437) },
    { FRAC_CONST(0.028366415064615), FRAC_CONST(0.013111407109155) },
    { FRAC_CONST(0.028326056336751), FRAC_CONST(0.013198372339315) },
    { FRAC_CONST(0.028285430993258), FRAC_CONST(0.013285213341368) },
    { FRAC_CONST(0.028244539416515), FRAC_CONST(0.013371929297933) },
    { FRAC_CONST(0.028203381991411), FRAC_CONST(0.013458519392807) },
    { FRAC_CONST(0.028161959105334), FRAC_CONST(0.013544982810971) },
    { FRAC_CONST(0.028120271148172), FRAC_CONST(0.013631318738598) },
    { FRAC_CONST(0.028078318512309), FRAC_CONST(0.013717526363062) },
    { FRAC_CONST(0.028036101592619), FRAC_CONST(0.013803604872943) },
    { FRAC_CONST(0.027993620786463), FRAC_CONST(0.013889553458039) },
    { FRAC_CONST(0.027950876493687), FRAC_CONST(0.013975371309367) },
    { FRAC_CONST(0.027907869116616), FRAC_CONST(0.014061057619178) },
    { FRAC_CONST(0.027864599060052), FRAC_CONST(0.014146611580959) },
    { FRAC_CONST(0.027821066731270), FRAC_CONST(0.014232032389445) },
    { FRAC_CONST(0.027777272540012), FRAC_CONST(0.014317319240622) },
    { FRAC_CONST(0.027733216898487), FRAC_CONST(0.014402471331737) },
    { FRAC_CONST(0.027688900221361), FRAC_CONST(0.014487487861307) },
    { FRAC_CONST(0.027644322925762), FRAC_CONST(0.014572368029123) },
    { FRAC_CONST(0.027599485431266), FRAC_CONST(0.014657111036262) },
    { FRAC_CONST(0.027554388159903), FRAC_CONST(0.014741716085090) },
    { FRAC_CONST(0.027509031536144), FRAC_CONST(0.014826182379271) },
    { FRAC_CONST(0.027463415986904), FRAC_CONST(0.014910509123778) },
    { FRAC_CONST(0.027417541941533), FRAC_CONST(0.014994695524894) },
    { FRAC_CONST(0.027371409831816), FRAC_CONST(0.015078740790225) },
    { FRAC_CONST(0.027325020091965), FRAC_CONST(0.015162644128704) },
    { FRAC_CONST(0.027278373158618), FRAC_CONST(0.015246404750603) },
    { FRAC_CONST(0.027231469470833), FRAC_CONST(0.015330021867534) },
    { FRAC_CONST(0.027184309470088), FRAC_CONST(0.015413494692460) },
    { FRAC_CONST(0.027136893600268), FRAC_CONST(0.015496822439704) },
    { FRAC_CONST(0.027089222307671), FRAC_CONST(0.015580004324954) },
    { FRAC_CONST(0.027041296040997), FRAC_CONST(0.015663039565269) },
    { FRAC_CONST(0.026993115251345), FRAC_CONST(0.015745927379091) },
    { FRAC_CONST(0.026944680392213), FRAC_CONST(0.015828666986247) },
    { FRAC_CONST(0.026895991919487), FRAC_CONST(0.015911257607961) },
    { FRAC_CONST(0.026847050291442), FRAC_CONST(0.015993698466859) },
    { FRAC_CONST(0.026797855968734), FRAC_CONST(0.016075988786976) },
    { FRAC_CONST(0.026748409414401), FRAC_CONST(0.016158127793763) },
    { FRAC_CONST(0.026698711093851), FRAC_CONST(0.016240114714099) },
    { FRAC_CONST(0.026648761474864), FRAC_CONST(0.016321948776289) },
    { FRAC_CONST(0.026598561027585), FRAC_CONST(0.016403629210082) },
    { FRAC_CONST(0.026548110224519), FRAC_CONST(0.016485155246669) },
    { FRAC_CONST(0.026497409540530), FRAC_CONST(0.016566526118696) },
    { FRAC_CONST(0.026446459452830), FRAC_CONST(0.016647741060271) },
    { FRAC_CONST(0.026395260440982), FRAC_CONST(0.016728799306966) },
    { FRAC_CONST(0.026343812986890), FRAC_CONST(0.016809700095831) },
    { FRAC_CONST(0.026292117574797), FRAC_CONST(0.016890442665397) },
    { FRAC_CONST(0.026240174691280), FRAC_CONST(0.016971026255683) },
    { FRAC_CONST(0.026187984825246), FRAC_CONST(0.017051450108208) },
    { FRAC_CONST(0.026135548467924), FRAC_CONST(0.017131713465990) },
    { FRAC_CONST(0.026082866112867), FRAC_CONST(0.017211815573560) },
    { FRAC_CONST(0.026029938255941), FRAC_CONST(0.017291755676967) },
    { FRAC_CONST(0.025976765395322), FRAC_CONST(0.017371533023784) },
    { FRAC_CONST(0.025923348031494), FRAC_CONST(0.017451146863116) },
    { FRAC_CONST(0.025869686667242), FRAC_CONST(0.017530596445607) },
    { FRAC_CONST(0.025815781807646), FRAC_CONST(0.017609881023449) },
    { FRAC_CONST(0.025761633960080), FRAC_CONST(0.017688999850383) },
    { FRAC_CONST(0.025707243634204), FRAC_CONST(0.017767952181715) },
    { FRAC_CONST(0.025652611341960), FRAC_CONST(0.017846737274313) },
    { FRAC_CONST(0.025597737597568), FRAC_CONST(0.017925354386623) },
    { FRAC_CONST(0.025542622917522), FRAC_CONST(0.018003802778671) },
    { FRAC_CONST(0.025487267820581), FRAC_CONST(0.018082081712071) },
    { FRAC_CONST(0.025431672827768), FRAC_CONST(0.018160190450031) },
    { FRAC_CONST(0.025375838462365), FRAC_CONST(0.018238128257362) },
    { FRAC_CONST(0.025319765249906), FRAC_CONST(0.018315894400484) },
    { FRAC_CONST(0.025263453718173), FRAC_CONST(0.018393488147432) },
    { FRAC_CONST(0.025206904397193), FRAC_CONST(0.018470908767865) },
    { FRAC_CONST(0.025150117819228), FRAC_CONST(0.018548155533070) },
    { FRAC_CONST(0.025093094518776), FRAC_CONST(0.018625227715971) },
    { FRAC_CONST(0.025035835032562), FRAC_CONST(0.018702124591135) },
    { FRAC_CONST(0.024978339899534), FRAC_CONST(0.018778845434780) },
    { FRAC_CONST(0.024920609660858), FRAC_CONST(0.018855389524780) },
    { FRAC_CONST(0.024862644859912), FRAC_CONST(0.018931756140672) },
    { FRAC_CONST(0.024804446042284), FRAC_CONST(0.019007944563666) },
    { FRAC_CONST(0.024746013755764), FRAC_CONST(0.019083954076646) },
    { FRAC_CONST(0.024687348550337), FRAC_CONST(0.019159783964183) },
    { FRAC_CONST(0.024628450978184), FRAC_CONST(0.019235433512536) },
    { FRAC_CONST(0.024569321593670), FRAC_CONST(0.019310902009663) },
    { FRAC_CONST(0.024509960953345), FRAC_CONST(0.019386188745225) },
    { FRAC_CONST(0.024450369615932), FRAC_CONST(0.019461293010596) },
    { FRAC_CONST(0.024390548142329), FRAC_CONST(0.019536214098866) },
    { FRAC_CONST(0.024330497095598), FRAC_CONST(0.019610951304848) },
    { FRAC_CONST(0.024270217040961), FRAC_CONST(0.019685503925087) },
    { FRAC_CONST(0.024209708545799), FRAC_CONST(0.019759871257867) },
    { FRAC_CONST(0.024148972179639), FRAC_CONST(0.019834052603212) },
    { FRAC_CONST(0.024088008514157), FRAC_CONST(0.019908047262901) },
    { FRAC_CONST(0.024026818123164), FRAC_CONST(0.019981854540467) },
    { FRAC_CONST(0.023965401582609), FRAC_CONST(0.020055473741208) },
    { FRAC_CONST(0.023903759470567), FRAC_CONST(0.020128904172192) },
    { FRAC_CONST(0.023841892367236), FRAC_CONST(0.020202145142264) },
    { FRAC_CONST(0.023779800854935), FRAC_CONST(0.020275195962052) },
    { FRAC_CONST(0.023717485518092), FRAC_CONST(0.020348055943974) },
    { FRAC_CONST(0.023654946943242), FRAC_CONST(0.020420724402244) },
    { FRAC_CONST(0.023592185719023), FRAC_CONST(0.020493200652878) },
    { FRAC_CONST(0.023529202436167), FRAC_CONST(0.020565484013703) },
    { FRAC_CONST(0.023465997687496), FRAC_CONST(0.020637573804361) },
    { FRAC_CONST(0.023402572067918), FRAC_CONST(0.020709469346314) },
    { FRAC_CONST(0.023338926174419), FRAC_CONST(0.020781169962854) },
    { FRAC_CONST(0.023275060606058), FRAC_CONST(0.020852674979108) },
    { FRAC_CONST(0.023210975963963), FRAC_CONST(0.020923983722044) },
    { FRAC_CONST(0.023146672851322), FRAC_CONST(0.020995095520475) },
    { FRAC_CONST(0.023082151873380), FRAC_CONST(0.021066009705072) },
    { FRAC_CONST(0.023017413637435), FRAC_CONST(0.021136725608363) },
    { FRAC_CONST(0.022952458752826), FRAC_CONST(0.021207242564742) },
    { FRAC_CONST(0.022887287830934), FRAC_CONST(0.021277559910478) },
    { FRAC_CONST(0.022821901485173), FRAC_CONST(0.021347676983716) },
    { FRAC_CONST(0.022756300330983), FRAC_CONST(0.021417593124488) },
    { FRAC_CONST(0.022690484985827), FRAC_CONST(0.021487307674717) },
    { FRAC_CONST(0.022624456069185), FRAC_CONST(0.021556819978223) },
    { FRAC_CONST(0.022558214202547), FRAC_CONST(0.021626129380729) },
    { FRAC_CONST(0.022491760009405), FRAC_CONST(0.021695235229869) },
    { FRAC_CONST(0.022425094115252), FRAC_CONST(0.021764136875192) },
    { FRAC_CONST(0.022358217147572), FRAC_CONST(0.021832833668171) },
    { FRAC_CONST(0.022291129735838), FRAC_CONST(0.021901324962204) },
    { FRAC_CONST(0.022223832511501), FRAC_CONST(0.021969610112625) },
    { FRAC_CONST(0.022156326107988), FRAC_CONST(0.022037688476709) },
    { FRAC_CONST(0.022088611160696), FRAC_CONST(0.022105559413676) },
    { FRAC_CONST(0.022020688306983), FRAC_CONST(0.022173222284699) },
    { FRAC_CONST(0.021952558186166), FRAC_CONST(0.022240676452909) },
    { FRAC_CONST(0.021884221439510), FRAC_CONST(0.022307921283403) },
    { FRAC_CONST(0.021815678710228), FRAC_CONST(0.022374956143245) },
    { FRAC_CONST(0.021746930643469), FRAC_CONST(0.022441780401478) },
    { FRAC_CONST(0.021677977886316), FRAC_CONST(0.022508393429127) },
    { FRAC_CONST(0.021608821087780), FRAC_CONST(0.022574794599206) },
    { FRAC_CONST(0.021539460898790), FRAC_CONST(0.022640983286719) },
    { FRAC_CONST(0.021469897972190), FRAC_CONST(0.022706958868676) },
    { FRAC_CONST(0.021400132962735), FRAC_CONST(0.022772720724087) },
    { FRAC_CONST(0.021330166527077), FRAC_CONST(0.022838268233979) },
    { FRAC_CONST(0.021259999323769), FRAC_CONST(0.022903600781391) },
    { FRAC_CONST(0.021189632013250), FRAC_CONST(0.022968717751391) },
    { FRAC_CONST(0.021119065257845), FRAC_CONST(0.023033618531071) },
    { FRAC_CONST(0.021048299721754), FRAC_CONST(0.023098302509561) },
    { FRAC_CONST(0.020977336071050), FRAC_CONST(0.023162769078031) },
    { FRAC_CONST(0.020906174973670), FRAC_CONST(0.023227017629698) },
    { FRAC_CONST(0.020834817099409), FRAC_CONST(0.023291047559828) },
    { FRAC_CONST(0.020763263119915), FRAC_CONST(0.023354858265748) },
    { FRAC_CONST(0.020691513708680), FRAC_CONST(0.023418449146848) },
    { FRAC_CONST(0.020619569541038), FRAC_CONST(0.023481819604585) },
    { FRAC_CONST(0.020547431294155), FRAC_CONST(0.023544969042494) },
    { FRAC_CONST(0.020475099647023), FRAC_CONST(0.023607896866186) },
    { FRAC_CONST(0.020402575280455), FRAC_CONST(0.023670602483363) },
    { FRAC_CONST(0.020329858877078), FRAC_CONST(0.023733085303813) },
    { FRAC_CONST(0.020256951121327), FRAC_CONST(0.023795344739427) },
    { FRAC_CONST(0.020183852699437), FRAC_CONST(0.023857380204193) },
    { FRAC_CONST(0.020110564299439), FRAC_CONST(0.023919191114211) },
    { FRAC_CONST(0.020037086611150), FRAC_CONST(0.023980776887692) },
    { FRAC_CONST(0.019963420326171), FRAC_CONST(0.024042136944968) },
    { FRAC_CONST(0.019889566137877), FRAC_CONST(0.024103270708495) },
    { FRAC_CONST(0.019815524741412), FRAC_CONST(0.024164177602859) },
    { FRAC_CONST(0.019741296833681), FRAC_CONST(0.024224857054779) },
    { FRAC_CONST(0.019666883113346), FRAC_CONST(0.024285308493120) },
    { FRAC_CONST(0.019592284280817), FRAC_CONST(0.024345531348888) },
    { FRAC_CONST(0.019517501038246), FRAC_CONST(0.024405525055242) },
    { FRAC_CONST(0.019442534089523), FRAC_CONST(0.024465289047500) },
    { FRAC_CONST(0.019367384140264), FRAC_CONST(0.024524822763141) },
    { FRAC_CONST(0.019292051897809), FRAC_CONST(0.024584125641809) },
    { FRAC_CONST(0.019216538071215), FRAC_CONST(0.024643197125323) },
    { FRAC_CONST(0.019140843371246), FRAC_CONST(0.024702036657681) },
    { FRAC_CONST(0.019064968510369), FRAC_CONST(0.024760643685063) },
    { FRAC_CONST(0.018988914202748), FRAC_CONST(0.024819017655836) },
    { FRAC_CONST(0.018912681164234), FRAC_CONST(0.024877158020562) },
    { FRAC_CONST(0.018836270112363), FRAC_CONST(0.024935064232003) },
    { FRAC_CONST(0.018759681766343), FRAC_CONST(0.024992735745123) },
    { FRAC_CONST(0.018682916847054), FRAC_CONST(0.025050172017095) },
    { FRAC_CONST(0.018605976077037), FRAC_CONST(0.025107372507308) },
    { FRAC_CONST(0.018528860180486), FRAC_CONST(0.025164336677369) },
    { FRAC_CONST(0.018451569883247), FRAC_CONST(0.025221063991110) },
    { FRAC_CONST(0.018374105912805), FRAC_CONST(0.025277553914591) },
    { FRAC_CONST(0.018296468998280), FRAC_CONST(0.025333805916107) },
    { FRAC_CONST(0.018218659870421), FRAC_CONST(0.025389819466194) },
    { FRAC_CONST(0.018140679261596), FRAC_CONST(0.025445594037630) },
    { FRAC_CONST(0.018062527905790), FRAC_CONST(0.025501129105445) },
    { FRAC_CONST(0.017984206538592), FRAC_CONST(0.025556424146920) },
    { FRAC_CONST(0.017905715897192), FRAC_CONST(0.025611478641598) },
    { FRAC_CONST(0.017827056720375), FRAC_CONST(0.025666292071285) },
    { FRAC_CONST(0.017748229748511), FRAC_CONST(0.025720863920056) },
    { FRAC_CONST(0.017669235723550), FRAC_CONST(0.025775193674260) },
    { FRAC_CONST(0.017590075389012), FRAC_CONST(0.025829280822525) },
    { FRAC_CONST(0.017510749489986), FRAC_CONST(0.025883124855762) },
    { FRAC_CONST(0.017431258773116), FRAC_CONST(0.025936725267170) },
    { FRAC_CONST(0.017351603986600), FRAC_CONST(0.025990081552242) },
    { FRAC_CONST(0.017271785880180), FRAC_CONST(0.026043193208768) },
    { FRAC_CONST(0.017191805205132), FRAC_CONST(0.026096059736841) },
    { FRAC_CONST(0.017111662714267), FRAC_CONST(0.026148680638861) },
    { FRAC_CONST(0.017031359161915), FRAC_CONST(0.026201055419541) },
    { FRAC_CONST(0.016950895303924), FRAC_CONST(0.026253183585908) },
    { FRAC_CONST(0.016870271897651), FRAC_CONST(0.026305064647313) },
    { FRAC_CONST(0.016789489701954), FRAC_CONST(0.026356698115431) },
    { FRAC_CONST(0.016708549477186), FRAC_CONST(0.026408083504269) },
    { FRAC_CONST(0.016627451985187), FRAC_CONST(0.026459220330167) },
    { FRAC_CONST(0.016546197989277), FRAC_CONST(0.026510108111806) },
    { FRAC_CONST(0.016464788254250), FRAC_CONST(0.026560746370212) },
    { FRAC_CONST(0.016383223546365), FRAC_CONST(0.026611134628757) },
    { FRAC_CONST(0.016301504633341), FRAC_CONST(0.026661272413168) },
    { FRAC_CONST(0.016219632284346), FRAC_CONST(0.026711159251530) },
    { FRAC_CONST(0.016137607269996), FRAC_CONST(0.026760794674288) },
    { FRAC_CONST(0.016055430362340), FRAC_CONST(0.026810178214254) },
    { FRAC_CONST(0.015973102334858), FRAC_CONST(0.026859309406613) },
    { FRAC_CONST(0.015890623962454), FRAC_CONST(0.026908187788922) },
    { FRAC_CONST(0.015807996021446), FRAC_CONST(0.026956812901119) },
    { FRAC_CONST(0.015725219289558), FRAC_CONST(0.027005184285527) },
    { FRAC_CONST(0.015642294545918), FRAC_CONST(0.027053301486856) },
    { FRAC_CONST(0.015559222571044), FRAC_CONST(0.027101164052208) },
    { FRAC_CONST(0.015476004146842), FRAC_CONST(0.027148771531083) },
    { FRAC_CONST(0.015392640056594), FRAC_CONST(0.027196123475380) },
    { FRAC_CONST(0.015309131084956), FRAC_CONST(0.027243219439406) },
    { FRAC_CONST(0.015225478017946), FRAC_CONST(0.027290058979875) },
    { FRAC_CONST(0.015141681642938), FRAC_CONST(0.027336641655915) },
    { FRAC_CONST(0.015057742748656), FRAC_CONST(0.027382967029073) },
    { FRAC_CONST(0.014973662125164), FRAC_CONST(0.027429034663317) },
    { FRAC_CONST(0.014889440563862), FRAC_CONST(0.027474844125040) },
    { FRAC_CONST(0.014805078857474), FRAC_CONST(0.027520394983066) },
    { FRAC_CONST(0.014720577800046), FRAC_CONST(0.027565686808654) },
    { FRAC_CONST(0.014635938186934), FRAC_CONST(0.027610719175499) },
    { FRAC_CONST(0.014551160814797), FRAC_CONST(0.027655491659740) },
    { FRAC_CONST(0.014466246481592), FRAC_CONST(0.027700003839960) },
    { FRAC_CONST(0.014381195986567), FRAC_CONST(0.027744255297195) },
    { FRAC_CONST(0.014296010130247), FRAC_CONST(0.027788245614933) },
    { FRAC_CONST(0.014210689714436), FRAC_CONST(0.027831974379120) },
    { FRAC_CONST(0.014125235542201), FRAC_CONST(0.027875441178165) },
    { FRAC_CONST(0.014039648417870), FRAC_CONST(0.027918645602941) },
    { FRAC_CONST(0.013953929147020), FRAC_CONST(0.027961587246792) },
    { FRAC_CONST(0.013868078536476), FRAC_CONST(0.028004265705534) },
    { FRAC_CONST(0.013782097394294), FRAC_CONST(0.028046680577462) },
    { FRAC_CONST(0.013695986529763), FRAC_CONST(0.028088831463351) },
    { FRAC_CONST(0.013609746753390), FRAC_CONST(0.028130717966461) },
    { FRAC_CONST(0.013523378876898), FRAC_CONST(0.028172339692540) },
    { FRAC_CONST(0.013436883713214), FRAC_CONST(0.028213696249828) },
    { FRAC_CONST(0.013350262076462), FRAC_CONST(0.028254787249062) },
    { FRAC_CONST(0.013263514781960), FRAC_CONST(0.028295612303478) },
    { FRAC_CONST(0.013176642646205), FRAC_CONST(0.028336171028814) },
    { FRAC_CONST(0.013089646486871), FRAC_CONST(0.028376463043317) },
    { FRAC_CONST(0.013002527122799), FRAC_CONST(0.028416487967743) },
    { FRAC_CONST(0.012915285373990), FRAC_CONST(0.028456245425361) },
    { FRAC_CONST(0.012827922061597), FRAC_CONST(0.028495735041960) },
    { FRAC_CONST(0.012740438007915), FRAC_CONST(0.028534956445849) },
    { FRAC_CONST(0.012652834036379), FRAC_CONST(0.028573909267859) },
    { FRAC_CONST(0.012565110971550), FRAC_CONST(0.028612593141354) },
    { FRAC_CONST(0.012477269639111), FRAC_CONST(0.028651007702224) },
    { FRAC_CONST(0.012389310865858), FRAC_CONST(0.028689152588899) },
    { FRAC_CONST(0.012301235479693), FRAC_CONST(0.028727027442343) },
    { FRAC_CONST(0.012213044309615), FRAC_CONST(0.028764631906065) },
    { FRAC_CONST(0.012124738185712), FRAC_CONST(0.028801965626115) },
    { FRAC_CONST(0.012036317939156), FRAC_CONST(0.028839028251097) },
    { FRAC_CONST(0.011947784402191), FRAC_CONST(0.028875819432161) },
    { FRAC_CONST(0.011859138408130), FRAC_CONST(0.028912338823015) },
    { FRAC_CONST(0.011770380791341), FRAC_CONST(0.028948586079925) },
    { FRAC_CONST(0.011681512387245), FRAC_CONST(0.028984560861718) },
    { FRAC_CONST(0.011592534032306), FRAC_CONST(0.029020262829785) },
    { FRAC_CONST(0.011503446564022), FRAC_CONST(0.029055691648087) },
    { FRAC_CONST(0.011414250820918), FRAC_CONST(0.029090846983152) },
    { FRAC_CONST(0.011324947642537), FRAC_CONST(0.029125728504087) },
    { FRAC_CONST(0.011235537869437), FRAC_CONST(0.029160335882573) },
    { FRAC_CONST(0.011146022343175), FRAC_CONST(0.029194668792871) },
    { FRAC_CONST(0.011056401906305), FRAC_CONST(0.029228726911828) },
    { FRAC_CONST(0.010966677402371), FRAC_CONST(0.029262509918876) },
    { FRAC_CONST(0.010876849675891), FRAC_CONST(0.029296017496036) },
    { FRAC_CONST(0.010786919572361), FRAC_CONST(0.029329249327922) },
    { FRAC_CONST(0.010696887938235), FRAC_CONST(0.029362205101743) },
    { FRAC_CONST(0.010606755620926), FRAC_CONST(0.029394884507308) },
    { FRAC_CONST(0.010516523468793), FRAC_CONST(0.029427287237024) },
    { FRAC_CONST(0.010426192331137), FRAC_CONST(0.029459412985906) },
    { FRAC_CONST(0.010335763058187), FRAC_CONST(0.029491261451573) },
    { FRAC_CONST(0.010245236501099), FRAC_CONST(0.029522832334255) },
    { FRAC_CONST(0.010154613511943), FRAC_CONST(0.029554125336796) },
    { FRAC_CONST(0.010063894943698), FRAC_CONST(0.029585140164654) },
    { FRAC_CONST(0.009973081650240), FRAC_CONST(0.029615876525905) },
    { FRAC_CONST(0.009882174486340), FRAC_CONST(0.029646334131247) },
    { FRAC_CONST(0.009791174307650), FRAC_CONST(0.029676512694001) },
    { FRAC_CONST(0.009700081970699), FRAC_CONST(0.029706411930116) },
    { FRAC_CONST(0.009608898332881), FRAC_CONST(0.029736031558168) },
    { FRAC_CONST(0.009517624252453), FRAC_CONST(0.029765371299366) },
    { FRAC_CONST(0.009426260588521), FRAC_CONST(0.029794430877553) },
    { FRAC_CONST(0.009334808201034), FRAC_CONST(0.029823210019210) },
    { FRAC_CONST(0.009243267950778), FRAC_CONST(0.029851708453456) },
    { FRAC_CONST(0.009151640699363), FRAC_CONST(0.029879925912053) },
    { FRAC_CONST(0.009059927309220), FRAC_CONST(0.029907862129408) },
    { FRAC_CONST(0.008968128643591), FRAC_CONST(0.029935516842573) },
    { FRAC_CONST(0.008876245566520), FRAC_CONST(0.029962889791254) },
    { FRAC_CONST(0.008784278942845), FRAC_CONST(0.029989980717805) },
    { FRAC_CONST(0.008692229638191), FRAC_CONST(0.030016789367235) },
    { FRAC_CONST(0.008600098518961), FRAC_CONST(0.030043315487212) },
    { FRAC_CONST(0.008507886452329), FRAC_CONST(0.030069558828062) },
    { FRAC_CONST(0.008415594306230), FRAC_CONST(0.030095519142772) },
    { FRAC_CONST(0.008323222949351), FRAC_CONST(0.030121196186994) },
    { FRAC_CONST(0.008230773251129), FRAC_CONST(0.030146589719046) },
    { FRAC_CONST(0.008138246081733), FRAC_CONST(0.030171699499915) },
    { FRAC_CONST(0.008045642312067), FRAC_CONST(0.030196525293257) },
    { FRAC_CONST(0.007952962813750), FRAC_CONST(0.030221066865402) },
    { FRAC_CONST(0.007860208459119), FRAC_CONST(0.030245323985357) },
    { FRAC_CONST(0.007767380121212), FRAC_CONST(0.030269296424803) },
    { FRAC_CONST(0.007674478673766), FRAC_CONST(0.030292983958103) },
    { FRAC_CONST(0.007581504991203), FRAC_CONST(0.030316386362302) },
    { FRAC_CONST(0.007488459948628), FRAC_CONST(0.030339503417126) },
    { FRAC_CONST(0.007395344421816), FRAC_CONST(0.030362334904989) },
    { FRAC_CONST(0.007302159287206), FRAC_CONST(0.030384880610993) },
    { FRAC_CONST(0.007208905421891), FRAC_CONST(0.030407140322928) },
    { FRAC_CONST(0.007115583703613), FRAC_CONST(0.030429113831278) },
    { FRAC_CONST(0.007022195010752), FRAC_CONST(0.030450800929220) },
    { FRAC_CONST(0.006928740222316), FRAC_CONST(0.030472201412626) },
    { FRAC_CONST(0.006835220217939), FRAC_CONST(0.030493315080068) },
    { FRAC_CONST(0.006741635877866), FRAC_CONST(0.030514141732814) },
    { FRAC_CONST(0.006647988082948), FRAC_CONST(0.030534681174838) },
    { FRAC_CONST(0.006554277714635), FRAC_CONST(0.030554933212813) },
    { FRAC_CONST(0.006460505654964), FRAC_CONST(0.030574897656119) },
    { FRAC_CONST(0.006366672786553), FRAC_CONST(0.030594574316845) },
    { FRAC_CONST(0.006272779992593), FRAC_CONST(0.030613963009786) },
    { FRAC_CONST(0.006178828156839), FRAC_CONST(0.030633063552447) },
    { FRAC_CONST(0.006084818163601), FRAC_CONST(0.030651875765048) },
    { FRAC_CONST(0.005990750897737), FRAC_CONST(0.030670399470520) },
    { FRAC_CONST(0.005896627244644), FRAC_CONST(0.030688634494512) },
    { FRAC_CONST(0.005802448090250), FRAC_CONST(0.030706580665388) },
    { FRAC_CONST(0.005708214321004), FRAC_CONST(0.030724237814232) },
    { FRAC_CONST(0.005613926823871), FRAC_CONST(0.030741605774849) },
    { FRAC_CONST(0.005519586486321), FRAC_CONST(0.030758684383764) },
    { FRAC_CONST(0.005425194196321), FRAC_CONST(0.030775473480228) },
    { FRAC_CONST(0.005330750842327), FRAC_CONST(0.030791972906214) },
    { FRAC_CONST(0.005236257313276), FRAC_CONST(0.030808182506425) },
    { FRAC_CONST(0.005141714498576), FRAC_CONST(0.030824102128288) },
    { FRAC_CONST(0.005047123288102), FRAC_CONST(0.030839731621963) },
    { FRAC_CONST(0.004952484572181), FRAC_CONST(0.030855070840339) },
    { FRAC_CONST(0.004857799241589), FRAC_CONST(0.030870119639036) },
    { FRAC_CONST(0.004763068187541), FRAC_CONST(0.030884877876411) },
    { FRAC_CONST(0.004668292301681), FRAC_CONST(0.030899345413553) },
    { FRAC_CONST(0.004573472476075), FRAC_CONST(0.030913522114288) },
    { FRAC_CONST(0.004478609603205), FRAC_CONST(0.030927407845180) },
    { FRAC_CONST(0.004383704575956), FRAC_CONST(0.030941002475530) },
    { FRAC_CONST(0.004288758287610), FRAC_CONST(0.030954305877381) },
    { FRAC_CONST(0.004193771631837), FRAC_CONST(0.030967317925516) },
    { FRAC_CONST(0.004098745502689), FRAC_CONST(0.030980038497461) },
    { FRAC_CONST(0.004003680794587), FRAC_CONST(0.030992467473486) },
    { FRAC_CONST(0.003908578402316), FRAC_CONST(0.031004604736602) },
    { FRAC_CONST(0.003813439221017), FRAC_CONST(0.031016450172571) },
    { FRAC_CONST(0.003718264146176), FRAC_CONST(0.031028003669899) },
    { FRAC_CONST(0.003623054073616), FRAC_CONST(0.031039265119839) },
    { FRAC_CONST(0.003527809899492), FRAC_CONST(0.031050234416394) },
    { FRAC_CONST(0.003432532520278), FRAC_CONST(0.031060911456318) },
    { FRAC_CONST(0.003337222832760), FRAC_CONST(0.031071296139114) },
    { FRAC_CONST(0.003241881734029), FRAC_CONST(0.031081388367037) },
    { FRAC_CONST(0.003146510121474), FRAC_CONST(0.031091188045095) },
    { FRAC_CONST(0.003051108892766), FRAC_CONST(0.031100695081051) },
    { FRAC_CONST(0.002955678945860), FRAC_CONST(0.031109909385419) },
    { FRAC_CONST(0.002860221178978), FRAC_CONST(0.031118830871473) },
    { FRAC_CONST(0.002764736490604), FRAC_CONST(0.031127459455239) },
    { FRAC_CONST(0.002669225779478), FRAC_CONST(0.031135795055501) },
    { FRAC_CONST(0.002573689944583), FRAC_CONST(0.031143837593803) },
    { FRAC_CONST(0.002478129885137), FRAC_CONST(0.031151586994444) },
    { FRAC_CONST(0.002382546500589), FRAC_CONST(0.031159043184484) },
    { FRAC_CONST(0.002286940690606), FRAC_CONST(0.031166206093743) },
    { FRAC_CONST(0.002191313355067), FRAC_CONST(0.031173075654800) },
    { FRAC_CONST(0.002095665394051), FRAC_CONST(0.031179651802998) },
    { FRAC_CONST(0.001999997707835), FRAC_CONST(0.031185934476438) },
    { FRAC_CONST(0.001904311196878), FRAC_CONST(0.031191923615985) },
    { FRAC_CONST(0.001808606761820), FRAC_CONST(0.031197619165268) },
    { FRAC_CONST(0.001712885303465), FRAC_CONST(0.031203021070678) },
    { FRAC_CONST(0.001617147722782), FRAC_CONST(0.031208129281370) },
    { FRAC_CONST(0.001521394920889), FRAC_CONST(0.031212943749264) },
    { FRAC_CONST(0.001425627799047), FRAC_CONST(0.031217464429043) },
    { FRAC_CONST(0.001329847258653), FRAC_CONST(0.031221691278159) },
    { FRAC_CONST(0.001234054201231), FRAC_CONST(0.031225624256825) },
    { FRAC_CONST(0.001138249528420), FRAC_CONST(0.031229263328024) },
    { FRAC_CONST(0.001042434141971), FRAC_CONST(0.031232608457502) },
    { FRAC_CONST(0.000946608943736), FRAC_CONST(0.031235659613775) },
    { FRAC_CONST(0.000850774835656), FRAC_CONST(0.031238416768124) },
    { FRAC_CONST(0.000754932719759), FRAC_CONST(0.031240879894597) },
    { FRAC_CONST(0.000659083498149), FRAC_CONST(0.031243048970010) },
    { FRAC_CONST(0.000563228072993), FRAC_CONST(0.031244923973948) },
    { FRAC_CONST(0.000467367346520), FRAC_CONST(0.031246504888762) },
    { FRAC_CONST(0.000371502221008), FRAC_CONST(0.031247791699571) },
    { FRAC_CONST(0.000275633598775), FRAC_CONST(0.031248784394264) },
    { FRAC_CONST(0.000179762382174), FRAC_CONST(0.031249482963498) },
    { FRAC_CONST(0.000083889473581), FRAC_CONST(0.031249887400697) }
};

/* 64 (N/4) complex twiddle factors */
ALIGN static const complex_t mdct_tab_256[] =
{
    { FRAC_CONST(0.088387931675923), FRAC_CONST(0.000271171628935) },
    { FRAC_CONST(0.088354655998507), FRAC_CONST(0.002440238387037) },
    { FRAC_CONST(0.088268158780110), FRAC_CONST(0.004607835236780) },
    { FRAC_CONST(0.088128492123423), FRAC_CONST(0.006772656498875) },
    { FRAC_CONST(0.087935740158418), FRAC_CONST(0.008933398165942) },
    { FRAC_CONST(0.087690018991670), FRAC_CONST(0.011088758687994) },
    { FRAC_CONST(0.087391476636423), FRAC_CONST(0.013237439756448) },
    { FRAC_CONST(0.087040292923427), FRAC_CONST(0.015378147086172) },
    { FRAC_CONST(0.086636679392621), FRAC_CONST(0.017509591195118) },
    { FRAC_CONST(0.086180879165703), FRAC_CONST(0.019630488181053) },
    { FRAC_CONST(0.085673166799686), FRAC_CONST(0.021739560494940) },
    { FRAC_CONST(0.085113848121515), FRAC_CONST(0.023835537710479) },
    { FRAC_CONST(0.084503260043847), FRAC_CONST(0.025917157289369) },
    { FRAC_CONST(0.083841770362110), FRAC_CONST(0.027983165341813) },
    { FRAC_CONST(0.083129777532952), FRAC_CONST(0.030032317381813) },
    { FRAC_CONST(0.082367710434230), FRAC_CONST(0.032063379076803) },
    { FRAC_CONST(0.081556028106671), FRAC_CONST(0.034075126991164) },
    { FRAC_CONST(0.080695219477356), FRAC_CONST(0.036066349323177) },
    { FRAC_CONST(0.079785803065216), FRAC_CONST(0.038035846634965) },
    { FRAC_CONST(0.078828326668693), FRAC_CONST(0.039982432574992) },
    { FRAC_CONST(0.077823367035766), FRAC_CONST(0.041904934592675) },
    { FRAC_CONST(0.076771529516540), FRAC_CONST(0.043802194644686) },
    { FRAC_CONST(0.075673447698606), FRAC_CONST(0.045673069892513) },
    { FRAC_CONST(0.074529783025390), FRAC_CONST(0.047516433390863) },
    { FRAC_CONST(0.073341224397728), FRAC_CONST(0.049331174766491) },
    { FRAC_CONST(0.072108487758894), FRAC_CONST(0.051116200887052) },
    { FRAC_CONST(0.070832315663343), FRAC_CONST(0.052870436519557) },
    { FRAC_CONST(0.069513476829429), FRAC_CONST(0.054592824978055) },
    { FRAC_CONST(0.068152765676348), FRAC_CONST(0.056282328760143) },
    { FRAC_CONST(0.066751001845620), FRAC_CONST(0.057937930171918) },
    { FRAC_CONST(0.065309029707361), FRAC_CONST(0.059558631940996) },
    { FRAC_CONST(0.063827717851668), FRAC_CONST(0.061143457817234) },
    { FRAC_CONST(0.062307958565413), FRAC_CONST(0.062691453160784) },
    { FRAC_CONST(0.060750667294763), FRAC_CONST(0.064201685517134) },
    { FRAC_CONST(0.059156782093749), FRAC_CONST(0.065673245178784) },
    { FRAC_CONST(0.057527263059216), FRAC_CONST(0.067105245733220) },
    { FRAC_CONST(0.055863091752499), FRAC_CONST(0.068496824596852) },
    { FRAC_CONST(0.054165270608165), FRAC_CONST(0.069847143534609) },
    { FRAC_CONST(0.052434822330188), FRAC_CONST(0.071155389164853) },
    { FRAC_CONST(0.050672789275903), FRAC_CONST(0.072420773449336) },
    { FRAC_CONST(0.048880232828135), FRAC_CONST(0.073642534167879) },
    { FRAC_CONST(0.047058232755862), FRAC_CONST(0.074819935377512) },
    { FRAC_CONST(0.045207886563797), FRAC_CONST(0.075952267855771) },
    { FRAC_CONST(0.043330308831298), FRAC_CONST(0.077038849527912) },
    { FRAC_CONST(0.041426630540984), FRAC_CONST(0.078079025877766) },
    { FRAC_CONST(0.039497998397473), FRAC_CONST(0.079072170341994) },
    { FRAC_CONST(0.037545574136653), FRAC_CONST(0.080017684687506) },
    { FRAC_CONST(0.035570533825892), FRAC_CONST(0.080914999371817) },
    { FRAC_CONST(0.033574067155622), FRAC_CONST(0.081763573886112) },
    { FRAC_CONST(0.031557376722714), FRAC_CONST(0.082562897080836) },
    { FRAC_CONST(0.029521677306074), FRAC_CONST(0.083312487473584) },
    { FRAC_CONST(0.027468195134911), FRAC_CONST(0.084011893539132) },
    { FRAC_CONST(0.025398167150101), FRAC_CONST(0.084660693981419) },
    { FRAC_CONST(0.023312840259098), FRAC_CONST(0.085258497987320) },
    { FRAC_CONST(0.021213470584847), FRAC_CONST(0.085804945462053) },
    { FRAC_CONST(0.019101322709138), FRAC_CONST(0.086299707246093) },
    { FRAC_CONST(0.016977668910873), FRAC_CONST(0.086742485313442) },
    { FRAC_CONST(0.014843788399692), FRAC_CONST(0.087133012951149) },
    { FRAC_CONST(0.012700966545425), FRAC_CONST(0.087471054919968) },
    { FRAC_CONST(0.010550494103830), FRAC_CONST(0.087756407596056) },
    { FRAC_CONST(0.008393666439096), FRAC_CONST(0.087988899093631) },
    { FRAC_CONST(0.006231782743558), FRAC_CONST(0.088168389368510) },
    { FRAC_CONST(0.004066145255116), FRAC_CONST(0.088294770302461) },
    { FRAC_CONST(0.001898058472816), FRAC_CONST(0.088367965768336) }
};

#ifdef LD_DEC
/* 128 (N/4) complex twiddle factors */
ALIGN static const complex_t mdct_tab_1024[] =
{
    { FRAC_CONST(0.044194160825012), FRAC_CONST(0.000033896503468) },
    { FRAC_CONST(0.044193120897389), FRAC_CONST(0.000305066138364) },
    { FRAC_CONST(0.044190417123742), FRAC_CONST(0.000576224287693) },
    { FRAC_CONST(0.044186049605866), FRAC_CONST(0.000847360742503) },
    { FRAC_CONST(0.044180018508197), FRAC_CONST(0.001118465294660) },
    { FRAC_CONST(0.044172324057802), FRAC_CONST(0.001389527737231) },
    { FRAC_CONST(0.044162966544372), FRAC_CONST(0.001660537864867) },
    { FRAC_CONST(0.044151946320213), FRAC_CONST(0.001931485474192) },
    { FRAC_CONST(0.044139263800230), FRAC_CONST(0.002202360364180) },
    { FRAC_CONST(0.044124919461912), FRAC_CONST(0.002473152336546) },
    { FRAC_CONST(0.044108913845316), FRAC_CONST(0.002743851196123) },
    { FRAC_CONST(0.044091247553044), FRAC_CONST(0.003014446751254) },
    { FRAC_CONST(0.044071921250223), FRAC_CONST(0.003284928814169) },
    { FRAC_CONST(0.044050935664476), FRAC_CONST(0.003555287201370) },
    { FRAC_CONST(0.044028291585898), FRAC_CONST(0.003825511734018) },
    { FRAC_CONST(0.044003989867028), FRAC_CONST(0.004095592238311) },
    { FRAC_CONST(0.043978031422810), FRAC_CONST(0.004365518545871) },
    { FRAC_CONST(0.043950417230565), FRAC_CONST(0.004635280494126) },
    { FRAC_CONST(0.043921148329953), FRAC_CONST(0.004904867926689) },
    { FRAC_CONST(0.043890225822930), FRAC_CONST(0.005174270693748) },
    { FRAC_CONST(0.043857650873712), FRAC_CONST(0.005443478652439) },
    { FRAC_CONST(0.043823424708727), FRAC_CONST(0.005712481667236) },
    { FRAC_CONST(0.043787548616571), FRAC_CONST(0.005981269610326) },
    { FRAC_CONST(0.043750023947958), FRAC_CONST(0.006249832361997) },
    { FRAC_CONST(0.043710852115672), FRAC_CONST(0.006518159811011) },
    { FRAC_CONST(0.043670034594508), FRAC_CONST(0.006786241854993) },
    { FRAC_CONST(0.043627572921225), FRAC_CONST(0.007054068400804) },
    { FRAC_CONST(0.043583468694479), FRAC_CONST(0.007321629364927) },
    { FRAC_CONST(0.043537723574771), FRAC_CONST(0.007588914673843) },
    { FRAC_CONST(0.043490339284377), FRAC_CONST(0.007855914264410) },
    { FRAC_CONST(0.043441317607290), FRAC_CONST(0.008122618084246) },
    { FRAC_CONST(0.043390660389149), FRAC_CONST(0.008389016092101) },
    { FRAC_CONST(0.043338369537168), FRAC_CONST(0.008655098258243) },
    { FRAC_CONST(0.043284447020070), FRAC_CONST(0.008920854564826) },
    { FRAC_CONST(0.043228894868005), FRAC_CONST(0.009186275006278) },
    { FRAC_CONST(0.043171715172482), FRAC_CONST(0.009451349589667) },
    { FRAC_CONST(0.043112910086283), FRAC_CONST(0.009716068335087) },
    { FRAC_CONST(0.043052481823387), FRAC_CONST(0.009980421276025) },
    { FRAC_CONST(0.042990432658884), FRAC_CONST(0.010244398459743) },
    { FRAC_CONST(0.042926764928889), FRAC_CONST(0.010507989947649) },
    { FRAC_CONST(0.042861481030457), FRAC_CONST(0.010771185815673) },
    { FRAC_CONST(0.042794583421490), FRAC_CONST(0.011033976154639) },
    { FRAC_CONST(0.042726074620644), FRAC_CONST(0.011296351070639) },
    { FRAC_CONST(0.042655957207238), FRAC_CONST(0.011558300685406) },
    { FRAC_CONST(0.042584233821153), FRAC_CONST(0.011819815136685) },
    { FRAC_CONST(0.042510907162732), FRAC_CONST(0.012080884578604) },
    { FRAC_CONST(0.042435979992684), FRAC_CONST(0.012341499182048) },
    { FRAC_CONST(0.042359455131975), FRAC_CONST(0.012601649135022) },
    { FRAC_CONST(0.042281335461721), FRAC_CONST(0.012861324643029) },
    { FRAC_CONST(0.042201623923085), FRAC_CONST(0.013120515929433) },
    { FRAC_CONST(0.042120323517160), FRAC_CONST(0.013379213235827) },
    { FRAC_CONST(0.042037437304862), FRAC_CONST(0.013637406822406) },
    { FRAC_CONST(0.041952968406809), FRAC_CONST(0.013895086968325) },
    { FRAC_CONST(0.041866920003207), FRAC_CONST(0.014152243972073) },
    { FRAC_CONST(0.041779295333730), FRAC_CONST(0.014408868151835) },
    { FRAC_CONST(0.041690097697398), FRAC_CONST(0.014664949845855) },
    { FRAC_CONST(0.041599330452450), FRAC_CONST(0.014920479412801) },
    { FRAC_CONST(0.041506997016224), FRAC_CONST(0.015175447232131) },
    { FRAC_CONST(0.041413100865019), FRAC_CONST(0.015429843704450) },
    { FRAC_CONST(0.041317645533974), FRAC_CONST(0.015683659251874) },
    { FRAC_CONST(0.041220634616927), FRAC_CONST(0.015936884318392) },
    { FRAC_CONST(0.041122071766285), FRAC_CONST(0.016189509370223) },
    { FRAC_CONST(0.041021960692883), FRAC_CONST(0.016441524896177) },
    { FRAC_CONST(0.040920305165846), FRAC_CONST(0.016692921408010) },
    { FRAC_CONST(0.040817109012449), FRAC_CONST(0.016943689440788) },
    { FRAC_CONST(0.040712376117967), FRAC_CONST(0.017193819553235) },
    { FRAC_CONST(0.040606110425535), FRAC_CONST(0.017443302328094) },
    { FRAC_CONST(0.040498315935996), FRAC_CONST(0.017692128372479) },
    { FRAC_CONST(0.040388996707752), FRAC_CONST(0.017940288318230) },
    { FRAC_CONST(0.040278156856609), FRAC_CONST(0.018187772822267) },
    { FRAC_CONST(0.040165800555627), FRAC_CONST(0.018434572566936) },
    { FRAC_CONST(0.040051932034955), FRAC_CONST(0.018680678260367) },
    { FRAC_CONST(0.039936555581679), FRAC_CONST(0.018926080636820) },
    { FRAC_CONST(0.039819675539659), FRAC_CONST(0.019170770457035) },
    { FRAC_CONST(0.039701296309360), FRAC_CONST(0.019414738508577) },
    { FRAC_CONST(0.039581422347694), FRAC_CONST(0.019657975606187) },
    { FRAC_CONST(0.039460058167849), FRAC_CONST(0.019900472592126) },
    { FRAC_CONST(0.039337208339116), FRAC_CONST(0.020142220336521) },
    { FRAC_CONST(0.039212877486723), FRAC_CONST(0.020383209737704) },
    { FRAC_CONST(0.039087070291656), FRAC_CONST(0.020623431722561) },
    { FRAC_CONST(0.038959791490485), FRAC_CONST(0.020862877246870) },
    { FRAC_CONST(0.038831045875184), FRAC_CONST(0.021101537295642) },
    { FRAC_CONST(0.038700838292953), FRAC_CONST(0.021339402883462) },
    { FRAC_CONST(0.038569173646034), FRAC_CONST(0.021576465054824) },
    { FRAC_CONST(0.038436056891527), FRAC_CONST(0.021812714884472) },
    { FRAC_CONST(0.038301493041202), FRAC_CONST(0.022048143477734) },
    { FRAC_CONST(0.038165487161312), FRAC_CONST(0.022282741970855) },
    { FRAC_CONST(0.038028044372402), FRAC_CONST(0.022516501531335) },
    { FRAC_CONST(0.037889169849115), FRAC_CONST(0.022749413358259) },
    { FRAC_CONST(0.037748868819998), FRAC_CONST(0.022981468682628) },
    { FRAC_CONST(0.037607146567305), FRAC_CONST(0.023212658767690) },
    { FRAC_CONST(0.037464008426800), FRAC_CONST(0.023442974909269) },
    { FRAC_CONST(0.037319459787553), FRAC_CONST(0.023672408436094) },
    { FRAC_CONST(0.037173506091737), FRAC_CONST(0.023900950710120) },
    { FRAC_CONST(0.037026152834428), FRAC_CONST(0.024128593126861) },
    { FRAC_CONST(0.036877405563392), FRAC_CONST(0.024355327115708) },
    { FRAC_CONST(0.036727269878879), FRAC_CONST(0.024581144140255) },
    { FRAC_CONST(0.036575751433414), FRAC_CONST(0.024806035698618) },
    { FRAC_CONST(0.036422855931580), FRAC_CONST(0.025029993323758) },
    { FRAC_CONST(0.036268589129807), FRAC_CONST(0.025253008583796) },
    { FRAC_CONST(0.036112956836151), FRAC_CONST(0.025475073082334) },
    { FRAC_CONST(0.035955964910083), FRAC_CONST(0.025696178458769) },
    { FRAC_CONST(0.035797619262257), FRAC_CONST(0.025916316388609) },
    { FRAC_CONST(0.035637925854300), FRAC_CONST(0.026135478583784) },
    { FRAC_CONST(0.035476890698576), FRAC_CONST(0.026353656792963) },
    { FRAC_CONST(0.035314519857970), FRAC_CONST(0.026570842801858) },
    { FRAC_CONST(0.035150819445650), FRAC_CONST(0.026787028433540) },
    { FRAC_CONST(0.034985795624846), FRAC_CONST(0.027002205548742) },
    { FRAC_CONST(0.034819454608610), FRAC_CONST(0.027216366046166) },
    { FRAC_CONST(0.034651802659589), FRAC_CONST(0.027429501862792) },
    { FRAC_CONST(0.034482846089783), FRAC_CONST(0.027641604974175) },
    { FRAC_CONST(0.034312591260311), FRAC_CONST(0.027852667394755) },
    { FRAC_CONST(0.034141044581172), FRAC_CONST(0.028062681178149) },
    { FRAC_CONST(0.033968212511001), FRAC_CONST(0.028271638417458) },
    { FRAC_CONST(0.033794101556828), FRAC_CONST(0.028479531245560) },
    { FRAC_CONST(0.033618718273831), FRAC_CONST(0.028686351835407) },
    { FRAC_CONST(0.033442069265093), FRAC_CONST(0.028892092400321) },
    { FRAC_CONST(0.033264161181349), FRAC_CONST(0.029096745194286) },
    { FRAC_CONST(0.033085000720737), FRAC_CONST(0.029300302512241) },
    { FRAC_CONST(0.032904594628548), FRAC_CONST(0.029502756690366) },
    { FRAC_CONST(0.032722949696969), FRAC_CONST(0.029704100106376) },
    { FRAC_CONST(0.032540072764829), FRAC_CONST(0.029904325179807) },
    { FRAC_CONST(0.032355970717341), FRAC_CONST(0.030103424372297) },
    { FRAC_CONST(0.032170650485843), FRAC_CONST(0.030301390187873) },
    { FRAC_CONST(0.031984119047537), FRAC_CONST(0.030498215173235) },
    { FRAC_CONST(0.031796383425227), FRAC_CONST(0.030693891918034) },
    { FRAC_CONST(0.031607450687052), FRAC_CONST(0.030888413055150) },
    { FRAC_CONST(0.031417327946223), FRAC_CONST(0.031081771260973) },
    { FRAC_CONST(0.031226022360754), FRAC_CONST(0.031273959255676) },
    { FRAC_CONST(0.031033541133193), FRAC_CONST(0.031464969803488) },
    { FRAC_CONST(0.030839891510348), FRAC_CONST(0.031654795712972) },
    { FRAC_CONST(0.030645080783018), FRAC_CONST(0.031843429837288) },
    { FRAC_CONST(0.030449116285718), FRAC_CONST(0.032030865074469) },
    { FRAC_CONST(0.030252005396399), FRAC_CONST(0.032217094367684) },
    { FRAC_CONST(0.030053755536176), FRAC_CONST(0.032402110705505) },
    { FRAC_CONST(0.029854374169043), FRAC_CONST(0.032585907122172) },
    { FRAC_CONST(0.029653868801596), FRAC_CONST(0.032768476697853) },
    { FRAC_CONST(0.029452246982750), FRAC_CONST(0.032949812558907) },
    { FRAC_CONST(0.029249516303451), FRAC_CONST(0.033129907878142) },
    { FRAC_CONST(0.029045684396395), FRAC_CONST(0.033308755875070) },
    { FRAC_CONST(0.028840758935738), FRAC_CONST(0.033486349816166) },
    { FRAC_CONST(0.028634747636808), FRAC_CONST(0.033662683015118) },
    { FRAC_CONST(0.028427658255815), FRAC_CONST(0.033837748833080) },
    { FRAC_CONST(0.028219498589555), FRAC_CONST(0.034011540678924) },
    { FRAC_CONST(0.028010276475123), FRAC_CONST(0.034184052009485) },
    { FRAC_CONST(0.027799999789613), FRAC_CONST(0.034355276329809) },
    { FRAC_CONST(0.027588676449824), FRAC_CONST(0.034525207193396) },
    { FRAC_CONST(0.027376314411959), FRAC_CONST(0.034693838202447) },
    { FRAC_CONST(0.027162921671330), FRAC_CONST(0.034861163008098) },
    { FRAC_CONST(0.026948506262053), FRAC_CONST(0.035027175310665) },
    { FRAC_CONST(0.026733076256746), FRAC_CONST(0.035191868859880) },
    { FRAC_CONST(0.026516639766228), FRAC_CONST(0.035355237455122) },
    { FRAC_CONST(0.026299204939210), FRAC_CONST(0.035517274945657) },
    { FRAC_CONST(0.026080779961991), FRAC_CONST(0.035677975230865) },
    { FRAC_CONST(0.025861373058146), FRAC_CONST(0.035837332260471) },
    { FRAC_CONST(0.025640992488223), FRAC_CONST(0.035995340034772) },
    { FRAC_CONST(0.025419646549425), FRAC_CONST(0.036151992604866) },
    { FRAC_CONST(0.025197343575302), FRAC_CONST(0.036307284072871) },
    { FRAC_CONST(0.024974091935435), FRAC_CONST(0.036461208592152) },
    { FRAC_CONST(0.024749900035122), FRAC_CONST(0.036613760367538) },
    { FRAC_CONST(0.024524776315061), FRAC_CONST(0.036764933655540) },
    { FRAC_CONST(0.024298729251033), FRAC_CONST(0.036914722764569) },
    { FRAC_CONST(0.024071767353583), FRAC_CONST(0.037063122055150) },
    { FRAC_CONST(0.023843899167697), FRAC_CONST(0.037210125940135) },
    { FRAC_CONST(0.023615133272485), FRAC_CONST(0.037355728884908) },
    { FRAC_CONST(0.023385478280852), FRAC_CONST(0.037499925407603) },
    { FRAC_CONST(0.023154942839179), FRAC_CONST(0.037642710079302) },
    { FRAC_CONST(0.022923535626995), FRAC_CONST(0.037784077524241) },
    { FRAC_CONST(0.022691265356652), FRAC_CONST(0.037924022420018) },
    { FRAC_CONST(0.022458140772993), FRAC_CONST(0.038062539497785) },
    { FRAC_CONST(0.022224170653027), FRAC_CONST(0.038199623542453) },
    { FRAC_CONST(0.021989363805598), FRAC_CONST(0.038335269392885) },
    { FRAC_CONST(0.021753729071049), FRAC_CONST(0.038469471942092) },
    { FRAC_CONST(0.021517275320897), FRAC_CONST(0.038602226137423) },
    { FRAC_CONST(0.021280011457490), FRAC_CONST(0.038733526980758) },
    { FRAC_CONST(0.021041946413679), FRAC_CONST(0.038863369528695) },
    { FRAC_CONST(0.020803089152479), FRAC_CONST(0.038991748892734) },
    { FRAC_CONST(0.020563448666730), FRAC_CONST(0.039118660239466) },
    { FRAC_CONST(0.020323033978761), FRAC_CONST(0.039244098790750) },
    { FRAC_CONST(0.020081854140050), FRAC_CONST(0.039368059823895) },
    { FRAC_CONST(0.019839918230880), FRAC_CONST(0.039490538671839) },
    { FRAC_CONST(0.019597235360003), FRAC_CONST(0.039611530723322) },
    { FRAC_CONST(0.019353814664291), FRAC_CONST(0.039731031423061) },
    { FRAC_CONST(0.019109665308395), FRAC_CONST(0.039849036271924) },
    { FRAC_CONST(0.018864796484402), FRAC_CONST(0.039965540827094) },
    { FRAC_CONST(0.018619217411483), FRAC_CONST(0.040080540702240) },
    { FRAC_CONST(0.018372937335552), FRAC_CONST(0.040194031567683) },
    { FRAC_CONST(0.018125965528915), FRAC_CONST(0.040306009150554) },
    { FRAC_CONST(0.017878311289921), FRAC_CONST(0.040416469234963) },
    { FRAC_CONST(0.017629983942612), FRAC_CONST(0.040525407662148) },
    { FRAC_CONST(0.017380992836371), FRAC_CONST(0.040632820330639) },
    { FRAC_CONST(0.017131347345575), FRAC_CONST(0.040738703196411) },
    { FRAC_CONST(0.016881056869233), FRAC_CONST(0.040843052273033) },
    { FRAC_CONST(0.016630130830641), FRAC_CONST(0.040945863631822) },
    { FRAC_CONST(0.016378578677023), FRAC_CONST(0.041047133401988) },
    { FRAC_CONST(0.016126409879175), FRAC_CONST(0.041146857770781) },
    { FRAC_CONST(0.015873633931110), FRAC_CONST(0.041245032983635) },
    { FRAC_CONST(0.015620260349699), FRAC_CONST(0.041341655344309) },
    { FRAC_CONST(0.015366298674314), FRAC_CONST(0.041436721215026) },
    { FRAC_CONST(0.015111758466470), FRAC_CONST(0.041530227016609) },
    { FRAC_CONST(0.014856649309460), FRAC_CONST(0.041622169228618) },
    { FRAC_CONST(0.014600980808001), FRAC_CONST(0.041712544389481) },
    { FRAC_CONST(0.014344762587867), FRAC_CONST(0.041801349096623) },
    { FRAC_CONST(0.014088004295529), FRAC_CONST(0.041888580006598) },
    { FRAC_CONST(0.013830715597792), FRAC_CONST(0.041974233835211) },
    { FRAC_CONST(0.013572906181430), FRAC_CONST(0.042058307357645) },
    { FRAC_CONST(0.013314585752822), FRAC_CONST(0.042140797408577) },
    { FRAC_CONST(0.013055764037585), FRAC_CONST(0.042221700882306) },
    { FRAC_CONST(0.012796450780212), FRAC_CONST(0.042301014732860) },
    { FRAC_CONST(0.012536655743699), FRAC_CONST(0.042378735974118) },
    { FRAC_CONST(0.012276388709183), FRAC_CONST(0.042454861679919) },
    { FRAC_CONST(0.012015659475571), FRAC_CONST(0.042529388984173) },
    { FRAC_CONST(0.011754477859172), FRAC_CONST(0.042602315080970) },
    { FRAC_CONST(0.011492853693324), FRAC_CONST(0.042673637224683) },
    { FRAC_CONST(0.011230796828031), FRAC_CONST(0.042743352730074) },
    { FRAC_CONST(0.010968317129584), FRAC_CONST(0.042811458972393) },
    { FRAC_CONST(0.010705424480197), FRAC_CONST(0.042877953387479) },
    { FRAC_CONST(0.010442128777629), FRAC_CONST(0.042942833471854) },
    { FRAC_CONST(0.010178439934815), FRAC_CONST(0.043006096782821) },
    { FRAC_CONST(0.009914367879490), FRAC_CONST(0.043067740938551) },
    { FRAC_CONST(0.009649922553818), FRAC_CONST(0.043127763618177) },
    { FRAC_CONST(0.009385113914016), FRAC_CONST(0.043186162561878) },
    { FRAC_CONST(0.009119951929979), FRAC_CONST(0.043242935570968) },
    { FRAC_CONST(0.008854446584907), FRAC_CONST(0.043298080507974) },
    { FRAC_CONST(0.008588607874926), FRAC_CONST(0.043351595296722) },
    { FRAC_CONST(0.008322445808712), FRAC_CONST(0.043403477922409) },
    { FRAC_CONST(0.008055970407118), FRAC_CONST(0.043453726431684) },
    { FRAC_CONST(0.007789191702791), FRAC_CONST(0.043502338932719) },
    { FRAC_CONST(0.007522119739798), FRAC_CONST(0.043549313595281) },
    { FRAC_CONST(0.007254764573250), FRAC_CONST(0.043594648650800) },
    { FRAC_CONST(0.006987136268915), FRAC_CONST(0.043638342392438) },
    { FRAC_CONST(0.006719244902849), FRAC_CONST(0.043680393175148) },
    { FRAC_CONST(0.006451100561010), FRAC_CONST(0.043720799415744) },
    { FRAC_CONST(0.006182713338881), FRAC_CONST(0.043759559592953) },
    { FRAC_CONST(0.005914093341090), FRAC_CONST(0.043796672247476) },
    { FRAC_CONST(0.005645250681027), FRAC_CONST(0.043832135982044) },
    { FRAC_CONST(0.005376195480466), FRAC_CONST(0.043865949461465) },
    { FRAC_CONST(0.005106937869184), FRAC_CONST(0.043898111412683) },
    { FRAC_CONST(0.004837487984578), FRAC_CONST(0.043928620624817) },
    { FRAC_CONST(0.004567855971284), FRAC_CONST(0.043957475949213) },
    { FRAC_CONST(0.004298051980793), FRAC_CONST(0.043984676299484) },
    { FRAC_CONST(0.004028086171076), FRAC_CONST(0.044010220651553) },
    { FRAC_CONST(0.003757968706190), FRAC_CONST(0.044034108043689) },
    { FRAC_CONST(0.003487709755907), FRAC_CONST(0.044056337576546) },
    { FRAC_CONST(0.003217319495322), FRAC_CONST(0.044076908413193) },
    { FRAC_CONST(0.002946808104477), FRAC_CONST(0.044095819779151) },
    { FRAC_CONST(0.002676185767973), FRAC_CONST(0.044113070962418) },
    { FRAC_CONST(0.002405462674586), FRAC_CONST(0.044128661313495) },
    { FRAC_CONST(0.002134649016890), FRAC_CONST(0.044142590245416) },
    { FRAC_CONST(0.001863754990865), FRAC_CONST(0.044154857233763) },
    { FRAC_CONST(0.001592790795518), FRAC_CONST(0.044165461816692) },
    { FRAC_CONST(0.001321766632497), FRAC_CONST(0.044174403594946) },
    { FRAC_CONST(0.001050692705710), FRAC_CONST(0.044181682231873) },
    { FRAC_CONST(0.000779579220936), FRAC_CONST(0.044187297453434) },
    { FRAC_CONST(0.000508436385446), FRAC_CONST(0.044191249048222) },
    { FRAC_CONST(0.000237274407613), FRAC_CONST(0.044193536867459) }
};
#endif // LD_DEC

#ifdef ALLOW_SMALL_FRAMELENGTH
/* 480 (N/4) complex twiddle factors */
ALIGN static const complex_t mdct_tab_1920[] =
{
    { FRAC_CONST(0.032274858518097), FRAC_CONST(0.000013202404176) },
    { FRAC_CONST(0.032274642494505), FRAC_CONST(0.000118821372483) },
    { FRAC_CONST(0.032274080835421), FRAC_CONST(0.000224439068308) },
    { FRAC_CONST(0.032273173546860), FRAC_CONST(0.000330054360572) },
    { FRAC_CONST(0.032271920638538), FRAC_CONST(0.000435666118218) },
    { FRAC_CONST(0.032270322123873), FRAC_CONST(0.000541273210231) },
    { FRAC_CONST(0.032268378019984), FRAC_CONST(0.000646874505642) },
    { FRAC_CONST(0.032266088347691), FRAC_CONST(0.000752468873546) },
    { FRAC_CONST(0.032263453131514), FRAC_CONST(0.000858055183114) },
    { FRAC_CONST(0.032260472399674), FRAC_CONST(0.000963632303600) },
    { FRAC_CONST(0.032257146184092), FRAC_CONST(0.001069199104358) },
    { FRAC_CONST(0.032253474520390), FRAC_CONST(0.001174754454853) },
    { FRAC_CONST(0.032249457447888), FRAC_CONST(0.001280297224671) },
    { FRAC_CONST(0.032245095009606), FRAC_CONST(0.001385826283535) },
    { FRAC_CONST(0.032240387252262), FRAC_CONST(0.001491340501313) },
    { FRAC_CONST(0.032235334226272), FRAC_CONST(0.001596838748031) },
    { FRAC_CONST(0.032229935985750), FRAC_CONST(0.001702319893890) },
    { FRAC_CONST(0.032224192588507), FRAC_CONST(0.001807782809271) },
    { FRAC_CONST(0.032218104096050), FRAC_CONST(0.001913226364749) },
    { FRAC_CONST(0.032211670573582), FRAC_CONST(0.002018649431111) },
    { FRAC_CONST(0.032204892090000), FRAC_CONST(0.002124050879359) },
    { FRAC_CONST(0.032197768717898), FRAC_CONST(0.002229429580728) },
    { FRAC_CONST(0.032190300533560), FRAC_CONST(0.002334784406698) },
    { FRAC_CONST(0.032182487616965), FRAC_CONST(0.002440114229003) },
    { FRAC_CONST(0.032174330051782), FRAC_CONST(0.002545417919644) },
    { FRAC_CONST(0.032165827925374), FRAC_CONST(0.002650694350905) },
    { FRAC_CONST(0.032156981328790), FRAC_CONST(0.002755942395358) },
    { FRAC_CONST(0.032147790356771), FRAC_CONST(0.002861160925883) },
    { FRAC_CONST(0.032138255107744), FRAC_CONST(0.002966348815672) },
    { FRAC_CONST(0.032128375683825), FRAC_CONST(0.003071504938250) },
    { FRAC_CONST(0.032118152190814), FRAC_CONST(0.003176628167476) },
    { FRAC_CONST(0.032107584738196), FRAC_CONST(0.003281717377568) },
    { FRAC_CONST(0.032096673439141), FRAC_CONST(0.003386771443102) },
    { FRAC_CONST(0.032085418410500), FRAC_CONST(0.003491789239036) },
    { FRAC_CONST(0.032073819772804), FRAC_CONST(0.003596769640711) },
    { FRAC_CONST(0.032061877650267), FRAC_CONST(0.003701711523874) },
    { FRAC_CONST(0.032049592170778), FRAC_CONST(0.003806613764680) },
    { FRAC_CONST(0.032036963465906), FRAC_CONST(0.003911475239711) },
    { FRAC_CONST(0.032023991670893), FRAC_CONST(0.004016294825985) },
    { FRAC_CONST(0.032010676924657), FRAC_CONST(0.004121071400967) },
    { FRAC_CONST(0.031997019369789), FRAC_CONST(0.004225803842586) },
    { FRAC_CONST(0.031983019152549), FRAC_CONST(0.004330491029241) },
    { FRAC_CONST(0.031968676422869), FRAC_CONST(0.004435131839816) },
    { FRAC_CONST(0.031953991334348), FRAC_CONST(0.004539725153692) },
    { FRAC_CONST(0.031938964044252), FRAC_CONST(0.004644269850758) },
    { FRAC_CONST(0.031923594713510), FRAC_CONST(0.004748764811426) },
    { FRAC_CONST(0.031907883506716), FRAC_CONST(0.004853208916638) },
    { FRAC_CONST(0.031891830592124), FRAC_CONST(0.004957601047881) },
    { FRAC_CONST(0.031875436141648), FRAC_CONST(0.005061940087200) },
    { FRAC_CONST(0.031858700330859), FRAC_CONST(0.005166224917208) },
    { FRAC_CONST(0.031841623338985), FRAC_CONST(0.005270454421097) },
    { FRAC_CONST(0.031824205348907), FRAC_CONST(0.005374627482653) },
    { FRAC_CONST(0.031806446547156), FRAC_CONST(0.005478742986267) },
    { FRAC_CONST(0.031788347123916), FRAC_CONST(0.005582799816945) },
    { FRAC_CONST(0.031769907273017), FRAC_CONST(0.005686796860323) },
    { FRAC_CONST(0.031751127191935), FRAC_CONST(0.005790733002674) },
    { FRAC_CONST(0.031732007081789), FRAC_CONST(0.005894607130928) },
    { FRAC_CONST(0.031712547147340), FRAC_CONST(0.005998418132675) },
    { FRAC_CONST(0.031692747596989), FRAC_CONST(0.006102164896182) },
    { FRAC_CONST(0.031672608642773), FRAC_CONST(0.006205846310406) },
    { FRAC_CONST(0.031652130500364), FRAC_CONST(0.006309461265002) },
    { FRAC_CONST(0.031631313389067), FRAC_CONST(0.006413008650337) },
    { FRAC_CONST(0.031610157531816), FRAC_CONST(0.006516487357501) },
    { FRAC_CONST(0.031588663155172), FRAC_CONST(0.006619896278321) },
    { FRAC_CONST(0.031566830489325), FRAC_CONST(0.006723234305370) },
    { FRAC_CONST(0.031544659768083), FRAC_CONST(0.006826500331981) },
    { FRAC_CONST(0.031522151228878), FRAC_CONST(0.006929693252258) },
    { FRAC_CONST(0.031499305112758), FRAC_CONST(0.007032811961088) },
    { FRAC_CONST(0.031476121664387), FRAC_CONST(0.007135855354151) },
    { FRAC_CONST(0.031452601132040), FRAC_CONST(0.007238822327937) },
    { FRAC_CONST(0.031428743767604), FRAC_CONST(0.007341711779751) },
    { FRAC_CONST(0.031404549826572), FRAC_CONST(0.007444522607730) },
    { FRAC_CONST(0.031380019568042), FRAC_CONST(0.007547253710853) },
    { FRAC_CONST(0.031355153254712), FRAC_CONST(0.007649903988952) },
    { FRAC_CONST(0.031329951152882), FRAC_CONST(0.007752472342725) },
    { FRAC_CONST(0.031304413532445), FRAC_CONST(0.007854957673748) },
    { FRAC_CONST(0.031278540666888), FRAC_CONST(0.007957358884484) },
    { FRAC_CONST(0.031252332833290), FRAC_CONST(0.008059674878300) },
    { FRAC_CONST(0.031225790312316), FRAC_CONST(0.008161904559473) },
    { FRAC_CONST(0.031198913388214), FRAC_CONST(0.008264046833205) },
    { FRAC_CONST(0.031171702348814), FRAC_CONST(0.008366100605636) },
    { FRAC_CONST(0.031144157485525), FRAC_CONST(0.008468064783849) },
    { FRAC_CONST(0.031116279093331), FRAC_CONST(0.008569938275893) },
    { FRAC_CONST(0.031088067470786), FRAC_CONST(0.008671719990782) },
    { FRAC_CONST(0.031059522920014), FRAC_CONST(0.008773408838517) },
    { FRAC_CONST(0.031030645746705), FRAC_CONST(0.008875003730092) },
    { FRAC_CONST(0.031001436260110), FRAC_CONST(0.008976503577507) },
    { FRAC_CONST(0.030971894773039), FRAC_CONST(0.009077907293780) },
    { FRAC_CONST(0.030942021601857), FRAC_CONST(0.009179213792959) },
    { FRAC_CONST(0.030911817066483), FRAC_CONST(0.009280421990133) },
    { FRAC_CONST(0.030881281490382), FRAC_CONST(0.009381530801444) },
    { FRAC_CONST(0.030850415200566), FRAC_CONST(0.009482539144097) },
    { FRAC_CONST(0.030819218527589), FRAC_CONST(0.009583445936373) },
    { FRAC_CONST(0.030787691805541), FRAC_CONST(0.009684250097643) },
    { FRAC_CONST(0.030755835372048), FRAC_CONST(0.009784950548375) },
    { FRAC_CONST(0.030723649568268), FRAC_CONST(0.009885546210147) },
    { FRAC_CONST(0.030691134738883), FRAC_CONST(0.009986036005661) },
    { FRAC_CONST(0.030658291232103), FRAC_CONST(0.010086418858753) },
    { FRAC_CONST(0.030625119399655), FRAC_CONST(0.010186693694402) },
    { FRAC_CONST(0.030591619596781), FRAC_CONST(0.010286859438745) },
    { FRAC_CONST(0.030557792182239), FRAC_CONST(0.010386915019088) },
    { FRAC_CONST(0.030523637518292), FRAC_CONST(0.010486859363916) },
    { FRAC_CONST(0.030489155970710), FRAC_CONST(0.010586691402906) },
    { FRAC_CONST(0.030454347908763), FRAC_CONST(0.010686410066936) },
    { FRAC_CONST(0.030419213705216), FRAC_CONST(0.010786014288099) },
    { FRAC_CONST(0.030383753736329), FRAC_CONST(0.010885502999714) },
    { FRAC_CONST(0.030347968381849), FRAC_CONST(0.010984875136338) },
    { FRAC_CONST(0.030311858025010), FRAC_CONST(0.011084129633775) },
    { FRAC_CONST(0.030275423052523), FRAC_CONST(0.011183265429088) },
    { FRAC_CONST(0.030238663854579), FRAC_CONST(0.011282281460612) },
    { FRAC_CONST(0.030201580824838), FRAC_CONST(0.011381176667967) },
    { FRAC_CONST(0.030164174360430), FRAC_CONST(0.011479949992062) },
    { FRAC_CONST(0.030126444861948), FRAC_CONST(0.011578600375117) },
    { FRAC_CONST(0.030088392733446), FRAC_CONST(0.011677126760663) },
    { FRAC_CONST(0.030050018382430), FRAC_CONST(0.011775528093563) },
    { FRAC_CONST(0.030011322219859), FRAC_CONST(0.011873803320018) },
    { FRAC_CONST(0.029972304660138), FRAC_CONST(0.011971951387578) },
    { FRAC_CONST(0.029932966121114), FRAC_CONST(0.012069971245157) },
    { FRAC_CONST(0.029893307024070), FRAC_CONST(0.012167861843041) },
    { FRAC_CONST(0.029853327793724), FRAC_CONST(0.012265622132901) },
    { FRAC_CONST(0.029813028858222), FRAC_CONST(0.012363251067801) },
    { FRAC_CONST(0.029772410649132), FRAC_CONST(0.012460747602215) },
    { FRAC_CONST(0.029731473601443), FRAC_CONST(0.012558110692033) },
    { FRAC_CONST(0.029690218153558), FRAC_CONST(0.012655339294575) },
    { FRAC_CONST(0.029648644747289), FRAC_CONST(0.012752432368600) },
    { FRAC_CONST(0.029606753827855), FRAC_CONST(0.012849388874320) },
    { FRAC_CONST(0.029564545843872), FRAC_CONST(0.012946207773407) },
    { FRAC_CONST(0.029522021247356), FRAC_CONST(0.013042888029011) },
    { FRAC_CONST(0.029479180493710), FRAC_CONST(0.013139428605762) },
    { FRAC_CONST(0.029436024041725), FRAC_CONST(0.013235828469789) },
    { FRAC_CONST(0.029392552353570), FRAC_CONST(0.013332086588727) },
    { FRAC_CONST(0.029348765894794), FRAC_CONST(0.013428201931728) },
    { FRAC_CONST(0.029304665134313), FRAC_CONST(0.013524173469475) },
    { FRAC_CONST(0.029260250544412), FRAC_CONST(0.013620000174189) },
    { FRAC_CONST(0.029215522600735), FRAC_CONST(0.013715681019643) },
    { FRAC_CONST(0.029170481782283), FRAC_CONST(0.013811214981173) },
    { FRAC_CONST(0.029125128571406), FRAC_CONST(0.013906601035686) },
    { FRAC_CONST(0.029079463453801), FRAC_CONST(0.014001838161674) },
    { FRAC_CONST(0.029033486918505), FRAC_CONST(0.014096925339225) },
    { FRAC_CONST(0.028987199457889), FRAC_CONST(0.014191861550031) },
    { FRAC_CONST(0.028940601567655), FRAC_CONST(0.014286645777401) },
    { FRAC_CONST(0.028893693746829), FRAC_CONST(0.014381277006273) },
    { FRAC_CONST(0.028846476497755), FRAC_CONST(0.014475754223221) },
    { FRAC_CONST(0.028798950326094), FRAC_CONST(0.014570076416472) },
    { FRAC_CONST(0.028751115740811), FRAC_CONST(0.014664242575910) },
    { FRAC_CONST(0.028702973254178), FRAC_CONST(0.014758251693091) },
    { FRAC_CONST(0.028654523381760), FRAC_CONST(0.014852102761253) },
    { FRAC_CONST(0.028605766642418), FRAC_CONST(0.014945794775326) },
    { FRAC_CONST(0.028556703558297), FRAC_CONST(0.015039326731945) },
    { FRAC_CONST(0.028507334654823), FRAC_CONST(0.015132697629457) },
    { FRAC_CONST(0.028457660460698), FRAC_CONST(0.015225906467935) },
    { FRAC_CONST(0.028407681507891), FRAC_CONST(0.015318952249187) },
    { FRAC_CONST(0.028357398331639), FRAC_CONST(0.015411833976768) },
    { FRAC_CONST(0.028306811470432), FRAC_CONST(0.015504550655988) },
    { FRAC_CONST(0.028255921466016), FRAC_CONST(0.015597101293927) },
    { FRAC_CONST(0.028204728863381), FRAC_CONST(0.015689484899442) },
    { FRAC_CONST(0.028153234210760), FRAC_CONST(0.015781700483179) },
    { FRAC_CONST(0.028101438059619), FRAC_CONST(0.015873747057582) },
    { FRAC_CONST(0.028049340964652), FRAC_CONST(0.015965623636907) },
    { FRAC_CONST(0.027996943483779), FRAC_CONST(0.016057329237229) },
    { FRAC_CONST(0.027944246178133), FRAC_CONST(0.016148862876456) },
    { FRAC_CONST(0.027891249612061), FRAC_CONST(0.016240223574335) },
    { FRAC_CONST(0.027837954353113), FRAC_CONST(0.016331410352467) },
    { FRAC_CONST(0.027784360972039), FRAC_CONST(0.016422422234315) },
    { FRAC_CONST(0.027730470042780), FRAC_CONST(0.016513258245214) },
    { FRAC_CONST(0.027676282142466), FRAC_CONST(0.016603917412384) },
    { FRAC_CONST(0.027621797851405), FRAC_CONST(0.016694398764938) },
    { FRAC_CONST(0.027567017753080), FRAC_CONST(0.016784701333894) },
    { FRAC_CONST(0.027511942434143), FRAC_CONST(0.016874824152183) },
    { FRAC_CONST(0.027456572484404), FRAC_CONST(0.016964766254662) },
    { FRAC_CONST(0.027400908496833), FRAC_CONST(0.017054526678124) },
    { FRAC_CONST(0.027344951067546), FRAC_CONST(0.017144104461307) },
    { FRAC_CONST(0.027288700795801), FRAC_CONST(0.017233498644904) },
    { FRAC_CONST(0.027232158283994), FRAC_CONST(0.017322708271577) },
    { FRAC_CONST(0.027175324137651), FRAC_CONST(0.017411732385960) },
    { FRAC_CONST(0.027118198965418), FRAC_CONST(0.017500570034678) },
    { FRAC_CONST(0.027060783379060), FRAC_CONST(0.017589220266351) },
    { FRAC_CONST(0.027003077993454), FRAC_CONST(0.017677682131607) },
    { FRAC_CONST(0.026945083426576), FRAC_CONST(0.017765954683088) },
    { FRAC_CONST(0.026886800299502), FRAC_CONST(0.017854036975468) },
    { FRAC_CONST(0.026828229236397), FRAC_CONST(0.017941928065456) },
    { FRAC_CONST(0.026769370864511), FRAC_CONST(0.018029627011808) },
    { FRAC_CONST(0.026710225814170), FRAC_CONST(0.018117132875340) },
    { FRAC_CONST(0.026650794718768), FRAC_CONST(0.018204444718934) },
    { FRAC_CONST(0.026591078214767), FRAC_CONST(0.018291561607551) },
    { FRAC_CONST(0.026531076941680), FRAC_CONST(0.018378482608238) },
    { FRAC_CONST(0.026470791542075), FRAC_CONST(0.018465206790142) },
    { FRAC_CONST(0.026410222661558), FRAC_CONST(0.018551733224515) },
    { FRAC_CONST(0.026349370948775), FRAC_CONST(0.018638060984730) },
    { FRAC_CONST(0.026288237055398), FRAC_CONST(0.018724189146286) },
    { FRAC_CONST(0.026226821636121), FRAC_CONST(0.018810116786819) },
    { FRAC_CONST(0.026165125348656), FRAC_CONST(0.018895842986112) },
    { FRAC_CONST(0.026103148853718), FRAC_CONST(0.018981366826109) },
    { FRAC_CONST(0.026040892815028), FRAC_CONST(0.019066687390916) },
    { FRAC_CONST(0.025978357899296), FRAC_CONST(0.019151803766819) },
    { FRAC_CONST(0.025915544776223), FRAC_CONST(0.019236715042290) },
    { FRAC_CONST(0.025852454118485), FRAC_CONST(0.019321420307998) },
    { FRAC_CONST(0.025789086601733), FRAC_CONST(0.019405918656817) },
    { FRAC_CONST(0.025725442904582), FRAC_CONST(0.019490209183837) },
    { FRAC_CONST(0.025661523708606), FRAC_CONST(0.019574290986376) },
    { FRAC_CONST(0.025597329698327), FRAC_CONST(0.019658163163984) },
    { FRAC_CONST(0.025532861561211), FRAC_CONST(0.019741824818458) },
    { FRAC_CONST(0.025468119987662), FRAC_CONST(0.019825275053848) },
    { FRAC_CONST(0.025403105671008), FRAC_CONST(0.019908512976470) },
    { FRAC_CONST(0.025337819307501), FRAC_CONST(0.019991537694913) },
    { FRAC_CONST(0.025272261596305), FRAC_CONST(0.020074348320047) },
    { FRAC_CONST(0.025206433239491), FRAC_CONST(0.020156943965039) },
    { FRAC_CONST(0.025140334942028), FRAC_CONST(0.020239323745355) },
    { FRAC_CONST(0.025073967411776), FRAC_CONST(0.020321486778774) },
    { FRAC_CONST(0.025007331359476), FRAC_CONST(0.020403432185395) },
    { FRAC_CONST(0.024940427498748), FRAC_CONST(0.020485159087650) },
    { FRAC_CONST(0.024873256546079), FRAC_CONST(0.020566666610309) },
    { FRAC_CONST(0.024805819220816), FRAC_CONST(0.020647953880491) },
    { FRAC_CONST(0.024738116245157), FRAC_CONST(0.020729020027676) },
    { FRAC_CONST(0.024670148344147), FRAC_CONST(0.020809864183709) },
    { FRAC_CONST(0.024601916245669), FRAC_CONST(0.020890485482816) },
    { FRAC_CONST(0.024533420680433), FRAC_CONST(0.020970883061607) },
    { FRAC_CONST(0.024464662381971), FRAC_CONST(0.021051056059087) },
    { FRAC_CONST(0.024395642086630), FRAC_CONST(0.021131003616670) },
    { FRAC_CONST(0.024326360533561), FRAC_CONST(0.021210724878181) },
    { FRAC_CONST(0.024256818464715), FRAC_CONST(0.021290218989868) },
    { FRAC_CONST(0.024187016624830), FRAC_CONST(0.021369485100415) },
    { FRAC_CONST(0.024116955761430), FRAC_CONST(0.021448522360944) },
    { FRAC_CONST(0.024046636624808), FRAC_CONST(0.021527329925030) },
    { FRAC_CONST(0.023976059968027), FRAC_CONST(0.021605906948708) },
    { FRAC_CONST(0.023905226546906), FRAC_CONST(0.021684252590480) },
    { FRAC_CONST(0.023834137120014), FRAC_CONST(0.021762366011328) },
    { FRAC_CONST(0.023762792448662), FRAC_CONST(0.021840246374720) },
    { FRAC_CONST(0.023691193296893), FRAC_CONST(0.021917892846620) },
    { FRAC_CONST(0.023619340431478), FRAC_CONST(0.021995304595495) },
    { FRAC_CONST(0.023547234621902), FRAC_CONST(0.022072480792330) },
    { FRAC_CONST(0.023474876640361), FRAC_CONST(0.022149420610628) },
    { FRAC_CONST(0.023402267261751), FRAC_CONST(0.022226123226426) },
    { FRAC_CONST(0.023329407263659), FRAC_CONST(0.022302587818300) },
    { FRAC_CONST(0.023256297426359), FRAC_CONST(0.022378813567377) },
    { FRAC_CONST(0.023182938532797), FRAC_CONST(0.022454799657339) },
    { FRAC_CONST(0.023109331368588), FRAC_CONST(0.022530545274437) },
    { FRAC_CONST(0.023035476722006), FRAC_CONST(0.022606049607496) },
    { FRAC_CONST(0.022961375383975), FRAC_CONST(0.022681311847926) },
    { FRAC_CONST(0.022887028148061), FRAC_CONST(0.022756331189727) },
    { FRAC_CONST(0.022812435810462), FRAC_CONST(0.022831106829504) },
    { FRAC_CONST(0.022737599170003), FRAC_CONST(0.022905637966469) },
    { FRAC_CONST(0.022662519028125), FRAC_CONST(0.022979923802453) },
    { FRAC_CONST(0.022587196188874), FRAC_CONST(0.023053963541915) },
    { FRAC_CONST(0.022511631458899), FRAC_CONST(0.023127756391950) },
    { FRAC_CONST(0.022435825647437), FRAC_CONST(0.023201301562294) },
    { FRAC_CONST(0.022359779566306), FRAC_CONST(0.023274598265338) },
    { FRAC_CONST(0.022283494029900), FRAC_CONST(0.023347645716133) },
    { FRAC_CONST(0.022206969855176), FRAC_CONST(0.023420443132400) },
    { FRAC_CONST(0.022130207861645), FRAC_CONST(0.023492989734537) },
    { FRAC_CONST(0.022053208871367), FRAC_CONST(0.023565284745628) },
    { FRAC_CONST(0.021975973708940), FRAC_CONST(0.023637327391451) },
    { FRAC_CONST(0.021898503201489), FRAC_CONST(0.023709116900488) },
    { FRAC_CONST(0.021820798178663), FRAC_CONST(0.023780652503931) },
    { FRAC_CONST(0.021742859472618), FRAC_CONST(0.023851933435691) },
    { FRAC_CONST(0.021664687918017), FRAC_CONST(0.023922958932406) },
    { FRAC_CONST(0.021586284352013), FRAC_CONST(0.023993728233451) },
    { FRAC_CONST(0.021507649614247), FRAC_CONST(0.024064240580942) },
    { FRAC_CONST(0.021428784546832), FRAC_CONST(0.024134495219750) },
    { FRAC_CONST(0.021349689994350), FRAC_CONST(0.024204491397504) },
    { FRAC_CONST(0.021270366803840), FRAC_CONST(0.024274228364600) },
    { FRAC_CONST(0.021190815824791), FRAC_CONST(0.024343705374213) },
    { FRAC_CONST(0.021111037909128), FRAC_CONST(0.024412921682298) },
    { FRAC_CONST(0.021031033911210), FRAC_CONST(0.024481876547605) },
    { FRAC_CONST(0.020950804687815), FRAC_CONST(0.024550569231683) },
    { FRAC_CONST(0.020870351098134), FRAC_CONST(0.024618998998889) },
    { FRAC_CONST(0.020789674003759), FRAC_CONST(0.024687165116394) },
    { FRAC_CONST(0.020708774268678), FRAC_CONST(0.024755066854194) },
    { FRAC_CONST(0.020627652759262), FRAC_CONST(0.024822703485116) },
    { FRAC_CONST(0.020546310344257), FRAC_CONST(0.024890074284826) },
    { FRAC_CONST(0.020464747894775), FRAC_CONST(0.024957178531837) },
    { FRAC_CONST(0.020382966284284), FRAC_CONST(0.025024015507516) },
    { FRAC_CONST(0.020300966388600), FRAC_CONST(0.025090584496093) },
    { FRAC_CONST(0.020218749085876), FRAC_CONST(0.025156884784668) },
    { FRAC_CONST(0.020136315256592), FRAC_CONST(0.025222915663218) },
    { FRAC_CONST(0.020053665783549), FRAC_CONST(0.025288676424605) },
    { FRAC_CONST(0.019970801551857), FRAC_CONST(0.025354166364584) },
    { FRAC_CONST(0.019887723448925), FRAC_CONST(0.025419384781811) },
    { FRAC_CONST(0.019804432364452), FRAC_CONST(0.025484330977848) },
    { FRAC_CONST(0.019720929190419), FRAC_CONST(0.025549004257175) },
    { FRAC_CONST(0.019637214821078), FRAC_CONST(0.025613403927192) },
    { FRAC_CONST(0.019553290152943), FRAC_CONST(0.025677529298230) },
    { FRAC_CONST(0.019469156084779), FRAC_CONST(0.025741379683559) },
    { FRAC_CONST(0.019384813517595), FRAC_CONST(0.025804954399392) },
    { FRAC_CONST(0.019300263354632), FRAC_CONST(0.025868252764895) },
    { FRAC_CONST(0.019215506501354), FRAC_CONST(0.025931274102193) },
    { FRAC_CONST(0.019130543865439), FRAC_CONST(0.025994017736379) },
    { FRAC_CONST(0.019045376356769), FRAC_CONST(0.026056482995518) },
    { FRAC_CONST(0.018960004887419), FRAC_CONST(0.026118669210657) },
    { FRAC_CONST(0.018874430371648), FRAC_CONST(0.026180575715833) },
    { FRAC_CONST(0.018788653725892), FRAC_CONST(0.026242201848076) },
    { FRAC_CONST(0.018702675868750), FRAC_CONST(0.026303546947421) },
    { FRAC_CONST(0.018616497720974), FRAC_CONST(0.026364610356909) },
    { FRAC_CONST(0.018530120205464), FRAC_CONST(0.026425391422602) },
    { FRAC_CONST(0.018443544247254), FRAC_CONST(0.026485889493583) },
    { FRAC_CONST(0.018356770773502), FRAC_CONST(0.026546103921965) },
    { FRAC_CONST(0.018269800713483), FRAC_CONST(0.026606034062902) },
    { FRAC_CONST(0.018182634998576), FRAC_CONST(0.026665679274589) },
    { FRAC_CONST(0.018095274562256), FRAC_CONST(0.026725038918274) },
    { FRAC_CONST(0.018007720340083), FRAC_CONST(0.026784112358263) },
    { FRAC_CONST(0.017919973269692), FRAC_CONST(0.026842898961926) },
    { FRAC_CONST(0.017832034290785), FRAC_CONST(0.026901398099707) },
    { FRAC_CONST(0.017743904345116), FRAC_CONST(0.026959609145127) },
    { FRAC_CONST(0.017655584376488), FRAC_CONST(0.027017531474792) },
    { FRAC_CONST(0.017567075330734), FRAC_CONST(0.027075164468401) },
    { FRAC_CONST(0.017478378155718), FRAC_CONST(0.027132507508750) },
    { FRAC_CONST(0.017389493801313), FRAC_CONST(0.027189559981742) },
    { FRAC_CONST(0.017300423219401), FRAC_CONST(0.027246321276391) },
    { FRAC_CONST(0.017211167363854), FRAC_CONST(0.027302790784828) },
    { FRAC_CONST(0.017121727190533), FRAC_CONST(0.027358967902310) },
    { FRAC_CONST(0.017032103657269), FRAC_CONST(0.027414852027226) },
    { FRAC_CONST(0.016942297723858), FRAC_CONST(0.027470442561102) },
    { FRAC_CONST(0.016852310352050), FRAC_CONST(0.027525738908608) },
    { FRAC_CONST(0.016762142505537), FRAC_CONST(0.027580740477564) },
    { FRAC_CONST(0.016671795149944), FRAC_CONST(0.027635446678948) },
    { FRAC_CONST(0.016581269252819), FRAC_CONST(0.027689856926900) },
    { FRAC_CONST(0.016490565783622), FRAC_CONST(0.027743970638730) },
    { FRAC_CONST(0.016399685713714), FRAC_CONST(0.027797787234924) },
    { FRAC_CONST(0.016308630016347), FRAC_CONST(0.027851306139149) },
    { FRAC_CONST(0.016217399666655), FRAC_CONST(0.027904526778260) },
    { FRAC_CONST(0.016125995641641), FRAC_CONST(0.027957448582309) },
    { FRAC_CONST(0.016034418920170), FRAC_CONST(0.028010070984544) },
    { FRAC_CONST(0.015942670482954), FRAC_CONST(0.028062393421421) },
    { FRAC_CONST(0.015850751312545), FRAC_CONST(0.028114415332610) },
    { FRAC_CONST(0.015758662393324), FRAC_CONST(0.028166136160998) },
    { FRAC_CONST(0.015666404711489), FRAC_CONST(0.028217555352697) },
    { FRAC_CONST(0.015573979255046), FRAC_CONST(0.028268672357047) },
    { FRAC_CONST(0.015481387013797), FRAC_CONST(0.028319486626627) },
    { FRAC_CONST(0.015388628979331), FRAC_CONST(0.028369997617257) },
    { FRAC_CONST(0.015295706145012), FRAC_CONST(0.028420204788004) },
    { FRAC_CONST(0.015202619505968), FRAC_CONST(0.028470107601191) },
    { FRAC_CONST(0.015109370059084), FRAC_CONST(0.028519705522399) },
    { FRAC_CONST(0.015015958802984), FRAC_CONST(0.028568998020472) },
    { FRAC_CONST(0.014922386738030), FRAC_CONST(0.028617984567529) },
    { FRAC_CONST(0.014828654866302), FRAC_CONST(0.028666664638963) },
    { FRAC_CONST(0.014734764191593), FRAC_CONST(0.028715037713449) },
    { FRAC_CONST(0.014640715719398), FRAC_CONST(0.028763103272951) },
    { FRAC_CONST(0.014546510456900), FRAC_CONST(0.028810860802724) },
    { FRAC_CONST(0.014452149412962), FRAC_CONST(0.028858309791325) },
    { FRAC_CONST(0.014357633598114), FRAC_CONST(0.028905449730613) },
    { FRAC_CONST(0.014262964024545), FRAC_CONST(0.028952280115756) },
    { FRAC_CONST(0.014168141706090), FRAC_CONST(0.028998800445240) },
    { FRAC_CONST(0.014073167658220), FRAC_CONST(0.029045010220868) },
    { FRAC_CONST(0.013978042898030), FRAC_CONST(0.029090908947771) },
    { FRAC_CONST(0.013882768444231), FRAC_CONST(0.029136496134411) },
    { FRAC_CONST(0.013787345317136), FRAC_CONST(0.029181771292585) },
    { FRAC_CONST(0.013691774538648), FRAC_CONST(0.029226733937433) },
    { FRAC_CONST(0.013596057132255), FRAC_CONST(0.029271383587441) },
    { FRAC_CONST(0.013500194123014), FRAC_CONST(0.029315719764447) },
    { FRAC_CONST(0.013404186537539), FRAC_CONST(0.029359741993647) },
    { FRAC_CONST(0.013308035403995), FRAC_CONST(0.029403449803598) },
    { FRAC_CONST(0.013211741752084), FRAC_CONST(0.029446842726223) },
    { FRAC_CONST(0.013115306613032), FRAC_CONST(0.029489920296820) },
    { FRAC_CONST(0.013018731019584), FRAC_CONST(0.029532682054063) },
    { FRAC_CONST(0.012922016005985), FRAC_CONST(0.029575127540008) },
    { FRAC_CONST(0.012825162607977), FRAC_CONST(0.029617256300097) },
    { FRAC_CONST(0.012728171862781), FRAC_CONST(0.029659067883165) },
    { FRAC_CONST(0.012631044809089), FRAC_CONST(0.029700561841444) },
    { FRAC_CONST(0.012533782487056), FRAC_CONST(0.029741737730567) },
    { FRAC_CONST(0.012436385938281), FRAC_CONST(0.029782595109573) },
    { FRAC_CONST(0.012338856205805), FRAC_CONST(0.029823133540913) },
    { FRAC_CONST(0.012241194334091), FRAC_CONST(0.029863352590452) },
    { FRAC_CONST(0.012143401369021), FRAC_CONST(0.029903251827477) },
    { FRAC_CONST(0.012045478357878), FRAC_CONST(0.029942830824699) },
    { FRAC_CONST(0.011947426349339), FRAC_CONST(0.029982089158259) },
    { FRAC_CONST(0.011849246393462), FRAC_CONST(0.030021026407731) },
    { FRAC_CONST(0.011750939541676), FRAC_CONST(0.030059642156129) },
    { FRAC_CONST(0.011652506846768), FRAC_CONST(0.030097935989909) },
    { FRAC_CONST(0.011553949362874), FRAC_CONST(0.030135907498976) },
    { FRAC_CONST(0.011455268145464), FRAC_CONST(0.030173556276684) },
    { FRAC_CONST(0.011356464251335), FRAC_CONST(0.030210881919845) },
    { FRAC_CONST(0.011257538738598), FRAC_CONST(0.030247884028732) },
    { FRAC_CONST(0.011158492666665), FRAC_CONST(0.030284562207083) },
    { FRAC_CONST(0.011059327096240), FRAC_CONST(0.030320916062102) },
    { FRAC_CONST(0.010960043089307), FRAC_CONST(0.030356945204470) },
    { FRAC_CONST(0.010860641709118), FRAC_CONST(0.030392649248343) },
    { FRAC_CONST(0.010761124020182), FRAC_CONST(0.030428027811361) },
    { FRAC_CONST(0.010661491088253), FRAC_CONST(0.030463080514646) },
    { FRAC_CONST(0.010561743980319), FRAC_CONST(0.030497806982812) },
    { FRAC_CONST(0.010461883764593), FRAC_CONST(0.030532206843968) },
    { FRAC_CONST(0.010361911510496), FRAC_CONST(0.030566279729717) },
    { FRAC_CONST(0.010261828288652), FRAC_CONST(0.030600025275167) },
    { FRAC_CONST(0.010161635170872), FRAC_CONST(0.030633443118931) },
    { FRAC_CONST(0.010061333230142), FRAC_CONST(0.030666532903129) },
    { FRAC_CONST(0.009960923540617), FRAC_CONST(0.030699294273397) },
    { FRAC_CONST(0.009860407177603), FRAC_CONST(0.030731726878888) },
    { FRAC_CONST(0.009759785217550), FRAC_CONST(0.030763830372273) },
    { FRAC_CONST(0.009659058738038), FRAC_CONST(0.030795604409750) },
    { FRAC_CONST(0.009558228817767), FRAC_CONST(0.030827048651045) },
    { FRAC_CONST(0.009457296536545), FRAC_CONST(0.030858162759415) },
    { FRAC_CONST(0.009356262975275), FRAC_CONST(0.030888946401653) },
    { FRAC_CONST(0.009255129215945), FRAC_CONST(0.030919399248091) },
    { FRAC_CONST(0.009153896341616), FRAC_CONST(0.030949520972603) },
    { FRAC_CONST(0.009052565436412), FRAC_CONST(0.030979311252611) },
    { FRAC_CONST(0.008951137585505), FRAC_CONST(0.031008769769084) },
    { FRAC_CONST(0.008849613875105), FRAC_CONST(0.031037896206544) },
    { FRAC_CONST(0.008747995392451), FRAC_CONST(0.031066690253072) },
    { FRAC_CONST(0.008646283225794), FRAC_CONST(0.031095151600306) },
    { FRAC_CONST(0.008544478464390), FRAC_CONST(0.031123279943448) },
    { FRAC_CONST(0.008442582198486), FRAC_CONST(0.031151074981266) },
    { FRAC_CONST(0.008340595519310), FRAC_CONST(0.031178536416098) },
    { FRAC_CONST(0.008238519519057), FRAC_CONST(0.031205663953853) },
    { FRAC_CONST(0.008136355290878), FRAC_CONST(0.031232457304017) },
    { FRAC_CONST(0.008034103928871), FRAC_CONST(0.031258916179656) },
    { FRAC_CONST(0.007931766528065), FRAC_CONST(0.031285040297416) },
    { FRAC_CONST(0.007829344184412), FRAC_CONST(0.031310829377528) },
    { FRAC_CONST(0.007726837994772), FRAC_CONST(0.031336283143813) },
    { FRAC_CONST(0.007624249056906), FRAC_CONST(0.031361401323680) },
    { FRAC_CONST(0.007521578469457), FRAC_CONST(0.031386183648135) },
    { FRAC_CONST(0.007418827331946), FRAC_CONST(0.031410629851778) },
    { FRAC_CONST(0.007315996744755), FRAC_CONST(0.031434739672811) },
    { FRAC_CONST(0.007213087809115), FRAC_CONST(0.031458512853036) },
    { FRAC_CONST(0.007110101627101), FRAC_CONST(0.031481949137863) },
    { FRAC_CONST(0.007007039301610), FRAC_CONST(0.031505048276306) },
    { FRAC_CONST(0.006903901936357), FRAC_CONST(0.031527810020993) },
    { FRAC_CONST(0.006800690635862), FRAC_CONST(0.031550234128164) },
    { FRAC_CONST(0.006697406505433), FRAC_CONST(0.031572320357675) },
    { FRAC_CONST(0.006594050651161), FRAC_CONST(0.031594068473000) },
    { FRAC_CONST(0.006490624179905), FRAC_CONST(0.031615478241233) },
    { FRAC_CONST(0.006387128199278), FRAC_CONST(0.031636549433095) },
    { FRAC_CONST(0.006283563817639), FRAC_CONST(0.031657281822929) },
    { FRAC_CONST(0.006179932144080), FRAC_CONST(0.031677675188707) },
    { FRAC_CONST(0.006076234288412), FRAC_CONST(0.031697729312034) },
    { FRAC_CONST(0.005972471361157), FRAC_CONST(0.031717443978146) },
    { FRAC_CONST(0.005868644473532), FRAC_CONST(0.031736818975914) },
    { FRAC_CONST(0.005764754737440), FRAC_CONST(0.031755854097848) },
    { FRAC_CONST(0.005660803265456), FRAC_CONST(0.031774549140098) },
    { FRAC_CONST(0.005556791170816), FRAC_CONST(0.031792903902453) },
    { FRAC_CONST(0.005452719567407), FRAC_CONST(0.031810918188350) },
    { FRAC_CONST(0.005348589569753), FRAC_CONST(0.031828591804869) },
    { FRAC_CONST(0.005244402293001), FRAC_CONST(0.031845924562742) },
    { FRAC_CONST(0.005140158852914), FRAC_CONST(0.031862916276347) },
    { FRAC_CONST(0.005035860365855), FRAC_CONST(0.031879566763717) },
    { FRAC_CONST(0.004931507948778), FRAC_CONST(0.031895875846539) },
    { FRAC_CONST(0.004827102719212), FRAC_CONST(0.031911843350155) },
    { FRAC_CONST(0.004722645795254), FRAC_CONST(0.031927469103567) },
    { FRAC_CONST(0.004618138295554), FRAC_CONST(0.031942752939435) },
    { FRAC_CONST(0.004513581339303), FRAC_CONST(0.031957694694082) },
    { FRAC_CONST(0.004408976046222), FRAC_CONST(0.031972294207493) },
    { FRAC_CONST(0.004304323536549), FRAC_CONST(0.031986551323320) },
    { FRAC_CONST(0.004199624931030), FRAC_CONST(0.032000465888879) },
    { FRAC_CONST(0.004094881350902), FRAC_CONST(0.032014037755158) },
    { FRAC_CONST(0.003990093917884), FRAC_CONST(0.032027266776813) },
    { FRAC_CONST(0.003885263754166), FRAC_CONST(0.032040152812170) },
    { FRAC_CONST(0.003780391982394), FRAC_CONST(0.032052695723232) },
    { FRAC_CONST(0.003675479725661), FRAC_CONST(0.032064895375674) },
    { FRAC_CONST(0.003570528107494), FRAC_CONST(0.032076751638847) },
    { FRAC_CONST(0.003465538251839), FRAC_CONST(0.032088264385780) },
    { FRAC_CONST(0.003360511283053), FRAC_CONST(0.032099433493181) },
    { FRAC_CONST(0.003255448325892), FRAC_CONST(0.032110258841438) },
    { FRAC_CONST(0.003150350505494), FRAC_CONST(0.032120740314619) },
    { FRAC_CONST(0.003045218947373), FRAC_CONST(0.032130877800478) },
    { FRAC_CONST(0.002940054777404), FRAC_CONST(0.032140671190449) },
    { FRAC_CONST(0.002834859121810), FRAC_CONST(0.032150120379653) },
    { FRAC_CONST(0.002729633107153), FRAC_CONST(0.032159225266897) },
    { FRAC_CONST(0.002624377860318), FRAC_CONST(0.032167985754674) },
    { FRAC_CONST(0.002519094508504), FRAC_CONST(0.032176401749168) },
    { FRAC_CONST(0.002413784179212), FRAC_CONST(0.032184473160250) },
    { FRAC_CONST(0.002308448000231), FRAC_CONST(0.032192199901481) },
    { FRAC_CONST(0.002203087099626), FRAC_CONST(0.032199581890114) },
    { FRAC_CONST(0.002097702605728), FRAC_CONST(0.032206619047093) },
    { FRAC_CONST(0.001992295647121), FRAC_CONST(0.032213311297057) },
    { FRAC_CONST(0.001886867352628), FRAC_CONST(0.032219658568338) },
    { FRAC_CONST(0.001781418851302), FRAC_CONST(0.032225660792960) },
    { FRAC_CONST(0.001675951272410), FRAC_CONST(0.032231317906644) },
    { FRAC_CONST(0.001570465745428), FRAC_CONST(0.032236629848809) },
    { FRAC_CONST(0.001464963400018), FRAC_CONST(0.032241596562566) },
    { FRAC_CONST(0.001359445366028), FRAC_CONST(0.032246217994727) },
    { FRAC_CONST(0.001253912773470), FRAC_CONST(0.032250494095799) },
    { FRAC_CONST(0.001148366752513), FRAC_CONST(0.032254424819990) },
    { FRAC_CONST(0.001042808433471), FRAC_CONST(0.032258010125204) },
    { FRAC_CONST(0.000937238946789), FRAC_CONST(0.032261249973045) },
    { FRAC_CONST(0.000831659423030), FRAC_CONST(0.032264144328817) },
    { FRAC_CONST(0.000726070992868), FRAC_CONST(0.032266693161525) },
    { FRAC_CONST(0.000620474787068), FRAC_CONST(0.032268896443871) },
    { FRAC_CONST(0.000514871936481), FRAC_CONST(0.032270754152261) },
    { FRAC_CONST(0.000409263572030), FRAC_CONST(0.032272266266801) },
    { FRAC_CONST(0.000303650824695), FRAC_CONST(0.032273432771295) },
    { FRAC_CONST(0.000198034825504), FRAC_CONST(0.032274253653254) },
    { FRAC_CONST(0.000092416705518), FRAC_CONST(0.032274728903884) }
};

#ifdef LD_DEC
/* 240 (N/4) complex twiddle factors */
ALIGN static const complex_t mdct_tab_960[] =
{
    { FRAC_CONST(0.045643531183573), FRAC_CONST(0.000037342034959) },
    { FRAC_CONST(0.045642309173789), FRAC_CONST(0.000336075315362) },
    { FRAC_CONST(0.045639131999390), FRAC_CONST(0.000634794199417) },
    { FRAC_CONST(0.045633999796474), FRAC_CONST(0.000933485891002) },
    { FRAC_CONST(0.045626912784890), FRAC_CONST(0.001232137595157) },
    { FRAC_CONST(0.045617871268219), FRAC_CONST(0.001530736518639) },
    { FRAC_CONST(0.045606875633772), FRAC_CONST(0.001829269870464) },
    { FRAC_CONST(0.045593926352564), FRAC_CONST(0.002127724862455) },
    { FRAC_CONST(0.045579023979299), FRAC_CONST(0.002426088709795) },
    { FRAC_CONST(0.045562169152346), FRAC_CONST(0.002724348631569) },
    { FRAC_CONST(0.045543362593709), FRAC_CONST(0.003022491851315) },
    { FRAC_CONST(0.045522605108999), FRAC_CONST(0.003320505597570) },
    { FRAC_CONST(0.045499897587396), FRAC_CONST(0.003618377104416) },
    { FRAC_CONST(0.045475241001617), FRAC_CONST(0.003916093612031) },
    { FRAC_CONST(0.045448636407866), FRAC_CONST(0.004213642367228) },
    { FRAC_CONST(0.045420084945797), FRAC_CONST(0.004511010624011) },
    { FRAC_CONST(0.045389587838458), FRAC_CONST(0.004808185644112) },
    { FRAC_CONST(0.045357146392244), FRAC_CONST(0.005105154697544) },
    { FRAC_CONST(0.045322761996840), FRAC_CONST(0.005401905063139) },
    { FRAC_CONST(0.045286436125157), FRAC_CONST(0.005698424029100) },
    { FRAC_CONST(0.045248170333275), FRAC_CONST(0.005994698893542) },
    { FRAC_CONST(0.045207966260374), FRAC_CONST(0.006290716965035) },
    { FRAC_CONST(0.045165825628663), FRAC_CONST(0.006586465563151) },
    { FRAC_CONST(0.045121750243305), FRAC_CONST(0.006881932019003) },
    { FRAC_CONST(0.045075741992343), FRAC_CONST(0.007177103675792) },
    { FRAC_CONST(0.045027802846618), FRAC_CONST(0.007471967889347) },
    { FRAC_CONST(0.044977934859683), FRAC_CONST(0.007766512028667) },
    { FRAC_CONST(0.044926140167717), FRAC_CONST(0.008060723476460) },
    { FRAC_CONST(0.044872420989432), FRAC_CONST(0.008354589629687) },
    { FRAC_CONST(0.044816779625979), FRAC_CONST(0.008648097900101) },
    { FRAC_CONST(0.044759218460849), FRAC_CONST(0.008941235714784) },
    { FRAC_CONST(0.044699739959770), FRAC_CONST(0.009233990516688) },
    { FRAC_CONST(0.044638346670603), FRAC_CONST(0.009526349765171) },
    { FRAC_CONST(0.044575041223233), FRAC_CONST(0.009818300936537) },
    { FRAC_CONST(0.044509826329454), FRAC_CONST(0.010109831524568) },
    { FRAC_CONST(0.044442704782856), FRAC_CONST(0.010400929041064) },
    { FRAC_CONST(0.044373679458701), FRAC_CONST(0.010691581016378) },
    { FRAC_CONST(0.044302753313806), FRAC_CONST(0.010981774999945) },
    { FRAC_CONST(0.044229929386409), FRAC_CONST(0.011271498560822) },
    { FRAC_CONST(0.044155210796046), FRAC_CONST(0.011560739288214) },
    { FRAC_CONST(0.044078600743413), FRAC_CONST(0.011849484792012) },
    { FRAC_CONST(0.044000102510229), FRAC_CONST(0.012137722703321) },
    { FRAC_CONST(0.043919719459097), FRAC_CONST(0.012425440674986) },
    { FRAC_CONST(0.043837455033359), FRAC_CONST(0.012712626382127) },
    { FRAC_CONST(0.043753312756950), FRAC_CONST(0.012999267522665) },
    { FRAC_CONST(0.043667296234245), FRAC_CONST(0.013285351817848) },
    { FRAC_CONST(0.043579409149906), FRAC_CONST(0.013570867012776) },
    { FRAC_CONST(0.043489655268722), FRAC_CONST(0.013855800876928) },
    { FRAC_CONST(0.043398038435451), FRAC_CONST(0.014140141204686) },
    { FRAC_CONST(0.043304562574653), FRAC_CONST(0.014423875815857) },
    { FRAC_CONST(0.043209231690524), FRAC_CONST(0.014706992556195) },
    { FRAC_CONST(0.043112049866720), FRAC_CONST(0.014989479297920) },
    { FRAC_CONST(0.043013021266188), FRAC_CONST(0.015271323940241) },
    { FRAC_CONST(0.042912150130984), FRAC_CONST(0.015552514409871) },
    { FRAC_CONST(0.042809440782090), FRAC_CONST(0.015833038661547) },
    { FRAC_CONST(0.042704897619235), FRAC_CONST(0.016112884678543) },
    { FRAC_CONST(0.042598525120698), FRAC_CONST(0.016392040473187) },
    { FRAC_CONST(0.042490327843124), FRAC_CONST(0.016670494087374) },
    { FRAC_CONST(0.042380310421324), FRAC_CONST(0.016948233593079) },
    { FRAC_CONST(0.042268477568078), FRAC_CONST(0.017225247092864) },
    { FRAC_CONST(0.042154834073934), FRAC_CONST(0.017501522720393) },
    { FRAC_CONST(0.042039384807000), FRAC_CONST(0.017777048640940) },
    { FRAC_CONST(0.041922134712739), FRAC_CONST(0.018051813051888) },
    { FRAC_CONST(0.041803088813754), FRAC_CONST(0.018325804183247) },
    { FRAC_CONST(0.041682252209576), FRAC_CONST(0.018599010298148) },
    { FRAC_CONST(0.041559630076443), FRAC_CONST(0.018871419693350) },
    { FRAC_CONST(0.041435227667079), FRAC_CONST(0.019143020699741) },
    { FRAC_CONST(0.041309050310468), FRAC_CONST(0.019413801682838) },
    { FRAC_CONST(0.041181103411629), FRAC_CONST(0.019683751043285) },
    { FRAC_CONST(0.041051392451382), FRAC_CONST(0.019952857217350) },
    { FRAC_CONST(0.040919922986111), FRAC_CONST(0.020221108677421) },
    { FRAC_CONST(0.040786700647532), FRAC_CONST(0.020488493932496) },
    { FRAC_CONST(0.040651731142446), FRAC_CONST(0.020755001528683) },
    { FRAC_CONST(0.040515020252497), FRAC_CONST(0.021020620049682) },
    { FRAC_CONST(0.040376573833925), FRAC_CONST(0.021285338117280) },
    { FRAC_CONST(0.040236397817314), FRAC_CONST(0.021549144391836) },
    { FRAC_CONST(0.040094498207337), FRAC_CONST(0.021812027572768) },
    { FRAC_CONST(0.039950881082502), FRAC_CONST(0.022073976399034) },
    { FRAC_CONST(0.039805552594888), FRAC_CONST(0.022334979649620) },
    { FRAC_CONST(0.039658518969884), FRAC_CONST(0.022595026144014) },
    { FRAC_CONST(0.039509786505922), FRAC_CONST(0.022854104742690) },
    { FRAC_CONST(0.039359361574204), FRAC_CONST(0.023112204347583) },
    { FRAC_CONST(0.039207250618434), FRAC_CONST(0.023369313902565) },
    { FRAC_CONST(0.039053460154540), FRAC_CONST(0.023625422393919) },
    { FRAC_CONST(0.038897996770393), FRAC_CONST(0.023880518850809) },
    { FRAC_CONST(0.038740867125527), FRAC_CONST(0.024134592345752) },
    { FRAC_CONST(0.038582077950852), FRAC_CONST(0.024387631995085) },
    { FRAC_CONST(0.038421636048370), FRAC_CONST(0.024639626959432) },
    { FRAC_CONST(0.038259548290876), FRAC_CONST(0.024890566444167) },
    { FRAC_CONST(0.038095821621671), FRAC_CONST(0.025140439699877) },
    { FRAC_CONST(0.037930463054261), FRAC_CONST(0.025389236022825) },
    { FRAC_CONST(0.037763479672055), FRAC_CONST(0.025636944755403) },
    { FRAC_CONST(0.037594878628068), FRAC_CONST(0.025883555286595) },
    { FRAC_CONST(0.037424667144605), FRAC_CONST(0.026129057052425) },
    { FRAC_CONST(0.037252852512960), FRAC_CONST(0.026373439536415) },
    { FRAC_CONST(0.037079442093102), FRAC_CONST(0.026616692270033) },
    { FRAC_CONST(0.036904443313354), FRAC_CONST(0.026858804833142) },
    { FRAC_CONST(0.036727863670081), FRAC_CONST(0.027099766854444) },
    { FRAC_CONST(0.036549710727369), FRAC_CONST(0.027339568011930) },
    { FRAC_CONST(0.036369992116697), FRAC_CONST(0.027578198033315) },
    { FRAC_CONST(0.036188715536611), FRAC_CONST(0.027815646696484) },
    { FRAC_CONST(0.036005888752396), FRAC_CONST(0.028051903829926) },
    { FRAC_CONST(0.035821519595745), FRAC_CONST(0.028286959313171) },
    { FRAC_CONST(0.035635615964417), FRAC_CONST(0.028520803077226) },
    { FRAC_CONST(0.035448185821906), FRAC_CONST(0.028753425105002) },
    { FRAC_CONST(0.035259237197095), FRAC_CONST(0.028984815431745) },
    { FRAC_CONST(0.035068778183914), FRAC_CONST(0.029214964145465) },
    { FRAC_CONST(0.034876816940994), FRAC_CONST(0.029443861387355) },
    { FRAC_CONST(0.034683361691315), FRAC_CONST(0.029671497352220) },
    { FRAC_CONST(0.034488420721856), FRAC_CONST(0.029897862288892) },
    { FRAC_CONST(0.034292002383240), FRAC_CONST(0.030122946500652) },
    { FRAC_CONST(0.034094115089375), FRAC_CONST(0.030346740345641) },
    { FRAC_CONST(0.033894767317093), FRAC_CONST(0.030569234237276) },
    { FRAC_CONST(0.033693967605790), FRAC_CONST(0.030790418644658) },
    { FRAC_CONST(0.033491724557057), FRAC_CONST(0.031010284092984) },
    { FRAC_CONST(0.033288046834313), FRAC_CONST(0.031228821163949) },
    { FRAC_CONST(0.033082943162434), FRAC_CONST(0.031446020496153) },
    { FRAC_CONST(0.032876422327378), FRAC_CONST(0.031661872785500) },
    { FRAC_CONST(0.032668493175811), FRAC_CONST(0.031876368785596) },
    { FRAC_CONST(0.032459164614726), FRAC_CONST(0.032089499308145) },
    { FRAC_CONST(0.032248445611061), FRAC_CONST(0.032301255223347) },
    { FRAC_CONST(0.032036345191317), FRAC_CONST(0.032511627460281) },
    { FRAC_CONST(0.031822872441171), FRAC_CONST(0.032720607007302) },
    { FRAC_CONST(0.031608036505083), FRAC_CONST(0.032928184912422) },
    { FRAC_CONST(0.031391846585912), FRAC_CONST(0.033134352283693) },
    { FRAC_CONST(0.031174311944513), FRAC_CONST(0.033339100289593) },
    { FRAC_CONST(0.030955441899347), FRAC_CONST(0.033542420159397) },
    { FRAC_CONST(0.030735245826077), FRAC_CONST(0.033744303183559) },
    { FRAC_CONST(0.030513733157171), FRAC_CONST(0.033944740714083) },
    { FRAC_CONST(0.030290913381494), FRAC_CONST(0.034143724164891) },
    { FRAC_CONST(0.030066796043904), FRAC_CONST(0.034341245012195) },
    { FRAC_CONST(0.029841390744841), FRAC_CONST(0.034537294794860) },
    { FRAC_CONST(0.029614707139919), FRAC_CONST(0.034731865114764) },
    { FRAC_CONST(0.029386754939508), FRAC_CONST(0.034924947637164) },
    { FRAC_CONST(0.029157543908322), FRAC_CONST(0.035116534091046) },
    { FRAC_CONST(0.028927083864999), FRAC_CONST(0.035306616269485) },
    { FRAC_CONST(0.028695384681680), FRAC_CONST(0.035495186029992) },
    { FRAC_CONST(0.028462456283587), FRAC_CONST(0.035682235294866) },
    { FRAC_CONST(0.028228308648598), FRAC_CONST(0.035867756051541) },
    { FRAC_CONST(0.027992951806817), FRAC_CONST(0.036051740352923) },
    { FRAC_CONST(0.027756395840148), FRAC_CONST(0.036234180317738) },
    { FRAC_CONST(0.027518650881862), FRAC_CONST(0.036415068130865) },
    { FRAC_CONST(0.027279727116161), FRAC_CONST(0.036594396043672) },
    { FRAC_CONST(0.027039634777745), FRAC_CONST(0.036772156374348) },
    { FRAC_CONST(0.026798384151369), FRAC_CONST(0.036948341508233) },
    { FRAC_CONST(0.026555985571409), FRAC_CONST(0.037122943898140) },
    { FRAC_CONST(0.026312449421412), FRAC_CONST(0.037295956064686) },
    { FRAC_CONST(0.026067786133656), FRAC_CONST(0.037467370596605) },
    { FRAC_CONST(0.025822006188702), FRAC_CONST(0.037637180151068) },
    { FRAC_CONST(0.025575120114946), FRAC_CONST(0.037805377454000) },
    { FRAC_CONST(0.025327138488165), FRAC_CONST(0.037971955300388) },
    { FRAC_CONST(0.025078071931066), FRAC_CONST(0.038136906554591) },
    { FRAC_CONST(0.024827931112832), FRAC_CONST(0.038300224150647) },
    { FRAC_CONST(0.024576726748663), FRAC_CONST(0.038461901092573) },
    { FRAC_CONST(0.024324469599317), FRAC_CONST(0.038621930454668) },
    { FRAC_CONST(0.024071170470652), FRAC_CONST(0.038780305381806) },
    { FRAC_CONST(0.023816840213160), FRAC_CONST(0.038937019089732) },
    { FRAC_CONST(0.023561489721501), FRAC_CONST(0.039092064865353) },
    { FRAC_CONST(0.023305129934041), FRAC_CONST(0.039245436067023) },
    { FRAC_CONST(0.023047771832380), FRAC_CONST(0.039397126124832) },
    { FRAC_CONST(0.022789426440883), FRAC_CONST(0.039547128540881) },
    { FRAC_CONST(0.022530104826206), FRAC_CONST(0.039695436889566) },
    { FRAC_CONST(0.022269818096825), FRAC_CONST(0.039842044817851) },
    { FRAC_CONST(0.022008577402555), FRAC_CONST(0.039986946045542) },
    { FRAC_CONST(0.021746393934081), FRAC_CONST(0.040130134365550) },
    { FRAC_CONST(0.021483278922467), FRAC_CONST(0.040271603644166) },
    { FRAC_CONST(0.021219243638687), FRAC_CONST(0.040411347821316) },
    { FRAC_CONST(0.020954299393132), FRAC_CONST(0.040549360910825) },
    { FRAC_CONST(0.020688457535133), FRAC_CONST(0.040685637000671) },
    { FRAC_CONST(0.020421729452469), FRAC_CONST(0.040820170253240) },
    { FRAC_CONST(0.020154126570884), FRAC_CONST(0.040952954905576) },
    { FRAC_CONST(0.019885660353596), FRAC_CONST(0.041083985269625) },
    { FRAC_CONST(0.019616342300802), FRAC_CONST(0.041213255732484) },
    { FRAC_CONST(0.019346183949192), FRAC_CONST(0.041340760756635) },
    { FRAC_CONST(0.019075196871451), FRAC_CONST(0.041466494880189) },
    { FRAC_CONST(0.018803392675763), FRAC_CONST(0.041590452717113) },
    { FRAC_CONST(0.018530783005316), FRAC_CONST(0.041712628957466) },
    { FRAC_CONST(0.018257379537800), FRAC_CONST(0.041833018367625) },
    { FRAC_CONST(0.017983193984910), FRAC_CONST(0.041951615790509) },
    { FRAC_CONST(0.017708238091842), FRAC_CONST(0.042068416145797) },
    { FRAC_CONST(0.017432523636792), FRAC_CONST(0.042183414430153) },
    { FRAC_CONST(0.017156062430449), FRAC_CONST(0.042296605717432) },
    { FRAC_CONST(0.016878866315491), FRAC_CONST(0.042407985158896) },
    { FRAC_CONST(0.016600947166078), FRAC_CONST(0.042517547983420) },
    { FRAC_CONST(0.016322316887341), FRAC_CONST(0.042625289497698) },
    { FRAC_CONST(0.016042987414872), FRAC_CONST(0.042731205086442) },
    { FRAC_CONST(0.015762970714219), FRAC_CONST(0.042835290212581) },
    { FRAC_CONST(0.015482278780363), FRAC_CONST(0.042937540417454) },
    { FRAC_CONST(0.015200923637213), FRAC_CONST(0.043037951321002) },
    { FRAC_CONST(0.014918917337087), FRAC_CONST(0.043136518621958) },
    { FRAC_CONST(0.014636271960196), FRAC_CONST(0.043233238098025) },
    { FRAC_CONST(0.014352999614128), FRAC_CONST(0.043328105606063) },
    { FRAC_CONST(0.014069112433327), FRAC_CONST(0.043421117082265) },
    { FRAC_CONST(0.013784622578575), FRAC_CONST(0.043512268542327) },
    { FRAC_CONST(0.013499542236471), FRAC_CONST(0.043601556081625) },
    { FRAC_CONST(0.013213883618907), FRAC_CONST(0.043688975875378) },
    { FRAC_CONST(0.012927658962548), FRAC_CONST(0.043774524178812) },
    { FRAC_CONST(0.012640880528305), FRAC_CONST(0.043858197327323) },
    { FRAC_CONST(0.012353560600813), FRAC_CONST(0.043939991736633) },
    { FRAC_CONST(0.012065711487901), FRAC_CONST(0.044019903902940) },
    { FRAC_CONST(0.011777345520066), FRAC_CONST(0.044097930403073) },
    { FRAC_CONST(0.011488475049948), FRAC_CONST(0.044174067894638) },
    { FRAC_CONST(0.011199112451794), FRAC_CONST(0.044248313116156) },
    { FRAC_CONST(0.010909270120937), FRAC_CONST(0.044320662887211) },
    { FRAC_CONST(0.010618960473257), FRAC_CONST(0.044391114108577) },
    { FRAC_CONST(0.010328195944653), FRAC_CONST(0.044459663762361) },
    { FRAC_CONST(0.010036988990509), FRAC_CONST(0.044526308912122) },
    { FRAC_CONST(0.009745352085163), FRAC_CONST(0.044591046703005) },
    { FRAC_CONST(0.009453297721368), FRAC_CONST(0.044653874361857) },
    { FRAC_CONST(0.009160838409762), FRAC_CONST(0.044714789197351) },
    { FRAC_CONST(0.008867986678328), FRAC_CONST(0.044773788600099) },
    { FRAC_CONST(0.008574755071860), FRAC_CONST(0.044830870042761) },
    { FRAC_CONST(0.008281156151424), FRAC_CONST(0.044886031080160) },
    { FRAC_CONST(0.007987202493820), FRAC_CONST(0.044939269349379) },
    { FRAC_CONST(0.007692906691044), FRAC_CONST(0.044990582569869) },
    { FRAC_CONST(0.007398281349750), FRAC_CONST(0.045039968543542) },
    { FRAC_CONST(0.007103339090706), FRAC_CONST(0.045087425154868) },
    { FRAC_CONST(0.006808092548258), FRAC_CONST(0.045132950370962) },
    { FRAC_CONST(0.006512554369783), FRAC_CONST(0.045176542241676) },
    { FRAC_CONST(0.006216737215155), FRAC_CONST(0.045218198899680) },
    { FRAC_CONST(0.005920653756196), FRAC_CONST(0.045257918560541) },
    { FRAC_CONST(0.005624316676135), FRAC_CONST(0.045295699522801) },
    { FRAC_CONST(0.005327738669067), FRAC_CONST(0.045331540168049) },
    { FRAC_CONST(0.005030932439406), FRAC_CONST(0.045365438960992) },
    { FRAC_CONST(0.004733910701344), FRAC_CONST(0.045397394449517) },
    { FRAC_CONST(0.004436686178303), FRAC_CONST(0.045427405264758) },
    { FRAC_CONST(0.004139271602393), FRAC_CONST(0.045455470121152) },
    { FRAC_CONST(0.003841679713863), FRAC_CONST(0.045481587816494) },
    { FRAC_CONST(0.003543923260561), FRAC_CONST(0.045505757231988) },
    { FRAC_CONST(0.003246014997382), FRAC_CONST(0.045527977332297) },
    { FRAC_CONST(0.002947967685724), FRAC_CONST(0.045548247165585) },
    { FRAC_CONST(0.002649794092941), FRAC_CONST(0.045566565863562) },
    { FRAC_CONST(0.002351506991799), FRAC_CONST(0.045582932641515) },
    { FRAC_CONST(0.002053119159924), FRAC_CONST(0.045597346798344) },
    { FRAC_CONST(0.001754643379257), FRAC_CONST(0.045609807716597) },
    { FRAC_CONST(0.001456092435508), FRAC_CONST(0.045620314862489) },
    { FRAC_CONST(0.001157479117605), FRAC_CONST(0.045628867785927) },
    { FRAC_CONST(0.000858816217149), FRAC_CONST(0.045635466120535) },
    { FRAC_CONST(0.000560116527865), FRAC_CONST(0.045640109583661) },
    { FRAC_CONST(0.000261392845053), FRAC_CONST(0.045642797976394) }
};
#endif // LD_DEC

/* 60 (N/4) complex twiddle factors */
ALIGN static const complex_t mdct_tab_240[] =
{
    { FRAC_CONST(0.091286604111815), FRAC_CONST(0.000298735779793) },
    { FRAC_CONST(0.091247502481454), FRAC_CONST(0.002688238127538) },
    { FRAC_CONST(0.091145864370807), FRAC_CONST(0.005075898091152) },
    { FRAC_CONST(0.090981759437558), FRAC_CONST(0.007460079287760) },
    { FRAC_CONST(0.090755300151030), FRAC_CONST(0.009839147718664) },
    { FRAC_CONST(0.090466641715108), FRAC_CONST(0.012211472889198) },
    { FRAC_CONST(0.090115981961863), FRAC_CONST(0.014575428926191) },
    { FRAC_CONST(0.089703561215976), FRAC_CONST(0.016929395692256) },
    { FRAC_CONST(0.089229662130024), FRAC_CONST(0.019271759896156) },
    { FRAC_CONST(0.088694609490769), FRAC_CONST(0.021600916198470) },
    { FRAC_CONST(0.088098769996564), FRAC_CONST(0.023915268311810) },
    { FRAC_CONST(0.087442552006035), FRAC_CONST(0.026213230094844) },
    { FRAC_CONST(0.086726405258214), FRAC_CONST(0.028493226639351) },
    { FRAC_CONST(0.085950820564309), FRAC_CONST(0.030753695349588) },
    { FRAC_CONST(0.085116329471329), FRAC_CONST(0.032993087013213) },
    { FRAC_CONST(0.084223503897785), FRAC_CONST(0.035209866863042) },
    { FRAC_CONST(0.083272955741727), FRAC_CONST(0.037402515628894) },
    { FRAC_CONST(0.082265336461381), FRAC_CONST(0.039569530578832) },
    { FRAC_CONST(0.081201336628670), FRAC_CONST(0.041709426549053) },
    { FRAC_CONST(0.080081685455930), FRAC_CONST(0.043820736961749) },
    { FRAC_CONST(0.078907150296148), FRAC_CONST(0.045902014830227) },
    { FRAC_CONST(0.077678536117054), FRAC_CONST(0.047951833750597) },
    { FRAC_CONST(0.076396684949434), FRAC_CONST(0.049968788879362) },
    { FRAC_CONST(0.075062475310050), FRAC_CONST(0.051951497896226) },
    { FRAC_CONST(0.073676821599542), FRAC_CONST(0.053898601951466) },
    { FRAC_CONST(0.072240673475749), FRAC_CONST(0.055808766597225) },
    { FRAC_CONST(0.070755015202858), FRAC_CONST(0.057680682702068) },
    { FRAC_CONST(0.069220864976840), FRAC_CONST(0.059513067348201) },
    { FRAC_CONST(0.067639274227625), FRAC_CONST(0.061304664710718) },
    { FRAC_CONST(0.066011326898512), FRAC_CONST(0.063054246918278) },
    { FRAC_CONST(0.064338138703282), FRAC_CONST(0.064760614894630) },
    { FRAC_CONST(0.062620856361546), FRAC_CONST(0.066422599180399) },
    { FRAC_CONST(0.060860656812842), FRAC_CONST(0.068039060734572) },
    { FRAC_CONST(0.059058746410016), FRAC_CONST(0.069608891715145) },
    { FRAC_CONST(0.057216360092450), FRAC_CONST(0.071131016238378) },
    { FRAC_CONST(0.055334760539699), FRAC_CONST(0.072604391116154) },
    { FRAC_CONST(0.053415237306106), FRAC_CONST(0.074028006570930) },
    { FRAC_CONST(0.051459105937014), FRAC_CONST(0.075400886927784) },
    { FRAC_CONST(0.049467707067153), FRAC_CONST(0.076722091283096) },
    { FRAC_CONST(0.047442405501835), FRAC_CONST(0.077990714149396) },
    { FRAC_CONST(0.045384589281588), FRAC_CONST(0.079205886075941) },
    { FRAC_CONST(0.043295668730857), FRAC_CONST(0.080366774244592) },
    { FRAC_CONST(0.041177075491445), FRAC_CONST(0.081472583040586) },
    { FRAC_CONST(0.039030261541332), FRAC_CONST(0.082522554597810) },
    { FRAC_CONST(0.036856698199564), FRAC_CONST(0.083515969318206) },
    { FRAC_CONST(0.034657875117883), FRAC_CONST(0.084452146364948) },
    { FRAC_CONST(0.032435299259796), FRAC_CONST(0.085330444129049) },
    { FRAC_CONST(0.030190493867775), FRAC_CONST(0.086150260669096) },
    { FRAC_CONST(0.027924997419306), FRAC_CONST(0.086911034123781) },
    { FRAC_CONST(0.025640362572491), FRAC_CONST(0.087612243096981) },
    { FRAC_CONST(0.023338155101933), FRAC_CONST(0.088253407015092) },
    { FRAC_CONST(0.021019952825636), FRAC_CONST(0.088834086456390) },
    { FRAC_CONST(0.018687344523641), FRAC_CONST(0.089353883452193) },
    { FRAC_CONST(0.016341928849164), FRAC_CONST(0.089812441759604) },
    { FRAC_CONST(0.013985313232951), FRAC_CONST(0.090209447105664) },
    { FRAC_CONST(0.011619112781631), FRAC_CONST(0.090544627402740) },
    { FRAC_CONST(0.009244949170797), FRAC_CONST(0.090817752935000) },
    { FRAC_CONST(0.006864449533597), FRAC_CONST(0.091028636515846) },
    { FRAC_CONST(0.004479245345574), FRAC_CONST(0.091177133616206) },
    { FRAC_CONST(0.002090971306534), FRAC_CONST(0.091263142463585) }
};
#endif // ALLOW_SMALL_FRAMELENGTH

#ifdef SSR_DEC
/* 128 (N/4) complex twiddle factors */
ALIGN static const complex_t mdct_tab_512[] =
{
    { FRAC_CONST(0.062499926465731), FRAC_CONST(0.000095873761643) },
    { FRAC_CONST(0.062494043817678), FRAC_CONST(0.000862836783004) },
    { FRAC_CONST(0.062478749796497), FRAC_CONST(0.001629669864319) },
    { FRAC_CONST(0.062454046705412), FRAC_CONST(0.002396257523347) },
    { FRAC_CONST(0.062419938264617), FRAC_CONST(0.003162484314806) },
    { FRAC_CONST(0.062376429610718), FRAC_CONST(0.003928234847760) },
    { FRAC_CONST(0.062323527295958), FRAC_CONST(0.004693393802995) },
    { FRAC_CONST(0.062261239287231), FRAC_CONST(0.005457845950387) },
    { FRAC_CONST(0.062189574964882), FRAC_CONST(0.006221476166254) },
    { FRAC_CONST(0.062108545121295), FRAC_CONST(0.006984169450695) },
    { FRAC_CONST(0.062018161959266), FRAC_CONST(0.007745810944907) },
    { FRAC_CONST(0.061918439090167), FRAC_CONST(0.008506285948482) },
    { FRAC_CONST(0.061809391531894), FRAC_CONST(0.009265479936681) },
    { FRAC_CONST(0.061691035706609), FRAC_CONST(0.010023278577683) },
    { FRAC_CONST(0.061563389438265), FRAC_CONST(0.010779567749800) },
    { FRAC_CONST(0.061426471949919), FRAC_CONST(0.011534233558664) },
    { FRAC_CONST(0.061280303860842), FRAC_CONST(0.012287162354380) },
    { FRAC_CONST(0.061124907183410), FRAC_CONST(0.013038240748641) },
    { FRAC_CONST(0.060960305319791), FRAC_CONST(0.013787355631805) },
    { FRAC_CONST(0.060786523058421), FRAC_CONST(0.014534394189923) },
    { FRAC_CONST(0.060603586570268), FRAC_CONST(0.015279243921739) },
    { FRAC_CONST(0.060411523404896), FRAC_CONST(0.016021792655621) },
    { FRAC_CONST(0.060210362486310), FRAC_CONST(0.016761928566463) },
    { FRAC_CONST(0.060000134108604), FRAC_CONST(0.017499540192517) },
    { FRAC_CONST(0.059780869931400), FRAC_CONST(0.018234516452187) },
    { FRAC_CONST(0.059552602975075), FRAC_CONST(0.018966746660751) },
    { FRAC_CONST(0.059315367615794), FRAC_CONST(0.019696120547033) },
    { FRAC_CONST(0.059069199580329), FRAC_CONST(0.020422528270008) },
    { FRAC_CONST(0.058814135940681), FRAC_CONST(0.021145860435346) },
    { FRAC_CONST(0.058550215108495), FRAC_CONST(0.021866008111883) },
    { FRAC_CONST(0.058277476829279), FRAC_CONST(0.022582862848028) },
    { FRAC_CONST(0.057995962176414), FRAC_CONST(0.023296316688095) },
    { FRAC_CONST(0.057705713544970), FRAC_CONST(0.024006262188558) },
    { FRAC_CONST(0.057406774645326), FRAC_CONST(0.024712592434239) },
    { FRAC_CONST(0.057099190496578), FRAC_CONST(0.025415201054398) },
    { FRAC_CONST(0.056783007419769), FRAC_CONST(0.026113982238763) },
    { FRAC_CONST(0.056458273030907), FRAC_CONST(0.026808830753458) },
    { FRAC_CONST(0.056125036233796), FRAC_CONST(0.027499641956852) },
    { FRAC_CONST(0.055783347212673), FRAC_CONST(0.028186311815319) },
    { FRAC_CONST(0.055433257424646), FRAC_CONST(0.028868736918904) },
    { FRAC_CONST(0.055074819591951), FRAC_CONST(0.029546814496896) },
    { FRAC_CONST(0.054708087694007), FRAC_CONST(0.030220442433307) },
    { FRAC_CONST(0.054333116959288), FRAC_CONST(0.030889519282247) },
    { FRAC_CONST(0.053949963857008), FRAC_CONST(0.031553944283204) },
    { FRAC_CONST(0.053558686088614), FRAC_CONST(0.032213617376216) },
    { FRAC_CONST(0.053159342579100), FRAC_CONST(0.032868439216943) },
    { FRAC_CONST(0.052751993468129), FRAC_CONST(0.033518311191623) },
    { FRAC_CONST(0.052336700100979), FRAC_CONST(0.034163135431927) },
    { FRAC_CONST(0.051913525019303), FRAC_CONST(0.034802814829698) },
    { FRAC_CONST(0.051482531951712), FRAC_CONST(0.035437253051569) },
    { FRAC_CONST(0.051043785804177), FRAC_CONST(0.036066354553480) },
    { FRAC_CONST(0.050597352650253), FRAC_CONST(0.036690024595057) },
    { FRAC_CONST(0.050143299721132), FRAC_CONST(0.037308169253887) },
    { FRAC_CONST(0.049681695395515), FRAC_CONST(0.037920695439658) },
    { FRAC_CONST(0.049212609189314), FRAC_CONST(0.038527510908178) },
    { FRAC_CONST(0.048736111745188), FRAC_CONST(0.039128524275271) },
    { FRAC_CONST(0.048252274821899), FRAC_CONST(0.039723645030535) },
    { FRAC_CONST(0.047761171283507), FRAC_CONST(0.040312783550971) },
    { FRAC_CONST(0.047262875088400), FRAC_CONST(0.040895851114488) },
    { FRAC_CONST(0.046757461278150), FRAC_CONST(0.041472759913252) },
    { FRAC_CONST(0.046245005966220), FRAC_CONST(0.042043423066923) },
    { FRAC_CONST(0.045725586326493), FRAC_CONST(0.042607754635728) },
    { FRAC_CONST(0.045199280581658), FRAC_CONST(0.043165669633408) },
    { FRAC_CONST(0.044666167991423), FRAC_CONST(0.043717084040018) },
    { FRAC_CONST(0.044126328840584), FRAC_CONST(0.044261914814575) },
    { FRAC_CONST(0.043579844426930), FRAC_CONST(0.044800079907569) },
    { FRAC_CONST(0.043026797049006), FRAC_CONST(0.045331498273316) },
    { FRAC_CONST(0.042467269993710), FRAC_CONST(0.045856089882166) },
    { FRAC_CONST(0.041901347523761), FRAC_CONST(0.046373775732552) },
    { FRAC_CONST(0.041329114865000), FRAC_CONST(0.046884477862888) },
    { FRAC_CONST(0.040750658193560), FRAC_CONST(0.047388119363313) },
    { FRAC_CONST(0.040166064622889), FRAC_CONST(0.047884624387270) },
    { FRAC_CONST(0.039575422190629), FRAC_CONST(0.048373918162926) },
    { FRAC_CONST(0.038978819845356), FRAC_CONST(0.048855927004441) },
    { FRAC_CONST(0.038376347433190), FRAC_CONST(0.049330578323055) },
    { FRAC_CONST(0.037768095684260), FRAC_CONST(0.049797800638026) },
    { FRAC_CONST(0.037154156199042), FRAC_CONST(0.050257523587392) },
    { FRAC_CONST(0.036534621434563), FRAC_CONST(0.050709677938566) },
    { FRAC_CONST(0.035909584690482), FRAC_CONST(0.051154195598769) },
    { FRAC_CONST(0.035279140095032), FRAC_CONST(0.051591009625274) },
    { FRAC_CONST(0.034643382590851), FRAC_CONST(0.052020054235496) },
    { FRAC_CONST(0.034002407920680), FRAC_CONST(0.052441264816895) },
    { FRAC_CONST(0.033356312612947), FRAC_CONST(0.052854577936706) },
    { FRAC_CONST(0.032705193967229), FRAC_CONST(0.053259931351495) },
    { FRAC_CONST(0.032049150039598), FRAC_CONST(0.053657264016528) },
    { FRAC_CONST(0.031388279627857), FRAC_CONST(0.054046516094966) },
    { FRAC_CONST(0.030722682256659), FRAC_CONST(0.054427628966880) },
    { FRAC_CONST(0.030052458162521), FRAC_CONST(0.054800545238072) },
    { FRAC_CONST(0.029377708278725), FRAC_CONST(0.055165208748723) },
    { FRAC_CONST(0.028698534220122), FRAC_CONST(0.055521564581850) },
    { FRAC_CONST(0.028015038267826), FRAC_CONST(0.055869559071575) },
    { FRAC_CONST(0.027327323353815), FRAC_CONST(0.056209139811209) },
    { FRAC_CONST(0.026635493045425), FRAC_CONST(0.056540255661140) },
    { FRAC_CONST(0.025939651529755), FRAC_CONST(0.056862856756541) },
    { FRAC_CONST(0.025239903597978), FRAC_CONST(0.057176894514872) },
    { FRAC_CONST(0.024536354629559), FRAC_CONST(0.057482321643202) },
    { FRAC_CONST(0.023829110576385), FRAC_CONST(0.057779092145329) },
    { FRAC_CONST(0.023118277946808), FRAC_CONST(0.058067161328707) },
    { FRAC_CONST(0.022403963789609), FRAC_CONST(0.058346485811177) },
    { FRAC_CONST(0.021686275677870), FRAC_CONST(0.058617023527499) },
    { FRAC_CONST(0.020965321692783), FRAC_CONST(0.058878733735689) },
    { FRAC_CONST(0.020241210407366), FRAC_CONST(0.059131577023150) },
    { FRAC_CONST(0.019514050870114), FRAC_CONST(0.059375515312615) },
    { FRAC_CONST(0.018783952588580), FRAC_CONST(0.059610511867874) },
    { FRAC_CONST(0.018051025512878), FRAC_CONST(0.059836531299311) },
    { FRAC_CONST(0.017315380019131), FRAC_CONST(0.060053539569230) },
    { FRAC_CONST(0.016577126892844), FRAC_CONST(0.060261503996984) },
    { FRAC_CONST(0.015836377312223), FRAC_CONST(0.060460393263896) },
    { FRAC_CONST(0.015093242831429), FRAC_CONST(0.060650177417972) },
    { FRAC_CONST(0.014347835363782), FRAC_CONST(0.060830827878419) },
    { FRAC_CONST(0.013600267164905), FRAC_CONST(0.061002317439940) },
    { FRAC_CONST(0.012850650815819), FRAC_CONST(0.061164620276839) },
    { FRAC_CONST(0.012099099205988), FRAC_CONST(0.061317711946905) },
    { FRAC_CONST(0.011345725516320), FRAC_CONST(0.061461569395097) },
    { FRAC_CONST(0.010590643202123), FRAC_CONST(0.061596170957011) },
    { FRAC_CONST(0.009833965976015), FRAC_CONST(0.061721496362147) },
    { FRAC_CONST(0.009075807790803), FRAC_CONST(0.061837526736961) },
    { FRAC_CONST(0.008316282822321), FRAC_CONST(0.061944244607705) },
    { FRAC_CONST(0.007555505452236), FRAC_CONST(0.062041633903059) },
    { FRAC_CONST(0.006793590250821), FRAC_CONST(0.062129679956555) },
    { FRAC_CONST(0.006030651959703), FRAC_CONST(0.062208369508780) },
    { FRAC_CONST(0.005266805474583), FRAC_CONST(0.062277690709378) },
    { FRAC_CONST(0.004502165827931), FRAC_CONST(0.062337633118830) },
    { FRAC_CONST(0.003736848171665), FRAC_CONST(0.062388187710030) },
    { FRAC_CONST(0.002970967759810), FRAC_CONST(0.062429346869643) },
    { FRAC_CONST(0.002204639931138), FRAC_CONST(0.062461104399250) },
    { FRAC_CONST(0.001437980091802), FRAC_CONST(0.062483455516285) },
    { FRAC_CONST(0.000671103697954), FRAC_CONST(0.062496396854751) }
};

/* 16 (N/4) complex twiddle factors */
ALIGN static const complex_t mdct_tab_64[] =
{
    { FRAC_CONST(0.176763384336599), FRAC_CONST(0.002169321984356) },
    { FRAC_CONST(0.175699589589310), FRAC_CONST(0.019484717553714) },
    { FRAC_CONST(0.172943711747111), FRAC_CONST(0.036612464641599) },
    { FRAC_CONST(0.168522291420137), FRAC_CONST(0.053387613680577) },
    { FRAC_CONST(0.162477909303132), FRAC_CONST(0.069648610815172) },
    { FRAC_CONST(0.154868776100077), FRAC_CONST(0.085238853753814) },
    { FRAC_CONST(0.145768171923295), FRAC_CONST(0.100008199934509) },
    { FRAC_CONST(0.135263740565902), FRAC_CONST(0.113814412479792) },
    { FRAC_CONST(0.123456645444178), FRAC_CONST(0.126524530015608) },
    { FRAC_CONST(0.110460595338559), FRAC_CONST(0.138016147162030) },
    { FRAC_CONST(0.096400749315926), FRAC_CONST(0.148178593363981) },
    { FRAC_CONST(0.081412511379371), FRAC_CONST(0.156913998709178) },
    { FRAC_CONST(0.065640226453626), FRAC_CONST(0.164138236468888) },
    { FRAC_CONST(0.049235790264535), FRAC_CONST(0.169781733284316) },
    { FRAC_CONST(0.032357186500177), FRAC_CONST(0.173790139196080) },
    { FRAC_CONST(0.015166965341583), FRAC_CONST(0.176124851064031) }
};
#endif // SSR_DEC

#endif // FIXED_POINT

#ifdef __cplusplus
}
#endif
#endif
