/**
 * 
 */
package org.blueforest.rockhouse.encoding_converter.popup.actions;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.IntBuffer;

/**
 * @author akira saito
 *
 */
public class LineDelimiterConvertInputStream extends InputStream {
	private PushbackInputStream stream;
	private IntBuffer buffer;
	private LineDelimiter lineDelimiter;
	private int[] lineDelimiterCodes;
	private boolean cr = false;
	private boolean lf = false;
	private boolean crLf = false;
	private boolean reachEof = false;
	private boolean eofReturned = false;
	
	/**
	 * 
	 */
	public LineDelimiterConvertInputStream(InputStream stream, LineDelimiter lineDelimiter) {
		this.stream = new PushbackInputStream(stream);
		this.buffer = IntBuffer.allocate(4096);
		this.buffer.limit(0);
		this.lineDelimiter = lineDelimiter;

		byte[] bytes = this.lineDelimiter.getBytes();
		this.lineDelimiterCodes = new int[bytes.length];
		for (int i = 0; i < bytes.length; ++i) {
			this.lineDelimiterCodes[i] = bytes[i];
		}
	}

	private void charge() throws IOException {
		this.buffer.clear();

		do {
			int c = this.stream.read();
			if (c == -1) {
				this.buffer.put(-1);
				break;
			}
			
			if (c == '\r') {
				int next = this.stream.read();
				if (next == -1) {
					this.buffer.put(this.lineDelimiterCodes);
					cr = true;
					break;
					
				} else if (next == '\n') {
					this.buffer.put(this.lineDelimiterCodes);
					crLf = true;
					continue;

				} else {
					this.buffer.put(this.lineDelimiterCodes);
					this.stream.unread(next);
					cr = true;
					continue;
				}
				
			} else if (c == '\n') {
				this.buffer.put(this.lineDelimiterCodes);
				lf = true;
				continue;
			}
			
			this.buffer.put(c);
			
		} while (this.buffer.remaining() >= lineDelimiterCodes.length + 1);

		this.buffer.limit(this.buffer.position());
		this.buffer.rewind();
	}
	
	@Override
	public int read() throws IOException {
		if (this.reachEof && !this.eofReturned) {
			this.eofReturned = true;
			return -1;
		}
		if (this.reachEof) {
			throw new EOFException();
		}
		
		if (!this.buffer.hasRemaining()) {
			this.charge();
		}

		int c = this.buffer.get();
		if (c == -1) {
			this.reachEof = true;
		}
		return c;
	}
//
//	@Override
//	public int read(byte[] b) throws IOException {
//		int i;
//		for (i = 0; i < b.length; ++i) {
//			int c = this.read();
//			if (c == -1) {
//				break;
//			}
//			b[i] = (byte)c;
//		}
//		return i;
//	}
//
//	@Override
//	public int read(byte[] b, int off, int len) throws IOException {
//		int i;
//		for (i = 0; i < len; ++i) {
//			int c = this.read();
//			if (c == -1) {
//				break;
//			}
//			b[i+off] = (byte)c;
//		}
//		return i;
//	}

	@Override
	public int available() throws IOException {
		return this.stream.available() + this.buffer.remaining();
	}
//
//	@Override
//	public long skip(long n) throws IOException {
//		return this.stream.skip(n);
//	}

	@Override
	public boolean markSupported() {
		return false;
	}

	@Override
	public void mark(int readlimit) {
		throw new UnsupportedOperationException();
	}

	@Override
	public void reset() throws IOException {
		throw new UnsupportedOperationException();
	}

	@Override
	public void close() throws IOException {
		this.stream.close();
	}

	public boolean hasCr() {
		return this.cr;
	}

	public boolean hasLf() {
		return this.lf;
	}

	public boolean hasCrLf() {
		return this.crLf;
	}

}
