package org.blueforest.rockhouse.encoding_converter.popup.actions.wizard;

import org.blueforest.rockhouse.encoding_converter.popup.actions.LineDelimiter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ConvertEncodingWizardPage extends WizardPage {
	private String fromEncoding;
	private String toEncoding;
	private LineDelimiter toLineDelimiter;
	private boolean convertLineDelimiter;
	private String contentTypeText;
	private boolean onlyReporting;
	private Button useResourceSettingCheckBox = null;
	private Button useProjectDefaultSettingCheckBox = null;
	private Combo fromEncodingCombo = null;
	private Combo toEncodingCombo = null;
	private Button convertLineDelimiterCheckBox = null;
	private Combo convertLineDelimiterCombo = null;
	private Text contentTypeFilterText = null;
	private Button onlyReportingCheckbox = null;
	
	public ConvertEncodingWizardPage() {
		super("Convert Encoding");
		this.setTitle("Convert Encoding");
		this.setMessage("Run custom conversion.");
		this.setPageComplete(true);
	}
	
	public ConvertEncodingWizardPage(String name) {
		super(name);
	}

	public void createControl(Composite parent) {
		Composite container = new Composite(parent, SWT.NULL);
		container.setLayout(this.createVerticalListLayout());
		
		Composite fromToContainer = new Composite(container, SWT.NULL);
		fromToContainer.setLayout(this.createHorizontalFillLayout());

		// From Encoding
		final Group fromEncodingGroup = createGroup(fromToContainer, "From Encoding"); 
		{
			useResourceSettingCheckBox = new Button(fromEncodingGroup, SWT.CHECK);
			useResourceSettingCheckBox.setText("Use resource properties");
			useResourceSettingCheckBox.setSelection(true);
			
			fromEncodingCombo = new Combo(fromEncodingGroup, SWT.DROP_DOWN);
			fromEncodingCombo.setLayoutData(new RowData(200, fromEncodingCombo.getItemHeight()));
			fromEncodingCombo.setEnabled(false);
			fromEncodingCombo.add("UTF-8");

			useResourceSettingCheckBox.addSelectionListener(new SelectionListener(){
				public void widgetSelected(SelectionEvent e) {
//					Button button = (Button)e.widget;
//					if(button.getSelection()) {
//						fromEncodingCombo.setEnabled(false);
//						fromEncoding = null;
//					} else {
//						fromEncodingCombo.setEnabled(true);
//						fromEncoding = fromEncodingCombo.getText();
//					}
					applyInputFieldRule();
				}

				public void widgetDefaultSelected(SelectionEvent e) {
				}
				
			});
		
			fromEncodingCombo.addModifyListener( new ModifyListener() {
				public void modifyText(ModifyEvent e) {
//					fromEncoding = fromEncodingCombo.getText();
					applyInputFieldRule();
				}
			});
		}

		// To Encoding
		final Group toEncodingGroup = createGroup(fromToContainer, "To Encoding");
		{
			useProjectDefaultSettingCheckBox = new Button(toEncodingGroup, SWT.CHECK);
			useProjectDefaultSettingCheckBox.setText("Use project default");
			useProjectDefaultSettingCheckBox.setSelection(true);

			toEncodingCombo = new Combo(toEncodingGroup, SWT.DROP_DOWN);
			toEncodingCombo.setLayoutData(new RowData(200, toEncodingCombo.getItemHeight()));
			toEncodingCombo.setEnabled(false);
			toEncodingCombo.add("UTF-8");
			
			useProjectDefaultSettingCheckBox.addSelectionListener(new SelectionListener(){
				public void widgetSelected(SelectionEvent e) {
//					Button button = (Button)e.widget;
//					if(button.getSelection()) {
//						toEncodingCombo.setEnabled(false);
//						toEncoding = null;
//					} else {
//						toEncodingCombo.setEnabled(true);
//						toEncoding = toEncodingCombo.getText();
//					}
					applyInputFieldRule();
				}

				public void widgetDefaultSelected(SelectionEvent e) {
				}
				
			});

			toEncodingCombo.addModifyListener( new ModifyListener() {
				public void modifyText(ModifyEvent e) {
					applyInputFieldRule();
				}
			});
		}

		// Convert line delimiter
		Composite conertLineDelimiterComposite = new Composite(container, SWT.NULL);
		conertLineDelimiterComposite.setLayout(this.createVerticalListLayout());
		
		convertLineDelimiterCheckBox = new Button(conertLineDelimiterComposite, SWT.CHECK);
		convertLineDelimiterCheckBox.setText("Convert line delimiter");
		convertLineDelimiterCheckBox.setSelection(false);
		convertLineDelimiterCheckBox.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent e) {
				applyInputFieldRule();
			}

			public void widgetDefaultSelected(SelectionEvent e) {
			}
			
		});

		convertLineDelimiterCombo = new Combo(conertLineDelimiterComposite, SWT.DROP_DOWN | SWT.READ_ONLY);
		convertLineDelimiterCombo.setLayoutData(new RowData(200, toEncodingCombo.getItemHeight()));
		convertLineDelimiterCombo.setEnabled(false);
		convertLineDelimiterCombo.add(LineDelimiter.CR.name());
		convertLineDelimiterCombo.add(LineDelimiter.LF.name());
		convertLineDelimiterCombo.add(LineDelimiter.CRLF.name());
		convertLineDelimiterCombo.addModifyListener( new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				applyInputFieldRule();
			}
		});
		

		// Content type filter
		Composite contentTypeFilter = new Composite(container, SWT.NULL);
		contentTypeFilter.setLayout(this.createHorizontalListLayout());
		
		Label contentTypeLabel = new Label(contentTypeFilter, SWT.NULL);
		contentTypeLabel.setText("Content type filter:");
		contentTypeFilterText = new Text(contentTypeFilter, SWT.BORDER);
		contentTypeFilterText.setText("^Text($|/.*)");
		contentTypeFilterText.setToolTipText("Can use a content type of Eclipse.\nsee Preferences -> General -> Content Types");
		contentTypeFilterText.setLayoutData(new RowData(150,contentTypeFilterText.getLineHeight()));
		contentTypeFilterText.addModifyListener(new ModifyListener(){
			public void modifyText(ModifyEvent e) {
				applyInputFieldRule();
			}
		});
		
		// only reporting
		onlyReportingCheckbox = new Button(container, SWT.CHECK);
		onlyReportingCheckbox.setText("Only the current encoding report");
		onlyReportingCheckbox.setSelection(false);
		onlyReportingCheckbox.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent e) {
				applyInputFieldRule();
			}

			public void widgetDefaultSelected(SelectionEvent e) {
			}
			
		});

		
		this.setControl(fromToContainer);
	}
	
	private void applyInputFieldRule() {
		if (this.convertLineDelimiterCheckBox.getSelection()) {
			this.convertLineDelimiterCombo.setEnabled(true);

			this.convertLineDelimiter = true;
			String text = this.convertLineDelimiterCombo.getText();
			if (text == null || text.length() == 0) {
				this.toLineDelimiter = null;
			} else {
				this.toLineDelimiter = LineDelimiter.valueOf(text);
			}
		} else {
			this.convertLineDelimiterCombo.setEnabled(false);

			this.convertLineDelimiter = false;
			this.toLineDelimiter = null;
		}
		
		this.contentTypeText = this.contentTypeFilterText.getText();
		if (this.onlyReportingCheckbox.getSelection()) {
			onlyReporting = true;
			toEncoding = null;
			fromEncoding = null;
			useResourceSettingCheckBox.setEnabled(false);
			useProjectDefaultSettingCheckBox.setEnabled(false);
			fromEncodingCombo.setEnabled(false);
			toEncodingCombo.setEnabled(false);
			return;
		}
		
		onlyReporting = false;
		useResourceSettingCheckBox.setEnabled(true);
		if (this.useResourceSettingCheckBox.getSelection()) {
			fromEncodingCombo.setEnabled(false);
			fromEncoding = null;
		} else {
			fromEncodingCombo.setEnabled(true);
			fromEncoding = this.fromEncodingCombo.getText();
		}
		
		useProjectDefaultSettingCheckBox.setEnabled(true);
		if (this.useProjectDefaultSettingCheckBox.getSelection()) {
			toEncodingCombo.setEnabled(false);
			toEncoding = null;
		} else {
			toEncodingCombo.setEnabled(true);
			toEncoding = this.toEncodingCombo.getText();
		}
	}

	private FillLayout createHorizontalFillLayout() {
		FillLayout layout = new FillLayout();
		layout.type = SWT.HORIZONTAL;
		return layout;
	}

	private RowLayout createHorizontalListLayout() {
		RowLayout layout = new RowLayout();
		layout.justify = false;
		layout.type = SWT.HORIZONTAL;
		layout.fill = true;
		return layout;
	}

	private RowLayout createVerticalListLayout() {
		RowLayout layout = new RowLayout();
		layout.justify = false;
		layout.type = SWT.VERTICAL;
		layout.fill = true;
		return layout;
	}

	private Group createGroup(Composite container, String caption) {
		Group group = new Group(container, SWT.SHADOW_ETCHED_IN); 
		group.setText(caption);
		group.setLayout(this.createVerticalListLayout());
		return group;
	}

	public String getFromEncoding() {
		return this.fromEncoding;
	}

	public void setFromEncoding(String fromEncoding) {
		this.fromEncoding = fromEncoding;
	}

	public String getToEncoding() {
		return this.toEncoding;
	}

	public void setToEncoding(String toEncoding) {
		this.toEncoding = toEncoding;
	}

	public boolean isConvertLineDelimiter() {
		return this.convertLineDelimiter;
	}

	public void setConvertLineDelimiter(boolean enabled) {
		this.convertLineDelimiter = enabled;
	}

	public LineDelimiter getToLineDelimiter() {
		return this.toLineDelimiter;
	}

	public void setToLineDelimiter(LineDelimiter lineDelimiter) {
		this.toLineDelimiter = lineDelimiter;
	}
	
	public String getContentTypeFilter() {
		return this.contentTypeText;
	}

	public void setContentTypeFilter(String filter) {
		this.contentTypeText = filter;
	}

	public boolean isOnlyReporting() {
		return this.onlyReporting;
	}

	public void setOnlyReporting(boolean onlyReporting) {
		this.onlyReporting = onlyReporting;
	}

}
