/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.edocbook.core;

import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import jp.sourceforge.edocbook.core.DocbookFile;
import jp.sourceforge.edocbook.core.EDocbookRuntimeException;
import jp.sourceforge.edocbook.core.ResultFile;

public class DocbookTransformer {
    private Transformer transformer;

    public DocbookTransformer(Source xsl) {
        this.transformer = this.createTransformer(xsl);
    }

    public void transform(DocbookFile source, ResultFile result) {
        try {
            assert (this.transformer != null);
            this.transformer.transform(source.getSource(), result.getResult());
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw new EDocbookRuntimeException(e);
        }
    }

    public void setOutputProperty(String key, String value) {
        this.transformer.setOutputProperty(key, value);
    }

    public void setParameter(String param, String value) {
        this.transformer.setParameter(param, value);
    }

    private Transformer createTransformer(Source xsl) {
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer transformer = tf.newTransformer(xsl);
            assert (transformer != null);
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            throw new EDocbookRuntimeException(e);
        }
    }
}

