/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.edocbook.core;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import jp.sourceforge.edocbook.core.Activator;
import jp.sourceforge.edocbook.core.DocbookFile;
import jp.sourceforge.edocbook.core.DocbookTransformer;
import jp.sourceforge.edocbook.core.Param;
import jp.sourceforge.edocbook.core.ResultFile;
import jp.sourceforge.edocbook.core.Template;
import jp.sourceforge.edocbook.core.XslBuilder;

public class DocbookXsl {
    private Properties outputProperties;
    private List<Param> parameters;
    private String rootDir;
    private List<String> importXslList = new ArrayList<String>();
    private List<Template> templates;
    private String resultFileExtension;

    public DocbookXsl() {
        this.rootDir = Activator.getResourceAsUrlString("lib/docbook-xsl");
    }

    public DocbookXsl(String rootDir, Properties outputProperties, List<Param> parameters) {
        this.rootDir = rootDir;
        this.outputProperties = outputProperties;
        this.parameters = parameters;
    }

    private Source getSource() {
        XslBuilder builder = new XslBuilder();
        for (String s : this.importXslList) {
            builder.addImport(s);
        }
        for (Template template : this.templates) {
            builder.addTemplate(template.getName(), template.getBody());
        }
        return new StreamSource(new ByteArrayInputStream(builder.getXslString().getBytes()), this.rootDir);
    }

    public void addImport(String href) {
        this.importXslList.add(href);
    }

    public void addTemplate(Template template) {
        this.templates.add(template);
    }

    public void setTemplates(List<Template> templates) {
        this.templates = templates;
    }

    public Properties getOutputProperties() {
        return this.outputProperties;
    }

    public List<Param> getParameters() {
        return this.parameters;
    }

    public void apply(DocbookFile docbook, ResultFile result) {
        DocbookTransformer transformer = new DocbookTransformer(this.getSource());
        for (Map.Entry<Object, Object> entry : this.outputProperties.entrySet()) {
            transformer.setOutputProperty((String)entry.getKey(), (String)entry.getValue());
        }
        for (Param param : this.parameters) {
            transformer.setParameter(param.getName(), param.getValue());
        }
        transformer.transform(docbook, result);
    }

    public String getResultFileExtension() {
        return this.resultFileExtension;
    }

    public void setResultFileExtension(String resultFileExtension) {
        this.resultFileExtension = resultFileExtension;
    }

    public void setOutputProperties(Properties outputProperties) {
        this.outputProperties = outputProperties;
    }

    public void setParameters(List<Param> parameters) {
        this.parameters = parameters;
    }
}

