/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.edocbook.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.edocbook.core.Template;
import jp.sourceforge.edocbook.ui.preferences.dialog.TemplateEditDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class HtmlTemplatePreferencePageComposite
extends Composite {
    private List<Template> templates;
    private Group templateGroup = null;
    private Table templateTable = null;
    private Composite templateButtonComposite = null;
    private Button temlpateAddButton = null;
    private Button templateEditButton = null;
    private Button templateDeleteButton = null;
    private Text templateTextArea = null;

    public HtmlTemplatePreferencePageComposite(Composite parent, int style, List<Template> templates) {
        super(parent, style);
        this.templates = templates;
        this.initialize();
    }

    private void initialize() {
        this.createTemplateGroup();
        this.setLayout((Layout)new GridLayout());
        this.setSize(new Point(399, 369));
        this.setLayout((Layout)new GridLayout());
        this.updateTemplateTable();
    }

    private void updateTemplateTable() {
        this.templateTable.removeAll();
        for (Template template : this.templates) {
            TableItem item = new TableItem(this.templateTable, 0);
            item.setText(0, template.getName());
        }
    }

    private void createTemplateGroup() {
        GridData gridData5 = new GridData();
        gridData5.grabExcessHorizontalSpace = true;
        gridData5.verticalAlignment = 4;
        gridData5.grabExcessVerticalSpace = true;
        gridData5.horizontalAlignment = 4;
        GridData gridData4 = new GridData();
        gridData4.horizontalAlignment = 4;
        gridData4.heightHint = -1;
        gridData4.grabExcessHorizontalSpace = true;
        gridData4.grabExcessVerticalSpace = true;
        gridData4.verticalAlignment = 4;
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.heightHint = -1;
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.grabExcessVerticalSpace = false;
        gridData3.verticalAlignment = 4;
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 2;
        this.templateGroup = new Group((Composite)this, 0);
        this.templateGroup.setText("xsl:template");
        this.templateGroup.setLayoutData((Object)gridData5);
        this.templateGroup.setLayout((Layout)gridLayout1);
        this.templateTable = new Table((Composite)this.templateGroup, 2);
        this.templateTable.setHeaderVisible(true);
        this.templateTable.setLayoutData((Object)gridData3);
        this.templateTable.setLinesVisible(true);
        this.templateTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = HtmlTemplatePreferencePageComposite.this.templateTable.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                HtmlTemplatePreferencePageComposite.this.templateTextArea.setText(((Template)HtmlTemplatePreferencePageComposite.this.templates.get(index)).getBody());
            }
        });
        this.createTemplateButtonComposite();
        this.templateTextArea = new Text((Composite)this.templateGroup, 2634);
        this.templateTextArea.setLayoutData((Object)gridData4);
        TableColumn tableColumn2 = new TableColumn(this.templateTable, 0);
        tableColumn2.setWidth(200);
        tableColumn2.setText("template name");
    }

    private void createTemplateButtonComposite() {
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.verticalAlignment = 4;
        RowLayout rowLayout1 = new RowLayout();
        rowLayout1.justify = false;
        rowLayout1.type = 512;
        rowLayout1.pack = false;
        rowLayout1.spacing = 5;
        rowLayout1.wrap = false;
        rowLayout1.fill = false;
        this.templateButtonComposite = new Composite((Composite)this.templateGroup, 0);
        this.templateButtonComposite.setLayout((Layout)rowLayout1);
        this.templateButtonComposite.setLayoutData((Object)gridData2);
        this.temlpateAddButton = new Button(this.templateButtonComposite, 0);
        this.temlpateAddButton.setText("Add");
        this.temlpateAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateEditDialog dialog = new TemplateEditDialog(HtmlTemplatePreferencePageComposite.this.getShell());
                if (dialog.open() == 0) {
                    HtmlTemplatePreferencePageComposite.this.templates.add(dialog.getEditModel());
                    HtmlTemplatePreferencePageComposite.this.updateTemplateTable();
                    int index = HtmlTemplatePreferencePageComposite.this.templates.size() - 1;
                    HtmlTemplatePreferencePageComposite.this.templateTable.select(index);
                    HtmlTemplatePreferencePageComposite.this.templateTextArea.setText(((Template)HtmlTemplatePreferencePageComposite.this.templates.get(index)).getBody());
                }
            }
        });
        this.templateEditButton = new Button(this.templateButtonComposite, 0);
        this.templateEditButton.setText("Edit");
        this.templateEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = HtmlTemplatePreferencePageComposite.this.templateTable.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                TemplateEditDialog dialog = new TemplateEditDialog(HtmlTemplatePreferencePageComposite.this.getShell(), (Template)HtmlTemplatePreferencePageComposite.this.templates.get(index));
                if (dialog.open() == 0) {
                    Template template = dialog.getEditModel();
                    HtmlTemplatePreferencePageComposite.this.templates.remove(index);
                    HtmlTemplatePreferencePageComposite.this.templates.add(template);
                    HtmlTemplatePreferencePageComposite.this.updateTemplateTable();
                    HtmlTemplatePreferencePageComposite.this.templateTable.select(index);
                    HtmlTemplatePreferencePageComposite.this.templateTextArea.setText(((Template)HtmlTemplatePreferencePageComposite.this.templates.get(index)).getBody());
                }
            }
        });
        this.templateDeleteButton = new Button(this.templateButtonComposite, 0);
        this.templateDeleteButton.setText("Delete");
        this.templateDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] indices = HtmlTemplatePreferencePageComposite.this.templateTable.getSelectionIndices();
                if (indices.length == 0) {
                    return;
                }
                int lastIndex = 0;
                ArrayList<Template> removedList = new ArrayList<Template>();
                int[] nArray = indices;
                int n = indices.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    removedList.add((Template)HtmlTemplatePreferencePageComposite.this.templates.get(i));
                    lastIndex = i;
                    ++n2;
                }
                for (Template t : removedList) {
                    HtmlTemplatePreferencePageComposite.this.templates.remove(t);
                }
                HtmlTemplatePreferencePageComposite.this.updateTemplateTable();
                if (lastIndex >= HtmlTemplatePreferencePageComposite.this.templates.size()) {
                    lastIndex = HtmlTemplatePreferencePageComposite.this.templates.size() - 1;
                }
                HtmlTemplatePreferencePageComposite.this.templateTable.select(lastIndex);
                HtmlTemplatePreferencePageComposite.this.templateTextArea.setText(((Template)HtmlTemplatePreferencePageComposite.this.templates.get(lastIndex)).getBody());
            }
        });
    }

    public List<Template> getTemplates() {
        return this.templates;
    }
}

