/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.edocbook.ui.preferences.dialog;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import jp.sourceforge.edocbook.core.Param;
import jp.sourceforge.edocbook.ui.preferences.dialog.ParameterEditComposite;
import jp.sourceforge.edocbook.ui.preferences.dialog.ParameterEditModel;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ParameterEditDialog
extends Dialog {
    private ParameterEditComposite composite;
    private ParameterEditModel model = new ParameterEditModel();
    private ParameterChangeListener listener;

    public ParameterEditDialog(Shell parentShell) {
        this(parentShell, null);
    }

    public ParameterEditDialog(Shell parentShell, Param model) {
        super(parentShell);
        if (model != null) {
            this.model.setName(model.getName());
            this.model.setValue(model.getValue());
        }
        this.listener = new ParameterChangeListener();
        this.model.addPropertyChangeListener(this.listener);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Edit xsl:parameter");
        this.composite = new ParameterEditComposite(parent, 0, this.model);
        return this.composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button okButton = this.getButton(0);
        okButton.setEnabled(this.model.getName().length() != 0);
    }

    public boolean close() {
        this.model.removePropertyChangeListener(this.listener);
        return super.close();
    }

    public Param getEditModel() {
        return new Param(this.model.getName(), this.model.getValue());
    }

    private class ParameterChangeListener
    implements PropertyChangeListener {
        private ParameterChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Button okButton = ParameterEditDialog.this.getButton(0);
            okButton.setEnabled(((ParameterEditModel)e.getSource()).getName().length() != 0);
        }
    }
}

