package elazyrest.core.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 
 * @author kaz
 *
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.PARAMETER)
public @interface RestParam {
	String name();
	String[] suffix() default "";
	String description() default "";
	boolean required() default false;
	boolean binary() default false;
	String pattern() default "";
	int maxLength() default -1;
	int minLength() default -1;
	String def() default "";
}
