package elazyrest.core.aspect;

import java.io.IOException;
import java.lang.annotation.Annotation;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 
 * @author kaz
 *
 */
public abstract class AspectBase {
	protected abstract void beforeService(HttpServletRequest req, HttpServletResponse res, AspectChain chain, Annotation methodAnnotation) throws IOException;
	protected abstract void afterService(HttpServletRequest req, HttpServletResponse res, AspectChain chain, Annotation methodAnnotation) throws IOException;
	protected abstract void onException(HttpServletRequest req, HttpServletResponse res, AspectChain chain, Annotation methodAnnotation, Exception e) throws IOException;

	public void doAdvice(HttpServletRequest req, HttpServletResponse res, AspectChain chain, Annotation methodAnnotation) throws IOException{
		try {
			beforeService(req, res, chain, methodAnnotation);
			chain.doAdvice();
			afterService(req, res, chain, methodAnnotation);
		}
		catch (RuntimeException e) {
			onException(req, res, chain, methodAnnotation, e);
			throw e;
		}
		catch (IOException e) {
			onException(req, res, chain, methodAnnotation, e);
			throw e;
		}
		catch (Exception e) {
			onException(req, res, chain, methodAnnotation, e);
			throw new RuntimeException(e);
		}
	}
}
