package elazyrest.core.provider;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * 
 * @author kaz
 *
 */
public class SingletonProvider {
	private static SingletonProvider _instance = new SingletonProvider();
	
	private static Log log = LogFactory.getLog(SingletonProvider.class);

	protected Map<Class<?>, Object> instances = new HashMap<Class<?>, Object>();
	
	public static Object get(Class<?> cl) {
		return _instance.getInstance(cl);
	}

	public static boolean contains(Class<?> cl) {
		return _instance.instances.containsKey(cl);
	}

	public static void set(Class<?> cl, Object instance) {
		synchronized (_instance.instances) {
			_instance.instances.put(cl, instance);
		}
	}
	

	public Object getInstance(Class<?> cl) {
		Object targetInstance = null;
		try {
			synchronized (instances) {
				// CX^X݂ΕԂ
				if (instances.containsKey(cl)) {
					targetInstance = instances.get(cl);
				}
				// ŏ̃ANZXɃCX^X𐶐
				else {
					targetInstance = cl.newInstance();
					instances.put(cl, targetInstance);
				}
			}
			return targetInstance;
		}
		catch (InstantiationException e) {
			log.error(e.getMessage(), e);
			//e.printStackTrace();
			throw new RuntimeException(e);
		}
		catch (IllegalAccessException e) {
			log.error(e.getMessage(), e);
			//e.printStackTrace();
			throw new RuntimeException(e);
		}
	}
	
	public static void clear() {
		synchronized (_instance.instances) {
			_instance.instances.clear();
		}
	}
}
