/*
 * Decompiled with CFR 0.152.
 */
package elazyrest.ext.hibernate;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.AnnotationConfiguration;

public class HibernateUtil {
    private static final SessionFactory sessionFactory;
    private static Log log;
    private static final ThreadLocal<Session> session;
    private static final ThreadLocal<List<Transaction>> transactionList;

    static {
        log = LogFactory.getLog(HibernateUtil.class);
        try {
            sessionFactory = new AnnotationConfiguration().configure().buildSessionFactory();
        }
        catch (HibernateException ex) {
            log.error((Object)("Configuration problem: " + ex.getMessage()));
            throw new RuntimeException("Configuration problem: " + ex.getMessage(), ex);
        }
        catch (Exception ex) {
            log.error((Object)("Configuration problem: " + ex.getMessage()));
            throw new RuntimeException("Configuration problem: " + ex.getMessage(), ex);
        }
        session = new ThreadLocal();
        transactionList = new ThreadLocal();
    }

    private HibernateUtil() {
    }

    public static Session currentSession() throws HibernateException {
        Session s = session.get();
        if (s == null) {
            s = sessionFactory.openSession();
            session.set(s);
            log.debug((Object)"open hibernate session");
        }
        if (!s.isOpen()) {
            s = sessionFactory.openSession();
            session.set(s);
            log.debug((Object)"open hibernate session");
        }
        return s;
    }

    public static Transaction beginTransaction() throws HibernateException {
        Session s = HibernateUtil.currentSession();
        List<Transaction> transactions = transactionList.get();
        if (transactions == null) {
            transactions = new ArrayList<Transaction>();
        }
        Transaction trans = s.beginTransaction();
        transactions.add(trans);
        transactionList.set(transactions);
        log.debug((Object)"begin transaction");
        return trans;
    }

    public static Transaction lastTransaction() throws HibernateException {
        List<Transaction> transactions = transactionList.get();
        if (transactions == null) {
            return null;
        }
        return transactions.get(transactions.size() - 1);
    }

    public static void rollback() throws HibernateException {
        List<Transaction> transactions = transactionList.get();
        if (transactions != null) {
            for (Transaction trans : transactions) {
                if (!trans.isActive() || trans.wasCommitted() || trans.wasRolledBack()) continue;
                trans.rollback();
                log.debug((Object)"transaction rollback");
            }
            transactionList.set(null);
        }
    }

    public static void closeSession() throws HibernateException {
        try {
            HibernateUtil.rollback();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        Session s = session.get();
        if (s != null) {
            try {
                if (s.isOpen()) {
                    s.close();
                    log.debug((Object)"close session");
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        session.set(null);
    }
}

