/*
 * Decompiled with CFR 0.152.
 */
package elazyrest.core.provider;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonProvider {
    private static SingletonProvider _instance = new SingletonProvider();
    private static Log log = LogFactory.getLog(SingletonProvider.class);
    protected Map<Class<?>, Object> instances = new HashMap();

    public static Object get(Class<?> cl) {
        return _instance.getInstance(cl);
    }

    public static boolean contains(Class<?> cl) {
        return SingletonProvider._instance.instances.containsKey(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set(Class<?> cl, Object instance) {
        Map<Class<?>, Object> map = SingletonProvider._instance.instances;
        synchronized (map) {
            SingletonProvider._instance.instances.put(cl, instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getInstance(Class<?> cl) {
        Object targetInstance = null;
        try {
            Map<Class<?>, Object> map = this.instances;
            synchronized (map) {
                if (this.instances.containsKey(cl)) {
                    targetInstance = this.instances.get(cl);
                } else {
                    targetInstance = cl.newInstance();
                    this.instances.put(cl, targetInstance);
                }
            }
            return targetInstance;
        }
        catch (InstantiationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<Class<?>, Object> map = SingletonProvider._instance.instances;
        synchronized (map) {
            SingletonProvider._instance.instances.clear();
        }
    }
}

