/*
 * Decompiled with CFR 0.152.
 */
package elazyrest.core.provider;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadLocalProvider {
    private static ThreadLocalProvider _instance = new ThreadLocalProvider();
    private static Log log = LogFactory.getLog(ThreadLocalProvider.class);
    private Map<Class<?>, ThreadLocal> instances = new HashMap();

    public static Object get(Class<?> cl) {
        return _instance.getInstance(cl);
    }

    public static boolean contains(Class<?> cl) {
        ThreadLocal local;
        Object obj;
        return ThreadLocalProvider._instance.instances.containsKey(cl) && (obj = (local = ThreadLocalProvider._instance.instances.get(cl)).get()) != null;
    }

    public static void set(Class cl, Object instance) {
        _instance.setInstance(cl, instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInstance(Class cl, Object instance) {
        Map<Class<?>, ThreadLocal> map = this.instances;
        synchronized (map) {
            ThreadLocal tLocal = this.instances.containsKey(cl) ? this.instances.get(cl) : new ThreadLocal();
            tLocal.set(instance);
            this.instances.put(cl, tLocal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getInstance(Class<?> cl) {
        try {
            Object instance = null;
            Map<Class<?>, ThreadLocal> map = this.instances;
            synchronized (map) {
                ThreadLocal tLocal;
                if (!this.instances.containsKey(cl)) {
                    tLocal = new ThreadLocal();
                    this.instances.put(cl, tLocal);
                } else {
                    tLocal = this.instances.get(cl);
                    instance = tLocal.get();
                }
                if (instance == null) {
                    instance = cl.newInstance();
                }
                tLocal.set(instance);
            }
            return instance;
        }
        catch (InstantiationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<Class<?>, ThreadLocal> map = ThreadLocalProvider._instance.instances;
        synchronized (map) {
            ThreadLocalProvider._instance.instances.clear();
        }
    }
}

