/*
 * Decompiled with CFR 0.152.
 */
package elazyrest.core.util;

import elazyrest.core.util.AppContext;
import elazyrest.core.validator.RestParamError;
import elazyrest.core.validator.RestParamErrors;
import elazyrest.core.xml.response.ObjectFactory;
import elazyrest.core.xml.response.Response;
import java.util.List;
import java.util.Map;

public class ResponseGen {
    public static final int SUCCESS = 0;
    public static final int INVALID_PARAMETER = 1;
    public static final int INTERNAL_SERVER_ERROR = 2;
    public static final int DATA_EMPTY = 3;
    public static final int AUTHORIZATION_REQUIRED = 4;
    public static final int AUTHENTICATION_ERROR = 5;
    public static final int DUPLICATION = 6;
    public static final int FORBIDDEN = 7;
    public static final int NOT_SUPPORTED_METHOD = 8;
    public static final int NOT_SUPPORTED_OPERATION = 9;

    public static Response generateXML(int status, String message) {
        return ResponseGen.generateXML(status, message, null);
    }

    public static byte[] generateBinary(byte[] bytes, String contentType) {
        AppContext appContext = AppContext.getContext();
        appContext.setIsBinary(true);
        appContext.setContentType(contentType);
        return bytes;
    }

    public static Response generateXML(int status, String message, String guid) {
        ObjectFactory of = new ObjectFactory();
        Response res = of.createResponse();
        res.setStatus(new Integer(status));
        res.setMessage(message);
        res.setGuid(guid);
        return res;
    }

    public static Response generateXML(int status, String message, String guid, RestParamErrors errors) {
        ObjectFactory of = new ObjectFactory();
        Response res = of.createResponse();
        res.setStatus(new Integer(status));
        res.setMessage(message);
        res.setGuid(guid);
        Response.ValidateErrors validateErrors = new Response.ValidateErrors();
        List<Response.ValidateErrors.ValidateError> errorList = validateErrors.getValidateError();
        Map<String, RestParamError> errorMap = errors.getErrors();
        for (String key : errorMap.keySet()) {
            RestParamError error = errorMap.get(key);
            Response.ValidateErrors.ValidateError validateError = new Response.ValidateErrors.ValidateError();
            validateError.setKey(key);
            validateError.setError(error.getResourceKey());
            errorList.add(validateError);
        }
        res.setValidateErrors(validateErrors);
        return res;
    }

    public static void setResponseEncoding(String enc) {
        AppContext context = AppContext.getContext();
        if (enc != null) {
            context.setResponseEncoding(enc);
        }
    }
}

