/*
 * Decompiled with CFR 0.152.
 */
package elazyrest.core.validator;

import elazyrest.i18n.MessageResourceBundle;
import elazyrest.i18n.ResourceBundleEx;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class RestParamError {
    private String key = null;
    private String keyDescription = null;
    private List<String> params = new ArrayList<String>();
    private String resourceKey;
    private static MessageResourceBundle messageResource = new MessageResourceBundle(ResourceBundleEx.getBundle((String)"resources/validator_resource"));
    private static MessageResourceBundle paramResource;

    static {
        try {
            paramResource = new MessageResourceBundle(ResourceBundleEx.getBundle((String)"resources/param_resource"));
        }
        catch (Exception x) {
            paramResource = null;
        }
    }

    public RestParamError(String key, String keyDescription, String resourceKey) {
        this.key = key;
        this.keyDescription = keyDescription;
        this.resourceKey = resourceKey;
        if (keyDescription != null && keyDescription.length() > 0) {
            this.params.add(keyDescription);
        } else if (paramResource != null) {
            String newKeyDescription = paramResource.getString(key);
            this.params.add(newKeyDescription != null ? newKeyDescription : key);
        } else {
            this.params.add(key);
        }
    }

    public RestParamError(String key, String keyDescription, String resourceKey, String[] params) {
        this.key = key;
        this.keyDescription = keyDescription;
        this.resourceKey = resourceKey;
        if (keyDescription != null && keyDescription.length() > 0) {
            this.params.add(keyDescription);
        } else if (paramResource != null) {
            String newKeyDescription = paramResource.getString(key);
            this.params.add(newKeyDescription != null ? newKeyDescription : key);
        } else {
            this.params.add(key);
        }
        if (params != null) {
            this.params.addAll((Collection<String>)Arrays.asList(params));
        }
    }

    public void addParams(String val) {
        this.params.add(val);
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyDescription() {
        return this.keyDescription;
    }

    public String[] getParams() {
        if (this.params.isEmpty()) {
            return null;
        }
        String[] paramArray = new String[this.params.size()];
        return this.params.toArray(paramArray);
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    public String getMessage() {
        return messageResource.getString(this.resourceKey, (Object[])this.getParams());
    }
}

