package elazyrest.twitter.auth;

import java.net.Authenticator;
import java.net.PasswordAuthentication;

public class BasicAuthenticator extends Authenticator {

	private String username;
    private String password;

    public BasicAuthenticator(String username, String password){
        this.username = username;
        this.password = password;
    }

    protected PasswordAuthentication getPasswordAuthentication(){
        return new
            PasswordAuthentication(username, password.toCharArray());
    }

	public String getPassword() {
		return password;
	}

	public String getUsername() {
		return username;
	}

	public String getCredential() {
		String userpass = username + ":" + password;
		sun.misc.BASE64Encoder enc = new sun.misc.BASE64Encoder();
		String credential = "Basic "+enc.encode(userpass.getBytes()); 
		return credential;
	}
}
