/*
 * Decompiled with CFR 0.152.
 */
package generator;

import elazyrest.core.annotation.RestMethod;
import elazyrest.core.annotation.RestParam;
import elazyrest.core.annotation.SimpleXml;
import elazyrest.i18n.MessageResourceBundle;
import elazyrest.i18n.ResourceBundleEx;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;

public class DocGen {
    private String packageName = "elazyrest.service";
    private String docRoot = "gen/sample/";
    private String endPoint = "http://localhost:8080/elazyrest";
    private static String lineSep = System.getProperty("line.separator");
    private static MessageResourceBundle paramResource;
    private StringBuffer indexHTML = null;

    static {
        try {
            paramResource = new MessageResourceBundle(ResourceBundleEx.getBundle((String)"resources/param_resource"));
        }
        catch (Exception x) {
            paramResource = null;
        }
    }

    public DocGen() {
    }

    public DocGen(String packageName, String docRoot, String endPoint) {
        this.packageName = packageName;
        if (docRoot != null && !docRoot.endsWith("/")) {
            docRoot = String.valueOf(docRoot) + "/";
        }
        this.docRoot = docRoot;
        this.endPoint = endPoint;
    }

    public static void main(String[] args) {
        Object packageName = null;
        Object docRoot = null;
        DocGen self = new DocGen();
        try {
            self.generate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void generate() {
        this.indexHTML = new StringBuffer("<html>" + lineSep + "<body>" + lineSep);
        this.indexHTML.append("<h1>API \u30c9\u30ad\u30e5\u30e1\u30f3\u30c8</h1>" + lineSep);
        this.indexHTML.append("<h2>\u30b5\u30fc\u30d3\u30b9\u4e00\u89a7</h2>" + lineSep);
        try {
            URL serviceRoot;
            File smartyRoot;
            File phpRoot;
            File formRoot;
            File root = new File(this.docRoot);
            if (!root.exists()) {
                root.mkdir();
            }
            if (!(formRoot = new File(String.valueOf(this.docRoot) + "form")).exists()) {
                formRoot.mkdir();
            }
            if (!(phpRoot = new File(String.valueOf(this.docRoot) + "php")).exists()) {
                phpRoot.mkdir();
            }
            if (!(smartyRoot = new File(String.valueOf(this.docRoot) + "smarty")).exists()) {
                smartyRoot.mkdir();
            }
            if ((serviceRoot = this.getClass().getClassLoader().getResource(this.packageName.replace('.', '/'))) != null) {
                File dir = new File(serviceRoot.getPath());
                this.generate(dir, this.packageName);
            }
        }
        finally {
            try {
                this.indexHTML.append("</body>" + lineSep + "</html>");
                String string = String.valueOf(this.docRoot) + "index.html";
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
                printWriter.write(this.indexHTML.toString());
                printWriter.flush();
                printWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    private void generate(File file, String parentPackage) {
        String filename = file.getName();
        if (file.isDirectory()) {
            File[] flist = file.listFiles();
            String packname = null;
            if (file.getName().equals("classes") || parentPackage != null && parentPackage.endsWith(file.getName())) {
                packname = parentPackage;
            } else {
                String string = packname = parentPackage.length() > 0 ? String.valueOf(parentPackage) + "." + file.getName() : file.getName();
            }
            if (flist != null && flist.length > 0) {
                File[] fileArray = flist;
                int n = 0;
                int n2 = fileArray.length;
                while (n < n2) {
                    File childFile = fileArray[n];
                    this.generate(childFile, packname);
                    ++n;
                }
            }
        }
        if (!file.getName().endsWith(".class")) {
            return;
        }
        String clname = null;
        clname = parentPackage != null && parentPackage.length() > 0 ? String.valueOf(parentPackage) + "." + filename.substring(0, filename.lastIndexOf(46)) : filename.substring(0, filename.lastIndexOf(46));
        this.genClDoc(clname.replace('/', '.'));
    }

    private void genClDoc(String clName) {
        try {
            Method[] methods;
            Class<?> cl = Class.forName(clName);
            String clFileName = cl.getName().substring(cl.getName().lastIndexOf(46) + 1);
            if (!cl.isAnnotationPresent(SimpleXml.class)) {
                return;
            }
            this.indexHTML.append("<a href=\"" + clFileName + ".html\">" + clFileName + "</a><br>" + lineSep);
            StringBuffer classDoc = new StringBuffer("<html>" + lineSep + "<body>" + lineSep);
            classDoc.append("<h1>" + clFileName + "</h1>" + lineSep);
            Method[] methodArray = methods = cl.getMethods();
            int n = 0;
            int n2 = methodArray.length;
            while (n < n2) {
                Method targetMethod = methodArray[n];
                if (targetMethod.isAnnotationPresent(RestMethod.class)) {
                    this.genMethDoc(clFileName, targetMethod);
                    this.genMethForm(clFileName, targetMethod);
                    this.genPHP(clFileName, targetMethod);
                    this.genSmarty(clFileName, targetMethod);
                    classDoc.append("<a href=\"" + clFileName + "." + targetMethod.getName() + ".html\">" + clFileName + "." + targetMethod.getName() + "</a>" + "<br>" + lineSep);
                }
                ++n;
            }
            classDoc.append("</body>" + lineSep + "</html>");
            String classDocName = String.valueOf(this.docRoot) + clFileName + ".html";
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(classDocName)));
            pw.write(classDoc.toString());
            pw.flush();
            pw.close();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void genMethDoc(String clName, Method method) {
        String[] allowMethods = method.getAnnotation(RestMethod.class).value();
        StringBuffer methodDoc = new StringBuffer("<html>" + lineSep + "<body>");
        methodDoc.append("<h1>" + clName + "." + method.getName() + "</h1>" + lineSep);
        methodDoc.append("<h2>\u30a8\u30f3\u30c9\u30dd\u30a4\u30f3\u30c8</h2>" + lineSep);
        methodDoc.append(String.valueOf(this.endPoint) + "<br>" + lineSep);
        methodDoc.append("<h2>\u30d1\u30e9\u30e1\u30fc\u30bf</h2>" + lineSep);
        methodDoc.append("<strong>method</strong>: " + clName + "." + method.getName() + "<br>" + lineSep);
        Annotation[][] paramAnnotation = method.getParameterAnnotations();
        int i = 0;
        while (i < paramAnnotation.length) {
            int j = 0;
            while (j < paramAnnotation[i].length) {
                if (paramAnnotation[i][j].annotationType() == RestParam.class) {
                    String description;
                    String key;
                    RestParam restParam = (RestParam)paramAnnotation[i][j];
                    String keyDescription = key = restParam.name();
                    if (paramResource != null && (description = paramResource.getString(String.valueOf(clName) + "." + method.getName() + "." + key)) != null && description.length() > 0) {
                        keyDescription = description;
                    }
                    methodDoc.append("<strong>" + key + "</strong>: " + keyDescription + "<br>" + lineSep);
                }
                ++j;
            }
            ++i;
        }
        methodDoc.append("</body>" + lineSep + "</html>");
        methodDoc.append("<h2>\u30b5\u30f3\u30d7\u30eb</h2>" + lineSep);
        methodDoc.append("<a href=\"form/" + clName + "." + method.getName() + ".html" + "\">html</a><br>" + lineSep);
        methodDoc.append("<a href=\"php/" + clName + "." + method.getName() + ".php.txt" + "\">php</a><br>" + lineSep);
        methodDoc.append("smarty(<a href=\"smarty/" + clName + "." + method.getName() + ".php.txt" + "\">php</a>" + lineSep);
        methodDoc.append("<a href=\"smarty/" + clName + "." + method.getName() + ".tpl.txt" + "\">template</a>)" + lineSep);
        methodDoc.append("<h2>\u30ec\u30b9\u30dd\u30f3\u30b9\u4f8b</h2>" + lineSep);
        methodDoc.append("</body></html>");
        methodDoc.append("<h2>\u30a8\u30e9\u30fc \u30b3\u30fc\u30c9</h2>" + lineSep);
        String methodFileName = String.valueOf(this.docRoot) + clName + "." + method.getName() + ".html";
        try {
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(methodFileName)));
            pw.write(methodDoc.toString());
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void genMethForm(String clName, Method method) {
        String[] allowMethods = method.getAnnotation(RestMethod.class).value();
        StringBuffer methodDoc = new StringBuffer("");
        methodDoc.append("<h1>" + clName + "." + method.getName() + "</h1>" + lineSep);
        methodDoc.append("<form action=\"" + this.endPoint + "\" method=\"" + allowMethods[0].toLowerCase() + "\" target=\"_result\">" + lineSep);
        methodDoc.append("<input type=\"hidden\" name=\"method\" value=\"" + clName + "." + method.getName() + "\"/>" + lineSep);
        Annotation[][] paramAnnotation = method.getParameterAnnotations();
        int i = 0;
        while (i < paramAnnotation.length) {
            int j = 0;
            while (j < paramAnnotation[i].length) {
                if (paramAnnotation[i][j].annotationType() == RestParam.class) {
                    String description;
                    String key;
                    RestParam restParam = (RestParam)paramAnnotation[i][j];
                    String keyDescription = key = restParam.name();
                    if (paramResource != null && (description = paramResource.getString(String.valueOf(clName) + "." + method.getName() + "." + key)) != null && description.length() > 0) {
                        keyDescription = description;
                    }
                    methodDoc.append(String.valueOf(keyDescription) + ":<input type=\"text\" name=\"" + key + "\" value=\"\"/><br>" + lineSep);
                }
                ++j;
            }
            ++i;
        }
        methodDoc.append("<input type=\"submit\" name=\"submit\"/>" + lineSep);
        methodDoc.append("</form>" + lineSep);
        StringBuffer htmlText = new StringBuffer("<html>" + lineSep + "<body>");
        htmlText.append(methodDoc + lineSep);
        htmlText.append("<plainText>" + methodDoc + "</plainText>");
        htmlText.append("</body>" + lineSep + "</html>");
        String methodFileName = String.valueOf(this.docRoot) + "form/" + clName + "." + method.getName() + ".html";
        try {
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(methodFileName)));
            pw.write(htmlText.toString());
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void genPHP(String clName, Method method) {
        String[] allowMethods = method.getAnnotation(RestMethod.class).value();
        StringBuffer phpDoc = new StringBuffer();
        phpDoc.append("<h1>" + clName + "." + method.getName() + "</h1>" + lineSep);
        phpDoc.append("<form action=\"\" method=\"" + allowMethods[0].toLowerCase() + "\">" + lineSep);
        StringBuffer phpFile = new StringBuffer();
        StringBuffer phpReqStr = new StringBuffer("if ($isSubmit) {");
        phpReqStr.append(lineSep);
        phpReqStr.append("$submiturl = \"$serverUrl?method=" + clName + "." + method.getName() + "\";" + lineSep);
        phpReqStr.append("$queries = array(" + lineSep);
        phpFile.append("<?php" + lineSep + "require_once('common.php');" + lineSep + lineSep);
        Annotation[][] paramAnnotation = method.getParameterAnnotations();
        int i = 0;
        while (i < paramAnnotation.length) {
            if (i != 0) {
                phpReqStr.append("," + lineSep);
            }
            int j = 0;
            while (j < paramAnnotation[i].length) {
                if (paramAnnotation[i][j].annotationType() == RestParam.class) {
                    String description;
                    String key;
                    RestParam restParam = (RestParam)paramAnnotation[i][j];
                    String keyDescription = key = restParam.name();
                    if (paramResource != null && (description = paramResource.getString(String.valueOf(clName) + "." + method.getName() + "." + key)) != null && description.length() > 0) {
                        keyDescription = description;
                    }
                    phpDoc.append(String.valueOf(keyDescription) + ":<input type=\"text\" name=\"" + key + "\" value=\"<?php echo $" + key + ";?>\"/><br>" + lineSep);
                    phpFile.append("$" + key + " = $_REQUEST['" + key + "'];" + lineSep);
                    phpReqStr.append("'" + key + "'=>" + "$" + key);
                }
                ++j;
            }
            ++i;
        }
        phpDoc.append("</form>" + lineSep);
        phpDoc.append("<input type=\"submit\" name=\"submit\"/>" + lineSep);
        phpDoc.append("</form>" + lineSep);
        phpReqStr.append(");" + lineSep + lineSep);
        phpReqStr.append("$res = simplexml_load_file_with_" + allowMethods[0].toLowerCase() + "($submiturl, $queries, getwsseheader());" + lineSep);
        phpReqStr.append("if ($res->status == 0) {" + lineSep);
        phpReqStr.append("header(\"Location: xxxx\". \"?\".htmlspecialchars( SID ));" + lineSep);
        phpReqStr.append("exit;" + lineSep + "}" + lineSep + "}" + lineSep);
        phpFile.append("$isSubmit = $_REQUEST['submit'];" + lineSep);
        phpFile.append(phpReqStr + lineSep);
        phpFile.append("?>" + lineSep + lineSep + "<html>" + lineSep + "<body>" + phpDoc);
        phpFile.append("</body>" + lineSep + "</html>");
        String phpFileName = String.valueOf(this.docRoot) + "php/" + clName + "." + method.getName() + ".php.txt";
        try {
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(phpFileName)));
            pw.write(phpFile.toString());
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void genSmarty(String clName, Method method) {
        String[] allowMethods = method.getAnnotation(RestMethod.class).value();
        StringBuffer assignStr = new StringBuffer("require_once('setup.php');" + lineSep);
        assignStr.append("$smarty = new Smarty_CGM();" + lineSep);
        StringBuffer templateStr = new StringBuffer("<html>" + lineSep + "<body>" + lineSep);
        templateStr.append("<h1>" + clName + "." + method.getName() + "</h1>" + lineSep);
        templateStr.append("<form action=\"\" method=\"" + allowMethods[0].toLowerCase() + "\">" + lineSep);
        StringBuffer phpFile = new StringBuffer();
        StringBuffer phpReqStr = new StringBuffer("if ($isSubmit) {");
        phpReqStr.append(lineSep);
        phpReqStr.append("$submiturl = \"$serverUrl?method=" + clName + "." + method.getName() + "\";" + lineSep);
        phpReqStr.append("$queries = array(" + lineSep);
        phpFile.append("<?php" + lineSep + "require_once('common.php');" + lineSep + lineSep);
        Annotation[][] paramAnnotation = method.getParameterAnnotations();
        int i = 0;
        while (i < paramAnnotation.length) {
            if (i != 0) {
                phpReqStr.append("," + lineSep);
            }
            int j = 0;
            while (j < paramAnnotation[i].length) {
                if (paramAnnotation[i][j].annotationType() == RestParam.class) {
                    String description;
                    String key;
                    RestParam restParam = (RestParam)paramAnnotation[i][j];
                    String keyDescription = key = restParam.name();
                    if (paramResource != null && (description = paramResource.getString(String.valueOf(clName) + "." + method.getName() + "." + key)) != null && description.length() > 0) {
                        keyDescription = description;
                    }
                    assignStr.append("$smarty->assign('" + key + "', $" + key + ");" + lineSep);
                    templateStr.append(String.valueOf(keyDescription) + ":<input type=\"text\" name=\"" + key + "\" value=\"{{$" + key + "}}\"/><br>" + lineSep);
                    phpFile.append("$" + key + " = $_REQUEST['" + key + "'];" + lineSep);
                    phpReqStr.append("'" + key + "'=>" + "$" + key);
                }
                ++j;
            }
            ++i;
        }
        assignStr.append(String.valueOf(lineSep) + "$smarty->display_ua('XXXXX.tpl');" + lineSep);
        templateStr.append("<input type=\"submit\" name=\"submit\"/>" + lineSep);
        templateStr.append("</form>" + lineSep);
        phpReqStr.append(");" + lineSep + lineSep);
        phpReqStr.append("$res = simplexml_load_file_with_" + allowMethods[0].toLowerCase() + "($submiturl, $queries, getwsseheader());" + lineSep);
        phpReqStr.append("if ($res->status == 0) {" + lineSep);
        phpReqStr.append("header(\"Location: xxxx\". \"?\".htmlspecialchars( SID ));" + lineSep);
        phpReqStr.append("exit;" + lineSep + "}" + lineSep + "}" + lineSep);
        phpFile.append("$isSubmit = $_REQUEST['submit'];" + lineSep);
        phpFile.append(phpReqStr + lineSep);
        phpFile.append(String.valueOf(lineSep) + assignStr + lineSep);
        phpFile.append("?>");
        templateStr.append("</body>" + lineSep + "</html>");
        String phpFileName = String.valueOf(this.docRoot) + "smarty/" + clName + "." + method.getName() + ".php.txt";
        String templateFileName = String.valueOf(this.docRoot) + "smarty/" + clName + "." + method.getName() + ".tpl.txt";
        try {
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(phpFileName)));
            pw.write(phpFile.toString());
            pw.flush();
            pw.close();
            pw = new PrintWriter(new BufferedWriter(new FileWriter(templateFileName)));
            pw.write(templateStr.toString());
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

