using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Drawing;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.GameData.Expression;
using MinorShift.Emuera.GameData.Variable;
using MinorShift._Library;
using MinorShift.Emuera.GameView;
namespace MinorShift.Emuera.GameProc
{
	internal sealed partial class Process
	{

		private void runScriptProc()
		{
			bool sequential = state.Sequential;
			state.ShfitNextLine();
			LogicalLine line = state.CurrentLine;
			vEvaluator.Scope = state.Scope;
			if (line == null)
				throw new ExeEE("Emuera.exe͎Ɏss܂");
			else if (line.IsError)
				throw new CodeEE(line.ErrMes);
			else if (line is NullLine)
			{//t@CI[
				vEvaluator.RESULT = 0;
				state.Return(0);
			}
			else if (line is FunctionLabelLine)
			{
				if (sequential)
				{//ꗎĂi֐I[j
					vEvaluator.RESULT = 0;
					state.Return(0);
				}
				else//CALLJUMPŔł
					return;
			}
			else if (line is GotoLabelLine)
				return;//xB邱Ƃ͂ȂB
			else if (line is InstructionLine)
			{
				InstructionLine func = (InstructionLine)line;
				if (func.Argument == null)
					LogicalLineParser.SetArgumentTo(func, null);
				if (func.IsError)
					throw new CodeEE(func.ErrMes);
				if (BuiltInFunctionManager.IsFlowContorol(func.Function))
					doFlowControlFunction(func, sequential);
				else
					doNormalFunction(func);
			}
			else if (line is InvalidLine)
			{
				if (string.IsNullOrEmpty(line.ErrMes))
					throw new CodeEE("ǍɎsss܂BG[̏ڍׂ͓Ǎ̌xQƂĂB");
				else
					throw new CodeEE(line.ErrMes);
			}
			else
				throw new ExeEE("`ĂȂނ̍sł");
		}

		public void DoDebugNormalFunction(InstructionLine line)
		{
			doNormalFunction(line);
			vEvaluator.IamaMunchkin();
		}

		#region normal
		void doNormalFunction(InstructionLine line)
		{
			if ((line.Function & BuiltInFunctionCode.__ARG_METHOD__) == BuiltInFunctionCode.__ARG_METHOD__)
			{
				FunctionArgument arg = (FunctionArgument)line.Argument;
				Type type = arg.MethodTerm.GetOperandType();
				if (arg.MethodTerm.GetOperandType() == typeof(Int64))
					vEvaluator.RESULT = eEvaluator.GetInteger(arg.MethodTerm);
				else if (arg.MethodTerm.GetOperandType() == typeof(string))
					vEvaluator.RESULTS = eEvaluator.GetString(arg.MethodTerm);
				else
					throw new ExeEE(line.Function.ToString() + "߂̌^s");
				return;
			}
			string str = null;
			IOperandTerm term = null;
			switch (line.Function)
			{
				case BuiltInFunctionCode.SET:
					{
						SpSetArgument spsetarg = (SpSetArgument)line.Argument;
						FixedVariablePointer p = eEvaluator.GetFixedVariable(spsetarg.VariableDest);
						vEvaluator.SetValue(p, eEvaluator.GetInteger(spsetarg.Term));
					}
					break;
				case BuiltInFunctionCode.SETS:
					{
						SpSetsArgument spsetsarg = (SpSetsArgument)line.Argument;
						FixedVariablePointer p = eEvaluator.GetFixedVariable(spsetsarg.VariableDest);
						vEvaluator.SetValue(p, spsetsarg.StrForm.GetString(eEvaluator));
					}
					break;
				case BuiltInFunctionCode.PRINT://\
				case BuiltInFunctionCode.PRINTL://s
				case BuiltInFunctionCode.PRINTW://͑҂(s)
				case BuiltInFunctionCode.PRINTSINGLE://s
					str = ((StrArgument)line.Argument).Str;
					if (line.Function == BuiltInFunctionCode.PRINTSINGLE)
						console.PrintLine(str);
					else
					{
						console.Print(str);
						if (line.Function != BuiltInFunctionCode.PRINT)
							console.NewLine();
						if (line.Function == BuiltInFunctionCode.PRINTW)
							console.ReadAnyKey();
					}
					break;
				case BuiltInFunctionCode.PRINTV://ϐ̓e
				case BuiltInFunctionCode.PRINTVL:
				case BuiltInFunctionCode.PRINTVW:
				case BuiltInFunctionCode.PRINTSINGLEV:
					{
						StringBuilder builder = new StringBuilder();
						foreach (IOperandTerm termV in ((SpPrintVArgument)line.Argument).Terms)
						{
							if (termV.GetOperandType() == typeof(Int64))
								builder.Append(eEvaluator.GetInteger(termV).ToString());
							else
								builder.Append(((SingleTerm)termV).Str);
						}
						str = builder.ToString();

						if (line.Function == BuiltInFunctionCode.PRINTSINGLEV)
							console.PrintLine(str);
						else
						{
							console.Print(str);
							if (line.Function != BuiltInFunctionCode.PRINTV)
								console.NewLine();
							if (line.Function == BuiltInFunctionCode.PRINTVW)
								console.ReadAnyKey();
						}
					}
					break;
				case BuiltInFunctionCode.PRINTS://ϐ̓e
				case BuiltInFunctionCode.PRINTSL:
				case BuiltInFunctionCode.PRINTSW:
				case BuiltInFunctionCode.PRINTSINGLES:
					{
						term = ((ExpressionArgument)line.Argument).Term;
						str = eEvaluator.GetString(term);
						if (line.Function == BuiltInFunctionCode.PRINTSINGLES)
							console.PrintLine(str);
						else
						{
							console.Print(str);
							if (line.Function != BuiltInFunctionCode.PRINTS)
								console.NewLine();
							if (line.Function == BuiltInFunctionCode.PRINTSW)
								console.ReadAnyKey();
						}
					}
					break;

				case BuiltInFunctionCode.PRINTFORM://{}A%ϐ%Ȃǂ̏gB
				case BuiltInFunctionCode.PRINTFORML:
				case BuiltInFunctionCode.PRINTFORMW:
				case BuiltInFunctionCode.PRINTSINGLEFORM:
					{
						StringForm strForm = ((FormStrArgument)line.Argument).StrForm;
						str = strForm.GetString(eEvaluator);
						if (line.Function == BuiltInFunctionCode.PRINTSINGLEFORM)
							console.PrintLine(str);
						else
						{
							console.Print(str);
							if (line.Function != BuiltInFunctionCode.PRINTFORM)
								console.NewLine();
							if (line.Function == BuiltInFunctionCode.PRINTFORMW)
								console.ReadAnyKey();
						}
					}
					break;
				case BuiltInFunctionCode.PRINTFORMS://ϐ̓eϊĕ\܂B
				case BuiltInFunctionCode.PRINTFORMSL:
				case BuiltInFunctionCode.PRINTFORMSW:
				case BuiltInFunctionCode.PRINTSINGLEFORMS:
					{
						term = ((ExpressionArgument)line.Argument).Term;
						str = eEvaluator.GetString(term);
						StringForm strForm = new StringForm(str);
						str = strForm.GetString(eEvaluator);
						if (line.Function == BuiltInFunctionCode.PRINTSINGLEFORMS)
							console.PrintLine(str);
						else
						{
							console.Print(str);
							if (line.Function != BuiltInFunctionCode.PRINTFORMS)
								console.NewLine();
							if (line.Function == BuiltInFunctionCode.PRINTFORMSW)
								console.ReadAnyKey();
						}
					}
					break;
				case BuiltInFunctionCode.PRINTC:
				case BuiltInFunctionCode.PRINTLC:
					{
						if (line.Function == BuiltInFunctionCode.PRINTC)
							console.PrintC(((StrArgument)line.Argument).Str, true);
						else
							console.PrintC(((StrArgument)line.Argument).Str, false);
					}
					break;
				case BuiltInFunctionCode.CLEARLINE:
					{
						ExpressionArgument intExpArg = (ExpressionArgument)line.Argument;
						Int32 delNum = (Int32)eEvaluator.GetInteger(intExpArg.Term);
						console.deleteLine(delNum);
						console.RefreshStrings(false);
					}
					break;
				case BuiltInFunctionCode.REUSELASTLINE:
					{
						StringForm strForm = ((FormStrArgument)line.Argument).StrForm;
						console.PrintTemporaryLine(strForm.GetString(eEvaluator));
					}
					break;
				case BuiltInFunctionCode.WAIT://s҂B
					console.ReadAnyKey();
					break;
				case BuiltInFunctionCode.TWAIT:
					{
						SpSwapCharaArgument arg = (SpSwapCharaArgument)line.Argument;
						Int64 time = eEvaluator.GetInteger(arg.X);
						Int64 flag = eEvaluator.GetInteger(arg.Y);
						console.waitInputWithTimer(time, flag);
						break;
					}
				case BuiltInFunctionCode.INPUT://́B͂RESULTցB
					console.ReadInteger();
					break;
				case BuiltInFunctionCode.INPUTS://́B͂RESULTSցB
					console.ReadString();
					break;
				case BuiltInFunctionCode.TINPUT:
					{
						SpBarArgument arg = (SpBarArgument)line.Argument;
						long x = eEvaluator.GetInteger(arg.Terms[0]);
						long y = eEvaluator.GetInteger(arg.Terms[1]);
						long z = eEvaluator.GetInteger(arg.Terms[2]);
						console.ReadIntegerWithTimer(x, y, z);
					}
					break;
				case BuiltInFunctionCode.TINPUTS:
					{
						SpTInputsArgument arg = (SpTInputsArgument)line.Argument;
						Int64 x = eEvaluator.GetInteger(arg.Time);
						string strs = eEvaluator.GetString(arg.Def);
						Int64 z = eEvaluator.GetInteger(arg.Disp);
						console.ReadStringWithTimer(x, strs, z);
					}
					break;
				case BuiltInFunctionCode.DRAWLINE://ʂ̍[E[܂----ƐB
					console.PrintBar();
					console.NewLine();
					break;
				case BuiltInFunctionCode.CUSTOMDRAWLINE:
					{
						str = ((StrArgument)line.Argument).Str;
						console.ChangeStBar(str);
						console.PrintBar();
						console.NewLine();
						console.ChangeStBar(Config.Instance.DrawLineString);
					}
					break;
				case BuiltInFunctionCode.BAR://[*****....]̂悤ȃOtBBAR (ϐ) , (ől), ()
				case BuiltInFunctionCode.BARL://stB
					{
						SpBarArgument barArg = (SpBarArgument)line.Argument;
						Int64 var = eEvaluator.GetInteger(barArg.Terms[0]);
						Int64 max = eEvaluator.GetInteger(barArg.Terms[1]);
						Int64 length = eEvaluator.GetInteger(barArg.Terms[2]);
						console.Print(createBar(var, max, length));
					}
					if (line.Function == BuiltInFunctionCode.BARL)
						console.NewLine();
					break;
				case BuiltInFunctionCode.TIMES://vZBTIMES (ϐ) , (l)Ƃ`ŎgB
					{
						SpTimesArgument timesArg = (SpTimesArgument)line.Argument;
						VariableToken var = timesArg.VariableDest;
						double d = eEvaluator.GetInteger(var) * timesArg.DoubleValue;
						FixedVariablePointer p = eEvaluator.GetFixedVariable(var);
						unchecked
						{
							vEvaluator.SetValue(p, (Int64)d);
						}
					}
					break;
				case BuiltInFunctionCode.PRINT_ABL://\́B͓o^ԍ
				case BuiltInFunctionCode.PRINT_TALENT://f
				case BuiltInFunctionCode.PRINT_MARK://
				case BuiltInFunctionCode.PRINT_EXP://o
					{
						ExpressionArgument intExpArg = (ExpressionArgument)line.Argument;
						Int64 target = eEvaluator.GetInteger(intExpArg.Term);
						console.Print(vEvaluator.GetCharacterDataString(target, line.Function));
						console.NewLine();
					}
					break;
				case BuiltInFunctionCode.PRINT_PALAM://p[^
					{
						ExpressionArgument intExpArg = (ExpressionArgument)line.Argument;
						Int64 target = eEvaluator.GetInteger(intExpArg.Term);
						int count = 0;
						///100ȍ~͔ے̎ƂȂ̂ŕ\Ȃ
						for (int i = 0; i < 100; i++)
						{
							string printStr = vEvaluator.GetCharacterParamString(target, i);
							if (printStr != null)
							{
								console.PrintC(printStr, true);
								count++;
								if ((Config.Instance.PrintCPerLine > 0) && (count % Config.Instance.PrintCPerLine == 0))
									console.PrintFlush(false);
							}
						}
						console.PrintFlush(false);
					}
					break;
				case BuiltInFunctionCode.PRINT_ITEM://ACe
					console.Print(vEvaluator.GetHavingItemsString());
					console.NewLine();
					break;
				case BuiltInFunctionCode.PRINT_SHOPITEM://VbvŔĂACe
					{
						int length = Math.Min(vEvaluator.ITEMSALES.Length, vEvaluator.ITEMNAME.Length);
						int count = 0;
						for (int i = 0; i < length; i++)
						{
							if (vEvaluator.ItemSales(i))
							{
								string printStr = vEvaluator.ITEMNAME[i];
								if (printStr == null)
									printStr = "";
								Int64 price = vEvaluator.ITEMPRICE[i];
								// 1.52aϕ@iPʂ̍ւёOuAuɑΉj
								if (Config.Instance.MoneyFirst)
									console.PrintC(string.Format("[{2}] {0}({3}{1})", printStr, price, i, Config.Instance.MoneyLabel), false);
								else
									console.PrintC(string.Format("[{2}] {0}({1}{3})", printStr, price, i, Config.Instance.MoneyLabel), false);
								count++;
								if ((Config.Instance.PrintCPerLine > 0) && (count % Config.Instance.PrintCPerLine == 0))
									console.PrintFlush(false);
							}
						}
						console.PrintFlush(false);
					}
					break;
				case BuiltInFunctionCode.UPCHECK://p[^̕ϓ
					vEvaluator.UpdateInUpcheck(console);
					break;
				case BuiltInFunctionCode.ADDCHARA://(Lԍ)̃LN^ǉ
				case BuiltInFunctionCode.ADDSPCHARA://(Lԍ)SPLN^ǉitO01ɂč쐬j
				case BuiltInFunctionCode.DELCHARA://(Lo^ԍ)̃LN^폜B
					{
						ExpressionArgument intExpArg = (ExpressionArgument)line.Argument;
						Int64 integer = eEvaluator.GetInteger(intExpArg.Term);
						if (line.Function == BuiltInFunctionCode.ADDCHARA)
							vEvaluator.AddCharacter(integer, false);
						else if (line.Function == BuiltInFunctionCode.ADDSPCHARA)
							vEvaluator.AddCharacter(integer, true);
						else
							vEvaluator.DelCharacter(integer);
					}
					break;
				case BuiltInFunctionCode.PUTFORM://@SAVEINFO֐ł̂ݎgp\BPRINTFORMƓl̏ŃZ[uf[^ɊTvB
					{
						StringForm formStr = ((FormStrArgument)line.Argument).StrForm;
						if(vEvaluator.SAVEDATA_TEXT != null)
							vEvaluator.SAVEDATA_TEXT += formStr.GetString(eEvaluator);
						else
							vEvaluator.SAVEDATA_TEXT = formStr.GetString(eEvaluator);
						break;
					}
				case BuiltInFunctionCode.QUIT://Q[I
					console.Quit();
					break;


				case BuiltInFunctionCode.STRLEN://RESULTɕioCgj
					str = ((StrArgument)line.Argument).Str;
					this.vEvaluator.RESULT = ShiftJisManager.GetStrlenShiftJis(str);
					break;

				//case BuiltInFunctionCode.STRLENS:
				//    term = ((ExpressionArgument)line.Argument).Term;
				//    this.vEvaluator.RESULT = ShiftJisManager.GetStrlenShiftJis(eEvaluator.GetString(term));
				//    break;

				case BuiltInFunctionCode.STRLENFORM:
					{
						StringForm strForm = ((FormStrArgument)line.Argument).StrForm;
						this.vEvaluator.RESULT = ShiftJisManager.GetStrlenShiftJis(strForm.GetString(eEvaluator));
					}
					break;

				case BuiltInFunctionCode.PRINTFORMC:
				case BuiltInFunctionCode.PRINTFORMLC:
					{
						StringForm strForm = ((FormStrArgument)line.Argument).StrForm;
						if (line.Function == BuiltInFunctionCode.PRINTFORMC)
							console.PrintC(strForm.GetString(eEvaluator), true);
						else
							console.PrintC(strForm.GetString(eEvaluator), false);
					}
					break;
				//case BuiltInFunctionCode.SUBSTRING:
				//    {
				//        SpSubstringArgument arg = (SpSubstringArgument)line.Argument;
				//        str = eEvaluator.GetString(arg.StrExpression);
				//        int start = (int)this.eEvaluator.GetInteger(arg.Start);
				//        int length = (int)this.eEvaluator.GetInteger(arg.Length);
				//        this.vEvaluator.RESULTS = ShiftJisManager.GetSubStringShiftJis(str, start, length);
				//    }
				//    break;
				case BuiltInFunctionCode.SWAPCHARA:
					{
						SpSwapCharaArgument arg = (SpSwapCharaArgument)line.Argument;
						long x = eEvaluator.GetInteger(arg.X);
						long y = eEvaluator.GetInteger(arg.Y);
						vEvaluator.SwapChara(x, y);
					}
					break;
				case BuiltInFunctionCode.SORTCHARA:
					{
						SpSortcharaArgument spSortArg = (SpSortcharaArgument)line.Argument;
						Int64 elem = 0;
						if (spSortArg.SortKey.Element2 != null)
							elem = eEvaluator.GetInteger(spSortArg.SortKey.Element2);
						vEvaluator.SortChara(spSortArg.SortKey.Identifier, elem, spSortArg.SortOrder, true);
					}
					break;
				//case BuiltInFunctionCode.GETCHARA:
				//case BuiltInFunctionCode.GETSPCHARA:
				//    {
				//        ExpressionArgument intExpArg = (ExpressionArgument)line.Argument;
				//        Int64 integer = eEvaluator.GetInteger(intExpArg.Term);
				//        if (line.Function == BuiltInFunctionCode.GETCHARA)
				//            vEvaluator.RESULT = vEvaluator.GetChara(integer, false);
				//        else
				//            vEvaluator.RESULT = vEvaluator.GetChara(integer, true);
				//    }
				//    break;
				//case BuiltInFunctionCode.FINDCHARA:
				//    {
				//        SpFindCharaArgument arg = (SpFindCharaArgument)line.Argument;

				//        Int64 elem = 0;
				//        if (arg.CharaVar.Element2 != null)
				//            elem = eEvaluator.GetInteger(arg.CharaVar.Element2);
				//        VariableIdentifier varID = arg.CharaVar.Identifier;
				//        Int64 startindex = eEvaluator.GetInteger(arg.StartIndex);
				//        Int64 ret = -1;
				//        if (varID.IsString)
				//        {
				//            string word = eEvaluator.GetString(arg.Word);
				//            ret = vEvaluator.FindChara(varID, elem, word, elem);
				//        }
				//        else
				//        {
				//            Int64 word = eEvaluator.GetInteger(arg.Word);
				//            ret = vEvaluator.FindChara(varID, elem, word, elem);
				//        }
				//        vEvaluator.RESULT = ret;
				//    }
				//    break;
				//case BuiltInFunctionCode.CSVNAME:
				//case BuiltInFunctionCode.CSVCALLNAME:
				//    {
				//        SpSwapCharaArgument arg = (SpSwapCharaArgument)line.Argument;
				//        long x = eEvaluator.GetInteger(arg.X);
				//        long y = eEvaluator.GetInteger(arg.Y);
				//        vEvaluator.RESULTS = vEvaluator.GetCharacterNamefromCSVData(x, (line.Function == BuiltInFunctionCode.CSVCALLNAME), (y != 0));
				//    }
				//    break;
				case BuiltInFunctionCode.VARSIZE:
					{
						SpVarsizeArgument versizeArg = (SpVarsizeArgument)line.Argument;
						VariableIdentifier varID = versizeArg.VariableID;
						vEvaluator.VarSize(varID);
					}
					break;
				case BuiltInFunctionCode.SAVEDATA:
					{
						SpSaveDataArgument spSavedataArg = (SpSaveDataArgument)line.Argument;
						Int64 target = eEvaluator.GetInteger(spSavedataArg.Target);
						if (target < 0)
							throw new CodeEE("SAVEDATÄɕ̒l(" + target.ToString() + ")w肳܂");
						else if (target > int.MaxValue)
							throw new CodeEE("SAVEDATÄ(" + target.ToString() + ")傫܂");
						string savemes = eEvaluator.GetString(spSavedataArg.StrExpression);
						saveTo((int)target, savemes);
					}
					break;
				case BuiltInFunctionCode.DELDATA:
					{
						ExpressionArgument intExpArg = (ExpressionArgument)line.Argument;
						Int64 target = eEvaluator.GetInteger(intExpArg.Term);
						if (target < 0)
							throw new CodeEE("DELDATÄɕ̒l(" + target.ToString() + ")w肳܂");
						else if (target > int.MaxValue)
							throw new CodeEE("DELDATÄ(" + target.ToString() + ")傫܂");
						delData((int)target);
					}
					break;
				case BuiltInFunctionCode.CHKDATA:
					{
						ExpressionArgument intExpArg = (ExpressionArgument)line.Argument;
						Int64 target = eEvaluator.GetInteger(intExpArg.Term);
						if (target < 0)
							throw new CodeEE("CHKDATÄɕ̒l(" + target.ToString() + ")w肳܂");
						else if (target > int.MaxValue)
							throw new CodeEE("CHKDATÄ(" + target.ToString() + ")傫܂");
						EraDataResult result = checkData((int)target);
						vEvaluator.RESULT = (long)result.State;
						vEvaluator.RESULTS = result.DataMes;
					}
					break;
				case BuiltInFunctionCode.SAVEGLOBAL:
					saveGlobal();
					break;
				case BuiltInFunctionCode.LOADGLOBAL:
					if (loadGlobal())
						vEvaluator.RESULT = 1;
					else
						vEvaluator.RESULT = 0;
					break;
				case BuiltInFunctionCode.POWER:
					{
						SpPowerArgument powerArg = (SpPowerArgument)line.Argument;
						FixedVariablePointer p = eEvaluator.GetFixedVariable(powerArg.VariableDest);
						double x = eEvaluator.GetInteger(powerArg.X);
						double y = eEvaluator.GetInteger(powerArg.Y);
						double pow = Math.Pow(x, y);
						if (double.IsNaN(pow))
							throw new CodeEE("ݏ挋ʂ񐔒lł");
						else if (double.IsInfinity(pow))
							throw new CodeEE("ݏ挋ʂł");
						else if ((pow >= Int64.MaxValue) || (pow <= Int64.MinValue))
							throw new CodeEE("ݏ挋(" + pow.ToString() + ")64rbgt͈̔͊Oł");
						vEvaluator.SetValue(p, (long)pow);
						break;
					}
				case BuiltInFunctionCode.SWAP:
					{
						SpSwapVarArgument arg = (SpSwapVarArgument)line.Argument;
						FixedVariablePointer p1 = eEvaluator.GetFixedVariable(arg.var1);
						FixedVariablePointer p2 = eEvaluator.GetFixedVariable(arg.var2);
						if (arg.var1.GetOperandType() != arg.var2.GetOperandType())
							throw new CodeEE("ւϐ̌^قȂ܂");
						if (arg.var1.GetOperandType() == typeof(Int64))
						{
							Int64 temp = eEvaluator.GetInteger(arg.var1);
							vEvaluator.SetValue(p1, eEvaluator.GetInteger(arg.var2));
							vEvaluator.SetValue(p2, temp);
						}
						else if (arg.var1.GetOperandType() == typeof(string))
						{
							string temps = eEvaluator.GetString(arg.var1);
							vEvaluator.SetValue(p1, eEvaluator.GetString(arg.var2));
							vEvaluator.SetValue(p2, temps);
						}
						else
						{
							throw new CodeEE("sȕϐ^ł");
						}
						break;
					}
				case BuiltInFunctionCode.GETTIME:
					{
						long date = DateTime.Now.Year;
						date = date * 100 + DateTime.Now.Month;
						date = date * 100 + DateTime.Now.Day;
						date = date * 100 + DateTime.Now.Hour;
						date = date * 100 + DateTime.Now.Minute;
						date = date * 100 + DateTime.Now.Second;
						date = date * 1000 + DateTime.Now.Millisecond;
						vEvaluator.RESULT = date;//17B2炢B
						vEvaluator.RESULTS = DateTime.Now.ToString();
					}
					break;
				case BuiltInFunctionCode.SETCOLOR:
					{
						SpBarArgument barArg = (SpBarArgument)line.Argument;
						Int64 colorR = eEvaluator.GetInteger(barArg.Terms[0]);
						Int64 colorG = eEvaluator.GetInteger(barArg.Terms[1]);
						Int64 colorB = eEvaluator.GetInteger(barArg.Terms[2]);
						if ((colorR < 0) || (colorG < 0) || (colorB < 0))
							throw new CodeEE("SETCOLOR̈0̒lw肳܂"); ;
						if ((colorR > 255) || (colorG > 255) || (colorB > 255))
							throw new CodeEE("SETCOLOR̈255𒴂lw肳܂");
						Color c = Color.FromArgb((Int32)colorR, (Int32)colorG, (Int32)colorB);
						console.SetStringStyle(c);
					}
					break;
				case BuiltInFunctionCode.RESETCOLOR:
					console.SetStringStyle(Config.Instance.ForeColor);
					break;
				case BuiltInFunctionCode.FONTBOLD:
					console.SetStringStyle(console.StringStyle.FontStyle | FontStyle.Bold);
					break;
				case BuiltInFunctionCode.FONTITALIC:
					console.SetStringStyle(console.StringStyle.FontStyle | FontStyle.Italic);
					break;
				case BuiltInFunctionCode.FONTREGULAR:
					console.SetStringStyle(FontStyle.Regular);
					break;
				case BuiltInFunctionCode.FONTSTYLE:
					{
						FontStyle fs = FontStyle.Regular;
						Int64 i = eEvaluator.GetInteger(((ExpressionArgument)line.Argument).Term);
						if ((i & 1) != 0)
							fs |= FontStyle.Bold;
						if ((i & 2) != 0)
							fs |= FontStyle.Italic;
						if ((i & 4) != 0)
							fs |= FontStyle.Strikeout;
						if ((i & 8) != 0)
							fs |= FontStyle.Underline;
						console.SetStringStyle(fs);
					}
					break;
				//case BuiltInFunctionCode.CHKFONT:
				//    {
				//        term = ((ExpressionArgument)line.Argument).Term;
				//        str = eEvaluator.GetString(term);
				//        System.Drawing.Text.InstalledFontCollection ifc = new System.Drawing.Text.InstalledFontCollection();
				//        Int64 isInstalled = 0;
				//        foreach (FontFamily ff in ifc.Families)
				//        {
				//            if (ff.Name == str)
				//            {
				//                isInstalled = 1;
				//                break;
				//            }
				//        }
				//        vEvaluator.RESULT = isInstalled;
				//    }
				//    break;
				case BuiltInFunctionCode.SETFONT:
					term = ((ExpressionArgument)line.Argument).Term;
					console.SetFont(eEvaluator.GetString(term));
					break;
				case BuiltInFunctionCode.ALIGNMENT:
					str = line.ArgumentStr;
					if (Config.Instance.IgnoreCase)
						str = str.ToUpper();
					if (!Enum.IsDefined(typeof(DisplayLineAlignment), str))
						throw new CodeEE("ALIGNMENT̃L[[h\"" + str + "\"͖`ł");
					console.Alignment = (DisplayLineAlignment)Enum.Parse(typeof(DisplayLineAlignment), str);
					break;
				case BuiltInFunctionCode.RESETDATA:
					vEvaluator.ResetData();
					break;
				case BuiltInFunctionCode.RESETGLOBAL:
					vEvaluator.ResetGlobalData();
					break;
				case BuiltInFunctionCode.RANDOMIZE:
					vEvaluator.Randomize(eEvaluator.GetInteger(((ExpressionArgument)line.Argument).Term));
					break;
				case BuiltInFunctionCode.INITRAND:
					vEvaluator.InitRanddata();
					break;
				case BuiltInFunctionCode.DUMPRAND:
					vEvaluator.DumpRanddata();
					break;
				case BuiltInFunctionCode.REDRAW:
					console.SetRedraw(eEvaluator.GetInteger(((ExpressionArgument)line.Argument).Term));
					break;
				//case BuiltInFunctionCode.STRFIND:
				//    {
				//        SpStrFindArgument arg = (SpStrFindArgument)line.Argument;
				//        string target = eEvaluator.GetString(arg.TargetStr);
				//        string word = eEvaluator.GetString(arg.WordStr);
				//        int JISstart = (int)eEvaluator.GetInteger(arg.StartIndex);
				//        int UFTstart = ShiftJisManager.GetUFTIndex(str, JISstart);
				//        if (UFTstart >= target.Length)
				//        {
				//            vEvaluator.RESULT = -1;
				//        }
				//        int index = target.IndexOf(word, UFTstart);
				//        if( index > 0 )
				//        {
				//            string subStr = target.Substring(0, index);
				//            index = ShiftJisManager.GetStrlenShiftJis(subStr);
				//        }
				//        vEvaluator.RESULT = index;
				//    }
				//    break;
				default:
					throw new ExeEE("`̊֐");
			}
			return;
		}


		private string createBar(Int64 var, Int64 max, Int64 length)
		{
			if (max <= 0)
				throw new CodeEE("BAR̍ől̒lł͂܂");
			if (length <= 0)
				throw new CodeEE("BAR̒̒lł͂܂");
			if (length >= 100)//\h߁B
				throw new CodeEE("BAR܂");
			StringBuilder builder = new StringBuilder();
			builder.Append('[');
			int count;
			unchecked
			{
				count = (int)(var * length / max);
			}
			if (count < 0)
				count = 0;
			if (count > length)
				count = (int)length;
			builder.Append(Config.Instance.BarChar1, count);
			builder.Append(Config.Instance.BarChar2, (int)length - count);
			builder.Append(']');
			return builder.ToString();
		}

		#endregion

		#region flow control

		void doFlowControlFunction(InstructionLine line, bool sequential)
		{
			StringStream st = new StringStream(line.ArgumentStr);
			ExpressionArgument expArg = null;
			switch (line.Function)
			{
				case BuiltInFunctionCode.BEGIN://VXe֐̎sB
					string keyword = line.ArgumentStr;
					if (Config.Instance.IgnoreCase)
						keyword = keyword.ToUpper();
					if (!Enum.IsDefined(typeof(BeginType), keyword))
						throw new CodeEE("BEGIÑL[[h\"" + keyword + "\"͖`ł");
					state.SetBegin((BeginType)Enum.Parse(typeof(BeginType), keyword));
					state.Return(0);
					break;

				case BuiltInFunctionCode.SAVEGAME://Z[uʂĂԁBVbv̂݁B
					saveCurrentState(true);
					state.SaveLoadData(true);
					break;
				case BuiltInFunctionCode.LOADGAME://
					saveCurrentState(true);
					state.SaveLoadData(false);
					break;

				case BuiltInFunctionCode.SIF://ŝIF
					expArg = (ExpressionArgument)line.Argument;
					if (eEvaluator.GetInteger(expArg.Term) != 0)//]^Ȃ炻̂܂ܗꗎ
						break;
					state.ShfitNextLine();//UȂsƂ΂BɗƂƓɂ
					break;
				case BuiltInFunctionCode.IF:
					expArg = (ExpressionArgument)line.Argument;
					if (eEvaluator.GetInteger(expArg.Term) != 0)//^
						break;
					state.JumpTo(line.JumpTo);
					break;

				case BuiltInFunctionCode.ELSE:
					if (sequential)//ڗȂENDIF
					{
						state.JumpTo(line.JumpToEndif);
						break;
					}
					else//IFAELSEIF΂ꂽȂ炻̂܂܎
					{
						break;
					}
				case BuiltInFunctionCode.ELSEIF:
					if (sequential)//ڗȂELSEƓ
					{
						goto case BuiltInFunctionCode.ELSE;
					}
					else//(IFAELSEIF)΂ꂽꍇIFƓ
					{
						goto case BuiltInFunctionCode.IF;
					}
				case BuiltInFunctionCode.ENDIF:
					break;//ENDIFłׂƂ͓ɖ

				case BuiltInFunctionCode.REPEAT://REND܂ŌJԂBJԂ񐔂COUNTցBlXgsB
				case BuiltInFunctionCode.FOR://NEXT܂ŌJԂBJE^[ϐݒ\BlXgB
					if (sequential)//ォ痈Ȃ񐔂̃Zbg
					{
						if (line.Function == BuiltInFunctionCode.FOR)
						{
							SpForNextArgment forArg = (SpForNextArgment)line.Argument;
							line.LoopCounter = eEvaluator.GetFixedVariable(forArg.Cnt);
							line.LoopEnd = eEvaluator.GetInteger(forArg.End);
							line.LoopStep = eEvaluator.GetInteger(forArg.Step);
							vEvaluator.SetValue(line.LoopCounter, eEvaluator.GetInteger(forArg.Start));
						}
						else
						{
							expArg = (ExpressionArgument)line.Argument;
							FixedVariablePointer count = new FixedVariablePointer();
							count = new FixedVariablePointer();
							count.ID = VariableIdentifier.GetVariableId(VariableCode.COUNT);
							count.Index1 = 0;
							line.LoopEnd = eEvaluator.GetInteger(expArg.Term);
							line.LoopCounter = count;
							line.LoopStep = 1;
							vEvaluator.SetValue(count, 0);
						}
					}
					else//iRENDACONTINUEjłȂJE^[̑
					{
						unchecked
						{
							vEvaluator.SetValue(line.LoopCounter, vEvaluator.GetInteger(line.LoopCounter) + line.LoopStep);
						}
					}
					if ((line.LoopStep > 0) && (line.LoopEnd > vEvaluator.GetInteger(line.LoopCounter)))//܂񐔂cĂȂA
						break;//̂܂܎̍s
					else if ((line.LoopStep < 0) && (line.LoopEnd < vEvaluator.GetInteger(line.LoopCounter)))//܂񐔂cĂȂA
						break;//̂܂܎̍s
					state.JumpTo(line.JumpTo);
					break;


				case BuiltInFunctionCode.WHILE://WEND܂ŌJԂA^ꂽ𖞂薳ɌJԂBlXg
					{
						expArg = (ExpressionArgument)line.Argument;
						if (eEvaluator.GetInteger(expArg.Term) != 0)//^
							break;//̂܂ܒ̏
						state.JumpTo(line.JumpTo);
						break;
					}
				case BuiltInFunctionCode.NEXT://NEXTɖ߂
				case BuiltInFunctionCode.REND://REPEATɖ߂
				case BuiltInFunctionCode.WEND://WHILEɖ߂
					if (!sequential)//REPEATAFORAWHILEABREAKłȂ
						break;
					//ŗȂREPEATAFORAWHILEɋABJԂ񐔂̋Lƃ`FbNREPEATAFORsB
					state.JumpTo(line.JumpTo);
					break;
				case BuiltInFunctionCode.BREAK://REND܂ŃWv
					{
						//BREAKJUMPREND܂NEXTB̃WvłREPEATFORiLineɑB
						InstructionLine iLine = (InstructionLine)((InstructionLine)line.JumpTo).JumpTo;
						//WHILE̓JE^Ȃ̂ŁAWv
						if (iLine.Function == BuiltInFunctionCode.WHILE)
						{
							state.JumpTo(line.JumpTo);
							break;
						}
						unchecked
						{//{ƂłBREAKCOUNT
							vEvaluator.SetValue(iLine.LoopCounter, vEvaluator.GetInteger(iLine.LoopCounter) + iLine.LoopStep);
						}
						state.JumpTo(line.JumpTo);
						break;
					}
				case BuiltInFunctionCode.CONTINUE://REPEATɖ߂
				case BuiltInFunctionCode.GOTO://$xփWv
				case BuiltInFunctionCode.TRYGOTO:
                case BuiltInFunctionCode.TRYCGOTO:
                case BuiltInFunctionCode.RESTART://֐̍ĊJB֐̍ŏɖ߂B
					if (line.JumpTo == null)
					{
                        if (line.Function == BuiltInFunctionCode.TRYGOTO)
                            break;
                        else if (line.Function == BuiltInFunctionCode.TRYCGOTO)
                        {
                            if (line.JumpToEndCatch != null)
                                state.JumpTo(line.JumpToEndCatch);
                        }
						if (line.Function == BuiltInFunctionCode.GOTO)
							throw new CodeEE("x\"$" + line.ArgumentStr + "\"܂");
						throw new ExeEE("Wv悪K؂ɐݒ肳ĂȂ");
					}
					state.JumpTo(line.JumpTo);
					break;
				case BuiltInFunctionCode.JUMP://֐Ɉړ
				case BuiltInFunctionCode.TRYJUMP:
                case BuiltInFunctionCode.TRYCJUMP:
                    if (line.JumpTo == null)
					{
                        if (line.Function == BuiltInFunctionCode.TRYJUMP)
                            break;
                        else if (line.Function == BuiltInFunctionCode.TRYCJUMP)
                        {
                            if (line.JumpToEndCatch != null)
                                state.JumpTo(line.JumpToEndCatch);
                        }
						throw new CodeEE("֐\"@" + ((SpCallArgment)line.Argument).Str + "\"܂");
					}
					assignArgs((FunctionLabelLine)line.JumpTo, ((SpCallArgment)line.Argument).Args);
					state.JumpTo(line.JumpTo);
					break;
				case BuiltInFunctionCode.CALL://֐ɈړBړLARETURNŋAB
				case BuiltInFunctionCode.TRYCALL:
                case BuiltInFunctionCode.TRYCCALL:
                    {
                        if ((line.JumpTo == null) && (line.Function == BuiltInFunctionCode.TRYCALL))
                            break;
                        else if ((line.JumpTo == null) && (line.Function == BuiltInFunctionCode.TRYCCALL))
                        {
                            if (line.JumpToEndCatch != null)
                                state.JumpTo(line.JumpToEndCatch);
                            break;
                        }
                        if (!sequential)//RETURNŋAĂ
                            break;//Ȃ
						string label = ((SpCallArgment)line.Argument).Str;
						if (Config.Instance.IgnoreCase)
							label = label.ToUpper();
						CalledFunction call = CalledFunction.CallFunction(this, label, line, false);
						if ((call == null) || (call.Count == 0) || (call.NextLine == null))
							throw new CodeEE("֐\"@" + label + "\"܂");
						if (call.Count > 1)
							throw new ExeEE("֐\"@" + label + "\"̌₪Ԃꂽ");
						//if (call.LabelList.Count > 1 && strArray.Count > 0)
						//    throw new ExeEE("EVENT֐\"@" + label + "\"Ɉw肷邱Ƃ͂ł܂");
						assignArgs(call.LabelList[0], ((SpCallArgment)line.Argument).Args);
						state.AddFunction(call);
						break;
					}
				case BuiltInFunctionCode.RETURN://֐̏IBRESULTɐi[\B
					{
						expArg = (ExpressionArgument)line.Argument;
						Int64 ret = eEvaluator.GetInteger(expArg.Term);
						vEvaluator.RESULT = ret;
						state.Return(ret);
						break;
					}
				case BuiltInFunctionCode.RETURNFORM://֐̏IBRESULTɐi[\B
					{
						//expArg = (ExpressionArgument)line.Argument;
						StringForm strForm = ((FormStrArgument)line.Argument).StrForm;
						string arg = strForm.GetString(eEvaluator);
						StringStream aSt = new StringStream(arg);
						Int64 ret = eEvaluator.GetInteger(ExpressionParser.ReduceIntegerTerm(aSt));
						vEvaluator.RESULT = ret;
						state.Return(ret);
						break;
					}
				case BuiltInFunctionCode.RETURNF:
					{
						expArg = (ExpressionArgument)line.Argument;
						SingleTerm ret = null;
						if (expArg.Term != null)
						{
							ret = eEvaluator.GetValue(expArg.Term);
						}
						state.ReturnF(ret);
						break;
					}
				case BuiltInFunctionCode.LOADDATA:
					{
						ExpressionArgument intExpArg = (ExpressionArgument)line.Argument;
						Int64 target = eEvaluator.GetInteger(intExpArg.Term);
						if (target < 0)
							throw new CodeEE("LOADDATÄɕ̒l(" + target.ToString() + ")w肳܂");
						else if (target > int.MaxValue)
							throw new CodeEE("LOADDATÄ(" + target.ToString() + ")傫܂");
						EraDataResult result = checkData((int)target);
						if (result.State != EraDataState.OK)
							throw new CodeEE("sȃf[^[h悤Ƃ܂");

						loadFrom((int)target);
						state.ClearFunctionList();
						state.SystemState = SystemStateCode.LoadData_DataLoaded;
					}
					break;
				case BuiltInFunctionCode.JUMPFORM:
				case BuiltInFunctionCode.TRYJUMPFORM:
                case BuiltInFunctionCode.TRYCJUMPFORM:
                    {
						SpCallformArgment spCallformArg = (SpCallformArgment)line.Argument;
						StringForm strForm = spCallformArg.StrForm;
						string label = strForm.GetString(eEvaluator).Trim();
						if (Config.Instance.IgnoreCase)
							label = label.ToUpper(); ;
						CalledFunction call = CalledFunction.CallFunction(this, label, line, false);
						if ((call == null) || (call.Count == 0) || (call.NextLine == null))
						{
							if (line.Function == BuiltInFunctionCode.TRYJUMPFORM)
                                break;
                            else if (line.Function == BuiltInFunctionCode.TRYCJUMPFORM)
                            {
                                if (line.JumpToEndCatch != null)
                                    state.JumpTo(line.JumpToEndCatch);
                                break;
                            }
                            throw new CodeEE("֐\"@" + label + "\"܂");
						}
						assignArgs(call.LabelList[0], spCallformArg.Args);
						state.JumpTo(call.NextLine);
						break;
					}

				case BuiltInFunctionCode.CALLFORM:
				case BuiltInFunctionCode.TRYCALLFORM:
                case BuiltInFunctionCode.TRYCCALLFORM:
                    {
						if (!sequential)//RETURNŋAĂ
                            break;//Ȃ
                        SpCallformArgment spCallformArg = (SpCallformArgment)line.Argument;
						StringForm strForm = spCallformArg.StrForm;
						string label = strForm.GetString(eEvaluator).Trim();
						if (Config.Instance.IgnoreCase)
							label = label.ToUpper(); ;
						CalledFunction call = CalledFunction.CallFunction(this, label, line, false);
						if ((call == null) || (call.Count == 0) || (call.NextLine == null))
						{
                            if (line.Function == BuiltInFunctionCode.TRYCALLFORM)
                               break;
                            else if (line.Function == BuiltInFunctionCode.TRYCCALLFORM)
                            {
                                if (line.JumpToEndCatch != null)
                                    state.JumpTo(line.JumpToEndCatch);
                                break;
                            }
							throw new CodeEE("֐\"@" + label + "\"܂");

						}
						assignArgs(call.LabelList[0], spCallformArg.Args);
						state.AddFunction(call);
						break;
					}
				case BuiltInFunctionCode.GOTOFORM:
				case BuiltInFunctionCode.TRYGOTOFORM:
                case BuiltInFunctionCode.TRYCGOTOFORM:
                    {
						StringForm strForm = ((FormStrArgument)line.Argument).StrForm;
						string label = strForm.GetString(eEvaluator).Trim();
						if (Config.Instance.IgnoreCase)
							label = label.ToUpper();
						LogicalLine jumpto = state.CurrentCalled.CallLabel(this, label);
						if (jumpto == null)
						{
                            if (line.Function == BuiltInFunctionCode.TRYGOTOFORM)
                                break;
                            else if (line.Function == BuiltInFunctionCode.TRYCGOTOFORM)
                            {
                                if (line.JumpToEndCatch != null)
                                    state.JumpTo(line.JumpToEndCatch);
                                break;
                            }
							throw new CodeEE("x\"$" + label + "\"܂");
						}
						state.JumpTo(jumpto);
						break;
					}
				case BuiltInFunctionCode.CALLTRAIN:
					{
						ExpressionArgument intExpArg = (ExpressionArgument)line.Argument;
						Int64 count = eEvaluator.GetInteger(intExpArg.Term);
						SetCommnds(count);
						break;
					}
                case BuiltInFunctionCode.CATCH:
                    {
                        if (sequential) //ォ痬ĂȂ牽ȂENDCATCHɔ
                            state.JumpTo(line.JumpToEndCatch);
                    }
                    break; 
                case BuiltInFunctionCode.ENDCATCH:
                    break;
				case BuiltInFunctionCode.DOTRAIN:
					{
						switch (state.SystemState)
						{
							//case SystemStateCode.Train_Begin://BEGIN TRAINB
							case SystemStateCode.Train_CallEventTrain://@EVENTTRAIŇĂяoBXLbv\
							case SystemStateCode.Train_CallShowStatus://@SHOW_STATUŠĂяo
							//case SystemStateCode.Train_CallComAbleXX://@COM_ABLExx̌ĂяoB
							case SystemStateCode.Train_CallShowUserCom://@SHOW_USERCOM̌Ăяo
							//case SystemStateCode.Train_WaitInput://͑҂ԁBIs\ȂEVENTCOMCOMxxAłȂ@USERCOMRESULTn
							//case SystemStateCode.Train_CallEventCom://@EVENTCOM̌Ăяo
							//case SystemStateCode.Train_CallComXX://@COMxx̌Ăяo
							//case SystemStateCode.Train_CallSourceCheck://@SOURCE_CHECǨĂяo
							case SystemStateCode.Train_CallEventComEnd://@EVENTCOMENĎĂяoBXLbv\BTrain_CallEventTrain֋AB@USERCOM̌Ăяo
								break;
							default:
								throw new CodeEE("DOTRAIN߂̈ʒuŎs邱Ƃ͂ł܂");
						}
						coms.Clear();
						isCTrain = false;
						this.count = 0;
						Int64 train = eEvaluator.GetInteger(((ExpressionArgument)line.Argument).Term);
						if (train < 0)
							throw new CodeEE("DOTRAIN߂0̒ln܂");
						if (train >= vEvaluator.Constant.TrainName.Length)
							throw new CodeEE("DOTRAIN߂TRAINNAME̔z񐔈ȏ̒ln܂");
						doTrainSelectCom = train;
						state.SystemState = SystemStateCode.Train_DoTrain;
						break;
					}
				default:
					throw new ExeEE("`̊֐ł");
			}

		}

		/// <summary>
		/// Ăяo֐ւ̈̑B[JϐScope̓sAJumpToAddFunction̑OɌĂԂƁB
		/// </summary>
		/// <param name="called"></param>
		/// <param name="args"></param>
		private void assignArgs(FunctionLabelLine called, IOperandTerm[] args)
		{
			if (called.Arg.Length < args.Length)
				throw new CodeEE("̐֐\"@" + called.LabelName + "\"ɐݒ肳ꂽ𒴂Ă܂");
			if (called.Arg.Length == 0)
				return;
			string oldScope = state.Scope;
			string newScope = called.LabelName;
			for (int i = 0; i < called.Arg.Length; i++)
			{
				IOperandTerm term = null;
				if (i < args.Length)
					term = args[i];
				FixedVariablePointer pt;
				if (term == null)
				{
					//VEvaluator.Scope = oldScope;
					//string str = eEvaluator.GetString(term);
					vEvaluator.Scope = newScope;
					pt = eEvaluator.GetFixedVariable(called.Arg[i]);
					if (called.Arg[i].GetOperandType() == typeof(string))
						vEvaluator.SetValue(pt, "");
					else if (called.Arg[i].GetOperandType() == typeof(Int64))
						vEvaluator.SetValue(pt, 0);
					else
						continue;
				}
				else if ((term.GetOperandType() == typeof(string)) && (called.Arg[i].GetOperandType() == typeof(string)))
				{
					vEvaluator.Scope = oldScope;
					string str = eEvaluator.GetString(term);
					vEvaluator.Scope = newScope;
					pt = eEvaluator.GetFixedVariable(called.Arg[i]);
					vEvaluator.SetValue(pt, str);
				}
				else if ((term.GetOperandType() == typeof(Int64)) && (called.Arg[i].GetOperandType() == typeof(Int64)))
				{
					vEvaluator.Scope = oldScope;
					Int64 l = eEvaluator.GetInteger(term);
					vEvaluator.Scope = newScope;
					pt = eEvaluator.GetFixedVariable(called.Arg[i]);
					vEvaluator.SetValue(pt, l);
				}
				else if ((term.GetOperandType() == typeof(Int64)) && (called.Arg[i].GetOperandType() == typeof(string)))
				{
					vEvaluator.Scope = oldScope;
					Int64 l = eEvaluator.GetInteger(term);
					vEvaluator.Scope = newScope;
					pt = eEvaluator.GetFixedVariable(called.Arg[i]);
					vEvaluator.SetValue(pt, l.ToString());
				}
				else if ((term.GetOperandType() == typeof(string)) && (called.Arg[i].GetOperandType() == typeof(Int64)))
					throw new CodeEE((i + 1).ToString() + "Ԗڂ̈𕶎^琮^ɕϊł܂");
				else
					throw new ExeEE("̌`s");
			}

		}

		//private List<string> splitArgStr(string str, BuiltInFunctionCode bc)
		//{
		//    List<string> strArray = new List<string>();
		//    StringStream st = new StringStream(str);
		//    string tStr = null;
		//    int count = 0;
		//    while (!st.EOS)
		//    {
		//        TokenReader.SkipWhiteSpace(st);
		//        if (count > 0)
		//        {
		//            tStr = TokenReader.ReadIdentiferWithIndexAndExpression(st);
		//            strArray.Add(tStr);
		//            count++;
		//        }
		//        else
		//        {
		//            if (bc == BuiltInFunctionCode.CALLFORM || bc == BuiltInFunctionCode.TRYCALLFORM)
		//            {
		//                tStr = TokenReader.ReadRawStringWithFormString(st);
		//            }
		//            else
		//            {
		//                tStr = TokenReader.ReadRawString(st);
		//            }
		//            strArray.Add(tStr);
		//            count++;
		//        }
		//    }
		//    return strArray;
		//}


		List<ProcessState> prevStateList = new List<ProcessState>();
		private void saveCurrentState(bool single)
		{
			if (single && (prevStateList.Count > 0))
				throw new ExeEE("LĂԂ̂ɍēxL悤Ƃ");
			prevStateList.Add(state.Clone());
		}

		private void loadPrevState()
		{
			if (prevStateList.Count == 0)
				throw new ExeEE("LĂԂȂ̂ɌĂі߂ꂽ");
			state = prevStateList[prevStateList.Count - 1];
			deletePrevState();
		}

		private void deletePrevState()
		{
			if (prevStateList.Count != 0)
				prevStateList.RemoveAt(prevStateList.Count - 1);
		}

		private void deleteAllPrevState()
		{
			prevStateList.Clear();
		}


		#endregion
	}
}
