using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.GameData.Variable;

namespace MinorShift.Emuera.GameProc
{
	/// <summary>
	/// ߕ1sɑ钊ۃNX
	/// </summary>
	internal abstract class LogicalLine
	{
		protected ScriptPosition position;

		//LogicalLine prevLine;
		LogicalLine nextLine;
		public ScriptPosition Position
		{
			get { return position; }
		}

		//IF-ENDIFȂǂ̌̎dlύX̂ŕsvɂȂ
		//public LogicalLine PrevLine
		//{
		//    get { return prevLine; }
		//    set { prevLine = value; }
		//}

		public LogicalLine NextLine
		{
			get { return nextLine; }
			set { nextLine = value; }
		}
		public override string ToString()
		{
			if (position == null)
				return base.ToString();
			return string.Format("{0}:{1}:{2}", position.Filename, position.LineNo, position.RowLine);
		}

		protected bool isError;
		protected string errMes = "";

		public virtual string ErrMes
		{
			get { return errMes; }
			set { errMes = value; }
		}
		public virtual bool IsError
		{
			get { return isError; }
			set { isError = value; }
		}
	}

	/// <summary>
	/// RgsB
	/// </summary>
	internal sealed class CommentLine : LogicalLine
	{
		public CommentLine(ScriptPosition thePosition, string str)
		{
			base.position = thePosition;
			comment = str;
		}
		string comment;
		public override bool IsError
		{
			get { return false; }
		}
	}

	/// <summary>
	/// ȍsB
	/// </summary>
	internal sealed class InvalidLine : LogicalLine
	{
		public InvalidLine(ScriptPosition thePosition, string err)
		{
			base.position = thePosition;
			errMes = err;
		}
		public override bool IsError
		{
			get { return true; }
		}
	}

	/// <summary>
	/// ߕ
	/// </summary>
	internal sealed class InstructionLine : LogicalLine
	{
		public InstructionLine(ScriptPosition thePosition, BuiltInFunctionCode theFunc, string theArg)
		{
			base.position = thePosition;
			this.func = theFunc;
			this.argstr = theArg;
		}
		public InstructionLine(ScriptPosition thePosition, BuiltInFunctionCode theFunc, string dest, string theArg)
		{
			base.position = thePosition;
			this.func = theFunc;
			this.assigndest = dest;
			this.argstr = theArg;
		}
		readonly BuiltInFunctionCode func;
		readonly string argstr;
		readonly string assigndest;
		Int64 subData = 0;
		Argument arg = null;
		public BuiltInFunctionCode Function
		{
			get { return func; }
		}
		public string ArgumentStr
		{
			get { return argstr; }
		}
		public Argument Argument
		{
			get { return arg; }
			set { arg = value; }
		}
		public string AssignmentDestStr
		{
			get { return assigndest; }
		}

		/// <summary>
		/// JԂ̏IL
		/// </summary>
		public Int64 LoopEnd
		{
			get { return subData; }
			set { subData = value; }
		}

		FixedVariablePointer cnt;
		/// <summary>
		/// JԂɂϐL
		/// </summary>
		public FixedVariablePointer LoopCounter
		{
			get { return cnt; }
			set { cnt = value; }
		}

		Int64 step;
		/// <summary>
		/// JԂ̂тɑlL
		/// </summary>
		public Int64 LoopStep
		{
			get { return step; }
			set { step = value; }
		}

		private LogicalLine jumpto = null;
        private LogicalLine jumptoendcatch = null;
		//1.723 IFn̎dlύXB
		//private LogicalLine jumptoendif = null;
		//public LogicalLine JumpToEndif
		//{
		//    get { return jumptoendif; }
		//    set { jumptoendif = value; }
		//}
		//IFSELECT݂̂gB
		public List<InstructionLine> IfCaseList = null;
        //PRINTDATÂ݂gB
        //public List<InstructionLine> dataList = null;
        public List<List<InstructionLine>> dataList = null;

		public LogicalLine JumpTo
		{
			get { return jumpto; }
			set { jumpto = value; }
		}

        public LogicalLine JumpToEndCatch
        {
            get { return jumptoendcatch; }
            set { jumptoendcatch = value; }
        }

	}


	/// <summary>
	/// t@C̎n[ƏI[
	/// </summary>
	internal sealed class NullLine : LogicalLine { }

	/// <summary>
	/// @Ŏn܂郉xs
	/// </summary>
	internal sealed class FunctionLabelLine : LogicalLine, IComparable<FunctionLabelLine>
	{
		public FunctionLabelLine(ScriptPosition thePosition, string labelname, List<VariableToken> args)
		{
			base.position = thePosition;
			LabelName = labelname;
			if ((args != null) && (args.Count > 0))
			{
				this.arg = new VariableToken[args.Count];
				args.CopyTo(this.arg);
			}
			else
				this.arg = new VariableToken[0];
			Priority = 0;
			IsSingle = false;
			Index = -1;
			Depth = -1;
			IsMethod = false;
			MethodType = typeof(void);
		}
		readonly VariableToken[] arg;


		public string LabelName { get; private set; }
		public int Priority { get; set; }
		public bool IsSingle { get; set; }
		public int Index { get; set; }

		public bool IsMethod { get; set; }
		public Type MethodType { get; set; }
		public VariableToken[] Arg
		{
			get { return arg; }
		}
		public int Depth { get; set; }
		#region IComparable<FunctionLabelLine> o

		public int CompareTo(FunctionLabelLine other)
		{
			if (Priority != other.Priority)
				return Priority.CompareTo(other.Priority);
			return Index.CompareTo(other.Index);
		}

		#endregion
	}

	/// <summary>
	/// $Ŏn܂郉xs
	/// </summary>
	internal sealed class GotoLabelLine : LogicalLine, IEqualityComparer<GotoLabelLine>
	{
		public GotoLabelLine(ScriptPosition thePosition, string labelname)
		{
			base.position = thePosition;
			this.labelname = labelname;
		}
		readonly string labelname = "";
		FunctionLabelLine parentFunction = null;
		public string LabelName
		{
			get { return labelname; }
		}

		public void SetParentFunction(FunctionLabelLine parent)
		{
			parentFunction = parent;
		}

		public FunctionLabelLine ParentFunction
		{
			get { return parentFunction; }
		}


		#region IEqualityComparer<GotoLabelLine> o

		public bool Equals(GotoLabelLine x, GotoLabelLine y)
		{
			if ((x == null) || (y == null))
				return false;
			return ((x.parentFunction == y.parentFunction) && (x.labelname == y.labelname));
		}

		public int GetHashCode(GotoLabelLine obj)
		{
			return labelname.GetHashCode() ^ parentFunction.GetHashCode();
		}

		#endregion
	}

}