﻿using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.GameData.Expression;

namespace MinorShift.Emuera.GameProc
{
	//1.713 諸事情によりProcess.State.csから分割
	internal sealed partial class Process
	{
		/// <summary>
		/// 現在呼び出し中の関数
		/// </summary>
		private class CalledFunction
		{
			private CalledFunction(string label) { FunctionName = label; }
			public static CalledFunction CallFunction(Process parent, string label, LogicalLine retAddress, bool isEvent)
			{
				CalledFunction called = new CalledFunction(label);
				List<FunctionLabelLine> newLabelList = new List<FunctionLabelLine>();
				if (isEvent)
				{
					newLabelList.AddRange(parent.labelDic.GetLabels(label));
					newLabelList.Sort();
				}
				else
				{
					FunctionLabelLine labelline = parent.labelDic.GetLabel(label);
					if (labelline != null)
					{
						newLabelList.Add(labelline);
					}
				}
				foreach (FunctionLabelLine line in newLabelList)
				{
					if (line.IsMethod)
						throw new CodeEE("#FUCNTIONが定義された関数(" + line.Position.Filename + ":" + line.Position.LineNo + "行目)に対し通常のCALLが行われました");
				}
				called.labelList = newLabelList;
				called.returnAddress = retAddress;
				return called;

			}

			public static CalledFunction CallFunctionMethod(Process parent, string label)
			{
				CalledFunction called = new CalledFunction(label);
				List<FunctionLabelLine> newLabelList = new List<FunctionLabelLine>();
				FunctionLabelLine labelline = parent.labelDic.GetLabel(label);
				if (labelline != null)
				{
					newLabelList.Add(labelline);
				}
				foreach (FunctionLabelLine line in newLabelList)
				{
					if (!line.IsMethod)
						throw new CodeEE("#FUCNTIONが定義されていない関数(" + line.Position.Filename + ":" + line.Position.LineNo + "行目)を式中で呼び出そうとしました");
				}
				called.labelList = newLabelList;
				called.returnAddress = null;
				return called;
			}

			public LogicalLine CallLabel(Process parent, string label)
			{
				return parent.labelDic.GetLabelDollar(label, this.NextLine);
			}

			public CalledFunction Clone()
			{
				CalledFunction called = new CalledFunction(this.FunctionName);
				List<FunctionLabelLine> newLabelList = new List<FunctionLabelLine>();
				newLabelList.AddRange(this.labelList);
				newLabelList.Sort();
				called.labelList = newLabelList;
				called.counter = this.counter;
				called.returnAddress = this.returnAddress;
				return called;
			}

			List<FunctionLabelLine> labelList;
			int counter = 0;
			LogicalLine returnAddress;
			public readonly string FunctionName = "";
			public List<FunctionLabelLine> LabelList
			{
				get { return labelList; }
			}
			public LogicalLine ReturnAddress
			{
				get { return returnAddress; }
			}
			public bool HasSingleFlag
			{
				get
				{
					if (labelList.Count <= counter)
						return false;
					return labelList[counter].IsSingle;
				}
			}
			public FunctionLabelLine NextLine
			{
				get
				{
					if (labelList.Count <= counter)
						return null;
					return labelList[counter];
				}
			}

			public void ShiftNext()
			{
				counter++;
			}
			public void Finish()
			{ counter = labelList.Count; }

			public int Count { get { return labelList.Count; } }
		}
	}
}
