﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using MinorShift.Emuera.Sub;
using MinorShift._Library;
using System.Windows.Forms;

namespace MinorShift.Emuera.GameView
{
	internal sealed class StringMeasure:IDisposable
	{
		public StringMeasure(Graphics g)
		{
			mode = Config.Instance.TextDrawingMode;
			if (mode == TextDrawingMode.WINAPI)
				GDI.GDIStart(g, Config.Instance.BackColor);
			graph = g;
		}
		Graphics graph = null;
		readonly TextDrawingMode mode;


		static readonly float fontDisplaySize = Config.Instance.Font.Size / 2 * 1.04f;//実際には指定したフォントより若干幅をとる？
		static readonly StringFormat sf = new StringFormat(StringFormatFlags.MeasureTrailingSpaces);
		static readonly CharacterRange[] ranges = new CharacterRange[] { new CharacterRange(0, 1) };

		static readonly Size layoutSize = new Size(Config.Instance.WindowX * 2, Config.Instance.LineHeight);
		static readonly RectangleF layoutRect = new RectangleF(0, 0, Config.Instance.WindowX * 2, Config.Instance.LineHeight);

		public int GetDisplayLength(string s, Font font)
		{
			if (graph == null)
				throw new ExeEE("Graphicsが設定されていない");
			return StringMeasure.GetDisplayLength(graph, s, font, mode);
		}

		public static int GetDisplayLength(Graphics g, string s, Font font, TextDrawingMode drawMode)
		{
			if (string.IsNullOrEmpty(s))
				return 0;
			if (drawMode == TextDrawingMode.GRAPHICS)
			{
				ranges[0].Length = s.Length;
				//CharacterRange[] ranges = new CharacterRange[] { new CharacterRange(0, s.Length) };
				sf.SetMeasurableCharacterRanges(ranges);
				Region[] regions = g.MeasureCharacterRanges(s, font, layoutRect, sf);
				RectangleF rectF = regions[0].GetBounds(g);
				//return (int)rectF.Width;//プロポーショナルでなくても数ピクセルずれる
				return (int)((int)((rectF.Width - 1) / fontDisplaySize + 0.95f) * fontDisplaySize);
			}
			else if (drawMode == TextDrawingMode.TEXTRENDERER)
			{
				Size size = TextRenderer.MeasureText(g, s, font, layoutSize, TextFormatFlags.NoPadding | TextFormatFlags.NoPrefix);
				//Size size = TextRenderer.MeasureText(g, s, Config.Instance.Font);
				return size.Width;
			}
			else if (drawMode == TextDrawingMode.WINAPI)
			{
				Size size = GDI.MeasureText(s, font);
				return size.Width;
			}
			else
				throw new ExeEE("描画モード不明");
		}

		#region IDisposable メンバ

		public void Dispose()
		{
			if (graph != null)
			{
				if (mode == TextDrawingMode.WINAPI)
					GDI.GDIEnd(graph);
				graph.Dispose();
			}
			graph = null;
		}

		#endregion
	}
}
