using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Drawing;
using Microsoft.VisualBasic;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.GameData.Expression;
using MinorShift.Emuera.GameData.Variable;
using MinorShift._Library;
using MinorShift.Emuera.GameView;
using MinorShift.Emuera.GameData.Function;

namespace MinorShift.Emuera.GameProc
{
	internal sealed partial class Process
	{
		private void runScriptProc()
		{
            while(true)
            {
                bool sequential = state.Sequential;
                state.ShfitNextLine();
                LogicalLine line = state.CurrentLine;
                vEvaluator.Scope = state.Scope;
                if (line == null)
                    throw new ExeEE("Emuera.exe͎Ɏss܂");
                else if (line.IsError)
                    throw new CodeEE(line.ErrMes);
                else if (line is NullLine)
                {//t@CI[
                    if (!state.IsFunctionMethod)
                        vEvaluator.RESULT = 0;
                    state.Return(0);
                    if (!(state.GetCurrentReturnAddress is NullLine))
                        continue;
                    return;
                }
                else if (line is FunctionLabelLine)
                {
                    if (sequential)
                    {//ꗎĂi֐I[j
                        if (!state.IsFunctionMethod)
                            vEvaluator.RESULT = 0;
                        state.Return(0);
                        if (!(state.GetCurrentReturnAddress is NullLine))
                            continue;
                        return;
                    }
                    else//CALLJUMPŔł
                        return;
                }
                else if (line is GotoLabelLine)
                    continue;//xB邱Ƃ͂ȂB
                else if (line is InstructionLine)
                {
                    InstructionLine func = (InstructionLine)line;
                    InstructionLine jumpTo = null;
                    if (func.Argument == null)
                        LogicalLineParser.SetArgumentTo(func, null);
                    if (func.IsError)
                        throw new CodeEE(func.ErrMes);
                    BuiltInFunctionCode iFunc = func.Function;
                    if (!BuiltInFunctionManager.IsFlowContorol(iFunc))
                    {
                        if ((iFunc & BuiltInFunctionCode.__ARG_METHOD__) == BuiltInFunctionCode.__ARG_METHOD__)
                        {
                            FunctionArgument arg = (FunctionArgument)func.Argument;
                            Type type = arg.MethodTerm.GetOperandType();
                            if (arg.MethodTerm.GetOperandType() == typeof(Int64))
                                vEvaluator.RESULT = eEvaluator.GetInteger(arg.MethodTerm);
                            else if (arg.MethodTerm.GetOperandType() == typeof(string))
                                vEvaluator.RESULTS = eEvaluator.GetString(arg.MethodTerm);
                            else
                                throw new ExeEE(func.Function.ToString() + "߂̌^s");
                        }
                        else if (iFunc == BuiltInFunctionCode.SET)
                        {
                            SpSetArgument spsetarg = (SpSetArgument)func.Argument;
                            FixedVariablePointer p = eEvaluator.GetFixedVariable(spsetarg.VariableDest);
                            vEvaluator.SetValue(p, eEvaluator.GetInteger(spsetarg.Term));
                        }
                        else if (iFunc == BuiltInFunctionCode.SETS)
                        {
                            SpSetsArgument spsetsarg = (SpSetsArgument)func.Argument;
                            FixedVariablePointer p = eEvaluator.GetFixedVariable(spsetsarg.VariableDest);
                            vEvaluator.SetValue(p, spsetsarg.StrForm.GetString(eEvaluator));
                        }
                        else
                            doNormalFunction(func);
                    }
                    else
                    {
                        if (iFunc == BuiltInFunctionCode.SIF || iFunc == BuiltInFunctionCode.IF || iFunc == BuiltInFunctionCode.SELECTCASE
                            || iFunc == BuiltInFunctionCode.ELSEIF || iFunc == BuiltInFunctionCode.ELSE || iFunc == BuiltInFunctionCode.CASE
                            || iFunc == BuiltInFunctionCode.CASEELSE
                            || iFunc == BuiltInFunctionCode.ENDIF || iFunc == BuiltInFunctionCode.ENDSELECT || iFunc == BuiltInFunctionCode.ENDCATCH
                            || iFunc == BuiltInFunctionCode.ENDFUNC || iFunc == BuiltInFunctionCode.DO)
                        {
                            ExpressionArgument expArg = null;
                            if (iFunc == BuiltInFunctionCode.ELSE || iFunc == BuiltInFunctionCode.ELSEIF
                                || iFunc == BuiltInFunctionCode.CASE || iFunc == BuiltInFunctionCode.CASEELSE)
                            {
                                if (func.JumpTo == null)
                                    throw new ExeEE(func.Function.ToString() + "̃Wv悪ݒ肳ĂȂ");
                                state.JumpTo(func.JumpTo);
                            }
                            else if (iFunc == BuiltInFunctionCode.SIF)
                            {
                                expArg = (ExpressionArgument)func.Argument;
                                if (eEvaluator.GetInteger(expArg.Term) == 0)//]^Ȃ炻̂܂ܗꗎ
                                    state.ShfitNextLine();//UȂsƂ΂BɗƂƓɂ
                            }
                            else if (iFunc == BuiltInFunctionCode.IF)
                            {
                                LogicalLine ifJumpto = null;
                                if (func.IfCaseList == null)
                                    throw new ExeEE("IFIF-ELSEIFXgKɍ쐬ĂȂ");
                                if (func.JumpTo == null)
                                    throw new ExeEE("IFɑΉENDIFݒ肳ĂȂ");

                                for (int i = 0; i < func.IfCaseList.Count; i++)
                                {
                                    if (func.IfCaseList[i].IsError)
                                        continue;
                                    if (func.IfCaseList[i].Function == BuiltInFunctionCode.ELSE)
                                    {
                                        ifJumpto = func.IfCaseList[i];
                                        break;
                                    }

                                    expArg = (ExpressionArgument)(func.IfCaseList[i].Argument);
                                    if (expArg == null)
                                        throw new ExeEE("IF`FbNB͂ĂȂB", func.IfCaseList[i].Position);

                                    //1730 ELSEIFoG[IF̃G[ƂČoĂ
                                    state.RunningLine = func.IfCaseList[i];
                                    if (eEvaluator.GetInteger(expArg.Term) != 0)//^
                                    {
                                        ifJumpto = func.IfCaseList[i];
                                        break;
                                    }
                                }
                                if (ifJumpto == null)
                                    ifJumpto = func.JumpTo;//ENDIF
                                if (ifJumpto != func)//gWvȂ炻̂܂
                                    state.JumpTo(ifJumpto);
                                state.RunningLine = null;
                            }
                            else if (iFunc == BuiltInFunctionCode.SELECTCASE)
                            {
                                LogicalLine caseJumpto = null;
                                SingleTerm term = eEvaluator.GetValue(((ExpressionArgument)func.Argument).Term);
                                if (func.IfCaseList == null)
                                    throw new ExeEE("SELECTCASECASEXgKɍ쐬ĂȂ");
                                if (func.JumpTo == null)
                                    throw new ExeEE("SELECTCASEɑΉENDSELECTݒ肳ĂȂ");
                                for (int i = 0; i < func.IfCaseList.Count; i++)
                                {
                                    if (func.IfCaseList[i].IsError)
                                        continue;
                                    if (func.IfCaseList[i].Function == BuiltInFunctionCode.CASEELSE)
                                    {
                                        caseJumpto = func.IfCaseList[i];
                                        break;
                                    }
                                    CaseArgument caseArg = (CaseArgument)(func.IfCaseList[i].Argument);
                                    if (caseArg == null)
                                        throw new ExeEE("CASE`FbNB͂ĂȂB", func.IfCaseList[i].Position);

                                    //1730 CASEoG[SELECTCASẼG[ƂČoĂ
                                    state.RunningLine = func.IfCaseList[i];
                                    foreach (CaseExpression caseExp in caseArg.CaseExps)
                                    {
                                        if (eEvaluator.GetCase(caseExp, term))
                                        {
                                            caseJumpto = func.IfCaseList[i];
                                            goto casefound;
                                        }
                                    }
                                }
                            casefound:
                                if (caseJumpto == null)
                                    caseJumpto = func.JumpTo;//ENDSELECT
                                state.JumpTo(caseJumpto);
                                state.RunningLine = null;
                            }
                        }
                        else if (iFunc == BuiltInFunctionCode.RETURN|| iFunc == BuiltInFunctionCode.RETURNFORM || iFunc == BuiltInFunctionCode.CONTINUE
                            || iFunc == BuiltInFunctionCode.RESTART|| iFunc == BuiltInFunctionCode.BREAK|| iFunc == BuiltInFunctionCode.REND
                            || iFunc == BuiltInFunctionCode.NEXT || iFunc == BuiltInFunctionCode.WEND || iFunc == BuiltInFunctionCode.LOOP)
                        {
                            if (iFunc == BuiltInFunctionCode.REND || iFunc == BuiltInFunctionCode.NEXT
                                || (iFunc == BuiltInFunctionCode.CONTINUE && ((((InstructionLine)func.JumpTo).Function == BuiltInFunctionCode.REPEAT) || ((InstructionLine)func.JumpTo).Function == BuiltInFunctionCode.FOR)))
                            {
                                jumpTo = (InstructionLine)func.JumpTo;
                                //[vϐs(REPEATAFORoRɃ[v悤Ƃꍇ͖ă[v𔲂(eramakerdl肷))
                                if (jumpTo.LoopCounter == null)
                                    state.JumpTo(jumpTo.JumpTo);
                                else
                                {
                                    unchecked
                                    {
                                        vEvaluator.SetValue(jumpTo.LoopCounter, vEvaluator.GetInteger(jumpTo.LoopCounter) + jumpTo.LoopStep);
                                    }
                                    if (((jumpTo.LoopStep > 0) && (jumpTo.LoopEnd > vEvaluator.GetInteger(jumpTo.LoopCounter)))
                                        || ((jumpTo.LoopStep < 0) && (jumpTo.LoopEnd < vEvaluator.GetInteger(jumpTo.LoopCounter))))//܂񐔂cĂȂA
                                        state.JumpTo(func.JumpTo);
                                    else if (func.Function == BuiltInFunctionCode.CONTINUE)
                                        state.JumpTo(jumpTo.JumpTo);
                                }
                            }
                            else if (iFunc == BuiltInFunctionCode.WEND || (iFunc == BuiltInFunctionCode.CONTINUE && ((InstructionLine)func.JumpTo).Function == BuiltInFunctionCode.WHILE))
                            {
                                jumpTo = (InstructionLine)func.JumpTo;
                                if (eEvaluator.GetInteger(((ExpressionArgument)jumpTo.Argument).Term) != 0)
                                    state.JumpTo(func.JumpTo);
                                else if (func.Function == BuiltInFunctionCode.CONTINUE)
                                    state.JumpTo(jumpTo.JumpTo);
                            }
                            else if (iFunc == BuiltInFunctionCode.LOOP || (iFunc == BuiltInFunctionCode.CONTINUE && ((InstructionLine)func.JumpTo).Function == BuiltInFunctionCode.DO))
                            {
                                InstructionLine tFunc = func;
                                if (iFunc == BuiltInFunctionCode.CONTINUE)
                                    tFunc = (InstructionLine)((InstructionLine)func.JumpTo).JumpTo;
                                ExpressionArgument expArg = (ExpressionArgument)tFunc.Argument;
                                if (eEvaluator.GetInteger(expArg.Term) != 0)//^
                                    state.JumpTo(tFunc.JumpTo);
                                else if (iFunc == BuiltInFunctionCode.CONTINUE)
                                    state.JumpTo((InstructionLine)((InstructionLine)func.JumpTo).JumpTo);
                            }
                            else if (iFunc == BuiltInFunctionCode.BREAK)
                            {
                                ////BREAKJUMPREND܂NEXTB̃WvłREPEATFORiLineɑB
                                //1.723 dlύXBBREAKJUMPɂREPEATAFORAWHILELBJUMP悪{JUMPB
                                jumpTo = (InstructionLine)func.JumpTo;
                                InstructionLine iLine = (InstructionLine)jumpTo.JumpTo;
                                //WHILEDO̓JE^Ȃ̂ŁAWv
                                if (jumpTo.Function != BuiltInFunctionCode.WHILE && jumpTo.Function != BuiltInFunctionCode.DO)
                                {
                                    unchecked
                                    {//{ƂłBREAKCOUNT
                                        vEvaluator.SetValue(jumpTo.LoopCounter, vEvaluator.GetInteger(jumpTo.LoopCounter) + jumpTo.LoopStep);
                                    }
                                }
                                state.JumpTo(iLine);
                            }
                            else if (iFunc == BuiltInFunctionCode.RESTART)
                                state.JumpTo(func.JumpTo);
                            else if (iFunc == BuiltInFunctionCode.RETURN)
                            {
                                ExpressionArgument expArg = (ExpressionArgument)func.Argument;
                                Int64 ret = eEvaluator.GetInteger(expArg.Term);
                                vEvaluator.RESULT = ret;
                                state.Return(ret);
                                if (state.GetCurrentReturnAddress is NullLine)
                                    return;
                            }
                            else if (iFunc == BuiltInFunctionCode.RETURNFORM)
                            {
                                string arg = eEvaluator.GetString(((ExpressionArgument)func.Argument).Term);
                                StringStream aSt = new StringStream(arg);
                                Int64 ret = eEvaluator.GetInteger(ExpressionParser.ReduceIntegerTerm(aSt, null));
                                vEvaluator.RESULT = ret;
                                state.Return(ret);
                                if (state.GetCurrentReturnAddress is NullLine)
                                    return;
                            }
                        }
                        else if (!doFlowControlFunction(func, sequential))
                            return;
                    }
                    //lineCount++;
                    //WinmmTimer玞Ԃ擾̂͂ꎩ̌\ȃRXĝ10000sɈ񂭂炢ŁB
                    if ((lineCount % 10000 == 0 || (lineCount - 1) % 10000 == 0) && Config.Instance.InfiniteLoopAlertTime > 0)
                        checkInfiniteLoop();
                    if (console.IsRunning && !state.ScriptEnd)
                        continue;
                    return;
                }
                else if (line is InvalidLine)
                {
                    if (string.IsNullOrEmpty(line.ErrMes))
                        throw new CodeEE("ǍɎsss܂BG[̏ڍׂ͓Ǎ̌xQƂĂB");
                    else
                        throw new CodeEE(line.ErrMes);
                }
                else
                    throw new ExeEE("`ĂȂނ̍sł");
            }
		}

		public void DoDebugNormalFunction(InstructionLine line)
		{
            if ((line.Function & BuiltInFunctionCode.__ARG_METHOD__) == BuiltInFunctionCode.__ARG_METHOD__)
            {
                FunctionArgument arg = (FunctionArgument)line.Argument;
                Type type = arg.MethodTerm.GetOperandType();
                if (arg.MethodTerm.GetOperandType() == typeof(Int64))
                    vEvaluator.RESULT = eEvaluator.GetInteger(arg.MethodTerm);
                else if (arg.MethodTerm.GetOperandType() == typeof(string))
                    vEvaluator.RESULTS = eEvaluator.GetString(arg.MethodTerm);
                else
                    throw new ExeEE(line.Function.ToString() + "߂̌^s");
            }
            else if (line.Function == BuiltInFunctionCode.SET)
            {
                SpSetArgument spsetarg = (SpSetArgument)line.Argument;
                FixedVariablePointer p = eEvaluator.GetFixedVariable(spsetarg.VariableDest);
                vEvaluator.SetValue(p, eEvaluator.GetInteger(spsetarg.Term));
            }
            else if (line.Function == BuiltInFunctionCode.SETS)
            {
                SpSetsArgument spsetsarg = (SpSetsArgument)line.Argument;
                FixedVariablePointer p = eEvaluator.GetFixedVariable(spsetsarg.VariableDest);
                vEvaluator.SetValue(p, spsetsarg.StrForm.GetString(eEvaluator));
            }
            else
                doNormalFunction(line);
            vEvaluator.IamaMunchkin();
        }

		#region normal
		void doNormalFunction(InstructionLine line)
		{
            //if ((line.Function & BuiltInFunctionCode.__ARG_METHOD__) == BuiltInFunctionCode.__ARG_METHOD__)
            //{
            //    FunctionArgument arg = (FunctionArgument)line.Argument;
            //    Type type = arg.MethodTerm.GetOperandType();
            //    if (arg.MethodTerm.GetOperandType() == typeof(Int64))
            //        vEvaluator.RESULT = eEvaluator.GetInteger(arg.MethodTerm);
            //    else if (arg.MethodTerm.GetOperandType() == typeof(string))
            //        vEvaluator.RESULTS = eEvaluator.GetString(arg.MethodTerm);
            //    else
            //        throw new ExeEE(line.Function.ToString() + "߂̌^s");
            //    return;
            //}
			string str = null;
			IOperandTerm term = null;
			switch (line.Function)
			{
                //case BuiltInFunctionCode.SET:
                //    {
                //        SpSetArgument spsetarg = (SpSetArgument)line.Argument;
                //        FixedVariablePointer p = eEvaluator.GetFixedVariable(spsetarg.VariableDest);
                //        vEvaluator.SetValue(p, eEvaluator.GetInteger(spsetarg.Term));
                //    }
                //    break;
                //case BuiltInFunctionCode.SETS:
                //    {
                //        SpSetsArgument spsetsarg = (SpSetsArgument)line.Argument;
                //        FixedVariablePointer p = eEvaluator.GetFixedVariable(spsetsarg.VariableDest);
                //        vEvaluator.SetValue(p, spsetsarg.StrForm.GetString(eEvaluator));
                //    }
                //    break;
				case BuiltInFunctionCode.PRINT://\
                case BuiltInFunctionCode.PRINTD:
                case BuiltInFunctionCode.PRINTL://s
                case BuiltInFunctionCode.PRINTDL:
				case BuiltInFunctionCode.PRINTW://͑҂(s)
                case BuiltInFunctionCode.PRINTDW:
				case BuiltInFunctionCode.PRINTSINGLE://s
                case BuiltInFunctionCode.PRINTSINGLED:
				case BuiltInFunctionCode.PRINTS://ϐ̓e
                case BuiltInFunctionCode.PRINTSD:
                case BuiltInFunctionCode.PRINTSL:
                case BuiltInFunctionCode.PRINTSDL:
				case BuiltInFunctionCode.PRINTSW:
                case BuiltInFunctionCode.PRINTSDW:
				case BuiltInFunctionCode.PRINTSINGLES:
                case BuiltInFunctionCode.PRINTSINGLESD:
				case BuiltInFunctionCode.PRINTFORM://{}A%ϐ%Ȃǂ̏gB
                case BuiltInFunctionCode.PRINTFORMD:
				case BuiltInFunctionCode.PRINTFORML:
                case BuiltInFunctionCode.PRINTFORMDL:
				case BuiltInFunctionCode.PRINTFORMW:
                case BuiltInFunctionCode.PRINTFORMDW:
				case BuiltInFunctionCode.PRINTSINGLEFORM:
                case BuiltInFunctionCode.PRINTSINGLEFORMD:
                case BuiltInFunctionCode.PRINTK:
                case BuiltInFunctionCode.PRINTKL:
                case BuiltInFunctionCode.PRINTKW:
                case BuiltInFunctionCode.PRINTSINGLEK:
                case BuiltInFunctionCode.PRINTSK:
                case BuiltInFunctionCode.PRINTSKL:
                case BuiltInFunctionCode.PRINTSKW:
                case BuiltInFunctionCode.PRINTSINGLESK:
                case BuiltInFunctionCode.PRINTFORMK:
                case BuiltInFunctionCode.PRINTFORMKL:
                case BuiltInFunctionCode.PRINTFORMKW:
                case BuiltInFunctionCode.PRINTSINGLEFORMK:
                    {
                        if (skipPrint)
                            break;
                        console.UseUserStyle = !BuiltInFunctionManager.IsPrintDFunction(line.Function);
						term = ((ExpressionArgument)line.Argument).Term;
						str = eEvaluator.GetString(term);
                        if (BuiltInFunctionManager.IsPrintKFunction(line.Function) && (forceHiragana | forceKatakana | halftoFull))
                        {
                            if (forceKatakana)
                                str = Strings.StrConv(str, VbStrConv.Katakana, 0);
                            else if (forceHiragana)
                            {
                                if (halftoFull)
                                    str = Strings.StrConv(str, VbStrConv.Hiragana | VbStrConv.Wide, 0);
                                else
                                    str = Strings.StrConv(str, VbStrConv.Hiragana, 0);
                            }
                        }
                        outputToConsole(str, line.Function);
					}
					break;

				case BuiltInFunctionCode.PRINTV://ϐ̓e
                case BuiltInFunctionCode.PRINTVD:
				case BuiltInFunctionCode.PRINTVL:
                case BuiltInFunctionCode.PRINTVDL:
				case BuiltInFunctionCode.PRINTVW:
                case BuiltInFunctionCode.PRINTVDW:
				case BuiltInFunctionCode.PRINTSINGLEV:
                case BuiltInFunctionCode.PRINTSINGLEVD:
                case BuiltInFunctionCode.PRINTVK:
                case BuiltInFunctionCode.PRINTVKL:
                case BuiltInFunctionCode.PRINTVKW:
                case BuiltInFunctionCode.PRINTSINGLEVK:
					{
                        if (skipPrint)
                            break;
                        console.UseUserStyle = !BuiltInFunctionManager.IsPrintDFunction(line.Function);
                        StringBuilder builder = new StringBuilder();
						foreach (IOperandTerm termV in ((SpPrintVArgument)line.Argument).Terms)
						{
							if (termV.GetOperandType() == typeof(Int64))
								builder.Append(eEvaluator.GetInteger(termV).ToString());
							else
								builder.Append(((SingleTerm)termV).Str);
						}
						str = builder.ToString();
                        if (BuiltInFunctionManager.IsPrintKFunction(line.Function) && (forceHiragana | forceKatakana | halftoFull))
                        {
                            if (forceKatakana)
                                str = Strings.StrConv(str, VbStrConv.Katakana, 0);
                            else if (forceHiragana)
                            {
                                if (halftoFull)
                                    str = Strings.StrConv(str, VbStrConv.Hiragana | VbStrConv.Wide, 0);
                                else
                                    str = Strings.StrConv(str, VbStrConv.Hiragana, 0);
                            }
                        }
                        outputToConsole(str, line.Function);
                    }
					break;
				case BuiltInFunctionCode.PRINTFORMS://ϐ̓eϊĕ\܂B
                case BuiltInFunctionCode.PRINTFORMSD:
				case BuiltInFunctionCode.PRINTFORMSL:
                case BuiltInFunctionCode.PRINTFORMSDL:
				case BuiltInFunctionCode.PRINTFORMSW:
                case BuiltInFunctionCode.PRINTFORMSDW:
				case BuiltInFunctionCode.PRINTSINGLEFORMS:
                case BuiltInFunctionCode.PRINTSINGLEFORMSD:
                case BuiltInFunctionCode.PRINTFORMSK:
                case BuiltInFunctionCode.PRINTFORMSKL:
                case BuiltInFunctionCode.PRINTFORMSKW:
                case BuiltInFunctionCode.PRINTSINGLEFORMSK:
					{
                        if (skipPrint)
                            break;
                        console.UseUserStyle = !BuiltInFunctionManager.IsPrintDFunction(line.Function);
                        term = ((ExpressionArgument)line.Argument).Term;
						str = eEvaluator.GetString(term);
						StringForm strForm = new StringForm(str);
						str = strForm.GetString(eEvaluator);
                        if (BuiltInFunctionManager.IsPrintKFunction(line.Function) && (forceHiragana | forceKatakana | halftoFull))
                        {
                            if (forceKatakana)
                                str = Strings.StrConv(str, VbStrConv.Katakana, 0);
                            else if (forceHiragana)
                            {
                                if (halftoFull)
                                    str = Strings.StrConv(str, VbStrConv.Hiragana | VbStrConv.Wide, 0);
                                else
                                    str = Strings.StrConv(str, VbStrConv.Hiragana, 0);
                            }
                        }
                        outputToConsole(str, line.Function);
                    }
					break;
				case BuiltInFunctionCode.PRINTC:
                case BuiltInFunctionCode.PRINTCD:
				case BuiltInFunctionCode.PRINTLC:
                case BuiltInFunctionCode.PRINTLCD:
				case BuiltInFunctionCode.PRINTFORMC:
                case BuiltInFunctionCode.PRINTFORMCD:
				case BuiltInFunctionCode.PRINTFORMLC:
                case BuiltInFunctionCode.PRINTFORMLCD:
                case BuiltInFunctionCode.PRINTCK:
                case BuiltInFunctionCode.PRINTLCK:
                case BuiltInFunctionCode.PRINTFORMCK:
                case BuiltInFunctionCode.PRINTFORMLCK:
					{
                        if (skipPrint)
                            break;
                        console.UseUserStyle = !BuiltInFunctionManager.IsPrintDFunction(line.Function);
                        term = ((ExpressionArgument)line.Argument).Term;
						str = eEvaluator.GetString(term);
                        if (BuiltInFunctionManager.IsPrintKFunction(line.Function) && (forceHiragana | forceKatakana | halftoFull))
                        {
                            if (forceKatakana)
                                str = Strings.StrConv(str, VbStrConv.Katakana, 0);
                            else if (forceHiragana)
                            {
                                if (halftoFull)
                                    str = Strings.StrConv(str, VbStrConv.Hiragana | VbStrConv.Wide, 0);
                                else
                                    str = Strings.StrConv(str, VbStrConv.Hiragana, 0);
                            }
                        } 
                        if ((line.Function == BuiltInFunctionCode.PRINTFORMC)
							||(line.Function == BuiltInFunctionCode.PRINTC)
                            ||(line.Function == BuiltInFunctionCode.PRINTCD)
                            ||(line.Function == BuiltInFunctionCode.PRINTFORMCD))
							console.PrintC(str, true);
						else
							console.PrintC(str, false);
                        console.UseUserStyle = true;
                    }
					break;
				case BuiltInFunctionCode.PRINTBUTTON://ϐ̓e
					{
                        if (skipPrint)
                            break;
                        SpButtonArgument bArg = (SpButtonArgument)line.Argument;
						str = eEvaluator.GetString(bArg.PrintStrTerm);
                        if (BuiltInFunctionManager.IsPrintKFunction(line.Function) && (forceHiragana | forceKatakana | halftoFull))
                        {
                            if (forceKatakana)
                                str = Strings.StrConv(str, VbStrConv.Katakana, 0);
                            else if (forceHiragana)
                            {
                                if (halftoFull)
                                    str = Strings.StrConv(str, VbStrConv.Hiragana | VbStrConv.Wide, 0);
                                else
                                    str = Strings.StrConv(str, VbStrConv.Hiragana, 0);
                            }
                        } 
                        if (bArg.ButtonWord.GetOperandType() == typeof(long))
							console.PrintButton(str,  eEvaluator.GetInteger(bArg.ButtonWord));
						else
							console.PrintButton(str, eEvaluator.GetString(bArg.ButtonWord));
					}
					break;
                case BuiltInFunctionCode.PRINTDATA:
                case BuiltInFunctionCode.PRINTDATAD:
                case BuiltInFunctionCode.PRINTDATAL:
                case BuiltInFunctionCode.PRINTDATADL:
                case BuiltInFunctionCode.PRINTDATAW:
                case BuiltInFunctionCode.PRINTDATADW:
                case BuiltInFunctionCode.PRINTDATAK:
                case BuiltInFunctionCode.PRINTDATAKL:
                case BuiltInFunctionCode.PRINTDATAKW:
                    {
                        if (skipPrint)
                            break;
                        console.UseUserStyle = !BuiltInFunctionManager.IsPrintDFunction(line.Function);
                        int count = line.dataList.Count;
                        int choice = (int)vEvaluator.GetNextRand(count);
                        VariableToken iTerm = ((PrintDataArgument)line.Argument).Var;
                        if (iTerm != null)
                            vEvaluator.SetValue(eEvaluator.GetFixedVariable(iTerm), choice);
                        List<InstructionLine> iList = line.dataList[choice];
                        int i = 0;
                        foreach (InstructionLine selectedLine in iList)
                        {
							state.RunningLine = selectedLine;
							if (selectedLine.Argument == null)
								LogicalLineParser.SetArgumentTo(selectedLine, null);
                            term = ((ExpressionArgument)selectedLine.Argument).Term;
                            str = eEvaluator.GetString(term);
                            if (BuiltInFunctionManager.IsPrintKFunction(line.Function) && (forceHiragana | forceKatakana | halftoFull))
                            {
                                if (forceKatakana)
                                    str = Strings.StrConv(str, VbStrConv.Katakana, 0);
                                else if (forceHiragana)
                                {
                                    if (halftoFull)
                                        str = Strings.StrConv(str, VbStrConv.Hiragana | VbStrConv.Wide, 0);
                                    else
                                        str = Strings.StrConv(str, VbStrConv.Hiragana, 0);
                                }
                            } 
                            console.Print(str);
                            if (++i < (int)iList.Count)
                                console.NewLine();
                        }
                        if (BuiltInFunctionManager.IsNewLine(line.Function) || BuiltInFunctionManager.IsWaitInput(line.Function))
                            console.NewLine();
                        if (BuiltInFunctionManager.IsWaitInput(line.Function))
                            console.ReadAnyKey();
                        console.UseUserStyle = true;
                        //Wv邪AꂪAł邱Ƃۏ؁B
                        state.JumpTo(line.JumpTo);
						state.RunningLine = null;
                    }
                    break;
                case BuiltInFunctionCode.ENDDATA:
                    //Ȃ
                    break;
				case BuiltInFunctionCode.CLEARLINE:
					{
                        if (skipPrint)
                            break;
                        ExpressionArgument intExpArg = (ExpressionArgument)line.Argument;
						Int32 delNum = (Int32)eEvaluator.GetInteger(intExpArg.Term);
						console.deleteLine(delNum);
						console.RefreshStrings(false);
					}
					break;
				case BuiltInFunctionCode.REUSELASTLINE:
					{
                        if (skipPrint)
                            break;
                        term = ((ExpressionArgument)line.Argument).Term;
						str = eEvaluator.GetString(term);
						console.PrintTemporaryLine(str);
					}
					break;
				case BuiltInFunctionCode.WAIT://s҂B
                    if (skipPrint)
                        break;
                    console.ReadAnyKey();
					break;
				case BuiltInFunctionCode.TWAIT:
					{
                        if (skipPrint)
                            break;
                        SpSwapCharaArgument arg = (SpSwapCharaArgument)line.Argument;
						Int64 time = eEvaluator.GetInteger(arg.X);
						Int64 flag = eEvaluator.GetInteger(arg.Y);
						console.waitInputWithTimer(time, flag);
						break;
					}
				case BuiltInFunctionCode.INPUT://́B͂RESULTցB
                    if (skipPrint)
                        break;
                    console.ReadInteger();
					break;
				case BuiltInFunctionCode.INPUTS://́B͂RESULTSցB
                    if (skipPrint)
                        break;
                    console.ReadString();
					break;
				case BuiltInFunctionCode.TINPUT:
					{
                        if (skipPrint)
                            break;
                        SpBarArgument arg = (SpBarArgument)line.Argument;
						long x = eEvaluator.GetInteger(arg.Terms[0]);
						long y = eEvaluator.GetInteger(arg.Terms[1]);
						long z = eEvaluator.GetInteger(arg.Terms[2]);
						console.ReadIntegerWithTimer(x, y, z);
                    }
					break;
				case BuiltInFunctionCode.TINPUTS:
					{
                        if (skipPrint)
                            break;
                        SpTInputsArgument arg = (SpTInputsArgument)line.Argument;
						Int64 x = eEvaluator.GetInteger(arg.Time);
						string strs = eEvaluator.GetString(arg.Def);
						Int64 z = eEvaluator.GetInteger(arg.Disp);
						console.ReadStringWithTimer(x, strs, z);
                    }
					break;
				case BuiltInFunctionCode.DRAWLINE://ʂ̍[E[܂----ƐB
                    if (skipPrint)
                        break;
                    console.PrintBar();
					console.NewLine();
					break;
				case BuiltInFunctionCode.CUSTOMDRAWLINE:
					{
                        if (skipPrint)
                            break;
                        term = ((ExpressionArgument)line.Argument).Term;
						str = eEvaluator.GetString(term);
						console.setStBar(str);
						console.PrintBar();
						console.NewLine();
						console.setStBar(Config.Instance.DrawLineString);
					}
					break;
				case BuiltInFunctionCode.BAR://[*****....]̂悤ȃOtBBAR (ϐ) , (ől), ()
				case BuiltInFunctionCode.BARL://stB
					{
                        if (skipPrint)
                            break;
                        SpBarArgument barArg = (SpBarArgument)line.Argument;
						Int64 var = eEvaluator.GetInteger(barArg.Terms[0]);
						Int64 max = eEvaluator.GetInteger(barArg.Terms[1]);
						Int64 length = eEvaluator.GetInteger(barArg.Terms[2]);
						console.Print(createBar(var, max, length));
					}
					if (line.Function == BuiltInFunctionCode.BARL)
						console.NewLine();
					break;
				case BuiltInFunctionCode.TIMES://vZBTIMES (ϐ) , (l)Ƃ`ŎgB
					{
						SpTimesArgument timesArg = (SpTimesArgument)line.Argument;
						VariableToken var = timesArg.VariableDest;
						double d = eEvaluator.GetInteger(var) * timesArg.DoubleValue;
						FixedVariablePointer p = eEvaluator.GetFixedVariable(var);
						unchecked
						{
							vEvaluator.SetValue(p, (Int64)d);
						}
					}
					break;
				case BuiltInFunctionCode.PRINT_ABL://\́B͓o^ԍ
				case BuiltInFunctionCode.PRINT_TALENT://f
				case BuiltInFunctionCode.PRINT_MARK://
				case BuiltInFunctionCode.PRINT_EXP://o
					{
                        if (skipPrint)
                            break;
                        ExpressionArgument intExpArg = (ExpressionArgument)line.Argument;
						Int64 target = eEvaluator.GetInteger(intExpArg.Term);
						console.Print(vEvaluator.GetCharacterDataString(target, line.Function));
						console.NewLine();
					}
					break;
				case BuiltInFunctionCode.PRINT_PALAM://p[^
					{
                        if (skipPrint)
                            break;
                        ExpressionArgument intExpArg = (ExpressionArgument)line.Argument;
						Int64 target = eEvaluator.GetInteger(intExpArg.Term);
						int count = 0;
						///100ȍ~͔ے̎ƂȂ̂ŕ\Ȃ
						for (int i = 0; i < 100; i++)
						{
							string printStr = vEvaluator.GetCharacterParamString(target, i);
							if (printStr != null)
							{
								console.PrintC(printStr, true);
								count++;
								if ((Config.Instance.PrintCPerLine > 0) && (count % Config.Instance.PrintCPerLine == 0))
									console.PrintFlush(false);
							}
						}
						console.PrintFlush(false);
					}
					break;
				case BuiltInFunctionCode.PRINT_ITEM://ACe
                    if (skipPrint)
                        break;
                    console.Print(vEvaluator.GetHavingItemsString());
					console.NewLine();
					break;
				case BuiltInFunctionCode.PRINT_SHOPITEM://VbvŔĂACe
					{
                        if (skipPrint)
                            break;
						int length = Math.Min(vEvaluator.ITEMSALES.Length, vEvaluator.ITEMNAME.Length);
						int count = 0;
						for (int i = 0; i < length; i++)
						{
							if (vEvaluator.ItemSales(i))
							{
								string printStr = vEvaluator.ITEMNAME[i];
								if (printStr == null)
									printStr = "";
								Int64 price = vEvaluator.ITEMPRICE[i];
								// 1.52aϕ@iPʂ̍ւёOuAuɑΉj
								if (Config.Instance.MoneyFirst)
									console.PrintC(string.Format("[{2}] {0}({3}{1})", printStr, price, i, Config.Instance.MoneyLabel), false);
								else
									console.PrintC(string.Format("[{2}] {0}({1}{3})", printStr, price, i, Config.Instance.MoneyLabel), false);
								count++;
								if ((Config.Instance.PrintCPerLine > 0) && (count % Config.Instance.PrintCPerLine == 0))
									console.PrintFlush(false);
							}
						}
						console.PrintFlush(false);
					}
					break;
				case BuiltInFunctionCode.UPCHECK://p[^̕ϓ
                    if (skipPrint)
                        break;
                    vEvaluator.UpdateInUpcheck(console);
					break;
				case BuiltInFunctionCode.ADDCHARA://(Lԍ)̃LN^ǉ
				case BuiltInFunctionCode.ADDSPCHARA://(Lԍ)SPLN^ǉitO01ɂč쐬j
				case BuiltInFunctionCode.DELCHARA://(Lo^ԍ)̃LN^폜B
					{
						ExpressionArgument intExpArg = (ExpressionArgument)line.Argument;
						Int64 integer = eEvaluator.GetInteger(intExpArg.Term);
						if (line.Function == BuiltInFunctionCode.ADDCHARA)
							vEvaluator.AddCharacter(integer, false);
						else if (line.Function == BuiltInFunctionCode.ADDSPCHARA)
							vEvaluator.AddCharacter(integer, true);
						else
							vEvaluator.DelCharacter(integer);
					}
					break;
				case BuiltInFunctionCode.DELALLCHARA:
					{
						vEvaluator.DelAllCharacter();
						break;
					}
                case BuiltInFunctionCode.ADDDEFCHARA:
                    {
                        if (state.Scope != "SYSTEM_TITLE")
                            throw new CodeEE("@SYSTEM_TITLEȊOł̖߂gƂ͂ł܂");
                        vEvaluator.AddCharacterFromCsvNo(0);
                        if (Process.instance.gamebase.DefaultCharacter > 0)
                            vEvaluator.AddCharacterFromCsvNo(Process.instance.gamebase.DefaultCharacter);
                        break;
                    }
                case BuiltInFunctionCode.ADDVOIDCHARA:
                    {
                        vEvaluator.AddPseudoCharacter();
                    }
                    break;
				case BuiltInFunctionCode.PUTFORM://@SAVEINFO֐ł̂ݎgp\BPRINTFORMƓl̏ŃZ[uf[^ɊTvB
					{
						term = ((ExpressionArgument)line.Argument).Term;
						str = eEvaluator.GetString(term);
						if (vEvaluator.SAVEDATA_TEXT != null)
							vEvaluator.SAVEDATA_TEXT += str;
						else
							vEvaluator.SAVEDATA_TEXT = str;
						break;
					}
				case BuiltInFunctionCode.QUIT://Q[I
					console.Quit();
					break;


				case BuiltInFunctionCode.STRLEN://RESULTɕioCgj
				//case BuiltInFunctionCode.STRLENS:
				case BuiltInFunctionCode.STRLENFORM:
					term = ((ExpressionArgument)line.Argument).Term;
					str = eEvaluator.GetString(term);
					this.vEvaluator.RESULT = ShiftJisManager.GetStrlenShiftJis(str);
					break;

                case BuiltInFunctionCode.STRLENU://RESULTɕioCgj
                case BuiltInFunctionCode.STRLENFORMU:
                    term = ((ExpressionArgument)line.Argument).Term;
                    str = eEvaluator.GetString(term);
                    this.vEvaluator.RESULT = str.Length;
                    break;

				case BuiltInFunctionCode.SWAPCHARA:
					{
						SpSwapCharaArgument arg = (SpSwapCharaArgument)line.Argument;
						long x = eEvaluator.GetInteger(arg.X);
						long y = eEvaluator.GetInteger(arg.Y);
						vEvaluator.SwapChara(x, y);
					}
					break;
				case BuiltInFunctionCode.SORTCHARA:
					{
						SpSortcharaArgument spSortArg = (SpSortcharaArgument)line.Argument;
						Int64 elem = 0;
						if (spSortArg.SortKey.Element2 != null)
							elem = eEvaluator.GetInteger(spSortArg.SortKey.Element2);
						vEvaluator.SortChara(spSortArg.SortKey.Identifier, elem, spSortArg.SortOrder, true);
					}
					break;
				case BuiltInFunctionCode.VARSIZE:
					{
						SpVarsizeArgument versizeArg = (SpVarsizeArgument)line.Argument;
						VariableIdentifier varID = versizeArg.VariableID;
						vEvaluator.VarSize(varID);
					}
					break;
				case BuiltInFunctionCode.SAVEDATA:
					{
						SpSaveDataArgument spSavedataArg = (SpSaveDataArgument)line.Argument;
						Int64 target = eEvaluator.GetInteger(spSavedataArg.Target);
						if (target < 0)
							throw new CodeEE("SAVEDATÄɕ̒l(" + target.ToString() + ")w肳܂");
						else if (target > int.MaxValue)
							throw new CodeEE("SAVEDATÄ(" + target.ToString() + ")傫܂");
						string savemes = eEvaluator.GetString(spSavedataArg.StrExpression);
						saveTo((int)target, savemes);
					}
					break;
				case BuiltInFunctionCode.DELDATA:
					{
						ExpressionArgument intExpArg = (ExpressionArgument)line.Argument;
						Int64 target = eEvaluator.GetInteger(intExpArg.Term);
						if (target < 0)
							throw new CodeEE("DELDATÄɕ̒l(" + target.ToString() + ")w肳܂");
						else if (target > int.MaxValue)
							throw new CodeEE("DELDATÄ(" + target.ToString() + ")傫܂");
						delData((int)target);
					}
					break;
				case BuiltInFunctionCode.CHKDATA:
					{
						ExpressionArgument intExpArg = (ExpressionArgument)line.Argument;
						Int64 target = eEvaluator.GetInteger(intExpArg.Term);
						if (target < 0)
							throw new CodeEE("CHKDATÄɕ̒l(" + target.ToString() + ")w肳܂");
						else if (target > int.MaxValue)
							throw new CodeEE("CHKDATÄ(" + target.ToString() + ")傫܂");
						EraDataResult result = checkData((int)target);
						vEvaluator.RESULT = (long)result.State;
						vEvaluator.RESULTS = result.DataMes;
					}
					break;
				case BuiltInFunctionCode.SAVEGLOBAL:
					saveGlobal();
					break;
				case BuiltInFunctionCode.LOADGLOBAL:
					if (loadGlobal())
						vEvaluator.RESULT = 1;
					else
						vEvaluator.RESULT = 0;
					break;
				case BuiltInFunctionCode.POWER:
					{
						SpPowerArgument powerArg = (SpPowerArgument)line.Argument;
						FixedVariablePointer p = eEvaluator.GetFixedVariable(powerArg.VariableDest);
						double x = eEvaluator.GetInteger(powerArg.X);
						double y = eEvaluator.GetInteger(powerArg.Y);
						double pow = Math.Pow(x, y);
						if (double.IsNaN(pow))
							throw new CodeEE("ݏ挋ʂ񐔒lł");
						else if (double.IsInfinity(pow))
							throw new CodeEE("ݏ挋ʂł");
						else if ((pow >= Int64.MaxValue) || (pow <= Int64.MinValue))
							throw new CodeEE("ݏ挋(" + pow.ToString() + ")64rbgt͈̔͊Oł");
						vEvaluator.SetValue(p, (long)pow);
						break;
					}
				case BuiltInFunctionCode.SWAP:
					{
						SpSwapVarArgument arg = (SpSwapVarArgument)line.Argument;
						FixedVariablePointer p1 = eEvaluator.GetFixedVariable(arg.var1);
						FixedVariablePointer p2 = eEvaluator.GetFixedVariable(arg.var2);
						if (arg.var1.GetOperandType() != arg.var2.GetOperandType())
							throw new CodeEE("ւϐ̌^قȂ܂");
						if (arg.var1.GetOperandType() == typeof(Int64))
						{
                            Int64 temp = vEvaluator.GetInteger(p1);
                            vEvaluator.SetValue(p1, vEvaluator.GetInteger(p2));
							vEvaluator.SetValue(p2, temp);
						}
						else if (arg.var1.GetOperandType() == typeof(string))
						{
                            string temps = vEvaluator.GetString(p1);
                            vEvaluator.SetValue(p1, vEvaluator.GetString(p2));
							vEvaluator.SetValue(p2, temps);
						}
						else
						{
							throw new CodeEE("sȕϐ^ł");
						}
						break;
					}
				case BuiltInFunctionCode.GETTIME:
					{
						long date = DateTime.Now.Year;
						date = date * 100 + DateTime.Now.Month;
						date = date * 100 + DateTime.Now.Day;
						date = date * 100 + DateTime.Now.Hour;
						date = date * 100 + DateTime.Now.Minute;
						date = date * 100 + DateTime.Now.Second;
						date = date * 1000 + DateTime.Now.Millisecond;
						vEvaluator.RESULT = date;//17B2炢B
                        vEvaluator.RESULTS = DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss");
					}
					break;
				case BuiltInFunctionCode.SETCOLOR:
					{
						SpColorArgument colorArg = (SpColorArgument)line.Argument;
						Int64 colorR;
						Int64 colorG;
						Int64 colorB;
						if (colorArg.RGB != null)
						{
							Int64 colorRGB = eEvaluator.GetInteger(colorArg.RGB);
							colorR = (colorRGB & 0xFF0000) >> 16;
							colorG = (colorRGB & 0x00FF00) >> 8;
							colorB = (colorRGB & 0x0000FF);
						}
						else
						{
							colorR = eEvaluator.GetInteger(colorArg.R);
							colorG = eEvaluator.GetInteger(colorArg.G);
							colorB = eEvaluator.GetInteger(colorArg.B);
							if ((colorR < 0) || (colorG < 0) || (colorB < 0))
								throw new CodeEE("SETCOLOR̈0̒lw肳܂");
							if ((colorR > 255) || (colorG > 255) || (colorB > 255))
								throw new CodeEE("SETCOLOR̈255𒴂lw肳܂");
						}
						Color c = Color.FromArgb((Int32)colorR, (Int32)colorG, (Int32)colorB);
						console.SetStringStyle(c);
					}
					break;
				case BuiltInFunctionCode.RESETCOLOR:
					console.SetStringStyle(Config.Instance.ForeColor);
					break;
				case BuiltInFunctionCode.FONTBOLD:
					console.SetStringStyle(console.StringStyle.FontStyle | FontStyle.Bold);
					break;
				case BuiltInFunctionCode.FONTITALIC:
					console.SetStringStyle(console.StringStyle.FontStyle | FontStyle.Italic);
					break;
				case BuiltInFunctionCode.FONTREGULAR:
					console.SetStringStyle(FontStyle.Regular);
					break;
				case BuiltInFunctionCode.FONTSTYLE:
					{
						FontStyle fs = FontStyle.Regular;
						Int64 i = eEvaluator.GetInteger(((ExpressionArgument)line.Argument).Term);
						if ((i & 1) != 0)
							fs |= FontStyle.Bold;
						if ((i & 2) != 0)
							fs |= FontStyle.Italic;
						if ((i & 4) != 0)
							fs |= FontStyle.Strikeout;
						if ((i & 8) != 0)
							fs |= FontStyle.Underline;
						console.SetStringStyle(fs);
					}
					break;
				case BuiltInFunctionCode.SETFONT:
					term = ((ExpressionArgument)line.Argument).Term;
					console.SetFont(eEvaluator.GetString(term));
					break;
				case BuiltInFunctionCode.ALIGNMENT:
					str = line.ArgumentStr;
					if (Config.Instance.IgnoreCase)
						str = str.ToUpper();
					if (!Enum.IsDefined(typeof(DisplayLineAlignment), str))
						throw new CodeEE("ALIGNMENT̃L[[h\"" + str + "\"͖`ł");
					console.Alignment = (DisplayLineAlignment)Enum.Parse(typeof(DisplayLineAlignment), str);
					break;
				case BuiltInFunctionCode.RESETDATA:
					vEvaluator.ResetData();
                    console.ResetStyle();
                    break;
				case BuiltInFunctionCode.RESETGLOBAL:
					vEvaluator.ResetGlobalData();
					break;
				case BuiltInFunctionCode.RANDOMIZE:
					vEvaluator.Randomize(eEvaluator.GetInteger(((ExpressionArgument)line.Argument).Term));
					break;
				case BuiltInFunctionCode.INITRAND:
					vEvaluator.InitRanddata();
					break;
				case BuiltInFunctionCode.DUMPRAND:
					vEvaluator.DumpRanddata();
					break;
				case BuiltInFunctionCode.REDRAW:
					console.SetRedraw(eEvaluator.GetInteger(((ExpressionArgument)line.Argument).Term));
					break;
                case BuiltInFunctionCode.SETBIT:
                case BuiltInFunctionCode.CLEARBIT:
                case BuiltInFunctionCode.INVERTBIT:
                    {
                        BitArgument spsetarg = (BitArgument)line.Argument;
                        FixedVariablePointer p = eEvaluator.GetFixedVariable(spsetarg.VariableDest);
                        Int64 x = eEvaluator.GetInteger(spsetarg.Term);
                        if ((x < 0) || (x > 63))
                            throw new CodeEE("2rbg̃W(063)𒴂Ă܂");
                        Int64 baseValue = vEvaluator.GetInteger(p);
                        Int64 shift = 1L << (int)x;
                        if (line.Function == BuiltInFunctionCode.SETBIT)
                            baseValue |= shift;
                        else if (line.Function == BuiltInFunctionCode.CLEARBIT)
                            baseValue &= ~shift;
                        else
                            baseValue ^= shift;
                        vEvaluator.SetValue(p, baseValue);
                    }
                    break;
				case BuiltInFunctionCode.VARSET:
					{
						SpVarSetArgument spvarsetarg = (SpVarSetArgument)line.Argument;
						FixedVariablePointer p = eEvaluator.GetFixedVariable(spvarsetarg.VariableDest);
                        int start = 0;
                        if (spvarsetarg.Start != null)
                            start = (int)eEvaluator.GetInteger(spvarsetarg.Start);
                        int end = 0;
                        if (spvarsetarg.End != null)
                            end = (int)eEvaluator.GetInteger(spvarsetarg.End);
                        else if (spvarsetarg.VariableDest.Identifier.IsArray1D)
                            end = (int)eEvaluator.VEvaluator.GetVariableSize(p.ID);
                        if (start > end)
                        {
                            int temp = start;
                            start = end;
                            end = start;
                        }
                        if (p.ID.IsString)
						{
							string src = eEvaluator.GetString(spvarsetarg.Term);
							vEvaluator.SetValueAll(p, src, start, end);
						}
						else
						{
							long src = eEvaluator.GetInteger(spvarsetarg.Term);
                            vEvaluator.SetValueAll(p, src, start, end);
						}
					}
					break;
                case BuiltInFunctionCode.CVARSET:
                    {
                        SpCVarSetArgument spvarsetarg = (SpCVarSetArgument)line.Argument;
                        FixedVariablePointer p = eEvaluator.GetFixedVariable(spvarsetarg.VariableDest);
                        SingleTerm index = eEvaluator.GetValue(spvarsetarg.Index);
                        int charaNum = (int)eEvaluator.VEvaluator.GetInteger(eEvaluator.GetFixedVariable(new VariableToken(VariableIdentifier.GetVariableId("CHARANUM"), new SingleTerm(0), new SingleTerm(0), new SingleTerm(0))));
                        int start = 0;
                        if (spvarsetarg.Start != null)
                        {
                            start = (int)eEvaluator.GetInteger(spvarsetarg.Start);
                            if (start < 0 || start >= charaNum)
                                throw new CodeEE("CVARSET̑S(" + start.ToString() + ")LN^͈̔͊Oł");
                        }
                        int end = 0;
                        if (spvarsetarg.End != null)
                        {
                            end = (int)eEvaluator.GetInteger(spvarsetarg.End);
                            if (end < 0 || end > charaNum)
                                throw new CodeEE("CVARSET̑T(" + end.ToString() + ")LN^͈̔͊Oł");
                        }
                        else
                            end = charaNum;
                        if (start > end)
                        {
                            int temp = start;
                            start = end;
                            end = start;
                        }
                        if (!p.ID.IsCharacterData)
                            throw new CodeEE("CVARSETɃLN^ϐłȂϐ" + p.ID.ToString() + "n܂");
                        if (index.GetOperandType() == typeof(string) && p.ID.IsArray1D)
                        {
                            if (!ConstantData.isDefined(p.ID.Code, index.Str))
                                throw new CodeEE("" + index.Str + "͔zϐ" + p.ID.Code.ToString() + "̗vfł͂܂");
                        }
                        if (p.ID.IsString)
                        {
                            string src = eEvaluator.GetString(spvarsetarg.Term);
                            vEvaluator.SetValueAllEachChara(p, index, src, start, end);
                        }
                        else
                        {
                            long src = eEvaluator.GetInteger(spvarsetarg.Term);
                            vEvaluator.SetValueAllEachChara(p, index, src, start, end);
                        }
                    }
                    break;
                case BuiltInFunctionCode.RESET_STAIN:
                    {
                        ExpressionArgument expArg = (ExpressionArgument)line.Argument;
                        Int64 no = eEvaluator.GetInteger(expArg.Term);
                        vEvaluator.setDefaultStain(no);
                    }
                    break;
                case BuiltInFunctionCode.SPLIT:
                    {
                        SpSplitArgument spSplitArg = (SpSplitArgument)line.Argument;
                        FixedVariablePointer p;
                        string target = eEvaluator.GetString(spSplitArg.TargetStr);
                        string[] split = new string[] { eEvaluator.GetString(spSplitArg.Split) };
                        string[] retStr = target.Split(split, StringSplitOptions.None);
                        for (int i = 0; i < retStr.Length; i++)
                        {
                            p = eEvaluator.GetFixedVariable(VariableParser.ReduceVariable(spSplitArg.Var, new SingleTerm(i), null, null));
                            vEvaluator.SetValue(p, retStr[i]);
                        }
                        vEvaluator.RESULT = retStr.Length;
                    }
                    break;
                case BuiltInFunctionCode.PRINTCPERLINE:
                    {
                        SpGetIntArgument spGetintArg = (SpGetIntArgument)line.Argument;
                        FixedVariablePointer p = eEvaluator.GetFixedVariable(spGetintArg.VarToken);
                        vEvaluator.SetValue(p, (Int64)Config.Instance.PrintCPerLine);
                    }
                    break;
                case BuiltInFunctionCode.SAVENOS:
                    {
                        SpGetIntArgument spGetintArg = (SpGetIntArgument)line.Argument;
                        FixedVariablePointer p = eEvaluator.GetFixedVariable(spGetintArg.VarToken);
                        vEvaluator.SetValue(p, (Int64)Config.Instance.SaveDataNos);
                    }
                    break;
                case BuiltInFunctionCode.FORCEKANA:
                    {
                        ExpressionArgument arg = (ExpressionArgument)line.Argument;
                        Int64 flag = eEvaluator.GetInteger(arg.Term);
                        if (flag < 0 || flag > 3)
                            throw new CodeEE("FORCEKANÄw\Ȕ͈(0`3)𒴂Ă܂");
                        forceKatakana = (flag == 1) ? true : false;
                        forceHiragana = (flag > 1) ? true : false;
                        halftoFull = (flag == 3) ? true : false;
                    }
                    break;
                case BuiltInFunctionCode.CALLF:
                    {
                        string label = ((SpCallArgment)line.Argument).Str;
                        if (Config.Instance.IgnoreCase)
                            label = label.ToUpper();
                        IOperandTerm mToken = FunctionMethodCreator.GetFunctionMethod(labelDic, label, ((SpCallArgment)line.Argument).Args);
                        if (mToken == null)
                            throw new CodeEE("֐\"@" + label + "\"܂");
                        eEvaluator.GetValue(mToken);
                        break;
                    }
                case BuiltInFunctionCode.CALLFORMF:
                    {
                        SpCallformArgment spCallformArg = (SpCallformArgment)line.Argument;
                        StringForm strForm = spCallformArg.StrForm;
                        string label = strForm.GetString(eEvaluator).Trim();
                        if (Config.Instance.IgnoreCase)
                            label = label.ToUpper();
                        IOperandTerm mToken = FunctionMethodCreator.GetFunctionMethod(labelDic, label, spCallformArg.Args);
                        if (mToken == null)
                            throw new CodeEE("֐\"@" + label + "\"܂");
                        eEvaluator.GetValue(mToken);
                        break;
                    }
                default:
					throw new ExeEE("`̊֐");
			}
			return;
		}

        private void outputToConsole(string str, BuiltInFunctionCode func)
        {
            if (BuiltInFunctionManager.IsPrintSingle(func))
                console.PrintLine(str);
            else
            {
                console.Print(str);
                if (BuiltInFunctionManager.IsNewLine(func) || BuiltInFunctionManager.IsWaitInput(func))
                    console.NewLine();
                if (BuiltInFunctionManager.IsWaitInput(func))
                    console.ReadAnyKey();
            }
            console.UseUserStyle = true;
        }

		private string createBar(Int64 var, Int64 max, Int64 length)
		{
			if (max <= 0)
				throw new CodeEE("BAR̍ől̒lł͂܂");
			if (length <= 0)
				throw new CodeEE("BAR̒̒lł͂܂");
			if (length >= 100)//\h߁B
				throw new CodeEE("BAR܂");
			StringBuilder builder = new StringBuilder();
			builder.Append('[');
			int count;
			unchecked
			{
				count = (int)(var * length / max);
			}
			if (count < 0)
				count = 0;
			if (count > length)
				count = (int)length;
			builder.Append(Config.Instance.BarChar1, count);
			builder.Append(Config.Instance.BarChar2, (int)length - count);
			builder.Append(']');
			return builder.ToString();
		}

        bool forceKatakana = false;
        bool forceHiragana = false;
        bool halftoFull = false;
		#endregion

		#region flow control

		bool doFlowControlFunction(InstructionLine func, bool sequential)
		{
            StringStream st = new StringStream(func.ArgumentStr);
            ExpressionArgument expArg = null;
            switch (func.Function)
            {
                case BuiltInFunctionCode.BEGIN://VXe֐̎sB
                    string keyword = func.ArgumentStr;
                    if (Config.Instance.IgnoreCase)
                        keyword = keyword.ToUpper();
                    if (!Enum.IsDefined(typeof(BeginType), keyword))
                        throw new CodeEE("BEGIÑL[[h\"" + keyword + "\"͖`ł");
                    state.SetBegin((BeginType)Enum.Parse(typeof(BeginType), keyword));
                    state.Return(0);
                    console.ResetStyle();
                    return false;
                case BuiltInFunctionCode.SAVEGAME://Z[uʂĂԁBVbv̂݁B
                    saveCurrentState(true);
                    state.SaveLoadData(true);
                    return false;
                case BuiltInFunctionCode.LOADGAME://
                    saveCurrentState(true);
                    state.SaveLoadData(false);
                    return false;

                //case BuiltInFunctionCode.SIF://ŝIF
                //    expArg = (ExpressionArgument)func.Argument;
                //    if (eEvaluator.GetInteger(expArg.Term) != 0)//]^Ȃ炻̂܂ܗꗎ
                //        break;
                //    state.ShfitNextLine();//UȂsƂ΂BɗƂƓɂ
                //    break;
                //case BuiltInFunctionCode.IF:
                //    {//1.723 dlύX
                //        LogicalLine ifJumpto = null;
                //        if (func.IfCaseList == null)
                //            throw new ExeEE("IFIF-ELSEIFXgKɍ쐬ĂȂ");
                //        if (func.JumpTo == null)
                //            throw new ExeEE("IFɑΉENDIFݒ肳ĂȂ");

                //        for (int i = 0; i < func.IfCaseList.Count; i++)
                //        {
                //            if (func.IfCaseList[i].IsError)
                //                continue;
                //            if (func.IfCaseList[i].Function == BuiltInFunctionCode.ELSE)
                //            {
                //                ifJumpto = func.IfCaseList[i];
                //                break;
                //            }

                //            expArg = (ExpressionArgument)(func.IfCaseList[i].Argument);
                //            if (expArg == null)
                //                throw new ExeEE("IF`FbNB͂ĂȂB", func.IfCaseList[i].Position);

                //            //1730 ELSEIFoG[IF̃G[ƂČoĂ
                //            state.RunningLine = func.IfCaseList[i];
                //            if (eEvaluator.GetInteger(expArg.Term) != 0)//^
                //            {
                //                ifJumpto = func.IfCaseList[i];
                //                break;
                //            }
                //        }
                //        if (ifJumpto == null)
                //            ifJumpto = func.JumpTo;//ENDIF
                //        if (ifJumpto != func)//gWvȂ炻̂܂
                //            state.JumpTo(ifJumpto);
                //        state.RunningLine = null;
                //    }
                //    break;
                //case BuiltInFunctionCode.SELECTCASE:
                //    {//1.724 ǉ
                //        LogicalLine caseJumpto = null;
                //        SingleTerm term = eEvaluator.GetValue(((ExpressionArgument)func.Argument).Term);
                //        if (func.IfCaseList == null)
                //            throw new ExeEE("SELECTCASECASEXgKɍ쐬ĂȂ");
                //        if (func.JumpTo == null)
                //            throw new ExeEE("SELECTCASEɑΉENDSELECTݒ肳ĂȂ");
                //        for (int i = 0; i < func.IfCaseList.Count; i++)
                //        {
                //            if (func.IfCaseList[i].IsError)
                //                continue;
                //            if (func.IfCaseList[i].Function == BuiltInFunctionCode.CASEELSE)
                //            {
                //                caseJumpto = func.IfCaseList[i];
                //                break;
                //            }
                //            CaseArgument caseArg = (CaseArgument)(func.IfCaseList[i].Argument);
                //            if (caseArg == null)
                //                throw new ExeEE("CASE`FbNB͂ĂȂB", func.IfCaseList[i].Position);

                //            //1730 CASEoG[SELECTCASẼG[ƂČoĂ
                //            state.RunningLine = func.IfCaseList[i];
                //            foreach (CaseExpression caseExp in caseArg.CaseExps)
                //            {
                //                if (eEvaluator.GetCase(caseExp, term))
                //                {
                //                    caseJumpto = func.IfCaseList[i];
                //                    goto casefound;
                //                }
                //            }
                //        }
                //    casefound:
                //        if (caseJumpto == null)
                //            caseJumpto = func.JumpTo;//ENDSELECT
                //        state.JumpTo(caseJumpto);
                //        state.RunningLine = null;
                //    }
                //    break;
                //case BuiltInFunctionCode.ELSE:
                //case BuiltInFunctionCode.ELSEIF:
                //case BuiltInFunctionCode.CASE:
                //case BuiltInFunctionCode.CASEELSE:
                //    if (sequential)//ڗȂENDIF
                //    {
                //        if (func.JumpTo == null)
                //            throw new ExeEE(func.Function.ToString() + "̃Wv悪ݒ肳ĂȂ");
                //        state.JumpTo(func.JumpTo);
                //        break;
                //    }
                    //else//IF΂ꂽȂ炻̂܂܎
                    //{//1.723 ELSEIF̏IFōsB
                    //    break;
                    //}
                //case BuiltInFunctionCode.ENDIF:
                //case BuiltInFunctionCode.ENDSELECT:
                //case BuiltInFunctionCode.ENDCATCH:
                //case BuiltInFunctionCode.ENDFUNC:
                //case BuiltInFunctionCode.DO:
                //    break;//ENDIF, ENDSELECTłׂƂ͓ɖ

                case BuiltInFunctionCode.REPEAT://REND܂ŌJԂBJԂ񐔂COUNTցBlXgsB
                case BuiltInFunctionCode.FOR://NEXT܂ŌJԂBJE^[ϐݒ\BlXgB
                    //if (sequential)//ォ痈Ȃ񐔂̃Zbg
                    //{
                    if (func.Function == BuiltInFunctionCode.FOR)
                    {
                        SpForNextArgment forArg = (SpForNextArgment)func.Argument;
                        func.LoopCounter = eEvaluator.GetFixedVariable(forArg.Cnt);
                        //1.725 ύXBREPEATɂȂ炤B
                        vEvaluator.SetValue(func.LoopCounter, eEvaluator.GetInteger(forArg.Start));
                        func.LoopEnd = eEvaluator.GetInteger(forArg.End);
                        func.LoopStep = eEvaluator.GetInteger(forArg.Step);
                    }
                    else
                    {
                        expArg = (ExpressionArgument)func.Argument;
                        FixedVariablePointer count = new FixedVariablePointer();
                        count.ID = VariableIdentifier.GetVariableId(VariableCode.COUNT);
                        count.Index1 = 0;
                        //1.725 ύXBeramakerł͈]̑OCOUNT0ĂB
                        vEvaluator.SetValue(count, 0);
                        func.LoopEnd = eEvaluator.GetInteger(expArg.Term);
                        func.LoopCounter = count;
                        func.LoopStep = 1;
                    }
                    //}
                    //else//iRENDACONTINUEjłȂJE^[̑
                    //{
                    //    unchecked
                    //    {
                    //        vEvaluator.SetValue(func.LoopCounter, vEvaluator.GetInteger(func.LoopCounter) + func.LoopStep);
                    //    }
                    //}
                    if ((func.LoopStep > 0) && (func.LoopEnd > vEvaluator.GetInteger(func.LoopCounter)))//܂񐔂cĂȂA
                        break;//̂܂܎̍s
                    else if ((func.LoopStep < 0) && (func.LoopEnd < vEvaluator.GetInteger(func.LoopCounter)))//܂񐔂cĂȂA
                        break;//̂܂܎̍s
                    state.JumpTo(func.JumpTo);
                    break;
                case BuiltInFunctionCode.WHILE://WEND܂ŌJԂA^ꂽ𖞂薳ɌJԂBlXg
                    {
                        expArg = (ExpressionArgument)func.Argument;
                        if (eEvaluator.GetInteger(expArg.Term) != 0)//^
                            break;//̂܂ܒ̏
                        state.JumpTo(func.JumpTo);
                        break;
                    }
                //case BuiltInFunctionCode.NEXT://NEXTɖ߂
                //case BuiltInFunctionCode.REND://REPEATɖ߂
                //    {
                //        InstructionLine jumpLine = (InstructionLine)func.JumpTo;
                //        unchecked
                //        {
                //            vEvaluator.SetValue(jumpLine.LoopCounter, vEvaluator.GetInteger(jumpLine.LoopCounter) + jumpLine.LoopStep);
                //        }
                //        if (((jumpLine.LoopStep > 0) && (jumpLine.LoopEnd > vEvaluator.GetInteger(jumpLine.LoopCounter)))
                //            || ((jumpLine.LoopStep < 0) && (jumpLine.LoopEnd < vEvaluator.GetInteger(jumpLine.LoopCounter))))//܂񐔂cĂȂA
                //            state.JumpTo(func.JumpTo);
                //    }
                //    break;
                //case BuiltInFunctionCode.WEND://WHILEɖ߂
                //    if (!sequential)//REPEATAFORAWHILEABREAKłȂ
                //        break;
                //    //ŗȂREPEATAFORAWHILEɋABJԂ񐔂̋Lƃ`FbNREPEATAFORsB
                //    state.JumpTo(func.JumpTo);
                //    break;
                //case BuiltInFunctionCode.BREAK://REND܂ŃWv
                //    {
                //        ////BREAKJUMPREND܂NEXTB̃WvłREPEATFORiLineɑB
                //        //1.723 dlύXBBREAKJUMPɂREPEATAFORAWHILELBJUMP悪{JUMPB
                //        InstructionLine iJumpTo = (InstructionLine)func.JumpTo;
                //        InstructionLine iLine = (InstructionLine)iJumpTo.JumpTo;
                //        //WHILEDO̓JE^Ȃ̂ŁAWv
                //        if (iJumpTo.Function == BuiltInFunctionCode.WHILE || iJumpTo.Function == BuiltInFunctionCode.DO)
                //        {
                //            state.JumpTo(iLine);
                //            break;
                //        }
                //        unchecked
                //        {//{ƂłBREAKCOUNT
                //            vEvaluator.SetValue(iJumpTo.LoopCounter, vEvaluator.GetInteger(iJumpTo.LoopCounter) + iJumpTo.LoopStep);
                //        }
                //        state.JumpTo(iLine);
                //        break;
                //    }
                //case BuiltInFunctionCode.CONTINUE://REPEATɖ߂
                //    {
                //        InstructionLine jumpTo = (InstructionLine)func.JumpTo;
                //        if (jumpTo.Function == BuiltInFunctionCode.WEND)
                //        {
                //            expArg = (ExpressionArgument)jumpTo.Argument;
                //            if (eEvaluator.GetInteger(expArg.Term) != 0)//^
                //                state.JumpTo(func.JumpTo);
                //            else
                //                state.JumpTo(jumpTo.JumpTo);
                //        }
                //        else
                //        {
                //            unchecked
                //            {
                //                vEvaluator.SetValue(jumpTo.LoopCounter, vEvaluator.GetInteger(jumpTo.LoopCounter) + jumpTo.LoopStep);
                //            }
                //            if (((jumpTo.LoopStep > 0) && (jumpTo.LoopEnd > vEvaluator.GetInteger(jumpTo.LoopCounter)))
                //                || ((jumpTo.LoopStep < 0) && (jumpTo.LoopEnd < vEvaluator.GetInteger(jumpTo.LoopCounter))))//܂񐔂cĂȂA
                //                state.JumpTo(func.JumpTo);
                //            else
                //                state.JumpTo(jumpTo.JumpTo);
                //        }
                //    }
                //    break;
                case BuiltInFunctionCode.GOTO://$xփWv
                case BuiltInFunctionCode.TRYGOTO:
                case BuiltInFunctionCode.TRYCGOTO:
                //case BuiltInFunctionCode.RESTART://֐̍ĊJB֐̍ŏɖ߂B
                    if (func.JumpTo == null)
                    {
                        if (func.Function == BuiltInFunctionCode.TRYGOTO)
                            break;
                        else if (func.Function == BuiltInFunctionCode.TRYCGOTO)
                        {
                            if (func.JumpToEndCatch != null)
                                state.JumpTo(func.JumpToEndCatch);
                        }
                        if (func.Function == BuiltInFunctionCode.GOTO)
                            throw new CodeEE("x\"$" + func.ArgumentStr + "\"܂");
                        throw new ExeEE("Wv悪K؂ɐݒ肳ĂȂ");
                    }
                    state.JumpTo(func.JumpTo);
                    break;
                case BuiltInFunctionCode.JUMP://֐Ɉړ
                case BuiltInFunctionCode.TRYJUMP:
                case BuiltInFunctionCode.TRYCJUMP:
                    {
                        if (func.JumpTo == null)
                        {
                            if (func.Function == BuiltInFunctionCode.TRYJUMP)
                                break;
                            else if (func.Function == BuiltInFunctionCode.TRYCJUMP)
                            {
                                if (func.JumpToEndCatch != null)
                                    state.JumpTo(func.JumpToEndCatch);
                            }
                            throw new CodeEE("֐\"@" + ((SpCallArgment)func.Argument).Str + "\"܂");
                        }
                        assignArgs((FunctionLabelLine)func.JumpTo, ((SpCallArgment)func.Argument).Args);
                        string label = ((SpCallArgment)func.Argument).Str;
                        CalledFunction call = CalledFunction.CallFunction(this, label, state.GetCurrentReturnAddress, false);
                        state.ChangeCurrentFunction(call);
                        state.JumpTo(func.JumpTo);
                    }
                    break;
                case BuiltInFunctionCode.CALL://֐ɈړBړLARETURNŋAB
                case BuiltInFunctionCode.TRYCALL:
                case BuiltInFunctionCode.TRYCCALL:
                    {
                        if ((func.JumpTo == null) && (func.Function == BuiltInFunctionCode.TRYCALL))
                            break;
                        else if ((func.JumpTo == null) && (func.Function == BuiltInFunctionCode.TRYCCALL))
                        {
                            if (func.JumpToEndCatch != null)
                                state.JumpTo(func.JumpToEndCatch);
                            break;
                        }
                        if (!sequential)//RETURNŋAĂ
                            break;//Ȃ
                        string label = ((SpCallArgment)func.Argument).Str;
                        if (Config.Instance.IgnoreCase)
                            label = label.ToUpper();
                        CalledFunction call = CalledFunction.CallFunction(this, label, func, false);
                        if ((call == null) || (call.Count == 0) || (call.NextLine == null))
                            throw new CodeEE("֐\"@" + label + "\"܂");
                        if (call.Count > 1)
                            throw new ExeEE("֐\"@" + label + "\"̌₪Ԃꂽ");
                        //if (call.LabelList.Count > 1 && strArray.Count > 0)
                        //    throw new ExeEE("EVENT֐\"@" + label + "\"Ɉw肷邱Ƃ͂ł܂");
                        assignArgs(call.LabelList[0], ((SpCallArgment)func.Argument).Args);
                        state.AddFunction(call);
                        break;
                    }
                //case BuiltInFunctionCode.RETURN://֐̏IBRESULTɐi[\B
                //    {
                //        expArg = (ExpressionArgument)func.Argument;
                //        Int64 ret = eEvaluator.GetInteger(expArg.Term);
                //        vEvaluator.RESULT = ret;
                //        state.Return(ret);
                //        if (state.GetCurrentReturnAddress is NullLine)
                //            return false;
                //        break;
                //    }
                //case BuiltInFunctionCode.RETURNFORM://֐̏IBRESULTɐi[\B
                //    {
                //        string arg = eEvaluator.GetString(((ExpressionArgument)func.Argument).Term);
                //        StringStream aSt = new StringStream(arg);
                //        Int64 ret = eEvaluator.GetInteger(ExpressionParser.ReduceIntegerTerm(aSt, null));
                //        vEvaluator.RESULT = ret;
                //        state.Return(ret);
                //        if (state.GetCurrentReturnAddress is NullLine)
                //            return false;
                //        break;
                //    }
                case BuiltInFunctionCode.RETURNF:
                    {
                        expArg = (ExpressionArgument)func.Argument;
                        SingleTerm ret = null;
                        if (expArg.Term != null)
                        {
                            ret = eEvaluator.GetValue(expArg.Term);
                        }
                        state.ReturnF(ret);
                        return false;
                    }
                case BuiltInFunctionCode.LOADDATA:
                    {
                        ExpressionArgument intExpArg = (ExpressionArgument)func.Argument;
                        Int64 target = eEvaluator.GetInteger(intExpArg.Term);
                        if (target < 0)
                            throw new CodeEE("LOADDATÄɕ̒l(" + target.ToString() + ")w肳܂");
                        else if (target > int.MaxValue)
                            throw new CodeEE("LOADDATÄ(" + target.ToString() + ")傫܂");
                        EraDataResult result = checkData((int)target);
                        if (result.State != EraDataState.OK)
                            throw new CodeEE("sȃf[^[h悤Ƃ܂");

                        loadFrom((int)target);
                        state.ClearFunctionList();
                        state.SystemState = SystemStateCode.LoadData_DataLoaded;
                        return false;
                    }
                case BuiltInFunctionCode.JUMPFORM:
                case BuiltInFunctionCode.TRYJUMPFORM:
                case BuiltInFunctionCode.TRYCJUMPFORM:
                    {
                        SpCallformArgment spCallformArg = (SpCallformArgment)func.Argument;
                        StringForm strForm = spCallformArg.StrForm;
                        string label = strForm.GetString(eEvaluator).Trim();
                        if (Config.Instance.IgnoreCase)
                            label = label.ToUpper(); ;
                        CalledFunction call = CalledFunction.CallFunction(this, label, state.GetCurrentReturnAddress, false);
                        if ((call == null) || (call.Count == 0) || (call.NextLine == null))
                        {
                            if (func.Function == BuiltInFunctionCode.TRYJUMPFORM)
                                break;
                            else if (func.Function == BuiltInFunctionCode.TRYCJUMPFORM)
                            {
                                if (func.JumpToEndCatch != null)
                                    state.JumpTo(func.JumpToEndCatch);
                                break;
                            }
                            throw new CodeEE("֐\"@" + label + "\"܂");
                        }
                        assignArgs(call.LabelList[0], spCallformArg.Args);
                        state.ChangeCurrentFunction(call);
                        state.JumpTo(call.NextLine);
                        break;
                    }

                case BuiltInFunctionCode.CALLFORM:
                case BuiltInFunctionCode.TRYCALLFORM:
                case BuiltInFunctionCode.TRYCCALLFORM:
                    {
                        if (!sequential)//RETURNŋAĂ
                            break;//Ȃ
                        SpCallformArgment spCallformArg = (SpCallformArgment)func.Argument;
                        StringForm strForm = spCallformArg.StrForm;
                        string label = strForm.GetString(eEvaluator).Trim();
                        if (Config.Instance.IgnoreCase)
                            label = label.ToUpper(); ;
                        CalledFunction call = CalledFunction.CallFunction(this, label, func, false);
                        if ((call == null) || (call.Count == 0) || (call.NextLine == null))
                        {
                            if (func.Function == BuiltInFunctionCode.TRYCALLFORM)
                                break;
                            else if (func.Function == BuiltInFunctionCode.TRYCCALLFORM)
                            {
                                if (func.JumpToEndCatch != null)
                                    state.JumpTo(func.JumpToEndCatch);
                                break;
                            }
                            throw new CodeEE("֐\"@" + label + "\"܂");

                        }
                        assignArgs(call.LabelList[0], spCallformArg.Args);
                        state.AddFunction(call);
                        break;
                    }
                case BuiltInFunctionCode.GOTOFORM:
                case BuiltInFunctionCode.TRYGOTOFORM:
                case BuiltInFunctionCode.TRYCGOTOFORM:
                    {
                        string label = eEvaluator.GetString(((ExpressionArgument)func.Argument).Term);
                        if (Config.Instance.IgnoreCase)
                            label = label.ToUpper();
                        LogicalLine jumpto = state.CurrentCalled.CallLabel(this, label);
                        if (jumpto == null)
                        {
                            if (func.Function == BuiltInFunctionCode.TRYGOTOFORM)
                                break;
                            else if (func.Function == BuiltInFunctionCode.TRYCGOTOFORM)
                            {
                                if (func.JumpToEndCatch != null)
                                    state.JumpTo(func.JumpToEndCatch);
                                break;
                            }
                            throw new CodeEE("x\"$" + label + "\"܂");
                        }
                        state.JumpTo(jumpto);
                        break;
                    }
                case BuiltInFunctionCode.TRYCALLLIST:
                    {
                        if (!sequential)//RETURNŋAĂ
                        {
                            state.JumpTo(func.JumpTo);
                            break;
                        }
                        string funcName = "";
                        CalledFunction callto = null;
                        SpCallformArgment cfa = null;
                        foreach (InstructionLine iLine in func.callList)
                        {
                            if (iLine.Argument == null)
                                LogicalLineParser.SetArgumentTo(iLine, null);
                            cfa = (SpCallformArgment)iLine.Argument;
                            funcName = cfa.StrForm.GetString(eEvaluator).Trim();
                            if (Config.Instance.IgnoreCase)
                                funcName = funcName.ToUpper();
                            callto = CalledFunction.CallFunction(this, funcName, func.JumpTo, false);
                            if ((callto != null) && (callto.Count != 0) && (callto.NextLine != null))
                                break;
                        }
                        if ((callto == null) || (callto.Count == 0) || (callto.NextLine == null))
                            state.JumpTo(func.JumpTo);
                        else
                        {
                            assignArgs(callto.LabelList[0], cfa.Args);
                            state.AddFunction(callto);
                        }
                    }
                    break;
                case BuiltInFunctionCode.TRYJUMPLIST:
                    {
                        string funcName = "";
                        CalledFunction callto = null;
                        SpCallformArgment cfa = null;
                        foreach (InstructionLine iLine in func.callList)
                        {
                            if (iLine.Argument == null)
                                LogicalLineParser.SetArgumentTo(iLine, null);
                            cfa = (SpCallformArgment)iLine.Argument;
                            funcName = cfa.StrForm.GetString(eEvaluator).Trim();
                            if (Config.Instance.IgnoreCase)
                                funcName = funcName.ToUpper();
                            callto = CalledFunction.CallFunction(this, funcName, func, false);
                            if ((callto != null) && (callto.Count != 0) && (callto.NextLine != null))
                                break;
                        }
                        if ((callto == null) || (callto.Count == 0) || (callto.NextLine == null))
                            state.JumpTo(func.JumpTo);
                        else
                        {
                            assignArgs(callto.LabelList[0], cfa.Args);
                            state.ChangeCurrentFunction(callto);
                            state.JumpTo(callto.NextLine);
                        }
                    }
                    break;
                case BuiltInFunctionCode.TRYGOTOLIST:
                    {
                        string funcName = "";
                        LogicalLine jumpto = null;
                        foreach (InstructionLine iLine in func.callList)
                        {
                            if (iLine.Argument == null)
                                LogicalLineParser.SetArgumentTo(iLine, null);
                            funcName = ((SpCallformArgment)iLine.Argument).StrForm.GetString(eEvaluator).Trim();
                            if (Config.Instance.IgnoreCase)
                                funcName = funcName.ToUpper();
                            jumpto = state.CurrentCalled.CallLabel(this, funcName);
                            if (jumpto != null)
                                break;
                        }
                        if (jumpto == null)
                            state.JumpTo(func.JumpTo);
                        else
                            state.JumpTo(jumpto);
                    }
                    break;
                case BuiltInFunctionCode.CALLTRAIN:
                    {
                        ExpressionArgument intExpArg = (ExpressionArgument)func.Argument;
                        Int64 count = eEvaluator.GetInteger(intExpArg.Term);
                        SetCommnds(count);
                        return false;
                    }
                case BuiltInFunctionCode.CATCH:
                    {
                        if (sequential)//ォ痬ĂȂ牽ȂENDCATCHɔ
                            state.JumpTo(func.JumpToEndCatch);
                    }
                    break;
                case BuiltInFunctionCode.DOTRAIN:
                    {
                        switch (state.SystemState)
                        {
                            //case SystemStateCode.Train_Begin://BEGIN TRAINB
                            case SystemStateCode.Train_CallEventTrain://@EVENTTRAIŇĂяoBXLbv\
                            case SystemStateCode.Train_CallShowStatus://@SHOW_STATUŠĂяo
                            //case SystemStateCode.Train_CallComAbleXX://@COM_ABLExx̌ĂяoB
                            case SystemStateCode.Train_CallShowUserCom://@SHOW_USERCOM̌Ăяo
                            //case SystemStateCode.Train_WaitInput://͑҂ԁBIs\ȂEVENTCOMCOMxxAłȂ@USERCOMRESULTn
                            //case SystemStateCode.Train_CallEventCom://@EVENTCOM̌Ăяo
                            //case SystemStateCode.Train_CallComXX://@COMxx̌Ăяo
                            //case SystemStateCode.Train_CallSourceCheck://@SOURCE_CHECǨĂяo
                            case SystemStateCode.Train_CallEventComEnd://@EVENTCOMENĎĂяoBXLbv\BTrain_CallEventTrain֋AB@USERCOM̌Ăяo
                                break;
                            default:
                                throw new CodeEE("DOTRAIN߂̈ʒuŎs邱Ƃ͂ł܂");
                        }
                        coms.Clear();
                        isCTrain = false;
                        this.count = 0;

                        Int64 train = eEvaluator.GetInteger(((ExpressionArgument)func.Argument).Term);
                        if (train < 0)
                            throw new CodeEE("DOTRAIN߂0̒ln܂");
                        if (train >= vEvaluator.Constant.TrainName.Length)
                            throw new CodeEE("DOTRAIN߂TRAINNAME̔z񐔈ȏ̒ln܂");
                        doTrainSelectCom = train;
                        state.SystemState = SystemStateCode.Train_DoTrain;
                        return false;
                    }
                //case BuiltInFunctionCode.LOOP:
                //    if (!sequential)
                //        break;
                //    expArg = (ExpressionArgument)func.Argument;
                //    if (eEvaluator.GetInteger(expArg.Term) == 0)//U
                //        break;//̂܂܎̏
                //    state.JumpTo(func.JumpTo);
                //    break;
                default:
                    throw new ExeEE("`̊֐ł");
            }
            return true;
		}

		/// <summary>
		/// Ăяo֐ւ̈̑B[JϐScope̓sAJumpToAddFunction̑OɌĂԂƁB
		/// </summary>
		/// <param name="called"></param>
		/// <param name="args"></param>
		private void assignArgs(FunctionLabelLine called, IOperandTerm[] args)
		{
			if (called.Arg.Length < args.Length)
				throw new CodeEE("̐֐\"@" + called.LabelName + "\"ɐݒ肳ꂽ𒴂Ă܂");
			if (called.Arg.Length == 0)
				return;
			string oldScope = state.Scope;
			string newScope = called.LabelName;
			for (int i = 0; i < called.Arg.Length; i++)
			{
				IOperandTerm term = null;
				if (i < args.Length)
					term = args[i];
				FixedVariablePointer pt;
				if (term == null)
				{
					//VEvaluator.Scope = oldScope;
					//string str = eEvaluator.GetString(term);
					vEvaluator.Scope = newScope;
					pt = eEvaluator.GetFixedVariable(called.Arg[i]);
					if (called.Arg[i].GetOperandType() == typeof(string))
						vEvaluator.SetValue(pt, "");
					else if (called.Arg[i].GetOperandType() == typeof(Int64))
						vEvaluator.SetValue(pt, 0);
					else
						continue;
				}
				else if ((term.GetOperandType() == typeof(string)) && (called.Arg[i].GetOperandType() == typeof(string)))
				{
					vEvaluator.Scope = oldScope;
					string str = eEvaluator.GetString(term);
					vEvaluator.Scope = newScope;
					pt = eEvaluator.GetFixedVariable(called.Arg[i]);
					vEvaluator.SetValue(pt, str);
				}
				else if ((term.GetOperandType() == typeof(Int64)) && (called.Arg[i].GetOperandType() == typeof(Int64)))
				{
					vEvaluator.Scope = oldScope;
					Int64 l = eEvaluator.GetInteger(term);
					vEvaluator.Scope = newScope;
					pt = eEvaluator.GetFixedVariable(called.Arg[i]);
					vEvaluator.SetValue(pt, l);
				}
				else if ((term.GetOperandType() == typeof(Int64)) && (called.Arg[i].GetOperandType() == typeof(string)))
				{
					vEvaluator.Scope = oldScope;
					Int64 l = eEvaluator.GetInteger(term);
					vEvaluator.Scope = newScope;
					pt = eEvaluator.GetFixedVariable(called.Arg[i]);
					vEvaluator.SetValue(pt, l.ToString());
				}
				else if ((term.GetOperandType() == typeof(string)) && (called.Arg[i].GetOperandType() == typeof(Int64)))
					throw new CodeEE((i + 1).ToString() + "Ԗڂ̈𕶎^琮^ɕϊł܂");
				else
					throw new ExeEE("̌`s");
			}

		}

		//private List<string> splitArgStr(string str, BuiltInFunctionCode bc)
		//{
		//    List<string> strArray = new List<string>();
		//    StringStream st = new StringStream(str);
		//    string tStr = null;
		//    int count = 0;
		//    while (!st.EOS)
		//    {
		//        TokenReader.SkipWhiteSpace(st);
		//        if (count > 0)
		//        {
		//            tStr = TokenReader.ReadIdentiferWithIndexAndExpression(st);
		//            strArray.Add(tStr);
		//            count++;
		//        }
		//        else
		//        {
		//            if (bc == BuiltInFunctionCode.CALLFORM || bc == BuiltInFunctionCode.TRYCALLFORM)
		//            {
		//                tStr = TokenReader.ReadRawStringWithFormString(st);
		//            }
		//            else
		//            {
		//                tStr = TokenReader.ReadRawString(st);
		//            }
		//            strArray.Add(tStr);
		//            count++;
		//        }
		//    }
		//    return strArray;
		//}


		List<ProcessState> prevStateList = new List<ProcessState>();
		private void saveCurrentState(bool single)
		{
			if (single && (prevStateList.Count > 0))
				throw new ExeEE("LĂԂ̂ɍēxL悤Ƃ");
			prevStateList.Add(state.Clone());
		}

		private void loadPrevState()
		{
			if (prevStateList.Count == 0)
				throw new ExeEE("LĂԂȂ̂ɌĂі߂ꂽ");
			state = prevStateList[prevStateList.Count - 1];
			deletePrevState();
		}

		private void deletePrevState()
		{
			if (prevStateList.Count != 0)
				prevStateList.RemoveAt(prevStateList.Count - 1);
		}

		private void deleteAllPrevState()
		{
			prevStateList.Clear();
		}


		#endregion
	}
}
