using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameView;
using MinorShift.Emuera.GameData.Expression;
using MinorShift.Emuera.GameData.Variable;
using System.Windows.Forms;

namespace MinorShift.Emuera.GameProc
{

	internal sealed partial class Process
	{
		private Process(EmueraConsole view)
		{
			console = view;
		}

		//1.713 ProcessO[o
		//ExpressionEvaluatorParserp
		//1.731 łɈꕔMethodQ
		public static Process CreateProcess(EmueraConsole view)
		{
			//if (instance == null)
			//	instance.Dispose();
			instance = new Process(view);
			return instance;
		}
		static Process instance = null;
		public static Process Instance { get { return instance; } }
        public LogicalLine getCurrentLilne { get { return state.CurrentLine; } }

        //ERBloaderɈ͂̌ʂn߂̋nϐ
        public Dictionary<string, Int64> tempDic = new Dictionary<string, long>();
        public void PrintAnalysisWarning(string str, LogicalLine line, int level)
        {
            console.PrintWarning(str, line.Position, level);
        }

		/// <summary>
		/// @~~$~~W߂́BCALL߂ȂǂŎg
		/// sLogicalLinegێB
		/// </summary>
		LabelDictionary labelDic;
		public LabelDictionary LabelDic { get { return labelDic; } }

		/// <summary>
		/// ϐSBXNvgŕKvɂȂϐ́i[U[ڐGȂ̂܂߁j̒ɂ
		/// </summary>
		private VariableEvaluator vEvaluator;
		private ExpressionEvaluator eEvaluator;
		private GameBase gamebase;
		readonly EmueraConsole console;
		public EmueraConsole Console { get { return console; } }
		ProcessState state;
        static List<string> loadedFileList = new List<string>();
        bool noError = false;

        public bool Initialize()
		{
			isInitialized = false;
			state = new ProcessState();
            bool load_Rename = false;
			string csvDir = Program.ExeDir + "csv\\";
			string erbDir = Program.ExeDir + "erb\\";
			try
			{
                if (Config.Instance.UseKeyMacro && !Program.AnalysisMode)
                {
                    if (File.Exists(Program.ExeDir + "macro.txt"))
                    {
                        if (Config.Instance.DisplayReport)
                            console.PrintLine("macro.txtǂݍݒEEE");
                        Config.Instance.LoadMacroFile(Program.ExeDir + "macro.txt");
                    }
                }
				if (Config.Instance.UseReplaceFile && !Program.AnalysisMode)
				{
					if (File.Exists(csvDir + "_Replace.csv"))
					{
                        if (Config.Instance.DisplayReport)
							console.PrintLine("_Replace.csvǂݍݒEEE");
						Config.Instance.LoadReplaceFile(csvDir + "_Replace.csv");
                        console.setStBar(Config.Instance.DrawLineString);
					}
					//else
					//	console.PrintLine("csv\\_Replace.csv܂");
				}
                if (Config.Instance.UseRenameFile)
                {
                    if (File.Exists(csvDir + "_Rename.csv"))
                    {
                        if (Config.Instance.DisplayReport || Program.AnalysisMode)
                            console.PrintLine("_Rename.csvǂݍݒEEE");
                        load_Rename = true;
                    }
                    else
                        console.PrintLine("csv\\_Rename.csv܂");

                }
                if (!Config.Instance.DisplayReport)
				{
					console.PrintLine(Config.Instance.LoadLabel);
					console.RefreshStrings(true);
				}
				gamebase = new GameBase();
				gamebase.LoadGameBaseCsv(csvDir + "GAMEBASE.CSV");
				console.SetWindowTitle(gamebase.ScriptWindowTitle);
				
				ConstantData constant = new ConstantData(gamebase);
				constant.LoadData(csvDir, console);
				vEvaluator = new VariableEvaluator(gamebase, constant);
				//VariableEvaluator.SetTestData(VEvaluator);
				eEvaluator = new ExpressionEvaluator(vEvaluator);
				//if (File.Exists(csvDir + "_Rename.csv"))
				//    VarData.LoadEraExRenameFile(csvDir + "_Rename.csv");
				ErbLoader loader = new ErbLoader(console, vEvaluator);
				if (load_Rename)
                    loader.LoadEraExRenameFile(csvDir + "_Rename.csv");
				labelDic = new LabelDictionary();
                if (Program.AnalysisMode)
                {
                    noError = loader.loadErbs(Program.AnalysisFiles, labelDic);
                }
                else
                    noError = loader.LoadErbFiles(erbDir, Config.Instance.DisplayReport, labelDic);
				initSystemProcess();
			}
			catch (CodeEE e)
			{
                System.Media.SystemSounds.Hand.Play();
				if (e.Position != null)
				{
					console.PrintLine(e.Position.Filename + "" + e.Position.LineNo.ToString() + "sڂŃG[܂");
					console.PrintLine(e.Position.RowLine);
				}
				console.PrintLine(e.Message);
				return false;
			}
			catch (Exception)
			{
                System.Media.SystemSounds.Hand.Play();
                console.PrintLine("ɒvIȃG[܂");
				return false;
			}
			if (labelDic == null)
			{
				return false;
			}
			isInitialized = true;
			state.SystemState = SystemStateCode.Title_Begin;
            return true;
		}

		//public bool InitialaizeWithoutLoad()
		//{
		//    VEvaluator = new VariableEvaluator(VEvaluator.Gamebase, VEvaluator.Constant);
		//    //VariableEvaluator.SetTestData(VEvaluator);
		//    eEvaluator = new ExpressionEvaluator(VEvaluator);
		//    VEvaluator.AddCharacter(0, false);
		//    if (VEvaluator.Gamebase.DefaultCharacter > 0)
		//        VEvaluator.AddCharacter(VEvaluator.Gamebase.DefaultCharacter, false);
		//    return true;
		//}

		public void ReloadErb()
		{
			saveCurrentState(false);
			state.ClearFunctionList();
			state.SystemState = SystemStateCode.System_Reloaderb;
			isInitialized = false;
			labelDic = null;
			string erbDir = Program.ExeDir + "erb\\";
			ErbLoader loader = new ErbLoader(console, vEvaluator);
			labelDic = new LabelDictionary();
			loader.LoadErbFiles(erbDir, false, labelDic);
			isInitialized = true;
			console.ReadAnyKey();
		}

        public void ReloadPartialErb(List<string> path, bool addNewFiles)
        {
            saveCurrentState(false);
            state.ClearFunctionList();
            state.SystemState = SystemStateCode.System_Reloaderb;
            isInitialized = false;
            for (int i = 0; i < path.Count; i++)
            {
                if (!addNewFiles || (addNewFiles && checkFilePathExist(path[i])))
                    labelDic.RemoveLabelWithPath(path[i]);
                else if (addNewFiles)
                {
                    string fname;
                    if (path[i].StartsWith(Program.ExeDir))
                        fname = path[i].Substring(Program.ExeDir.Length + "erb\\".Length);
                    else
                        fname = path[i];
                  
                    loadedFileList.Add(fname);
                }
            }
            ErbLoader loader = new ErbLoader(console, vEvaluator); 
            loader.loadErbs(path, labelDic);
            isInitialized = true;
            console.ReadAnyKey();
        }

        private bool checkFilePathExist(string path)
        {
            string fname;
            if (path.StartsWith(Program.ExeDir))
                fname = path.Substring(Program.ExeDir.Length + "erb\\".Length);
            else
                fname = path;
            if (!loadedFileList.Contains(fname))
                return false;
            return true;
        }

        public bool checkFilePathsExist(List<string> path)
        {
            foreach (string fpath in path)
            {
                if (!checkFilePathExist(fpath))
                    return false;
            }
            return true;
        }

		public void SetCommnds(Int64 count)
		{
			coms = new List<long>((int)count);
			isCTrain = true;
			for (int i = 0; i < (int)count; i++)
			{
				string comStr = string.Format("SELECTCOM:{0}", (i + 1));
				StringStream aSt = new StringStream(comStr);
				Int64 comNum = eEvaluator.GetInteger(ExpressionParser.ReduceIntegerTerm(aSt, null));
				coms.Add(comNum);
			}
		}

		public void InputInteger(Int64 i)
		{
			vEvaluator.RESULT = i;
		}
		public void InputSystemInteger(Int64 i)
		{
			systemResult = i;
		}
		public void InputString(string s)
		{
			vEvaluator.RESULTS = s;
		}

		public bool isInitialized = false;
		private long lineCount = 0;
		private uint startTime = 0;
		public void DoScript()
		{
			startTime = _Library.WinmmTimer.TickCount;
			lineCount = 0;
			while (true)
			{
				methodStack = 0;
				if (state.ScriptEnd)
					runSystemProcWithCatch();
				if (!console.IsRunning)
				{
					//    if (console.hasWaitRefresh || console.needRefresh)
					//        console.RefreshStrings(true);
					break;
				}
				runScriptProcWithCatch();
				//if (console.needRefresh)
				//    console.RefreshStrings(true);
			}
			return;
		}

		private void runSystemProcWithCatch()
		{
			try
			{
				runSystemProc();
			}
			catch (Exception e)
			{
                System.Media.SystemSounds.Hand.Play();
                if (e is CodeEE)
					console.PrintLine("֐̏I[ŃG[܂");
				else if (e is ExeEE)
					console.PrintLine("֐̏I[EmuerãG[܂");
				else
					console.PrintLine("֐̏I[ŗ\ȂG[܂");
				console.PrintLine(e.Message);
				console.ThrowError();
			}
		}

		public void BeginTitle()
		{
			vEvaluator.ResetData();
			state.ClearFunctionList();
			state.SystemState = SystemStateCode.Title_Begin;
		}

		private void checkInfiniteLoop()
		{
            //lineCount++;
            ////WinmmTimer玞Ԃ擾̂͂ꎩ̌\ȃRXĝ10000sɈ񂭂炢ŁB
            //if (lineCount % 10000 != 0)
            //    return;
            //if (Config.Instance.InfiniteLoopAlertTime <= 0)
            //    return;

			//܂ȂBBEEP̂~߂Ȃ̂ł̏ȂƂɁi1.51j
			////t[Yh~Błł
			//System.Windows.Forms.Application.DoEvents();
			////System.Threading.Thread.Sleep(0);

			//if (!console.Enabled)
			//{
			//    //DoEvents()̊ԂɃEChEꂽ炨܂B
			//    console.ReadAnyKey();
			//    return;
			//}
			uint time = _Library.WinmmTimer.TickCount - startTime;
			if (time < Config.Instance.InfiniteLoopAlertTime)
				return;
			LogicalLine currentLine = state.CurrentLine;
			if ((currentLine == null) || (currentLine is NullLine))
				return;//݂̍sȏԂȂX[
			if (!console.Enabled)
				return;//N[YĂMessageBox.ShowłȂ̂ŁB
			string caption = string.Format("[v̉\܂");
			string text = string.Format(
				"݁A{0}{1}sڂsłB\nŌ̓͂{3}~bo߂{2}ss܂B\n𒆒fI܂H",
				currentLine.Position.Filename, currentLine.Position.LineNo, lineCount, time);
			DialogResult result = MessageBox.Show(text, caption, MessageBoxButtons.YesNo);
			if (result == DialogResult.Yes)
			{
				throw new CodeEE("[v̋^ɂ苭II܂");
			}
			else
			{
				lineCount = 0;
				startTime = _Library.WinmmTimer.TickCount;
			}
		}

		///DoScript()̈ꕔBG[Ȃ̂ŕB
		private void runScriptProcWithCatch()
		{
			try
			{
				runScriptProc();
				//checkInfiniteLoop();
			}
			catch (Exception ec)
			{
                System.Media.SystemSounds.Hand.Play();
				LogicalLine currentLine = state.ErrorLine;
				if ((currentLine == null) || (currentLine is NullLine))
					currentLine = null;
				ScriptPosition positon = null;

				if((ec is EmueraException ) &&( ((EmueraException)ec).Position != null))
					positon = ((EmueraException)ec).Position; 
				else if ((currentLine != null) && (currentLine.Position != null))
					positon = currentLine.Position;

				if(positon !=null)
				{
					if (ec is CodeEE)//*.ERB̖ƎvO
						console.PrintLine(currentLine.Position.Filename + "" + currentLine.Position.LineNo.ToString() + "sڂŃG[܂");
					else if (ec is ExeEE)//emuera.exe{̂ɋNƎvOBoOB
						console.PrintLine(currentLine.Position.Filename + "" + currentLine.Position.LineNo.ToString() + "sڂEmuera.exẽG[܂");
					else//SystemExceptionB\ȂO
						console.PrintLine(currentLine.Position.Filename + "" + currentLine.Position.LineNo.ToString() + "sڂŗ\ȂG[܂");
					console.PrintLine(currentLine.Position.RowLine);
				}
				else
				{
					if (ec is CodeEE)//*.ERB̖ƎvO
						console.PrintLine("G[܂");
					else if (ec is ExeEE)//emuera.exe{̂ɋNƎvOBoOB
						console.PrintLine("Emuera.exẽG[܂");
					else//SystemExceptionB\ȂO
						console.PrintLine("\ȂG[܂");
					console.PrintLine("ӏł܂ł");
				}
				if (ec is EmueraException)
					console.PrintLine(ec.Message);
				else//SystemExceptionBG[em邽߂ɂMessageނType̕dv
					console.PrintLine(ec.GetType().ToString() + ":" + ec.Message);
				console.ThrowError();
			}
			return;
		}

		int methodStack = 0;
		public SingleTerm GetValue(string funcname, IOperandTerm[] args)
		{
			methodStack++;
			if (methodStack > 100)
			{
				//StackOverflowExceptioncatchłȂɍČȂ̂ŔOɈ萔őł؂B
				//ɂĂ100ȑOStackOverflowExceptionł邩H
				throw new CodeEE("֐̌ĂяoX^bN܂(ɍċAĂяoĂ܂񂩁H)");
			}
			ProcessState temp_state = state.Clone();
			CalledFunction call = CalledFunction.CallFunctionMethod(this, funcname);
			if ((call == null) || (call.Count == 0) || (call.NextLine == null))
				throw new ExeEE("֐\"@" + funcname + "\"܂");
			if (call.Count > 1)
				throw new ExeEE("֐\"@" + funcname + "\"̌₪Ԃꂽ");
			assignArgs(call.LabelList[0], args);
			SingleTerm ret = null;
			state.ClearFunctionList();
			state.AddFunction(call);
			//do while̒throw ꂽG[͂ł̓Lb`ȂB
			//#functionSĔrunScriptProcWithCatchŃLb`B
			//state = temp_state;sȂ߁AG[s͐肳B
			do
			{
				runScriptProc();
				//if (console.IsError)
				//    break;
				if (!console.IsRunning && !console.IsDebug)
					throw new ExeEE("R\[ԂRunningłȂ");//R\[Ԃω閽߂__METHOD_SAFE__OĂ͂
			} while (state.CurrentLine != null);

			ret = state.MethodReturnValue;
			state = temp_state;
            if (!(console.IsDebug && (methodStack == 1) && (state.SystemState != SystemStateCode.Title_Begin)))
                eEvaluator.VEvaluator.Scope = state.Scope;
            else if (state.SystemState == SystemStateCode.Title_Begin)
                eEvaluator.VEvaluator.Scope = "";
			//if (console.IsError)
			//{
			//    throw new CodeEE("֐@" + funcname + "̌ĂяoɃG[܂");
			//}
			methodStack--;
			return ret;
		}
	}
}
