﻿using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.GameData.Expression;
using MinorShift.Emuera.GameData.Function;
using MinorShift.Emuera.GameData.Variable;

namespace MinorShift.Emuera.GameProc
{

	internal sealed class UserDefinedFunctionArgument
	{
		public UserDefinedFunctionArgument(IOperandTerm[] srcArgs)
		{
			Arguments = srcArgs;
			TransporterInt = new Int64[Arguments.Length];
			TransporterStr = new string[Arguments.Length];
		}
		public readonly IOperandTerm[] Arguments;
		public readonly Int64[] TransporterInt;
		public readonly string[] TransporterStr;
		public void SetTransporter(ExpressionMediator exm)
		{
			for (int i = 0; i < Arguments.Length; i++)
			{
				if (Arguments[i] == null)
					continue;
				if (Arguments[i].GetOperandType() == typeof(Int64))
					TransporterInt[i] = Arguments[i].GetIntValue(exm);
				else
					TransporterStr[i] = Arguments[i].GetStrValue(exm);
			}
		}
		public UserDefinedFunctionArgument Restructure(ExpressionMediator exm)
		{
			for (int i = 0; i < Arguments.Length; i++)
			{
				if (Arguments[i] == null)
					continue;
				Arguments[i] = Arguments[i].Restructure(exm);
			}
			return this;
		}
	}

	/// <summary>
	/// 現在呼び出し中の関数
	/// イベント関数を除いて実行中に内部状態は変化しないので使いまわしても良い
	/// </summary>
	internal sealed class CalledFunction
	{
		private CalledFunction(string label) { FunctionName = label; }
		public static CalledFunction CallEventFunction(Process parent, string label, LogicalLine retAddress)
		{
			CalledFunction called = new CalledFunction(label);
			List<FunctionLabelLine> newLabelList = new List<FunctionLabelLine>();
			called.Finished = false;
			called.eventLabelList = parent.LabelDictionary.GetEventLabels(label);
			if (called.eventLabelList == null)
			{
				FunctionLabelLine line = parent.LabelDictionary.GetNonEventLabel(label);
				if (parent.LabelDictionary.GetNonEventLabel(label) != null)
				{
					throw new CodeEE("イベント関数でない関数@" + label + "(" + line.Position.Filename + ":" + line.Position.LineNo + "行目)に対しEVENT呼び出しが行われました");
				}
				return null;
			}
			called.counter = -1;
			called.group = 0;
			called.ShiftNext();
			called.TopLabel = called.CurrentLabel;
			called.returnAddress = retAddress;
			return called;
		}

		public static CalledFunction CallFunction(Process parent, string label, LogicalLine retAddress)
		{
			CalledFunction called = new CalledFunction(label);
			called.Finished = false;
			FunctionLabelLine labelline = parent.LabelDictionary.GetNonEventLabel(label);
			if (labelline == null)
			{
				if (parent.LabelDictionary.GetEventLabels(label) != null)
				{
					throw new CodeEE("イベント関数@" + label + "に対し通常のCALLが行われました");
				}
				return null;
			}
			called.TopLabel = labelline;
			called.CurrentLabel = labelline;
			called.returnAddress = retAddress;
            return called;
		}

		public static CalledFunction CreateCalledFunctionMethod(FunctionLabelLine labelline, string label)
		{
			CalledFunction called = new CalledFunction(label);
			called.TopLabel = labelline;
			called.CurrentLabel = labelline;
			called.returnAddress = null;
			return called;
		}
		
		
		static FunctionMethod tostrMethod = null;
		/// <summary>
		/// 1803beta005 予め引数の数を合わせて規定値を代入しておく
		/// </summary>
		public UserDefinedFunctionArgument ConvertArg(IOperandTerm[] srcArgs, out string errMes)
		{
			errMes = null;
			FunctionLabelLine func = TopLabel;
			IOperandTerm[] convertedArg = new IOperandTerm[func.Arg.Length];
			if(convertedArg.Length < srcArgs.Length)
			{
				errMes = "引数の数が関数\"@" + func.LabelName + "\"に設定された数を超えています";
				return null;
			}
			IOperandTerm term = null;
			VariableTerm destArg = null;
			bool isString = false;
			for (int i = 0; i < func.Arg.Length; i++)
			{
				term = (i < srcArgs.Length) ? srcArgs[i] : null;
				destArg = func.Arg[i];
				isString = destArg.IsString;
				if (term == null)
				{//
					term = func.Def[i];
					if (term == null && !func.ArgOptional)
					{
						errMes = "\"@" + func.LabelName + "\"の引数は省略できません";
						return null;
					}
				}
				else if (term.GetOperandType() != destArg.GetOperandType())
				{
					if (term.GetOperandType() == typeof(string))
					{
						errMes = (i + 1).ToString() + "番目の引数を文字列型から整数型に変換できません";
						return null;
					}
					else
					{
						if (!func.ArgAutoConvert)
						{
							errMes = (i + 1).ToString() + "番目の引数を整数型から文字列型に変換できません";
							return null;
						}
						if (tostrMethod == null)
							tostrMethod = FunctionMethodCreator.GetMethodList()["TOSTR"];
						term = new FunctionMethodTerm(tostrMethod, new IOperandTerm[] { term });
					}
				}
				convertedArg[i] = term;
			}
			return new UserDefinedFunctionArgument(convertedArg);
		}

		public LogicalLine CallLabel(Process parent, string label)
		{
			return parent.LabelDictionary.GetLabelDollar(label, this.CurrentLabel);
		}

        public void updateRetAddress(LogicalLine line)
        {
            returnAddress = line;
        }

		public CalledFunction Clone()
		{
			CalledFunction called = new CalledFunction(this.FunctionName);
			called.eventLabelList = this.eventLabelList;
			called.CurrentLabel = this.CurrentLabel;
			called.TopLabel = this.TopLabel;
			called.group = this.group;

			called.counter = this.counter;
			called.returnAddress = this.returnAddress;
			return called;
		}

		List<FunctionLabelLine>[] eventLabelList;
		public FunctionLabelLine CurrentLabel { get; private set; }
		public FunctionLabelLine TopLabel { get; private set; }
		int counter = -1;
		int group = 0;
		LogicalLine returnAddress;
		public readonly string FunctionName = "";
		public bool IsJump { get; set; }
		public bool Finished { get; private set; }
		public LogicalLine ReturnAddress
		{
			get { return returnAddress; }
		}
		public bool IsEvent
		{
			get
			{
				return TopLabel.IsEvent;
			}
		}
		public bool HasSingleFlag
		{
			get
			{
				if (CurrentLabel == null)
					return false;
				return CurrentLabel.IsSingle;
			}
		}


		#region イベント関数専用
		public void ShiftNext()
		{
			while (true)
			{
				counter++;
				if (eventLabelList[group].Count > counter)
				{
					CurrentLabel = (eventLabelList[group])[counter];
					return;
				}
				group++;
				counter = -1;
				if (group >= 4)
				{
					CurrentLabel = null;
					return;
				}
			}
		}

		public void ShiftNextGroup()
		{
			counter = -1;
			group++;
            if (group >= 4)
            {
                CurrentLabel = null;
                return;
            }
			ShiftNext();
		}

        public void FinishEvent()
        {
            group = 4;
            counter = -1;
            CurrentLabel = null;
            return;
        }

        public bool IsOnly
        {
            get { return CurrentLabel.IsOnly; }
        }
		#endregion
	}
}
