/* MainWindowControl */

#import <Cocoa/Cocoa.h>
#import "option.h"

/* MessageBoxDlg Return value */
#define MBR_OK		0
#define MBR_CANCEL	1
#define MBR_YES		2
#define MBR_NO		3
#define MBR_ABORT	4
#define MBR_RETRY	5
#define MBR_IGNORE	6

/* MessageBoxDlg Flags */
#define MBF_TYPEMASK		0x000f
#define MBF_TYPEABORTRETRYIGNORE 0x0001	/* ~/Ďs/ */
#define MBF_TYPEOKCANCEL	0x0002  /* OK/LZ */
#define MBF_TYPERETRYCANCEL	0x0003  /* Ďs/LZ */
#define MBF_TYPEYESNO		0x0004  /* ͂/ */
#define MBF_TYPEYESNOCANCEL	0x0005  /* ͂//LZ */
#define MBF_TYPEOK		0x0006  /* OK */

#define MBF_ICONMASK		0x00f0
#define MBF_ICONEXCLAMATION	0x0010
#define MBF_ICONINFORMATION	0x0020
#define MBF_ICONQUESTION	0x0030
#define MBF_ICONSTOP		0x0040


@interface MainWindowControl : NSObject
{
    IBOutlet id buttonQuit;
    IBOutlet id buttonStartCopy;
    IBOutlet id meter1;
    IBOutlet id meter1Label;
    IBOutlet id meter2;
    IBOutlet id meter2Label;
    IBOutlet id readerCombo;
    IBOutlet id writerCombo;
    IBOutlet id settingPanel;
	IBOutlet id infoLabel;
}
- (IBAction)exitProgram:(id)sender;
- (IBAction)scanDrive:(id)sender;
- (IBAction)startCopy:(id)sender;
- (void)startUp;
- (void)uiCtlMeter1Initialize:(const char *)string;
- (void)uiCtlMeter2Initialize:(const char *)string;
- (void)uiCtlMeter1Update:(int)percentage;
- (void)uiCtlMeter2Update:(int)percentage;
- (void)uiCtlDispInfo:(const char *)string;
- (int)uiCtlSetting:(OPTIONS *)option;
- (int)MessageBoxDlg : (const char *)messageKey
				title : (const char *)titleKey
				flags : (int)flags;
- (void)startCopyThread : (id)object;
@end
