/* ~Օʉ
 * Copyright (C) 2004 Kagetani Hideto
 */

#ifdef linux
# define _LARGEFILE_SOURCE
# define _FILE_OFFSET_BITS 64
#endif

#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#ifdef linux
# include <fcntl.h>
#endif
#include <time.h>
#if defined(WIN32)
# include <io.h>
#endif
#if !defined(MACOSX)
# include <malloc.h>
#endif
#include "aspi.h"
#include "struct.h"
#include "cmd.h"
#include "ui.h"

#define IMGFILEMAXSIZE	0x40000000	/* 1giga-bytes */

#define IMAGETYPE_ORIGINAL	0		/* ~ՕʉC[W */
#define IMAGETYPE_ISO		1		/* ISO9660C[W */

typedef struct {
  DRIVE *drive;
  FILE *fp;
  char *filename;
  int fileindex;
  DWORD bytecount;
  int disc_type;
  int image_type;
} COPYDRIVE;

typedef struct {
	struct _TRACKINFO trackinfo;
	BYTE mode2;			/* MODE2Ȃ1AȊO0 */
	BYTE isrc[12+1];
	BOOL tao;			/* TAOŋL^Ă邩ǂ */
	WORD pause_len;		/* Audio Pause Length */
} CPTRACKINFO;

#define IS_TRACKMODE_DATA(m)	(((m) & 0x0c)==4)

#define IMGFILE_VERSION 0

typedef struct {
	BYTE version;		/* IMGFILE_VERSION */
	BYTE disc_type;
	BYTE disc_stat;
	BYTE last_sess_stat;
	BYTE media_catalog_number[13+1];
	DWORD last_addr;
	WORD sessions;
	WORD tracks;
	BYTE *cdtext;
	int cdtext_size;
	CPTRACKINFO *trackinfo;	/* <= KŌ */
} CPDISCINFO;

#define REALDRIVE(d)	((d)->drive!=NULL)
#define virtual_drvDRIVE(d)	((d)->drive==NULL)

void DebugLog(char *fmt, ...)
{
#ifdef DEBUGLOG
	va_list args;
	char str[512];
	FILE *fp;
	time_t now;

	fp = fopen("enban.log", "a");
	if(fp == NULL)
		return;

	time(&now);
	strftime(str, sizeof(str)-1, "%Y/%m/%d %H:%M:%S : ", localtime(&now));
	fputs(str, fp);

	va_start(args, fmt);
	vsprintf(str, fmt, args);

	fputs(str, fp);
	fclose(fp);
#endif
}


static void RemoveImageFile(const char *basefilename)
{
	char *filename;
	int i;

	remove(basefilename);
	filename = malloc(strlen(basefilename)+2+1);
	for(i=1; i<=9; i++){
		sprintf(filename, "%s.%d", basefilename, i);
		remove(filename);
	}
	free(filename);
}


static int CloseImageFile(COPYDRIVE *cpdrv)
{
	if(cpdrv->fp!=NULL){
		fclose(cpdrv->fp);
		cpdrv->fp = NULL;
		cpdrv->bytecount = 0;
	}
	return RET_OK;
}

static int OpenImageFile(COPYDRIVE *cpdrv, BOOL reader)
{
	char filename[_MAX_PATH];

	CloseImageFile(cpdrv);
	if(strlen(cpdrv->filename)+2+1 >= sizeof(filename) ||
			cpdrv->fileindex>=10 || cpdrv->fileindex<0){
		UIDispMessage("C[Wt@C̃I[vɎs܂B", UIDMT_ERROR);
		return RET_NG;
	}
	strcpy(filename, cpdrv->filename);
	if(cpdrv->fileindex>0)
		sprintf(filename+strlen(filename), ".%d", cpdrv->fileindex);

#ifdef WIN32
	cpdrv->fp = fopen(filename, reader ? "rb" : "wb");
#else
	cpdrv->fp = fopen(filename, reader ? "r" : "w");
#endif
	if(cpdrv->fp==NULL){
		UIDispMessage("C[W@C̃I[vɎs܂B", UIDMT_ERROR);
		return RET_NG;
	}
	cpdrv->bytecount = 0;

	return RET_OK;
}

static int OpenNextImageFile(COPYDRIVE *cpdrv, BOOL reader)
{
	cpdrv->fileindex++;
	return OpenImageFile(cpdrv, reader);
}

static int ReadImageFile(COPYDRIVE *cpdrv, void *buf, DWORD size)
{
	int ret;
	BYTE *bufp = (BYTE *)buf;

	if(size > IMGFILEMAXSIZE-cpdrv->bytecount){
		fread(bufp, (IMGFILEMAXSIZE-cpdrv->bytecount), 1, cpdrv->fp);
		bufp += (IMGFILEMAXSIZE-cpdrv->bytecount);
		size -= (IMGFILEMAXSIZE-cpdrv->bytecount);
		ret = OpenNextImageFile(cpdrv, TRUE);
		if(ret!=RET_OK)
			return ret;
	}
	fread(bufp, size, 1, cpdrv->fp);
	cpdrv->bytecount += size;

	return RET_OK;
}

static int WriteImageFile(COPYDRIVE *cpdrv, void *buf, DWORD size)
{
	int ret;
	BYTE *bufp = (BYTE *)buf;

	if(size > IMGFILEMAXSIZE-cpdrv->bytecount){
		fwrite(bufp, (IMGFILEMAXSIZE-cpdrv->bytecount), 1, cpdrv->fp);
		bufp += (IMGFILEMAXSIZE-cpdrv->bytecount);
		size -= (IMGFILEMAXSIZE-cpdrv->bytecount);
		ret = OpenNextImageFile(cpdrv, FALSE);
		if(ret!=RET_OK)
			return ret;
	}
	fwrite(bufp, size, 1, cpdrv->fp);
	cpdrv->bytecount += size;

	return RET_OK;
}


static int OpenDevice(COPYDRIVE *cpdrv, DRIVE *drive,
					  const char *filename, BOOL reader, BOOL bWaitDisc)
{
	int ret;

	if(filename!=NULL){
		  /* zfoCX */
	  cpdrv->filename = strdup(filename);
	  cpdrv->fileindex = 0;
	  cpdrv->fp = NULL;
	  ret = OpenImageFile(cpdrv, reader);
	  if(ret!=RET_OK)
		return ret;
	  cpdrv->drive = NULL;
	  cpdrv->disc_type = DT_UNKNOWN;
	  cpdrv->image_type = IMAGETYPE_ORIGINAL;
	}
	else{
	  cpdrv->drive = drive;
	  cpdrv->fp = NULL;
	  cpdrv->filename = NULL;
	  ret = GetDiscType(cpdrv->drive, &cpdrv->disc_type, bWaitDisc);
	  if(ret!=RET_OK){
		if(ret!=RET_ABORT && bWaitDisc){
		  UIDispMessage("fBXN^Cv擾Ɏs܂B", UIDMT_ERROR);
		}
		return ret;
	  }
	  ret = SendPreventAllow(cpdrv->drive, 1);
	  if(ret!=RET_OK){
		DispCommandError(cpdrv->drive);
		return ret;
	  }
	}

	return RET_OK;
}

static void CloseDevice(COPYDRIVE *cpdrv)
{
	if(!REALDRIVE(cpdrv)){
		/* zfoCX */
		CloseImageFile(cpdrv);
		if(cpdrv->filename!=NULL){
			free(cpdrv->filename);
			cpdrv->filename = NULL;
		}
	}
	else{
		SendPreventAllow(cpdrv->drive, 0);
	}
}

static int SetDiscInformation(COPYDRIVE *cpdrv, CPDISCINFO *discinfo)
{
  int ret;

  if(virtual_drvDRIVE(cpdrv)){
	if(cpdrv->image_type == IMAGETYPE_ISO){
		  /* ISOC[W̏ꍇ́A1ZbV̂ */
	  if(discinfo->sessions > 1){
		UIDispMessage("}`ZbṼC[Wt@C͏o܂B",
					  UIDMT_ERROR);
		return RET_NG;
	  }
	}
	else{
		  /* ~ՕʉIWiC[W */
		  /* C[Wt@CɃfBXN */
	  discinfo->version = IMGFILE_VERSION;
	  ret = WriteImageFile(cpdrv, discinfo,
						   sizeof(CPDISCINFO)-sizeof(CPTRACKINFO *));
	  if(ret!=RET_OK)
		return ret;
	  
	  if(discinfo->cdtext_size>0){
		ret = WriteImageFile(cpdrv, discinfo->cdtext, discinfo->cdtext_size);
		if(ret!=RET_OK)
		  return ret;
	  }
	  ret = WriteImageFile(cpdrv, discinfo->trackinfo,
						   sizeof(CPTRACKINFO)*discinfo->tracks);
	  if(ret!=RET_OK)
		return ret;
	}
  }
  
  return RET_OK;
}

static int WhetherTAO(COPYDRIVE *cpdrv, WORD sess_num, BOOL *result,
					  DWORD *lout_start)
{
	int ret;
	int i;
	struct _FULLTOCDESC *ftd;
	DWORD lba=0UL;

	if(virtual_drvDRIVE(cpdrv))
		return RET_OK;

	*lout_start = 0UL;
	*result = TRUE;
	if(!DT_CD_FAMILY(cpdrv->disc_type))
		return RET_OK;

	/* TOC񂩂YZbṼ[hAEgJnAhX߂ */
	ret = SendReadToc(cpdrv->drive, sess_num, 1, RTF_FULLTOC);
	if(ret!=RET_OK){
		/* I[vZbV݂̂̏ꍇ̓G[ɂȂ...̂? */
		return RET_OK;
	}

	for(i=sizeof(struct _TOCHEADER); i<cpdrv->drive->bufsize; i+=sizeof(struct _FULLTOCDESC)){
		ftd = (struct _FULLTOCDESC *)(cpdrv->drive->data_buf+i);
		if(ftd->point == 0xa2){
			lba = MSF2LBA(ftd->pmin, ftd->psec, ftd->pframe, FALSE);
			break;
		}
	}

	if(lba==0UL){
		/* 炭I[vZbVȂ̂ŁATAO */
		return RET_OK;
	}

	*lout_start = lba;

	/* [hAEgJnAhX̒O2ubNǂł݂ */
	ret = SendReadCD(cpdrv->drive, lba-2, 2);
	if(ret==RET_OK){
		/* ǂ߂A炭 Run-out L^ĂȂ̂ SAO */
		*result = FALSE;
	}

	return RET_OK;
}

static int GetGapLen(COPYDRIVE *cpdrv, CPTRACKINFO *cpti)
{
	int ret;
	DWORD search_start, search_end, lba, track_start;
	DWORD real_start;
	BYTE track_num = cpti->trackinfo.track_number_lsb;

	track_start = Get4bytes(cpti->trackinfo.track_start);
	search_end = track_start;
	search_start = search_end - 151;	/* GAP=150ʓIȂ̂ŁA̎O猟 */
	real_start = search_start;

	while(TRUE){
		/*
		 * QTV[PVŃANZXԂ񑬂
		 */
		for(lba=search_start; lba<search_end; lba++){
			ret = GetSubQ(cpdrv->drive, lba, 1);
			if(ret!=RET_OK){
				search_start++;
				continue;
			}
			if((cpdrv->drive->data_buf[0] & 0x0f)!=0x01){
				/* ԂISRCMediaCatalogNumberL^Ă */
				search_start++;
				continue;
			}
			if(track_num==cpdrv->drive->data_buf[1]){
				break;
			}
		}
		if(lba==real_start){
			/* 擪ɃMbvȂAƑO猟 */
			search_end = search_start;
			search_start -= 150;
			real_start = search_start;
			continue;
		}
		break;
	}
	if(lba >= track_start)
		cpti->pause_len = 0;
	else if(track_start-lba > 0xffff)
		cpti->pause_len = 0xffff;
	else
		cpti->pause_len = (WORD)(track_start - lba);

	if(cpti->pause_len>0){
		/* Ô߁AMbv̍ŌmF */
		ret = GetSubQ(cpdrv->drive, Get4bytes(cpti->trackinfo.track_start)-1, 1);
		if(ret==RET_OK){
			if((cpdrv->drive->data_buf[0] & 0x0f)==0x01 &&
				cpdrv->drive->data_buf[1]==track_num &&
				cpdrv->drive->data_buf[2]>0){
				cpti->pause_len--;
			}
		}
	}

	return RET_OK;
}


static int GetTrackInformation(COPYDRIVE *cpdrv, WORD track_num, CPTRACKINFO *cpti)
{
	int ret;

	ret = SendReadTrackInfo(cpdrv->drive, track_num);
	if(ret!=RET_OK){
		DispCommandError(cpdrv->drive);
		return ret;
	}
	memcpy(&cpti->trackinfo, cpdrv->drive->data_buf, sizeof(struct _TRACKINFO));
	cpti->mode2 = 0;
	cpti->pause_len = 0;
	if(cpti->trackinfo.blank)
		return RET_OK;
	if(DT_CD_FAMILY(cpdrv->disc_type)){
		memset(cpti->isrc, 0, 12+1);
		if(IS_TRACKMODE_DATA(cpti->trackinfo.track_mode)){
			/* MODE2ǂ𒲂ׂ */
			ret = SendReadCD(cpdrv->drive,
				Get4bytes(cpti->trackinfo.track_start), 1);
			if(ret!=RET_OK){
				DispCommandError(cpdrv->drive);
				return ret;
			}
			if(cpdrv->drive->data_buf[15]==2)
				cpti->mode2 = 1;
		}
		else{
			ret = SendReadSubchannel(cpdrv->drive, (BYTE)track_num, 0, 1, RSCF_ISRC);
			if(ret!=RET_OK){
				DispCommandError(cpdrv->drive);
				return ret;
			}
			if(cpdrv->drive->data_buf[8] & 0x80){
				memcpy(cpti->isrc, cpdrv->drive->data_buf+9, 12);
			}
			if(track_num>1){
				/* Mbv𒲂ׂ */
				ret = GetGapLen(cpdrv, cpti);
				if(ret!=RET_OK){
					return ret;
				}
			}
		}
	}

	return RET_OK;
}

static int AdjustTrackSize(COPYDRIVE *cpdrv, CPDISCINFO *discinfo, WORD track_num, DWORD lout_start)
{
	DWORD next_start=0;
	CPTRACKINFO *cpti, *ncpti=NULL;
	DWORD lba, track_size;
	int ret;
#if 0
	char buf[80];
#endif

	if(virtual_drvDRIVE(cpdrv))
		return RET_OK;

	if(DT_DVD_FAMILY(cpdrv->disc_type))
		return RET_OK;

	next_start = lout_start;
	cpti = &discinfo->trackinfo[track_num-1];
	if(cpti->tao){
		/* gbNȂgbN̍Ō2ubNǂł݂ */
		if(Get4bytes(cpti->trackinfo.free_blocks)==0){
			lba = Get4bytes(cpti->trackinfo.track_start) + 
					Get4bytes(cpti->trackinfo.track_size) -2;
			ret = SendReadCD(cpdrv->drive, lba, 2);
			if(ret!=RET_OK){
				/* ǂ߂ȂȂ炽Ԃ Run-out ł傤 */
				track_size = Get4bytes(cpti->trackinfo.track_size) -2;
				Set4bytes(cpti->trackinfo.track_size, track_size);
			}
		}
		return RET_OK;
	}
	if(track_num < discinfo->tracks){
		ncpti = &discinfo->trackinfo[track_num];
		if(((WORD)cpti->trackinfo.session_number_msb<<8 | cpti->trackinfo.session_number_lsb)==
			((WORD)ncpti->trackinfo.session_number_msb<<8 | ncpti->trackinfo.session_number_lsb)){
			/* ̃gbNZbV */
			next_start = Get4bytes(ncpti->trackinfo.track_start);
			if(IS_TRACKMODE_DATA(ncpti->trackinfo.track_mode)){
				next_start -= 150;
				if(!IS_TRACKMODE_DATA(cpti->trackinfo.track_mode) ||
					ncpti->mode2 != cpti->mode2){
					/* 2part */
					next_start -= 75;
				}
			}
			else{
				next_start -= ncpti->pause_len;
			}
		}
	}
	if(next_start==0)
		return RET_OK;

	/* ۂɓǂł݂? */
	for(lba=next_start-4; lba<next_start; lba++){
		ret = SendReadCD(cpdrv->drive, lba, 1);
		if(ret!=RET_OK)
			break;
	}

	track_size = lba-Get4bytes(cpti->trackinfo.track_start);
#if 0
	if(track_size != Get4bytes(cpti->trackinfo.track_size)){
		sprintf(buf, "gbN%d ̃TCY 0x%08lX  0x%08lX ɕύX܂B",
			track_num, Get4bytes(cpti->trackinfo.track_size), track_size);
		UIDispMessage(buf, UIDMT_INFORMATION);
	}
#endif
	Set4bytes(cpti->trackinfo.track_size, track_size);

	return RET_OK;
}

static int GetCDText(COPYDRIVE *cpdrv, CPDISCINFO *discinfo)
{
	int ret;
	WORD len;

	ret = SendReadToc(cpdrv->drive, 0, 0, RTF_CDTEXT);
	if(ret!=RET_OK){
		return RET_OK;
	}
	len = Get2bytes(cpdrv->drive->data_buf);
	if(len<=2){	/* header(4bytes) - length field(2bytes) */
		/* CD-TEXTȂ */
		return RET_OK;
	}
	len -= 2;
	discinfo->cdtext = (BYTE *)malloc(len);
	if(discinfo->cdtext==NULL)
		return RET_MEMERR;
	memcpy(discinfo->cdtext, cpdrv->drive->data_buf+4, len);
	discinfo->cdtext_size = len;
	return RET_OK;
}


static int GetDiscInformation(COPYDRIVE *cpdrv, CPDISCINFO *discinfo)
{
	int ret;
	WORD track_num;
	WORD sess_num, last_sess_num;
	BOOL tao;
	struct _DISCINFO *di;
	CPTRACKINFO *cpti;
	DWORD last_addr=0, lout_start=0;
	DWORD track_size;
#ifdef WIN32
	__int64 file_size;
#else
	off_t file_size;
#endif

	if(virtual_drvDRIVE(cpdrv)){
	  if(cpdrv->image_type == IMAGETYPE_ISO){
			/* ISOC[Wt@C̏ꍇ */
		memset(discinfo, 0, sizeof(CPDISCINFO));
			/* t@CTCY擾 */
#ifdef WIN32
		file_size = _lseeki64(_fileno(cpdrv->fp), 0, SEEK_END);
		_lseeki64(_fileno(cpdrv->fp), 0, SEEK_SET);
#else
		fseeko(cpdrv->fp, 0, SEEK_END);
		file_size = ftello(cpdrv->fp);
		fseeko(cpdrv->fp, 0, SEEK_SET);
#endif
		track_size = (DWORD)((file_size+2047)/2048);
		
			/* fBXNݒ */
		discinfo->disc_stat = DISCSTAT_COMPLETE;
		discinfo->last_sess_stat = SESSSTAT_COMPLETE;
		discinfo->last_addr = (DWORD)(track_size-1);
		discinfo->sessions = 1;
		discinfo->tracks = 1;
		discinfo->trackinfo = (CPTRACKINFO *)malloc(sizeof(CPTRACKINFO));
		if(discinfo->trackinfo==NULL){
		  free(discinfo->cdtext);
		  discinfo->cdtext = NULL;
		  return RET_MEMERR;
		}
		memset(discinfo->trackinfo, 0, sizeof(CPTRACKINFO));
		discinfo->trackinfo->mode2 = 0;
		discinfo->trackinfo->tao = FALSE;
		discinfo->trackinfo->trackinfo.track_number_lsb = 1;
		discinfo->trackinfo->trackinfo.session_number_lsb = 1;
		discinfo->trackinfo->trackinfo.track_mode = 4;
		discinfo->trackinfo->trackinfo.data_mode = 0x0f;
		Set4bytes(discinfo->trackinfo->trackinfo.track_start, 0);
		Set4bytes(discinfo->trackinfo->trackinfo.track_size, track_size);
	  }
	  else{
			/* C[Wt@CfBXN𓾂 */
		ret = ReadImageFile(cpdrv, discinfo, sizeof(CPDISCINFO)-sizeof(CPTRACKINFO *));
		if(ret!=RET_OK)
		  return ret;
		if(discinfo->version != IMGFILE_VERSION){
		  return RET_NG;
		}
			/* CD-TEXT */
		if(discinfo->cdtext_size>0){
		  discinfo->cdtext = (BYTE *)malloc(discinfo->cdtext_size);
		  if(discinfo->cdtext==NULL)
			return RET_MEMERR;
		  ret = ReadImageFile(cpdrv, discinfo->cdtext,
							  discinfo->cdtext_size);
		  if(ret!=RET_OK){
			free(discinfo->cdtext);
			discinfo->cdtext = NULL;
			return ret;
		  }
		}
		else{
		  discinfo->cdtext = NULL;
		}
			/* gbN */
		discinfo->trackinfo = (CPTRACKINFO *)malloc(sizeof(CPTRACKINFO)*discinfo->tracks);
		if(discinfo->trackinfo==NULL){
		  free(discinfo->cdtext);
		  discinfo->cdtext = NULL;
		  return RET_MEMERR;
		}
		ret = ReadImageFile(cpdrv, discinfo->trackinfo,
							sizeof(CPTRACKINFO)*discinfo->tracks);
		if(ret!=RET_OK){
		  free(discinfo->cdtext);
		  discinfo->cdtext = NULL;
		  free(discinfo->trackinfo);
		  discinfo->trackinfo = NULL;
		  return ret;
		}
	  }
	  return RET_OK;
	}

	ret = SendReadDiscInfo(cpdrv->drive);
	if(ret!=RET_OK){
	  DispCommandError(cpdrv->drive);
	  return ret;
	}
	di = (struct _DISCINFO *)cpdrv->drive->data_buf;
	discinfo->disc_stat = di->disc_status;
	discinfo->last_sess_stat = di->sess_status;
	discinfo->sessions = (WORD)di->numsess_msb<<8 | di->numsess_lsb;
	discinfo->tracks = (WORD)di->last_track_ls_msb<<8 | di->last_track_ls_lsb;
	discinfo->disc_type = di->disc_type;

	discinfo->cdtext = NULL;
	discinfo->cdtext_size = 0;
	memset(discinfo->media_catalog_number, 0, 13+1);
	if(DT_CD_FAMILY(cpdrv->disc_type)){
		ret = SendReadSubchannel(cpdrv->drive, 0, 0, 1, RSCF_MCN);
		if(ret!=RET_OK){
			DispCommandError(cpdrv->drive);
			return ret;
		}
		if(cpdrv->drive->data_buf[8] & 0x80){
			memcpy(discinfo->media_catalog_number, cpdrv->drive->data_buf+9, 13);
		}
		/* CD-TEXT */
		ret = GetCDText(cpdrv, discinfo);
		if(ret!=RET_OK){
			return ret;
		}
	}

	/* gbNƂɏ擾 */
	UIMeter1Initialize("擾");
	discinfo->trackinfo = (CPTRACKINFO *)malloc(sizeof(CPTRACKINFO)*discinfo->tracks);
	for(track_num=1; track_num<=discinfo->tracks; track_num++){
		UIMeter1Update(track_num*100/discinfo->tracks/2);
		if(UICheckAbort()){
			free(discinfo->cdtext);
			discinfo->cdtext = NULL;
			free(discinfo->trackinfo);
			discinfo->trackinfo = NULL;
			return RET_ABORT;
		}
		cpti = &discinfo->trackinfo[track_num-1];
		ret = GetTrackInformation(cpdrv, track_num, cpti);
		if(ret!=RET_OK){
			free(discinfo->cdtext);
			discinfo->cdtext = NULL;
			free(discinfo->trackinfo);
			discinfo->trackinfo = NULL;
			return ret;
		}
	}

	last_sess_num = 0;
	for(track_num=1; track_num<=discinfo->tracks; track_num++){
		UIMeter1Update(track_num*100/discinfo->tracks/2+50);
		if(UICheckAbort()){
			free(discinfo->cdtext);
			discinfo->cdtext = NULL;
			free(discinfo->trackinfo);
			discinfo->trackinfo = NULL;
			return RET_ABORT;
		}
		cpti = &discinfo->trackinfo[track_num-1];
		/* ZbVTAOL^ǂ𒲂ׂ */
		sess_num = (WORD)cpti->trackinfo.session_number_msb<<8 |
						cpti->trackinfo.session_number_lsb;
		if(sess_num != last_sess_num){
			ret = WhetherTAO(cpdrv, sess_num, &tao, &lout_start);
			if(ret!=RET_OK){
				free(discinfo->cdtext);
				discinfo->cdtext = NULL;
				free(discinfo->trackinfo);
				discinfo->trackinfo = NULL;
				return ret;
			}
			last_sess_num = sess_num;
		}
		cpti->tao = tao;
		/* gbNTCY */
		ret = AdjustTrackSize(cpdrv, discinfo, track_num, lout_start);
		if(ret!=RET_OK){
			free(discinfo->cdtext);
			discinfo->cdtext = NULL;
			free(discinfo->trackinfo);
			discinfo->trackinfo = NULL;
			return ret;
		}
		/* fBXNŏIAhXXV */
		if(cpti->trackinfo.nwa_valid){
			if(Get4bytes(cpti->trackinfo.next_writable_addr) > Get4bytes(cpti->trackinfo.track_start))
				last_addr = Get4bytes(cpti->trackinfo.next_writable_addr);
		}
		else{
			last_addr = Get4bytes(cpti->trackinfo.track_start) +
						Get4bytes(cpti->trackinfo.track_size);
		}
	}
	discinfo->last_addr = last_addr;

	if(DT_DVD_FAMILY(cpdrv->disc_type) && discinfo->tracks>1){
		/* DVDDAOł͕gbNL^łȂ */
		if(GetOption()->dao){
			ret = UIDispMessage("gbN݂̂ DAO L^ł܂B\nTAO ŋL^𑱍s܂H",
					UIDMT_QUESTION);
			if(ret!=UIDMRET_OK){
				free(discinfo->cdtext);
				discinfo->cdtext = NULL;
				free(discinfo->trackinfo);
				discinfo->trackinfo = NULL;
				return RET_ABORT;
			}
			GetOption()->dao = FALSE;
		}
	}

	return RET_OK;
}

static int FormatDVD(COPYDRIVE *cpdrv, BYTE type, DWORD size)
{
	int ret;
	WORD len, offset;
	struct _FORMATCAPA_HEADER *fch;
	struct _FORMATLIST_HEADER *fh;
	struct _FORMATDESC *fd, fcd;
	const char *message;

	if(virtual_drvDRIVE(cpdrv))
		return RET_OK;

	/* Format Descriptor 𓾂 */
	ret = SendReadFormatCapacities(cpdrv->drive);
	if(ret!=RET_OK){
		DispCommandError(cpdrv->drive);
		return ret;
	}
	fch = (struct _FORMATCAPA_HEADER *)cpdrv->drive->data_buf;
	len = fch->list_len;
	offset = sizeof(struct _FORMATCAPA_HEADER) + sizeof(struct _FORMATCURMAXDESC);
	for(; offset<len; offset += sizeof(struct _FORMATDESC)){
		fd = (struct _FORMATDESC *)(cpdrv->drive->data_buf + offset);
		if(fd->format_type==type){
			memcpy(&fcd, fd, sizeof(struct _FORMATDESC));
			break;
		}
	}
	if(offset>=len){
		return RET_NG;
	}

	fh = (struct _FORMATLIST_HEADER *)cpdrv->drive->data_buf;
	fd = (struct _FORMATDESC *)(cpdrv->drive->data_buf+sizeof(struct _FORMATLIST_HEADER));
	memset(fh, 0, sizeof(struct _FORMATLIST_HEADER));
	memcpy(fd, &fcd, sizeof(struct _FORMATDESC));
	fh->fov = 1;
	fh->immed = 1;
	Set2bytes(fh->fmtdesc_len, sizeof(struct _FORMATDESC));
	if(Get4bytes(fd->num_blocks) > size)
		Set4bytes(fd->num_blocks, size);
	len = sizeof(struct _FORMATLIST_HEADER) + sizeof(struct _FORMATDESC);
	ret = SendFormatUnit(cpdrv->drive, 1, 0, FUFC_OTHER, len);
	if(ret!=RET_OK){
		DispCommandError(cpdrv->drive);
		return ret;
	}

	if(type==FDFT_QUICK || type==FDFT_QUICKADD || type==FDFT_QUICKGROW)
		message = "";
	else
		message = "";
	ret = WaitProgress(cpdrv->drive, message, FALSE);
	if(ret!=RET_OK){
		if(ret==RET_CMDERR)
			DispCommandError(cpdrv->drive);
		return ret;
	}

	return RET_OK;
}

static int Formatting(COPYDRIVE *cpdrv)
{
	int ret;
	struct _DISCINFO *di;

	if(virtual_drvDRIVE(cpdrv)){
		return RET_OK;
	}

	if(cpdrv->disc_type!=DT_DVDPRW){
		return RET_OK;
	}

	ret = SendReadDiscInfo(cpdrv->drive);
	if(ret!=RET_OK){
		DispCommandError(cpdrv->drive);
		return ret;
	}

	di = (struct _DISCINFO *)cpdrv->drive->data_buf;
	if(di->bgformat_stat != BGFSTAT_NOTFORMATTED){
		return RET_OK;
	}

	ret = FormatDVD(cpdrv, FDFT_DVDPRW, 0xffffffff);
	if(ret!=RET_OK){
		return ret;
	}

	return RET_OK;
}

static int Blanking(COPYDRIVE *cpdrv)
{
	int ret;
	struct _DISCINFO *di;

	if(virtual_drvDRIVE(cpdrv)){
		return RET_OK;
	}

	if(cpdrv->disc_type==DT_DVDRWS || cpdrv->disc_type==DT_DVDRWO){
		if(GetOption()->dao==FALSE){
			/* QuickFormat ̂ Blank sv */
			return RET_OK;
		}
	}
	if(cpdrv->disc_type==DT_DVDPRW){
		/* sv */
		return RET_OK;
	}
	ret = SendReadDiscInfo(cpdrv->drive);
	if(ret!=RET_OK){
		DispCommandError(cpdrv->drive);
		return ret;
	}

	di = (struct _DISCINFO *)cpdrv->drive->data_buf;
	if(di->disc_status==DISCSTAT_EMPTY){
		return RET_OK;
	}
	if(di->erasable==0){
		UIDispMessage("L^fBXNuNł͂Ȃ̂ŕʂł܂B", UIDMT_ERROR);
		return RET_NG;
	}

	ret = UIDispMessage("L^fBXNuNł͂܂B܂H", UIDMT_QUESTION);
	if(ret==UIDMRET_CANCEL){
		return RET_ABORT;
	}

	ret = BlankDisc(cpdrv->drive, 1);
	if(ret!=RET_OK){
		if(ret==RET_CMDERR){
			DispCommandError(cpdrv->drive);
		}
		return ret;
	}

	return RET_OK;
}

static int GetWritableSize(COPYDRIVE *cpdrv, DWORD *size_ret)
{
	int ret;
	WORD track_num;
	struct _DISCINFO *di;
	struct _TRACKINFO *ti;

	*size_ret = 0UL;
	if(virtual_drvDRIVE(cpdrv))
		return RET_OK;

	ret = SendReadDiscInfo(cpdrv->drive);
	if(ret!=RET_OK){
		DispCommandError(cpdrv->drive);
		return ret;
	}
	di = (struct _DISCINFO *)cpdrv->drive->data_buf;
	track_num = (WORD)di->last_track_ls_msb<<8 | di->last_track_ls_lsb;
	ret = SendReadTrackInfo(cpdrv->drive, track_num);
	if(ret!=RET_OK){
		DispCommandError(cpdrv->drive);
		return ret;
	}
	ti = (struct _TRACKINFO *)cpdrv->drive->data_buf;
	*size_ret = Get4bytes(ti->free_blocks);

	return RET_OK;
}


static int CloseSession(COPYDRIVE *cpdrv, int num_drv)
{
	int ret;
	int index;

	for(index=0; index<num_drv; index++){
	  if(virtual_drvDRIVE(&cpdrv[index]))
		continue;

	  ret = SendCloseTrackSession(cpdrv[index].drive, 1, CTST_CLOSESESSION, 0);
	  if(ret!=RET_OK){
		DispCommandError(cpdrv->drive);
		return ret;
	  }
	}

	index=num_drv-1;
	ret = WaitProgress(cpdrv[index].drive, "ZbV", FALSE);
	if(ret!=RET_OK){
	  if(ret==RET_CMDERR)
		DispCommandError(cpdrv[index].drive);
	  return ret;
	}

	return RET_OK;
}

static int ExecCloseTrack(COPYDRIVE *cpdrv, int num_drv, WORD track_num)
{
	int ret;
	int index;

	if(virtual_drvDRIVE(&cpdrv[0]))
		return RET_OK;

	for(index=0; index<num_drv; index++){
	  ret = SendCloseTrackSession(cpdrv[index].drive, 1, CTST_CLOSETRACK,
								  track_num);
	  if(ret!=RET_OK){
		DispCommandError(cpdrv[index].drive);
		return ret;
	  }
	}

	index = num_drv-1;
	ret = WaitProgress(cpdrv[index].drive, "gbN", FALSE);
	if(ret!=RET_OK){
	  if(ret==RET_CMDERR)
		DispCommandError(cpdrv[index].drive);
	  return ret;
	}

	return RET_OK;
}

static int SyncCache(COPYDRIVE *cpdrv)
{
	int ret;

	if(virtual_drvDRIVE(cpdrv))
		return RET_OK;

	ret = SendSynchronizeCache(cpdrv->drive, 1);
	if(ret!=RET_OK){
		DispCommandError(cpdrv->drive);
		return ret;
	}

	ret = WaitProgress(cpdrv->drive, NULL, FALSE);
	if(ret!=RET_OK){
		if(ret==RET_CMDERR)
			DispCommandError(cpdrv->drive);
		return ret;
	}

	return RET_OK;
}

static int ReserveTrack(COPYDRIVE *cpdrv, DWORD size)
{
	int ret;

	if(virtual_drvDRIVE(cpdrv))
		return RET_OK;

	ret = SendReserveTrack(cpdrv->drive, size);
	if(ret!=RET_OK){
		DispCommandError(cpdrv->drive);
		return ret;
	}

	return RET_OK;
}


static int SetWriteParametersPage(COPYDRIVE *cpdrv, CPDISCINFO *discinfo, WORD track_num, BOOL sao)
{
	CPTRACKINFO *cpti;
	struct _MODEPAGE05 *mp05;
	WORD sess_num;
	int ret;

	if(virtual_drvDRIVE(cpdrv))
		return RET_OK;

	if(track_num==0)
		track_num=1;
	cpti = &discinfo->trackinfo[track_num-1];
	sess_num = (WORD)cpti->trackinfo.session_number_msb<<8 |
				(WORD)cpti->trackinfo.session_number_lsb;

	/* ݒl擾ĕKvȕ */
	ret = SendModeSense(cpdrv->drive, MSPC_CURRENT, 5);
	if(ret!=RET_OK){
		DispCommandError(cpdrv->drive);
		return ret;
	}
	mp05 = (struct _MODEPAGE05 *)(cpdrv->drive->data_buf +
									(cpdrv->drive->atapi ? 8 : 16));

	if(DT_DVD_FAMILY(cpdrv->disc_type)){
		mp05->write_type = MP05WT_PACKET;
		mp05->track_mode = MP05TM_DATA;
		mp05->dbtype = MP05DBT_MODE1;
	}
	else{
		mp05->track_mode = cpti->trackinfo.track_mode;
		if(IS_TRACKMODE_DATA(mp05->track_mode)){
			mp05->dbtype = cpti->mode2 ? MP05DBT_MIX : MP05DBT_MODE1;
			mp05->write_type = cpti->trackinfo.packet ? MP05WT_PACKET : MP05WT_TAO;
		}
		else{
			mp05->dbtype = MP05DBT_CDDA_2352;
			mp05->write_type = MP05WT_TAO;
		}
	}

	mp05->BUFE = GetOption()->bufe;
	mp05->test_write = GetOption()->test_write;
	if(discinfo->sessions == sess_num){
		/* ŏIZbV */
		mp05->multi_session = discinfo->disc_stat==DISCSTAT_COMPLETE ? 0 : 3;
	}
	else{
		mp05->multi_session = 3;
	}
	mp05->fp = cpti->trackinfo.fp;
	mp05->copy = cpti->trackinfo.copy;
	mp05->session_format = discinfo->disc_type;
	memcpy(mp05->packet_size, cpti->trackinfo.packet_size, 4);

	if(sao){
		mp05->write_type = MP05WT_SAO;
		mp05->track_mode = MP05TM_DATA;
		mp05->fp = 0;
		Set4bytes(mp05->packet_size, 0UL);
	}

	/* MCN */
	if(strlen(discinfo->media_catalog_number)>0){
		memcpy(mp05->media_cat_number, discinfo->media_catalog_number, 13);
		mp05->mc_val = 1;
	}
	else{
		memset(mp05->media_cat_number, 0, 13);
		mp05->mc_val = 0;
	}
	/* ISRC */
	if(strlen(cpti->isrc)>0){
		memcpy(mp05->ISRC, cpti->isrc, 12);
		mp05->tc_val = 1;
	}
	else{
		memset(mp05->ISRC, 0, 12);
		mp05->tc_val = 0;
	}

	ret = SendModeSelect(cpdrv->drive, 5);
	if(ret!=RET_OK){
		DispCommandError(cpdrv->drive);
		return ret;
	}

	return RET_OK;
}


static int SetSpeed(COPYDRIVE *cpdrv, int read_speed, int write_speed)
{
	int ret;
	WORD read_kbps, write_kbps;
	struct _PERFORMANCEDESC *pd;

	if(virtual_drvDRIVE(cpdrv))
		return RET_OK;

	if(DT_CD_FAMILY(cpdrv->disc_type)){
		read_kbps = read_speed ? (WORD)(read_speed*176.4) : 0xffff;
		write_kbps = write_speed ? (WORD)(write_speed*176.4) : 0xffff;
		ret = SendSetCdSpeed(cpdrv->drive, read_kbps, write_kbps, 0);
		if(ret!=RET_OK){
			DispCommandError(cpdrv->drive);
			return ret;
		}
	}
	else{
		pd = (struct _PERFORMANCEDESC *)cpdrv->drive->data_buf;
		memset(pd, 0, sizeof(struct _PERFORMANCEDESC));
		pd->rdd = (read_speed==0 && write_speed==0) ? 1:0;
		Set4bytes(pd->read_size, (DWORD)(read_speed*1385));
		Set4bytes(pd->read_time, 1000);
		Set4bytes(pd->write_size, (DWORD)(write_speed*1385));
		Set4bytes(pd->write_time, 1000);

		ret = SendSetStreaming(cpdrv->drive);
#if 0	/* G[ɂȂĂpׁA */
		if(ret!=RET_OK){
			DispCommandError(cpdrv->drive);
			return ret;
		}
#endif
	}

	return RET_OK;
}



static int GetVPSize(COPYDRIVE *cpdrv, DWORD lba, DWORD *size_ret)
{
	BYTE tmp[4];
	DWORD start_lba;
	DWORD len;
	int ret;

	if(virtual_drvDRIVE(cpdrv)){
	  if(cpdrv->image_type == IMAGETYPE_ISO){
		return RET_OK;
	  }
	  else{
		ret = ReadImageFile(cpdrv, tmp, 4);
		if(ret!=RET_OK)
		  return ret;
		*size_ret = Get4bytes(tmp);
	  }	  
	}
	else{
	  start_lba = lba;
	  len = cpdrv->drive->bufsize / 2352;
	  ret=RET_OK;
	  while(TRUE){
		while(TRUE){
		  if(UICheckAbort())
			return RET_ABORT;
		  ret = SendReadCD(cpdrv->drive, lba, len);
		  if(ret!=RET_OK)
			break;
		  lba += len;
		}
		if(len==1)
		  break;
		len=1;
	  }
	  *size_ret = lba - start_lba;
	}
	return RET_OK;
}

static int SetVPSize(COPYDRIVE *cpdrv, DWORD size)
{
	BYTE tmp[4];
	int ret;

	if(virtual_drvDRIVE(cpdrv)){
	  if(cpdrv->image_type == IMAGETYPE_ISO){
		return RET_OK;
	  }
	  else{
		Set4bytes(tmp, size);
		ret = WriteImageFile(cpdrv, tmp, 4);
		if(ret!=RET_OK)
		  return ret;
	  }
	}
	return RET_OK;
}

/*
 * blocksize  2048/2332/2336/2352 삷B
 * ȊO͑ΉĂȂB
 */
static int ExecReadWrite(COPYDRIVE *src, COPYDRIVE *dst, int num_dst,
						 DWORD lba, DWORD blocksize, DWORD len)
{
	int ret;
	BYTE *sp, *dp;
	DWORD cnt;
	int index;

	if(virtual_drvDRIVE(src) && virtual_drvDRIVE(&dst[0])){
		return RET_NG;
	}

	/* Read */
	if(virtual_drvDRIVE(src)){
	  ret = ReadImageFile(src, dst->drive->data_buf, blocksize*len);
	  if(ret!=RET_OK)
		return ret;
	}
	else{
	  if(blocksize==2048){
		ret = SendRead10(src->drive, lba, (WORD)len, len*blocksize);
	  }
	  else{
		ret = SendReadCD(src->drive, lba, len);
	  }
	  if(ret!=RET_OK){
		DispCommandError(src->drive);
		return ret;
	  }
	  if(blocksize==2332){
			/* ReadCD bs=2352 œǂ񂾂ǂA
			   KvȂ̂ 2332 Ȃ̂Ńobt@l߂ */
		sp = dp = src->drive->data_buf;
		sp += 16;	/* sync 16bytes */
		for(cnt=0; cnt<len; cnt++){
		  memmove(dp, sp, 2332);
		  sp += 2352;
		  dp += 2332;
		}
	  }
	  else if(blocksize==2336){
			/* 2336 Ƀobt@l߂ */
		sp = dp = src->drive->data_buf;
		sp += 16;	/* sync 16bytes */
		for(cnt=0; cnt<len; cnt++){
		  memmove(dp, sp, 2336);
		  sp += 2352;
		  dp += 2336;
		}
	  }
	}

	/* Write */
	if(virtual_drvDRIVE(&dst[0])){
	  ret = WriteImageFile(dst, src->drive->data_buf, len*blocksize);
	  if(ret!=RET_OK)
		return ret;
	}
	else{
	  for(index=0; index<num_dst; index++){
		ret = SendWrite10(dst[index].drive, lba, (WORD)len, len*blocksize);
		if(ret!=RET_OK){
		  DispCommandError(dst[index].drive);
		  return ret;
		}
	  }
	}

	return RET_OK;
}



static int OpenTrack(COPYDRIVE *cpdrv, CPDISCINFO *discinfo, WORD track_num)
{
	int ret;

	if(REALDRIVE(cpdrv)){
		if(DT_CD_FAMILY(cpdrv->disc_type)){
			ret = SetWriteParametersPage(cpdrv, discinfo, track_num,
				!discinfo->trackinfo[track_num-1].tao );
			if(ret!=RET_OK)
				return ret;
		}
		else{
			if(cpdrv->disc_type==DT_DVDR ||
					cpdrv->disc_type==DT_DVDRWS || cpdrv->disc_type==DT_DVDRWO){
				/* DVD-R/-RW */
				if(cpdrv->disc_type!=DT_DVDR && GetOption()->dao==FALSE){
					ret = FormatDVD(cpdrv,
							(BYTE)(track_num==1 ? FDFT_QUICK : FDFT_QUICKADD),
							0x00000000);
				}
				else{
					ret = SetWriteParametersPage(cpdrv, discinfo, track_num,
								GetOption()->dao);
				}
				if(ret!=RET_OK)
					return ret;
			}
		}
	}

	return RET_OK;
}


static int CloseTrack(COPYDRIVE *cpdrv, int num_drv,
					  CPDISCINFO *discinfo, WORD track_num)
{
	CPTRACKINFO *cpti;
	int ret;

	if(REALDRIVE(&cpdrv[0])){
	  cpti = &discinfo->trackinfo[track_num-1];
	  if(cpti->trackinfo.packet && cpti->trackinfo.nwa_valid==0 &&
		 Get4bytes(cpti->trackinfo.free_blocks)==0 &&
		 cpdrv[0].disc_type!=DT_DVDRWS &&
		 cpdrv[0].disc_type!=DT_DVDRWO &&
		 GetOption()->dao==FALSE){
		ret = ExecCloseTrack(cpdrv, num_drv, track_num);
		if(ret!=RET_OK)
		  return ret;
	  }
	}

	return RET_OK;
}

static void MakeCDTextBuffer(BYTE *buf, DWORD fillsize,
							BYTE *cdtext, DWORD cdtext_size, DWORD *cdtext_offset)
{
	DWORD cdtext_restsize;
	DWORD copysize;

	while(fillsize>0){
		cdtext_restsize = cdtext_size - (*cdtext_offset);
		if(fillsize < cdtext_restsize){
			copysize = fillsize;
		}
		else{
			copysize = cdtext_restsize;
		}

		memcpy(buf, cdtext+(*cdtext_offset), copysize);
		buf += copysize;
		fillsize -= copysize;
		*cdtext_offset += copysize;
		if(*cdtext_offset >= cdtext_size)
			*cdtext_offset = 0;
	}
}

/*
 * CRČvZ̓Tbp܂B
 * crc.h ɏĂʂAcdrecord 2.0 pNĂĂ܂B
 */
#define LOCAL
#define UInt16_t WORD
#include "crc.h"
static void CalcCDTextCRC(CPDISCINFO *discinfo)
{
	int i, j;
	WORD crc;

	for(i=0; i<discinfo->cdtext_size; i+=18){
		crc = 0;
		for(j=0; j<16; j++){
			crc = (crc<<BPB) ^ crctab[(crc>>(BPW-BPB)) ^ discinfo->cdtext[i+j]];
		}
		crc = crc ^ 0xFFFF;
		discinfo->cdtext[i+16] = (BYTE)(crc>>8);
		discinfo->cdtext[i+17] = (BYTE)(crc);
	}
}


static int WriteCDText(COPYDRIVE *cpdrv, int num_drv, CPDISCINFO *discinfo)
{
	int ret;
	struct _DISCINFO *di;
	DWORD lba;
	DWORD rest_blocks, total_blocks, len, deflen;
	BYTE *converted_cdtext=NULL;
	DWORD converted_cdtext_size;
	DWORD cdtext_offset=0;
	long t1, t2;
	DWORD i;

	if(virtual_drvDRIVE(&cpdrv[0]))
		return RET_OK;

	if(num_drv != 1){
	  UIDispMessage("uւCD-TEXT݂͖T|[głB",
					UIDMT_ERROR);
	  return RET_NG;
	}
	
	CalcCDTextCRC(discinfo);
	converted_cdtext_size = (discinfo->cdtext_size * 4+2)/3;
	converted_cdtext = malloc(converted_cdtext_size);
	if(converted_cdtext==NULL)
		return RET_MEMERR;
	for(i=0; i<converted_cdtext_size/4; i++){
		/*   8bit        6bit
		 * aaaaaaaa    00aaaaaa
		 * bbbbbbbb => 00aabbbb
		 * cccccccc    00bbbbcc
		 *             00cccccc
		 */
		converted_cdtext[i*4+0] = (discinfo->cdtext[i*3+0]>>2) & 0x3f;
		converted_cdtext[i*4+1] = ((discinfo->cdtext[i*3+0]<<4) & 0x30) |
								  ((discinfo->cdtext[i*3+1]>>4) & 0x0f);
		converted_cdtext[i*4+2] = ((discinfo->cdtext[i*3+1]<<2) & 0x3c) |
								  ((discinfo->cdtext[i*3+2]>>6) & 0x03);
		converted_cdtext[i*4+3] = (discinfo->cdtext[i*3+2]>>0) & 0x3f;
	}

	/* Lead-inJnԂ擾 */
	ret = SendReadDiscInfo(cpdrv->drive);
	if(ret!=RET_OK){
		DispCommandError(cpdrv->drive);
		return ret;
	}
	di = (struct _DISCINFO *)cpdrv->drive->data_buf;
	lba = MSF2LBA(di->last_lead_in[1],
					di->last_lead_in[2],
					di->last_lead_in[3], FALSE);
	rest_blocks = total_blocks = (DWORD)(-150-lba);

	/* 1xɓ]łubNvZ(1ubN=96bytes) */
	deflen = (cpdrv->drive->bufsize-1)/96;

	/* ʕ\ */
	UIMeter2Initialize("CD-TEXT");
	t1 = t2 = time(NULL);

	while(rest_blocks>0){
		t2 = time(NULL);
		if(t1!=t2){
			UIMeter2Update((total_blocks-rest_blocks)*100/total_blocks);
			t1=t2;
		}
		if(UICheckAbort()){
			ret = RET_ABORT;
			break;
		}

		len = deflen < rest_blocks ? deflen : rest_blocks;
		MakeCDTextBuffer(cpdrv->drive->data_buf, len*96,
						converted_cdtext, converted_cdtext_size, &cdtext_offset);
		ret = SendWrite10(cpdrv->drive, lba, (WORD)len, len*96);
		if(ret!=RET_OK){
			DispCommandError(cpdrv->drive);
			break;
		}
		lba += len;
		rest_blocks -= len;
	}

	free(converted_cdtext);

	return ret;
}


static int WriteLoop(COPYDRIVE *src, COPYDRIVE *dst, int num_dst,
					 DWORD lba, DWORD blocks, DWORD deflen,
					 DWORD blocksize, BOOL vp_track, DWORD last_addr, BOOL sao)
{
	int ret;
	DWORD rest_blocks, total_blocks, len;
	long t1, t2;
	int percent_total;
	double curr_speed=0;
	DWORD last_lba=lba;
	DWORD rest_time;
	char info[80];
	int index;

	rest_blocks = total_blocks = blocks;

	t1 = t2 = time(NULL);
	ret = RET_OK;
	while(rest_blocks>0 && ret==RET_OK){
	  if(vp_track){
		ret = GetVPSize(src, lba, &blocks);
		if(ret!=RET_OK)
		  break;
		for(index=0; index<num_dst; index++){
		  ret = SetVPSize(&dst[index], blocks);
		  if(ret!=RET_OK)
			break;
		}
		if(ret!=RET_OK)
		  break;
	  }
	  else
		blocks = rest_blocks;

	  while(blocks>0){
		t2 = time(NULL);
		if(t1!=t2){
		  percent_total = (lba*100/last_addr);
		  if(GetOption()->on_the_fly==FALSE)
			percent_total = percent_total/2 + (REALDRIVE(dst) ? 50 : 0);
		  UIMeter1Update(percent_total);
		  UIMeter2Update((total_blocks-rest_blocks)*100/total_blocks);
			  /* ]xvZ */
		  if(GetOption()->flags & OPFLG_DVD)
			curr_speed = (lba-last_lba)*2048/1024.0/1385;
		  else
			curr_speed = (lba-last_lba)*2352/1024.0/176.4;
		  sprintf(info, "%.1f{", curr_speed);
		  if(lba>last_lba){
				/* c莞ԌvZ */
			rest_time = (DWORD)(0.5+rest_blocks/(lba-last_lba));
			sprintf(info+strlen(info), " c莞 %d:%02d",
					(int)(rest_time/60), (int)(rest_time%60));
		  }
		  UIDispInfo(info);
		  last_lba = lba;
		  t1=t2;
		}
		if(UICheckAbort()){
		  ret = RET_ABORT;
		  break;
		}
		len = deflen>blocks ? blocks : deflen;
		ret = ExecReadWrite(src, dst, num_dst, lba, blocksize, len);
		if(ret!=RET_OK)
		  break;
		lba += len;
		blocks -= len;
		rest_blocks -= len;
	  }

	  percent_total = (lba*100/last_addr);
	  if(GetOption()->on_the_fly==FALSE)
		percent_total = percent_total/2 + (REALDRIVE(dst) ? 50 : 0);
	  UIMeter1Update(percent_total);
	  UIMeter2Update((total_blocks-rest_blocks)*100/total_blocks);
	  if(ret==RET_OK){
		if(!sao){
		  for(index=0; index<num_dst; index++){
			ret = SyncCache(&dst[index]);
			if(ret!=RET_OK)
			  break;
		  }
		}
	  }

	  if(vp_track){
		lba += 7;
		if(rest_blocks>7)
		  rest_blocks -= 7;
		if(rest_blocks<7)
		  rest_blocks=0;
	  }
	}

	UIDispInfo("");
	return ret;
}

static int CopyTrack(COPYDRIVE *src, COPYDRIVE *dst, int num_dst,
					 CPDISCINFO *discinfo, WORD track_num)
{
	int ret;
	BOOL vp_track=FALSE;
	CPTRACKINFO *cpti = &discinfo->trackinfo[track_num-1];
	DWORD len;
	DWORD blocksize;
	DWORD blocks;
	DWORD lba;
	char msgbuf[80];
	int index;

	/* VariablePacketǂ */
	if(cpti->trackinfo.packet && Get4bytes(cpti->trackinfo.packet_size)==0)
	  vp_track=TRUE;
	/* L^ubN */
	if(cpti->trackinfo.nwa_valid){
	  blocks = Get4bytes(cpti->trackinfo.next_writable_addr) -
		Get4bytes(cpti->trackinfo.track_start);
	}
	else{
	  blocks = Get4bytes(cpti->trackinfo.track_size) -
		Get4bytes(cpti->trackinfo.free_blocks);
	}
	/* ubNTCY */
	if(DT_DVD_FAMILY(dst->disc_type)){
	  blocksize = 2048;
		  /* 1ɓ]ubN */
	  len = 16;
	}
	else{
	  if(IS_TRACKMODE_DATA(cpti->trackinfo.track_mode)){
		blocksize = cpti->mode2 ? 2332 : 2048;
	  }
	  else{
		blocksize = 2352;
	  }
		  /* 1ɓ]łubN */
	  if(REALDRIVE(src)){
		len = src->drive->bufsize / (blocksize==2048 ? 2048 : 2352);
	  }
	  else if(REALDRIVE(&dst[0])){
		len = dst->drive->bufsize / (blocksize==2048 ? 2048 : 2352);
	  }
	  else{
		len = 16;
	  }
	}
	if(blocksize*len >= 0x10000){
		  /* wnaspi32.dll ł 64KB ]łȂ炵̂ */
	  len = 0xffff/blocksize;
	}

		/* L^AhX */
	lba = Get4bytes(cpti->trackinfo.track_start);

	for(index=0; index<num_dst; index++){
	  ret = OpenTrack(&dst[index], discinfo, track_num);
	  if(ret!=RET_OK)
		return ret;
	}

	/* ʕ\ */
	sprintf(msgbuf, "gbN%d", track_num);
	UIMeter2Initialize(msgbuf);

	if(Get4bytes(cpti->trackinfo.free_blocks) > 0){
	  for(index=0; index<num_dst; index++){
		ret = ReserveTrack(&dst[index],
						   Get4bytes(cpti->trackinfo.track_size));
		if(ret!=RET_OK)
		  return ret;
	  }
	}

	ret = WriteLoop(src, dst, num_dst, lba, blocks, len, blocksize,
					vp_track, discinfo->last_addr, FALSE);
	if(ret!=RET_OK){
		  /* G[̏ꍇ́ASyncCacheďI */
	  for(index=0; index<num_dst; index++){
		SyncCache(&dst[index]);
	  }
	}
	else{
	  ret = CloseTrack(dst, num_dst, discinfo, track_num);
	}

	return ret;
}

static int CreateCueSheet(COPYDRIVE *cpdrv, CPDISCINFO *discinfo, WORD track_num,
						  struct _CUESHEET **cs_ret)
{
	struct _CUESHEET *cs = NULL, *csp;
	int cur_cs = 0;
	int num_cs = 0;
	DWORD gap_len;
	WORD sess_num = 0;
	DWORD nwa;
	CPTRACKINFO *cpti=NULL, *lcpti=NULL;
	struct _TRACKINFO *ti;
	int ret;
	BOOL gap_2part;
	BOOL cdtext=FALSE;
	int retry;	/* CD-TEXTT|[ghCüׂ̃gC */

	if(track_num==1 && discinfo->cdtext_size>0)
		cdtext = TRUE;

	for(retry=0; retry<2; retry++){
		cur_cs = 0;
		num_cs = 0;
		sess_num = 0;
		/* NWA擾 */
		if(virtual_drvDRIVE(cpdrv)){
			nwa = 0;
		}
		else{
			ret = SendReadTrackInfo(cpdrv->drive, track_num);
			if(ret!=RET_OK){
				DispCommandError(cpdrv->drive);
				return ret;
			}
			ti = (struct _TRACKINFO *)cpdrv->drive->data_buf;
			nwa = Get4bytes(ti->next_writable_addr);
		}
		nwa -= 150;

		if(strlen(discinfo->media_catalog_number)!=0){
			/* Media Catalog Number */
			num_cs += 2;
			cs = (struct _CUESHEET *)realloc(cs, num_cs * sizeof(struct _CUESHEET));
			if(cs==NULL)
				return RET_MEMERR;
			csp = &cs[cur_cs++];
			csp->ctladr = CSADR_MCN;
			memcpy(&csp->tno, discinfo->media_catalog_number, 7);
			csp = &cs[cur_cs++];
			csp->ctladr = CSADR_MCN;
			memcpy(&csp->tno, discinfo->media_catalog_number+7, 7);
		}

		cpti = NULL;
		lcpti = NULL;
		ret = RET_OK;
		for( ; track_num <= discinfo->tracks; track_num++){
			lcpti = cpti;
			cpti = &discinfo->trackinfo[track_num-1];
			gap_len = 0;
			if(sess_num==0){
				sess_num = (WORD)cpti->trackinfo.session_number_msb<<8 |
							(WORD)cpti->trackinfo.session_number_lsb;
				/* Lead-in */
				num_cs++;
				cs = (struct _CUESHEET *)realloc(cs, num_cs * sizeof(struct _CUESHEET));
				if(cs==NULL)
					return RET_MEMERR;
				csp = &cs[cur_cs++];
				csp->ctladr = IS_TRACKMODE_DATA(cpti->trackinfo.track_mode) ? CSCTL_DATA : CSCTL_AUDIO;
				csp->ctladr |= CSADR_NORMAL;
				csp->tno = 0;
				csp->index = 0;
				csp->dataform = cdtext ? 0x41 : 0x01;
				csp->scms = 0;
				LBA2MSF(nwa, &csp->min, &csp->sec, &csp->frame);
				gap_len = 150;
			}
			else if(sess_num != ((WORD)cpti->trackinfo.session_number_msb<<8 |
								(WORD)cpti->trackinfo.session_number_lsb)){
				cpti = lcpti;
				break;
			}

			if(strlen(cpti->isrc)!=0){
				/* ISRC */
				num_cs += 2;
				cs = (struct _CUESHEET *)realloc(cs, num_cs * sizeof(struct _CUESHEET));
				if(cs==NULL)
					return RET_MEMERR;
				csp = &cs[cur_cs++];
				csp->ctladr = CSADR_ISRC;
				csp->tno = (BYTE)track_num;
				memcpy(&csp->index, cpti->isrc, 6);
				csp = &cs[cur_cs++];
				csp->ctladr = CSADR_ISRC;
				csp->tno = (BYTE)track_num;
				memcpy(&csp->index, cpti->isrc+6, 6);
			}
			gap_2part = FALSE;
			if(gap_len==0){
#if 1	/* ̕ǂ? */
				if(lcpti!=NULL){
					gap_len = Get4bytes(cpti->trackinfo.track_start) -
								(Get4bytes(lcpti->trackinfo.track_start) +
								 Get4bytes(lcpti->trackinfo.track_size));
					if(IS_TRACKMODE_DATA(cpti->trackinfo.track_mode)){
						/* DATA */
						if(!IS_TRACKMODE_DATA(lcpti->trackinfo.track_mode) ||
							lcpti->mode2 != cpti->mode2){
							/* 2part */
							gap_2part = TRUE;
						}
					}
					else{
						/* AUDIO */
						if(IS_TRACKMODE_DATA(lcpti->trackinfo.track_mode)){
							/* ODATȀꍇ? */
							gap_2part = TRUE;
						}
					}
				}
#else
				if(!IS_TRACKMODE_DATA(cpti->trackinfo.track_mode)){
					/* AUDIO */
					gap_len = cpti->pause_len;
				}
				else if(lcpti!=NULL){
					/* DATA  2nd ȍ~ */
					gap_len = 150;
					if(!IS_TRACKMODE_DATA(lcpti->trackinfo.track_mode) ||
						lcpti->mode2 != cpti->mode2){
						/* 2part */
						gap_len = 75+150;
						gap_2part = TRUE;
					}
				}
#endif
			}
			nwa = Get4bytes(cpti->trackinfo.track_start) - gap_len;
			if(gap_len>0){
				/* pre-gap */
				if(gap_2part && gap_len>150){
					num_cs++;
					cs = (struct _CUESHEET *)realloc(cs, num_cs * sizeof(struct _CUESHEET));
					if(cs==NULL)
						return RET_MEMERR;
					csp = &cs[cur_cs++];
					csp->ctladr = IS_TRACKMODE_DATA(lcpti->trackinfo.track_mode) ? CSCTL_DATA : CSCTL_AUDIO;
					csp->ctladr |= CSADR_NORMAL;
					csp->tno = (BYTE)track_num;
					csp->index = 0;
					if(!IS_TRACKMODE_DATA(lcpti->trackinfo.track_mode))
						csp->dataform = 0x01;
					else
						csp->dataform = lcpti->mode2 ? 0x24 : 0x14;
					csp->scms = lcpti->trackinfo.copy ? 0x80 : 0;
					LBA2MSF(nwa, &csp->min, &csp->sec, &csp->frame);
					nwa += (gap_len-150);
					gap_len = 150;
				}
				num_cs++;
				cs = (struct _CUESHEET *)realloc(cs, num_cs * sizeof(struct _CUESHEET));
				if(cs==NULL)
					return RET_MEMERR;
				csp = &cs[cur_cs++];
				csp->ctladr = IS_TRACKMODE_DATA(cpti->trackinfo.track_mode) ? CSCTL_DATA : CSCTL_AUDIO;
				csp->ctladr |= CSADR_NORMAL;
				csp->tno = (BYTE)track_num;
				csp->index = 0;
				if(!IS_TRACKMODE_DATA(cpti->trackinfo.track_mode))
					csp->dataform = 0x01;
				else
					csp->dataform = cpti->mode2 ? 0x24 : 0x14;
				csp->scms = cpti->trackinfo.copy ? 0x80 : 0;
				LBA2MSF(nwa, &csp->min, &csp->sec, &csp->frame);
				nwa += gap_len;
			}
			/* Audio/Data */
			num_cs++;
			cs = (struct _CUESHEET *)realloc(cs, num_cs * sizeof(struct _CUESHEET));
			if(cs==NULL)
				return RET_MEMERR;
			csp = &cs[cur_cs++];
			csp->ctladr = IS_TRACKMODE_DATA(cpti->trackinfo.track_mode) ? CSCTL_DATA : CSCTL_AUDIO;
			csp->ctladr |= CSADR_NORMAL;
			csp->tno = (BYTE)track_num;
			csp->index = 1;
			if(!IS_TRACKMODE_DATA(cpti->trackinfo.track_mode))
				csp->dataform = 0x00;
			else
				csp->dataform = cpti->mode2 ? 0x20 : 0x10;
			csp->scms = cpti->trackinfo.copy ? 0x80 : 0;
			LBA2MSF(nwa, &csp->min, &csp->sec, &csp->frame);
			nwa += Get4bytes(cpti->trackinfo.track_size);
		}
		/* Lead-out */
		num_cs++;
		cs = (struct _CUESHEET *)realloc(cs, num_cs * sizeof(struct _CUESHEET));
		if(cs==NULL)
			return RET_MEMERR;
		csp = &cs[cur_cs++];
		csp->ctladr = IS_TRACKMODE_DATA(cpti->trackinfo.track_mode) ? CSCTL_DATA : CSCTL_AUDIO;
		csp->ctladr |= CSADR_NORMAL;
		csp->tno = 0xAA;
		csp->index = 1;
		if(!IS_TRACKMODE_DATA(cpti->trackinfo.track_mode))
			csp->dataform = 0x01;
		else
			csp->dataform = cpti->mode2 ? 0x24 : 0x14;
		csp->scms = cpti->trackinfo.copy ? 0x80 : 0;
		LBA2MSF(nwa, &csp->min, &csp->sec, &csp->frame);

		*cs_ret = cs;

		if(REALDRIVE(cpdrv)){
			ret = SendSendCueSheet(cpdrv->drive, cs, num_cs*sizeof(struct _CUESHEET));
			if(ret!=RET_OK){
				if(!retry && cdtext){
					cdtext = FALSE;	/* CD-TEXT 𖳌ɂăgC */
				}
				else{
					DispCommandError(cpdrv->drive);
					*cs_ret = NULL;
					free(cs);
					return ret;
				}
			}
		}
		if(ret==RET_OK)
			break;
	}

	return RET_OK;
}

static int CopySession(COPYDRIVE *src, COPYDRIVE *dst, int num_dst,
					   CPDISCINFO *discinfo,
					   WORD *track_num_ret)
{
	int ret=RET_OK;
	WORD track_num = *track_num_ret;
	struct _CUESHEET *cs=NULL, *csp;
	BOOL done=FALSE;
	DWORD lba, blocks;
	DWORD translen, blocksize;
	char msgbuf[80];
	int index;

	for(index=0; index<num_dst; index++){
	  if(cs!=NULL){
		free(cs);
		cs=NULL;
	  }
	  ret = SetWriteParametersPage(&dst[index], discinfo, track_num, TRUE);
	  if(ret!=RET_OK)
		return ret;

	  ret = CreateCueSheet(&dst[index], discinfo, track_num, &cs);
	  if(ret!=RET_OK)
		return ret;
	}

	for(csp=cs; !done; csp++){
	  if((csp->ctladr & 0x0f)!=CSADR_NORMAL)
		continue;
	  if(csp->tno==0xaa){
		done=TRUE;
		continue;
	  }
	  if(csp->dataform==0x24 || csp->dataform==0x14 || csp->dataform==0x01){
			/* f[^]iV */
		continue;
	  }
	  if(csp->dataform==0x41){
			/* CD-TEXT */
		ret = WriteCDText(dst, num_dst, discinfo);
		if(ret!=RET_OK)
		  break;
		continue;
	  }
	  lba = MSF2LBA(csp->min, csp->sec, csp->frame, FALSE);
#if 1
	  blocks = Get4bytes(discinfo->trackinfo[csp->tno-1].trackinfo.track_size);
#else	/* CueSheet狁߂ꍇ́AISRC𖳎ėLMSFKv */
	  blocks = MSF2LBA((csp+1)->min, (csp+1)->sec, (csp+1)->frame, FALSE) - lba;
#endif
	  switch(csp->dataform){
	  case 0x20:
		blocksize = 2336;
		break;
	  case 0x10:
		blocksize = 2048;
		break;
	  default:
		blocksize = 2352;
	  }
	  if(REALDRIVE(src))
		translen = src->drive->bufsize / (blocksize==2048 ? 2048 : 2352);
	  else
		translen = dst[0].drive->bufsize / (blocksize==2048 ? 2048 : 2352);
	  if(blocksize*translen >= 0x10000){
			/* wnaspi32.dll ł 64KB ]łȂ炵̂ */
		translen = 0xffff / (blocksize==2048 ? 2048 : 2352);
	  }

		  /* ʕ\ */
	  sprintf(msgbuf, "gbN%d", csp->tno);
	  UIMeter2Initialize(msgbuf);

	  ret = WriteLoop(src, dst, num_dst,
					  lba, blocks, translen, blocksize,
					  FALSE, discinfo->last_addr, TRUE);
	  if(ret!=RET_OK){
		break;
	  }
	  *track_num_ret = csp->tno;
	}

	for(index=0; index<num_dst; index++){
	  SyncCache(&dst[index]);
	}

	(*track_num_ret)++;

	free(cs);
	return ret;
}


static int CopyDAO(COPYDRIVE *src, COPYDRIVE *dst, int num_dst,
				   CPDISCINFO *discinfo)
{
	int disc_type;
	int ret;
	int index;

	if(virtual_drvDRIVE(src) && virtual_drvDRIVE(&dst[0]))
		return RET_NG;

	if(REALDRIVE(src))
		disc_type = src->disc_type;
	else
		disc_type = dst[0].disc_type;

	if(DT_CD_FAMILY(disc_type)){
		  /* ͂₱ɂ͗Ȃ */
	  UIDispMessage("cOȂACD  DAO ͂ł܂B",
					UIDMT_ERROR);
	  return RET_ABORT;
	}
	else{
		  /* DVD-R/-RW */
	  for(index=0; index<num_dst; index++){
		ret = SetWriteParametersPage(&dst[index], discinfo, 1,
									 GetOption()->dao);
		if(ret!=RET_OK)
		  return ret;
		ret = ReserveTrack(&dst[index],
						   Get4bytes(discinfo->trackinfo[0].trackinfo.track_size));
		if(ret!=RET_OK)
		  return ret;
	  }

	  ret = CopyTrack(src, dst, num_dst, discinfo, 1);
	  if(ret!=RET_OK)
		return ret;
	}

	return RET_OK;
}



static int ExecCopy(COPYDRIVE *src, COPYDRIVE *dst, int num_dst)
{
	int ret;
	CPDISCINFO discinfo;
	DWORD free_size;
	WORD track_num;
	WORD sess_num;
	CPTRACKINFO *cpti;
	BOOL sao=FALSE;
	int index;

	for(index=0; index<num_dst; index++){
		  /* L^悤ƂfBXNBLANKłȂBLANKs */
	  ret = Blanking(&dst[index]);
	  if(ret!=RET_OK)
		return ret;
		  /* L^fBA DVD+RW ŁAtH[}bgȂtH[}bgJn */
	  ret = Formatting(&dst[index]);
	  if(ret!=RET_OK)
		return ret;
	}
	
		/* \[XfBXN̏𓾂(ReadDiscInfo. & ReadTrackInfo.) */
	ret = GetDiscInformation(src, &discinfo);
	if(ret!=RET_OK)
	  return ret;

	if(discinfo.last_addr==0){
	  UIDispMessage("ʌfBXN̓uNłBʂł܂B",
					UIDMT_INFORMATION);
	  free(discinfo.trackinfo);
	  free(discinfo.cdtext);
	  return RET_ABORT;
	}

		/* L^zhCuȂAC[Wt@CɃfBXNo */
	if(num_dst==1){
	  ret = SetDiscInformation(&dst[0], &discinfo);
	  if(ret!=RET_OK){
		free(discinfo.trackinfo);
		free(discinfo.cdtext);
		return ret;
	  }
	}

	for(index=0; index<num_dst; index++){
	  if(REALDRIVE(&dst[index])){
		if(dst[index].disc_type!=DT_DVDRWO &&
		   dst[index].disc_type!=DT_DVDRWS &&
		   dst[index].disc_type!=DT_DVDPRW){
			  /* DVD-RW/+RW łȂꍇAeʃ`FbN */
			  /* WriteParametersPageݒɂăt[ubN
				 eĂ܂ */
		  ret = SetWriteParametersPage(&dst[index], &discinfo, 1,
									   !discinfo.trackinfo[0].tao );
		  if(ret!=RET_OK){
			free(discinfo.trackinfo);
			free(discinfo.cdtext);
			return ret;
		  }

			  /* L^fBXN̋󂫗eʂ𓾂 */
		  ret = GetWritableSize(&dst[index], &free_size);
		  if(ret!=RET_OK){
			free(discinfo.trackinfo);
			free(discinfo.cdtext);
			return ret;
		  }
		  if(free_size < discinfo.last_addr){
			ret = UIDispMessage("L^fBXNeʂsĂ܂B\nđs܂H",
								UIDMT_QUESTION);
			if(ret==UIDMRET_CANCEL){
			  free(discinfo.trackinfo);
			  free(discinfo.cdtext);
			  return RET_ABORT;
			}
		  }
		}

		if(dst[0].disc_type!=DT_DVDR &&
		   dst[0].disc_type!=DT_DVDRWO &&
		   dst[0].disc_type!=DT_DVDRWS){
			  /* DVD-R/-RW ȊO DAO  */
		  GetOption()->dao = FALSE;
		}
	  }
	}

		/* Ǎxݒ */
	ret = SetSpeed(src, GetOption()->read_speed, 0);
	if(ret!=RET_OK){
	  free(discinfo.trackinfo);
	  free(discinfo.cdtext);
	  return ret;
	}

	for(index=0; index<num_dst; index++){
		  /* L^xݒ */
	  ret = SetSpeed(&dst[index],
					 GetOption()->write_speed,
					 GetOption()->write_speed);
	  if(ret!=RET_OK){
		free(discinfo.trackinfo);
		free(discinfo.cdtext);
		return ret;
	  }
	}

	if(REALDRIVE(src)){
	  UIMeter1Initialize("S");
	}

	if(GetOption()->dao){
	  ret = CopyDAO(src, dst, num_dst, &discinfo);
	  if(ret!=RET_OK){
		free(discinfo.trackinfo);
		free(discinfo.cdtext);
		return ret;
	  }
	}
	else{
	  track_num=1;
	  for(sess_num=1; sess_num<=discinfo.sessions; sess_num++){
		if(track_num > discinfo.tracks)
		  break;
		if(track_num==discinfo.tracks &&
		   discinfo.trackinfo[track_num-1].trackinfo.blank){
			  /* ŏIgbNBLANKȂ牽I */
		  break;
		}
		if(discinfo.trackinfo[track_num-1].tao==FALSE){
			  /* SAOL^ */
		  sao = TRUE;
		  ret = CopySession(src, dst, num_dst, &discinfo, &track_num);
		  if(ret!=RET_OK){
			free(discinfo.trackinfo);
			free(discinfo.cdtext);
			return ret;
		  }
		  continue;
		}

			/* TAOL^ */
		sao = FALSE;
		for(; track_num <= discinfo.tracks; track_num++){
		  cpti = &discinfo.trackinfo[track_num-1];
		  if(sess_num !=
			 ((WORD)cpti->trackinfo.session_number_msb<<8 |
			  (WORD)cpti->trackinfo.session_number_lsb)){
				/* ̃ZbV͏I */
			ret = CloseSession(dst, num_dst);
			if(ret!=RET_OK){
			  free(discinfo.trackinfo);
			  free(discinfo.cdtext);
			  return ret;
			}
			break;
		  }
		  if(track_num==discinfo.tracks &&
			 discinfo.trackinfo[track_num-1].trackinfo.blank){
				/* ŏIgbNBLANKȂ牽I */
			break;;
		  }

		  ret = CopyTrack(src, dst, num_dst, &discinfo, track_num);
		  if(ret!=RET_OK){
			free(discinfo.trackinfo);
			free(discinfo.cdtext);
			return ret;
		  }
		}
	  }

	  if(discinfo.last_sess_stat==SESSSTAT_COMPLETE && sao==FALSE){
		ret = CloseSession(dst, num_dst);
		if(ret!=RET_OK){
		  free(discinfo.trackinfo);
		  free(discinfo.cdtext);
		  return ret;
		}
	  }
	}

	free(discinfo.trackinfo);
	free(discinfo.cdtext);

	return RET_OK;
}


int CopyDisc(DRIVE *reader, DRIVE *writer, int num_writer)
{
	BOOL bSameDrive=FALSE;
	BOOL bDVD=FALSE;
	COPYDRIVE src, dst, virtual_drv, *dstp=NULL;
	int ret;
	char tmpfile[_MAX_PATH];
	OPTIONS *option;
	int index;
	int num_writable_drive=0;
	int disc_type;

	dstp = (COPYDRIVE *)malloc(num_writer*sizeof(COPYDRIVE));
	if(dstp==NULL){
	  UIDispMessage("mۂɎs܂B", UIDMT_ERROR);
	  return RET_NG;
	}
	
	if(reader!=NULL && writer!=NULL){
		if(reader->hid == writer->hid &&
		   reader->tid == writer->tid){
		  bSameDrive = TRUE;
		}
	}

		/* ǎ摕ũI[v */
	if(reader==NULL){
		  /* ISOC[W */
	  tmpfile[0] = '\0';
	  ret = UIFileDialog(TRUE, tmpfile, sizeof(tmpfile), "iso");
	  if(ret!=UIDMRET_OK){
		free(dstp);
		return RET_ABORT;
	  }
	  ret = OpenDevice(&src, NULL, tmpfile, TRUE, FALSE);
	  if(ret!=RET_OK){
		free(dstp);
		return ret;
	  }
	  src.image_type = IMAGETYPE_ISO;
	}
	else{
	  ret = OpenDevice(&src, reader, NULL, TRUE, TRUE);
	  if(ret!=RET_OK){
		free(dstp);
		return ret;
	  }
	}
	disc_type = src.disc_type;
	
	if(bSameDrive){
	  ret = SetOption(src.drive, src.drive, src.disc_type);
	  if(ret!=RET_OK){
		CloseDevice(&src);
		free(dstp);
		return ret;
	  }
	  num_writable_drive = 1;
	}
	else{
	  if(writer==NULL){
			/* ISOC[W */
		strcpy(tmpfile, "image.iso");
		ret = UIFileDialog(FALSE, tmpfile, sizeof(tmpfile), "iso");
		if(ret!=RET_OK){
		  CloseDevice(&src);
		  free(dstp);
		  return RET_ABORT;
		}
		ret = OpenDevice(&dst, NULL, tmpfile, FALSE, FALSE);
		if(ret!=UIDMRET_OK){
		  CloseDevice(&src);
		  free(dstp);
		  return RET_ABORT;
		}
		dst.image_type = IMAGETYPE_ISO;
		memcpy(&dstp[0], &dst, sizeof(COPYDRIVE));
		num_writable_drive = 1;
	  }
	  else{
		for(index=0; index<num_writer; index++){
		  ret = OpenDevice(&dst, &writer[index], NULL, FALSE,
						   (num_writer==1));
		  if(ret!=RET_OK){
			continue;
		  }
		  memcpy(&dstp[num_writable_drive], &dst, sizeof(COPYDRIVE));
		  num_writable_drive++;
		}
		if(num_writable_drive==0){
		  CloseDevice(&src);
		  free(dstp);
		  return RET_NG;
		}
	  }

	  if(disc_type==DT_UNKNOWN){
		disc_type = dstp[0].disc_type;
	  }
	  
	  ret = SetOption(src.drive, dstp[0].drive, disc_type);
	  if(ret!=RET_OK){
		CloseDevice(&src);
		for(index=0; index<num_writable_drive; index++){
		  CloseDevice(&dstp[index]);
		}
		free(dstp);
		return ret;
	  }
	}

	option = GetOption();
	if(option->on_the_fly){
	  bDVD = DT_DVD_FAMILY(disc_type);
	  for(index=0; index<num_writable_drive; index++){
		if(bDVD != DT_DVD_FAMILY(dstp[index].disc_type)){
		  UIDispMessage("CD  DVD ADVD  CD ɂ̓Rs[ł܂B",
						UIDMT_ERROR);
		  CloseDevice(&src);
		  for(index=0; index<num_writer; index++){
			CloseDevice(&dstp[index]);
		  }
		  free(dstp);
		  return RET_NG;
		}
	  }
	  ret = ExecCopy(&src, dstp, num_writable_drive);
	  CloseDevice(&src);
	  for(index=0; index<num_writable_drive; index++){
		CloseDevice(&dstp[index]);
	  }
	  free(dstp);
	}
	else{
	  strcpy(tmpfile, GetOption()->temppath);
	  if(strlen(tmpfile)+1+7+1>=sizeof(tmpfile)){
		CloseDevice(&src);
		for(index=0; index<num_writable_drive; index++){
		  CloseDevice(&dstp[index]);
		}
		free(dstp);
		return RET_NG;
	  }
#ifdef WIN32
	  if(strlen(tmpfile)>0){
		if(tmpfile[strlen(tmpfile)-1]=='\\')
		  strcat(tmpfile, "tmp.img");
		else
		  strcat(tmpfile, "\\tmp.img");
	  }
	  else
		strcat(tmpfile, "\\tmp.img");
#else
	  strcat(tmpfile, "/tmp.img");
#endif
	  ret = OpenDevice(&virtual_drv, NULL, tmpfile, FALSE, FALSE);
	  if(ret!=RET_OK){
		CloseDevice(&src);
		if(!bSameDrive){
		  for(index=0; index<num_writable_drive; index++){
			CloseDevice(&dstp[index]);
		  }
		}
		free(dstp);
		return ret;
	  }

	  virtual_drv.disc_type = src.disc_type;

	  ret = ExecCopy(&src, &virtual_drv, 1);	/* DISC => Image file */
	  if(ret==RET_OK){
		OpenTray(src.drive);
	  }
	  CloseDevice(&src);
	  CloseDevice(&virtual_drv);
	  if(ret!=RET_OK){
		RemoveImageFile(tmpfile);
		if(!bSameDrive){
		  for(index=0; index<num_writable_drive; index++){
			CloseDevice(&dstp[index]);
		  }
		}
		free(dstp);
		return ret;
	  }

	  ret = OpenDevice(&virtual_drv, NULL, tmpfile, TRUE, FALSE);
	  if(ret!=RET_OK){
		RemoveImageFile(tmpfile);
		if(!bSameDrive){
		  for(index=0; index<num_writable_drive; index++){
		    CloseDevice(&dstp[index]);
		  }
		}
		free(dstp);
		return ret;
	  }
	  if(bSameDrive){
	    num_writable_drive=1;
	    ret = OpenDevice(&dstp[0], writer, NULL, FALSE, TRUE);
	    if(ret!=RET_OK){
	      CloseDevice(&virtual_drv);
	      RemoveImageFile(tmpfile);
		  if(!bSameDrive){
			for(index=0; index<num_writable_drive; index++){
			  CloseDevice(&dstp[index]);
			}
		  }
	      free(dstp);
	      return ret;
	    }
	  }

	  ret = ExecCopy(&virtual_drv, dstp, num_writable_drive);	/* Image file => DISC */
	  CloseDevice(&virtual_drv);
	  if(!bSameDrive){
		for(index=0; index<num_writable_drive; index++){
		  CloseDevice(&dstp[index]);
		}
	  }
	  free(dstp);
	  RemoveImageFile(tmpfile);
	}

	return ret;
}

