/* ~Օʉ
 * Copyright (C) 2004 Kagetani Hideto
 */
#include <stdio.h>
#include <string.h>
#if !defined(WIN32)
# include <pwd.h>
# include <unistd.h>
# include <sys/types.h>
# if !defined(MACOSX)
#  include <malloc.h>
# endif	/* !MACOSX */
#endif	/* !WIN32 */
#include "option.h"
#include "cmd.h"
#include "ui.h"

static OPTIONS g_Option;

#if defined(WIN32)

void GetRegString(const char *key, char *string_ret, DWORD size)
{
	LONG lRet;
	HKEY hKey;
	DWORD dwCount;
	DWORD dwType;

	if(size==0)
		return;
	if(string_ret==NULL)
		return;
	if(key==NULL)
		return;

	lRet = RegCreateKeyEx(HKEY_CURRENT_USER, "SOFTWARE\\EnbanFukusyaYa", 0, NULL,
						REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, NULL);
	if(lRet!=ERROR_SUCCESS)
		return;
	dwCount = size;
	dwType = REG_SZ;
	lRet = RegQueryValueEx(hKey, key, NULL, &dwType, string_ret, &dwCount);
	if(lRet!=ERROR_SUCCESS){
		RegCloseKey(hKey);
		return;
	}
	RegCloseKey(hKey);
	string_ret[size-1]='\0';
}

void WriteRegString(const char *key, const char *string)
{
	LONG lRet;
	HKEY hKey;

	if(key==NULL)
		return;
	if(string==NULL)
		string="";
	lRet = RegCreateKeyEx(HKEY_CURRENT_USER, "SOFTWARE\\EnbanFukusyaYa", 0, NULL,
						REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, NULL);
	if(lRet!=ERROR_SUCCESS)
		return;
	lRet = RegSetValueEx(hKey, key, 0, REG_SZ, string, strlen(string));
	if(lRet!=ERROR_SUCCESS){
		RegCloseKey(hKey);
		return;
	}
	RegCloseKey(hKey);
}

static void LoadOption()
{
	char buf[32];
	GetRegString("imagedir", g_Option.temppath, _MAX_PATH);
	GetRegString("readspeed", buf, sizeof(buf));
	g_Option.read_speed = atoi(buf);
	GetRegString("writespeed", buf, sizeof(buf));
	g_Option.write_speed = atoi(buf);
}

static void SaveOption()
{
	char buf[32];
	WriteRegString("imagedir", g_Option.temppath);
	sprintf(buf, "%d", g_Option.read_speed);
	WriteRegString("readspeed", buf);
	sprintf(buf, "%d", g_Option.write_speed);
	WriteRegString("writespeed", buf);
}
#else	/* WIN32 */

#define OPTFNAME ".enbanrc"
static char *GetOptionFilename()
{
	char *fname;
	struct passwd *pwent;

	pwent = getpwuid(getuid());
	fname = (char *)malloc(strlen(pwent->pw_dir)+1+strlen(OPTFNAME)+1);
	if(fname==NULL)
		return NULL;
	sprintf(fname, "%s/%s", pwent->pw_dir, OPTFNAME);
	return fname;
}

static void DeleteSpaces(char *buf)
{
	int qflag=0;
	
	while(*buf){
		if(*buf>0 && *buf<=0x20 && !qflag){
			memmove(buf, buf+1, strlen(buf));
		}
		else if(*buf==0x22){	/* " */
			qflag ^= 1;
			buf++;
		}
		else{
			buf++;
		}
	}
}

static void DeleteQuotation(char *buf)
{
	if(*buf=='\"'){
		if(buf[strlen(buf)-1]=='\"'){
			memmove(buf, buf+1, strlen(buf));
			buf[strlen(buf)-1]='\0';
		}
	}	
}


static void LoadOption()
{
	char *fname;
	char buf[80];
	FILE *fp;

	fname = GetOptionFilename();
	if(fname==NULL)
		return;
	fp = fopen(fname, "r");
	if(fp==NULL){
		free(fname);
		return;
	}

	while(fgets(buf, sizeof(buf), fp)){
		if(buf[0]=='\0')
			continue;
		if(buf[0]=='#')
			continue;
		DeleteSpaces(buf);
		if(!strncmp(buf, "imagedir=", 9)){
			DeleteQuotation(buf+9);
			strncpy(g_Option.temppath, buf+9, _MAX_PATH);
			g_Option.temppath[_MAX_PATH] = '\0';
		}
		else if(!strncmp(buf, "readspeed=", 10)){
			DeleteQuotation(buf+10);
			g_Option.read_speed = atoi(buf+10);
		}
		else if(!strncmp(buf, "writespeed=", 11)){
			DeleteQuotation(buf+11);
			g_Option.write_speed = atoi(buf+11);
		}
	}
	fclose(fp);

	free(fname);
}

static void SaveOption()
{
	char *fname;
	FILE *fp;

	fname = GetOptionFilename();
	if(fname==NULL)
		return;
	fp = fopen(fname, "w");
	if(fp==NULL){
		free(fname);
		return;
	}

	fprintf(fp, "imagedir=\"%s\"\n", g_Option.temppath);
	fprintf(fp, "readspeed=%d\n", g_Option.read_speed);
	fprintf(fp, "writespeed=%d\n", g_Option.write_speed);
	fclose(fp);
	
	free(fname);
}
#endif /* WIN32 */


int SetOption(DRIVE *reader, DRIVE *writer, int disc_type)
{
	int ret;
	struct _MODEPAGE05 *mp05;

	memset(&g_Option, 0, sizeof(OPTIONS));

	/* ꎞt@CfBNg߂ */
#ifdef WIN32
	if(GetTempPath(sizeof(g_Option.temppath), g_Option.temppath)==0){
		g_Option.temppath[0] = '\0';
	}
#else
	strcpy(g_Option.temppath, "/tmp");
#endif
	g_Option.flags |= OPFLG_TEMPPATH;

	if(disc_type==DT_DVDPR || disc_type==DT_DVDPRW){
		/* WriteParametersPage ݒ肪̂ */
		g_Option.bufe = TRUE;
		g_Option.test_write = FALSE;
	}
	else{
		if(writer==NULL){
			g_Option.bufe = FALSE;
			g_Option.test_write = FALSE;
		}
		else{
			ret = SendModeSense(writer, MSPC_CHANGEABLE, 5);
			if(ret!=RET_OK){
				DispCommandError(writer);
				return ret;
			}
			mp05 = (struct _MODEPAGE05 *)(writer->data_buf + (writer->atapi ? 8:16));
			if(mp05->BUFE){
				g_Option.bufe = TRUE;
				g_Option.flags |= OPFLG_BUFE;
			}
			if(mp05->test_write){
				g_Option.test_write = FALSE;
				g_Option.flags |= OPFLG_TESTWRITE;
			}
		}
	}

	if(reader!=NULL && writer!=NULL){
		if(reader->hid != writer->hid || reader->tid != writer->tid){
			g_Option.on_the_fly = TRUE;
			g_Option.flags |= OPFLG_ONTHEFLY;
		}
	}
	else{
		g_Option.on_the_fly = TRUE;
	}

	if(DT_DVD_FAMILY(disc_type)){
		g_Option.flags |= OPFLG_DVD;
		g_Option.dao = TRUE;
		g_Option.flags |= OPFLG_DAO;
	}

	LoadOption();
	ret = UISetting(&g_Option);
	SaveOption();
	return ret;
}

OPTIONS *GetOption()
{
	return &g_Option;
}


