/* ʣ̲
 * Copyright (c) 2004 Kagetani Hideto
 */
#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "filedlg.h"

static int g_RetCode;

static void on_file_selected(GtkWidget *widget, gpointer user_data)
{
  g_RetCode = FDR_OK;
}

static void on_file_canceled(GtkWidget *widget, gpointer user_data)
{
  g_RetCode = FDR_CANCEL;
}


int FileDialog(int bOpen, char *filename, int size, const char *suffix)
{
  GtkWidget *file_selector;
  const char *title = bOpen ? "ե򳫤" : "ե¸";
  char *mask=NULL;

  g_RetCode = FDR_PENDING;

  if(bOpen && suffix!=NULL){
    mask=(char *)malloc(strlen(suffix)+1+2);
  }
  if(mask!=NULL){
    strcpy(mask, "*.");
    strcat(mask, suffix);
  }

  file_selector = gtk_file_selection_new(title);
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(file_selector)->ok_button),
		     "clicked", GTK_SIGNAL_FUNC(on_file_selected),
		     (gpointer)file_selector);
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(file_selector)->cancel_button),
		     "clicked", GTK_SIGNAL_FUNC(on_file_canceled),
		     (gpointer)file_selector);
  if(mask!=NULL){
    gtk_file_selection_complete(GTK_FILE_SELECTION(file_selector), mask);
  }
  gtk_window_set_modal(GTK_WINDOW(file_selector), TRUE);
  gtk_widget_show(file_selector);

  while(g_RetCode==FDR_PENDING){
    gtk_main_iteration();
  }

  if(g_RetCode==FDR_OK){
    strncpy(filename, gtk_file_selection_get_filename(GTK_FILE_SELECTION(file_selector)), size);
    filename[size-1]='\0';
  }

  gtk_widget_destroy(file_selector);

  if(mask!=NULL){
    free(mask);
  }

  return g_RetCode;
}
