#import "SettingDlgControl.h"

@implementation SettingDlgControl

- (IBAction)buttonCancel:(id)sender
{
	[NSApp stopModalWithCode: RET_ABORT];
}

- (IBAction)buttonStart:(id)sender
{
	[NSApp stopModalWithCode: RET_OK];
}

- (int)openSettingDialog:(OPTIONS *)option
{
	int ret;
	
	[checkTestWrite setState : (option->test_write ? NSOnState:NSOffState)];
	[checkBUFE setState : (option->bufe ? NSOnState:NSOffState)];
	[checkOnTheFly setState : (option->on_the_fly ? NSOnState:NSOffState)];
	[checkDiscAtOnce setState : (option->dao ? NSOnState:NSOffState)];
	
	[checkTestWrite setEnabled : ((option->flags & OPFLG_TESTWRITE) ? YES:NO)];
	[checkBUFE setEnabled : ((option->flags & OPFLG_BUFE) ? YES:NO)];
	[checkOnTheFly setEnabled : ((option->flags & OPFLG_ONTHEFLY) ? YES:NO)];
	[checkDiscAtOnce setEnabled : ((option->flags & OPFLG_DAO) ? YES:NO)];
	
	[textTempDirectory setStringValue :
		[NSString stringWithCString : option->temppath]];
	[textTempDirectory setEnabled : ((option->flags & OPFLG_TEMPPATH) ? YES:NO)];
	
	[self setSpeedItems: readSpeedSel
				  defValue: option->read_speed
							  isdvd: (option->flags & OPFLG_DVD)];
	[self setSpeedItems: writeSpeedSel
						defValue: option->write_speed
									isdvd: (option->flags & OPFLG_DVD)];
	/* _CAO\ */
	ret = [NSApp runModalForWindow: settingPanel];
	[settingPanel orderOut: self];
	if(ret!=RET_OK)
		return ret;
	
	option->test_write = [checkTestWrite state]==NSOnState;
	option->bufe = [checkBUFE state]==NSOnState;
	option->on_the_fly = [checkOnTheFly state]==NSOnState;
	option->dao = [checkDiscAtOnce state]==NSOnState;
	
	option->read_speed = atoi([[readSpeedSel titleOfSelectedItem] cString]);
	option->write_speed = atoi([[writeSpeedSel titleOfSelectedItem] cString]);
	
	const char *tempPath = [[textTempDirectory stringValue] cString];
	strncpy(option->temppath, tempPath, _MAX_PATH-1);
	option->temppath[_MAX_PATH-1] = '\0';
	return RET_OK;
}

- (void)setSpeedItems:(id)target
			 defValue:(int)defaultSpeed
				isdvd:(BOOL)dvd
{
	int i, speed;
	const char *speedsCD[] = {
		"1{",
		"2{",
		"4{",
		"6{",
		"8{",
		"10{",
		"12{",
		"16{",
		"20{",
		"24{",
		"32{",
		"48{",
		"52{",
		"ő呬",
		NULL
	};
	const char *speedsDVD[] = {
		"1{",
		"2{",
		"4{",
		"6{",
		"8{",
		"10{",
		"12{",
		"16{",
		"20{",
		"24{",
		"W",
		NULL
	};
	const char **items;
	
	items = dvd ? speedsDVD : speedsCD;
	[target removeAllItems];
	for(i=0; items[i]!=NULL; i++){
		[target addItemWithTitle:
			[NSString stringWithCString: items[i]]];
		speed = atoi(items[i]);
		if(speed==defaultSpeed){
			[target selectItemAtIndex: i];
		}
	}
}


@end
