/* ~Օʉ
 * Copyright (C) 2004 Kagetani Hideto
 */
#ifndef __WINASPI_H__
#define __WINASPI_H__

#include <windows.h>

#include <scsidefs.h>
#include <srbcmn.h>
#include <srb32.h>

#define SENSEDATA_SIZE		0x20
#define USE_SCSIPT	1

typedef struct {
	BYTE cdb[12];
	BYTE snskey;
	BYTE asc;
	BYTE ascq;
	BYTE reqflag;
	DWORD datalen;
	BYTE *data;
	WORD repeat;
} CMDLOG;

typedef struct {
	int hid;
	int tid;
	DWORD timeout;
	SRB32_ExecSCSICmd *srb;
#if USE_SCSIPT
	HANDLE hDrive;
#endif
	BYTE *data_buf;
	int bufsize;
	BYTE sense_data[SENSEDATA_SIZE];
	BOOL atapi;
	BYTE cmdcode;
	CMDLOG *cmdlog;
	int cmdlog_size;
	int cmdlog_start;
	int cmdlog_end;
	DWORD cmdlog_maxdatalen;
} DRIVE;

#define SD_SENSEKEY(d)	(d->sense_data[2] & 0x0f)
#define SD_ASC(d)		(d->sense_data[12])
#define SD_ASCQ(d)		(d->sense_data[13])

/* return value */
#define RET_OK		0
#define RET_ABORT	1
#define RET_NG		-1
#define RET_TIMEOUT -2
#define RET_CMDERR	-3
#define RET_MEMERR	-4

/* reqflag */
#define REQ_NODATA	0x18
#define REQ_DATAOUT	0x10
#define REQ_DATAIN	0x08

#ifdef __cplusplus
extern "C" {
#endif

extern int OpenAspi(void);
extern void CloseAspi(void);
extern int InitializeDrive(DRIVE *drive, int bufsize, int cdblog_size);
extern void FreeDrive(DRIVE *drive);
extern int SetAspiSetting(DRIVE *drive, int *ha, int *tg, DWORD *timeout);
extern void GetAspiSetting(DRIVE *drive, int *ha, int *tg, DWORD *timeout);
extern int SendCmd(DRIVE *drive, BYTE *cdb, DWORD buflen, BYTE reqflag);
extern int GetHostAdapterCount(void);
extern int GetMaxTarget(void);
extern BOOL CheckDiscDevice(DRIVE *drive);
extern BOOL UsingSPTI();


#ifdef __cplusplus
}
#endif


#endif /* !__WINASPI_H__ */
