/* ~Օʉ
 * Copyright (C) 2004 Kagetani Hideto
 */
#include "stdafx.h"
#include "ui.h"
#include "ThemeMessageDlg.h"
#include "EnbanFukusya.h"

static BOOL g_bAbort=FALSE;
static HWND g_hWnd=NULL;

static void UIFlushMessage()
{
	MSG msg;
	while( PeekMessage( &msg, NULL, 0, 0, PM_REMOVE ) != 0 ){
		TranslateMessage( &msg );
		DispatchMessage( &msg );
	}
}

void UISetHWND(HWND hWnd)
{
	g_hWnd = hWnd;
}

BOOL UICheckAbort()
{
	UIFlushMessage();
	return g_bAbort;
}

void UISetAbort()
{
	g_bAbort=TRUE;
}

void UIClearAbort()
{
	g_bAbort=FALSE;
}


int UIDispMessage(const char *message, int type)
{
	CThemeSet *pThemeClass = ((CEnbanFukusyaApp *)AfxGetApp())->GetThemeClass();
	CThemeMessageDlg *pDlg;
	UINT nFlags=0;
	int ret;

	switch(type){
	case UIDMT_ERROR:
		nFlags = MB_ICONSTOP|MB_OK;
		break;
	case UIDMT_QUESTION:
		nFlags = MB_ICONQUESTION|MB_YESNO;
		break;
	default:
		nFlags = MB_OK;
	}
	pDlg = new CThemeMessageDlg;
	pDlg->SetTheme(pThemeClass);
	ret = pDlg->Disp(message, NULL, nFlags);

	delete pDlg;

	return (ret==IDOK||ret==IDYES) ? UIDMRET_OK : UIDMRET_CANCEL;
}

void UIMeter1Initialize(const char *message)
{
	::SendMessage(g_hWnd, WM_USER_UICTL, UICTL_METER1INIT, (LPARAM)message);
}

void UIMeter2Initialize(const char *message)
{
	::SendMessage(g_hWnd, WM_USER_UICTL, UICTL_METER2INIT, (LPARAM)message);
}

void UIMeter1Update(int percentage)
{
	::SendMessage(g_hWnd, WM_USER_UICTL, UICTL_METER1SETPOS, (LPARAM)percentage);
}

void UIMeter2Update(int percentage)
{
	::SendMessage(g_hWnd, WM_USER_UICTL, UICTL_METER2SETPOS, (LPARAM)percentage);
}

void UIDispInfo(const char *message)
{
	::SendMessage(g_hWnd, WM_USER_UICTL, UICTL_DISPINFO, (LPARAM)message);
}


int UISetting(OPTIONS *option)
{
	return ::SendMessage(g_hWnd, WM_USER_UICTL, UICTL_SETTING, (LPARAM)option);
}

int UIFileDialog(BOOL bOpen, char *filename, int size, const char *suffix)
{
	CString csFilter;
	if(suffix != NULL){
		csFilter.Format("%s files (*.%s)|*.%s|All Files (*.*)|*.*||", suffix, suffix, suffix);
	}
	else{
		csFilter = "All Files (*.*)|*.*||";
	}
	CFileDialog dlg(bOpen, suffix, filename, OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT,
					csFilter, NULL);
	if(dlg.DoModal()==IDOK){
		CString csFullPath = dlg.GetPathName();
		strncpy(filename, (LPCTSTR)csFullPath, size);
		filename[size-1] = '\0';
		return UIDMRET_OK;
	}
	return UIDMRET_CANCEL;				
}

