/* ~Օʉ
 * Copyright (C) 2004 Kagetani Hideto
 */

#if !defined(WIN32)
# include <stdlib.h>
# include <string.h>
#endif

#include "drive.h"
#include "cmdlog.h"
#include "cmd.h"

int SendCmd(CMDDRIVE *drive, BYTE *cdb, DWORD buflen, BYTE reqflag)
{
  int ret;

  if(drive->cmd_type == CMDDRVCTYPE_UNKNOWN){
	drive->cmd_type = CMDDRVCTYPE_CHECKING;
	CheckAtapi(drive);
  }

  drive->cmdcode = cdb[0];
  if(drive->type == CMDDRVTYPE_DRIVE){
	ret = SendAspiCmd(&drive->u.drive, cdb, drive->data_buf, buflen,
					  drive->sense_data, sizeof(drive->sense_data), reqflag);
  }
  else if(drive->type == CMDDRVTYPE_NET){
	ret = SendNetCmd(&drive->u.net, cdb, drive->data_buf, buflen,
					 drive->sense_data, sizeof(drive->sense_data), reqflag);
  }
  else{
	return RET_NG;
  }
  CmdLog(drive, cdb, buflen, reqflag, ret);

  return ret;
}

int SendCmdLongRead(CMDDRIVE *drive, BYTE *cdb, DWORD buflen, BYTE reqflag,
					DWORD total_blocks)
{
  int ret;

  if(drive->cmd_type == CMDDRVCTYPE_UNKNOWN){
	drive->cmd_type = CMDDRVCTYPE_CHECKING;
	CheckAtapi(drive);
  }

  if(drive->type == CMDDRVTYPE_NET){
	ret = SendNetCmdLongRead(&drive->u.net, cdb, drive->data_buf, buflen,
							 drive->sense_data, sizeof(drive->sense_data),
							 reqflag, total_blocks);
  }
  else{
	return RET_NG;
  }

  CmdLog(drive, cdb, buflen, reqflag, ret);
	
  return ret;
}

int InitializeCmdDrive(CMDDRIVE *drive, int bufsize, int cmdlog_size, int type)
{
  int ret;

  if(type != CMDDRVTYPE_DRIVE && type != CMDDRVTYPE_NET &&
	 type != CMDDRVTYPE_IMAGE && type != CMDDRVTYPE_ISO){
	return RET_NG;
  }

  FreeCmdDrive(drive);
  drive->cmd_type = CMDDRVCTYPE_UNKNOWN;

  if(CmdLogInit(drive, cmdlog_size)!=RET_OK){
	return RET_NG;
  }

  if(bufsize>0){
	drive->data_buf = (BYTE *)malloc(bufsize);
	if(drive->data_buf==NULL){
	  return RET_NG;
	}
	drive->bufsize = bufsize;
	drive->own_alloc = TRUE;
  }

  drive->type = type;
  if(type == CMDDRVTYPE_DRIVE){
	ret = InitializeDrive(&drive->u.drive);
  }
  else if(type == CMDDRVTYPE_NET){
	ret = InitializeSOCKCB(&drive->u.net);
  }
  else if(type == CMDDRVTYPE_IMAGE){
	ret = InitializeImage(&drive->u.image);
  }
  else /*if(type == CMDDRVTYPE_ISO)*/{
	ret = InitializeImage(&drive->u.image);
  }
  if(ret != RET_OK){
	if(drive->own_alloc){
	  free(drive->data_buf);
	  drive->data_buf=NULL;
	}
	free(drive->cmdlog);
	drive->cmdlog=NULL;
	return ret;
  }

  return RET_OK;
}

void FreeCmdDrive(CMDDRIVE *drive)
{
  CmdLogFree(drive);
  if(drive->data_buf!=NULL){
	if(drive->own_alloc){
	  free(drive->data_buf);
	}
	drive->data_buf=NULL;
  }

  if(drive->type == CMDDRVTYPE_DRIVE){
	FreeDrive(&drive->u.drive);
  }
  else if(drive->type == CMDDRVTYPE_NET){
	FreeSOCKCB(&drive->u.net);
  }
  else if(drive->type == CMDDRVTYPE_IMAGE){
	FreeImage(&drive->u.image);
  }
  else if(drive->type == CMDDRVTYPE_ISO){
	FreeImage(&drive->u.image);
  }
}

void CheckAtapi(CMDDRIVE *drive)
{
  BYTE cdb[12];
  BYTE buf[12];
  BYTE *keep;
  int ret;

  keep = drive->data_buf;
  drive->data_buf = buf;

  memset(cdb, 0, sizeof(cdb));
  cdb[0] = CMD_MODE_SENSE10;
  cdb[2] = 0x2a;
  cdb[8] = 12;
  ret = SendCmd(drive, cdb, 12, REQ_DATAIN);
  if(ret!=RET_OK){
	drive->cmd_type = CMDDRVCTYPE_SCSI;
  }
  else{
	drive->cmd_type = (drive->data_buf[8]==0x2a ? CMDDRVCTYPE_ATAPI:CMDDRVCTYPE_SCSI);
  }

  drive->data_buf = keep;
}

int SetDriveAspiSetting(CMDDRIVE *drive, int *ha, int *tg, DWORD *timeout)
{
  drive->cmd_type = CMDDRVCTYPE_UNKNOWN;
  return SetAspiSetting(&drive->u.drive, ha, tg, timeout);
}

void SetDriveBuffer(CMDDRIVE *drive, char *data_buf, int bufsize)
{
  drive->data_buf = data_buf;
  drive->bufsize = bufsize;
}

