/* ~Օʉ
 * Copyright (C) 2004 Kagetani Hideto
 */
#include <string.h>
#if !defined(WIN32)
# include <stdlib.h>
#endif
#include "image.h"
#include "ui.h"

static int OpenImageFile(IMAGEFILE *image, BOOL reader);
static int OpenNextImageFile(IMAGEFILE *image, BOOL reader);
static int CloseImageFile(IMAGEFILE *image);

#define IMGFILEMAXSIZE	0x40000000	/* 1giga-bytes */


static int OpenImageFile(IMAGEFILE *image, BOOL reader)
{
	char filename[_MAX_PATH];

	CloseImageFile(image);
	if(strlen(image->filename)+2+1 >= sizeof(filename) ||
			image->fileindex>=10 || image->fileindex<0){
		UIDispMessage("C[Wt@C̃I[vɎs܂B", UIDMT_ERROR);
		return RET_NG;
	}
	strcpy(filename, image->filename);
	if(image->fileindex>0)
		sprintf(filename+strlen(filename), ".%d", image->fileindex);

#ifdef WIN32
	image->fp = fopen(filename, reader ? "rb" : "wb");
#else
	image->fp = fopen(filename, reader ? "r" : "w");
#endif
	if(image->fp==NULL){
		UIDispMessage("C[W@C̃I[vɎs܂B", UIDMT_ERROR);
		return RET_NG;
	}
	image->bytecount = 0;

	return RET_OK;
}

static int OpenNextImageFile(IMAGEFILE *image, BOOL reader)
{
	image->fileindex++;
	return OpenImageFile(image, reader);
}

int ReadImageFile(IMAGEFILE *image, void *buf, DWORD size)
{
	int ret;
	BYTE *bufp = (BYTE *)buf;

	if(size > IMGFILEMAXSIZE-image->bytecount){
		fread(bufp, 1, (IMGFILEMAXSIZE-image->bytecount), image->fp);
		bufp += (IMGFILEMAXSIZE-image->bytecount);
		size -= (IMGFILEMAXSIZE-image->bytecount);
		ret = OpenNextImageFile(image, TRUE);
		if(ret!=RET_OK)
			return ret;
	}
	fread(bufp, 1, size, image->fp);
	image->bytecount += size;

	return RET_OK;
}

int WriteImageFile(IMAGEFILE *image, void *buf, DWORD size)
{
	int ret;
	BYTE *bufp = (BYTE *)buf;

	if(size > IMGFILEMAXSIZE-image->bytecount){
		fwrite(bufp, 1, (IMGFILEMAXSIZE-image->bytecount), image->fp);
		bufp += (IMGFILEMAXSIZE-image->bytecount);
		size -= (IMGFILEMAXSIZE-image->bytecount);
		ret = OpenNextImageFile(image, FALSE);
		if(ret!=RET_OK)
			return ret;
	}
	fwrite(bufp, 1, size, image->fp);
	image->bytecount += size;

	return RET_OK;
}


void RemoveImageFile(const char *basefilename)
{
	char *filename;
	int i;

	remove(basefilename);
	filename = malloc(strlen(basefilename)+2+1);
	for(i=1; i<=9; i++){
		sprintf(filename, "%s.%d", basefilename, i);
		remove(filename);
	}
	free(filename);
}


static int CloseImageFile(IMAGEFILE *image)
{
	if(image->fp!=NULL){
		fclose(image->fp);
		image->fp = NULL;
		image->bytecount = 0;
	}
	return RET_OK;
}


int InitializeImage(IMAGEFILE *image)
{
  memset(image, 0, sizeof(IMAGEFILE));
  return RET_OK;
}

void FreeImage(IMAGEFILE *image)
{
  CloseImageFile(image);
  if(image->filename != NULL){
	free(image->filename);
	image->filename = NULL;
  }
  image->fileindex = 0;
  image->bytecount = 0;
}

int OpenImage(IMAGEFILE *image, const char *filename, BOOL reader)
{
  int ret;

  if(filename == NULL){
	return RET_NG;
  }
  image->filename = strdup(filename);
  image->fileindex = 0;
  image->fp = NULL;
  ret = OpenImageFile(image, reader);
  if(ret != RET_OK){
	return ret;
  }

  return RET_OK;
}

