/* ʣ̲
 * Copyright (c) 2004 Kagetani Hideto
 */
#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "cmd.h"
#include "netdlg.h"
#include "ok.xpm"
#include "ng.xpm"
#include "common.h"

#define DEFAULT_PORTNUMBER "11877"

static int g_RetCode;
static BOOL g_Done = FALSE;
static GtkWidget *g_labelAddress = NULL;
static GtkWidget *g_entryAddress = NULL;
static GtkWidget *g_labelPort = NULL;
static GtkWidget *g_entryPort = NULL;

static void on_ok_clicked(GtkWidget *widget, gpointer user_data)
{
  g_RetCode = NDR_OK;
  g_Done = TRUE;
}

static void on_cancel_clicked(GtkWidget *widget, gpointer user_data)
{
  if(g_RetCode==NDR_PENDING){
	g_RetCode = NDR_CANCEL;
	g_Done = TRUE;
  }
}


static GtkWidget *
create_net_dialog(void)
{
  GtkWidget *netdlg;
  GtkWidget *dialog_vbox1;
  GtkWidget *table1;
  GtkWidget *label_address;
  GtkWidget *label_port;
  GtkWidget *entry_address;
  GtkWidget *entry_port;
  GtkWidget *dialog_action_area1;
  GtkWidget *hbox2;
  GtkWidget *button_ok;
  GtkWidget *button_cancel;

  netdlg = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (netdlg), "netdlg", netdlg);
  gtk_window_set_title (GTK_WINDOW (netdlg), "netdlg");
  gtk_window_set_policy (GTK_WINDOW (netdlg), TRUE, TRUE, FALSE);

  dialog_vbox1 = GTK_DIALOG (netdlg)->vbox;
  gtk_object_set_data (GTK_OBJECT (netdlg), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  table1 = gtk_table_new (2, 2, FALSE);
  gtk_widget_ref (table1);
  gtk_object_set_data_full (GTK_OBJECT (netdlg), "table1", table1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), table1, TRUE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (table1), 10);
  gtk_table_set_row_spacings (GTK_TABLE (table1), 5);
  gtk_table_set_col_spacings (GTK_TABLE (table1), 5);

  label_address = gtk_label_new ("³襢ɥ쥹");
  gtk_widget_ref (label_address);
  gtk_object_set_data_full (GTK_OBJECT (netdlg), "label_address", label_address,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_address);
  gtk_table_attach (GTK_TABLE (table1), label_address, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_address), 0, 0.5);

  label_port = gtk_label_new ("ݡֹ");
  gtk_widget_ref (label_port);
  gtk_object_set_data_full (GTK_OBJECT (netdlg), "label_port", label_port,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_port);
  gtk_table_attach (GTK_TABLE (table1), label_port, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_port), 0, 0.5);

	  /* ³襢ɥ쥹 */
  entry_address = gtk_entry_new ();
  gtk_widget_ref (entry_address);
  gtk_object_set_data_full (GTK_OBJECT (netdlg), "entry_address", entry_address,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_address);
  gtk_table_attach (GTK_TABLE (table1), entry_address, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
	  /* ݡֹ */
  entry_port = gtk_entry_new ();
  gtk_widget_ref (entry_port);
  gtk_object_set_data_full (GTK_OBJECT (netdlg), "entry_port", entry_port,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_port);
  gtk_table_attach (GTK_TABLE (table1), entry_port, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  dialog_action_area1 = GTK_DIALOG (netdlg)->action_area;
  gtk_object_set_data (GTK_OBJECT (netdlg), "dialog_action_area1", dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_container_set_border_width (GTK_CONTAINER (dialog_action_area1), 10);

  hbox2 = gtk_hbox_new (FALSE, 10);
  gtk_widget_ref (hbox2);
  gtk_object_set_data_full (GTK_OBJECT (netdlg), "hbox2", hbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox2);
  gtk_box_pack_end (GTK_BOX (dialog_action_area1), hbox2, TRUE, FALSE, 0);

  button_ok = xpm_button_new(netdlg, ok_xpm, "λ");
  gtk_widget_ref (button_ok);
  gtk_object_set_data_full (GTK_OBJECT (netdlg), "button_ok", button_ok,
                            (GtkDestroyNotify) gtk_widget_unref);
  GTK_WIDGET_SET_FLAGS(button_ok, GTK_CAN_DEFAULT);
  gtk_widget_show (button_ok);
  gtk_box_pack_start (GTK_BOX (hbox2), button_ok, FALSE, FALSE, 0);

  button_cancel = xpm_button_new(netdlg, ng_xpm, "");
  gtk_widget_ref (button_cancel);
  gtk_object_set_data_full (GTK_OBJECT (netdlg), "button_cancel", button_cancel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_cancel);
  gtk_box_pack_start (GTK_BOX (hbox2), button_cancel, FALSE, FALSE, 0);

  gtk_signal_connect (GTK_OBJECT (button_ok), "clicked",
                      GTK_SIGNAL_FUNC (on_ok_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (button_cancel), "clicked",
                      GTK_SIGNAL_FUNC (on_cancel_clicked),
                      NULL);
  gtk_signal_connect(GTK_OBJECT(netdlg), "destroy",
					 GTK_SIGNAL_FUNC(on_cancel_clicked),
					 NULL);

  gtk_widget_grab_default (button_ok);
  
  g_labelAddress = label_address;
  g_entryAddress = entry_address;
  g_labelPort = label_port;
  g_entryPort = entry_port;

  return netdlg;
}


int NetDialog(int bServer, char *remote, int size, int *port_number)
{
  GtkWidget *netdialog;

  g_Done = FALSE;
  g_RetCode = NDR_PENDING;
  
  netdialog = create_net_dialog();
  if(bServer){
	  gtk_widget_set_sensitive(g_labelAddress, FALSE);
	  gtk_widget_set_sensitive(g_entryAddress, FALSE);
  }
  gtk_entry_set_text(GTK_ENTRY(g_entryPort), DEFAULT_PORTNUMBER);
  gtk_widget_show(netdialog);
  
  while(!g_Done){
    gtk_main_iteration();
  }
  
  if(GTK_IS_WIDGET(netdialog)){
	if(bServer==FALSE){
	  strncpy(remote, gtk_entry_get_text(GTK_ENTRY(g_entryAddress)), size);
	}
	*port_number = atoi(gtk_entry_get_text(GTK_ENTRY(g_entryPort)));
	gtk_widget_destroy(netdialog);
  }
  

  return g_RetCode;
}
